var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments)).next());
    });
};
const Vue = require("vue");
const lodash_1 = require("lodash");
const api = require("./api");
const util_1 = require("@radic/util");
const bag = util_1.Storage.hasBag('codex.phpdoc') ? util_1.Storage.getBag('codex.phpdoc') : util_1.Storage.createBag('codex.phpdoc', util_1.StorageProvider.LOCAL);
const emit = Vue.codex.eventHub.$emit;
exports.types = {
    SET_PROJECT: 'phpdoc/SET_PROJECT',
    UPDATE_TREE: 'phpdoc/UPDATE_TREE',
    SET_FILE: 'phpdoc/SET_FILE',
    SET_LOADING: 'phpdoc/SET_LOADING',
    UPDATE_ENTITIES: 'phpdoc/UPDATE_ENTITIES',
    UPDATE_METHODS_SETTINGS: 'phpdoc/UPDATE_METHODS_SETTINGS',
    UPDATE_PROPERTIES_SETTINGS: 'phpdoc/UPDATE_PROPERTIES_SETTINGS',
};
function getSettings() {
    return {
        show: {
            inherited: false,
            public: true,
            protected: true,
            private: true
        },
        sort: {
            by: '',
            dir: 'asc'
        },
        view: ''
    };
}
let state = {
    project: '',
    ref: '',
    fullName: '',
    tree: undefined,
    entities: [],
    file: undefined,
    loading: {
        tree: true,
        content: true
    },
    settings: {
        methods: bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings(),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings(),
    }
};
exports.module = {
    state,
    mutations: {
        [exports.types.SET_PROJECT](state, project) {
            state.project = project.name;
            state.ref = project.ref;
            emit(exports.types.SET_PROJECT);
        },
        [exports.types.SET_LOADING](state, loading) {
            if (typeof loading.tree === 'boolean')
                state.loading.tree = loading.tree;
            if (typeof loading.content === 'boolean')
                state.loading.content = loading.content;
            emit(exports.types.SET_LOADING);
        },
        [exports.types.UPDATE_ENTITIES](state, entities) {
            state.entities = entities;
            emit(exports.types.UPDATE_ENTITIES);
        },
        [exports.types.UPDATE_TREE](state, tree) {
            state.tree = tree;
            emit(exports.types.UPDATE_TREE);
        },
        [exports.types.SET_FILE](state, file) {
            state.file = file;
            state.fullName = file.entity.full_name;
            emit(exports.types.SET_FILE);
        },
        [exports.types.UPDATE_METHODS_SETTINGS](state, settings) {
            state.settings.methods = lodash_1.merge({}, state.settings.methods, settings);
            bag.set('settings.methods', state.settings.methods, { json: true });
            emit(exports.types.UPDATE_METHODS_SETTINGS);
        },
        [exports.types.UPDATE_PROPERTIES_SETTINGS](state, settings) {
            state.settings.properties = lodash_1.merge({}, state.settings.properties, settings);
            bag.set('settings.properties', state.settings.properties, { json: true });
            emit(exports.types.UPDATE_PROPERTIES_SETTINGS);
        },
    },
    actions: {
        updatePhpdocEntities({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                dispatch('setPhpdocTreeLoading', true);
                api.getEntities(state.project, state.ref, { tree: true }).then(tree => {
                    commit(exports.types.UPDATE_TREE, tree);
                });
                return yield api.getEntities(state.project, state.ref).then(entities => {
                    commit(exports.types.UPDATE_ENTITIES, entities);
                    dispatch('setPhpdocTreeLoading', false);
                });
            });
        },
        setPhpdocFile({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                dispatch('setPhpdocContentLoading', true);
                if (state.fullName === payload) {
                    return;
                }
                return yield api.getEntity(state.project, state.ref, payload).then(file => {
                    commit(exports.types.SET_FILE, file);
                    dispatch('setPhpdocContentLoading', false);
                });
            });
        },
        updatePhpdoc({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                if ((payload.project && payload.project !== state.project) || (payload.ref && payload.ref !== state.ref)) {
                    commit(exports.types.SET_PROJECT, { name: payload.project, ref: payload.ref });
                    if (!payload.entity) {
                        yield dispatch('updatePhpdocEntities');
                        payload.entity = state.entities[0].full_name;
                    }
                    else {
                        dispatch('updatePhpdocEntities');
                    }
                }
                if (payload.entity && state.fullName !== payload.entity) {
                    return yield dispatch('setPhpdocFile', payload.entity);
                }
            });
        },
        updatePhpdocSettings({ state, commit, dispatch }, payload = undefined) {
            let type = payload.type === 'methods' ? exports.types.UPDATE_METHODS_SETTINGS : exports.types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, payload.settings);
        },
        resetPhpdocSettings({ state, commit, dispatch }, payload = undefined) {
            if (payload && payload === 'methods') {
                commit(exports.types.UPDATE_METHODS_SETTINGS, getSettings());
            }
            else if (payload && payload === 'properties') {
                commit(exports.types.UPDATE_PROPERTIES_SETTINGS, getSettings());
            }
            else {
            }
            let type = payload.type === 'methods' ? exports.types.UPDATE_METHODS_SETTINGS : exports.types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, getSettings());
            commit(exports.types.UPDATE_PROPERTIES_SETTINGS, getSettings());
        },
        setPhpdocTreeLoading({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.SET_LOADING, { tree: payload });
        },
        setPhpdocContentLoading({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.SET_LOADING, { content: payload });
        }
    },
    getters: {
        project: state => state.project,
        ref: state => state.ref,
        fullName: state => state.fullName,
        tree: state => state.tree,
        entities: state => state.entities,
        file: state => state.file,
        settings: state => state.settings,
        loading: state => state.loading,
    }
};
//# sourceMappingURL=store.js.map