var fs = require('fs')
var path = require('path')
function template(filePath) {
    filePath = path.resolve(filePath.toString().trim());

    if ( ! fs.existsSync(filePath) )        return ''

    let content = fs.readFileSync(filePath, 'utf8'),
        exp     = /\{#(.*)#\}/g,
        matches = [],
        myArr;

    while ((myArr = exp.exec(content)) !== null) {
        matches.push(myArr);
    }

    matches.forEach((match) => {
        let replace = template(match[1], 'utf8');
        content = content.replace(match[0], replace);
    })

    return content;
}