var path = require('path');
var config = require('../config');
var ExtractTextPlugin = require('extract-text-webpack-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');
var _ = require('lodash');
var fs = require('fs');
const GenerateAssetPlugin = require('generate-asset-webpack-plugin');
const sass = require('node-sass');
var isProduction = process.env.NODE_ENV === 'production';
exports.loadEnv = data => {
    Object.keys(data).forEach(key => {
        process.env[key] = data[key];
    });
};
exports.html = function (src, dest, options) {
    let o = _.merge({
        title: 'Codex',
        filename: dest,
        template: src,
        inject: false,
        chunksSortMode: 'dependency'
    }, options || {});
    return new HtmlWebpackPlugin(o);
};
exports.htmlScripts = function () {
    return {
        js: {},
        chunks: {}
    };
};
exports.sassRender = function (src, dest) {
    return new GenerateAssetPlugin({
        filename: exports.assetsPath(dest),
        fn: (compilation, cb) => {
            process.stdout.write('doing: ' + src + ' \n');
            sass.render({ file: src, outputStyle: isProduction ? 'compressed' : 'expanded' }, (err, result) => {
                if (err)
                    throw err;
                cb(null, result.css);
            });
        }
    });
};
exports.assetsPath = function (_path) {
    var assetsSubDirectory = isProduction
        ? config.prod.assetsSubDirectory
        : config.dev.assetsSubDirectory;
    return path.posix.join(assetsSubDirectory, _path);
};
exports.cssLoaders = function (options) {
    options = options || {};
    function generateLoaders(loaders) {
        var sourceLoader = loaders.map(function (loader) {
            var extraParamChar;
            if (/\?/.test(loader)) {
                loader = loader.replace(/\?/, '-loader?');
                extraParamChar = '&';
            }
            else {
                loader = loader + '-loader';
                extraParamChar = '?';
            }
            return loader + (options.sourceMap ? extraParamChar + 'sourceMap' : '');
        }).join('!');
        if (options.extract) {
            return ExtractTextPlugin.extract({
                fallbackLoader: 'style-loader',
                loader: sourceLoader
            });
        }
        else {
            return ['vue-style-loader', sourceLoader].join('!');
        }
    }
    return {
        css: generateLoaders(['css']),
        postcss: generateLoaders(['css']),
        less: generateLoaders(['css', 'less']),
        sass: generateLoaders(['css', 'sass?indentedSyntax']),
        scss: generateLoaders(['css', 'sass']),
        stylus: generateLoaders(['css', 'stylus']),
        styl: generateLoaders(['css', 'stylus'])
    };
};
exports.styleLoaders = function (options) {
    var output = [];
    var loaders = exports.cssLoaders(options);
    for (var extension in loaders) {
        var loader = loaders[extension];
        output.push({
            test: new RegExp('\\.' + extension + '$'),
            loader: loader
        });
    }
    return output;
};
//# sourceMappingURL=utils.js.map