'use strict';
const ExtractTextPlugin = require('extract-text-webpack-plugin');
const FaviconsWebpackPlugin = require('favicons-webpack-plugin');
const GenerateAssetPlugin = require('generate-asset-webpack-plugin');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const path = require('path');
const webpack = require('webpack');
const utils = require('./utils');
const projectRoot = path.resolve(__dirname, '../src');
const slideSizes = { sm: 576, md: 768, lg: 922, xl: 1200 };
const isProduction = process.env.NODE_ENV === 'production';
let base = function (type) {
    const config = require('../config');
    return {
        entry: {
            'codex': ['./src/app/codex/index.ts'],
            'codex.page.document': ['./src/app/document.ts'],
            jstree: ['jstree'],
            vendor: ['vue-touch', 'vue-nprogress', 'vue-cookie', 'spin.js', 'velocity-animate', 'tether', 'string'],
        },
        externals: {
            jquery: 'jQuery',
            vue: 'Vue',
            vuex: 'Vuex',
            prismjs: 'Prism',
            lodash: '_',
            '@radic/util': 'radic.util'
        },
        output: {
            path: config[type].assetsRoot,
            publicPath: config[type].assetsPublicPath
        },
        resolve: {
            extensions: ['.js', '.vue', '.css', '.json', '.tsx', '.ts'],
            alias: {
                vue: 'vue/dist/vue',
                package: path.resolve(__dirname, '../package.json'),
                src: path.resolve(__dirname, '../src'),
                assets: path.resolve(__dirname, '../src/assets'),
                components: path.resolve(__dirname, '../src/components'),
                mixins: path.resolve(__dirname, '../src/app/codex/mixins'),
                codex: path.resolve(__dirname, '../src/app/codex'),
                phpdoc: path.resolve(__dirname, '../src/app/phpdoc'),
            }
        },
        module: {
            loaders: [
                {
                    test: /\.vue$/,
                    loader: 'vue-loader'
                },
                { test: /\.json$/, loader: 'json-loader' },
                {
                    test: /\.pug$/,
                    loader: 'pug-loader',
                    query: {
                        pretty: true,
                        globals: {
                            codex_type: type,
                            codex_config: {
                                config: config[type],
                            },
                        }
                    }
                },
                {
                    test: /\.ts$/,
                    loader: 'awesome-typescript-loader',
                    exclude: /node_modules/,
                    query: {}
                },
                {
                    test: /\.js$/,
                    loader: ['babel-loader'],
                    include: [projectRoot, 'node_modules/vue-materials/src'],
                    exclude: [/node_modules\/(?!vue-.*)/]
                },
                {
                    test: /\.(png|jpe?g|gif|svg)(\?.*)?$/,
                    exclude: [/slide-\w*?\.(png|jpe?g|gif|svg)(\?.*)?$/],
                    loader: 'url-loader',
                    query: {
                        limit: 10000,
                        name: utils.assetsPath(`img/[name].[ext]`)
                    }
                },
                {
                    test: /slide-\w*?\.(png|jpe?g|gif|svg)(\?.*)?$/,
                    loaders: [
                        {
                            loader: 'url-loader',
                            query: {
                                limit: 10000,
                                name: utils.assetsPath(`img/slides/[name].[ext]`)
                            }
                        },
                        {
                            loader: 'responsive-loader',
                            query: {
                                placeholder: 40,
                                quality: 95,
                                sizes: [slideSizes.sm, slideSizes.md, slideSizes.lg, slideSizes.xl, 2000],
                                name: utils.assetsPath(`img/slides/[name]-[width].`),
                            }
                        }]
                },
                {
                    test: /\.(woff2?|eot|ttf|otf)(\?.*)?$/,
                    loader: 'url-loader',
                    query: {
                        limit: 100000,
                        importLoaders: true,
                        name: utils.assetsPath(`fonts/[name]/[name].[ext]`)
                    }
                }
            ].concat(utils.styleLoaders({
                sourceMap: config[type].cssSourceMap,
                extract: config[type].extractCss
            }))
        },
        plugins: [
            new FaviconsWebpackPlugin({
                logo: 'src/assets/img/logo.png',
                prefix: utils.assetsPath('img/favicons/')
            }),
            new CopyWebpackPlugin([
                { from: 'node_modules/font-awesome/fonts', to: 'assets/fonts' },
                { from: 'node_modules/prismjs', to: 'assets/vendor/prismjs', ignore: ['*.test'] },
                { from: 'node_modules/jquery/dist', to: 'assets/vendor/jquery' },
                { from: 'node_modules/vue-cookie/build/vue-cookie.js', to: 'assets/vendor/vue-cookie.min.js' },
                { from: 'node_modules/vuex/dist', to: 'assets/vendor/vuex' },
                { from: 'node_modules/vue/dist', to: 'assets/vendor/vue' },
                { from: 'node_modules/vue-resource/dist', to: 'assets/vendor/vue-resource' },
                { from: 'node_modules/wowjs/dist', to: 'assets/vendor/wowjs' },
                { from: 'node_modules/jstree/dist', to: 'assets/vendor/jstree' },
                { from: 'node_modules/lodash/lodash.js', to: 'assets/vendor/lodash/lodash.js' },
                { from: 'node_modules/lodash/lodash.min.js', to: 'assets/vendor/lodash/lodash.min.js' },
                { from: 'node_modules/@radic/util/radic.util.js', to: 'assets/vendor/radic.util/radic.util.js' },
                { from: 'node_modules/@radic/util/radic.util.min.js', to: 'assets/vendor/radic.util/radic.util.min.js' },
                { from: 'node_modules/velocity-animate/velocity.js', to: 'assets/vendor/velocity/velocity.js' },
                { from: 'node_modules/velocity-animate/velocity.min.js', to: 'assets/vendor/velocity/velocity.min.js' },
            ], { debug: 'warning' }),
            new webpack.ProvidePlugin({
                $: "jquery",
                jQuery: "jquery",
                "window.jQuery": "jquery",
                Hammer: "hammerjs/hammer",
                _: 'lodash',
                S: 'string'
            }),
            new webpack.LoaderOptionsPlugin({
                vue: {
                    loaders: utils.cssLoaders({
                        sourceMap: config[type].cssSourceMap,
                        extract: config[type].extractCss
                    }),
                    postcss: [
                        require('autoprefixer')({
                            browsers: ['last 3 versions']
                        })
                    ]
                }
            }),
            utils.html('src/views/welcome.pug', 'index.html', { codex: { type, config: config[type] } }),
            utils.html('src/views/document.pug', 'document.html', { codex: { type, config: config[type] } }),
            utils.html('src/views/error.pug', 'error.html', { codex: { type, config: config[type] } }),
            utils.html('src/views/phpdoc.pug', 'phpdoc.html', { codex: { type, config: config[type] } }),
        ]
    };
};
module.exports = base;
if (!module.parent) {
    console.log(require('util').inspect(base('dev'), true, 10, true));
}
//# sourceMappingURL=webpack.base.conf.js.map