'use strict';
const path = require('path');
const webpack = require('webpack');
const merge = require('webpack-merge');
const baseWebpackConfig = require('./webpack.base.conf');
const config = require('../config').dev;
const ExtractTextPlugin = require('extract-text-webpack-plugin');
const utils = require('./utils');
const env = process.env.NODE_ENV === 'testing'
    ? require('../config/test.env')
    : config.env;
utils.loadEnv(config.env);
let webpackConfig = {
    module: {
        loaders: utils.styleLoaders({
            sourceMap: false,
            extract: false
        })
    },
    devtool: 'source-map',
    watchOptions: {
        aggregateTimeout: 300,
    },
    output: {
        path: config.assetsRoot,
        publicPath: config.assetsPublicPath,
        filename: utils.assetsPath('js/[name].js'),
        chunkFilename: utils.assetsPath('js/[id].js')
    },
    plugins: [
        new webpack.DefinePlugin({
            'process.env': env
        }),
        new webpack.HotModuleReplacementPlugin(),
        new webpack.optimize.OccurrenceOrderPlugin(),
        new webpack.optimize.CommonsChunkPlugin({
            name: 'vendor',
            minChunks(module, count) {
                return (module.resource
                    && /\.js$/.test(module.resource)
                    && !/jstree/.test(module.resource)
                    && module.resource.indexOf(path.join(__dirname, '../node_modules'))
                        === 0);
            }
        }),
        new webpack.optimize.CommonsChunkPlugin({
            name: 'manifest',
            chunks: ['vendor']
        }),
        new webpack.optimize.CommonsChunkPlugin({
            name: 'jstree',
            chunks: ['jstree'],
            async: true
        }),
        utils.sassRender('src/styles/codex.scss', 'styles/codex.css'),
        utils.sassRender('src/styles/themes/codex-default.scss', 'styles/themes/codex-default.css'),
        utils.sassRender('src/styles/prismjs.scss', 'styles/prismjs.css'),
        utils.sassRender('src/styles/codex.page.welcome.scss', 'styles/codex.page.welcome.css'),
        utils.sassRender('src/styles/codex.page.error.scss', 'styles/codex.page.error.css'),
        utils.sassRender('src/styles/codex.page.phpdoc.scss', 'styles/codex.page.phpdoc.css'),
        utils.sassRender('src/styles/codex.phpdoc.document.scss', 'styles/codex.phpdoc.document.css'),
    ]
};
webpackConfig = merge(baseWebpackConfig('dev'), webpackConfig);
module.exports = webpackConfig;
//# sourceMappingURL=webpack.dev.conf.js.map