'use strict';
const path = require('path');
const webpack = require('webpack');
const merge = require('webpack-merge');
const ExtractTextPlugin = require('extract-text-webpack-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const GenerateAssetPlugin = require('generate-asset-webpack-plugin');
const sass = require('node-sass');
const baseWebpackConfig = require('./webpack.base.conf');
const config = require('../config').prod;
const utils = require('./utils');
const env = process.env.NODE_ENV === 'testing'
    ? require('../config/test.env')
    : config.env;
let webpackConfig = {
    devtool: config.productionSourceMap ? 'source-map' : false,
    output: {
        path: config.assetsRoot,
        publicPath: config.assetsPublicPath,
        filename: utils.assetsPath('js/[name].js'),
        chunkFilename: utils.assetsPath('js/[id].js')
    },
    plugins: [
        new webpack.DefinePlugin({
            'process.env': env
        }),
        new webpack.LoaderOptionsPlugin({
            minimize: true
        }),
        new webpack.optimize.UglifyJsPlugin({
            sourceMap: true,
            compress: {
                warnings: false
            },
            output: {
                comments: false
            },
        }),
        new webpack.optimize.OccurrenceOrderPlugin(),
        new webpack.optimize.CommonsChunkPlugin({
            name: 'vendor',
            minChunks(module, count) {
                return (module.resource &&
                    /\.js$/.test(module.resource) &&
                    module.resource.indexOf(path.join(__dirname, '../node_modules')) === 0);
            }
        }),
        new webpack.optimize.CommonsChunkPlugin({
            name: 'manifest',
            chunks: ['vendor']
        }),
        utils.sassRender('src/styles/codex.scss', 'styles/codex.css'),
        utils.sassRender('src/styles/themes/codex-default.scss', 'styles/themes/codex-default.css'),
        utils.sassRender('src/styles/prismjs.scss', 'styles/prismjs.css'),
        utils.sassRender('src/styles/codex.page.welcome.scss', 'styles/codex.page.welcome.css'),
        utils.sassRender('src/styles/codex.page.error.scss', 'styles/codex.page.error.css'),
        utils.sassRender('src/styles/codex.page.phpdoc.scss', 'styles/codex.page.phpdoc.css'),
        utils.sassRender('src/styles/codex.phpdoc.document.scss', 'styles/codex.phpdoc.document.css'),
        new ExtractTextPlugin(utils.assetsPath('.tmp/[name].css'))
    ]
};
if (config.productionGzip) {
    const CompressionWebpackPlugin = require('compression-webpack-plugin');
    webpackConfig.plugins.push(new CompressionWebpackPlugin({
        asset: '[path].gz[query]',
        algorithm: 'gzip',
        test: new RegExp('\\.(' +
            config.productionGzipExtensions.join('|') +
            ')$'),
        threshold: 10240,
        minRatio: 0.8
    }));
}
module.exports = merge(baseWebpackConfig('prod'), webpackConfig);
//# sourceMappingURL=webpack.prod.conf.js.map