'use strict';
const path = require('path');
const webpack = require('webpack');
const merge = require('webpack-merge');
const baseWebpackConfig = require('./webpack.base.conf');
const config = require('../config').serve;
const ExtractTextPlugin = require('extract-text-webpack-plugin');
const utils = require('./utils');
const env = process.env.NODE_ENV === 'testing'
    ? require('../config/test.env')
    : config.env;
let webpackConfig = {
    module: {
        loaders: utils.styleLoaders({
            sourceMap: config.cssSourceMap,
            extract: false
        })
    },
    devtool: 'source-map',
    watchOptions: {
        aggregateTimeout: 300,
    },
    devServer: {
        host: config.host,
        port: config.port,
        contentBase: config.assetsRoot,
        compress: true,
        historyApiFallback: true,
        watchContentBase: true,
        hot: true,
        inline: true,
        publicPath: `http://${config.host}:${config.port}/`
    },
    output: {
        path: config.assetsRoot,
        publicPath: config.assetsPublicPath,
        filename: utils.assetsPath('js/[name].js'),
        chunkFilename: utils.assetsPath('js/[id].js')
    },
    plugins: [
        new webpack.DefinePlugin({
            'process.env': env
        }),
        new webpack.HotModuleReplacementPlugin(),
        new webpack.optimize.OccurrenceOrderPlugin(),
        new webpack.optimize.CommonsChunkPlugin({
            name: 'vendor',
            minChunks(module, count) {
                return (module.resource &&
                    /\.js$/.test(module.resource) &&
                    module.resource.indexOf(path.join(__dirname, '../node_modules')) === 0);
            }
        }),
        new webpack.optimize.CommonsChunkPlugin({
            name: 'manifest',
            chunks: ['vendor']
        }),
        new ExtractTextPlugin(utils.assetsPath('styles/[name].css'))
    ]
};
webpackConfig = merge(baseWebpackConfig('serve'), webpackConfig);
module.exports = webpackConfig;
//# sourceMappingURL=webpack.serve.conf.js.map