var path = require('path');
module.exports = {
    prod: {
        env: {
            NODE_ENV: '"production"'
        },
        index: path.resolve(__dirname, '../dist/index.html'),
        assetsRoot: path.resolve(__dirname, '../dist'),
        assetsSubDirectory: 'assets',
        assetsPublicPath: '/',
        productionSourceMap: true,
        productionGzip: false,
        productionGzipExtensions: ['js', 'css'],
        cssSourceMap: true,
        extractCss: true
    },
    dev: {
        env: {
            NODE_ENV: '"development"'
        },
        assetsRoot: path.resolve(__dirname, '../dev'),
        assetsSubDirectory: 'assets',
        assetsPublicPath: '/',
        proxyTable: {},
        cssSourceMap: false,
        extractCss: false
    },
    serve: {
        env: {
            NODE_ENV: '"development"'
        },
        port: 3000,
        host: '0.0.0.0',
        assetsRoot: path.resolve(__dirname, '../dev-serve'),
        assetsSubDirectory: 'assets',
        assetsPublicPath: '/',
        proxyTable: {},
        cssSourceMap: false,
        extractCss: false
    }
};
//# sourceMappingURL=index.js.map