const Vue = require('vue');
const components = require('../components/document');
const vue_bulma_collapse_1 = require('vue-bulma-collapse');
Object.keys(components).forEach((key) => Vue.component(key, components[key]));
const vuex_1 = require('vuex');
exports.store = new vuex_1.Store({});
Vue.use(Vue.codex.CodexPlugin, { store: exports.store });
exports.App = Vue.extend({
    store: exports.store,
    components: {
        Collapse: vue_bulma_collapse_1.Collapse,
        CollapseItem: vue_bulma_collapse_1.Item
    },
    mixins: [Vue.codex.mixins.layout, Vue.codex.mixins.resize],
    data() {
        return {
            minHeights: { page: 0, inner: 0, app: 0 },
            sidenavs: {
                opened: '',
                right: true,
                width: 300
            }
        };
    },
    beforeMount() {
        if (this.isBreakpointDown('md')) {
            this.closeSidebar();
        }
    },
    mounted() {
        this.$$ready(() => {
            this.onResize();
            this.$nextTick(() => Vue.codex.loader.stop());
        });
        this.$on('resize', this.onResize);
        this.$events.$on('sidebar:open-sub-menu', this.onResize);
    },
    methods: {} }, ...vuex_1.mapActions([
    'toggleSidebar', 'closeSidebar', 'openSidebar', 'hideSidebar', 'showSidebar'
]), showSidenav(name), {
    this: .sidenavs.opened = name
}, hideSidenav(), {
    this: .sidenavs.opened = ''
}, isSidenav(name), {
    return: this.sidenavs.opened === name
}, sidenavTransition({ el, style, cb }), {
    this: .$$(el).velocity('stop'),
    this: .$$(el).velocity(style, {
        duration: 300,
        queue: false,
        easing: 'easeOutQuad',
        complete: cb
    })
}, onResize(), {
    if(isBreakpointDown = ('md')) { }, return: ,
    let: $page = this.$$(this.$refs.page),
    var: heights = {
        header: this.$refs.header.$$el.outerHeight(true),
        footer: this.$refs.footer.$$el.outerHeight(true),
        viewPort: this.getViewPort().height
    },
    this: .minHeights.page = heights.viewPort - heights.header - heights.footer,
    this: .minHeights.inner = this.minHeights.page - (parseInt($page.css('padding-top')) + parseInt($page.css('padding-bottom')))
});
computed: {
    vuex_1.mapGetters(['sidebar']),
        $sidebarInner();
    {
        return this.$$(this.$refs.sidebar.$el.children[0]);
    }
    $contentInner();
    {
        return this.$$(this.$refs.content.$el.children[0]);
    }
    sidebarInnerHeight();
    {
        return this.$sidebarInner.outerHeight();
    }
    contentInnerHeight();
    {
        return this.$contentInner.outerHeight();
    }
    classes();
    {
        return {
            'sidebar-hidden': this.sidebar.hidden,
            'sidebar-closed': this.sidebar.closed,
        };
    }
}
as;
Vue.ComponentOptions();
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = exports.App;
Vue.codex.App = exports.App;
//# sourceMappingURL=document.js.map