const Vue = require("vue");
const utils_1 = require('./phpdoc/utils');
let codex = window.codex;
if (codex.CodexPhpdocPlugin) {
    Vue.use(codex.CodexPhpdocPlugin);
}
Vue.config.debug = true;
const App = Vue.codex.App.extend({
    name: 'phpdoc',
    data() {
        return {
            minContentHeight: 0,
            phpdocHeight: 0,
            query: undefined,
            hashPath: null,
            navigator: null
        };
    },
    beforeMount() {
        let hashPath = utils_1.HashPathParser.parse(location.hash);
        if (hashPath.isHashPath()) {
            this.query = hashPath.toQuery();
            window.history.replaceState(null, hashPath.toString(), window.location.pathname + hashPath.toString());
        }
        else if (Vue.codex.phpdoc.defaultClass) {
            this.open(Vue.codex.phpdoc.defaultClass);
        }
        window.addEventListener("popstate", (event) => {
            let hashPath = utils_1.HashPathParser.parse(location.hash);
            console.log('popstate', window.location);
            if (hashPath.isHashPath()) {
                this.open(hashPath.toQuery());
            }
        }, false);
    },
    mounted() {
        console.log('phpdoc  APP');
        this.$$ready(() => this.onResizeDocument());
        this.$on('resize', this.onResizeDocument);
        this.$events.$on('phpdoc:type:click', (type) => {
            if (type.isLocal)
                this.open(type.fullName);
        });
        codex.loader.stop();
    },
    methods: {
        onResizeDocument() {
            this.$nextTick(() => {
                let $page = this.$$(this.$refs.page);
                this.phpdocHeight = this.minHeights.inner = 0;
                this.$nextTick(() => {
                    this.phpdocHeight = this.minHeights.inner = $page.outerHeight(true) - parseInt($page.css('padding-top')) - parseInt($page.css('padding-bottom'));
                });
            });
        },
        open(query) {
            this.$events.$emit('phpdoc:open', query);
            this.query = query;
            window.history.pushState(null, query, window.location.pathname + "#!/" + query);
        }
    },
    watch: {},
    computed: {}
});
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = App;
codex.App = App;
console.log('sc phpdoc');
//# sourceMappingURL=phpdoc.js.map