class FullyQualifiedNameParser {
    constructor(name) {
        this.name = '';
        this.entityName = '';
        this.methodName = '';
        this.propertyName = '';
        this.type = 'entity';
        let exp = /^(.*?)(?:$|\:{2}(.*))$/gm;
        let matches = [];
        let myArr;
        while ((myArr = exp.exec(name)) !== null) {
            matches.push(myArr);
        }
        if (matches.length !== 1 || matches[0].length !== 3)
            throw new Error('not valid fqn');
        let m = matches[0];
        this.name = name;
        this.type = 'entity';
        if (m[2] !== undefined) {
            this.type = m[2].indexOf('()') !== -1 ? 'method' : 'property';
        }
        this.entityName = m[1];
        this[this.type + 'Name'] = this.type === 'method' ? m[2].replace('()', '') : m[2];
    }
    is(type) { return this.type === type; }
    isEntity() { return this.is(FullyQualifiedNameParser.Entity); }
    isMethod() { return this.is(FullyQualifiedNameParser.Method); }
    isProperty() { return this.is(FullyQualifiedNameParser.Property); }
    toString() { return this.name; }
    requestApi() {
        if (this.isEntity()) {
            return Vue.codex.phpdoc.getEntity(this.entityName);
        }
        else if (this.isMethod()) {
            return Vue.codex.phpdoc.getMethod(this.entityName, this.methodName);
        }
        else if (this.isProperty()) {
            return Vue.codex.phpdoc.getProperty(this.entityName, this.propertyName);
        }
    }
}
FullyQualifiedNameParser.Entity = 'entity';
FullyQualifiedNameParser.Method = 'method';
FullyQualifiedNameParser.Property = 'property';
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = FullyQualifiedNameParser;
//# sourceMappingURL=FullyQualifiedNameParser.js.map