var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator.throw(value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments)).next());
    });
};
const Vue = require("vue");
const api = Vue.codex.api;
function defaultOptions(defaults = {}, params = {}) {
    let project = Vue.codex.project, ref = Vue.codex.ref;
    return { params: _.merge({ project, ref }, defaults, params) };
}
function getEntities(params = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            api
                .get('phpdoc/entities', defaultOptions({ tree: false, full: false }, params))
                .catch(err => reject(err))
                .then((res) => resolve(res.data));
        });
    });
}
exports.getEntities = getEntities;
function getEntity(entity, params = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        if (entity === undefined) {
            console.trace('entity undefined');
            throw new Error('entity undefined');
        }
        return new Promise((resolve, reject) => {
            api
                .get('phpdoc/entity', defaultOptions({ entity }, params))
                .catch(err => reject(err))
                .then((res) => resolve(res.data));
        });
    });
}
exports.getEntity = getEntity;
function getMethod(entity, method, params = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            api
                .get('phpdoc/method', defaultOptions({ entity, method }, params))
                .catch(err => reject(err))
                .then((res) => resolve(res.data));
        });
    });
}
exports.getMethod = getMethod;
function getProperty(entity, property, params = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            api
                .get('phpdoc/method', defaultOptions({ entity, property }, params))
                .catch(err => reject(err))
                .then((res) => resolve(res.data));
        });
    });
}
exports.getProperty = getProperty;
//# sourceMappingURL=api.js.map