function removeStartSlash(value) {
    if (value === undefined) {
        return;
    }
    var matches = value.match(/^\\(.*)/);
    if (matches !== null && matches.length === 2) {
        return matches[1];
    }
    return value;
}
exports.removeStartSlash = removeStartSlash;
;
function Type(name) {
    this.type = name;
    this.name = name;
    this.fullName = name;
    this.entities = Vue.codex.store.getters.entities;
    this.isEntity = this.name[0] === '\\';
    this.isPrimitive = this.isEntity === false;
    this.isLocal = false;
    this.isExternal = false;
    this.entity = {};
    let classes = [];
    if (this.isEntity) {
        this.fullName = removeStartSlash(this.name);
        this.name = _.last(this.type.split('\\'));
        this.isExternal = true;
        if (this.entities) {
            this.entity = _.find(this.entities, { full_name: this.type });
            this.isLocal = this.entity !== undefined;
            this.isExternal = !this.isLocal;
        }
        classes.push('phpdoc-type-' + (this.isLocal ? this.entity.type : 'external'));
    }
    else {
        classes.push('phpdoc-type-simple');
        classes.push('phpdoc-type-simple-' + this.type);
    }
    this.cssClass = classes.join(' ');
}
exports.Type = Type;
function parseFullName(fullName) {
    return parseRef(fullName);
}
exports.parseFullName = parseFullName;
function parseRef(ref) {
    return Query.from(ref);
}
exports.parseRef = parseRef;
class Query {
    constructor(query) {
        this.query = query;
        this.isEntity = false;
        this.isMethod = false;
        this.isProperty = false;
        this.entityName = null;
        this.methodName = null;
        this.propertyName = null;
        if (query.indexOf('::') !== -1) {
            this.entityName = query.split('::')[0];
            if (query.indexOf('()') !== -1) {
                this.methodName = query.split('::')[1].replace('()', '');
                this.isMethod = true;
            }
            else {
                this.propertyName = query.split('::')[1];
                this.isProperty = true;
            }
        }
        else {
            this.entityName = query;
            this.isEntity = true;
        }
        if (this.entityName[0] !== '\\') {
            this.entityName = '\\' + this.entityName;
        }
    }
    static from(query) {
        return new Query(query);
    }
    toString() {
        return this.query;
    }
}
exports.Query = Query;
class Tags {
    constructor(tags = []) {
        this.tags = tags;
    }
    get length() { return this.tags.length; }
    has(name) { return this.get(name) !== undefined; }
    get(name) { return _.find(this.tags, { name }); }
    where(k, v) { return _.find(this.tags, { [k]: v }); }
    exclude(vals, key = 'name') {
        return new Tags(_.filter(this.tags, (tag) => vals.indexOf(tag[key]) === -1));
    }
    toArray() { return this.tags; }
    isEmpty() { return this.tags.length === 0; }
}
exports.Tags = Tags;
//# sourceMappingURL=general.js.map