require('assets/img/ss-codex-phpdoc.png');
require('assets/img/ss-codex-document.png');
require('assets/img/issue-addon-scan.png');
require('assets/img/issue-speed-improvements.png');
require('assets/img/issue-toolbar-styles.png');
require('assets/img/slides/slide-html.png');
require('assets/img/slides/slide-typewriter.jpg');
require('assets/img/features/fa-puzzle-piece-140x140-37474f.png');
require('assets/img/features/transgender-alt-140x140-263238.png');
require('assets/img/features/responsive.png');
const vuex_1 = require('vuex');
const Vue = require("vue");
const components = require('../components/welcome');
let codex = window.codex;
Object.keys(components).forEach(key => Vue.component(key, components[key]));
const wow = new WOW({
    mobile: false,
});
wow.init();
const store = new vuex_1.Store({});
Vue.use(codex.CodexPlugin, { store });
Vue.codex.extend({ wow, store });
const App = Vue.extend({
    store,
    mixins: [Vue.codex.mixins.layout, Vue.codex.mixins.resize],
    data() {
        return {
            carouselHeight: 9999
        };
    },
    mounted() {
        this.updateHeight();
        this.$on('resize', () => this.updateHeight());
        this.$nextTick(() => {
            this.$$el.css('display', 'block');
        });
        this.$$ready(() => {
            this.$nextTick(() => codex.loader.stop());
            let $header = $(this.$refs.header.$el);
            this.$$('.scrollspy').scrollSpy({
                scrollOffset: $header.outerHeight(true) + 1
            });
        });
    },
    methods: {
        updateHeight() {
            this.carouselHeight = this.getViewPort().height + 1;
        }
    }
});
codex.App = App;
//# sourceMappingURL=welcome.js.map