(function () {
    if (typeof self === 'undefined' || !self.Prism || !self.document) {
        return;
    }
    Prism.hooks.add('complete', function (env) {
        if (!env.code) {
            return;
        }
        var pre = env.element.parentNode;
        var clsReg = /\s*\bcommand-line\b\s*/;
        if (!pre || !/pre/i.test(pre.nodeName) ||
            (!clsReg.test(pre.className) && !clsReg.test(env.element.className))) {
            return;
        }
        if (env.element.querySelector('.command-line-prompt')) {
            return;
        }
        if (clsReg.test(env.element.className)) {
            env.element.className = env.element.className.replace(clsReg, '');
        }
        if (!clsReg.test(pre.className)) {
            pre.className += ' command-line';
        }
        var getAttribute = function (key, defaultValue) {
            return (pre.getAttribute(key) || defaultValue).replace(/"/g, '&quot');
        };
        var lines = new Array(env.code.split('\n').length);
        var promptText = getAttribute('data-prompt', '');
        if (promptText !== '') {
            lines = lines.join('<span data-prompt="' + promptText + '"></span>');
        }
        else {
            var user = getAttribute('data-user', 'user');
            var host = getAttribute('data-host', 'localhost');
            lines = lines.join('<span data-user="' + user + '" data-host="' + host + '"></span>');
        }
        var prompt = document.createElement('span');
        prompt.className = 'command-line-prompt';
        prompt.innerHTML = lines;
        var outputSections = pre.getAttribute('data-output') || '';
        outputSections = outputSections.split(',');
        for (var i = 0; i < outputSections.length; i++) {
            var outputRange = outputSections[i].split('-');
            var outputStart = parseInt(outputRange[0]);
            var outputEnd = outputStart;
            if (outputRange.length === 2) {
                outputEnd = parseInt(outputRange[1]);
            }
            if (!isNaN(outputStart) && !isNaN(outputEnd)) {
                for (var j = outputStart; j <= outputEnd && j <= prompt.children.length; j++) {
                    var node = prompt.children[j - 1];
                    node.removeAttribute('data-user');
                    node.removeAttribute('data-host');
                    node.removeAttribute('data-prompt');
                }
            }
        }
        env.element.innerHTML = prompt.outerHTML + env.element.innerHTML;
    });
}());
//# sourceMappingURL=prism-command-line.js.map