webpackHotUpdate(1,{

/***/ 244:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(_) {

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Q = __webpack_require__(454);
var axios_1 = __webpack_require__(183);
var util_1 = __webpack_require__(86);
var md5_1 = __webpack_require__(40);

var Api = function () {
    function Api() {
        var _this = this;

        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, Api);

        this.errorMessages = {
            500: "The requested resource doesn't exist!",
            502: "Server error, please try again.",
            401: "You aren't authorized to access this resource."
        };
        this.options = {
            apiUrl: '',
            debug: false,
            axios: {}
        };
        this.requests = {};
        _.merge(this.options, options);
        this.cache = util_1.Storage.getOrCreateBag('codex.api.cache', "local");
        if (parseInt(this.cache.getSize('')) >= 8) {
            this.cache.clear();
        }
        this.$http = axios_1.create(options.axios);
        this.$http.interceptors.request.use(function (config) {
            config.url = _this.options.apiUrl + "/" + config.url;
            return config;
        }, this.catchInterceptorError);
        this.$http.interceptors.response.use(function (response) {
            _this.cache.set(response.config.url + _this.getParamsHash(response.config.params), response.data, {
                expires: 600000
            });
            return response;
        }, this.catchInterceptorError);
    }

    _createClass(Api, [{
        key: "getParamsHash",
        value: function getParamsHash(params) {
            if (params === undefined) return '';
            var objectText = Object.keys(params).map(function (key) {
                var val = params[key];
                if (typeof val === 'undefined') {
                    throw new Error('as this is on key ' + key);
                }
                return key + val.toString();
            }).join('');
            return md5_1.default(objectText);
        }
    }, {
        key: "resolveAndDelay",
        value: function resolveAndDelay(deferred, data) {
            setTimeout(function () {
                return deferred.resolve(data);
            }, this.options.debug ? 500 : 0);
        }
    }, {
        key: "apiCall",
        value: function apiCall(path) {
            var _this2 = this;

            var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

            var deferred = Q.defer();
            var requestKey = this.options.apiUrl + "/" + path + this.getParamsHash(options.params);
            var cachedObject = this.cache.get(requestKey, {});
            if (!_.isEmpty(cachedObject)) {
                deferred.resolve(cachedObject);
            } else {
                if (this.requests[requestKey] === undefined) {
                    this.requests[requestKey] = this.$http.get(path, options);
                }
                this.requests[requestKey].then(function (_ref) {
                    var data = _ref.data;

                    delete _this2.requests[requestKey];
                    deferred.resolve(data);
                }).catch(this.catchError);
            }
            return deferred.promise;
        }
    }, {
        key: "spreadData",
        value: function spreadData(result, spreadMembers) {
            var data = {};
            spreadMembers.forEach(function (member, i) {
                data[member] = result[i];
            });
            return data;
        }
    }, {
        key: "get",
        value: function get(path) {
            var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

            return this.apiCall(path, options);
        }
    }, {
        key: "post",
        value: function post(path, options) {
            return this.$http.post(path, options);
        }
    }, {
        key: "all",
        value: function all(path, spreadMembers) {
            var _this3 = this;

            var deferred = Q.defer();
            var apiCalls = path.map(function (p) {
                return _this3.apiCall(p);
            });
            axios.all(apiCalls).then(function (result) {
                return deferred.resolve(_this3.spreadData(result, spreadMembers));
            }).catch(this.catchError);
            return deferred.promise;
        }
    }, {
        key: "catchInterceptorError",
        value: function catchInterceptorError(error) {
            return Promise.reject(error);
        }
    }, {
        key: "catchError",
        value: function catchError(response) {
            var error = {
                code: response.status,
                message: response.message
            };
            var errorMessage = this.errorMessages[response.status];
            if (errorMessage) {
                error = {
                    code: 500,
                    message: errorMessage
                };
            }
            Promise.reject(error);
        }
    }]);

    return Api;
}();

exports.Api = Api;
//# sourceMappingURL=api.js.map
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ }

})
//# sourceMappingURL=1.ef712587d5c739ff6867.hot-update.js.map