webpackHotUpdate(2,{

/***/ 14:
/***/ function(module, exports, __webpack_require__) {

"use strict";


function __export(m) {
    for (var p in m) {
        if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }
}
__export(__webpack_require__(47));
__export(__webpack_require__(46));
var loader_1 = __webpack_require__(48);
exports.Loader = loader_1.default;
var md5_1 = __webpack_require__(40);
exports.md5 = md5_1.default;
//# sourceMappingURL=index.js.map

/***/ },

/***/ 178:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var plugin_1 = __webpack_require__(250);
var Vue = __webpack_require__(2);
Vue.codex.CodexPhpdocPlugin = window['CodexPhpdocPlugin'] = plugin_1.default;
//# sourceMappingURL=index.js.map

/***/ },

/***/ 229:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

var _vuex = __webpack_require__(9);

var _string = __webpack_require__(130);

var _string2 = _interopRequireDefault(_string);

var _mixins = __webpack_require__(32);

var _mixins2 = __webpack_require__(39);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'pd-app',
    mixins: [_mixins.component, _mixins2.resize],
    props: {
        query: String,
        height: Number

    },
    data: function data() {
        return {
            methodName: false,
            methodQuery: false,
            file: false,
            loading: true,

            active: 'methods',
            content: 'method',
            selectedProperty: false,
            selectedMethod: false,
            hasSlimScroll: false,
            slimScrollTimeout: 0
        };
    },
    mounted: function mounted() {
        var _this = this;

        if (this.query) this.handleQuery(this.query);else this.getPhpdocEntities().then(function (entities) {
            return _this.handleQuery(_this.entities[0].full_name);
        });

        this.$$ready(function () {
            return setTimeout(function () {
                _this.loading = false;
                _this.$nextTick(function () {
                    return _this.loadZoneWidths();
                });
            }, 500);
        });
    },

    watch: {
        query: function query(val) {
            this.handleQuery(val);
        }
    },
    computed: {
        entities: function entities() {
            return Vue.codex.phpdoc.entities;
        },
        entity: function entity() {
            return this.file.entity;
        },
        style: function style() {
            var styles = {};
            if (this.height) {
                styles['height'] = this.height + 'px';
            }
            return styles;
        }
    },
    methods: _extends({}, (0, _vuex.mapActions)(['getPhpdocEntities']), {
        handleQuery: function handleQuery(query) {
            var _this2 = this;

            var parsed = this.$phpdoc.parseRef(query);
            return this.getEntity(parsed.entityName).then(function (file) {
                _this2.file = file;
                //
                var method = parsed.isMethod ? parsed.methodName : false;
                if (file.entity.methods.length) {
                    method = file.entity.methods[0].name;
                }
                _this2.setMethod(method);
            });
        },
        setMethod: function setMethod(methodName) {
            this.methodName = methodName;
            if (methodName === false) {
                return this.methodQuery = false;
            }
            methodName = (0, _string2.default)(methodName).ensureRight('()');
            this.methodQuery = this.entity.full_name + '::' + methodName;
        },
        onPropertySelect: function onPropertySelect(propertyName) {
            this.selectedProperty = propertyName;
        },
        onMethodSelect: function onMethodSelect(methodName) {
            this.selectedMethod = methodName;
            this.setMethod(methodName);
        },
        setActive: function setActive(name) {
            this.active = name;
            this.content = name === 'source' ? name : 'method';
            this.$emit('open', name);
            this.$root.$emit('resize');
        },
        isActive: function isActive(name) {
            return this.active === name;
        },
        onTreeSelect: function onTreeSelect(query) {
            this.$root.open(query);
        },
        saveZoneWidths: function saveZoneWidths() {
            var zones = [];
            this.$$el.find('.drag-zone > .item').each(function (i) {
                zones.push($(this).css('width'));
            });
            this.$cookie.set('phpdoc.zoneWidths', zones.join('-'));
            this.$events.$emit('phpdoc:zoneWidths', zones.join('-'));
        },
        loadZoneWidths: function loadZoneWidths() {
            var zoneWidths = this.$cookie.get('phpdoc.zoneWidths');
            if (!zoneWidths) return;

            if (!zoneWidths.toString().length) return;
            var zones = zoneWidths.split('-');
            this.$$el.find('.drag-zone > .item').each(function (i) {
                $(this).css('width', zones[i]);
            });
        },
        showSource: function showSource() {}
    })

};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15)))

/***/ },

/***/ 230:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vuex = __webpack_require__(9);

__webpack_require__(441);

var _mixins = __webpack_require__(32);

exports.default = {
    name: 'pd-entity',
    mixins: [_mixins.fileRefComponent],
    props: {
        maxHeight: { type: Number, default: 0 },
        withProperties: Boolean,
        withMethods: Boolean,
        extended: Boolean
    },
    data: function data() {
        return {
            active: 'methods'
        };
    },
    mounted: function mounted() {},

    watch: {},
    computed: {
        hasExtend: function hasExtend() {
            return this.entity.extends && this.entity.extends.length > 0;
        },
        hasDescription: function hasDescription() {
            return this.entity.description.length > 0;
        }
    },
    methods: {}
}; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/***/ },

/***/ 231:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

var _vuex = __webpack_require__(9);

exports.default = {
    name: 'pd-list-settings-menu',
    props: {
        type: String
    },
    data: function data() {
        return {
            sortMethodsOptions: ['name', 'visibility']
        };
    },
    mounted: function mounted() {},

    methods: _extends({}, (0, _vuex.mapActions)(['updatePhpdocSettings', 'resetPhpdocSettings']), {
        closeMenu: function closeMenu() {
            this.$refs.ctxMenu.close();
        },
        resetSettings: function resetSettings() {
            this.resetPhpdocSettings(this.type);
        }
    }),
    computed: {
        settings: function settings() {
            return this.$store.getters.settings[this.type];
        },

        inherited: {
            get: function get() {
                return this.settings.show.inherited;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { inherited: v } } });
                //                    this.settings.show.inherited = v;
            }
        },
        public: {
            get: function get() {
                return this.settings.show.public;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { public: v } } });
            }
        },
        protected: {
            get: function get() {
                return this.settings ? this.settings.show.protected : false;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { protected: v } } });
            }
        },
        private: {
            get: function get() {
                return this.settings ? this.settings.show.private : false;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { private: v } } });
            }
        },
        sortBy: {
            get: function get() {
                return this.settings ? this.settings.sort.by : '';
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { sort: { by: v } } });
            }
        },
        sortDir: {
            get: function get() {
                return this.settings ? this.settings.sort.dir : 'asc';
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { sort: { dir: v } } });
            }
        }
    }
};

/***/ },

/***/ 232:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

var _vuex = __webpack_require__(9);

var _lodash = __webpack_require__(6);

exports.default = {
    name: 'pd-list-settings',
    props: {
        type: String,
        list: String
    },
    data: function data() {
        return {
            sortMethodsOptions: ['name', 'visibility']
        };
    },
    mounted: function mounted() {},

    methods: _extends({}, (0, _vuex.mapActions)(['updatePhpdocSettings', 'resetPhpdocSettings']), {
        closeFilters: function closeFilters() {
            this.$events.$emit('phpdoc.filters.close');
        },
        getList: function getList() {
            return this.$parent.$refs[this.list];
        },
        resetFilters: function resetFilters() {
            this.resetPhpdocSettings(this.type);
        }
    }),
    computed: {
        $list: function $list() {
            //                return this.$parent.$refs[this.list];
            return this.$helpers.getRefInParents(this.list, this.$parent);
        },

        settings: {
            get: function get() {
                return this.$store.getters.settings[this.type];
            }
        },
        inherited: {
            get: function get() {
                return this.settings ? this.settings.show.inherited : false;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { inherited: v } } });
                //                    this.settings.show.inherited = v;
            }
        },
        public: {
            get: function get() {
                return this.settings ? this.settings.show.public : false;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { public: v } } });
            }
        },
        protected: {
            get: function get() {
                return this.settings ? this.settings.show.protected : false;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { protected: v } } });
            }
        },
        private: {
            get: function get() {
                return this.settings ? this.settings.show.private : false;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { private: v } } });
            }
        },
        sortBy: {
            get: function get() {
                return this.settings ? this.settings.sort.by : '';
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { sort: { by: v } } });
            }
        },
        sortDir: {
            get: function get() {
                return this.settings ? this.settings.sort.dir : 'asc';
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { sort: { dir: v } } });
            }
        }
    }
};

/***/ },

/***/ 233:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

var _vue = __webpack_require__(2);

var _vue2 = _interopRequireDefault(_vue);

var _vuex = __webpack_require__(9);

var _lodash = __webpack_require__(6);

var _mixins = __webpack_require__(32);

var _mixins2 = __webpack_require__(39);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'pd-method-list',
    mixins: [_mixins.fileRefComponent, _mixins2.scrollable],
    props: {
        itemClass: { type: String, default: 'nav-item' },
        linkClass: { type: String, default: 'nav-link' },
        exclude: { type: Array, default: function _default() {
                return [];
            } },
        hide: { type: String, default: '' },
        selectable: { type: Boolean, default: false },
        hideIcon: Boolean,
        useSignature: Boolean,
        signatureHideModifiers: Boolean,
        signatureHideArgumentTypes: Boolean,
        signatureHideArgumentDefaults: Boolean,
        signatureHideReturn: Boolean,
        storeSettings: Boolean,
        mergeSettings: Object
    },
    data: function data() {
        return {
            active: undefined,
            settingsKey: 'pd-method-list-setting',
            filteredMethods: []
        };
    },
    mounted: function mounted() {
        if (this.mergeSettings) {
            this.recursiveSetter(this.settings, this.mergeSettings);
        }
    },

    watch: {
        file: function file(val) {
            if (val) {
                this.filterMethods();
            }
        },
        settings: function settings() {
            this.filterMethods();
        }
    },
    computed: _extends({}, (0, _vuex.mapGetters)({
        global_settings: 'global_settings',
        store_settings: 'settings'
    }), {
        settings: function settings() {
            return this.storeSettings ? this.store_settings['methods'] : this.global_settings['methods'];
        },
        methods: function methods() {
            return this.file.entity.methods;
        },
        liClass: function liClass() {
            return this.itemClass.split(' ');
        },
        aClass: function aClass() {
            return this.linkClass.split(' ');
        }
    }),
    methods: {
        filterMethods: function filterMethods() {
            this.filteredMethods = this.filter(this.methods);
        },

        // make sure only to overide keys that exist, not to add in bad keys after version changes
        recursiveSetter: function recursiveSetter(current, loaded) {
            var _this = this;

            Object.keys(current).forEach(function (key) {
                if (_typeof(current[key]) === 'object') {
                    if (typeof loaded[key] !== 'undefined') {

                        _this.recursiveSetter(current[key], loaded[key]);
                    }
                } else {
                    if (typeof loaded[key] !== 'undefined') {
                        current[key] = loaded[key];
                    }
                }
            });
        },
        filter: function filter(methods) {
            var items = (0, _lodash.chain)(methods);

            if (this.settings.show.inherited === false) {
                items = items.filter(function (item) {
                    return item.inherited !== true;
                });
            }
            if (this.settings.show.public === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'public';
                });
            }
            if (this.settings.show.protected === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'protected';
                });
            }
            if (this.settings.show.private === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'private';
                });
            }

            items = items.sortBy(this.settings.sort.by);

            if (this.settings.sort.dir === 'desc') {
                items = items.reverse();
            }

            return items.value();
        },
        setActive: function setActive(methodName) {
            if (!this.selectable) return;
            this.active = methodName;
            this.$emit('select', methodName);
            this.$events.$emit('phpdoc:method-list:select', methodName);
        },
        isActiveProperty: function isActiveProperty(method) {
            if (!this.selectable) return false;
            return this.method === method;
        },
        onMethodClick: function onMethodClick(method) {
            this.$emit('click', method);
            this.$events.$emit('phpdoc:method-list:click', method);
            this.setActive(method.name);
        }
    }
};

/***/ },

/***/ 234:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vuex = __webpack_require__(9);

var _lodash = __webpack_require__(6);

var _utils = __webpack_require__(49);

var _mixins = __webpack_require__(32);

exports.default = {
    name: 'pd-method-signature',
    mixins: [_mixins.methodRefComponent],
    props: {
        // ex: \Codex\Codex::get()
        hideModifiers: Boolean,
        hideReturn: Boolean,
        hideArguments: Boolean,
        hideArgumentTypes: Boolean,
        hideArgumentDefaults: Boolean,
        noTooltip: Boolean,
        returnCharacter: { type: String, default: '=>' }
    },
    mounted: function mounted() {},

    watch: {},
    methods: {},
    computed: {
        show: function show() {
            return {
                'modifiers': !this.hideModifiers,
                'return': !this.hideReturn,
                'arguments': !this.hideArguments,
                'argumentTypes': !this.hideArgumentTypes,
                'argumentDefaults': !this.hideArgumentDefaults
            };
        }
    }
}; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/***/ },

/***/ 235:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vuex = __webpack_require__(9);

var _lodash = __webpack_require__(6);

var _utils = __webpack_require__(49);

var _mixins = __webpack_require__(32);

exports.default = {
    name: 'pd-method',
    mixins: [_mixins.methodRefComponent],
    props: {
        hide: { type: String, default: '' }
    },
    data: function data() {
        return {
            excludeTags: ['param', 'example', 'return'],
            tags: new _utils.Tags()
        };
    },
    mounted: function mounted() {},

    watch: {
        method: function method(newVal) {
            var _this = this;

            if (this.hasData(this.method.returns)) {
                this.method.returns = this.method.returns.map(function (returns) {
                    if (returns === 'static') return _this.method.class_name;
                    return returns;
                });
            }
            this.$events.$emit('phpdoc:method:change', newVal);
            this.tags = new _utils.Tags(newVal.tags).exclude(this.excludeTags);

            setTimeout(function () {
                return _this.$nextTick(function () {
                    if (window['Prism']) window['Prism'].highlightAll();
                });
            }, 510);
        }
    },
    computed: {
        has: function has() {
            var m = this.method;
            return {
                tags: this.hasData(this.filterTags(m.tags)),
                returns: this.hasData(m.returns),
                description: this.hasData(m.description),
                'long-description': this.hasData(m['long-description']),
                arguments: this.hasData(m.arguments)
            };
        },
        show: function show() {
            var hidden = this.hide.split(',');
            var blocks = ['signature', 'description', 'example', 'tags', 'arguments', 'returns'];
            var show = {};
            blocks.forEach(function (block) {
                return show[block] = hidden.indexOf(block) === -1;
            });
            return show;
        }
    },
    methods: {
        hasData: function hasData(what) {
            return what !== undefined && what.length > 0;
        },
        filterTags: function filterTags(tags) {
            var _this2 = this;

            return (0, _lodash.filter)(tags, function (tag) {
                return _this2.excludeTags.indexOf(tag.name) === -1;
            });
        },
        onTypeClick: function onTypeClick() {}
    }
}; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/***/ },

/***/ 236:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

var _vue = __webpack_require__(2);

var _vue2 = _interopRequireDefault(_vue);

var _vuex = __webpack_require__(9);

var _lodash = __webpack_require__(6);

var _mixins = __webpack_require__(32);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'pd-property-list',
    mixins: [_mixins.fileRefComponent],
    props: {
        itemClass: { type: String, default: 'nav-item' },
        linkClass: { type: String, default: 'nav-link' },
        exclude: { type: Array, default: function _default() {
                return [];
            } },
        hide: { type: String, default: '' },
        selectable: { type: Boolean, default: false },
        compact: Boolean,
        useIcon: Boolean,
        persistSettings: Boolean,
        mergeSettings: Object
    },
    data: function data() {
        return {
            active: undefined,
            settingsKey: 'pd-property-list-setting',
            settings: {
                show: {
                    static: true,
                    inherited: false,
                    final: true,
                    public: true,
                    protected: true,
                    private: true
                },
                sort: {
                    by: '',
                    dir: 'asc'
                },
                view: ''
            }
        };
    },
    mounted: function mounted() {
        this.loadSettings();
        if (this.mergeSettings) {
            this.recursiveSetter(this.settings, this.mergeSettings);
        }
    },

    watch: {
        settings: {
            deep: true,
            handler: function handler(val, old) {
                this.saveSettings(val);
            }
        }
    },
    computed: {
        properties: function properties() {
            return this.entity.properties;
        },
        filteredProperties: function filteredProperties() {
            return this.filter(this.properties);
        },
        liClass: function liClass() {
            return this.itemClass.split(' ');
        },
        aClass: function aClass() {
            return this.linkClass.split(' ');
        }
    },
    methods: {
        saveSettings: function saveSettings(settings) {
            if (!this.persistSettings) return;
            this.$cookie.set(this.settingsKey, JSON.stringify(settings || this.settings));
        },
        loadSettings: function loadSettings() {
            if (!this.persistSettings) return;
            var parsed = JSON.parse(this.$cookie.get(this.settingsKey));
            if (parsed !== null) {

                this.recursiveSetter(this.settings, parsed);
            }
        },

        // make sure only to overide keys that exist, not to add in bad keys after version changes
        recursiveSetter: function recursiveSetter(current, loaded) {
            var _this = this;

            Object.keys(current).forEach(function (key) {
                if (_typeof(current[key]) === 'object') {
                    if (typeof loaded[key] !== 'undefined') {

                        _this.recursiveSetter(current[key], loaded[key]);
                    }
                } else {
                    if (typeof loaded[key] !== 'undefined') {
                        current[key] = loaded[key];
                    }
                }
            });
        },
        filter: function filter(properties) {
            var items = (0, _lodash.chain)(properties);

            if (this.settings.show.inherited === false) {
                items = items.filter(function (item) {
                    return item.inherited !== true;
                });
            }
            if (this.settings.show.public === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'public';
                });
            }
            if (this.settings.show.protected === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'protected';
                });
            }
            if (this.settings.show.private === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'private';
                });
            }

            items = items.sortBy(this.settings.sort.by);

            if (this.settings.sort.dir === 'desc') {
                items = items.reverse();
            }

            return items.value();
        },
        setActive: function setActive(propertyName) {
            if (!this.selectable) return;
            this.active = propertyName;
            this.$emit('select', propertyName);
        },
        isActiveProperty: function isActiveProperty(property) {
            if (!this.selectable) return false;
            return this.active === property;
        },
        onPropertyClick: function onPropertyClick(property) {
            this.$emit('click', property);
            this.setActive(property.name);
        }
    }
};

/***/ },

/***/ 237:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _mixins = __webpack_require__(32);

exports.default = {
    name: 'pd-source',
    mixins: [_mixins.fileRefComponent],
    mounted: function mounted() {
        var _this = this;

        this.$$ready(function () {

            if (_this.file) _this.setSourceCode(_this.file.source);
        });
    },

    watch: {
        file: function file() {
            var _this2 = this;

            this.$nextTick(function () {
                return _this2.setSourceCode(_this2.file.source);
            });
        }
    },
    computed: {
        $$lineNumbers: function $$lineNumbers() {
            return this.$$el.find('.line-numbers-rows > span');
        }
    },
    methods: {
        setSourceCode: function setSourceCode(code) {
            /** @type JQuery */
            var $sp = this.$$el,
                $pre = this.$$('<pre class="language-php line-numbers"></pre>'),
                $code = this.$$('<code class="language-php"></code>');

            $sp.html('');
            $pre.appendTo($sp);
            $code.appendTo($pre).text(code);
            Prism.highlightAll();
        },
        showSourceLine: function showSourceLine(line) {
            this.$$el.parent().animate({ scrollTop: this.$$lineNumbers[line - 1].offsetTop });
        }
    }
}; //
//
//
//

/***/ },

/***/ 238:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _utils = __webpack_require__(49);

var _lodash = __webpack_require__(6);

/**
 * Tags can be found on Entities, Methods and Properties.
 * We use a Fully Qualified Name as property to indicate where we want to look for tags
 */
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

exports.default = {
    name: 'pd-tags',
    props: {
        tags: { type: Array, default: function _default() {
                return [];
            } },
        exclude: { type: Array, default: [] }
    },
    data: function data() {
        return { res: false };
    },
    mounted: function mounted() {},

    watch: {},
    computed: {
        filteredTags: function filteredTags() {
            var _this = this;

            if (this.tags.length === 0) return [];

            return (0, _lodash.filter)(this.tags, function (tag) {
                return _this.exclude.indexOf(tag.name) === -1;
            });
        }
    },
    methods: {}
};

/***/ },

/***/ 239:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($, _) {

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//

var _vuex = __webpack_require__(9);

var _mixins = __webpack_require__(32);

var _mixins2 = __webpack_require__(39);

__webpack_require__(87);

exports.default = {
    name: 'pd-tree',
    mixins: [_mixins2.scrollable],
    props: {
        height: Number,
        query: String
    },
    data: function data() {
        return {
            config: {
                'plugins': ['types', 'search', 'wholerow'],
                'core': {
                    'themes': {
                        'responsive': false,
                        'name': 'codex'
                    }
                },
                'types': {
                    'default': { 'icon': 'fa fa-file' },
                    'folder': { 'icon': 'fa fa-folder color-blue-grey-500' },
                    'class': { icon: 'fa fa-file-code-o color-green-500' },
                    'interface': { icon: 'fa fa-code color-purple-800' },
                    'trait': { icon: 'fa fa-terminal color-blue-500' }

                }
            },
            // the .phpdoc-tree element
            $$tree: undefined,
            // root <ul> jquery element
            $$treeRoot: undefined,
            // jstree instance
            jstree: undefined,
            ignoreTreeSelect: false
        };
    },
    mounted: function mounted() {
        var _this = this;

        this.$$tree = this.$$(this.$el.children[0]);
        this.updatePhpdocTree().then(function () {
            _this.create(_this.tree || {});
            if (_this.tree && _this.query) {
                var parsed = _this.$phpdoc.parseRef(_this.query);
                _this.openTo(parsed.entityName);
            }
            _this.$watch('query', function (val) {
                var parsed = _this.$phpdoc.parseRef(val);
                _this.openTo(parsed.entityName);
            });
        });
    },
    beforeDestroy: function beforeDestroy() {},

    watch: {
        tree: function tree() {
            this.create(this.tree);
        }
    },
    computed: _extends({}, (0, _vuex.mapGetters)({ _tree: 'tree' }), {
        tree: function tree() {
            return Vue.codex.phpdoc.tree || this._tree;
        },
        project: function project() {
            return Vue.codex.project;
        },
        ref: function ref() {
            return Vue.codex.ref;
        }
    }),

    methods: _extends({}, (0, _vuex.mapActions)(['updatePhpdocTree']), {
        create: function create(items) {
            var _this2 = this;

            if (this.jstree) this.jstree.destroy();
            if (this.$$treeRoot) this.$$treeRoot.remove();
            this.$$treeRoot = $('<ul>').appendTo(this.$$el);
            this.traverse(items, this.$$treeRoot);
            //                this.tree.jstree(config('phpdoc.jstree'));
            this.$$el.jstree(this.config);
            /** @type JSTree */
            this.jstree = this.$$el.jstree();
            this.$$el.on('select_node.jstree', this, function (event, data) {
                if (_this2.ignoreTreeSelect) return;
                if (data.node.type === 'folder') {
                    _this2.jstree.open_node(data.node);
                } else {
                    var fullName = data.node.data.fullName;
                    _this2.$emit('select', fullName, event, data);
                }
            }).on('after_open.jstree', this, function () {
                _this2.$root.$emit('resize');
            });

            this.$emit('created');
        },
        traverse: function traverse(items, $el, level) {
            var _this3 = this;

            level = level || 0;
            Object.keys(items).forEach(function (k) {
                var item = items[k];
                if (isNaN(parseInt(k))) {
                    // this is a string, with children
                    var $nel = $('<ul>');
                    var $nli = $('<li>').text(k).append($nel);
                    $nli.addClass('fs-12');
                    if (level == 0) {
                        $nli.attr('data-jstree', '{ "opened" : true, "type" : "folder" }');
                    } else {
                        $nli.attr('data-jstree', '{ "type" : "folder" }');
                    }

                    var namePath = "\\" + k;
                    if (typeof $el.closest('li').attr('data-full-name') !== "undefined") {
                        namePath = $el.closest('li').attr('data-full-name') + namePath;
                    }
                    $nli.attr('data-full-name', namePath);

                    $el.prepend($nli);
                    _this3.traverse(item, $nel, level++);
                } else {
                    $el.append($('<li>').text(item['name']).attr('data-jstree', '{ "type": "' + item['type'] + '" }').attr('data-full-name', item['full_name']));
                }
            });
        },
        search: function search(fullName) {
            var items = this.jstree.get_json(null, { flat: true });
            //                console.trace('search for', fullName, 'in', items);
            var found = false;
            items.forEach(function (item) {

                if (typeof item.data.fullName !== "undefined" && _.endsWith(item.data.fullName, fullName)) {
                    //                        console.trace('search for', fullName, 'found', item);
                    found = item;
                    return false;
                }
            });
            return found;
        },
        openTo: function openTo(fullName) {
            var node = this.search(fullName);
            if (node !== false) {

                this.ignoreTreeSelect = true;
                this.jstree.close_all();
                this.jstree._open_to(node);
                this.jstree.deselect_all();
                this.jstree.select_node(node);
                this.ignoreTreeSelect = false;
            }
        }
    })
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15), __webpack_require__(6)))

/***/ },

/***/ 240:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

var _vuex = __webpack_require__(9);

var _utils = __webpack_require__(49);

var _lodash = __webpack_require__(6);

//, isNumber, isObject, isUndefined, isBoolean, isNull


exports.default = {
    name: 'pd-type',
    props: {
        type: { type: [String, Array], default: [] },
        fullName: { type: Boolean, default: false },
        noTooltip: { type: Boolean, default: false },
        tooltip: {
            type: Object, default: function _default() {
                return { effect: 'scale', placement: 'top' };
            }
        },
        seperator: { type: String, default: '|' },
        static: String
    },
    data: function data() {
        return {
            types: [],
            isInternal: false
        };
    },
    beforeMount: function beforeMount() {
        return this.getPhpdocEntities();
    },
    mounted: function mounted() {
        if (this.type) this.types = this.parseType(this.type);
    },

    watch: {
        type: function type(newVal) {
            this.types = this.parseType(newVal);
        },
        entities: function entities() {
            this.types = this.parseType(this.type);
        }
    },
    methods: _extends({}, (0, _vuex.mapActions)(['getPhpdocEntities']), {
        parseType: function parseType(type) {
            var _this = this;

            if ((0, _lodash.isString)(type)) {
                type = type.split('|');
            }
            if ((0, _lodash.isArray)(type)) {
                type = type.map(function (t) {
                    return new _utils.Type(t.toString(), _this);
                });
            }
            //
            return type;
        },
        onEntityClick: function onEntityClick(type) {
            this.$emit('click', type);
            this.$events.$emit('phpdoc:type:click', type);
        }
    }),
    computed: _extends({}, (0, _vuex.mapGetters)(['entities']), {
        showTooltip: function showTooltip() {
            return this.noTooltip === false;
        }
    })
};

/***/ },

/***/ 250:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(_) {

var directives = __webpack_require__(248);
var filters = __webpack_require__(249);
var api = __webpack_require__(68);
var mixins = __webpack_require__(32);
var utils = __webpack_require__(49);
filters['removeStartSlash'] = utils.removeStartSlash;
var plugin = function plugin(Vue) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (plugin.installed) return;
    Vue.codex.extend({
        phpdoc: _.merge({}, api, utils, {
            mixins: mixins
        })
    });
    Object.defineProperties(Vue.prototype, {
        $phpdoc: {
            get: function get() {
                return Vue.codex.phpdoc;
            }
        }
    });
    var components = __webpack_require__(254);
    Object.keys(components).forEach(function (key) {
        return Vue.component(key, components[key]);
    });
    Object.keys(directives).forEach(function (key) {
        return Vue.directive(key, directives[key]);
    });
    Object.keys(filters).forEach(function (key) {
        return Vue.filter(key, filters[key]);
    });
    if (Vue.codex.store) {
        var _require = __webpack_require__(251),
            module = _require.module,
            types = _require.types;

        Vue.codex.store.registerModule('phpdoc', module);
        Vue.codex.phpdoc.types = types;
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = plugin;
//# sourceMappingURL=plugin.js.map
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ },

/***/ 251:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(_) {

var _mutations;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var Vue = __webpack_require__(2);
var api = __webpack_require__(68);
var util_1 = __webpack_require__(86);
var bag = util_1.Storage.getOrCreateBag('codex.phpdoc', "local");
var emit = function emit() {
    for (var _len = arguments.length, params = Array(_len), _key = 0; _key < _len; _key++) {
        params[_key] = arguments[_key];
    }

    return Vue.codex.events.$emit.apply(Vue.codex.events, params);
};
exports.types = {
    ADD_ENTITY: 'phpdoc/ADD_ENTITY',
    SET_TREE: 'phpdoc/SET_TREE',
    SET_FILE: 'phpdoc/SET_FILE',
    SET_LOADING: 'phpdoc/SET_LOADING',
    SET_ENTITIES: 'phpdoc/SET_ENTITIES',
    MERGE_METHODS_SETTINGS: 'phpdoc/MERGE_METHODS_SETTINGS',
    MERGE_PROPERTIES_SETTINGS: 'phpdoc/MERGE_PROPERTIES_SETTINGS'
};
function getSettings() {
    var extra = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    return _.merge({
        show: {
            inherited: true,
            public: true,
            protected: true,
            private: true
        },
        sort: {
            by: '',
            dir: 'asc'
        },
        view: ''
    }, extra);
}
var state = {
    tree: Vue.codex.phpdoc.tree ? Vue.codex.phpdoc.tree : undefined,
    entities: Vue.codex.phpdoc.entities ? Vue.codex.phpdoc.entities : [],
    full_entities: [],
    settings: {
        methods: bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings({ show: { static: true, abstract: true, final: true } }),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings()
    },
    global_settings: {
        methods: getSettings({ show: { static: true, abstract: true, final: true } }),
        properties: getSettings()
    }
};
exports.module = {
    state: state,
    mutations: (_mutations = {}, _defineProperty(_mutations, exports.types.SET_LOADING, function (state, loading) {
        if (typeof loading.tree === 'boolean') state.loading.tree = loading.tree;
        if (typeof loading.content === 'boolean') state.loading.content = loading.content;
        emit(exports.types.SET_LOADING);
    }), _defineProperty(_mutations, exports.types.SET_ENTITIES, function (state, entities) {
        state.entities = entities;
        emit(exports.types.SET_ENTITIES);
    }), _defineProperty(_mutations, exports.types.SET_TREE, function (state, tree) {
        state.tree = tree;
        emit(exports.types.SET_TREE);
    }), _defineProperty(_mutations, exports.types.SET_FILE, function (state, file) {
        state.file = file;
        state.fullName = file.entity.full_name;
        emit(exports.types.SET_FILE);
    }), _defineProperty(_mutations, exports.types.ADD_ENTITY, function (state, entity) {
        state.full_entities.push(entity);
    }), _defineProperty(_mutations, exports.types.MERGE_METHODS_SETTINGS, function (state, settings) {
        state.settings.methods = _.merge({}, state.settings.methods, settings);
        bag.set('settings.methods', state.settings.methods, { json: true });
        emit(exports.types.MERGE_METHODS_SETTINGS);
    }), _defineProperty(_mutations, exports.types.MERGE_PROPERTIES_SETTINGS, function (state, settings) {
        state.settings.properties = _.merge({}, state.settings.properties, settings);
        bag.set('settings.properties', state.settings.properties, { json: true });
        emit(exports.types.MERGE_PROPERTIES_SETTINGS);
    }), _mutations),
    actions: {
        updatePhpdocEntities: function updatePhpdocEntities(_ref) {
            var state = _ref.state,
                commit = _ref.commit,
                dispatch = _ref.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee() {
                return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                api.getEntities({ tree: true }).then(function (tree) {
                                    commit(exports.types.SET_TREE, tree);
                                });
                                _context.next = 3;
                                return api.getEntities().then(function (entities) {
                                    commit(exports.types.SET_ENTITIES, entities);
                                });

                            case 3:
                                return _context.abrupt("return", _context.sent);

                            case 4:
                            case "end":
                                return _context.stop();
                        }
                    }
                }, _callee, this);
            }));
        },
        setPhpdocFile: function setPhpdocFile(_ref2) {
            var state = _ref2.state,
                commit = _ref2.commit,
                dispatch = _ref2.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee2() {
                return regeneratorRuntime.wrap(function _callee2$(_context2) {
                    while (1) {
                        switch (_context2.prev = _context2.next) {
                            case 0:
                                if (!(state.fullName === payload)) {
                                    _context2.next = 2;
                                    break;
                                }

                                return _context2.abrupt("return");

                            case 2:
                                _context2.next = 4;
                                return api.getEntity(payload, { full: true }).then(function (file) {
                                    commit(exports.types.SET_FILE, file);
                                });

                            case 4:
                                return _context2.abrupt("return", _context2.sent);

                            case 5:
                            case "end":
                                return _context2.stop();
                        }
                    }
                }, _callee2, this);
            }));
        },
        updatePhpdocTree: function updatePhpdocTree(_ref3) {
            var state = _ref3.state,
                commit = _ref3.commit,
                dispatch = _ref3.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee3() {
                return regeneratorRuntime.wrap(function _callee3$(_context3) {
                    while (1) {
                        switch (_context3.prev = _context3.next) {
                            case 0:
                                return _context3.abrupt("return", new Promise(function (resolve, reject) {
                                    return api.getEntities({ tree: true }).then(function (tree) {
                                        commit(exports.types.SET_TREE, tree);
                                        resolve(tree);
                                    });
                                }));

                            case 1:
                            case "end":
                                return _context3.stop();
                        }
                    }
                }, _callee3, this);
            }));
        },
        getPhpdocEntities: function getPhpdocEntities(_ref4) {
            var state = _ref4.state,
                commit = _ref4.commit,
                dispatch = _ref4.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee4() {
                return regeneratorRuntime.wrap(function _callee4$(_context4) {
                    while (1) {
                        switch (_context4.prev = _context4.next) {
                            case 0:
                                return _context4.abrupt("return", new Promise(function (resolve, reject) {
                                    if (state.entities.length === 0) {
                                        api.getEntities().then(function (entities) {
                                            commit(exports.types.SET_ENTITIES, entities);
                                            resolve(entities);
                                        });
                                    } else {
                                        resolve(state.entities);
                                    }
                                }));

                            case 1:
                            case "end":
                                return _context4.stop();
                        }
                    }
                }, _callee4, this);
            }));
        },
        getPhpdocEntity: function getPhpdocEntity(_ref5) {
            var state = _ref5.state,
                commit = _ref5.commit,
                dispatch = _ref5.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee5() {
                return regeneratorRuntime.wrap(function _callee5$(_context5) {
                    while (1) {
                        switch (_context5.prev = _context5.next) {
                            case 0:
                                return _context5.abrupt("return", new Promise(function (resolve, reject) {
                                    return api.getEntity(payload, { full: true }).then(function (entity) {
                                        commit(exports.types.ADD_ENTITY, entity);
                                        resolve(entity);
                                    });
                                }));

                            case 1:
                            case "end":
                                return _context5.stop();
                        }
                    }
                }, _callee5, this);
            }));
        },
        updatePhpdocSettings: function updatePhpdocSettings(_ref6) {
            var state = _ref6.state,
                commit = _ref6.commit,
                dispatch = _ref6.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            var type = payload.type === 'methods' ? exports.types.MERGE_METHODS_SETTINGS : exports.types.MERGE_PROPERTIES_SETTINGS;
            commit(type, payload.settings);
        },
        resetPhpdocSettings: function resetPhpdocSettings(_ref7) {
            var state = _ref7.state,
                commit = _ref7.commit,
                dispatch = _ref7.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            if (payload && payload === 'methods') {
                commit(exports.types.MERGE_METHODS_SETTINGS, state.global_settings.methods);
            } else if (payload && payload === 'properties') {
                commit(exports.types.MERGE_PROPERTIES_SETTINGS, state.global_settings.properties);
            } else {
                commit(exports.types.MERGE_METHODS_SETTINGS, state.global_settings.methods);
                commit(exports.types.MERGE_PROPERTIES_SETTINGS, state.global_settings.properties);
            }
        }
    },
    getters: {
        fullName: function fullName(state) {
            return state.fullName;
        },
        tree: function tree(state) {
            return state.tree;
        },
        entities: function entities(state) {
            return state.entities;
        },
        full_entities: function full_entities(state) {
            return state.full_entities;
        },
        settings: function settings(state) {
            return state.settings;
        },
        global_settings: function global_settings(state) {
            return state.global_settings;
        }
    }
};
//# sourceMappingURL=store.js.map
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ },

/***/ 254:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var pdEntity = __webpack_require__(522),
    pdPropertyList = __webpack_require__(528),
    pdMethod = __webpack_require__(527),
    pdMethodList = __webpack_require__(525),
    pdMethodSignature = __webpack_require__(526),
    pdListSettings = __webpack_require__(524),
    pdListSettingsMenu = __webpack_require__(523),
    pdType = __webpack_require__(532),
    pdTags = __webpack_require__(530),
    pdTree = __webpack_require__(531),
    pdSource = __webpack_require__(529),
    pdApp = __webpack_require__(521);
exports.pdEntity = pdEntity;
exports.pdPropertyList = pdPropertyList;
exports.pdMethod = pdMethod;
exports.pdMethodList = pdMethodList;
exports.pdMethodSignature = pdMethodSignature;
exports.pdListSettings = pdListSettings;
exports.pdListSettingsMenu = pdListSettingsMenu;
exports.pdType = pdType;
exports.pdTags = pdTags;
exports.pdTree = pdTree;
exports.pdSource = pdSource;
exports.pdApp = pdApp;
//# sourceMappingURL=index.js.map

/***/ },

/***/ 32:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(_) {

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var vuex_1 = __webpack_require__(9);
var general_1 = __webpack_require__(73);
exports.phpdocTab = {
    computed: _.merge(vuex_1.mapGetters(['file', 'settings']), {
        entity: function entity() {
            return this.file.entity;
        }
    }),
    methods: _.merge(vuex_1.mapActions(['updatePhpdoc']), {
        getFiltered: function getFiltered(type) {
            var items = _.chain(this.entity[type]);
            if (this.settings[type].show.inherited === false) {
                items = items.filter(function (item) {
                    return item.inherited !== true;
                });
            }
            if (this.settings[type].show.public === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'public';
                });
            }
            if (this.settings[type].show.protected === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'protected';
                });
            }
            if (this.settings[type].show.private === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'private';
                });
            }
            items = items.sortBy(this.settings[type].sort.by);
            if (this.settings[type].sort.dir === 'desc') {
                items = items.reverse();
            }
            return items.value();
        }
    })
};
exports.phpdocComponent = {
    methods: {}
};
exports.entityChild = {
    props: {
        fullName: String
    },
    data: function data() {
        return { fileData: false };
    },
    mounted: function mounted() {
        if (this.fullName) this.setFile(this.fullName);
    },

    watch: {
        fullName: function fullName(newVal) {
            this.setFile(newVal);
        }
    },
    computed: _.merge(vuex_1.mapGetters({ _file: 'file' }), {
        file: function file() {
            return this._file ? this._file : this.fileData;
        },
        entity: function entity() {
            return this.file ? this.file.entity : false;
        }
    }),
    methods: _.merge(vuex_1.mapActions(['setPhpdocFile']), {
        setFile: function setFile(fullName) {
            var _this = this;

            if (this._file) {
                this.setPhpdocFile(fullName);
            } else {
                this.$phpdoc.getEntity(fullName).then(function (data) {
                    return _this.fileData = data;
                });
            }
        }
    })
};
exports.component = {
    computed: {},
    methods: {
        inApp: function inApp() {
            return this.$root.$options.name === 'phpdoc';
        },
        getEntity: function getEntity(fullName) {
            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee() {
                var _this2 = this;

                return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                return _context.abrupt("return", new Promise(function (resolve, reject) {
                                    var entity = _.find(_this2.$store.getters.full_entities, fullName);
                                    if (entity) return resolve(entity);
                                    _this2.$store.dispatch('getPhpdocEntity', fullName).then(function (entity) {
                                        resolve(entity);
                                    });
                                }));

                            case 1:
                            case "end":
                                return _context.stop();
                        }
                    }
                }, _callee, this);
            }));
        },
        getMethod: function getMethod(entityName, methodName) {
            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee2() {
                var _this3 = this;

                var parsed;
                return regeneratorRuntime.wrap(function _callee2$(_context2) {
                    while (1) {
                        switch (_context2.prev = _context2.next) {
                            case 0:
                                if (!(methodName === undefined)) {
                                    _context2.next = 5;
                                    break;
                                }

                                parsed = general_1.parseFullName(entityName);

                                if (parsed.isMethod) {
                                    _context2.next = 4;
                                    break;
                                }

                                throw new Error('Query not for method ' + entityName);

                            case 4:
                                methodName = parsed.methodName;

                            case 5:
                                return _context2.abrupt("return", new Promise(function (resolve, reject) {
                                    var entity = _.find(_this3.$store.getters.full_entities, entityName);
                                    if (!entity) {
                                        return _this3.getEntity(entityName).then(function (entity) {
                                            var method = _.find(entity.entity.methods, { name: methodName });
                                            if (!method) {
                                                console.trace('no method found:  ' + methodName, _this3);
                                                return reject('no method found:  ' + methodName);
                                            }
                                            resolve(method);
                                        });
                                    }
                                    var method = _.find(entity.entity.methods, { name: methodName });
                                    if (!method) console.trace('no method found:  ' + methodName, _this3) && reject('no method found:  ' + methodName);
                                }));

                            case 6:
                            case "end":
                                return _context2.stop();
                        }
                    }
                }, _callee2, this);
            }));
        },
        hasEntity: function hasEntity(fullName) {
            return _.find(this.$store.getters.entities, fullName);
        }
    }
};
exports.fileRefComponent = {
    mixins: [exports.component],
    props: {
        query: String,
        fileRef: Object
    },
    data: function data() {
        return { file: false };
    },
    mounted: function mounted() {
        if (this.query) this.handleQuery(this.query);
        if (this.fileRef) this.file = this.fileRef;
    },

    computed: {
        entity: function entity() {
            return this.file.entity;
        }
    },
    watch: {
        query: function query(val) {
            this.file = false;
            this.handleQuery(val);
        },
        fileRef: function fileRef(val) {
            this.file = val;
        }
    },
    methods: {
        handleQuery: function handleQuery(ref) {
            var _this4 = this;

            var parsed = this.$phpdoc.parseRef(ref);
            if (!parsed.isEntity) {
                throw new Error('Parsed ref is not for method: ' + ref);
            }
            this.getEntity(parsed.entityName).then(function (file) {
                return _this4.file = file;
            });
        }
    }
};
exports.methodRefComponent = {
    mixins: [exports.component],
    props: {
        query: String,
        methodRef: Object
    },
    data: function data() {
        return { method: false };
    },
    mounted: function mounted() {
        if (this.query) this.handleQuery(this.query);
        if (this.methodRef) this.method = this.methodRef;
    },

    watch: {
        query: function query(val) {
            this.method = false;
            this.handleQuery(val);
        },
        methodRef: function methodRef(val) {
            this.method = val;
        }
    },
    methods: {
        handleQuery: function handleQuery(ref) {
            var _this5 = this;

            var parsed = this.$phpdoc.parseRef(ref);
            if (!parsed.isMethod) {
                throw new Error('Parsed ref is not for method: ' + ref);
            }
            this.getMethod(parsed.entityName, parsed.methodName).then(function (method) {
                return _this5.method = method;
            });
        }
    }
};
//# sourceMappingURL=mixins.js.map
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ },

/***/ 39:
/***/ function(module, exports, __webpack_require__) {

"use strict";


function __export(m) {
    for (var p in m) {
        if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }
}
var resize_1 = __webpack_require__(64);
exports.resize = resize_1.default;
var layout_1 = __webpack_require__(45);
exports.layout = layout_1.default;
__export(__webpack_require__(65));
//# sourceMappingURL=index.js.map

/***/ },

/***/ 40:
/***/ function(module, exports, __webpack_require__) {

"use strict";


function md5cycle(x, k) {
    var a = x[0],
        b = x[1],
        c = x[2],
        d = x[3];
    a = ff(a, b, c, d, k[0], 7, -680876936);
    d = ff(d, a, b, c, k[1], 12, -389564586);
    c = ff(c, d, a, b, k[2], 17, 606105819);
    b = ff(b, c, d, a, k[3], 22, -1044525330);
    a = ff(a, b, c, d, k[4], 7, -176418897);
    d = ff(d, a, b, c, k[5], 12, 1200080426);
    c = ff(c, d, a, b, k[6], 17, -1473231341);
    b = ff(b, c, d, a, k[7], 22, -45705983);
    a = ff(a, b, c, d, k[8], 7, 1770035416);
    d = ff(d, a, b, c, k[9], 12, -1958414417);
    c = ff(c, d, a, b, k[10], 17, -42063);
    b = ff(b, c, d, a, k[11], 22, -1990404162);
    a = ff(a, b, c, d, k[12], 7, 1804603682);
    d = ff(d, a, b, c, k[13], 12, -40341101);
    c = ff(c, d, a, b, k[14], 17, -1502002290);
    b = ff(b, c, d, a, k[15], 22, 1236535329);
    a = gg(a, b, c, d, k[1], 5, -165796510);
    d = gg(d, a, b, c, k[6], 9, -1069501632);
    c = gg(c, d, a, b, k[11], 14, 643717713);
    b = gg(b, c, d, a, k[0], 20, -373897302);
    a = gg(a, b, c, d, k[5], 5, -701558691);
    d = gg(d, a, b, c, k[10], 9, 38016083);
    c = gg(c, d, a, b, k[15], 14, -660478335);
    b = gg(b, c, d, a, k[4], 20, -405537848);
    a = gg(a, b, c, d, k[9], 5, 568446438);
    d = gg(d, a, b, c, k[14], 9, -1019803690);
    c = gg(c, d, a, b, k[3], 14, -187363961);
    b = gg(b, c, d, a, k[8], 20, 1163531501);
    a = gg(a, b, c, d, k[13], 5, -1444681467);
    d = gg(d, a, b, c, k[2], 9, -51403784);
    c = gg(c, d, a, b, k[7], 14, 1735328473);
    b = gg(b, c, d, a, k[12], 20, -1926607734);
    a = hh(a, b, c, d, k[5], 4, -378558);
    d = hh(d, a, b, c, k[8], 11, -2022574463);
    c = hh(c, d, a, b, k[11], 16, 1839030562);
    b = hh(b, c, d, a, k[14], 23, -35309556);
    a = hh(a, b, c, d, k[1], 4, -1530992060);
    d = hh(d, a, b, c, k[4], 11, 1272893353);
    c = hh(c, d, a, b, k[7], 16, -155497632);
    b = hh(b, c, d, a, k[10], 23, -1094730640);
    a = hh(a, b, c, d, k[13], 4, 681279174);
    d = hh(d, a, b, c, k[0], 11, -358537222);
    c = hh(c, d, a, b, k[3], 16, -722521979);
    b = hh(b, c, d, a, k[6], 23, 76029189);
    a = hh(a, b, c, d, k[9], 4, -640364487);
    d = hh(d, a, b, c, k[12], 11, -421815835);
    c = hh(c, d, a, b, k[15], 16, 530742520);
    b = hh(b, c, d, a, k[2], 23, -995338651);
    a = ii(a, b, c, d, k[0], 6, -198630844);
    d = ii(d, a, b, c, k[7], 10, 1126891415);
    c = ii(c, d, a, b, k[14], 15, -1416354905);
    b = ii(b, c, d, a, k[5], 21, -57434055);
    a = ii(a, b, c, d, k[12], 6, 1700485571);
    d = ii(d, a, b, c, k[3], 10, -1894986606);
    c = ii(c, d, a, b, k[10], 15, -1051523);
    b = ii(b, c, d, a, k[1], 21, -2054922799);
    a = ii(a, b, c, d, k[8], 6, 1873313359);
    d = ii(d, a, b, c, k[15], 10, -30611744);
    c = ii(c, d, a, b, k[6], 15, -1560198380);
    b = ii(b, c, d, a, k[13], 21, 1309151649);
    a = ii(a, b, c, d, k[4], 6, -145523070);
    d = ii(d, a, b, c, k[11], 10, -1120210379);
    c = ii(c, d, a, b, k[2], 15, 718787259);
    b = ii(b, c, d, a, k[9], 21, -343485551);
    x[0] = add32(a, x[0]);
    x[1] = add32(b, x[1]);
    x[2] = add32(c, x[2]);
    x[3] = add32(d, x[3]);
}
function cmn(q, a, b, x, s, t) {
    a = add32(add32(a, q), add32(x, t));
    return add32(a << s | a >>> 32 - s, b);
}
function ff(a, b, c, d, x, s, t) {
    return cmn(b & c | ~b & d, a, b, x, s, t);
}
function gg(a, b, c, d, x, s, t) {
    return cmn(b & d | c & ~d, a, b, x, s, t);
}
function hh(a, b, c, d, x, s, t) {
    return cmn(b ^ c ^ d, a, b, x, s, t);
}
function ii(a, b, c, d, x, s, t) {
    return cmn(c ^ (b | ~d), a, b, x, s, t);
}
function md51(s) {
    var txt = '';
    var n = s.length,
        state = [1732584193, -271733879, -1732584194, 271733878],
        i;
    for (i = 64; i <= s.length; i += 64) {
        md5cycle(state, md5blk(s.substring(i - 64, i)));
    }
    s = s.substring(i - 64);
    var tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
    for (i = 0; i < s.length; i++) {
        tail[i >> 2] |= s.charCodeAt(i) << (i % 4 << 3);
    }tail[i >> 2] |= 0x80 << (i % 4 << 3);
    if (i > 55) {
        md5cycle(state, tail);
        for (i = 0; i < 16; i++) {
            tail[i] = 0;
        }
    }
    tail[14] = n * 8;
    md5cycle(state, tail);
    return state;
}
function md5blk(s) {
    var md5blks = [],
        i;
    for (i = 0; i < 64; i += 4) {
        md5blks[i >> 2] = s.charCodeAt(i) + (s.charCodeAt(i + 1) << 8) + (s.charCodeAt(i + 2) << 16) + (s.charCodeAt(i + 3) << 24);
    }
    return md5blks;
}
var hex_chr = '0123456789abcdef'.split('');
function rhex(n) {
    var s = '',
        j = 0;
    for (; j < 4; j++) {
        s += hex_chr[n >> j * 8 + 4 & 0x0F] + hex_chr[n >> j * 8 & 0x0F];
    }return s;
}
function hex(x) {
    for (var i = 0; i < x.length; i++) {
        x[i] = rhex(x[i]);
    }return x.join('');
}
function md5(s) {
    return hex(md51(s));
}
function add32(a, b) {
    return a + b & 0xFFFFFFFF;
}
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = md5;
//# sourceMappingURL=md5.js.map

/***/ },

/***/ 46:
/***/ function(module, exports, __webpack_require__) {

"use strict";


function createBodyClickListener(fn) {
    var isListening = false;
    function start(cb) {
        window.addEventListener('click', _onclick, true);
        window.addEventListener('keyup', _onescape, true);
        isListening = true;
        if (typeof cb === 'function') cb();
    }
    function stop(cb) {
        window.removeEventListener('click', _onclick, true);
        window.removeEventListener('keyup', _onescape, true);
        isListening = false;
        if (typeof cb === 'function') cb();
    }
    function _onclick(e) {
        e.preventDefault();
        if (typeof fn === 'function') fn(e);
        stop();
    }
    function _onescape(e) {
        if (e.keyCode === 27) _onclick(e);
    }
    return {
        start: start, stop: stop,
        get isListening() {
            return isListening;
        }
    };
}
exports.createBodyClickListener = createBodyClickListener;
//# sourceMappingURL=body-click-listener.js.map

/***/ },

/***/ 47:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var lodash_1 = __webpack_require__(6);
function getRandomId(length) {
    if (lodash_1.isNumber(length)) {
        length = 15;
    }
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < length; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
}
exports.getRandomId = getRandomId;
function load(vNodeContext, cb) {
    if (document.readyState === 'complete') {
        vNodeContext.$nextTick(function () {
            return cb();
        });
    } else {
        document.addEventListener('DOMContentLoaded', function () {
            return cb();
        });
    }
}
exports.load = load;
function getViewPort() {
    var e = window,
        a = 'inner';
    if (!('innerWidth' in window)) {
        a = 'client';
        e = document.documentElement || document.body;
    }
    return {
        width: e[a + 'Width'],
        height: e[a + 'Height']
    };
}
exports.getViewPort = getViewPort;
function isTouchDevice() {
    try {
        document.createEvent("TouchEvent");
        return true;
    } catch (e) {
        return false;
    }
}
exports.isTouchDevice = isTouchDevice;
function getElementHeight(element) {
    if (!element['getClientRects']().length) {
        return element.offsetHeight;
    }
    var rect = element.getBoundingClientRect();
    if (rect.width || rect.height) {
        return rect.bottom - rect.top;
    }
    return 0;
}
exports.getElementHeight = getElementHeight;
function listen(target, eventType, callback) {
    if (target.addEventListener) {
        target.addEventListener(eventType, callback, false);
        return {
            remove: function remove() {
                target.removeEventListener(eventType, callback, false);
            }
        };
    } else if (target.attachEvent) {
        target.attachEvent("on" + eventType, callback);
        return {
            remove: function remove() {
                target.detachEvent("on" + eventType, callback);
            }
        };
    }
}
exports.listen = listen;
function getScroll(w, top) {
    var ret = w["page" + (top ? 'Y' : 'X') + "Offset"];
    var method = "scroll" + (top ? 'Top' : 'Left');
    if (typeof ret !== 'number') {
        var d = w.document;
        ret = d.documentElement[method];
        if (typeof ret !== 'number') {
            ret = d.body[method];
        }
    }
    return ret;
}
exports.getScroll = getScroll;
function getOffset(element) {
    var elm = element;
    var top = elm.offsetTop;
    var left = elm.offsetLeft;
    while (elm.offsetParent !== null) {
        elm = elm.offsetParent;
        top += elm.offsetTop;
        left += elm.offsetLeft;
    }
    return {
        top: top,
        left: left
    };
}
exports.getOffset = getOffset;
function cssTransitions() {
    if (typeof document === 'undefined') return false;
    var style = document.documentElement.style;
    return style['webkitTransition'] !== undefined || style['MozTransition'] !== undefined || style['OTransition'] !== undefined || style['MsTransition'] !== undefined || style.transition !== undefined;
}
exports.cssTransitions = cssTransitions;
function escapeHash(hash) {
    return hash.replace(/(:|\.|\[|\]|,|=)/g, "\\$1");
}
exports.escapeHash = escapeHash;
function registerJqueryHelpers($) {
    if ($.fn.prefixedData !== undefined) {
        return;
    }
    $.fn.prefixedData = function (prefix) {
        var origData = $(this).first().data();
        var data = {};
        for (var p in origData) {
            var pattern = new RegExp("^" + prefix + "[A-Z]+");
            if (origData.hasOwnProperty(p) && pattern.test(p)) {
                var shortName = p[prefix.length].toLowerCase() + p.substr(prefix.length + 1);
                data[shortName] = origData[p];
            }
        }
        return data;
    };
    $.fn.removeAttributes = function () {
        return this.each(function () {
            var attributes = $.map(this.attributes, function (item) {
                return item.name;
            });
            var img = $(this);
            $.each(attributes, function (i, item) {
                img.removeAttr(item);
            });
        });
    };
    $.fn.ensureClass = function (clas) {
        var has = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

        var $this = $(this);
        if (has === true && $this.hasClass(clas) === false) {
            $this.addClass(clas);
        } else if (has === false && $this.hasClass(clas) === true) {
            $this.removeClass(clas);
        }
        return this;
    };
    $.fn.onClick = function () {
        var $this = $(this);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return $this.on.apply($this, [isTouchDevice() ? 'touchend' : 'click'].concat(args));
    };
}
exports.registerJqueryHelpers = registerJqueryHelpers;
function parseBool(val) {
    return val === true || val === 1 || val === 'true' || val === '1';
}
exports.parseBool = parseBool;
function setCookie(k, v) {
    Vue.cookie.set(k, JSON.stringify(v));
}
exports.setCookie = setCookie;
function getCookie(k) {
    return JSON.parse(Vue.cookie.get(k));
}
exports.getCookie = getCookie;
function getRefInParents(ref, parent) {
    if (parent.$root === parent) return false;
    if (parent.$refs[ref] !== undefined) {
        return parent.$refs[ref];
    }
    return getRefInParents(ref, parent.$parent);
}
exports.getRefInParents = getRefInParents;
//# sourceMappingURL=general.js.map

/***/ },

/***/ 48:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Loader = function () {
    function Loader(loaderId, bodyLoadingClass, loaderClassSuffix) {
        _classCallCheck(this, Loader);

        this.loaderId = loaderId;
        this.bodyLoadingClass = bodyLoadingClass;
        this.loaderClassSuffix = loaderClassSuffix;
        this.isLoading = false;
    }

    _createClass(Loader, [{
        key: 'start',
        value: function start() {
            this.getLoaderElement();
            if (!this.bodyClass.contains(this.bodyLoadingClass)) {
                this.bodyClass.add(this.bodyLoadingClass);
            }
        }
    }, {
        key: 'stop',
        value: function stop() {
            this.bodyClass.remove(this.bodyLoadingClass);
        }
    }, {
        key: 'getLoaderElement',
        value: function getLoaderElement() {
            var container = document.getElementById(this.loaderId);
            var loader = void 0;
            if (!container) {
                container = document.createElement('div');
                container.setAttribute('id', this.loaderId);
                document.body.appendChild(container);
                loader = document.createElement('div');
                loader.classList.add('loader');
                loader.classList.add('loader-' + this.loaderClassSuffix);
            } else {
                loader = container.children[0];
            }
            return container;
        }
    }, {
        key: 'bodyClass',
        get: function get() {
            return document.body.classList;
        }
    }]);

    return Loader;
}();

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = Loader;
//# sourceMappingURL=loader.js.map

/***/ },

/***/ 521:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(229)

/* template */
var __vue_template__ = __webpack_require__(572)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-app.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-a6b7e580", __vue_options__)
  } else {
    hotAPI.reload("data-v-a6b7e580", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-app.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 522:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(230)

/* template */
var __vue_template__ = __webpack_require__(559)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-entity.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-466abad8", __vue_options__)
  } else {
    hotAPI.reload("data-v-466abad8", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-entity.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 523:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(231)

/* template */
var __vue_template__ = __webpack_require__(555)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-list-settings-menu.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-3ab09b8b", __vue_options__)
  } else {
    hotAPI.reload("data-v-3ab09b8b", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-list-settings-menu.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 524:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(232)

/* template */
var __vue_template__ = __webpack_require__(539)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-list-settings.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-0727f35e", __vue_options__)
  } else {
    hotAPI.reload("data-v-0727f35e", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-list-settings.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 525:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(233)

/* template */
var __vue_template__ = __webpack_require__(554)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-method-list.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-390c34ae", __vue_options__)
  } else {
    hotAPI.reload("data-v-390c34ae", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-method-list.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 526:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(234)

/* template */
var __vue_template__ = __webpack_require__(551)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-method-signature.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-25adc486", __vue_options__)
  } else {
    hotAPI.reload("data-v-25adc486", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-method-signature.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 527:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(235)

/* template */
var __vue_template__ = __webpack_require__(540)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-method.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-0a17e092", __vue_options__)
  } else {
    hotAPI.reload("data-v-0a17e092", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-method.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 528:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(236)

/* template */
var __vue_template__ = __webpack_require__(538)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-property-list.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-06cec575", __vue_options__)
  } else {
    hotAPI.reload("data-v-06cec575", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-property-list.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 529:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(237)

/* template */
var __vue_template__ = __webpack_require__(547)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-source.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-1a1f6a68", __vue_options__)
  } else {
    hotAPI.reload("data-v-1a1f6a68", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-source.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 530:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(238)

/* template */
var __vue_template__ = __webpack_require__(565)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-tags.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-78667a0a", __vue_options__)
  } else {
    hotAPI.reload("data-v-78667a0a", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-tags.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 531:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(239)

/* template */
var __vue_template__ = __webpack_require__(542)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-tree.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-10fd21e2", __vue_options__)
  } else {
    hotAPI.reload("data-v-10fd21e2", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-tree.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 532:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(240)

/* template */
var __vue_template__ = __webpack_require__(566)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/components/phpdoc/pd-type.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (true) {(function () {
  var hotAPI = __webpack_require__(1)
  hotAPI.install(__webpack_require__(2), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-7c925cab", __vue_options__)
  } else {
    hotAPI.reload("data-v-7c925cab", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] pd-type.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 538:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return (_vm.file) ? _vm._h('ul', {
    staticClass: "phpdoc-property-list",
    class: {
      'compact': _vm.compact
    },
    style: (_vm.scrollStyle)
  }, [_vm._l((_vm.filteredProperties), function(property) {
    return _vm._h('li', {
      class: _vm.liClass.concat(_vm.active === property.name ? ['active'] : [])
    }, [_vm._h('a', {
      staticClass: "no-hover no-click",
      class: _vm.aClass,
      attrs: {
        "href": "javascript:;"
      },
      on: {
        "click": function($event) {
          $event.preventDefault();
          $event.stopPropagation();
          _vm.onPropertyClick(property)
        }
      }
    }, [(_vm.useIcon) ? _vm._h('i', {
      staticClass: "pr-xs",
      class: 'phpdoc-visibility-' + property.visibility
    }) : _vm._e(), " ", _vm._h('span', {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: (!_vm.useIcon),
        expression: "!useIcon"
      }],
      class: 'phpdoc-visibility-' + property.visibility
    }, [_vm._s(property.visibility)]), "\n            " + _vm._s(property.name) + " :\n            ", _vm._h('pd-type', {
      attrs: {
        "type": property.types,
        "no-tooltip": ""
      }
    }), " ", _vm._h('span', {
      staticClass: "description",
      domProps: {
        "innerHTML": _vm._s(property.description)
      }
    })]), " ", " ", (property.inherited) ? _vm._h('a', {
      staticClass: "nav-link nav-link-modifier nav-link-modifier-big no-click",
      attrs: {
        "href": "javascript:;"
      },
      on: {
        "click": function($event) {
          $event.preventDefault();
          $event.stopPropagation();
          _vm.$emit('inheritedClick', property)
        }
      }
    }, [_vm._h('c-popover', {
      attrs: {
        "popover-class": "popover-phpdoc",
        "trigger": "hover",
        "placement": "right",
        "effect": "fade"
      }
    }, [_vm._h('i', {
      staticClass: "phpdoc-modifier-inherited"
    }), " ", _vm._h('span', {
      slot: "content"
    }, ["\n                    Inherited from: ", _vm._h('br'), " ", _vm._h('pd-type', {
      attrs: {
        "type": property.full_name,
        "full-name": "",
        "no-tooltip": ""
      }
    })])])]) : _vm._e(), " ", " ", (property.static) ? _vm._h('a', {
      staticClass: "nav-link nav-link-modifier no-hover no-click",
      attrs: {
        "title": "Static",
        "href": "javascript:;"
      }
    }, [_vm._m(0, true)]) : _vm._e()])
  })]) : _vm._e()
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "phpdoc-modifier-static"
  })
}]}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-06cec575", module.exports)
  }
}

/***/ },

/***/ 539:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-list-settings"
  }, [_vm._h('form', {
    staticClass: "form-horizontal"
  }, [_vm._h('div', {
    staticClass: "row"
  }, [_vm._h('div', {
    staticClass: "col-md-6"
  }, [_vm._m(0), " ", _vm._h('div', {
    staticClass: "pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.inherited),
      expression: "inherited"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.inherited) ? _vm._i(_vm.inherited, null) > -1 : _vm._q(_vm.inherited, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.inherited,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.inherited = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.inherited = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.inherited = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._m(1), " Show inherited " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.public),
      expression: "public"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.public) ? _vm._i(_vm.public, null) > -1 : _vm._q(_vm.public, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.public,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.public = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.public = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.public = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._m(2), " Show public " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.protected),
      expression: "protected"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.protected) ? _vm._i(_vm.protected, null) > -1 : _vm._q(_vm.protected, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.protected,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.protected = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.protected = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.protected = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._m(3), " Show protected " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.private),
      expression: "private"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.private) ? _vm._i(_vm.private, null) > -1 : _vm._q(_vm.private, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.private,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.private = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.private = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.private = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._m(4), " Show private " + _vm._s(_vm.name)])])]), " ", _vm._h('div', {
    staticClass: "col-md-6"
  }, [_vm._m(5), " ", _vm._h('div', {
    staticClass: "form-group"
  }, [_vm._m(6), " ", _vm._h('div', {
    staticClass: "col-sm-12"
  }, [_vm._h('select', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortBy),
      expression: "sortBy"
    }],
    staticClass: "form-control",
    attrs: {
      "id": "sort-by"
    },
    on: {
      "change": function($event) {
        _vm.sortBy = Array.prototype.filter.call($event.target.options, function(o) {
          return o.selected
        }).map(function(o) {
          var val = "_value" in o ? o._value : o.value;
          return val
        })[0]
      }
    }
  }, [_vm._l((_vm.sortMethodsOptions), function(option) {
    return _vm._h('option', [_vm._s(option)])
  })])])]), " ", _vm._h('div', {
    staticClass: "form-group"
  }, [_vm._h('div', {
    staticClass: "radio col-sm-6"
  }, [_vm._h('label', [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortDir),
      expression: "sortDir"
    }],
    attrs: {
      "type": "radio",
      "value": "asc"
    },
    domProps: {
      "checked": _vm._q(_vm.sortDir, "asc")
    },
    on: {
      "change": function($event) {
        _vm.sortDir = "asc"
      }
    }
  }), " Ascending "])]), " ", _vm._h('div', {
    staticClass: "radio col-sm-6"
  }, [_vm._h('label', [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortDir),
      expression: "sortDir"
    }],
    attrs: {
      "type": "radio",
      "value": "desc"
    },
    domProps: {
      "checked": _vm._q(_vm.sortDir, "desc")
    },
    on: {
      "change": function($event) {
        _vm.sortDir = "desc"
      }
    }
  }), " Descending "])])]), " ", _vm._h('div', {
    staticClass: "form-group"
  }, [_vm._h('div', {
    staticClass: "btn-group btn-group-sm"
  }, [_vm._h('a', {
    staticClass: "pull-right btn btn-secondary",
    attrs: {
      "href": "#"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.resetFilters()
      }
    }
  }, ["Reset to default"]), " ", _vm._h('a', {
    staticClass: "pull-right btn btn-primary",
    attrs: {
      "href": "#"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.closeFilters()
      }
    }
  }, ["Close"])])])]), " ", _vm._m(7)])])])
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('h4', ["Filters"])
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-check"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-check"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-check"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-check"
  })
},function (){var _vm=this;
  return _vm._h('h4', ["Sorting"])
},function (){var _vm=this;
  return _vm._h('label', {
    staticClass: "col-sm-2 hide control-label",
    attrs: {
      "for": "sort-by"
    }
  }, ["Sort By"])
},function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "col-md-2 col-md-offset-1"
  }, [_vm._h('h4', [" "])])
}]}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-0727f35e", module.exports)
  }
}

/***/ },

/***/ 540:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-method"
  }, [(!_vm.method) ? _vm._h('c-centered', [_vm._h('c-loader')]) : _vm._e(), " ", (_vm.method) ? _vm._h('pd-method-signature', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.signature),
      expression: "show.signature"
    }],
    attrs: {
      "query": _vm.method.full_name
    }
  }) : _vm._e(), " ", (_vm.method) ? _vm._h('div', {
    staticClass: "method-details"
  }, [(_vm.has.description) ? _vm._h('h4', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.description),
      expression: "show.description"
    }],
    staticClass: "method-block-title"
  }, ["Description"]) : _vm._e(), " ", (_vm.has.description) ? _vm._h('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.description),
      expression: "show.description"
    }],
    staticClass: "method-block"
  }, [_vm._h('div', {
    domProps: {
      "innerHTML": _vm._s(_vm.method.description)
    }
  }), " ", (_vm.has['long-description']) ? _vm._h('div', {
    domProps: {
      "innerHTML": _vm._s(_vm.method['long-description'])
    }
  }) : _vm._e()]) : _vm._e(), " ", (_vm.tags.has('example')) ? _vm._h('h4', {
    staticClass: "method-block-title"
  }, ["Example"]) : _vm._e(), " ", (_vm.tags.has('example')) ? _vm._h('div', {
    staticClass: "method-block"
  }, [_vm._h('pre', {
    staticClass: "language-php line-numbers"
  }, [_vm._h('code', {
    domProps: {
      "innerHTML": _vm._s(_vm.tags.get('example').description)
    }
  })])]) : _vm._e(), " ", (_vm.has.tags) ? _vm._h('h4', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.tags),
      expression: "show.tags"
    }],
    staticClass: "method-block-title"
  }, ["Tags"]) : _vm._e(), " ", (_vm.has.tags) ? _vm._h('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.tags),
      expression: "show.tags"
    }],
    staticClass: "method-block"
  }, [_vm._h('pd-tags', {
    attrs: {
      "tags": _vm.method.tags,
      "exclude": _vm.excludeTags
    }
  })]) : _vm._e(), " ", (_vm.has.arguments) ? _vm._h('h4', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.arguments),
      expression: "show.arguments"
    }],
    staticClass: "method-block-title"
  }, ["Arguments"]) : _vm._e(), " ", (_vm.has.arguments) ? _vm._h('ol', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.arguments),
      expression: "show.arguments"
    }],
    staticClass: "method-block method-arguments"
  }, [_vm._l((_vm.method.arguments), function(argument) {
    return _vm._h('li', [_vm._h('div', {
      staticClass: "method-argument"
    }, [_vm._l((argument.types), function(type) {
      return _vm._h('span', [(_vm.$index > 0) ? _vm._h('span', ["|"]) : _vm._e(), " ", _vm._h('pd-type', {
        attrs: {
          "type": type,
          "fqn": false
        }
      })])
    }), " ", _vm._h('span', {
      staticClass: "color-cyan-900"
    }, [" " + _vm._s(argument.name)]), " ", (argument.default.length > 0) ? _vm._h('span', [" = " + _vm._s(argument.default)]) : _vm._e()]), " ", (argument.description && argument.description.length > 0) ? _vm._h('div', {
      staticClass: "method-block"
    }, [_vm._h('span', {
      domProps: {
        "innerHTML": _vm._s(argument.description)
      }
    }), " ", (argument['long-description'] && argument['long-description'].length > 0) ? _vm._h('div', {
      domProps: {
        "innerHTML": _vm._s(argument['long-description'])
      }
    }) : _vm._e()]) : _vm._e()])
  })]) : _vm._e(), " ", (_vm.has.returns) ? _vm._h('h4', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.returns),
      expression: "show.returns"
    }],
    staticClass: "method-block-title"
  }, ["Returns"]) : _vm._e(), " ", (_vm.has.returns) ? _vm._h('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.returns),
      expression: "show.returns"
    }],
    staticClass: "method-block"
  }, [_vm._h('pd-type', {
    attrs: {
      "type": _vm.method.returns
    },
    on: {
      "click": _vm.onTypeClick
    }
  }), " "]) : _vm._e()]) : _vm._e()])
},staticRenderFns: []}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-0a17e092", module.exports)
  }
}

/***/ },

/***/ 542:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-tree",
    style: (_vm.scrollStyle)
  })
},staticRenderFns: []}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-10fd21e2", module.exports)
  }
}

/***/ },

/***/ 547:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._m(0)
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-source"
  })
}]}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-1a1f6a68", module.exports)
  }
}

/***/ },

/***/ 551:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return (_vm.method) ? _vm._h('div', {
    staticClass: "phpdoc-method-signature"
  }, [(_vm.method.static) ? _vm._h('span', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.modifiers),
      expression: "show.modifiers"
    }],
    staticClass: "phpdoc-modifier-static"
  }, ["static "]) : _vm._e(), _vm._h('span', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.modifiers),
      expression: "show.modifiers"
    }],
    class: ['phpdoc-visibility-' + _vm.method.visibility]
  }, [_vm._s(_vm.method.visibility) + " "]), (_vm.method.abstract) ? _vm._h('span', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.modifiers),
      expression: "show.modifiers"
    }],
    staticClass: "phpdoc-modifier-abstract"
  }, ["abstract "]) : _vm._e(), _vm._s(_vm.method.name) + " ", _vm._m(0), " ", _vm._l((_vm.method.arguments), function(argument, argumentIndex) {
    return _vm._h('span', {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: (_vm.show.arguments),
        expression: "show.arguments"
      }]
    }, [(argumentIndex !== 0) ? _vm._h('strong', [","]) : _vm._e(), " ", _vm._h('pd-type', {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: (_vm.show.argumentTypes),
        expression: "show.argumentTypes"
      }],
      attrs: {
        "type": argument.types,
        "no-tooltip": _vm.noTooltip
      }
    }), " ", _vm._h('span', {
      staticClass: "color-cyan-900"
    }, [_vm._s(argument.name)]), " ", (argument.default.length > 0) ? _vm._h('span', {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: (_vm.show.argumentDefaults),
        expression: "show.argumentDefaults"
      }],
      staticClass: "color-grey-700 fs-10"
    }, [" = " + _vm._s(argument.default)]) : _vm._e()])
  }), " ", _vm._m(1), " ", (_vm.method.returns && _vm.method.returns.length > 0) ? _vm._h('span', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.return),
      expression: "show.return"
    }]
  }, [_vm._s(_vm.returnCharacter)]) : _vm._e(), " ", (_vm.method.returns) ? _vm._h('pd-type', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: (_vm.show.return),
      expression: "show.return"
    }],
    attrs: {
      "type": _vm.method.returns,
      "no-tooltip": _vm.noTooltip
    }
  }) : _vm._e()]) : _vm._e()
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('strong', ["("])
},function (){var _vm=this;
  return _vm._h('strong', [")"])
}]}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-25adc486", module.exports)
  }
}

/***/ },

/***/ 554:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('ul', {
    staticClass: "phpdoc-method-list",
    style: (_vm.scrollStyle)
  }, [(!_vm.file) ? _vm._h('c-centered', [_vm._h('c-loader')]) : _vm._e(), " ", (_vm.file && _vm.file.entity.methods.length === 0) ? _vm._h('li', {
    staticClass: "nav-item"
  }, [_vm._h('a', {
    staticClass: "nav-link no-click",
    attrs: {
      "href": "javascript:;"
    }
  }, ["This " + _vm._s(_vm.file.type) + " does not contain any methods"])]) : _vm._e(), " ", _vm._l((_vm.filteredMethods), function(method) {
    return (_vm.file) ? _vm._h('li', {
      class: _vm.liClass.concat(_vm.active === method.name ? ['active'] : [])
    }, [_vm._h('a', {
      class: _vm.aClass,
      attrs: {
        "href": "javascript:;"
      },
      on: {
        "click": function($event) {
          $event.preventDefault();
          $event.stopPropagation();
          _vm.onMethodClick(method)
        }
      }
    }, [_vm._h('i', {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: (!_vm.hideIcon),
        expression: "!hideIcon"
      }],
      staticClass: "pr-xs",
      class: 'phpdoc-visibility-' + method.visibility
    }), " ", (_vm.useSignature === false) ? _vm._h('span', [_vm._s(method.name)]) : _vm._e(), " ", (_vm.useSignature) ? _vm._h('pd-method-signature', {
      attrs: {
        "query": method.full_name,
        "hide-modifiers": _vm.signatureHideModifiers,
        "hide-argument-types": _vm.signatureHideArgumentTypes,
        "hide-argument-defaults": _vm.signatureHideArgumentDefaults,
        "hide-return": _vm.signatureHideReturn
      }
    }) : _vm._e()]), " ", " ", (method.inherited) ? _vm._h('a', {
      staticClass: "nav-link nav-link-modifier",
      attrs: {
        "href": "javascript:;"
      },
      on: {
        "click": function($event) {
          $event.preventDefault();
          $event.stopPropagation();
          _vm.$emit('inheritedClick', method)
        }
      }
    }, [_vm._h('c-popover', {
      attrs: {
        "popover-class": "popover-phpdoc",
        "trigger": "hover",
        "placement": "right",
        "effect": "fade"
      }
    }, [_vm._h('i', {
      staticClass: "phpdoc-modifier-inherited"
    }), " ", _vm._h('span', {
      slot: "content"
    }, ["\n                    Inherited from: ", _vm._h('br'), " ", _vm._h('pd-type', {
      attrs: {
        "type": method.full_name,
        "full-name": "",
        "no-tooltip": ""
      }
    })])])]) : _vm._e(), " ", " ", (method.static) ? _vm._h('a', {
      staticClass: "nav-link nav-link-modifier no-click",
      attrs: {
        "title": "Static",
        "href": "javascript:;"
      }
    }, [_vm._m(0, true)]) : _vm._e(), " ", " ", (method.abstract) ? _vm._h('a', {
      staticClass: "nav-link nav-link-modifier no-click",
      attrs: {
        "title": "Abstract",
        "href": "javascript:;"
      }
    }, [_vm._m(1, true)]) : _vm._e(), " ", " ", (method.final) ? _vm._h('a', {
      staticClass: "nav-link nav-link-modifier no-click",
      attrs: {
        "title": "Final",
        "href": "javascript:;"
      }
    }, [_vm._m(2, true)]) : _vm._e()]) : _vm._e()
  })])
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "phpdoc-modifier-static"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "phpdoc-modifier-abstract"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "phpdoc-modifier-final"
  })
}]}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-390c34ae", module.exports)
  }
}

/***/ },

/***/ 555:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', [_vm._h('div', {
    on: {
      "contextmenu": function($event) {
        $event.preventDefault();
        _vm.$refs.ctxMenu.open($event)
      }
    }
  }, [_vm._t("default")]), " ", _vm._h('c-context-menu', {
    ref: "ctxMenu",
    attrs: {
      "id": "context-menu"
    }
  }, [_vm._h('form', [_vm._h('h6', {
    staticClass: "dropdown-header"
  }, ["Settings"]), " ", _vm._h('div', {
    staticClass: "dropdown-item pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.inherited),
      expression: "inherited"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.inherited) ? _vm._i(_vm.inherited, null) > -1 : _vm._q(_vm.inherited, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.inherited,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.inherited = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.inherited = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.inherited = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._h('i', {
    staticClass: "fa fa-check"
  }), " Show inherited " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "dropdown-item pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.public),
      expression: "public"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.public) ? _vm._i(_vm.public, null) > -1 : _vm._q(_vm.public, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.public,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.public = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.public = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.public = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._h('i', {
    staticClass: "fa fa-check"
  }), " Show public " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "dropdown-item pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.protected),
      expression: "protected"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.protected) ? _vm._i(_vm.protected, null) > -1 : _vm._q(_vm.protected, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.protected,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.protected = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.protected = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.protected = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._h('i', {
    staticClass: "fa fa-check"
  }), " Show protected " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "dropdown-item pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.private),
      expression: "private"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.private) ? _vm._i(_vm.private, null) > -1 : _vm._q(_vm.private, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.private,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.private = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.private = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.private = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._h('i', {
    staticClass: "fa fa-check"
  }), " Show private " + _vm._s(_vm.name)])]), " ", _vm._h('label', {
    staticClass: "dropdown-header",
    attrs: {
      "for": "sort-by"
    }
  }, ["Settings"]), " ", _vm._h('div', {
    staticClass: "dropdown-item"
  }, [_vm._h('select', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortBy),
      expression: "sortBy"
    }],
    staticClass: "form-control",
    attrs: {
      "id": "sort-by"
    },
    on: {
      "change": function($event) {
        _vm.sortBy = Array.prototype.filter.call($event.target.options, function(o) {
          return o.selected
        }).map(function(o) {
          var val = "_value" in o ? o._value : o.value;
          return val
        })[0]
      }
    }
  }, [_vm._l((_vm.sortMethodsOptions), function(option) {
    return _vm._h('option', [_vm._s(option)])
  })])]), " ", _vm._h('div', {
    staticClass: "dropdown-item"
  }, [_vm._h('label', [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortDir),
      expression: "sortDir"
    }],
    attrs: {
      "type": "radio",
      "value": "asc"
    },
    domProps: {
      "checked": _vm._q(_vm.sortDir, "asc")
    },
    on: {
      "change": function($event) {
        _vm.sortDir = "asc"
      }
    }
  }), " Ascending "])]), " ", _vm._h('div', {
    staticClass: "dropdown-item"
  }, [_vm._h('label', [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortDir),
      expression: "sortDir"
    }],
    attrs: {
      "type": "radio",
      "value": "desc"
    },
    domProps: {
      "checked": _vm._q(_vm.sortDir, "desc")
    },
    on: {
      "change": function($event) {
        _vm.sortDir = "desc"
      }
    }
  }), " Descending "])]), " ", _vm._h('div', {
    staticClass: "dropdown-item"
  }, [_vm._h('a', {
    staticClass: "btn btn-secondary btn-block",
    attrs: {
      "href": "#"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.resetSettings()
      }
    }
  }, ["Reset to default"])]), " ", _vm._h('div', {
    staticClass: "dropdown-item"
  }, [_vm._h('a', {
    staticClass: "btn btn-primary btn-block",
    attrs: {
      "href": "#"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.closeMenu()
      }
    }
  }, ["Close"])])])])])
},staticRenderFns: []}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-3ab09b8b", module.exports)
  }
}

/***/ },

/***/ 559:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-entity"
  }, [(!_vm.file) ? _vm._h('c-centered', [_vm._h('c-loader')]) : _vm._e(), " ", (_vm.file) ? _vm._h('div', [_vm._h('header', {
    staticClass: "phpdoc-header"
  }, [_vm._h('i', {
    class: 'phpdoc-type-' + _vm.file.type
  }), " ", _vm._h('h3', {
    staticClass: "header-title"
  }, [_vm._h('span', {
    class: 'phpdoc-type-' + _vm.file.type
  }, [_vm._s(_vm._f("removeStartSlash")(_vm.entity.full_name))]), " ", (_vm.hasExtend) ? _vm._h('small', {
    staticClass: "pl-xs fs-13"
  }, ["extends"]) : _vm._e(), " ", (_vm.hasExtend) ? _vm._h('pd-type', {
    staticClass: "fs-13",
    attrs: {
      "type": _vm.entity.extends
    }
  }) : _vm._e()])]), " ", " ", _vm._h('div', {
    staticClass: "phpdoc-block"
  }, [(_vm.hasDescription) ? _vm._h('p', {
    staticClass: "fs-13",
    domProps: {
      "innerHTML": _vm._s(_vm.entity.description)
    }
  }) : _vm._e(), " ", _vm._h('pd-tags', {
    attrs: {
      "object": _vm.entity,
      "exclude": ['example', 'inherited_from']
    }
  })]), " ", _vm._h('div', {
    staticClass: "phpdoc-block"
  }, [_vm._h('pd-tags', {
    attrs: {
      "tags": _vm.entity.tags,
      "exclude": ['example', 'inherited_from']
    }
  })]), " ", (_vm.withProperties) ? _vm._h('div', {
    staticClass: "phpdoc-block"
  }, [_vm._h('pd-property-list', {
    attrs: {
      "query": _vm.query,
      "compact": ""
    }
  })]) : _vm._e()]) : _vm._e()])
},staticRenderFns: []}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-466abad8", module.exports)
  }
}

/***/ },

/***/ 565:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-tags"
  }, [(_vm.filteredTags.length > 0) ? _vm._h('table', {
    staticClass: "table table-tags"
  }, [_vm._h('tbody', [_vm._l((_vm.filteredTags), function(tag) {
    return _vm._h('tr', [_vm._h('th', {
      attrs: {
        "width": "150",
        "valign": "middle"
      }
    }, [_vm._s(tag.name)]), " ", _vm._h('td', {
      attrs: {
        "colspan": tag.type ? 1 : 2
      }
    }, [(tag.description.length > 0) ? _vm._h('span', {
      domProps: {
        "innerHTML": _vm._s(tag.description)
      }
    }) : _vm._e()]), " ", (tag.type) ? _vm._h('td', [_vm._h('pd-type', {
      attrs: {
        "type": tag.type
      }
    })]) : _vm._e()])
  })])]) : _vm._e()])
},staticRenderFns: []}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-78667a0a", module.exports)
  }
}

/***/ },

/***/ 566:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('span', [_vm._l((_vm.types), function(type, itype) {
    return _vm._h('span', [(type.isPrimitive) ? _vm._h('span', {
      class: type.cssClass
    }, [_vm._s(type.name)]) : _vm._e(), " ", " ", (type.isEntity && _vm.showTooltip === false) ? _vm._h('a', {
      class: type.cssClass,
      attrs: {
        "href": "javascript:;"
      },
      on: {
        "click": function($event) {
          $event.preventDefault();
          $event.stopPropagation();
          _vm.onEntityClick(type)
        }
      }
    }, [_vm._s(_vm.fullName ? type.fullName : type.name)]) : _vm._e(), " ", (type.isEntity && _vm.showTooltip === true) ? _vm._h('c-popover', {
      attrs: {
        "popover-class": "popover-phpdoc",
        "trigger": "hover",
        "placement": "top",
        "effect": "fade"
      }
    }, [_vm._h('a', {
      class: type.cssClass,
      attrs: {
        "href": "javascript:;"
      },
      on: {
        "click": function($event) {
          $event.preventDefault();
          $event.stopPropagation();
          _vm.onEntityClick(type)
        }
      }
    }, [_vm._s(_vm.fullName ? type.fullName : type.name)]), " ", _vm._h('span', {
      slot: "content",
      class: type.cssClass
    }, ["\n                " + _vm._s(type.fullName) + "\n            "])]) : _vm._e(), " ", (_vm.seperator.length > 0) ? _vm._h('span', {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: (itype < _vm.types.length - 1),
        expression: "itype < types.length -1"
      }],
      staticClass: "type-seperator"
    }, [_vm._s(_vm.seperator) + " "]) : _vm._e()])
  })])
},staticRenderFns: []}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-7c925cab", module.exports)
  }
}

/***/ },

/***/ 572:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-app",
    style: (_vm.style)
  }, [(!_vm.file || _vm.loading) ? _vm._h('c-centered', [_vm._h('c-loader')]) : _vm._e(), " ", (_vm.file && !_vm.loading) ? _vm._h('div', {
    staticClass: "row"
  }, [_vm._h('div', {
    staticClass: "col-md-12"
  }, [_vm._h('c-drag-zone', {
    staticClass: "zone"
  }, [_vm._h('div', {
    directives: [{
      name: "scrollable",
      rawName: "v-scrollable",
      value: (_vm.height),
      expression: "height"
    }],
    staticClass: "item"
  }, [_vm._h('pd-tree', {
    ref: "tree",
    attrs: {
      "query": _vm.entity.full_name
    },
    on: {
      "select": _vm.onTreeSelect
    }
  })]), " ", " ", _vm._h('c-drag-zone-handle', {
    staticClass: "handle",
    on: {
      "change": _vm.saveZoneWidths
    }
  }), " ", " ", _vm._h('div', {
    directives: [{
      name: "scrollable",
      rawName: "v-scrollable",
      value: (_vm.height),
      expression: "height"
    }],
    staticClass: "item"
  }, [_vm._h('pd-entity', {
    ref: "entity",
    attrs: {
      "query": _vm.entity.full_name
    }
  }), " ", _vm._h('div', {
    staticClass: "tabbable phpdoc-tabs"
  }, [_vm._h('ul', {
    staticClass: "nav nav-tabs phpdoc-tabs-nav",
    attrs: {
      "role": "tablist"
    }
  }, [_vm._h('li', {
    staticClass: "nav-item",
    class: {
      'active': _vm.isActive('methods')
    },
    attrs: {
      "role": "presentation"
    }
  }, [_vm._h('a', {
    staticClass: "nav-link",
    attrs: {
      "href": "javascript:;",
      "aria-controls": "phpdoc-methods",
      "role": "tab"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.setActive('methods')
      }
    }
  }, ["Methods"])]), " ", (_vm.file.type !== 'interface') ? _vm._h('li', {
    staticClass: "nav-item",
    class: {
      'active': _vm.isActive('properties')
    },
    attrs: {
      "role": "presentation"
    }
  }, [_vm._h('a', {
    staticClass: "nav-link",
    attrs: {
      "href": "javascript:;",
      "aria-controls": "phpdoc-properties",
      "role": "tab"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.setActive('properties')
      }
    }
  }, ["Properties"])]) : _vm._e(), " ", _vm._h('li', {
    staticClass: "nav-item",
    class: {
      'active': _vm.isActive('source')
    },
    attrs: {
      "role": "presentation"
    }
  }, [_vm._h('a', {
    staticClass: "nav-link",
    attrs: {
      "href": "javascript:;",
      "aria-controls": "phpdoc-source",
      "role": "tab"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.setActive('source')
      }
    }
  }, ["Source"])])]), " ", _vm._h('div', {
    ref: "tabContent",
    staticClass: "tab-content"
  }, [_vm._h('div', {
    staticClass: "tab-pane phpdoc-tab-methods",
    class: {
      'active': _vm.isActive('methods')
    },
    attrs: {
      "role": "tabpanel"
    }
  }, [_vm._h('div', {
    staticClass: "tabbable tabs-left"
  }, [_vm._h('pd-list-settings-menu', {
    attrs: {
      "list": "methodList",
      "type": "methods"
    }
  }, [_vm._h('pd-method-list', {
    ref: "methodList",
    attrs: {
      "query": _vm.entity.full_name,
      "use-signature": "",
      "signature-hide-modifiers": "",
      "signature-hide-argument-types": "",
      "signature-hide-argument-defaults": "",
      "signature-hide-argument-return": "",
      "signature-hide-return": "",
      "selectable": "",
      "store-settings": ""
    },
    on: {
      "select": _vm.onMethodSelect
    }
  })]), " ", _vm._h('p', {
    staticClass: "text-sm-right pr-sm fs-10"
  }, ["Right-click the methods for more options"])])]), " ", _vm._h('div', {
    staticClass: "tab-pane phpdoc-tab-properties",
    class: {
      'active': _vm.isActive('properties')
    },
    attrs: {
      "role": "tabpanel"
    }
  }, [_vm._h('div', {
    staticClass: "tabbable tabs-left"
  }, [_vm._h('pd-property-list', {
    ref: "propertyList",
    attrs: {
      "query": _vm.entity.full_name
    }
  })])]), " ", _vm._h('div', {
    staticClass: "tab-pane phpdoc-tab-source",
    attrs: {
      "role": "tabpanel"
    }
  })])])]), " ", " ", _vm._h('c-drag-zone-handle', {
    staticClass: "handle",
    on: {
      "change": _vm.saveZoneWidths
    }
  }), " ", " ", _vm._h('div', {
    directives: [{
      name: "scrollable",
      rawName: "v-scrollable",
      value: (_vm.height),
      expression: "height"
    }],
    staticClass: "item"
  }, [(_vm.content === 'method' && _vm.methodQuery) ? _vm._h('pd-method', {
    ref: "method",
    attrs: {
      "query": _vm.methodQuery
    }
  }) : _vm._e(), " ", (_vm.content === 'source') ? _vm._h('pd-source', {
    ref: "source",
    attrs: {
      "query": _vm.entity.full_name
    }
  }) : _vm._e()])])])]) : _vm._e()])
},staticRenderFns: []}
if (true) {
  module.hot.accept()
  if (module.hot.data) {
     __webpack_require__(1).rerender("data-v-a6b7e580", module.exports)
  }
}

/***/ },

/***/ 602:
false,

/***/ 603:
false,

/***/ 604:
false,

/***/ 605:
false,

/***/ 606:
false,

/***/ 607:
false,

/***/ 608:
false,

/***/ 609:
false,

/***/ 610:
false,

/***/ 611:
false,

/***/ 612:
false,

/***/ 613:
false,

/***/ 614:
false,

/***/ 615:
false,

/***/ 616:
false,

/***/ 621:
false,

/***/ 622:
false,

/***/ 623:
false,

/***/ 624:
false,

/***/ 625:
false,

/***/ 626:
false,

/***/ 627:
false,

/***/ 628:
false,

/***/ 629:
false,

/***/ 630:
false,

/***/ 631:
false,

/***/ 633:
false,

/***/ 635:
false,

/***/ 636:
false,

/***/ 637:
false,

/***/ 638:
false,

/***/ 639:
false,

/***/ 64:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(_) {

var vuex_1 = __webpack_require__(9);
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    mixins: [],
    data: function data() {
        return {
            resize: 0
        };
    },

    computed: vuex_1.mapGetters(['heights']),
    mounted: function mounted() {
        window.addEventListener('resize', this.handleResize);
    },
    beforeDestroy: function beforeDestroy() {
        window.removeEventListener('resize', this.handleResize);
    },

    methods: _.merge(vuex_1.mapActions(['updateHeights']), {
        handleResize: function handleResize(event) {
            var _this = this;

            if (this.resize) clearTimeout(this.resize);
            this.resize = setTimeout(function () {
                _this.$emit('resize');
            }, 50);
        }
    })
};
//# sourceMappingURL=resize.js.map
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ },

/***/ 640:
false,

/***/ 641:
false,

/***/ 642:
false,

/***/ 643:
false,

/***/ 644:
false,

/***/ 645:
false,

/***/ 646:
false,

/***/ 647:
false,

/***/ 65:
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.scrollable = {
    props: {
        scrollable: Boolean,
        maxHeight: Number,
        height: Number,
        minHeight: Number
    },
    mounted: function mounted() {
        var classList = this.$el.classList;
        if (this.scrollable) {
            if (!classList.contains('scrollable')) {
                classList.add('scrollable');
            }
        }
    },

    computed: {
        scrollStyle: function scrollStyle() {
            var style = {};
            if (this.scrollable) {
                if (this.height) {
                    style['height'] = parseInt(this.height) + 'px';
                } else {
                    if (this.minHeight) {
                        style['minHeight'] = parseInt(this.minHeight) + 'px';
                    }
                    if (this.maxHeight) {
                        style['maxHeight'] = parseInt(this.maxHeight) + 'px';
                    }
                }
            }
            return style;
        }
    }
};
//# sourceMappingURL=scrollable.js.map

/***/ },

/***/ 68:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(_) {

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var Vue = __webpack_require__(2);
var api = Vue.codex.api;
function defaultOptions() {
    var defaults = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var project = Vue.codex.project,
        ref = Vue.codex.ref;
    return { params: _.merge({ project: project, ref: ref }, defaults, params) };
}
function getEntities() {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee() {
        return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
                switch (_context.prev = _context.next) {
                    case 0:
                        return _context.abrupt("return", new Promise(function (resolve, reject) {
                            api.get('phpdoc/entities', defaultOptions({ tree: false, full: false }, params)).catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data);
                            });
                        }));

                    case 1:
                    case "end":
                        return _context.stop();
                }
            }
        }, _callee, this);
    }));
}
exports.getEntities = getEntities;
function getEntity(entity) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee2() {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
                switch (_context2.prev = _context2.next) {
                    case 0:
                        if (!(entity === undefined)) {
                            _context2.next = 3;
                            break;
                        }

                        console.trace('entity undefined');
                        throw new Error('entity undefined');

                    case 3:
                        return _context2.abrupt("return", new Promise(function (resolve, reject) {
                            api.get('phpdoc/entity', defaultOptions({ entity: entity }, params)).catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data);
                            });
                        }));

                    case 4:
                    case "end":
                        return _context2.stop();
                }
            }
        }, _callee2, this);
    }));
}
exports.getEntity = getEntity;
function getMethod(entity, method) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee3() {
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
            while (1) {
                switch (_context3.prev = _context3.next) {
                    case 0:
                        return _context3.abrupt("return", new Promise(function (resolve, reject) {
                            api.get('phpdoc/method', defaultOptions({ entity: entity, method: method }, params)).catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data);
                            });
                        }));

                    case 1:
                    case "end":
                        return _context3.stop();
                }
            }
        }, _callee3, this);
    }));
}
exports.getMethod = getMethod;
function getProperty(entity, property) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee4() {
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
            while (1) {
                switch (_context4.prev = _context4.next) {
                    case 0:
                        return _context4.abrupt("return", new Promise(function (resolve, reject) {
                            api.get('phpdoc/method', defaultOptions({ entity: entity, property: property }, params)).catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data);
                            });
                        }));

                    case 1:
                    case "end":
                        return _context4.stop();
                }
            }
        }, _callee4, this);
    }));
}
exports.getProperty = getProperty;
//# sourceMappingURL=api.js.map
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ },

/***/ 73:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(_) {

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function removeStartSlash(value) {
    if (value === undefined) {
        return;
    }
    var matches = value.match(/^\\(.*)/);
    if (matches !== null && matches.length === 2) {
        return matches[1];
    }
    return value;
}
exports.removeStartSlash = removeStartSlash;
;
function Type(name) {
    this.type = name;
    this.name = name;
    this.fullName = name;
    this.entities = Vue.codex.store.getters.entities;
    this.isEntity = this.name[0] === '\\';
    this.isPrimitive = this.isEntity === false;
    this.isLocal = false;
    this.isExternal = false;
    this.entity = {};
    var classes = [];
    if (this.isEntity) {
        this.fullName = removeStartSlash(this.name);
        this.name = _.last(this.type.split('\\'));
        this.isExternal = true;
        if (this.entities) {
            this.entity = _.find(this.entities, { full_name: this.type });
            this.isLocal = this.entity !== undefined;
            this.isExternal = !this.isLocal;
        }
        classes.push('phpdoc-type-' + (this.isLocal ? this.entity.type : 'external'));
    } else {
        classes.push('phpdoc-type-simple');
        classes.push('phpdoc-type-simple-' + this.type);
    }
    this.cssClass = classes.join(' ');
}
exports.Type = Type;
function parseFullName(fullName) {
    return parseRef(fullName);
}
exports.parseFullName = parseFullName;
function parseRef(ref) {
    return Query.from(ref);
}
exports.parseRef = parseRef;

var Query = function () {
    function Query(query) {
        _classCallCheck(this, Query);

        this.query = query;
        this.isEntity = false;
        this.isMethod = false;
        this.isProperty = false;
        this.entityName = null;
        this.methodName = null;
        this.propertyName = null;
        if (query.indexOf('::') !== -1) {
            this.entityName = query.split('::')[0];
            if (query.indexOf('()') !== -1) {
                this.methodName = query.split('::')[1].replace('()', '');
                this.isMethod = true;
            } else {
                this.propertyName = query.split('::')[1];
                this.isProperty = true;
            }
        } else {
            this.entityName = query;
            this.isEntity = true;
        }
        if (this.entityName[0] !== '\\') {
            this.entityName = '\\' + this.entityName;
        }
    }

    _createClass(Query, [{
        key: 'toString',
        value: function toString() {
            return this.query;
        }
    }], [{
        key: 'from',
        value: function from(query) {
            return new Query(query);
        }
    }]);

    return Query;
}();

exports.Query = Query;

var Tags = function () {
    function Tags() {
        var tags = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

        _classCallCheck(this, Tags);

        this.tags = tags;
    }

    _createClass(Tags, [{
        key: 'has',
        value: function has(name) {
            return this.get(name) !== undefined;
        }
    }, {
        key: 'get',
        value: function get(name) {
            return _.find(this.tags, { name: name });
        }
    }, {
        key: 'where',
        value: function where(k, v) {
            return _.find(this.tags, _defineProperty({}, k, v));
        }
    }, {
        key: 'exclude',
        value: function exclude(vals) {
            var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'name';

            return new Tags(_.filter(this.tags, function (tag) {
                return vals.indexOf(tag[key]) === -1;
            }));
        }
    }, {
        key: 'toArray',
        value: function toArray() {
            return this.tags;
        }
    }, {
        key: 'isEmpty',
        value: function isEmpty() {
            return this.tags.length === 0;
        }
    }, {
        key: 'length',
        get: function get() {
            return this.tags.length;
        }
    }]);

    return Tags;
}();

exports.Tags = Tags;
//# sourceMappingURL=general.js.map
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ },

/***/ 90:
false

})
//# sourceMappingURL=2.1b655ff329413a62afa8.hot-update.js.map