webpackHotUpdate(2,{

/***/ 235:
/***/ function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vuex = __webpack_require__(9);

var _lodash = __webpack_require__(6);

var _utils = __webpack_require__(49);

var _mixins = __webpack_require__(32);

exports.default = {
    name: 'pd-method',
    mixins: [_mixins.methodRefComponent],
    props: {
        hide: { type: String, default: '' }
    },
    data: function data() {
        return {
            excludeTags: ['param', 'example', 'return'],
            tags: new _utils.Tags()
        };
    },
    mounted: function mounted() {},

    watch: {
        method: function method(newVal) {
            var _this = this;

            if (this.hasData(this.method.returns)) {
                this.method.returns = this.method.returns.map(function (returns) {
                    if (returns === 'static') return _this.method.class_name;
                    return returns;
                });
            }
            this.$events.$emit('phpdoc:method:change', newVal);
            this.tags = new _utils.Tags(newVal.tags).exclude(this.excludeTags).toArray();

            setTimeout(function () {
                return _this.$nextTick(function () {
                    if (window['Prism']) window['Prism'].highlightAll();
                });
            }, 510);
        }
    },
    computed: {
        has: function has() {
            var m = this.method;
            return {
                tags: !this.tags.exclude(this.excludeTags).isEmpty(),
                returns: this.hasData(m.returns),
                description: this.hasData(m.description),
                'long-description': this.hasData(m['long-description']),
                arguments: this.hasData(m.arguments)
            };
        },
        show: function show() {
            var hidden = this.hide.split(',');
            var blocks = ['signature', 'description', 'example', 'tags', 'arguments', 'returns'];
            var show = {};
            blocks.forEach(function (block) {
                return show[block] = hidden.indexOf(block) === -1;
            });
            return show;
        },
        example: function example() {
            return (0, _lodash.find)(this.tags, { name: 'example' });
        }
    },
    methods: {
        hasData: function hasData(what) {
            return what !== undefined && what.length > 0;
        },
        filterTags: function filterTags(tags) {
            var _this2 = this;

            return (0, _lodash.filter)(tags, function (tag) {
                return _this2.excludeTags.indexOf(tag.name) === -1;
            });
        },
        onTypeClick: function onTypeClick() {}
    }
}; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/***/ }

})
//# sourceMappingURL=2.426ba9eef19f8e9dbce9.hot-update.js.map