webpackHotUpdate(2,{

/***/ 251:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var _mutations;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments)).next());
    });
};
var Vue = __webpack_require__(2);
var lodash_1 = __webpack_require__(6);
var api = __webpack_require__(602);
var util_1 = __webpack_require__(86);
var bag = util_1.Storage.hasBag('codex.phpdoc') ? util_1.Storage.getBag('codex.phpdoc') : util_1.Storage.createBag('codex.phpdoc', util_1.StorageProvider.LOCAL);
var emit = function emit() {
    for (var _len = arguments.length, params = Array(_len), _key = 0; _key < _len; _key++) {
        params[_key] = arguments[_key];
    }

    return Vue.codex.eventHub.$emit.apply(Vue.codex.eventHub, params);
};
exports.types = {
    SET_PROJECT: 'phpdoc/SET_PROJECT',
    UPDATE_TREE: 'phpdoc/UPDATE_TREE',
    SET_FILE: 'phpdoc/SET_FILE',
    SET_LOADING: 'phpdoc/SET_LOADING',
    UPDATE_ENTITIES: 'phpdoc/UPDATE_ENTITIES',
    UPDATE_METHODS_SETTINGS: 'phpdoc/UPDATE_METHODS_SETTINGS',
    UPDATE_PROPERTIES_SETTINGS: 'phpdoc/UPDATE_PROPERTIES_SETTINGS'
};
function getSettings() {
    return {
        show: {
            inherited: false,
            public: true,
            protected: true,
            private: true
        },
        sort: {
            by: '',
            dir: 'asc'
        },
        view: ''
    };
}
var state = {
    project: '',
    ref: '',
    fullName: '',
    tree: undefined,
    entities: [],
    file: undefined,
    loading: {
        tree: true,
        content: true
    },
    settings: {
        methods: bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings(),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings()
    }
};
exports.module = {
    state: state,
    mutations: (_mutations = {}, _defineProperty(_mutations, exports.types.SET_PROJECT, function (state, project) {
        state.project = project.name;
        state.ref = project.ref;
        emit(exports.types.SET_PROJECT);
    }), _defineProperty(_mutations, exports.types.SET_LOADING, function (state, loading) {
        if (typeof loading.tree === 'boolean') state.loading.tree = loading.tree;
        if (typeof loading.content === 'boolean') state.loading.content = loading.content;
        emit(exports.types.SET_LOADING);
    }), _defineProperty(_mutations, exports.types.UPDATE_ENTITIES, function (state, entities) {
        state.entities = entities;
        emit(exports.types.UPDATE_ENTITIES);
    }), _defineProperty(_mutations, exports.types.UPDATE_TREE, function (state, tree) {
        state.tree = tree;
        emit(exports.types.UPDATE_TREE);
    }), _defineProperty(_mutations, exports.types.SET_FILE, function (state, file) {
        state.file = file;
        state.fullName = file.entity.full_name;
        emit(exports.types.SET_FILE);
    }), _defineProperty(_mutations, exports.types.UPDATE_METHODS_SETTINGS, function (state, settings) {
        state.settings.methods = lodash_1.merge({}, state.settings.methods, settings);
        bag.set('settings.methods', state.settings.methods, { json: true });
        emit(exports.types.UPDATE_METHODS_SETTINGS);
    }), _defineProperty(_mutations, exports.types.UPDATE_PROPERTIES_SETTINGS, function (state, settings) {
        state.settings.properties = lodash_1.merge({}, state.settings.properties, settings);
        bag.set('settings.properties', state.settings.properties, { json: true });
        emit(exports.types.UPDATE_PROPERTIES_SETTINGS);
    }), _mutations),
    actions: {
        updatePhpdocEntities: function updatePhpdocEntities(_ref) {
            var state = _ref.state,
                commit = _ref.commit,
                dispatch = _ref.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee() {
                return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                dispatch('setPhpdocTreeLoading', true);
                                api.getEntities(state.project, state.ref, { tree: true }).then(function (tree) {
                                    commit(exports.types.UPDATE_TREE, tree);
                                });
                                _context.next = 4;
                                return api.getEntities(state.project, state.ref).then(function (entities) {
                                    commit(exports.types.UPDATE_ENTITIES, entities);
                                    dispatch('setPhpdocTreeLoading', false);
                                });

                            case 4:
                                return _context.abrupt("return", _context.sent);

                            case 5:
                            case "end":
                                return _context.stop();
                        }
                    }
                }, _callee, this);
            }));
        },
        setPhpdocFile: function setPhpdocFile(_ref2) {
            var state = _ref2.state,
                commit = _ref2.commit,
                dispatch = _ref2.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee2() {
                return regeneratorRuntime.wrap(function _callee2$(_context2) {
                    while (1) {
                        switch (_context2.prev = _context2.next) {
                            case 0:
                                dispatch('setPhpdocContentLoading', true);

                                if (!(state.fullName === payload)) {
                                    _context2.next = 3;
                                    break;
                                }

                                return _context2.abrupt("return");

                            case 3:
                                _context2.next = 5;
                                return api.getEntity(state.project, state.ref, payload, { full: true }).then(function (file) {
                                    commit(exports.types.SET_FILE, file);
                                    dispatch('setPhpdocContentLoading', false);
                                });

                            case 5:
                                return _context2.abrupt("return", _context2.sent);

                            case 6:
                            case "end":
                                return _context2.stop();
                        }
                    }
                }, _callee2, this);
            }));
        },
        updatePhpdoc: function updatePhpdoc(_ref3) {
            var state = _ref3.state,
                commit = _ref3.commit,
                dispatch = _ref3.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee3() {
                return regeneratorRuntime.wrap(function _callee3$(_context3) {
                    while (1) {
                        switch (_context3.prev = _context3.next) {
                            case 0:
                                if (!(payload.project && payload.project !== state.project || payload.ref && payload.ref !== state.ref)) {
                                    _context3.next = 9;
                                    break;
                                }

                                commit(exports.types.SET_PROJECT, { name: payload.project, ref: payload.ref });

                                if (payload.entity) {
                                    _context3.next = 8;
                                    break;
                                }

                                _context3.next = 5;
                                return dispatch('updatePhpdocEntities');

                            case 5:
                                payload.entity = state.entities[0].full_name;
                                _context3.next = 9;
                                break;

                            case 8:
                                dispatch('updatePhpdocEntities');

                            case 9:
                                if (!(payload.entity && state.fullName !== payload.entity)) {
                                    _context3.next = 13;
                                    break;
                                }

                                _context3.next = 12;
                                return dispatch('setPhpdocFile', payload.entity);

                            case 12:
                                return _context3.abrupt("return", _context3.sent);

                            case 13:
                            case "end":
                                return _context3.stop();
                        }
                    }
                }, _callee3, this);
            }));
        },
        updatePhpdocSettings: function updatePhpdocSettings(_ref4) {
            var state = _ref4.state,
                commit = _ref4.commit,
                dispatch = _ref4.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            var type = payload.type === 'methods' ? exports.types.UPDATE_METHODS_SETTINGS : exports.types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, payload.settings);
        },
        resetPhpdocSettings: function resetPhpdocSettings(_ref5) {
            var state = _ref5.state,
                commit = _ref5.commit,
                dispatch = _ref5.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            if (payload && payload === 'methods') {
                commit(exports.types.UPDATE_METHODS_SETTINGS, getSettings());
            } else if (payload && payload === 'properties') {
                commit(exports.types.UPDATE_PROPERTIES_SETTINGS, getSettings());
            } else {}
            var type = payload.type === 'methods' ? exports.types.UPDATE_METHODS_SETTINGS : exports.types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, getSettings());
            commit(exports.types.UPDATE_PROPERTIES_SETTINGS, getSettings());
        },
        setPhpdocTreeLoading: function setPhpdocTreeLoading(_ref6) {
            var state = _ref6.state,
                commit = _ref6.commit,
                dispatch = _ref6.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            commit(exports.types.SET_LOADING, { tree: payload });
        },
        setPhpdocContentLoading: function setPhpdocContentLoading(_ref7) {
            var state = _ref7.state,
                commit = _ref7.commit,
                dispatch = _ref7.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            commit(exports.types.SET_LOADING, { content: payload });
        }
    },
    getters: {
        project: function project(state) {
            return state.project;
        },
        ref: function ref(state) {
            return state.ref;
        },
        fullName: function fullName(state) {
            return state.fullName;
        },
        tree: function tree(state) {
            return state.tree;
        },
        entities: function entities(state) {
            return state.entities;
        },
        file: function file(state) {
            return state.file;
        },
        settings: function settings(state) {
            return state.settings;
        },
        loading: function loading(state) {
            return state.loading;
        }
    }
};
//# sourceMappingURL=store.js.map

/***/ },

/***/ 602:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments)).next());
    });
};
var Vue = __webpack_require__(2);
var axios = __webpack_require__(183);
var lodash_1 = __webpack_require__(6);
function apiUrl(url) {
    var _apiUrl = Vue.codex.phpdoc.apiUrl;
    if (!_apiUrl.toString().endsWith('/')) _apiUrl += '/';
    _apiUrl += url;
    return _apiUrl;
}
function getEntities(project, ref) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee() {
        var options;
        return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
                switch (_context.prev = _context.next) {
                    case 0:
                        options = { params: lodash_1.merge({ project: project, ref: ref, tree: false, full: false }, params) };
                        return _context.abrupt("return", new Promise(function (resolve, reject) {
                            axios.get(apiUrl('phpdoc/entities'), options).catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data.data);
                            });
                        }));

                    case 2:
                    case "end":
                        return _context.stop();
                }
            }
        }, _callee, this);
    }));
}
exports.getEntities = getEntities;
function getEntity(project, ref, entity) {
    var params = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee2() {
        var options;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
                switch (_context2.prev = _context2.next) {
                    case 0:
                        options = { params: lodash_1.merge({ project: project, ref: ref, entity: entity }, params) };
                        return _context2.abrupt("return", new Promise(function (resolve, reject) {
                            axios.get(apiUrl('phpdoc/entity'), options).catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data.data);
                            });
                        }));

                    case 2:
                    case "end":
                        return _context2.stop();
                }
            }
        }, _callee2, this);
    }));
}
exports.getEntity = getEntity;
function getMethod(project, ref, entity, method) {
    var params = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee3() {
        var options;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
            while (1) {
                switch (_context3.prev = _context3.next) {
                    case 0:
                        options = { params: lodash_1.merge({ project: project, ref: ref, entity: entity, method: method }, params) };
                        return _context3.abrupt("return", new Promise(function (resolve, reject) {
                            axios.get(apiUrl('phpdoc/method'), options).catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data.data);
                            });
                        }));

                    case 2:
                    case "end":
                        return _context3.stop();
                }
            }
        }, _callee3, this);
    }));
}
exports.getMethod = getMethod;
function getProperty(project, ref, entity, property) {
    var params = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee4() {
        var options;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
            while (1) {
                switch (_context4.prev = _context4.next) {
                    case 0:
                        options = { params: lodash_1.merge({ project: project, ref: ref, entity: entity, property: property }, params) };
                        return _context4.abrupt("return", new Promise(function (resolve, reject) {
                            axios.get(apiUrl('phpdoc/property'), options).catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data.data);
                            });
                        }));

                    case 2:
                    case "end":
                        return _context4.stop();
                }
            }
        }, _callee4, this);
    }));
}
exports.getProperty = getProperty;
//# sourceMappingURL=api.js.map

/***/ }

})
//# sourceMappingURL=2.f38830d46e8bfb1d2da0.hot-update.js.map