webpackHotUpdate(5,{

/***/ 49:
/***/ function(module, exports, __webpack_require__) {

"use strict";


function __export(m) {
    for (var p in m) {
        if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }
}
__export(__webpack_require__(68));
__export(__webpack_require__(73));
var PHPDoc_1 = __webpack_require__(92);
exports.PHPDoc = PHPDoc_1.default;
var FullyQualifiedNameParser_1 = __webpack_require__(91);
exports.FullyQualifiedNameParser = FullyQualifiedNameParser_1.default;
var HashPathParser_1 = __webpack_require__(66);
exports.HashPathParser = HashPathParser_1.default;
var Navigator_1 = __webpack_require__(67);
exports.Navigator = Navigator_1.default;
//# sourceMappingURL=index.js.map

/***/ },

/***/ 66:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var HashPathParser = function () {
    function HashPathParser(hashPath) {
        _classCallCheck(this, HashPathParser);

        this.hashPath = '';
        this.classPath = '';
        this.type = 'class';
        this.method = '';
        this.property = '';
        this.line = 0;
        if (!this.isHashPath()) return;
        var exp = /^\#\!\/(.*?)(?:$|\:{2}(.*)|\!(.*?)(?:\@(\d*)|$))$/gm;
        var matches = [];
        var myArr = void 0;
        while ((myArr = exp.exec(hashPath)) !== null) {
            matches.push(myArr);
        }
        if (matches.length !== 1 || matches[0].length !== 5) throw new Error('not valid url string');
        var m = matches[0];
        this.hashPath = hashPath;
        this.type = 'class';
        if (m[2] !== undefined) {
            this.type = m[2].indexOf('()') !== -1 ? 'method' : 'property';
        }
        if (m[3] !== undefined) {
            this.type = m[3];
        }
        this.classPath = m[1];
        this[this.type] = this.type === 'method' ? m[2].replace('()', '') : m[2];
        this.line = parseInt(m[4]) || 0;
    }

    _createClass(HashPathParser, [{
        key: 'is',
        value: function is(type) {
            return this.type === type;
        }
    }, {
        key: 'isClass',
        value: function isClass() {
            return this.is(HashPathParser.Class);
        }
    }, {
        key: 'isMethod',
        value: function isMethod() {
            return this.is(HashPathParser.Method);
        }
    }, {
        key: 'isProperty',
        value: function isProperty() {
            return this.is(HashPathParser.Property);
        }
    }, {
        key: 'isSource',
        value: function isSource() {
            return this.is(HashPathParser.Source);
        }
    }, {
        key: 'hasLine',
        value: function hasLine() {
            return this.isSource() && this.line > 0;
        }
    }, {
        key: 'isHashPath',
        value: function isHashPath() {
            return location.hash.indexOf('#!/') !== -1;
        }
    }, {
        key: 'getHashPath',
        value: function getHashPath() {
            if (!this.isHashPath()) throw new Error('Current location is not a hashed path');
            return location.hash;
        }
    }, {
        key: 'toQuery',
        value: function toQuery() {
            if (this.isClass()) return this.classPath;
            if (this.isMethod()) return this.classPath + '::' + this.method + '()';
            if (this.isProperty()) return this.classPath + '::' + this.property;
            if (this.isSource()) {
                return this.classPath + '::';
            }
        }
    }, {
        key: 'toString',
        value: function toString() {
            return this.hashPath;
        }
    }], [{
        key: 'parse',
        value: function parse(hashPath) {
            return new HashPathParser(hashPath);
        }
    }]);

    return HashPathParser;
}();

HashPathParser.Class = 'class';
HashPathParser.Method = 'method';
HashPathParser.Property = 'property';
HashPathParser.Source = 'source';
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = HashPathParser;
//# sourceMappingURL=HashPathParser.js.map

/***/ },

/***/ 67:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var HashPathParser_1 = __webpack_require__(66);

var Navigator = function () {
    function Navigator() {
        _classCallCheck(this, Navigator);
    }

    _createClass(Navigator, [{
        key: 'parseHashPath',
        value: function parseHashPath(hashPath) {
            return new HashPathParser_1.default(hashPath);
        }
    }, {
        key: 'isHashPath',
        value: function isHashPath() {
            return location.hash.indexOf('#!/') !== -1;
        }
    }, {
        key: 'getHashPath',
        value: function getHashPath() {
            if (!this.isHashPath()) throw new Error('Current location is not a hashed path');
            return location.hash;
        }
    }, {
        key: 'getParsedHashPath',
        value: function getParsedHashPath() {
            return this.parseHashPath(this.getHashPath());
        }
    }, {
        key: 'init',
        value: function init(path) {
            var hashPath = void 0;
            if (path) hashPath = this.parseHashPath(path);else if (this.isHashPath()) hashPath = this.getParsedHashPath();else hashPath = new HashPathParser_1.default('');
        }
    }, {
        key: 'open',
        value: function open() {}
    }]);

    return Navigator;
}();

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = Navigator;
//# sourceMappingURL=Navigator.js.map

/***/ },

/***/ 91:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var FullyQualifiedNameParser = function () {
    function FullyQualifiedNameParser(name) {
        _classCallCheck(this, FullyQualifiedNameParser);

        this.name = '';
        this.entityName = '';
        this.methodName = '';
        this.propertyName = '';
        this.type = 'entity';
        var exp = /^(.*?)(?:$|\:{2}(.*))$/gm;
        var matches = [];
        var myArr = void 0;
        while ((myArr = exp.exec(name)) !== null) {
            matches.push(myArr);
        }
        if (matches.length !== 1 || matches[0].length !== 3) throw new Error('not valid fqn');
        var m = matches[0];
        this.name = name;
        this.type = 'entity';
        if (m[2] !== undefined) {
            this.type = m[2].indexOf('()') !== -1 ? 'method' : 'property';
        }
        this.entityName = m[1];
        this[this.type + 'Name'] = this.type === 'method' ? m[2].replace('()', '') : m[2];
    }

    _createClass(FullyQualifiedNameParser, [{
        key: 'is',
        value: function is(type) {
            return this.type === type;
        }
    }, {
        key: 'isEntity',
        value: function isEntity() {
            return this.is(FullyQualifiedNameParser.Entity);
        }
    }, {
        key: 'isMethod',
        value: function isMethod() {
            return this.is(FullyQualifiedNameParser.Method);
        }
    }, {
        key: 'isProperty',
        value: function isProperty() {
            return this.is(FullyQualifiedNameParser.Property);
        }
    }, {
        key: 'toString',
        value: function toString() {
            return this.name;
        }
    }, {
        key: 'requestApi',
        value: function requestApi() {
            if (this.isEntity()) {
                return Vue.codex.phpdoc.getEntity(this.entityName);
            } else if (this.isMethod()) {
                return Vue.codex.phpdoc.getMethod(this.entityName, this.methodName);
            } else if (this.isProperty()) {
                return Vue.codex.phpdoc.getProperty(this.entityName, this.propertyName);
            }
        }
    }]);

    return FullyQualifiedNameParser;
}();

FullyQualifiedNameParser.Entity = 'entity';
FullyQualifiedNameParser.Method = 'method';
FullyQualifiedNameParser.Property = 'property';
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = FullyQualifiedNameParser;
//# sourceMappingURL=FullyQualifiedNameParser.js.map

/***/ },

/***/ 92:
/***/ function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Navigator_1 = __webpack_require__(67);

var PHPDoc = function () {
    function PHPDoc(vm, $store) {
        _classCallCheck(this, PHPDoc);

        this.vm = vm;
        this.$store = $store;
    }

    _createClass(PHPDoc, [{
        key: "init",
        value: function init() {
            this.nav = new Navigator_1.default();
        }
    }]);

    return PHPDoc;
}();

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = PHPDoc;
//# sourceMappingURL=PHPDoc.js.map

/***/ }

})
//# sourceMappingURL=5.29cb37c6c9b3eb5c804a.hot-update.js.map