import { load } from "./utils";
import { VNode, VNodeDirective, DirectiveOptions } from "vue/types/index";


export const dropdown: DirectiveOptions = {
    bind (el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        load(vnode.context, () => {
            let id = binding.arg, params = {};
            if ( typeof binding.value === 'string' && typeof binding.arg !== 'string' )
                id = binding.value;

            if ( typeof binding.value !== 'string' )
                params = binding.value || {};


            el.setAttribute('data-activates', id);
            $(el).dropdown(params)
        })
    }
};


export const scrollTo: DirectiveOptions = {
    bind (el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        let o = {
            to      : null,
            duration: 500,
            easing  : 'swing',
            offset  : 0
        };
        $(() => {


            $(el).on('click', (event: JQueryEventObject) => {
                event.stopPropagation();
                event.preventDefault();
                if ( typeof binding.value === 'object' ) {
                    _.merge(o, binding.value);
                }

                if ( typeof binding.value === 'string' ) {
                    o.to = $(binding.value).offset().top

                } else if ( binding.arg ) {
                    o.to = $($(el).attr(binding.arg)).offset().top
                }
                setTimeout(() =>
                        $("html, body").stop().animate({ scrollTop: o.to + o.offset }, o.duration, o.easing, () => {
                            //
                        })
                    , 50)
            });

            //
        });
    }
};


export const scrollspy: DirectiveOptions = {
    bind(el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        let defaults = {};
        let options  = _.merge({}, defaults, binding.value);
    }
};

export const popover: DirectiveOptions = {
    bind(el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        let defaults = {};
        let options  = _.merge({}, defaults, binding.value);
        // $(() => { $(el)[ 'scrollSpy' ](options).on('scrollSpy:enter',
    }
};

function updateHeight(el, binding){
    let key = 'height';
    if(binding.modifiers['max']) key = 'maxHeight';
    if(binding.modifiers['min']) key = 'minHeight';
    el.style[key] = binding.value + 'px';
}

export const scrollable: DirectiveOptions = {
    bind(el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        if ( ! el.classList.contains('scrollable') ) {
            el.classList.add('scrollable')
        }
        if(binding.modifiers['x']){
            el.style['overflow-x'] = 'scroll';
        }
        if(binding.modifiers['y']){
            el.style['overflow-y'] = 'scroll';
        }
        updateHeight(el, binding);
    },
    componentUpdated(el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        updateHeight(el, binding);
    }
}