import * as Tether from 'tether'
let sides = {
    top: 'bottom',
    bottom: 'top',
    left: 'right',
    right: 'left'
}
let otherSide = (side:string)=> sides[side]

export default {
    props  : {
        content  : { type: String },
        effect   : { type: String, default: 'fade' },
        header   : { type: Boolean, default: true },
        placement: { type: String, default: 'top' },
        title    : { type: String },
        trigger  : { type: String }
    },
    data () {
        return {
            position: {
                top : 0,
                left: 0
            },
            visible    : false
        }
    },
    methods: {
        toggle (e) {

            if ( this.visible ) {
                this.hide(e);
            } else {
                this.show(e);
            }
        },
        show(e){
            if ( e && this.trigger === 'contextmenu' ) e.preventDefault()
            this.visible = true;
            this.reposition().then(() => this.$emit('show'));
        },
        hide(e){
            if ( e && this.trigger === 'contextmenu' ) e.preventDefault()
            this.visible = false;
            this.$emit('hide')
        },
        reposition(){
            return new Promise((resolve, reject) => {
                this.$nextTick(() => {
                    // if(!this.$refs.popover) return resolve();
                    let options = {
                        element: this.$refs.popover,
                        target: this.$refs.trigger.children[0],
                        attachment: otherSide(this.placement) + ' center',
                        targetAttachment: this.placement + ' center'
                    };
                    let t = new Tether(options)
                    t.position();
                    resolve();
                })
            })
        }
    },
    mounted () {
        let trigger = this.$refs.trigger
        if ( ! trigger ) return console.error('Could not find trigger v-el in your component that uses popoverMixin.')

        if ( this.trigger === 'focus' && ! ~ trigger.tabIndex ) {
            trigger = $('a,input,select,textarea,button', trigger)
            if ( ! trigger.length ) { trigger = null }
        }
        if ( trigger ) {
            let events = { contextmenu: 'contextmenu', hover: 'mouseleave mouseenter', focus: 'blur focus' }
            let event = events[ this.trigger ] || 'click';
            if(event === 'click'){
                $(trigger).on(event, (e) => {
                    e.stopPropagation();
                    this.show(e);
                })
                $(window).on(event, this.hide)
            } else {
                $(trigger).on(event, this.toggle)
            }
            this._trigger = trigger
        }

        this.$events.$on('phpdoc:open', () => this.hide())
    },
    beforeDestroy () {
        if ( this._trigger ) $(this._trigger).off()
    }
}