// import { merge } from "lodash";
import { mapGetters, mapActions } from "vuex";

export default {
    mixins: [], // @todo remove this mixin. requires checking/adjusting all dependent components
    data() {
        return {
            resize: 0
        }
    },

    computed: mapGetters([ 'heights' ]),
    mounted(){
        window.addEventListener('resize', this.handleResize);
    },
    beforeDestroy(){
        window.removeEventListener('resize', this.handleResize);
    },
    methods : _.merge(mapActions([ 'updateHeights' ]), {
        handleResize (event) {
            if ( this.resize ) clearTimeout(this.resize);
            this.resize = setTimeout(() => {
                this.$emit('resize');
            }, 50);
        }
    })
};
