exports.scrollable = {
    props: {
        scrollable: Boolean,
        maxHeight: Number,
        height: Number,
        minHeight: Number
    },
    mounted() {
        let classList = this.$el.classList;
        if (this.scrollable) {
            if (!classList.contains('scrollable')) {
                classList.add('scrollable');
            }
        }
    },
    computed: {
        scrollStyle() {
            let style = {};
            if (this.scrollable) {
                if (this.height) {
                    style['height'] = parseInt(this.height) + 'px';
                }
                else {
                    if (this.minHeight) {
                        style['minHeight'] = parseInt(this.minHeight) + 'px';
                    }
                    if (this.maxHeight) {
                        style['maxHeight'] = parseInt(this.maxHeight) + 'px';
                    }
                }
            }
            return style;
        }
    }
};
//# sourceMappingURL=scrollable.js.map