const SmoothScroll = require("smoothscroll");
require("../../vendor/scrollspy.js");
const VueCookie = require("vue-cookie");
const NProgress = require("vue-nprogress");
const components = require("../../components/global");
const directives = require("./directives");
const mixins = require("./mixins");
const utils = require("./utils");
const utils_1 = require("./utils");
const api_1 = require("./api");
const Vue = require("vue");
const vIcon = require('vue-materials/src/components/icon.vue');
_.merge(components, { vIcon });
window.codex = Vue.codex = {};
Vue.codex.makeExtender = function (obj) {
    obj.extend = function (...objs) {
        obj = _.merge.apply(_.merge, [obj, ...objs]);
        return obj;
    };
};
Vue.codex.makeExtender(Vue.codex);
Vue.codex.extend({
    loader: new utils_1.Loader('page-loader', 'page-loading', 'page'),
    events: new Vue(),
    breakpoints: { xs: 0, sm: 576, md: 768, lg: 922, xl: 1200 },
    sidebar: { width: 250, collapsedWidth: 54 },
    helpers: utils,
    mixins,
    debug: false,
    apiUrl: '',
    ref: '',
    project: ''
});
if (window['_CODEX_PHP_DATA'] !== undefined) {
    Vue.codex.extend(window['_CODEX_PHP_DATA']);
}
let plugin = function (Vue, options = {}) {
    if (plugin.installed)
        return;
    Vue.config.debug = Vue.codex.debug;
    Vue.codex.api = new api_1.Api({
        apiUrl: Vue.codex.apiUrl,
        debug: Vue.codex.debug
    });
    Vue.use(VueCookie);
    Vue.use(require('vue-touch'));
    Vue.use(NProgress, {
        latencyThreshold: 100,
        router: false,
        http: true
    });
    const nprogress = new NProgress({ parent: '.nprogress-container' });
    Object.defineProperties(Vue.prototype, {
        $helpers: { get() { return Vue.codex.helpers; } }
    });
    Vue.mixin({
        nprogress,
        computed: {
            $$el() { return $(this.$el); },
            $events() { return Vue.codex.events; },
            classes() { return {}; }
        },
        methods: {
            $$: (selector, options) => $(selector, options),
            $$ready(cb) {
                if (document.readyState === 'complete') {
                    this.$nextTick(() => cb());
                }
                else {
                    document.addEventListener('DOMContentLoaded', () => cb());
                }
            },
            $scroll(el, duration = 500, callback, context) {
                SmoothScroll(el, duration, callback, context);
            }
        }
    });
    Vue.config.debug &&
        Object.keys(components).forEach(key => Vue.component(key, components[key]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[key]));
    Vue.codex.extend({ nprogress });
    if (options.store) {
        var { module, types } = require('./store');
        options.store.registerModule('codex', module);
        Vue.codex.types = types;
        Vue.codex.store = options.store;
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = plugin;
//# sourceMappingURL=plugin.js.map