import * as SmoothScroll from "smoothscroll";
import "../../vendor/scrollspy.js";
import * as VueCookie from "vue-cookie";
// import * as VueTouch from "vue-touch";
import * as NProgress from "vue-nprogress";
import * as components from "../../components/global";
import * as directives from "./directives";
import * as mixins from './mixins'
import * as utils from "./utils";

import { Loader } from "./utils";
import { Api } from "./api";
import { Store } from "vuex";
// import Vue = require('vue')
import Vue = require('vue')
const vIcon = require('vue-materials/src/components/icon.vue');
_.merge(components, { vIcon });


window.codex = Vue.codex = {};

Vue.codex.makeExtender = function(obj){
    obj.extend = function(...objs:any[]){
        obj = _.merge.apply(_.merge, [obj, ...objs]);
        return obj;
    }
};
Vue.codex.makeExtender(Vue.codex);
Vue.codex.extend({
    loader     : new Loader('page-loader', 'page-loading', 'page'),
    events     : new Vue(),
    breakpoints: { xs: 0, sm: 576, md: 768, lg: 922, xl: 1200 },
    sidebar    : { width: 250, collapsedWidth: 54 },
    helpers    : utils,
    mixins,
    debug      : false,
    apiUrl     : '',
    ref        : '',
    project    : ''
})

if ( window[ '_CODEX_PHP_DATA' ] !== undefined ) {
    Vue.codex.extend(window[ '_CODEX_PHP_DATA' ]);
}


let plugin: any = function (Vue, options: any = {}) {
    if ( plugin.installed ) return;


    Vue.config.debug = Vue.codex.debug;

    Vue.codex.api = new Api({
        apiUrl: Vue.codex.apiUrl,
        debug : Vue.codex.debug
    })

    Vue.use(VueCookie);


    Vue.use(require('vue-touch'))

    Vue.use(NProgress, {
        latencyThreshold: 100,
        router          : false,
        http            : true
    });

    const nprogress = new NProgress({ parent: '.nprogress-container' });


    Object.defineProperties(Vue.prototype, {
        $helpers: { get () { return Vue.codex.helpers } }

    })

    Vue.mixin({
        nprogress,
        computed: {
            $$el(): JQuery { return $(this.$el); },
            $events(): vuejs.Vue { return Vue.codex.events },
            classes(): any { return {} }
        },
        methods : {
            $$: (selector, options): JQuery => $(selector, options),
            $$ready(cb: Function) {
                if ( document.readyState === 'complete' ) {
                    this.$nextTick(() => cb())
                } else {
                    document.addEventListener('DOMContentLoaded', () => cb())
                }
            },
            $scroll(el: HTMLElement, duration: number = 500, callback?: Function, context?: any){
                SmoothScroll(el, duration, callback, context)
            }
        }
    });

    Vue.config.debug &&

    Object.keys(components).forEach(key => Vue.component(key, components[ key ]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[ key ]));

    Vue.codex.extend({ nprogress });

    if ( options.store ) {
        var { module, types } = require('./store');
        options.store.registerModule('codex', module);
        Vue.codex.types = types;
        Vue.codex.store = options.store;
    }

};


export default plugin;
