const Vue = require("vue");
const utils_1 = require("./utils");
exports.types = {
    SIDEBAR: 'codex/SIDEBAR',
    TOGGLE_SIDEBAR: 'codex/TOGGLE_SIDEBAR',
    CLOSE_SIDEBAR: 'codex/CLOSE_SIDEBAR',
    OPEN_SIDEBAR: 'codex/OPEN_SIDEBAR',
    HIDE_SIDEBAR: 'codex/HIDE_SIDEBAR',
    SHOW_SIDEBAR: 'codex/SHOW_SIDEBAR',
    UPDATE_HEIGHTS: 'codex/UPDATE_HEIGHTS',
    UPDATE_MIN_HEIGHTS: 'codex/UPDATE_MIN_HEIGHTS',
};
let emit = (...params) => Vue.codex.events.$emit.apply(Vue.codex.events, params);
exports.module = {
    state: {
        project: '',
        ref: '',
        sidebar: { closed: utils_1.getCookie('codex.sidebar.closed') || false, hidden: utils_1.getCookie('codex.sidebar.hidden') || false }
    },
    mutations: {
        [exports.types.TOGGLE_SIDEBAR](state) {
            state.sidebar.closed = state.sidebar.closed === false;
            utils_1.setCookie('sidebar.closed', state.sidebar.closed);
            emit(exports.types.TOGGLE_SIDEBAR);
        },
        [exports.types.CLOSE_SIDEBAR](state) {
            state.sidebar.closed = true;
            utils_1.setCookie('sidebar.closed', state.sidebar.closed);
            emit(exports.types.CLOSE_SIDEBAR);
        },
        [exports.types.OPEN_SIDEBAR](state) {
            state.sidebar.closed = false;
            utils_1.setCookie('sidebar.closed', state.sidebar.closed);
            emit(exports.types.OPEN_SIDEBAR);
        },
        [exports.types.HIDE_SIDEBAR](state) {
            state.sidebar.hidden = true;
            utils_1.setCookie('sidebar.hidden', state.sidebar.hidden);
            emit(exports.types.HIDE_SIDEBAR);
        },
        [exports.types.SHOW_SIDEBAR](state) {
            state.sidebar.hidden = false;
            utils_1.setCookie('sidebar.hidden', state.sidebar.hidden);
            emit(exports.types.SHOW_SIDEBAR);
        },
    },
    actions: {
        toggleSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.TOGGLE_SIDEBAR);
        },
        closeSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.CLOSE_SIDEBAR);
        },
        openSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.OPEN_SIDEBAR);
        },
        hideSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.HIDE_SIDEBAR);
        },
        showSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.SHOW_SIDEBAR);
        },
    },
    getters: {
        sidebar: state => state.sidebar,
        heights: state => state.heights,
    }
};
//# sourceMappingURL=store.js.map