export function createBodyClickListener(fn) {
    let isListening = false



    function start(cb?: Function) {
        window.addEventListener('click', _onclick, true)
        window.addEventListener('keyup', _onescape, true)
        isListening = true
        if ( typeof cb === 'function' ) cb()
    }

    function stop(cb?: Function) {
        window.removeEventListener('click', _onclick, true)
        window.removeEventListener('keyup', _onescape, true)
        isListening = false
        if ( typeof cb === 'function' ) cb()
    }


    function _onclick(e) {
        e.preventDefault()
        if ( typeof fn === 'function' ) fn(e)
        stop()
    }

    function _onescape(e) {
        if ( e.keyCode === 27 ) _onclick(e)
    }

    return {
        start, stop,
        get isListening() {
            return isListening
        }
    }
}