const lodash_1 = require("lodash");
function getRandomId(length) {
    if (lodash_1.isNumber(length)) {
        length = 15;
    }
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < length; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
}
exports.getRandomId = getRandomId;
function load(vNodeContext, cb) {
    if (document.readyState === 'complete') {
        vNodeContext.$nextTick(() => cb());
    }
    else {
        document.addEventListener('DOMContentLoaded', () => cb());
    }
}
exports.load = load;
function getViewPort() {
    var e = window, a = 'inner';
    if (!('innerWidth' in window)) {
        a = 'client';
        e = document.documentElement || document.body;
    }
    return {
        width: e[a + 'Width'],
        height: e[a + 'Height']
    };
}
exports.getViewPort = getViewPort;
function isTouchDevice() {
    try {
        document.createEvent("TouchEvent");
        return true;
    }
    catch (e) {
        return false;
    }
}
exports.isTouchDevice = isTouchDevice;
function getElementHeight(element) {
    if (!element['getClientRects']().length) {
        return element.offsetHeight;
    }
    let rect = element.getBoundingClientRect();
    if (rect.width || rect.height) {
        return rect.bottom - rect.top;
    }
    return 0;
}
exports.getElementHeight = getElementHeight;
function listen(target, eventType, callback) {
    if (target.addEventListener) {
        target.addEventListener(eventType, callback, false);
        return {
            remove() {
                target.removeEventListener(eventType, callback, false);
            },
        };
    }
    else if (target.attachEvent) {
        target.attachEvent(`on${eventType}`, callback);
        return {
            remove() {
                target.detachEvent(`on${eventType}`, callback);
            },
        };
    }
}
exports.listen = listen;
function getScroll(w, top) {
    let ret = w[`page${top ? 'Y' : 'X'}Offset`];
    const method = `scroll${top ? 'Top' : 'Left'}`;
    if (typeof ret !== 'number') {
        const d = w.document;
        ret = d.documentElement[method];
        if (typeof ret !== 'number') {
            ret = d.body[method];
        }
    }
    return ret;
}
exports.getScroll = getScroll;
function getOffset(element) {
    let elm = element;
    let top = elm.offsetTop;
    let left = elm.offsetLeft;
    while (elm.offsetParent !== null) {
        elm = elm.offsetParent;
        top += elm.offsetTop;
        left += elm.offsetLeft;
    }
    return {
        top,
        left,
    };
}
exports.getOffset = getOffset;
function cssTransitions() {
    if (typeof (document) === 'undefined')
        return false;
    const style = document.documentElement.style;
    return (style['webkitTransition'] !== undefined ||
        style['MozTransition'] !== undefined ||
        style['OTransition'] !== undefined ||
        style['MsTransition'] !== undefined ||
        style.transition !== undefined);
}
exports.cssTransitions = cssTransitions;
function escapeHash(hash) {
    return hash.replace(/(:|\.|\[|\]|,|=)/g, "\\$1");
}
exports.escapeHash = escapeHash;
function registerJqueryHelpers($) {
    if ($.fn.prefixedData !== undefined) {
        return;
    }
    $.fn.prefixedData = function (prefix) {
        var origData = $(this).first().data();
        var data = {};
        for (var p in origData) {
            var pattern = new RegExp("^" + prefix + "[A-Z]+");
            if (origData.hasOwnProperty(p) && pattern.test(p)) {
                var shortName = p[prefix.length].toLowerCase() + p.substr(prefix.length + 1);
                data[shortName] = origData[p];
            }
        }
        return data;
    };
    $.fn.removeAttributes = function () {
        return this.each(function () {
            var attributes = $.map(this.attributes, function (item) {
                return item.name;
            });
            var img = $(this);
            $.each(attributes, function (i, item) {
                img.removeAttr(item);
            });
        });
    };
    $.fn.ensureClass = function (clas, has = true) {
        var $this = $(this);
        if (has === true && $this.hasClass(clas) === false) {
            $this.addClass(clas);
        }
        else if (has === false && $this.hasClass(clas) === true) {
            $this.removeClass(clas);
        }
        return this;
    };
    $.fn.onClick = function (...args) {
        var $this = $(this);
        return $this.on.apply($this, [isTouchDevice() ? 'touchend' : 'click'].concat(args));
    };
}
exports.registerJqueryHelpers = registerJqueryHelpers;
function parseBool(val) {
    return val === true || val === 1 || val === 'true' || val === '1';
}
exports.parseBool = parseBool;
function setCookie(k, v) {
    Vue.cookie.set(k, JSON.stringify(v));
}
exports.setCookie = setCookie;
function getCookie(k) {
    return JSON.parse(Vue.cookie.get(k));
}
exports.getCookie = getCookie;
function getRefInParents(ref, parent) {
    if (parent.$root === parent)
        return false;
    if (parent.$refs[ref] !== undefined) {
        return parent.$refs[ref];
    }
    return getRefInParents(ref, parent.$parent);
}
exports.getRefInParents = getRefInParents;
//# sourceMappingURL=general.js.map