class Loader {
    constructor(loaderId, bodyLoadingClass, loaderClassSuffix) {
        this.loaderId = loaderId;
        this.bodyLoadingClass = bodyLoadingClass;
        this.loaderClassSuffix = loaderClassSuffix;
        this.isLoading = false;
    }
    get bodyClass() {
        return document.body.classList;
    }
    start() {
        this.getLoaderElement();
        if (!this.bodyClass.contains(this.bodyLoadingClass)) {
            this.bodyClass.add(this.bodyLoadingClass);
        }
    }
    stop() {
        this.bodyClass.remove(this.bodyLoadingClass);
    }
    getLoaderElement() {
        let container = document.getElementById(this.loaderId);
        let loader;
        if (!container) {
            container = document.createElement('div');
            container.setAttribute('id', this.loaderId);
            document.body.appendChild(container);
            loader = document.createElement('div');
            loader.classList.add('loader');
            loader.classList.add('loader-' + this.loaderClassSuffix);
        }
        else {
            loader = container.children[0];
        }
        return container;
    }
}
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = Loader;
//# sourceMappingURL=loader.js.map