

export default class Loader {
    isLoading        = false
    // bodyLoadingClass = 'page-loading'
    // loaderId         = 'page-loader'
    // loaderClasses = ['loader']

    constructor(protected loaderId:string, protected bodyLoadingClass:string, protected loaderClassSuffix:string){}

    get bodyClass() {
        return document.body.classList;
    }


    start() {
        this.getLoaderElement();
        if ( ! this.bodyClass.contains(this.bodyLoadingClass) ) {
            this.bodyClass.add(this.bodyLoadingClass)
        }
    }

    stop() {
        this.bodyClass.remove(this.bodyLoadingClass)
    }

    protected getLoaderElement(): HTMLElement {
        let container = document.getElementById(this.loaderId);
        let loader;
        if ( ! container ) {
            container = document.createElement('div');
            container.setAttribute('id', this.loaderId);
            document.body.appendChild(container);
            loader = document.createElement('div');
            loader.classList.add('loader');
            loader.classList.add('loader-' + this.loaderClassSuffix);
        } else {
            loader = container.children[ 0 ];
        }
        return container;
    }
}

