import Vue from "vue";
import {mapGetters} from 'vuex';
import {HashPathParser} from './phpdoc/utils'

//import 'perfect-scrollbar/jquery';


if ( Vue.codex.CodexPhpdocPlugin ) {
    Vue.use(Vue.codex.CodexPhpdocPlugin);
}
Vue.config.debug = true;


const App = Vue.codex.App.extend({
    name: 'phpdoc',
    // mixins  : [Vue.codex.mixins.layout, Vue.codex.mixins.resize],
    data(){
        return {
            minContentHeight  : 0,
            phpdocHeight: 0,
            query             : codex.phpdoc.defaultClass ? codex.phpdoc.defaultClass : undefined,
            hashPath          : null,
            navigator         : null
        }
    },
    beforeMount(){
        // this.navigator = new Navigator()
        let hashPath = HashPathParser.parse(location.hash);
        if ( hashPath.isHashPath() ) {
            // do we have a hash path? if so, we set the query by that
            this.query = hashPath.toQuery();
            window.history.replaceState(null, hashPath.toString(), window.location.pathname + hashPath.toString());
        } else if ( Vue.codex.phpdoc.defaultClass ) {
            // we don't have a hash path? we check for default class for the project and set query by that, then update the hash path
            this.open(Vue.codex.phpdoc.defaultClass);
        }

        window.addEventListener("popstate", (event) => {
            let hashPath = HashPathParser.parse(location.hash);
            console.log('popstate', window.location);
            if ( hashPath.isHashPath() ) {
                this.open(hashPath.toQuery());
            }
        }, false);



    },
    mounted(){
        console.log('phpdoc  APP');
        this.$$ready(() => this.onResizeDocument());
        this.$on('resize', this.onResizeDocument)
        this.$events.$on('phpdoc:type:click', (type) => {
            if(type.isLocal) this.open(type.fullName);
        });
        codex.loader.stop();
    },
    methods : {
        // ...mapActions(['toggleSidebar'])
        onResizeDocument(){
            this.$nextTick(() => {
                let $page = this.$$(this.$refs.page);
                this.phpdocHeight = this.minHeights.inner = 0;

                this.$nextTick(() => {
                    this.phpdocHeight = this.minHeights.inner = $page.outerHeight(true) - parseInt($page.css('padding-top')) - parseInt($page.css('padding-bottom'))
                });
            })
        },
        open(query){
            this.$events.$emit('phpdoc:open', query);
            this.query = query;
            window.history.pushState(null, query, window.location.pathname + "#!/" + query);
        }
    },
    watch   : {
        // file(){
        //     this.$nextTick(() => {
        //         this.onResizeDocument();
        //         this.$scroll(this.$refs.header.$el);
        //     })
        // }
    },
    computed: {
        // ...mapGetters(['file'])
    }
});

export default App;

codex.App = App;

console.log('sc phpdoc');
