var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
const vuex_1 = require("vuex");
const general_1 = require("./utils/general");
exports.phpdocTab = {
    computed: _.merge(vuex_1.mapGetters(['file', 'settings']), {
        entity() {
            return this.file.entity;
        }
    }),
    methods: _.merge(vuex_1.mapActions(['updatePhpdoc']), {
        getFiltered(type) {
            let items = _.chain(this.entity[type]);
            if (this.settings[type].show.inherited === false) {
                items = items.filter((item) => item.inherited !== true);
            }
            if (this.settings[type].show.public === false) {
                items = items.filter((item) => item.visibility !== 'public');
            }
            if (this.settings[type].show.protected === false) {
                items = items.filter((item) => item.visibility !== 'protected');
            }
            if (this.settings[type].show.private === false) {
                items = items.filter((item) => item.visibility !== 'private');
            }
            items = items.sortBy(this.settings[type].sort.by);
            if (this.settings[type].sort.dir === 'desc') {
                items = items.reverse();
            }
            return items.value();
        }
    })
};
exports.phpdocComponent = {
    methods: {}
};
exports.entityChild = {
    props: {
        fullName: String
    },
    data() {
        return { fileData: false };
    },
    mounted() {
        if (this.fullName)
            this.setFile(this.fullName);
    },
    watch: {
        fullName(newVal) {
            this.setFile(newVal);
        }
    },
    computed: _.merge(vuex_1.mapGetters({ _file: 'file' }), {
        file() {
            return this._file ? this._file : this.fileData;
        },
        entity() {
            return this.file ? this.file.entity : false;
        }
    }),
    methods: _.merge(vuex_1.mapActions(['setPhpdocFile']), {
        setFile(fullName) {
            if (this._file) {
                this.setPhpdocFile(fullName);
            }
            else {
                this.$phpdoc.getEntity(fullName).then(data => this.fileData = data);
            }
        },
    })
};
exports.component = {
    computed: {},
    methods: {
        inApp() {
            return this.$root.$options.name === 'phpdoc';
        },
        getEntity(fullName) {
            return __awaiter(this, void 0, void 0, function* () {
                return new Promise((resolve, reject) => {
                    let entity = _.find(this.$store.getters.full_entities, fullName);
                    if (entity)
                        return resolve(entity);
                    this.$store.dispatch('getPhpdocEntity', fullName).then(entity => {
                        resolve(entity);
                    });
                });
            });
        },
        getMethod(entityName, methodName) {
            return __awaiter(this, void 0, void 0, function* () {
                if (methodName === undefined) {
                    let parsed = general_1.parseFullName(entityName);
                    if (!parsed.isMethod)
                        throw new Error('Query not for method ' + entityName);
                    methodName = parsed.methodName;
                }
                return new Promise((resolve, reject) => {
                    let entity = _.find(this.$store.getters.full_entities, entityName);
                    if (!entity) {
                        return this.getEntity(entityName).then((entity) => {
                            let method = _.find(entity.entity.methods, { name: methodName });
                            if (!method) {
                                console.trace('no method found:  ' + methodName, this);
                                return reject('no method found:  ' + methodName);
                            }
                            resolve(method);
                        });
                    }
                    let method = _.find(entity.entity.methods, { name: methodName });
                    if (!method)
                        console.trace('no method found:  ' + methodName, this) && reject('no method found:  ' + methodName);
                });
            });
        },
        hasEntity(fullName) {
            return _.find(this.$store.getters.entities, fullName);
        }
    }
};
exports.fileRefComponent = {
    mixins: [exports.component],
    props: {
        query: String,
        fileRef: Object
    },
    data() {
        return { file: false };
    },
    mounted() {
        if (this.query)
            this.handleQuery(this.query);
        if (this.fileRef)
            this.file = this.fileRef;
    },
    computed: {
        entity() {
            return this.file.entity;
        }
    },
    watch: {
        query(val) {
            this.file = false;
            this.handleQuery(val);
        },
        fileRef(val) { this.file = val; }
    },
    methods: {
        handleQuery(ref) {
            let parsed = this.$phpdoc.parseRef(ref);
            if (!parsed.isEntity) {
                throw new Error('Parsed ref is not for method: ' + ref);
            }
            this.getEntity(parsed.entityName).then(file => this.file = file);
        }
    }
};
exports.methodRefComponent = {
    mixins: [exports.component],
    props: {
        query: String,
        methodRef: Object
    },
    data() {
        return { method: false };
    },
    mounted() {
        if (this.query)
            this.handleQuery(this.query);
        if (this.methodRef)
            this.method = this.methodRef;
    },
    watch: {
        query(val) {
            this.method = false;
            this.handleQuery(val);
        },
        methodRef(val) { this.method = val; }
    },
    methods: {
        handleQuery(ref) {
            let parsed = this.$phpdoc.parseRef(ref);
            if (!parsed.isMethod) {
                throw new Error('Parsed ref is not for method: ' + ref);
            }
            this.getMethod(parsed.entityName, parsed.methodName).then(method => this.method = method);
        }
    }
};
//# sourceMappingURL=mixins.js.map