//import { find, merge, chain } from "lodash";
import { mapGetters, mapActions } from 'vuex';
import { parseFullName } from "./utils/general";
import { File, Method } from './utils'

export const phpdocTab = {
    computed: _.merge(mapGetters([ 'file', 'settings' ]), {
        entity(){
            return this.file.entity;
        }
    }),
    methods : _.merge(mapActions([ 'updatePhpdoc' ]), {
        getFiltered(type)            {
//                console.trace('getFiltered(type)', type, this.entity)
            let items: any = _.chain(this.entity[ type ]);
            if ( this.settings[ type ].show.inherited === false ) {
                items = items.filter((item) => item.inherited !== true);
            }
            if ( this.settings[ type ].show.public === false ) {
                items = items.filter((item) => item.visibility !== 'public');
            }
            if ( this.settings[ type ].show.protected === false ) {
                items = items.filter((item) => item.visibility !== 'protected');
            }
            if ( this.settings[ type ].show.private === false ) {
                items = items.filter((item) => item.visibility !== 'private');
            }

            //var a = _.sortBy(methods, this.sortMethodsBy);
//

            items = items.sortBy(this.settings[ type ].sort.by);

            if ( this.settings[ type ].sort.dir === 'desc' ) {
                items = items.reverse();
            }
            // this.count[ type ] = items.value().length;

            return items.value();
        }

    })
};

export const phpdocComponent = {
    methods: {}
}

export const entityChild = {
    props   : {
        fullName: String
    },
    data(){
        return { fileData: false }
    },
    mounted(){
        if ( this.fullName ) this.setFile(this.fullName);
    },
    watch   : {
        fullName(newVal){
            this.setFile(newVal);
        }
    },
    computed: _.merge(mapGetters({ _file: 'file' }), {
        file(){
            return this._file ? this._file : this.fileData;
        },
        entity()            {
            return this.file ? this.file.entity : false;
        }
    }),
    methods : _.merge(mapActions([ 'setPhpdocFile' ]), {
        setFile(fullName){
            if ( this._file ) {
                this.setPhpdocFile(fullName);
            } else {
                this.$phpdoc.getEntity(fullName).then(data => this.fileData = data);
            }
        },
    })
}

export const component = {
    computed: //merge(mapGetters([ 'tree', 'entities', 'full_entities', 'settings' ]), {
        {},


    // merge(mapActions([ 'updatePhpdocSettings', 'resetPhpdocSettings' ]), {
    methods: {
        inApp(){
            return this.$root.$options.name === 'phpdoc';
        },
        async getEntity(fullName){
            return new Promise((resolve, reject) => {
                let entity = _.find(this.$store.getters.full_entities, fullName);
                if ( entity ) return resolve(entity);
                this.$store.dispatch('getPhpdocEntity', fullName).then(entity => {
                    resolve(entity);
                })
            })
        },
        async getMethod(entityName, methodName){
            if ( methodName === undefined ) {
                let parsed = parseFullName(entityName);
                if ( ! parsed.isMethod ) throw new Error('Query not for method ' + entityName)
                methodName = parsed.methodName;
            }

            return new Promise((resolve, reject) => {
                let entity: File = <File> _.find(this.$store.getters.full_entities, entityName);
                if ( ! entity ) {
                    return this.getEntity(entityName).then((entity) => {
                        let method: Method = <Method> _.find(entity.entity.methods, { name: methodName });
                        if ( ! method ) {
                            console.trace('no method found:  ' + methodName, this);
                            return reject('no method found:  ' + methodName);
                        }
                        resolve(method);
                    })
                }
                let method: Method = <Method> _.find(entity.entity.methods, { name: methodName });
                if ( ! method ) console.trace('no method found:  ' + methodName, this) && reject('no method found:  ' + methodName);
            });
        },
        hasEntity(fullName){
            return _.find(this.$store.getters.entities, fullName);
        }
    }
}

export const fileRefComponent = {
    mixins  : [ component ],
    props   : {
        query  : String,
        fileRef: Object
    },
    data(){
        return { file: false }
    },
    mounted(){
        if ( this.query ) this.handleQuery(this.query);
        if ( this.fileRef ) this.file = this.fileRef
    },
    computed: {
        entity(){
            return this.file.entity;
        }
    },
    watch   : {
        query(val){
            this.file = false;
            this.handleQuery(val);
        },
        fileRef(val){ this.file = val }
    },
    methods : {
        handleQuery(ref){
            let parsed = this.$phpdoc.parseRef(ref);
            if ( ! parsed.isEntity ) {
                throw new Error('Parsed ref is not for method: ' + ref)
            }
            this.getEntity(parsed.entityName).then(file => this.file = file);
        }
    }
}

export const methodRefComponent = {
    mixins : [ component ],
    props  : {
        query    : String,
        methodRef: Object
    },
    data(){
        return { method: false }
    },
    mounted(){
        if ( this.query ) this.handleQuery(this.query);
        if ( this.methodRef ) this.method = this.methodRef;
    },
    watch  : {
        query(val){
            this.method = false;
            this.handleQuery(val);
        },
        methodRef(val){ this.method = val;}
    },
    methods: {
        handleQuery(ref){
            let parsed = this.$phpdoc.parseRef(ref);
            if ( ! parsed.isMethod ) {
                throw new Error('Parsed ref is not for method: ' + ref)
            }
            this.getMethod(parsed.entityName, parsed.methodName).then(method => this.method = method);
        }
    }
}