const directives = require("./directives");
const filters = require("./filters");
const api = require("./utils/api");
const mixins = require("./mixins");
const utils = require("./utils");
filters['removeStartSlash'] = utils.removeStartSlash;
let plugin = function (Vue, options = {}) {
    if (plugin.installed)
        return;
    Vue.codex.extend({
        phpdoc: _.merge({}, api, utils, {
            mixins,
        })
    });
    Object.defineProperties(Vue.prototype, {
        $phpdoc: { get() { return Vue.codex.phpdoc; } }
    });
    const components = require('components/phpdoc');
    Object.keys(components).forEach(key => Vue.component(key, components[key]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[key]));
    Object.keys(filters).forEach(key => Vue.filter(key, filters[key]));
    if (Vue.codex.store) {
        const { module, types } = require('./store');
        Vue.codex.store.registerModule('phpdoc', module);
        Vue.codex.phpdoc.types = types;
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = plugin;
//# sourceMappingURL=plugin.js.map