// import * as components from "components/phpdoc";
import * as directives from "./directives";
import * as filters from "./filters";
import * as api from './utils/api'
import * as mixins from './mixins'
import * as utils from './utils'
import PHPDoc from "./utils/PHPDoc";
import { Tag } from "./utils/api";

filters[ 'removeStartSlash' ] = utils.removeStartSlash;


let plugin: any = function (Vue, options: any = {}) {
    if ( plugin.installed ) return;

    // let phpdoc = new PHPDoc(Vue.codex.store);

    Vue.codex.extend({
        phpdoc: _.merge({}, api, utils, {
            mixins,
        })
    })


    Object.defineProperties(Vue.prototype, {
        $phpdoc: { get () { return Vue.codex.phpdoc } }
    })

    const components = require('components/phpdoc')

    Object.keys(components).forEach(key => Vue.component(key, components[ key ]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[ key ]));
    Object.keys(filters).forEach(key => Vue.filter(key, filters[ key ]));

    if ( Vue.codex.store ) {
        const { module, types } = require('./store');
        Vue.codex.store.registerModule('phpdoc', module);
        Vue.codex.phpdoc.types = types;

    }
};

export default plugin;