var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
const Vue = require("vue");
const api = require("./utils/api");
const util_1 = require("@radic/util");
const bag = util_1.Storage.getOrCreateBag('codex.phpdoc', "local");
const emit = (...params) => Vue.codex.events.$emit.apply(Vue.codex.events, params);
exports.types = {
    ADD_ENTITY: 'phpdoc/ADD_ENTITY',
    SET_TREE: 'phpdoc/SET_TREE',
    SET_FILE: 'phpdoc/SET_FILE',
    SET_LOADING: 'phpdoc/SET_LOADING',
    SET_ENTITIES: 'phpdoc/SET_ENTITIES',
    MERGE_METHODS_SETTINGS: 'phpdoc/MERGE_METHODS_SETTINGS',
    MERGE_PROPERTIES_SETTINGS: 'phpdoc/MERGE_PROPERTIES_SETTINGS',
};
function getSettings(extra = {}) {
    return _.merge({
        show: {
            inherited: true,
            public: true,
            protected: true,
            private: true
        },
        sort: {
            by: '',
            dir: 'asc'
        },
        view: ''
    }, extra);
}
let state = {
    tree: Vue.codex.phpdoc.tree ? Vue.codex.phpdoc.tree : undefined,
    entities: Vue.codex.phpdoc.entities ? Vue.codex.phpdoc.entities : [],
    full_entities: [],
    settings: {
        methods: bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings({ show: { static: true, abstract: true, final: true } }),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings(),
    },
    global_settings: {
        methods: getSettings({ show: { static: true, abstract: true, final: true } }),
        properties: getSettings(),
    }
};
exports.module = {
    state,
    mutations: {
        [exports.types.SET_LOADING](state, loading) {
            if (typeof loading.tree === 'boolean')
                state.loading.tree = loading.tree;
            if (typeof loading.content === 'boolean')
                state.loading.content = loading.content;
            emit(exports.types.SET_LOADING);
        },
        [exports.types.SET_ENTITIES](state, entities) {
            state.entities = entities;
            emit(exports.types.SET_ENTITIES);
        },
        [exports.types.SET_TREE](state, tree) {
            state.tree = tree;
            emit(exports.types.SET_TREE);
        },
        [exports.types.SET_FILE](state, file) {
            state.file = file;
            state.fullName = file.entity.full_name;
            emit(exports.types.SET_FILE);
        },
        [exports.types.ADD_ENTITY](state, entity) {
            state.full_entities.push(entity);
        },
        [exports.types.MERGE_METHODS_SETTINGS](state, settings) {
            state.settings.methods = _.merge({}, state.settings.methods, settings);
            bag.set('settings.methods', state.settings.methods, { json: true });
            emit(exports.types.MERGE_METHODS_SETTINGS);
        },
        [exports.types.MERGE_PROPERTIES_SETTINGS](state, settings) {
            state.settings.properties = _.merge({}, state.settings.properties, settings);
            bag.set('settings.properties', state.settings.properties, { json: true });
            emit(exports.types.MERGE_PROPERTIES_SETTINGS);
        },
    },
    actions: {
        updatePhpdocEntities({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                api.getEntities({ tree: true }).then(tree => {
                    commit(exports.types.SET_TREE, tree);
                });
                return yield api.getEntities().then(entities => {
                    commit(exports.types.SET_ENTITIES, entities);
                });
            });
        },
        setPhpdocFile({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                if (state.fullName === payload) {
                    return;
                }
                return yield api.getEntity(payload, { full: true }).then(file => {
                    commit(exports.types.SET_FILE, file);
                });
            });
        },
        updatePhpdocTree({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                return new Promise((resolve, reject) => {
                    return api.getEntities({ tree: true }).then((tree => {
                        commit(exports.types.SET_TREE, tree);
                        resolve(tree);
                    }));
                });
            });
        },
        getPhpdocEntities({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                return new Promise((resolve, reject) => {
                    if (state.entities.length === 0) {
                        api.getEntities().then((entities => {
                            commit(exports.types.SET_ENTITIES, entities);
                            resolve(entities);
                        }));
                    }
                    else {
                        resolve(state.entities);
                    }
                });
            });
        },
        getPhpdocEntity({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                return new Promise((resolve, reject) => {
                    return api.getEntity(payload, { full: true }).then((entity => {
                        commit(exports.types.ADD_ENTITY, entity);
                        resolve(entity);
                    }));
                });
            });
        },
        updatePhpdocSettings({ state, commit, dispatch }, payload = undefined) {
            let type = payload.type === 'methods' ? exports.types.MERGE_METHODS_SETTINGS : exports.types.MERGE_PROPERTIES_SETTINGS;
            commit(type, payload.settings);
        },
        resetPhpdocSettings({ state, commit, dispatch }, payload = undefined) {
            if (payload && payload === 'methods') {
                commit(exports.types.MERGE_METHODS_SETTINGS, state.global_settings.methods);
            }
            else if (payload && payload === 'properties') {
                commit(exports.types.MERGE_PROPERTIES_SETTINGS, state.global_settings.properties);
            }
            else {
                commit(exports.types.MERGE_METHODS_SETTINGS, state.global_settings.methods);
                commit(exports.types.MERGE_PROPERTIES_SETTINGS, state.global_settings.properties);
            }
        },
    },
    getters: {
        fullName: state => state.fullName,
        tree: state => state.tree,
        entities: state => state.entities,
        full_entities: state => state.full_entities,
        settings: state => state.settings,
        global_settings: state => state.global_settings
    }
};
//# sourceMappingURL=store.js.map