import { Dispatch, Commit } from "vuex";
import Vue = require('vue')

//import { merge } from 'lodash';
import { getEntity, EntityTree, Entity, SimpleEntity, File } from './utils'
// import { getCookie, setCookie } from "codex/utils";
import * as  api from './utils/api'
import { Storage } from '@radic/util'

const bag  = Storage.getOrCreateBag('codex.phpdoc',"local");
const emit = (...params: any[]) => Vue.codex.events.$emit.apply(Vue.codex.events, params);

// const api    = container.get<any>('api')
// const config = container.get<any>('config')

export const types = {
    ADD_ENTITY               : 'phpdoc/ADD_ENTITY',
    SET_TREE                 : 'phpdoc/SET_TREE',
    SET_FILE                 : 'phpdoc/SET_FILE',
    SET_LOADING              : 'phpdoc/SET_LOADING',
    SET_ENTITIES             : 'phpdoc/SET_ENTITIES',
    MERGE_METHODS_SETTINGS   : 'phpdoc/MERGE_METHODS_SETTINGS',
    MERGE_PROPERTIES_SETTINGS: 'phpdoc/MERGE_PROPERTIES_SETTINGS',
};

export interface Settings {
    show?: {
        inherited?: boolean,
        public   ?: boolean,
        protected?: boolean,
        private  ?: boolean,

        static   ?: boolean,
        abstract ?: boolean,
        final    ?: boolean,
    }
    sort?: {
        by ?: string,
        dir?: 'asc' | 'desc'
    }
    view?: string

}
export interface State {
    tree: EntityTree
    entities: SimpleEntity[]
    full_entities: File[],
    settings: {
        methods: Settings,
        properties: Settings
    },
    global_settings: {
        methods: Settings,
        properties: Settings
    }
}

function getSettings(extra = {}): Settings {
    return _.merge({
        show: {
            inherited: true,
            public   : true,
            protected: true,
            private  : true
        },
        sort: {
            by : '',
            dir: 'asc'
        },
        view: ''
    }, extra)
}



let state = {
    tree         : Vue.codex.phpdoc.tree ? Vue.codex.phpdoc.tree : undefined,
    entities     : Vue.codex.phpdoc.entities ? Vue.codex.phpdoc.entities : [],
    full_entities: [],
    settings     : {
        methods   : bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings({ show: { static: true, abstract: true, final: true } }),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings(),
    },
    global_settings: {
        methods   : getSettings({ show: { static: true, abstract: true, final: true } }),
        properties: getSettings(),
    }
}

export let module = {
    state,
    mutations: {
        [types.SET_LOADING](state, loading) {
            if ( typeof loading.tree === 'boolean' ) state.loading.tree = loading.tree;
            if ( typeof loading.content === 'boolean' ) state.loading.content = loading.content;
            emit(types.SET_LOADING);
        },
        [types.SET_ENTITIES](state, entities: Entity[]) {
            state.entities = entities;
            emit(types.SET_ENTITIES);
        },
        [types.SET_TREE](state, tree: EntityTree) {
            state.tree = tree;
            emit(types.SET_TREE);
        },
        [types.SET_FILE](state, file: File) {
            state.file     = file;
            state.fullName = file.entity.full_name;
            emit(types.SET_FILE);
        },

        [types.ADD_ENTITY](state: State, entity: File){
            state.full_entities.push(entity);
        },
        [types.MERGE_METHODS_SETTINGS](state: State, settings: Settings) {
            state.settings.methods = _.merge({}, state.settings.methods, settings);
            bag.set('settings.methods', state.settings.methods, { json: true });
            emit(types.MERGE_METHODS_SETTINGS);
        },
        [types.MERGE_PROPERTIES_SETTINGS](state: State, settings: Settings) {
            state.settings.properties = _.merge({}, state.settings.properties, settings);
            bag.set('settings.properties', state.settings.properties, { json: true });
            emit(types.MERGE_PROPERTIES_SETTINGS);
        },
    },

    actions: {
        // async setProject({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
        //
        //     // console.trace();
        //     // return await dispatch('updateEntities');
        // },
        async updatePhpdocEntities({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            // console.trace('updatePhpdocEntities', { payload });
            api.getEntities({ tree: true }).then(tree => {
                commit(types.SET_TREE, tree);
            });

            return await api.getEntities().then(entities => {
                commit(types.SET_ENTITIES, entities);
            });
        },
        async setPhpdocFile({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            // console.trace('setPhpdocFile', { payload });
            if ( state.fullName === payload ) {
                return;
            }
            return await api.getEntity(payload, { full: true }).then(file => {
                commit(types.SET_FILE, file);
            });
        },
        // async updatePhpdoc({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
        //     // console.trace('updatePhpdoc', { payload });
        //     if ( (payload.project && payload.project !== state.project) || (payload.ref && payload.ref !== state.ref) ) {
        //         // commit(types.SET_PROJECT, { name: payload.project, ref: payload.ref });
        //         if ( ! payload.entity ) {
        //             await dispatch('updatePhpdocEntities');
        //             payload.entity = state.entities[ 0 ].full_name;
        //         } else {
        //             dispatch('updatePhpdocEntities')
        //         }
        //     }
        //     if ( payload.entity && state.fullName !== payload.entity ) {
        //         return await dispatch('setPhpdocFile', payload.entity);
        //     }
        // },


        async updatePhpdocTree({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            return new Promise((resolve, reject) => {
                return api.getEntities({ tree: true }).then((tree => {
                    commit(types.SET_TREE, tree);
                    resolve(tree);
                }))
            })
        },

        async getPhpdocEntities({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            return new Promise((resolve, reject) => {
                if(state.entities.length === 0) {
                    api.getEntities().then((entities => {
                        commit(types.SET_ENTITIES, entities);
                        resolve(entities);
                    }))
                } else {
                    resolve(state.entities);
                }
            })
        },
        async getPhpdocEntity({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            return new Promise((resolve, reject) => {
                return api.getEntity(payload, { full: true }).then((entity => {
                    commit(types.ADD_ENTITY, entity);
                    resolve(entity);
                }))
            })
        },
        updatePhpdocSettings({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            let type = payload.type === 'methods' ? types.MERGE_METHODS_SETTINGS : types.MERGE_PROPERTIES_SETTINGS;
            commit(type, payload.settings);
        },
        resetPhpdocSettings({ state, commit, dispatch }:{ state: State, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            if ( payload && payload === 'methods' ) {
                commit(types.MERGE_METHODS_SETTINGS, state.global_settings.methods)
            } else if ( payload && payload === 'properties' ) {
                commit(types.MERGE_PROPERTIES_SETTINGS, state.global_settings.properties)
            } else {
                commit(types.MERGE_METHODS_SETTINGS, state.global_settings.methods);
                commit(types.MERGE_PROPERTIES_SETTINGS, state.global_settings.properties);
            }
        },
    },
    getters: {
        fullName     : state => state.fullName,
        tree         : state => state.tree,
        entities     : state => state.entities,
        full_entities: state => state.full_entities,
        settings     : state => state.settings,
        global_settings     : state => state.global_settings
    }
};


// container.bind('store').toConstantValue(store);
