const util_1 = require("@radic/util");
const bag = util_1.Storage.getOrCreateBag('codex.phpdoc', "local");
const emit = (...params) => Vue.codex.events.$emit.apply(Vue.codex.events, params);
function getFiltered(type) {
    let items = _.chain(this.entity[type]);
    if (this.settings[type].show.inherited === false) {
        items = items.filter((item) => item.inherited !== true);
    }
    if (this.settings[type].show.public === false) {
        items = items.filter((item) => item.visibility !== 'public');
    }
    if (this.settings[type].show.protected === false) {
        items = items.filter((item) => item.visibility !== 'protected');
    }
    if (this.settings[type].show.private === false) {
        items = items.filter((item) => item.visibility !== 'private');
    }
    items = items.sortBy(this.settings[type].sort.by);
    if (this.settings[type].sort.dir === 'desc') {
        items = items.reverse();
    }
    return items.value();
}
exports.getFiltered = getFiltered;
class Filter {
    constructor(settings, type, items) {
        this.settings = settings;
        this.type = type;
        this.items = items;
    }
    getFiltered(type) {
        let items = _.chain(this.items);
        if (this.settings[type].show.inherited === false) {
            items = items.filter((item) => item.inherited !== true);
        }
        if (this.settings[type].show.public === false) {
            items = items.filter((item) => item.visibility !== 'public');
        }
        if (this.settings[type].show.protected === false) {
            items = items.filter((item) => item.visibility !== 'protected');
        }
        if (this.settings[type].show.private === false) {
            items = items.filter((item) => item.visibility !== 'private');
        }
        items = items.sortBy(this.settings[type].sort.by);
        if (this.settings[type].sort.dir === 'desc') {
            items = items.reverse();
        }
        return items.value();
    }
}
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = Filter;
function getSettings() {
    return {
        show: {
            inherited: false,
            public: true,
            protected: true,
            private: true
        },
        sort: {
            by: '',
            dir: 'asc'
        },
        view: ''
    };
}
let state = {
    fullName: '',
    tree: undefined,
    entities: [],
    file: undefined,
    loading: {
        tree: true,
        content: true
    },
    settings: {
        methods: bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings(),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings(),
    }
};
//# sourceMappingURL=Filter.js.map