
import { SimpleEntity, EntityTree } from "./api";
import { Storage, StorageBag } from '@radic/util'

const bag:StorageBag = Storage.getOrCreateBag('codex.phpdoc', "local");
const emit = (...params:any[]) => Vue.codex.events.$emit.apply(Vue.codex.events, params);

export function getFiltered(type) {
//                console.trace('getFiltered(type)', type, this.entity)
    let items: any = _.chain(this.entity[ type ]);
    if ( this.settings[ type ].show.inherited === false ) {
        items = items.filter((item) => item.inherited !== true);
    }
    if ( this.settings[ type ].show.public === false ) {
        items = items.filter((item) => item.visibility !== 'public');
    }
    if ( this.settings[ type ].show.protected === false ) {
        items = items.filter((item) => item.visibility !== 'protected');
    }
    if ( this.settings[ type ].show.private === false ) {
        items = items.filter((item) => item.visibility !== 'private');
    }

    //var a = _.sortBy(methods, this.sortMethodsBy);
//

    items = items.sortBy(this.settings[ type ].sort.by);

    if ( this.settings[ type ].sort.dir === 'desc' ) {
        items = items.reverse();
    }
    // this.count[ type ] = items.value().length;

    return items.value();
}


export default class Filter {
    constructor(protected settings: any, protected type: string, protected items: any[]) {

    }


    getFiltered(type) {
        let items: any = _.chain(this.items);

        if ( this.settings[ type ].show.inherited === false ) {
            items = items.filter((item) => item.inherited !== true);
        }
        if ( this.settings[ type ].show.public === false ) {
            items = items.filter((item) => item.visibility !== 'public');
        }
        if ( this.settings[ type ].show.protected === false ) {
            items = items.filter((item) => item.visibility !== 'protected');
        }
        if ( this.settings[ type ].show.private === false ) {
            items = items.filter((item) => item.visibility !== 'private');
        }

        items = items.sortBy(this.settings[ type ].sort.by);

        if ( this.settings[ type ].sort.dir === 'desc' ) {
            items = items.reverse();
        }

        return items.value();
    }
}

export interface Settings {
    show?: {
        inherited?: boolean,
        public   ?: boolean,
        protected?: boolean,
        private  ?: boolean
    }
    sort?: {
        by ?: string,
        dir?: 'asc' | 'desc'
    }
    view?: string

}
export interface State {
    fullName: string
    tree: EntityTree
    entities: SimpleEntity[]
    file: File,
    loading: {
        tree: boolean,
        content: boolean
    }
    settings: {
        methods: Settings,
        properties: Settings
    }
}

function getSettings(): Settings {
    return {
        show: {
            inherited: false,
            public   : true,
            protected: true,
            private  : true
        },
        sort: {
            by : '',
            dir: 'asc'
        },
        view: ''
    }
}

let state: State = {
    fullName: '',
    tree    : undefined,
    entities: [],
    file    : undefined,
    loading : {
        tree   : true,
        content: true
    },
    settings: {
        methods   : bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings(),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings(),
    }
}
