
import { Method, Property } from "./api";
export default class FullyQualifiedNameParser {
    static Entity: string    = 'entity';
    static Method: string   = 'method';
    static Property: string = 'property';

    name: string         = '';
    entityName: string    = '';
    methodName: string   = '';
    propertyName: string = '';
    type: string         = 'entity';

    constructor(name) {

        let exp     = /^(.*?)(?:$|\:{2}(.*))$/gm
        let matches = [];
        let myArr;
        while ( (myArr = exp.exec(name)) !== null ) { matches.push(myArr); }

        if ( matches.length !== 1 || matches[ 0 ].length !== 3 ) throw new Error('not valid fqn');

        let m     = matches[ 0 ];
        this.name = name;
        this.type = 'entity';

        if ( m[ 2 ] !== undefined ) {
            this.type = m[ 2 ].indexOf('()') !== - 1 ? 'method' : 'property';
        }

        this.entityName    = m[ 1 ];
        this[ this.type + 'Name' ] = this.type === 'method' ? m[ 2 ].replace('()', '') : m[ 2 ];
    }

    is(type: string): boolean { return this.type === type; }

    isEntity(): boolean { return this.is(FullyQualifiedNameParser.Entity); }

    isMethod(): boolean { return this.is(FullyQualifiedNameParser.Method); }

    isProperty(): boolean { return this.is(FullyQualifiedNameParser.Property); }

    toString(): string { return this.name; }

    requestApi(): Promise<File|Method|Property> {
        if(this.isEntity()) {
            return Vue.codex.phpdoc.getEntity(this.entityName)
        } else if(this.isMethod()){
            return Vue.codex.phpdoc.getMethod(this.entityName, this.methodName)
        } else if(this.isProperty()){
            return Vue.codex.phpdoc.getProperty(this.entityName, this.propertyName)
        }
    }

}