class HashPathParser {
    constructor(hashPath) {
        this.hashPath = '';
        this.classPath = '';
        this.type = 'class';
        this.method = '';
        this.property = '';
        this.line = 0;
        if (!this.isHashPath())
            return;
        let exp = /^\#\!\/(.*?)(?:$|\:{2}(.*)|\!(.*?)(?:\@(\d*)|$))$/gm;
        let matches = [];
        let myArr;
        while ((myArr = exp.exec(hashPath)) !== null) {
            matches.push(myArr);
        }
        if (matches.length !== 1 || matches[0].length !== 5)
            throw new Error('not valid url string');
        let m = matches[0];
        this.hashPath = hashPath;
        this.type = 'class';
        if (m[2] !== undefined) {
            this.type = m[2].indexOf('()') !== -1 ? 'method' : 'property';
        }
        if (m[3] !== undefined) {
            this.type = m[3];
        }
        this.classPath = m[1];
        this[this.type] = this.type === 'method' ? m[2].replace('()', '') : m[2];
        this.line = parseInt(m[4]) || 0;
    }
    static parse(hashPath) {
        return new HashPathParser(hashPath);
    }
    is(type) { return this.type === type; }
    isClass() { return this.is(HashPathParser.Class); }
    isMethod() { return this.is(HashPathParser.Method); }
    isProperty() { return this.is(HashPathParser.Property); }
    isSource() { return this.is(HashPathParser.Source); }
    hasLine() { return this.isSource() && this.line > 0; }
    isHashPath() {
        return location.hash.indexOf('#!/') !== -1;
    }
    getHashPath() {
        if (!this.isHashPath())
            throw new Error('Current location is not a hashed path');
        return location.hash;
    }
    toQuery() {
        if (this.isClass())
            return this.classPath;
        if (this.isMethod())
            return this.classPath + '::' + this.method + '()';
        if (this.isProperty())
            return this.classPath + '::' + this.property;
        if (this.isSource()) {
            return this.classPath + '::';
        }
    }
    toString() { return this.hashPath; }
}
HashPathParser.Class = 'class';
HashPathParser.Method = 'method';
HashPathParser.Property = 'property';
HashPathParser.Source = 'source';
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = HashPathParser;
//# sourceMappingURL=HashPathParser.js.map