const HashPathParser_1 = require("./HashPathParser");
class Navigator {
    parseHashPath(hashPath) {
        return new HashPathParser_1.default(hashPath);
    }
    isHashPath() {
        return location.hash.indexOf('#!/') !== -1;
    }
    getHashPath() {
        if (!this.isHashPath())
            throw new Error('Current location is not a hashed path');
        return location.hash;
    }
    getParsedHashPath() {
        return this.parseHashPath(this.getHashPath());
    }
    init(path) {
        let hashPath;
        if (path)
            hashPath = this.parseHashPath(path);
        else if (this.isHashPath())
            hashPath = this.getParsedHashPath();
        else
            hashPath = new HashPathParser_1.default('');
    }
    open() {
    }
}
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = Navigator;
//# sourceMappingURL=Navigator.js.map