
import HashPathParser from "./HashPathParser";
/**
 * Should parse the URL for:
 * - class:        http://localhost/phpdoc.html#!/\Codex\Codex
 * - method:       http://localhost/phpdoc.html#!/\Codex\Codex::get()
 * - property:     http://localhost/phpdoc.html#!/\Codex\Codex::getters
 * - source:       http://localhost/phpdoc.html#!/\Codex\Codex!source@23
 *
 * "Hashed Paths" are:
 * - #!/\Codex\Codex
 * - #!/\Codex\Codex::get()
 * - #!/\Codex\Codex::getters
 * - #!/\Codex\Codex!source@23
 *
 * Using popstate and replaceState it should log/integrate actions into history AND it should auto-update the browser URL
 * - open class/interface/trait
 * - open methods tab
 * - view method
 * - open properties tab
 * - open source tab
 *
 */
export default class Navigator {

    protected parseHashPath(hashPath) {
        return new HashPathParser(hashPath);
    }

    /** Checks if the current location is a "hashed path" **/
    isHashPath() {
        return location.hash.indexOf('#!/') !== - 1
    }

    /** Returns the current location's hash path **/
    getHashPath() {
        if ( ! this.isHashPath() ) throw new Error('Current location is not a hashed path')
        return location.hash;
    }

    /** Returns the current location's parsed hash path **/
    getParsedHashPath() {
        return this.parseHashPath(this.getHashPath());
    }

    init(path?: string) {
        let hashPath: HashPathParser;

        if ( path )
        // check if path was given, means we want to open this path
            hashPath = this.parseHashPath(path);
        else if ( this.isHashPath() )
        // check if the current location contains a hash, which means we want to open a specific doc page
            hashPath = this.getParsedHashPath();
        else
        // auto resolve the hashPath then
            hashPath = new HashPathParser('');
        //
        // return;
        // window.history.replaceState(null, hashPath.toString(), window.location.pathname + hashPath.toString());
        //
        //     window.addEventListener("popstate", (event) =>
        //     {
        //
        //         if (location.hash.indexOf('#!/') !== -1) {
        //             this.setPhpdocFile(location.hash.replace(/\#\!\//, ''));
        //         }
        //     }, false);
    }

    open() {
        // window.history.pushState(null, this.file.entity.full_name, window.location.pathname + "#!/" + this.file.entity.full_name);
    }
}