import Vue = require('vue')
import { create as axiosCreate } from 'axios'

const api = Vue.codex.api;

function defaultOptions(defaults: any = {}, params: any = {}) {
    let project = Vue.codex.project,
        ref     = Vue.codex.ref;

    return { params: _.merge({ project, ref }, defaults, params) };
}

export async function getEntities(params: any = {}): Promise<SimpleEntity[]> {
    return <any> new Promise((resolve, reject) => {
        api
            .get('phpdoc/entities', defaultOptions({ tree: false, full: false }, params))
            .catch(err => reject(err))
            .then((res: any) => resolve(res.data))
    });
}

export async function getEntity(entity: string, params: any = {}): Promise<File> {
    if ( entity === undefined ) {
        console.trace('entity undefined');
        throw new Error('entity undefined');
    }
    return <any> new Promise((resolve, reject) => {
        api
            .get('phpdoc/entity', defaultOptions({ entity }, params))
            .catch(err => reject(err))
            .then((res: any) => resolve(res.data))
    });
}

export async function getMethod(entity: string, method: string, params: any = {}): Promise<Method> {
    return <any> new Promise((resolve, reject) => {
        api
            .get('phpdoc/method', defaultOptions({ entity, method }, params))
            .catch(err => reject(err))
            .then((res: any) => resolve(res.data))
    });
}

export async function getProperty(entity: string, property: string, params: any = {}): Promise<Property> {
    return <any> new Promise((resolve, reject) => {
        api
            .get('phpdoc/method', defaultOptions({ entity, property }, params))
            .catch(err => reject(err))
            .then((res: any) => resolve(res.data))
    });
}

export type VisibilityType = 'public' | 'protected' | 'private';
export type EntityType = 'class' | 'interface' | 'trait';

export interface BaseEntityMember {
    name: string
    full_name: string
    namespace: string
    line: number
}

export interface Method extends BaseEntityMember {
    arguments: Argument[]
    abstract: boolean
    class_name: string
    description: string
    final: boolean
    inherited: boolean
    'long-description': string
    package: string
    returns: string[]
    static: boolean
    tags: Tag[]
    throws: string[],
    visibility: VisibilityType
}
export interface Argument {
    byref: boolean
    default: any
    description: string
    name: string
    types: string[]
}
export interface Constant extends BaseEntityMember {
    value: string
}
export interface Property extends BaseEntityMember {
    class_name: string
    description: string
    inherited: boolean
    'long-description': string
    package: string
    static: boolean
    tags: Tag[]
    types: string[]
    visibility: VisibilityType

}
export interface Tag {
    description: string
    line: string
    name: string
    type: string
    variable: string
}

export interface SimpleEntity {
    full_name: string
    name: string
    namespace: string
    type: EntityType
}
export interface Entity extends SimpleEntity {
    abstract: boolean
    constants: Constant[]
    description: string
    extends: string
    final: boolean
    implements: string | string[]
    'long-description': string
    methods: Method[]
    name: string
    namespace: string
    properties: Property[]
    tags: Tag[]
}
export interface File {
    file_description: string,
    'file_long-description': string
    hash: string
    parse_markers: any
    path: string
    source: string
    type: EntityType
    uses: string[]
    entity: Entity
}
export interface EntityTree {
    [key: string]: SimpleEntity | EntityTree|SimpleEntity[]
}