//import { chain, filter, find, last } from 'lodash';
import { Tag } from "./api";

export function removeStartSlash(value: string) {
    if ( value === undefined ) {
        return;
    }
    var matches = value.match(/^\\(.*)/);
    if ( matches !== null && matches.length === 2 ) {
        return matches[ 1 ];
    }
    return value;
};

export function Type(name) {
    this.type        = name;
    this.name        = name;
    this.fullName    = name;
    this.entities    = Vue.codex.store.getters.entities;
    this.isEntity    = this.name[ 0 ] === '\\';
    this.isPrimitive = this.isEntity === false;
    this.isLocal     = false;
    this.isExternal  = false;
    this.entity      = {};
    let classes      = [];

    if ( this.isEntity ) {
        this.fullName   = removeStartSlash(this.name);
        this.name       = _.last(this.type.split('\\'));
        this.isExternal = true;
        if ( this.entities ) {
            this.entity     = _.find(this.entities, { full_name: this.type });
            this.isLocal    = this.entity !== undefined;
            this.isExternal = ! this.isLocal;
        }
        classes.push('phpdoc-type-' + (this.isLocal ? this.entity.type : 'external'));
    } else {
        classes.push('phpdoc-type-simple');
        classes.push('phpdoc-type-simple-' + this.type);
    }
    this.cssClass = classes.join(' ')
    //
}

export interface ParsedRef {

    isEntity?: boolean
    isMethod?: boolean
    isProperty?: boolean

    entityName?: string | null
    methodName?: string | null
    propertyName?: string | null
}
export function parseFullName(fullName) {
    return parseRef(fullName)
}
export function parseRef(ref): ParsedRef {
    return Query.from(ref);
}

export class Query implements ParsedRef{

    isEntity  : boolean = false
    isMethod  : boolean = false
    isProperty: boolean = false


    entityName  : string = null
    methodName  : string = null
    propertyName: string = null
    
    constructor(public query:string){
        if ( query.indexOf('::') !== - 1 ) {
            this.entityName = query.split('::')[ 0 ];
            if ( query.indexOf('()') !== - 1 ) {
                this.methodName = query.split('::')[ 1 ].replace('()', '')
                this.isMethod   = true;
            } else {
                this.propertyName = query.split('::')[ 1 ]
                this.isProperty   = true
            }
        } else {
            this.entityName = query;
            this.isEntity   = true;
        }
        if ( this.entityName[ 0 ] !== '\\' ) {
            this.entityName = '\\' + this.entityName;
        }
    }

    static from(query:string) : Query {
        return new Query(query);
    }

    toString(){
        return this.query;
    }
}

export class Tags {
    constructor(public tags: Tag[] = []) {}

    get length() { return this.tags.length }

    has(name: string): boolean { return this.get(name) !== undefined; }

    get(name: string): Tag|Tag[] { return _.find(this.tags, { name }) }

    where(k: string, v: string): Tag|Tag[] { return _.find(this.tags, { [k]: v }); }

    exclude(vals: any[], key: string = 'name') {
        return new Tags(_.filter(this.tags, (tag: Tag) => vals.indexOf(tag[ key ]) === - 1))
    }

    toArray() {return this.tags;}

    isEmpty() { return this.tags.length === 0 }
}

