// Licensed Materials - Property of IBM
// 5725-I43 (C) Copyright IBM Corp. 2015. All Rights Reserved.
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

/*jslint node:true */
/*jshint node:true */

'use strict';

function define(name, value) {
    Object.defineProperty(exports, name, {
        value: value,
        enumerable: true
    });
}

// Package name
define('MODULE', 'mfp-config-xml');

// Platforms
define('ANDROID', 'android');
define('IOS', 'ios');
define('WIN8', 'windows8');
define('WINPHONE8', 'windowsphone8');
define('WIN10', 'windows10');
define('WIN', 'windows');
define('PLATFORM', 'platform');

// Method prefixes
define('GET', 'get');
define('SET', 'set');
define('DELETE', 'delete');

// Method params
define('VALUE', 'value');

// Get, set, and delete methods
define('GET_PLATFORM_ATTRIB',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.getValue({0}, {5});' +
        '} else if (platform === "android") {' +
            'return this.getValue({1}, {5});' +
        '} else if (platform === "windows8") {' +
            'return this.getValue({2}, {5});' +
        '} else if (platform === "windowsphone8") {' +
            'return this.getValue({3}, {5});' +
        '} else if (platform === "windows10") {' +
            'return this.getValue({4}, {5});' +
        '}' +
    '}'
);
define('GET_PLATFORM_ATTRIB_ALT',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.getValue({0}, {3});' +
        '} else if (platform === "android") {' +
            'return this.getValue({1}, {3});' +
        '} else if (platform === "windows") {' +
            'return this.getValue({2}, {3});' +
        '}' +
    '}'
);
define('GET_ATTRIB', 'return this.getValue({0}, {1});');
define('GET_PLATFORM_TEXT',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.getValue({0});' +
        '} else if (platform === "android") {' +
            'return this.getValue({1});' +
        '} else if (platform === "windows8") {' +
            'return this.getValue({2});' +
        '} else if (platform === "windowsphone8") {' +
            'return this.getValue({3});' +
        '} else if (platform === "windows10") {' +
            'return this.getValue({4});' +
        '}' +
    '}'
);
define('GET_PLATFORM_TEXT_ALT',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.getValue({0});' +
        '} else if (platform === "android") {' +
            'return this.getValue({1});' +
        '} else if (platform === "windows") {' +
            'return this.getValue({2});' +
        '}' +
    '}'
);
define('GET_TEXT', 'return this.getValue({0});');
define('SET_PLATFORM_ATTRIB',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.setValue({0}, value, {5});' +
        '} else if (platform === "android") {' +
            'return this.setValue({1}, value, {5});' +
        '} else if (platform === "windows8") {' +
            'return this.setValue({2}, value, {5});' +
        '} else if (platform === "windowsphone8") {' +
            'return this.setValue({3}, value, {5});' +
        '} else if (platform === "windows10") {' +
            'return this.setValue({4}, value, {5});' +
        '}'+
    '}'
);
define('SET_PLATFORM_ATTRIB_ALT',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.setValue({0}, value, {3});' +
        '} else if (platform === "android") {' +
            'return this.setValue({1}, value, {3});' +
        '} else if (platform === "windows") {' +
            'return this.setValue({2}, value, {3});' +
        '}'+
    '}'
);
define('SET_ATTRIB',
    'return this.setValue({0}, value, {1});'
);
define('SET_TEXT', 'return this.setValue({0}, value);');
define('SET_PLATFORM_TEXT',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.setValue({0}, value);' +
        '} else if (platform === "android") {' +
            'return this.setValue({1}, value);' +
        '} else if (platform === "windows8") {' +
            'return this.setValue({2}, value);' +
        '} else if (platform === "windowsphone8") {' +
            'return this.setValue({3}, value);' +
        '} else if (platform === "windows10") {' +
            'return this.setValue({4}, value);' +
        '}'+
    '}'
);
define('SET_PLATFORM_TEXT_ALT',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.setValue({0}, value);' +
        '} else if (platform === "android") {' +
            'return this.setValue({1}, value);' +
        '} else if (platform === "windows") {' +
            'return this.setValue({2}, value);' +
        '}'+
    '}'
);
define('DELETE_PLATFORM_ELEMENT',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.deleteElement({0});' +
        '} else if (platform === "android") {' +
            'return this.deleteElement({1});' +
        '} else if (platform === "windows8") {' +
            'return this.deleteElement({2});' +
        '} else if (platform === "windowsphone8") {' +
            'return this.deleteElement({3});' +
        '} else if (platform === "windows10") {' +
            'return this.deleteElement({4});' +
        '}'+
    '}'
);
define('DELETE_PLATFORM_ELEMENT_ALT',
    'if (platform) {' +
        'if (platform === "ios") {' +
            'return this.deleteElement({0});' +
        '} else if (platform === "android") {' +
            'return this.deleteElement({1});' +
        '} else if (platform === "windows") {' +
            'return this.deleteElement({2});' +
        '}'+
    '}'
);
define('DELETE_ELEMENT', 'return this.deleteElement({0});');

// Method map
define('METHOD_MAP',
    [
        {
            'name': 'MFPNameSpace',
            'path': '"./"',
            'attrib': '"xmlns:mfp"',
            'param': [],
            'defaultValue': 'http://www.ibm.com/mobilefirst/cordova-plugin-mfp'
        },
        {
            'name': 'WidgetId',
            'path': '"./"',
            'attrib': '"id"',
            'param': [],
            'defaultValue': ''
        },
        {
            'name': 'WidgetVersion',
            'path': '"./"',
            'attrib': '"version"',
            'param': [],
            'defaultValue': ''
        },
        {
            'name': 'WidgetName',
            'path': '"./name"',
            'param': [],
            'defaultValue': ''
        },
        {
            'name': 'MainFile',
            'path': '"./content"',
            'attrib': '"src"',
            'param': [],
            'defaultValue': ''
        },
        {
            'name': 'MFPSDKChecksum',
            'path': {
                'android': '"./mfp:android,./mfp:sdkChecksum"',
                'ios': '"./mfp:ios,./mfp:sdkChecksum"',
                'win8': '"./mfp:windows,./mfp:windows8,./mfp:sdkChecksum"',
                'winphone8': '"./mfp:windows,./mfp:windowsphone8,./mfp:sdkChecksum"',
                'win10': '"./mfp:windows,./mfp:windows10,./mfp:sdkChecksum"'

            },
            'param': ['platform'],
            'defaultValue': '0'
        },
        {
            'name': 'MFPAppChecksum',
            'path': {
                'android': '"./mfp:android,./mfp:appChecksum"',
                'ios': '"./mfp:ios,./mfp:appChecksum"',
                'win': '"./mfp:windows,./mfp:appChecksum"',
            },
            'param': ['platform'],
            'defaultValue': '0'
        },
        {
            'name': 'MFPPlatformVersion',
            'path': '"./mfp:platformVersion"',
            'param': [],
            'defaultValue': ''
        },
        {
            'name': 'MFPClientCustomInit',
            'path': '"./mfp:clientCustomInit"',
            'attrib': '"enabled"',
            'param': [],
            'defaultValue': 'false'
        },
        {
            'name': 'MFPServerURL',
            'path': '"./mfp:server"',
            'attrib': '"url"',
            'param': [],
            'defaultValue': 'http://10.0.0.1:9080'
        },
        {
            'name': 'MFPServerRuntime',
            'path': '"./mfp:server"',
            'attrib': '"runtime"',
            'param': [],
            'defaultValue': 'mfp'
        },
        {
            'name': 'MFPDirectUpdateAuthKey',
            'path': '"./mfp:directUpdateAuthenticityPublicKey"',
            'param': [],
            'defaultValue': ''
        },
        {
            'name': 'MFPTestWebResources',
            'path': {
                'android': '"./mfp:android,./mfp:security,./mfp:testWebResourcesChecksum"',
                'ios': '"./mfp:ios,./mfp:security,./mfp:testWebResourcesChecksum"',
                'win8': '"./mfp:windows,./mfp:windows8,./mfp:security,./mfp:testWebResourcesChecksum"',
                'winphone8': '"./mfp:windows,./mfp:windowsphone8,./mfp:security,./mfp:testWebResourcesChecksum"',
                'win10': '"./mfp:windows,./mfp:windows10,./mfp:security,./mfp:testWebResourcesChecksum"'
            },
            'attrib': '"enabled"',
            'param': ['platform'],
            'defaultValue': 'false'
        },
        {
            'name': 'MFPIgnoreFileExtensions',
            'path': {
                'android': '"./mfp:android,./mfp:security,./mfp:testWebResourcesChecksum"',
                'ios': '"./mfp:ios,./mfp:security,./mfp:testWebResourcesChecksum"',
                'win8': '"./mfp:windows,./mfp:windows8,./mfp:security,./mfp:testWebResourcesChecksum"',
                'winphone8': '"./mfp:windows,./mfp:windowsphone8,./mfp:security,./mfp:testWebResourcesChecksum"',
                'win10': '"./mfp:windows,./mfp:windows10,./mfp:security,./mfp:testWebResourcesChecksum"'
            },
            'attrib': '"ignoreFileExtensions"',
            'param': ['platform'],
            'defaultValue': 'png, jpg, jpeg, gif, mp4, mp3'
        },
        {
            'name': 'MFPLanguagePrefs',
            'path': '"./mfp:languagePreferences"',
            'param': [],
            'defaultValue': 'en'
        }
    ]
);
