'use strict';
var gulp = require("gulp");

var gulpJsdoc2md = require("gulp-jsdoc-to-markdown");
var concat = require("gulp-concat");



// =============================================================================
// ================================= Documentation  ============================
// =============================================================================

gulp.task("build:docs:md", function() {
    return gulp.src("lib/node-cpython.js")
        .pipe(concat("API.md"))
        .pipe(gulpJsdoc2md())
        .on("error", function(err){
            gutil.log("jsdoc2md failed:", err.message);
        })
        .pipe(gulp.dest("doc"));
});

gulp.task('build:readme', function() {
  return gulp.src(['doc/README.md', 'doc/API.md', 'doc/LICENSE.md'])
    .pipe(concat('README.md'))
    .pipe(gulp.dest('.'));
});

// =============================================================================
// ================================= Gulp  =====================================
// =============================================================================

/**
*
*/
gulp.task('watch', function() {
  gulp.watch('src/es6/**/*.js', gulp.series('babel'));
  gulp.watch('test/**/*.spec.js', gulp.series('mocha'));
  gulp.watch().on('error', gutil.log)
});

gulp.task('gen:docs', gulp.series('build:docs:md', 'build:readme'))
gulp.task('default', gulp.series(gulp.parallel('watch')));
// gulp.task('default', gulp.series(gulp.series('tape'), gulp.parallel('watch')));
