{
    if ("undefined" == typeof g_all_modules) {
        g_all_modules = {};
    }
    g_all_modules["sp.js"] = {
        "version": {
            "rmj": 16,
            "rmm": 0,
            "rup": 4719,
            "rpr": 1224
        }
    };
}
if (typeof spWriteProfilerMark == 'function')
    spWriteProfilerMark("perfMarkBegin_" + "sp.js");
Type.registerNamespace('SP');
SP.ULSTraceLevel = function() {
};
SP.ULSTraceLevel.prototype = {
    verbose: 100
};
SP.ULSTraceLevel.registerEnum('SP.ULSTraceLevel', false);
SP.AddFieldOptions = function() {
};
SP.AddFieldOptions.prototype = {
    defaultValue: 0,
    addToDefaultContentType: 1,
    addToNoContentType: 2,
    addToAllContentTypes: 4,
    addFieldInternalNameHint: 8,
    addFieldToDefaultView: 16,
    addFieldCheckDisplayName: 32
};
SP.AddFieldOptions.registerEnum('SP.AddFieldOptions', false);
SP.AppInstanceErrorSource = function() {
};
SP.AppInstanceErrorSource.prototype = {
    common: 0,
    appWeb: 1,
    parentWeb: 2,
    remoteWebSite: 3,
    database: 4,
    officeExtension: 5,
    eventCallouts: 6,
    finalization: 7
};
SP.AppInstanceErrorSource.registerEnum('SP.AppInstanceErrorSource', false);
SP.AppInstanceErrorType = function() {
};
SP.AppInstanceErrorType.prototype = {
    transient: 0,
    configuration: 1,
    app: 2
};
SP.AppInstanceErrorType.registerEnum('SP.AppInstanceErrorType', false);
SP.AppInstanceStatus = function() {
};
SP.AppInstanceStatus.prototype = {
    invalidStatus: 0,
    installing: 1,
    canceling: 7,
    uninstalling: 4,
    installed: 5,
    upgrading: 8,
    initialized: 9,
    upgradeCanceling: 10,
    disabling: 11,
    disabled: 12,
    secretRolling: 13,
    recycling: 14,
    recycled: 15,
    restoring: 16,
    restoreCanceling: 17
};
SP.AppInstanceStatus.registerEnum('SP.AppInstanceStatus', false);
SP.AppLicenseType = function() {
};
SP.AppLicenseType.prototype = {
    perpetualMultiUser: 0,
    perpetualAllUsers: 1,
    trialMultiUser: 2,
    trialAllUsers: 3
};
SP.AppLicenseType.registerEnum('SP.AppLicenseType', false);
SP.AppType = function() {
};
SP.AppType.prototype = {
    doclib: 0,
    list: 1,
    tenant: 2,
    instance: 3,
    feature: 4,
    commonList: 5
};
SP.AppType.registerEnum('SP.AppType', false);
SP.AuditMaskType = function() {
};
SP.AuditMaskType.prototype = {
    none: 0,
    checkOut: 1,
    checkIn: 2,
    view: 4,
    objectDelete: 8,
    update: 16,
    profileChange: 32,
    childDelete: 64,
    schemaChange: 128,
    securityChange: 256,
    undelete: 512,
    workflow: 1024,
    copy: 2048,
    move: 4096,
    search: 8192,
    all: -1
};
SP.AuditMaskType.registerEnum('SP.AuditMaskType', false);
SP.BaseType = function() {
};
SP.BaseType.prototype = {
    none: -1,
    genericList: 0,
    documentLibrary: 1,
    unused: 2,
    discussionBoard: 3,
    survey: 4,
    issue: 5
};
SP.BaseType.registerEnum('SP.BaseType', false);
SP.BrowserFileHandling = function() {
};
SP.BrowserFileHandling.prototype = {
    permissive: 0,
    strict: 1
};
SP.BrowserFileHandling.registerEnum('SP.BrowserFileHandling', false);
SP.CalendarType = function() {
};
SP.CalendarType.prototype = {
    none: 0,
    gregorian: 1,
    japan: 3,
    taiwan: 4,
    korea: 5,
    hijri: 6,
    thai: 7,
    hebrew: 8,
    gregorianMEFrench: 9,
    gregorianArabic: 10,
    gregorianXLITEnglish: 11,
    gregorianXLITFrench: 12,
    koreaJapanLunar: 14,
    chineseLunar: 15,
    sakaEra: 16,
    umAlQura: 23
};
SP.CalendarType.registerEnum('SP.CalendarType', false);
SP.ChangeType = function() {
};
SP.ChangeType.prototype = {
    noChange: 0,
    add: 1,
    update: 2,
    deleteObject: 3,
    rename: 4,
    moveAway: 5,
    moveInto: 6,
    restore: 7,
    roleAdd: 8,
    roleDelete: 9,
    roleUpdate: 10,
    assignmentAdd: 11,
    assignmentDelete: 12,
    memberAdd: 13,
    memberDelete: 14,
    systemUpdate: 15,
    navigation: 16,
    scopeAdd: 17,
    scopeDelete: 18,
    listContentTypeAdd: 19,
    listContentTypeDelete: 20,
    dirty: 21
};
SP.ChangeType.registerEnum('SP.ChangeType', false);
SP.CheckinType = function() {
};
SP.CheckinType.prototype = {
    minorCheckIn: 0,
    majorCheckIn: 1,
    overwriteCheckIn: 2
};
SP.CheckinType.registerEnum('SP.CheckinType', false);
SP.CheckOutType = function() {
};
SP.CheckOutType.prototype = {
    online: 0,
    offline: 1,
    none: 2
};
SP.CheckOutType.registerEnum('SP.CheckOutType', false);
SP.ChoiceFormatType = function() {
};
SP.ChoiceFormatType.prototype = {
    dropdown: 0,
    radioButtons: 1
};
SP.ChoiceFormatType.registerEnum('SP.ChoiceFormatType', false);
SP.CustomizedPageStatus = function() {
};
SP.CustomizedPageStatus.prototype = {
    none: 0,
    uncustomized: 1,
    customized: 2
};
SP.CustomizedPageStatus.registerEnum('SP.CustomizedPageStatus', false);
SP.DateTimeFieldFormatType = function() {
};
SP.DateTimeFieldFormatType.prototype = {
    dateOnly: 0,
    dateTime: 1
};
SP.DateTimeFieldFormatType.registerEnum('SP.DateTimeFieldFormatType', false);
SP.DateTimeFieldFriendlyFormatType = function() {
};
SP.DateTimeFieldFriendlyFormatType.prototype = {
    unspecified: 0,
    disabled: 1,
    relative: 2
};
SP.DateTimeFieldFriendlyFormatType.registerEnum('SP.DateTimeFieldFriendlyFormatType', false);
SP.DocumentTemplateType = function() {
};
SP.DocumentTemplateType.prototype = {
    invalid: 0,
    word: 1,
    excel: 2,
    powerPoint: 3,
    oneNote: 4,
    excelForm: 5,
    max: 6
};
SP.DocumentTemplateType.registerEnum('SP.DocumentTemplateType', false);
SP.DraftVisibilityType = function() {
};
SP.DraftVisibilityType.prototype = {
    reader: 0,
    author: 1,
    approver: 2
};
SP.DraftVisibilityType.registerEnum('SP.DraftVisibilityType', false);
SP.EventReceiverSynchronization = function() {
};
SP.EventReceiverSynchronization.prototype = {
    defaultSynchronization: 0,
    synchronous: 1,
    asynchronous: 2
};
SP.EventReceiverSynchronization.registerEnum('SP.EventReceiverSynchronization', false);
SP.EventReceiverType = function() {
};
SP.EventReceiverType.prototype = {
    invalidReceiver: -1,
    itemAdding: 1,
    itemUpdating: 2,
    itemDeleting: 3,
    itemCheckingIn: 4,
    itemCheckingOut: 5,
    itemUncheckingOut: 6,
    itemAttachmentAdding: 7,
    itemAttachmentDeleting: 8,
    itemFileMoving: 9,
    itemVersionDeleting: 11,
    fieldAdding: 101,
    fieldUpdating: 102,
    fieldDeleting: 103,
    listAdding: 104,
    listDeleting: 105,
    siteDeleting: 201,
    webDeleting: 202,
    webMoving: 203,
    webAdding: 204,
    groupAdding: 301,
    groupUpdating: 302,
    groupDeleting: 303,
    groupUserAdding: 304,
    groupUserDeleting: 305,
    roleDefinitionAdding: 306,
    roleDefinitionUpdating: 307,
    roleDefinitionDeleting: 308,
    roleAssignmentAdding: 309,
    roleAssignmentDeleting: 310,
    inheritanceBreaking: 311,
    inheritanceResetting: 312,
    workflowStarting: 501,
    itemAdded: 10001,
    itemUpdated: 10002,
    itemDeleted: 10003,
    itemCheckedIn: 10004,
    itemCheckedOut: 10005,
    itemUncheckedOut: 10006,
    itemAttachmentAdded: 10007,
    itemAttachmentDeleted: 10008,
    itemFileMoved: 10009,
    itemFileConverted: 10010,
    itemVersionDeleted: 10011,
    fieldAdded: 10101,
    fieldUpdated: 10102,
    fieldDeleted: 10103,
    listAdded: 10104,
    listDeleted: 10105,
    siteDeleted: 10201,
    webDeleted: 10202,
    webRestored: 10205,
    webMoved: 10203,
    webProvisioned: 10204,
    groupAdded: 10301,
    groupUpdated: 10302,
    groupDeleted: 10303,
    groupUserAdded: 10304,
    groupUserDeleted: 10305,
    roleDefinitionAdded: 10306,
    roleDefinitionUpdated: 10307,
    roleDefinitionDeleted: 10308,
    roleAssignmentAdded: 10309,
    roleAssignmentDeleted: 10310,
    inheritanceBroken: 10311,
    inheritanceReset: 10312,
    workflowStarted: 10501,
    workflowPostponed: 10502,
    workflowCompleted: 10503,
    entityInstanceAdded: 10601,
    entityInstanceUpdated: 10602,
    entityInstanceDeleted: 10603,
    appInstalled: 10701,
    appUpgraded: 10702,
    appUninstalling: 10703,
    emailReceived: 20000,
    contextEvent: 32766
};
SP.EventReceiverType.registerEnum('SP.EventReceiverType', false);
SP.FeatureDefinitionScope = function() {
};
SP.FeatureDefinitionScope.prototype = {
    none: 0,
    farm: 1,
    site: 2,
    web: 3
};
SP.FeatureDefinitionScope.registerEnum('SP.FeatureDefinitionScope', false);
SP.FieldType = function() {
};
SP.FieldType.prototype = {
    invalid: 0,
    integer: 1,
    text: 2,
    note: 3,
    dateTime: 4,
    counter: 5,
    choice: 6,
    lookup: 7,
    boolean: 8,
    number: 9,
    currency: 10,
    URL: 11,
    computed: 12,
    threading: 13,
    guid: 14,
    multiChoice: 15,
    gridChoice: 16,
    calculated: 17,
    file: 18,
    attachments: 19,
    user: 20,
    recurrence: 21,
    crossProjectLink: 22,
    modStat: 23,
    error: 24,
    contentTypeId: 25,
    pageSeparator: 26,
    threadIndex: 27,
    workflowStatus: 28,
    allDayEvent: 29,
    workflowEventType: 30,
    geolocation: 31,
    outcomeChoice: 32,
    maxItems: 33
};
SP.FieldType.registerEnum('SP.FieldType', false);
SP.FieldUserSelectionMode = function() {
};
SP.FieldUserSelectionMode.prototype = {
    peopleOnly: 0,
    peopleAndGroups: 1
};
SP.FieldUserSelectionMode.registerEnum('SP.FieldUserSelectionMode', false);
SP.FileLevel = function() {
};
SP.FileLevel.prototype = {
    published: 1,
    draft: 2,
    checkout: 255
};
SP.FileLevel.registerEnum('SP.FileLevel', false);
SP.FileSystemObjectType = function() {
};
SP.FileSystemObjectType.prototype = {
    invalid: -1,
    file: 0,
    folder: 1,
    web: 2
};
SP.FileSystemObjectType.registerEnum('SP.FileSystemObjectType', false);
SP.FileVersionEventType = function() {
};
SP.FileVersionEventType.prototype = {
    share: 1,
    rename: 2,
    restore: 3,
    maxServerType: 28671,
    fromClient: 28672
};
SP.FileVersionEventType.registerEnum('SP.FileVersionEventType', false);
SP.ListDataValidationFailureReason = function() {
};
SP.ListDataValidationFailureReason.prototype = {
    dataFailure: 0,
    formulaError: 1
};
SP.ListDataValidationFailureReason.registerEnum('SP.ListDataValidationFailureReason', false);
SP.ListDataValidationType = function() {
};
SP.ListDataValidationType.prototype = {
    userFormulaField: 0,
    userFormulaItem: 1,
    requiredField: 2,
    choiceField: 3,
    minMaxField: 4,
    textField: 5
};
SP.ListDataValidationType.registerEnum('SP.ListDataValidationType', false);
SP.ListTemplateType = function() {
};
SP.ListTemplateType.prototype = {
    invalidType: -1,
    noListTemplate: 0,
    genericList: 100,
    documentLibrary: 101,
    survey: 102,
    links: 103,
    announcements: 104,
    contacts: 105,
    events: 106,
    tasks: 107,
    discussionBoard: 108,
    pictureLibrary: 109,
    dataSources: 110,
    webTemplateCatalog: 111,
    userInformation: 112,
    webPartCatalog: 113,
    listTemplateCatalog: 114,
    xmlForm: 115,
    masterPageCatalog: 116,
    noCodeWorkflows: 117,
    workflowProcess: 118,
    webPageLibrary: 119,
    customGrid: 120,
    solutionCatalog: 121,
    noCodePublic: 122,
    themeCatalog: 123,
    designCatalog: 124,
    appDataCatalog: 125,
    dataConnectionLibrary: 130,
    workflowHistory: 140,
    ganttTasks: 150,
    helpLibrary: 151,
    accessRequest: 160,
    tasksWithTimelineAndHierarchy: 171,
    maintenanceLogs: 175,
    meetings: 200,
    agenda: 201,
    meetingUser: 202,
    decision: 204,
    meetingObjective: 207,
    textBox: 210,
    thingsToBring: 211,
    homePageLibrary: 212,
    posts: 301,
    comments: 302,
    categories: 303,
    facility: 402,
    whereabouts: 403,
    callTrack: 404,
    circulation: 405,
    timecard: 420,
    holidays: 421,
    imeDic: 499,
    externalList: 600,
    mySiteDocumentLibrary: 700,
    issueTracking: 1100,
    adminTasks: 1200,
    healthRules: 1220,
    healthReports: 1221,
    developerSiteDraftApps: 1230,
    accessApp: 3100,
    alchemyMobileForm: 3101,
    alchemyApprovalWorkflow: 3102,
    sharingLinks: 3300
};
SP.ListTemplateType.registerEnum('SP.ListTemplateType', false);
SP.MigrationJobState = function() {
};
SP.MigrationJobState.prototype = {
    none: 0,
    queued: 2,
    processing: 4
};
SP.MigrationJobState.registerEnum('SP.MigrationJobState', false);
SP.MoveOperations = function() {
};
SP.MoveOperations.prototype = {
    none: 0,
    overwrite: 1,
    allowBrokenThickets: 8,
    bypassApprovePermission: 64
};
SP.MoveOperations.registerEnum('SP.MoveOperations', false);
SP.OpenWebOptions = function() {
};
SP.OpenWebOptions.prototype = {
    none: 0,
    initNavigationCache: 1
};
SP.OpenWebOptions.registerEnum('SP.OpenWebOptions', false);
SP.PageType = function() {
};
SP.PageType.prototype = {
    invalid: -1,
    defaultView: 0,
    normalView: 1,
    dialogView: 2,
    view: 3,
    displayForm: 4,
    displayFormDialog: 5,
    editForm: 6,
    editFormDialog: 7,
    newForm: 8,
    newFormDialog: 9,
    solutionForm: 10,
    pagE_MAXITEMS: 11
};
SP.PageType.registerEnum('SP.PageType', false);
SP.PolicyTipUserAction = function() {
};
SP.PolicyTipUserAction.prototype = {
    override: 0,
    reportFalsePositive: 1
};
SP.PolicyTipUserAction.registerEnum('SP.PolicyTipUserAction', false);
SP.PolicyTipUserActionResult = function() {
};
SP.PolicyTipUserActionResult.prototype = {
    none: 0,
    falsePositiveReported: 1,
    overridden: 2,
    falsePositiveReportedAndOverridden: 3
};
SP.PolicyTipUserActionResult.registerEnum('SP.PolicyTipUserActionResult', false);
SP.QuickLaunchOptions = function() {
};
SP.QuickLaunchOptions.prototype = {
    off: 0,
    on: 1,
    defaultValue: 2
};
SP.QuickLaunchOptions.registerEnum('SP.QuickLaunchOptions', false);
SP.RecycleBinItemState = function() {
};
SP.RecycleBinItemState.prototype = {
    none: 0,
    firstStageRecycleBin: 1,
    secondStageRecycleBin: 2
};
SP.RecycleBinItemState.registerEnum('SP.RecycleBinItemState', false);
SP.RecycleBinItemType = function() {
};
SP.RecycleBinItemType.prototype = {
    none: 0,
    file: 1,
    fileVersion: 2,
    listItem: 3,
    list: 4,
    folder: 5,
    folderWithLists: 6,
    attachment: 7,
    listItemVersion: 8,
    cascadeParent: 9,
    web: 10,
    app: 11
};
SP.RecycleBinItemType.registerEnum('SP.RecycleBinItemType', false);
SP.RecycleBinOrderBy = function() {
};
SP.RecycleBinOrderBy.prototype = {
    min: 0,
    defaultOrderBy: 0,
    title: 0,
    dirName: 1,
    author: 2,
    deletedDate: 3,
    size: 4,
    deletedBy: 5,
    none: 6,
    max: 6
};
SP.RecycleBinOrderBy.registerEnum('SP.RecycleBinOrderBy', false);
SP.RelationshipDeleteBehaviorType = function() {
};
SP.RelationshipDeleteBehaviorType.prototype = {
    none: 0,
    cascade: 1,
    restrict: 2
};
SP.RelationshipDeleteBehaviorType.registerEnum('SP.RelationshipDeleteBehaviorType', false);
SP.RenderListDataOptions = function() {
};
SP.RenderListDataOptions.prototype = {
    none: 0,
    contextInfo: 1,
    listData: 2,
    listSchema: 4,
    menuView: 8,
    listContentType: 16,
    fileSystemItemId: 32,
    clientFormSchema: 64,
    quickLaunch: 128
};
SP.RenderListDataOptions.registerEnum('SP.RenderListDataOptions', false);
SP.RenderListFormDataOptions = function() {
};
SP.RenderListFormDataOptions.prototype = {
    none: 0,
    excludeListSchema: 1,
    includeAttachments: 2,
    includeListViewData: 4
};
SP.RenderListFormDataOptions.registerEnum('SP.RenderListFormDataOptions', false);
SP.RoleType = function() {
};
SP.RoleType.prototype = {
    none: 0,
    guest: 1,
    reader: 2,
    contributor: 3,
    webDesigner: 4,
    administrator: 5,
    editor: 6
};
SP.RoleType.registerEnum('SP.RoleType', false);
SP.RuleOverrideOptions = function() {
};
SP.RuleOverrideOptions.prototype = {
    none: 0,
    allow: 1,
    allowWithJustification: 2
};
SP.RuleOverrideOptions.registerEnum('SP.RuleOverrideOptions', false);
SP.SandboxedCodeActivationCapabilities = function() {
};
SP.SandboxedCodeActivationCapabilities.prototype = {
    check: 1,
    disabled: 2,
    enabled: 3
};
SP.SandboxedCodeActivationCapabilities.registerEnum('SP.SandboxedCodeActivationCapabilities', false);
SP.SharingLinkKind = function() {
};
SP.SharingLinkKind.prototype = {
    uninitialized: 0,
    direct: 1,
    organizationView: 2,
    organizationEdit: 3,
    anonymousView: 4,
    anonymousEdit: 5
};
SP.SharingLinkKind.registerEnum('SP.SharingLinkKind', false);
SP.SharingOperationStatusCode = function() {
};
SP.SharingOperationStatusCode.prototype = {
    completedSuccessfully: 0,
    accessRequestsQueued: 1,
    noResolvedUsers: -1,
    accessDenied: -2,
    crossSiteRequestNotSupported: -3,
    unknowError: -4
};
SP.SharingOperationStatusCode.registerEnum('SP.SharingOperationStatusCode', false);
SP.SharingPermissionKind = function() {
};
SP.SharingPermissionKind.prototype = {
    group: 0,
    role: 1
};
SP.SharingPermissionKind.registerEnum('SP.SharingPermissionKind', false);
SP.SpecialFolderType = function() {
};
SP.SpecialFolderType.prototype = {
    attachment: 0,
    photos: 1,
    cameraRoll: 2,
    music: 3,
    apps: 4,
    appRoot: 5
};
SP.SpecialFolderType.registerEnum('SP.SpecialFolderType', false);
SP.SPEffectiveInformationRightsManagementSettingsSource = function() {
};
SP.SPEffectiveInformationRightsManagementSettingsSource.prototype = {
    none: 0,
    file: 1,
    list: 2,
    rule: 3
};
SP.SPEffectiveInformationRightsManagementSettingsSource.registerEnum('SP.SPEffectiveInformationRightsManagementSettingsSource', false);
SP.TemplateFileType = function() {
};
SP.TemplateFileType.prototype = {
    standardPage: 0,
    wikiPage: 1,
    formPage: 2
};
SP.TemplateFileType.registerEnum('SP.TemplateFileType', false);
SP.UpgradeStatus = function() {
};
SP.UpgradeStatus.prototype = {
    none: 0,
    inProgress: 1,
    failed: 2,
    completed: 3
};
SP.UpgradeStatus.registerEnum('SP.UpgradeStatus', false);
SP.UpgradeType = function() {
};
SP.UpgradeType.prototype = {
    buildUpgrade: 0,
    versionUpgrade: 1
};
SP.UpgradeType.registerEnum('SP.UpgradeType', false);
SP.UrlFieldFormatType = function() {
};
SP.UrlFieldFormatType.prototype = {
    hyperlink: 0,
    image: 1
};
SP.UrlFieldFormatType.registerEnum('SP.UrlFieldFormatType', false);
SP.UrlZone = function() {
};
SP.UrlZone.prototype = {
    defaultZone: 0,
    intranet: 1,
    internet: 2,
    custom: 3,
    extranet: 4
};
SP.UrlZone.registerEnum('SP.UrlZone', false);
SP.UserCustomActionRegistrationType = function() {
};
SP.UserCustomActionRegistrationType.prototype = {
    none: 0,
    list: 1,
    contentType: 2,
    progId: 3,
    fileType: 4
};
SP.UserCustomActionRegistrationType.registerEnum('SP.UserCustomActionRegistrationType', false);
SP.UserCustomActionScope = function() {
};
SP.UserCustomActionScope.prototype = {
    unknown: 0,
    site: 2,
    web: 3,
    list: 4
};
SP.UserCustomActionScope.registerEnum('SP.UserCustomActionScope', false);
SP.UserResourceScope = function() {
};
SP.UserResourceScope.prototype = {
    web: 0,
    list: 1
};
SP.UserResourceScope.registerEnum('SP.UserResourceScope', false);
SP.UserResourceType = function() {
};
SP.UserResourceType.prototype = {
    singleLine: 0,
    multiLine: 1
};
SP.UserResourceType.registerEnum('SP.UserResourceType', false);
SP.UserSharingCapabilities = function() {
};
SP.UserSharingCapabilities.prototype = {
    none: 0,
    canShareInternally: 1,
    canShareExternally: 2,
    canUseReadonlyLink: 4,
    canManageReadonlyLink: 8,
    canUseReadWriteLink: 16,
    canManageReadWriteLink: 32,
    canUseOrganizationReadonlyLink: 64,
    canManageOrganizationReadonlyLink: 128,
    canUseOrganizationReadWriteLink: 256,
    canManageOrganizationReadWriteLink: 512
};
SP.UserSharingCapabilities.registerEnum('SP.UserSharingCapabilities', false);
SP.ViewScope = function() {
};
SP.ViewScope.prototype = {
    defaultValue: 0,
    recursive: 1,
    recursiveAll: 2,
    filesOnly: 3
};
SP.ViewScope.registerEnum('SP.ViewScope', false);
SP.ViewType = function() {
};
SP.ViewType.prototype = {
    none: 0,
    html: 1,
    grid: 2048,
    calendar: 524288,
    recurrence: 8193,
    chart: 131072,
    gantt: 67108864
};
SP.ViewType.registerEnum('SP.ViewType', false);
SP.ClientContext = function SP_ClientContext(serverRelativeUrlOrFullUrl) {
    SP.ClientContext.initializeBase(this, [SP.ScriptUtility.isNullOrUndefined(serverRelativeUrlOrFullUrl) ? SP.ClientContext.$7h() : serverRelativeUrlOrFullUrl]);
    this.set_formDigestHandlingEnabled(true);
};
SP.ClientContext.$7h = function SP_ClientContext$$7h() {
    var $v_0 = window._spPageContextInfo;

    if ($v_0) {
        return $v_0.webServerRelativeUrl;
    }
    throw Error.invalidOperation(SP.ResResources.getString('CannotFindContextWebServerRelativeUrl'));
};
SP.ClientContext.get_current = function SP_ClientContext$get_current() {
    if (!SP.ClientContext.$1o) {
        var $v_0 = null;
        var $v_1 = window._spPageContextInfo;
        var $v_2 = false;

        if ($v_1) {
            $v_0 = $v_1.webServerRelativeUrl;
        }
        if (SP.ScriptUtility.isNullOrEmptyString($v_0)) {
            $v_0 = window.location.href;
            var $v_3 = $v_0.indexOf('?');

            if ($v_3 > 0) {
                $v_0 = $v_0.substr(0, $v_3);
            }
            $v_3 = $v_0.indexOf('#');
            if ($v_3 > 0) {
                $v_0 = $v_0.substr(0, $v_3);
            }
            var $v_4 = false;
            var $v_5 = $v_0.toLowerCase();
            var $v_6 = ['/_layouts', '/_vti_bin'];

            for (var $v_7 = 0; $v_7 < $v_6.length; $v_7++) {
                $v_3 = $v_5.indexOf($v_6[$v_7]);
                if ($v_3 > 0) {
                    $v_0 = $v_0.substr(0, $v_3);
                    $v_4 = true;
                    break;
                }
            }
            if (!$v_4) {
                $v_3 = $v_0.lastIndexOf('.');
                if ($v_3 > 0) {
                    $v_0 = $v_0.substr(0, $v_3);
                }
            }
            $v_2 = true;
        }
        SP.ClientContext.$1o = new SP.ClientContext($v_0);
        SP.ClientContext.$1o.set_isPageUrl($v_2);
    }
    return SP.ClientContext.$1o;
};
SP.ClientContext.prototype = {
    $K_1: null,
    get_web: function SP_ClientContext$get_web() {
        if (!this.$K_1) {
            var $v_0 = SP.RequestContext.getCurrent(this);

            this.$K_1 = $v_0.get_web();
        }
        return this.$K_1;
    },
    $W_1: null,
    get_site: function SP_ClientContext$get_site() {
        if (!this.$W_1) {
            var $v_0 = SP.RequestContext.getCurrent(this);

            this.$W_1 = $v_0.get_site();
        }
        return this.$W_1;
    },
    $16_1: null,
    get_requestResources: function SP_ClientContext$get_requestResources() {
        if (!this.$16_1) {
            this.$16_1 = new SP.RequestResources();
        }
        return this.$16_1;
    },
    get_$84_1: function SP_ClientContext$get_$84_1() {
        if (!this.$16_1) {
            return null;
        }
        return this.$16_1.$87_0();
    },
    get_serverVersion: function SP_ClientContext$get_serverVersion() {
        return this.get_serverLibraryVersion();
    },
    executeClientRequestAsync: function SP_ClientContext$executeClientRequestAsync(request, succeededCallback, failedCallback) {
        var $v_0 = this.get_$84_1();

        if (!SP.ScriptUtility.isNullOrEmptyString($v_0)) {
            ((request.get_webRequest()).get_headers())['X-SP-REQUESTRESOURCES'] = $v_0;
        }
        SP.ClientRuntimeContext.prototype.executeClientRequestAsync.call(this, request, succeededCallback, failedCallback);
    }
};
SP.RequestResources = function SP_RequestResources() {
};
SP.RequestResources.prototype = {
    $7_0: null,
    $6_0: null,
    $5O_0: false,
    $5V_0: false,
    $2b_0: false,
    $4O_0: false,
    get_listId: function SP_RequestResources$get_listId() {
        return this.$7_0;
    },
    set_listId: function SP_RequestResources$set_listId(value) {
        this.$7_0 = value;
        return value;
    },
    get_userInformationList: function SP_RequestResources$get_userInformationList() {
        return this.$5O_0;
    },
    set_userInformationList: function SP_RequestResources$set_userInformationList(value) {
        this.$5O_0 = value;
        return value;
    },
    get_webProperties: function SP_RequestResources$get_webProperties() {
        return this.$5V_0;
    },
    set_webProperties: function SP_RequestResources$set_webProperties(value) {
        this.$5V_0 = value;
        return value;
    },
    get_features: function SP_RequestResources$get_features() {
        return this.$2b_0;
    },
    set_features: function SP_RequestResources$set_features(value) {
        this.$2b_0 = value;
        return value;
    },
    get_navigationStructure: function SP_RequestResources$get_navigationStructure() {
        return this.$4O_0;
    },
    set_navigationStructure: function SP_RequestResources$set_navigationStructure(value) {
        this.$4O_0 = value;
        return value;
    },
    get_viewId: function SP_RequestResources$get_viewId() {
        return this.$6_0;
    },
    set_viewId: function SP_RequestResources$set_viewId(value) {
        this.$6_0 = value;
        return value;
    },
    $87_0: function SP_RequestResources$$87_0() {
        var $v_0 = new Sys.StringBuilder();

        if (this.$5O_0) {
            $v_0.append('USERINFOLIST');
        }
        if (this.$5V_0) {
            if (!$v_0.isEmpty()) {
                $v_0.append(',');
            }
            $v_0.append('WEBPROPERTIES');
        }
        if (this.$2b_0) {
            if (!$v_0.isEmpty()) {
                $v_0.append(',');
            }
            $v_0.append('FEATURES');
        }
        if (this.$4O_0) {
            if (!$v_0.isEmpty()) {
                $v_0.append(',');
            }
            $v_0.append('NAVIGATIONSTRUCTURE');
        }
        if (!SP.ScriptUtility.isNullOrUndefined(this.$7_0) && !this.$7_0.equals(SP.Guid.get_empty())) {
            if (!$v_0.isEmpty()) {
                $v_0.append(',');
            }
            $v_0.append('LIST');
            $v_0.append('=');
            $v_0.append(this.$7_0.toString());
        }
        if (!SP.ScriptUtility.isNullOrUndefined(this.$6_0) && !this.$6_0.equals(SP.Guid.get_empty())) {
            if (!$v_0.isEmpty()) {
                $v_0.append(',');
            }
            $v_0.append('VIEW');
            $v_0.append('=');
            $v_0.append(this.$6_0.toString());
        }
        return $v_0.toString();
    }
};
SP.ULS = function SP_ULS() {
};
SP.ULS.$7G = function SP_ULS$$7G() {
    if (SP.ULS.$7A) {
        return null;
    }
    var $v_0 = window.top.s_sp_debugWindow;

    if (SP.ScriptUtility.isNullOrUndefined($v_0) || $v_0.closed) {
        try {
            $v_0 = window.open('/_layouts/' + 15 + '/blank.htm', null, 'width=400,height=200,scrollbars=yes,resizable=yes,status=no,location=no,menubar=no,toolbar=no');
        }
        catch ($$e_1) {
            SP.ULS.$7A = true;
        }
        if ($v_0) {
            window.setTimeout(SP.ULS.$7i, 100);
        }
        window.top.s_sp_debugWindow = $v_0;
    }
    return $v_0;
};
SP.ULS.$7i = function SP_ULS$$7i() {
    var $v_0 = window.top.s_sp_debugWindow;

    if (!$v_0) {
        return;
    }
    try {
        var $v_1 = $v_0.document;
        var $v_2;

        $v_2 = $v_1.createElement('DIV');
        $v_1.body.appendChild($v_2);
        var $v_3 = $v_1.createElement('INPUT');

        $v_3.setAttribute('type', 'checkbox');
        $v_3.id = 'UlsConfigTraceApi';
        $v_2.appendChild($v_3);
        $v_2.appendChild($v_1.createTextNode('Trace API'));
        $v_2 = $v_1.createElement('DIV');
        $v_2.id = 'UlsLogs';
        $v_1.body.appendChild($v_2);
        $v_2 = $v_1.getElementById('UlsLogs');
        $v_2.appendChild($v_1.createTextNode('Use double-click to clear the entries.'));
        $addHandler($v_1.body, 'dblclick', SP.ULS.$7S);
        $addHandler($v_3, 'click', SP.ULS.$88);
        $v_1.title = 'Debug Output';
    }
    catch ($$e_4) { }
};
SP.ULS.get_enabled = function SP_ULS$get_enabled() {
    return SP.ULS.$19;
};
SP.ULS.set_enabled = function SP_ULS$set_enabled(value) {
    SP.ULS.$19 = value;
    return value;
};
SP.ULS.log = function SP_ULS$log(debugMessage) {
    if (!SP.ULS.$19) {
        return;
    }
    var $v_0 = (new Date()).format('hh:mm:ss.ffff');
    var $v_1 = SP.ULS.$t + debugMessage;

    if (SP.ULS.$V) {
        for (var $v_3 = 0; $v_3 < SP.ULS.$V.length; $v_3++) {
            var $v_4 = SP.ULS.$V[$v_3];
            var $v_5 = SP.ULS.$7K($v_4['time'], $v_4['msg']);

            if (!$v_5) {
                SP.ULS.$7O($v_0, $v_1);
                return;
            }
        }
        SP.ULS.$V = null;
    }
    var $v_2 = SP.ULS.$7K($v_0, $v_1);

    if (!$v_2) {
        SP.ULS.$7O($v_0, $v_1);
    }
};
SP.ULS.$7O = function SP_ULS$$7O($p0, $p1) {
    if (!SP.ULS.$V) {
        SP.ULS.$V = new Array(0);
    }
    var $v_0 = {};

    $v_0['time'] = $p0;
    $v_0['msg'] = $p1;
    SP.ULS.$V[SP.ULS.$V.length] = $v_0;
};
SP.ULS.$7K = function SP_ULS$$7K($p0, $p1) {
    var $v_0 = SP.ULS.$7G();

    if ($v_0) {
        try {
            var $v_1 = $v_0.document.createElement('DIV');

            $v_1.style.fontSize = '8pt';
            $v_1.style.fontFamily = 'Consolas, Courier, Sans-Serif';
            if (SP.ULS.$5c) {
                $v_1.style.backgroundColor = 'gray';
            }
            SP.ULS.$5c = !SP.ULS.$5c;
            var $v_2 = $v_0.document.createElement('SPAN');

            $v_2.style.fontWeight = 'bold';
            var $v_3 = $v_0.document.createElement('SPAN');

            $v_1.appendChild($v_2);
            $v_1.appendChild($v_3);
            var $v_4 = $v_0.document.getElementById('UlsLogs');

            if ($v_4) {
                $v_4.appendChild($v_1);
                SP.UI.UIUtility.setInnerText($v_2, $p0);
                SP.UI.UIUtility.setInnerText($v_3, $p1);
                return true;
            }
        }
        catch ($$e_7) { }
    }
    return false;
};
SP.ULS.$7S = function SP_ULS$$7S($p0) {
    var $v_0 = SP.ULS.$7G();

    if ($v_0 && $v_0.document) {
        ($v_0.document.getElementById('UlsLogs')).innerHTML = '';
    }
};
SP.ULS.$88 = function SP_ULS$$88($p0) {
    SP.ULS.$5d = $p0.target.checked;
};
SP.ULS.increaseIndent = function SP_ULS$increaseIndent() {
    SP.ULS.$7B++;
    SP.ULS.$t = SP.ULS.$t + String.fromCharCode(160);
};
SP.ULS.decreaseIndent = function SP_ULS$decreaseIndent() {
    SP.ULS.$7B--;
    if (SP.ULS.$t.length > 0) {
        SP.ULS.$t = SP.ULS.$t.substr(0, SP.ULS.$t.length - 1);
    }
};
SP.ULS.traceApiEnter = function SP_ULS$traceApiEnter(functionName) {
    if (!SP.ULS.$19) {
        return;
    }
    if (!SP.ULS.$5d) {
        return;
    }
    SP.ULS.$7C.push(functionName);
    var $v_0 = 'Enter ' + functionName + '(';

    for (var $v_1 = 1; $v_1 < arguments.length; $v_1++) {
        var $v_2 = arguments[$v_1];

        if ($v_1 !== 1) {
            $v_0 = $v_0 + ', ';
        }
        switch (typeof $v_2) {
        case 'number':
            $v_0 = $v_0 + $v_2.toString();
            break;
        case 'string':
            $v_0 = $v_0 + $v_2;
            break;
        case 'boolean':
            $v_0 = $v_0 + $v_2.toString();
            break;
        case 'object':
            $v_0 = $v_0 + '[object]';
            break;
        default:
            $v_0 = $v_0 + '[unknownobj]';
            break;
        }
    }
    $v_0 += ')';
    SP.ULS.log($v_0);
    SP.ULS.increaseIndent();
};
SP.ULS.traceApiLeave = function SP_ULS$traceApiLeave() {
    if (!SP.ULS.$19) {
        return;
    }
    if (!SP.ULS.$5d) {
        return;
    }
    SP.ULS.decreaseIndent();
    var $v_0 = SP.ULS.$7C.pop();
    var $v_1 = 'Leave ' + $v_0;

    SP.ULS.log($v_1);
};
SP.AccessRequests = function SP_AccessRequests() {
};
SP.AccessRequests.changeRequestStatus = function SP_AccessRequests$changeRequestStatus(context, itemId, newStatus, convStr, permType, permissionLevel) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{e7dae9f6-8aa5-4b86-92c8-61941d774c44}', 'ChangeRequestStatus', [itemId, newStatus, convStr, permType, permissionLevel]);

    context.addQuery($v_0);
};
SP.AccessRequests.changeRequestStatusBulk = function SP_AccessRequests$changeRequestStatusBulk(context, requestIds, newStatus) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{e7dae9f6-8aa5-4b86-92c8-61941d774c44}', 'ChangeRequestStatusBulk', [requestIds, newStatus]);

    context.addQuery($v_0);
};
SP.AccessRequests.updateConversation = function SP_AccessRequests$updateConversation(context, itemId, convStr, web) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{e7dae9f6-8aa5-4b86-92c8-61941d774c44}', 'UpdateConversation', [itemId, convStr, web]);

    context.addQuery($v_0);
};
SP.AlternateUrl = function SP_AlternateUrl(context, objectPath) {
    SP.AlternateUrl.initializeBase(this, [context, objectPath]);
};
SP.AlternateUrl.prototype = {
    get_uri: function SP_AlternateUrl$get_uri() {
        this.checkUninitializedProperty('Uri');
        return ((this.get_objectData()).get_properties())['Uri'];
    },
    get_urlZone: function SP_AlternateUrl$get_urlZone() {
        this.checkUninitializedProperty('UrlZone');
        return ((this.get_objectData()).get_properties())['UrlZone'];
    },
    initPropertiesFromJson: function SP_AlternateUrl$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Uri;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Uri'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Uri;
        }
        $v_0 = parentNode.UrlZone;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UrlZone'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.UrlZone;
        }
    }
};
SP.AlternateUrlPropertyNames = function SP_AlternateUrlPropertyNames() {
};
SP.App = function SP_App(context, objectPath) {
    SP.App.initializeBase(this, [context, objectPath]);
};
SP.App.prototype = {
    get_assetId: function SP_App$get_assetId() {
        this.checkUninitializedProperty('AssetId');
        return ((this.get_objectData()).get_properties())['AssetId'];
    },
    get_contentMarket: function SP_App$get_contentMarket() {
        this.checkUninitializedProperty('ContentMarket');
        return ((this.get_objectData()).get_properties())['ContentMarket'];
    },
    get_versionString: function SP_App$get_versionString() {
        this.checkUninitializedProperty('VersionString');
        return ((this.get_objectData()).get_properties())['VersionString'];
    },
    initPropertiesFromJson: function SP_App$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AssetId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AssetId'] = $v_0;
            delete parentNode.AssetId;
        }
        $v_0 = parentNode.ContentMarket;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContentMarket'] = $v_0;
            delete parentNode.ContentMarket;
        }
        $v_0 = parentNode.VersionString;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['VersionString'] = $v_0;
            delete parentNode.VersionString;
        }
    }
};
SP.AppPropertyNames = function SP_AppPropertyNames() {
};
SP.AppCatalog = function SP_AppCatalog() {
};
SP.AppCatalog.getAppInstances = function SP_AppCatalog$getAppInstances(context, web) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ClientObjectList(context, new SP.ObjectPathStaticMethod(context, '{79cdee9f-257e-423b-9e94-e6404659f7ea}', 'GetAppInstances', [web]), SP.AppInstance);
    return $v_0;
};
SP.AppCatalog.getAppInstance = function SP_AppCatalog$getAppInstance(context, web, appInstanceId) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.AppInstance(context, new SP.ObjectPathStaticMethod(context, '{79cdee9f-257e-423b-9e94-e6404659f7ea}', 'GetAppInstance', [web, appInstanceId]));
    return $v_0;
};
SP.AppCatalog.getDeveloperSiteAppInstancesByIds = function SP_AppCatalog$getDeveloperSiteAppInstancesByIds(context, site, appInstanceIds) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ClientObjectList(context, new SP.ObjectPathStaticMethod(context, '{79cdee9f-257e-423b-9e94-e6404659f7ea}', 'GetDeveloperSiteAppInstancesByIds', [site, appInstanceIds]), SP.AppInstance);
    return $v_0;
};
SP.AppCatalog.isAppSideloadingEnabled = function SP_AppCatalog$isAppSideloadingEnabled(context) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{79cdee9f-257e-423b-9e94-e6404659f7ea}', 'IsAppSideloadingEnabled', null);

    context.addQuery($v_1);
    $v_0 = new SP.BooleanResult();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.AppCatalog.getAppDetails = function SP_AppCatalog$getAppDetails(context, web, appInstance) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new Microsoft.SharePoint.Packaging.AppDetails(context, new SP.ObjectPathStaticMethod(context, '{79cdee9f-257e-423b-9e94-e6404659f7ea}', 'GetAppDetails', [web, appInstance]));
    return $v_0;
};
SP.AppCatalog.getAppPermissionDescriptions = function SP_AppCatalog$getAppPermissionDescriptions(context, web, appInstance) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{79cdee9f-257e-423b-9e94-e6404659f7ea}', 'GetAppPermissionDescriptions', [web, appInstance]);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.AppContextSite = function SP_AppContextSite(context, siteUrl) {
    SP.AppContextSite.initializeBase(this, [context, SP.ClientUtility.getOrCreateObjectPathForConstructor(context, '{5530f782-6a0d-41ec-bfd9-2cb628fe1557}', arguments)]);
};
SP.AppContextSite.newObject = function SP_AppContextSite$newObject(context, siteUrl) {
    return new SP.AppContextSite(context, new SP.ObjectPathConstructor(context, '{5530f782-6a0d-41ec-bfd9-2cb628fe1557}', [siteUrl]));
};
SP.AppContextSite.prototype = {
    get_site: function SP_AppContextSite$get_site() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Site'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Site(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Site'));
            ((this.get_objectData()).get_clientObjectProperties())['Site'] = $v_0;
        }
        return $v_0;
    },
    get_web: function SP_AppContextSite$get_web() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Web'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Web(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Web'));
            ((this.get_objectData()).get_clientObjectProperties())['Web'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_AppContextSite$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Site;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Site', this.get_site(), $v_0);
            (this.get_site()).fromJson($v_0);
            delete parentNode.Site;
        }
        $v_0 = parentNode.Web;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Web', this.get_web(), $v_0);
            (this.get_web()).fromJson($v_0);
            delete parentNode.Web;
        }
    }
};
SP.AppContextSiteObjectPropertyNames = function SP_AppContextSiteObjectPropertyNames() {
};
SP.AppInstance = function SP_AppInstance(context, objectPath) {
    SP.AppInstance.initializeBase(this, [context, objectPath]);
};
SP.AppInstance.getAppIcon = function SP_AppInstance$getAppIcon(context, hostWeb, appinstanceId, packageFingerprint) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new Microsoft.SharePoint.Packaging.AppIconInfo(context, new SP.ObjectPathStaticMethod(context, '{211a55df-058b-4917-ac93-2b5e08b1a9fd}', 'GetAppIcon', [hostWeb, appinstanceId, packageFingerprint]));
    return $v_0;
};
SP.AppInstance.prototype = {
    get_appPrincipalId: function SP_AppInstance$get_appPrincipalId() {
        this.checkUninitializedProperty('AppPrincipalId');
        return ((this.get_objectData()).get_properties())['AppPrincipalId'];
    },
    get_appWebFullUrl: function SP_AppInstance$get_appWebFullUrl() {
        this.checkUninitializedProperty('AppWebFullUrl');
        return ((this.get_objectData()).get_properties())['AppWebFullUrl'];
    },
    get_id: function SP_AppInstance$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_imageFallbackUrl: function SP_AppInstance$get_imageFallbackUrl() {
        this.checkUninitializedProperty('ImageFallbackUrl');
        return ((this.get_objectData()).get_properties())['ImageFallbackUrl'];
    },
    get_imageUrl: function SP_AppInstance$get_imageUrl() {
        this.checkUninitializedProperty('ImageUrl');
        return ((this.get_objectData()).get_properties())['ImageUrl'];
    },
    get_inError: function SP_AppInstance$get_inError() {
        this.checkUninitializedProperty('InError');
        return ((this.get_objectData()).get_properties())['InError'];
    },
    get_startPage: function SP_AppInstance$get_startPage() {
        this.checkUninitializedProperty('StartPage');
        return ((this.get_objectData()).get_properties())['StartPage'];
    },
    get_packageFingerprint: function SP_AppInstance$get_packageFingerprint() {
        this.checkUninitializedProperty('PackageFingerprint');
        return ((this.get_objectData()).get_properties())['PackageFingerprint'];
    },
    get_productId: function SP_AppInstance$get_productId() {
        this.checkUninitializedProperty('ProductId');
        return ((this.get_objectData()).get_properties())['ProductId'];
    },
    get_remoteAppUrl: function SP_AppInstance$get_remoteAppUrl() {
        this.checkUninitializedProperty('RemoteAppUrl');
        return ((this.get_objectData()).get_properties())['RemoteAppUrl'];
    },
    get_settingsPageUrl: function SP_AppInstance$get_settingsPageUrl() {
        this.checkUninitializedProperty('SettingsPageUrl');
        return ((this.get_objectData()).get_properties())['SettingsPageUrl'];
    },
    get_siteId: function SP_AppInstance$get_siteId() {
        this.checkUninitializedProperty('SiteId');
        return ((this.get_objectData()).get_properties())['SiteId'];
    },
    get_status: function SP_AppInstance$get_status() {
        this.checkUninitializedProperty('Status');
        return ((this.get_objectData()).get_properties())['Status'];
    },
    get_title: function SP_AppInstance$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    get_webId: function SP_AppInstance$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_AppInstance$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AppPrincipalId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AppPrincipalId'] = $v_0;
            delete parentNode.AppPrincipalId;
        }
        $v_0 = parentNode.AppWebFullUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AppWebFullUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.AppWebFullUrl;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.ImageFallbackUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ImageFallbackUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ImageFallbackUrl;
        }
        $v_0 = parentNode.ImageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ImageUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ImageUrl;
        }
        $v_0 = parentNode.InError;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['InError'] = $v_0;
            delete parentNode.InError;
        }
        $v_0 = parentNode.StartPage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['StartPage'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.StartPage;
        }
        $v_0 = parentNode.PackageFingerprint;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PackageFingerprint'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.PackageFingerprint;
        }
        $v_0 = parentNode.ProductId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ProductId'] = $v_0;
            delete parentNode.ProductId;
        }
        $v_0 = parentNode.RemoteAppUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RemoteAppUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.RemoteAppUrl;
        }
        $v_0 = parentNode.SettingsPageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SettingsPageUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SettingsPageUrl;
        }
        $v_0 = parentNode.SiteId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SiteId'] = $v_0;
            delete parentNode.SiteId;
        }
        $v_0 = parentNode.Status;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Status'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Status;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    },
    getErrorDetails: function SP_AppInstance$getErrorDetails() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ClientObjectList($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetErrorDetails', null), SP.AppInstanceErrorDetails);
        return $v_1;
    },
    uninstall: function SP_AppInstance$uninstall() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'Uninstall', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    upgrade: function SP_AppInstance$upgrade(appPackageStream) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Upgrade', [appPackageStream]);

        $v_0.addQuery($v_1);
    },
    cancelAllJobs: function SP_AppInstance$cancelAllJobs() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'CancelAllJobs', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.BooleanResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    install: function SP_AppInstance$install() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'Install', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    recycle: function SP_AppInstance$recycle() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'Recycle', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    restore: function SP_AppInstance$restore() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'Restore', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getPreviousAppVersion: function SP_AppInstance$getPreviousAppVersion() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.App($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetPreviousAppVersion', null));
        return $v_1;
    },
    retryAllJobs: function SP_AppInstance$retryAllJobs() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RetryAllJobs', null);

        $v_0.addQuery($v_1);
    }
};
SP.AppInstancePropertyNames = function SP_AppInstancePropertyNames() {
};
SP.AppInstanceErrorDetails = function SP_AppInstanceErrorDetails(context, objectPath) {
    SP.AppInstanceErrorDetails.initializeBase(this, [context, objectPath]);
};
SP.AppInstanceErrorDetails.prototype = {
    get_correlationId: function SP_AppInstanceErrorDetails$get_correlationId() {
        this.checkUninitializedProperty('CorrelationId');
        return ((this.get_objectData()).get_properties())['CorrelationId'];
    },
    set_correlationId: function SP_AppInstanceErrorDetails$set_correlationId(value) {
        ((this.get_objectData()).get_properties())['CorrelationId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'CorrelationId', value));
        }
        return value;
    },
    get_errorDetail: function SP_AppInstanceErrorDetails$get_errorDetail() {
        this.checkUninitializedProperty('ErrorDetail');
        return ((this.get_objectData()).get_properties())['ErrorDetail'];
    },
    get_errorType: function SP_AppInstanceErrorDetails$get_errorType() {
        this.checkUninitializedProperty('ErrorType');
        return ((this.get_objectData()).get_properties())['ErrorType'];
    },
    set_errorType: function SP_AppInstanceErrorDetails$set_errorType(value) {
        ((this.get_objectData()).get_properties())['ErrorType'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ErrorType', value));
        }
        return value;
    },
    get_errorTypeName: function SP_AppInstanceErrorDetails$get_errorTypeName() {
        this.checkUninitializedProperty('ErrorTypeName');
        return ((this.get_objectData()).get_properties())['ErrorTypeName'];
    },
    get_exceptionMessage: function SP_AppInstanceErrorDetails$get_exceptionMessage() {
        this.checkUninitializedProperty('ExceptionMessage');
        return ((this.get_objectData()).get_properties())['ExceptionMessage'];
    },
    get_source: function SP_AppInstanceErrorDetails$get_source() {
        this.checkUninitializedProperty('Source');
        return ((this.get_objectData()).get_properties())['Source'];
    },
    set_source: function SP_AppInstanceErrorDetails$set_source(value) {
        ((this.get_objectData()).get_properties())['Source'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Source', value));
        }
        return value;
    },
    get_sourceName: function SP_AppInstanceErrorDetails$get_sourceName() {
        this.checkUninitializedProperty('SourceName');
        return ((this.get_objectData()).get_properties())['SourceName'];
    },
    initPropertiesFromJson: function SP_AppInstanceErrorDetails$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CorrelationId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CorrelationId'] = $v_0;
            delete parentNode.CorrelationId;
        }
        $v_0 = parentNode.ErrorDetail;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ErrorDetail'] = $v_0;
            delete parentNode.ErrorDetail;
        }
        $v_0 = parentNode.ErrorType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ErrorType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ErrorType;
        }
        $v_0 = parentNode.ErrorTypeName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ErrorTypeName'] = $v_0;
            delete parentNode.ErrorTypeName;
        }
        $v_0 = parentNode.ExceptionMessage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ExceptionMessage'] = $v_0;
            delete parentNode.ExceptionMessage;
        }
        $v_0 = parentNode.Source;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Source'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Source;
        }
        $v_0 = parentNode.SourceName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SourceName'] = $v_0;
            delete parentNode.SourceName;
        }
    }
};
SP.AppInstanceErrorDetailsPropertyNames = function SP_AppInstanceErrorDetailsPropertyNames() {
};
SP.AppLicense = function SP_AppLicense() {
    SP.AppLicense.initializeBase(this);
};
SP.AppLicense.prototype = {
    $6g_1: null,
    get_rawXMLLicenseToken: function SP_AppLicense$get_rawXMLLicenseToken() {
        return this.$6g_1;
    },
    get_typeId: function SP_AppLicense$get_typeId() {
        return '{d3425bf9-fe82-4957-afda-5fbd21dabb85}';
    },
    writeToXml: function SP_AppLicense$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['RawXMLLicenseToken'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_AppLicense$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.RawXMLLicenseToken;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6g_1 = $v_0;
            delete parentNode.RawXMLLicenseToken;
        }
    }
};
SP.AppLicenseCollection = function SP_AppLicenseCollection() {
    SP.AppLicenseCollection.initializeBase(this);
};
SP.AppLicenseCollection.prototype = {
    add: function SP_AppLicenseCollection$add(item) {
        this.addChild(item);
    },
    get_item: function SP_AppLicenseCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_typeId: function SP_AppLicenseCollection$get_typeId() {
        return '{47beb529-4c4b-41ba-b717-28d18fbdf258}';
    },
    writeToXml: function SP_AppLicenseCollection$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        SP.ClientValueObjectCollection.prototype.writeToXml.call(this, writer, serializationContext);
    }
};
SP.AppSiteContext = function SP_AppSiteContext() {
    SP.AppSiteContext.initializeBase(this);
};
SP.AppSiteContext.prototype = {
    $6q_1: null,
    get_siteUrl: function SP_AppSiteContext$get_siteUrl() {
        return this.$6q_1;
    },
    get_typeId: function SP_AppSiteContext$get_typeId() {
        return '{5d861cdf-2818-4912-afd3-82caa1032837}';
    },
    writeToXml: function SP_AppSiteContext$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['SiteUrl'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_AppSiteContext$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.SiteUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6q_1 = $v_0;
            delete parentNode.SiteUrl;
        }
    }
};
SP.AppSiteContextUtility = function SP_AppSiteContextUtility() {
};
SP.AppSiteContextUtility.getAppSiteContextCollection = function SP_AppSiteContextUtility$getAppSiteContextCollection(context) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{d6cbdc41-0a1e-4711-bb3b-69d81746a39b}', 'GetAppSiteContextCollection', null);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.AppTile = function SP_AppTile(context, objectPath) {
    SP.AppTile.initializeBase(this, [context, objectPath]);
};
SP.AppTile.prototype = {
    get_appType: function SP_AppTile$get_appType() {
        this.checkUninitializedProperty('AppType');
        return ((this.get_objectData()).get_properties())['AppType'];
    },
    get_childCount: function SP_AppTile$get_childCount() {
        this.checkUninitializedProperty('ChildCount');
        return ((this.get_objectData()).get_properties())['ChildCount'];
    },
    get_lastModified: function SP_AppTile$get_lastModified() {
        this.checkUninitializedProperty('LastModified');
        return ((this.get_objectData()).get_properties())['LastModified'];
    },
    get_target: function SP_AppTile$get_target() {
        this.checkUninitializedProperty('Target');
        return ((this.get_objectData()).get_properties())['Target'];
    },
    get_thumbnail: function SP_AppTile$get_thumbnail() {
        this.checkUninitializedProperty('Thumbnail');
        return ((this.get_objectData()).get_properties())['Thumbnail'];
    },
    get_title: function SP_AppTile$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    initPropertiesFromJson: function SP_AppTile$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AppType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AppType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.AppType;
        }
        $v_0 = parentNode.ChildCount;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ChildCount'] = $v_0;
            delete parentNode.ChildCount;
        }
        $v_0 = parentNode.LastModified;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LastModified'] = $v_0;
            delete parentNode.LastModified;
        }
        $v_0 = parentNode.Target;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Target'] = $v_0;
            delete parentNode.Target;
        }
        $v_0 = parentNode.Thumbnail;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Thumbnail'] = $v_0;
            delete parentNode.Thumbnail;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
    }
};
SP.AppTilePropertyNames = function SP_AppTilePropertyNames() {
};
SP.AppTileCollection = function SP_AppTileCollection(context, objectPath) {
    SP.AppTileCollection.initializeBase(this, [context, objectPath]);
};
SP.AppTileCollection.prototype = {
    itemAt: function SP_AppTileCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_AppTileCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_AppTileCollection$get_childItemType() {
        return SP.AppTile;
    }
};
SP.Attachment = function SP_Attachment(context, objectPath) {
    SP.Attachment.initializeBase(this, [context, objectPath]);
};
SP.Attachment.prototype = {
    get_fileName: function SP_Attachment$get_fileName() {
        this.checkUninitializedProperty('FileName');
        return ((this.get_objectData()).get_properties())['FileName'];
    },
    get_serverRelativeUrl: function SP_Attachment$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    initPropertiesFromJson: function SP_Attachment$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FileName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FileName'] = $v_0;
            delete parentNode.FileName;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
    },
    deleteObject: function SP_Attachment$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.AttachmentPropertyNames = function SP_AttachmentPropertyNames() {
};
SP.AttachmentCollection = function SP_AttachmentCollection(context, objectPath) {
    SP.AttachmentCollection.initializeBase(this, [context, objectPath]);
};
SP.AttachmentCollection.prototype = {
    itemAt: function SP_AttachmentCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_AttachmentCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_AttachmentCollection$get_childItemType() {
        return SP.Attachment;
    },
    getByFileName: function SP_AttachmentCollection$getByFileName(fileName) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Attachment($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByFileName', [fileName]));
        return $v_1;
    }
};
SP.AttachmentCreationInformation = function SP_AttachmentCreationInformation() {
    SP.AttachmentCreationInformation.initializeBase(this);
};
SP.AttachmentCreationInformation.prototype = {
    $2P_1: null,
    $2h_1: null,
    get_contentStream: function SP_AttachmentCreationInformation$get_contentStream() {
        return this.$2P_1;
    },
    set_contentStream: function SP_AttachmentCreationInformation$set_contentStream(value) {
        this.$2P_1 = value;
        return value;
    },
    get_fileName: function SP_AttachmentCreationInformation$get_fileName() {
        return this.$2h_1;
    },
    set_fileName: function SP_AttachmentCreationInformation$set_fileName(value) {
        this.$2h_1 = value;
        return value;
    },
    get_typeId: function SP_AttachmentCreationInformation$get_typeId() {
        return '{edf6309c-8142-4133-921e-4d6aec35550d}';
    },
    writeToXml: function SP_AttachmentCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['ContentStream', 'FileName'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_AttachmentCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ContentStream;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2P_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.ContentStream;
        }
        $v_0 = parentNode.FileName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2h_1 = $v_0;
            delete parentNode.FileName;
        }
    }
};
SP.Audit = function SP_Audit(context, objectPath) {
    SP.Audit.initializeBase(this, [context, objectPath]);
};
SP.Audit.prototype = {
    get_auditFlags: function SP_Audit$get_auditFlags() {
        this.checkUninitializedProperty('AuditFlags');
        return ((this.get_objectData()).get_properties())['AuditFlags'];
    },
    set_auditFlags: function SP_Audit$set_auditFlags(value) {
        ((this.get_objectData()).get_properties())['AuditFlags'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AuditFlags', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_Audit$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AuditFlags;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AuditFlags'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.AuditFlags;
        }
    },
    update: function SP_Audit$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    }
};
SP.AuditPropertyNames = function SP_AuditPropertyNames() {
};
SP.BasePermissions = function SP_BasePermissions() {
    SP.BasePermissions.initializeBase(this);
};
SP.BasePermissions.prototype = {
    $9_1: 0,
    $A_1: 0,
    set: function SP_BasePermissions$set(perm) {
        if (perm === 65) {
            this.$A_1 = 65535;
            this.$9_1 = 32767;
            return;
        }
        if (!perm) {
            this.$A_1 = 0;
            this.$9_1 = 0;
            return;
        }
        var $v_0 = perm;

        $v_0 = $v_0 - 1;
        var $v_1 = 1;

        if ($v_0 >= 0 && $v_0 < 32) {
            $v_1 = $v_1 << $v_0;
            this.$A_1 = this.$A_1 | $v_1;
        }
        else if ($v_0 >= 32 && $v_0 < 64) {
            $v_1 = $v_1 << $v_0 - 32;
            this.$9_1 = this.$9_1 | $v_1;
        }
    },
    clear: function SP_BasePermissions$clear(perm) {
        var $v_0 = perm;

        $v_0 = $v_0 - 1;
        var $v_1 = 1;

        if ($v_0 >= 0 && $v_0 < 32) {
            $v_1 = $v_1 << $v_0;
            $v_1 = ~$v_1;
            this.$A_1 = this.$A_1 & $v_1;
        }
        else if ($v_0 >= 32 && $v_0 < 64) {
            $v_1 = $v_1 << $v_0 - 32;
            $v_1 = ~$v_1;
            this.$9_1 = this.$9_1 & $v_1;
        }
    },
    clearAll: function SP_BasePermissions$clearAll() {
        this.$9_1 = 0;
        this.$A_1 = 0;
    },
    has: function SP_BasePermissions$has(perm) {
        if (!perm) {
            return true;
        }
        if (perm === 65) {
            return (this.$9_1 & 32767) === 32767 && this.$A_1 === 65535;
        }
        var $v_0 = perm;

        $v_0 = $v_0 - 1;
        var $v_1 = 1;

        if ($v_0 >= 0 && $v_0 < 32) {
            $v_1 = $v_1 << $v_0;
            return 0 !== (this.$A_1 & $v_1);
        }
        else if ($v_0 >= 32 && $v_0 < 64) {
            $v_1 = $v_1 << $v_0 - 32;
            return 0 !== (this.$9_1 & $v_1);
        }
        return false;
    },
    equals: function SP_BasePermissions$equals(perm) {
        if (!perm) {
            return false;
        }
        return perm.$9_1 === this.$9_1 && perm.$A_1 === this.$A_1;
    },
    hasPermissions: function SP_BasePermissions$hasPermissions(high, low) {
        return (this.$9_1 & high) === high && (this.$A_1 & low) === low;
    },
    get_typeId: function SP_BasePermissions$get_typeId() {
        return '{db780e5a-6bc6-41ad-8e64-9dfa761afb6d}';
    },
    writeToXml: function SP_BasePermissions$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        writer.writeStartElement('Property');
        writer.writeAttributeString('Name', 'High');
        SP.DataConvert.writeValueToXmlElement(writer, this.$9_1, serializationContext);
        writer.writeEndElement();
        writer.writeStartElement('Property');
        writer.writeAttributeString('Name', 'Low');
        SP.DataConvert.writeValueToXmlElement(writer, this.$A_1, serializationContext);
        writer.writeEndElement();
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_BasePermissions$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.High;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$9_1 = $v_0;
            delete parentNode.High;
        }
        $v_0 = parentNode.Low;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$A_1 = $v_0;
            delete parentNode.Low;
        }
    }
};
SP.CamlQuery = function SP_CamlQuery() {
    SP.CamlQuery.initializeBase(this);
    this.$T_1 = true;
};
SP.CamlQuery.createAllItemsQuery = function SP_CamlQuery$createAllItemsQuery() {
    var $v_0 = new SP.CamlQuery();

    $v_0.$S_1 = '<View Scope=\"RecursiveAll\">\r\n    <Query>\r\n    </Query>\r\n</View>';
    return $v_0;
};
SP.CamlQuery.createAllFoldersQuery = function SP_CamlQuery$createAllFoldersQuery() {
    var $v_0 = new SP.CamlQuery();

    $v_0.$S_1 = '<View Scope=\"RecursiveAll\">\r\n    <Query>\r\n        <Where>\r\n            <Eq>\r\n                <FieldRef Name=\"FSObjType\" />\r\n                <Value Type=\"Integer\">1</Value>\r\n            </Eq>\r\n        </Where>\r\n    </Query>\r\n</View>';
    return $v_0;
};
SP.CamlQuery.prototype = {
    $T_1: false,
    $c_1: null,
    $4I_1: null,
    $S_1: null,
    get_datesInUtc: function SP_CamlQuery$get_datesInUtc() {
        return this.$T_1;
    },
    set_datesInUtc: function SP_CamlQuery$set_datesInUtc(value) {
        this.$T_1 = value;
        return value;
    },
    get_folderServerRelativeUrl: function SP_CamlQuery$get_folderServerRelativeUrl() {
        return this.$c_1;
    },
    set_folderServerRelativeUrl: function SP_CamlQuery$set_folderServerRelativeUrl(value) {
        this.$c_1 = value;
        return value;
    },
    get_listItemCollectionPosition: function SP_CamlQuery$get_listItemCollectionPosition() {
        return this.$4I_1;
    },
    set_listItemCollectionPosition: function SP_CamlQuery$set_listItemCollectionPosition(value) {
        this.$4I_1 = value;
        return value;
    },
    get_viewXml: function SP_CamlQuery$get_viewXml() {
        return this.$S_1;
    },
    set_viewXml: function SP_CamlQuery$set_viewXml(value) {
        this.$S_1 = value;
        return value;
    },
    get_typeId: function SP_CamlQuery$get_typeId() {
        return '{3d248d7b-fc86-40a3-aa97-02a75d69fb8a}';
    },
    writeToXml: function SP_CamlQuery$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['DatesInUtc', 'FolderServerRelativeUrl', 'ListItemCollectionPosition', 'ViewXml'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_CamlQuery$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DatesInUtc;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$T_1 = $v_0;
            delete parentNode.DatesInUtc;
        }
        $v_0 = parentNode.FolderServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$c_1 = $v_0;
            delete parentNode.FolderServerRelativeUrl;
        }
        $v_0 = parentNode.ListItemCollectionPosition;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4I_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.ListItemCollectionPosition;
        }
        $v_0 = parentNode.ViewXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$S_1 = $v_0;
            delete parentNode.ViewXml;
        }
    }
};
SP.Change = function SP_Change(context, objectPath) {
    SP.Change.initializeBase(this, [context, objectPath]);
};
SP.Change.prototype = {
    get_changeToken: function SP_Change$get_changeToken() {
        this.checkUninitializedProperty('ChangeToken');
        return ((this.get_objectData()).get_properties())['ChangeToken'];
    },
    get_changeType: function SP_Change$get_changeType() {
        this.checkUninitializedProperty('ChangeType');
        return ((this.get_objectData()).get_properties())['ChangeType'];
    },
    get_siteId: function SP_Change$get_siteId() {
        this.checkUninitializedProperty('SiteId');
        return ((this.get_objectData()).get_properties())['SiteId'];
    },
    get_time: function SP_Change$get_time() {
        this.checkUninitializedProperty('Time');
        return ((this.get_objectData()).get_properties())['Time'];
    },
    initPropertiesFromJson: function SP_Change$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ChangeToken;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ChangeToken'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ChangeToken;
        }
        $v_0 = parentNode.ChangeType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ChangeType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ChangeType;
        }
        $v_0 = parentNode.SiteId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SiteId'] = $v_0;
            delete parentNode.SiteId;
        }
        $v_0 = parentNode.Time;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Time'] = $v_0;
            delete parentNode.Time;
        }
    }
};
SP.ChangePropertyNames = function SP_ChangePropertyNames() {
};
SP.ChangeAlert = function SP_ChangeAlert(context, objectPath) {
    SP.ChangeAlert.initializeBase(this, [context, objectPath]);
};
SP.ChangeAlert.prototype = {
    get_alertId: function SP_ChangeAlert$get_alertId() {
        this.checkUninitializedProperty('AlertId');
        return ((this.get_objectData()).get_properties())['AlertId'];
    },
    get_webId: function SP_ChangeAlert$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeAlert$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AlertId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AlertId'] = $v_0;
            delete parentNode.AlertId;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeAlertPropertyNames = function SP_ChangeAlertPropertyNames() {
};
SP.ChangeCollection = function SP_ChangeCollection(context, objectPath) {
    SP.ChangeCollection.initializeBase(this, [context, objectPath]);
};
SP.ChangeCollection.prototype = {
    itemAt: function SP_ChangeCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ChangeCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ChangeCollection$get_childItemType() {
        return SP.Change;
    }
};
SP.ChangeContentType = function SP_ChangeContentType(context, objectPath) {
    SP.ChangeContentType.initializeBase(this, [context, objectPath]);
};
SP.ChangeContentType.prototype = {
    get_contentTypeId: function SP_ChangeContentType$get_contentTypeId() {
        this.checkUninitializedProperty('ContentTypeId');
        return ((this.get_objectData()).get_properties())['ContentTypeId'];
    },
    get_webId: function SP_ChangeContentType$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeContentType$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ContentTypeId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContentTypeId'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ContentTypeId;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeContentTypePropertyNames = function SP_ChangeContentTypePropertyNames() {
};
SP.ChangeField = function SP_ChangeField(context, objectPath) {
    SP.ChangeField.initializeBase(this, [context, objectPath]);
};
SP.ChangeField.prototype = {
    get_fieldId: function SP_ChangeField$get_fieldId() {
        this.checkUninitializedProperty('FieldId');
        return ((this.get_objectData()).get_properties())['FieldId'];
    },
    get_webId: function SP_ChangeField$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeField$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FieldId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FieldId'] = $v_0;
            delete parentNode.FieldId;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeFieldPropertyNames = function SP_ChangeFieldPropertyNames() {
};
SP.ChangeFile = function SP_ChangeFile(context, objectPath) {
    SP.ChangeFile.initializeBase(this, [context, objectPath]);
};
SP.ChangeFile.prototype = {
    get_uniqueId: function SP_ChangeFile$get_uniqueId() {
        this.checkUninitializedProperty('UniqueId');
        return ((this.get_objectData()).get_properties())['UniqueId'];
    },
    get_webId: function SP_ChangeFile$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeFile$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.UniqueId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UniqueId'] = $v_0;
            delete parentNode.UniqueId;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeFilePropertyNames = function SP_ChangeFilePropertyNames() {
};
SP.ChangeFolder = function SP_ChangeFolder(context, objectPath) {
    SP.ChangeFolder.initializeBase(this, [context, objectPath]);
};
SP.ChangeFolder.prototype = {
    get_uniqueId: function SP_ChangeFolder$get_uniqueId() {
        this.checkUninitializedProperty('UniqueId');
        return ((this.get_objectData()).get_properties())['UniqueId'];
    },
    get_webId: function SP_ChangeFolder$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeFolder$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.UniqueId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UniqueId'] = $v_0;
            delete parentNode.UniqueId;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeFolderPropertyNames = function SP_ChangeFolderPropertyNames() {
};
SP.ChangeGroup = function SP_ChangeGroup(context, objectPath) {
    SP.ChangeGroup.initializeBase(this, [context, objectPath]);
};
SP.ChangeGroup.prototype = {
    get_groupId: function SP_ChangeGroup$get_groupId() {
        this.checkUninitializedProperty('GroupId');
        return ((this.get_objectData()).get_properties())['GroupId'];
    },
    initPropertiesFromJson: function SP_ChangeGroup$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.GroupId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GroupId'] = $v_0;
            delete parentNode.GroupId;
        }
    }
};
SP.ChangeGroupPropertyNames = function SP_ChangeGroupPropertyNames() {
};
SP.ChangeItem = function SP_ChangeItem(context, objectPath) {
    SP.ChangeItem.initializeBase(this, [context, objectPath]);
};
SP.ChangeItem.prototype = {
    get_editor: function SP_ChangeItem$get_editor() {
        this.checkUninitializedProperty('Editor');
        return ((this.get_objectData()).get_properties())['Editor'];
    },
    get_editorEmailHint: function SP_ChangeItem$get_editorEmailHint() {
        this.checkUninitializedProperty('EditorEmailHint');
        return ((this.get_objectData()).get_properties())['EditorEmailHint'];
    },
    get_itemId: function SP_ChangeItem$get_itemId() {
        this.checkUninitializedProperty('ItemId');
        return ((this.get_objectData()).get_properties())['ItemId'];
    },
    get_listId: function SP_ChangeItem$get_listId() {
        this.checkUninitializedProperty('ListId');
        return ((this.get_objectData()).get_properties())['ListId'];
    },
    get_serverRelativeUrl: function SP_ChangeItem$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    get_sharedByUser: function SP_ChangeItem$get_sharedByUser() {
        this.checkUninitializedProperty('SharedByUser');
        return ((this.get_objectData()).get_properties())['SharedByUser'];
    },
    get_sharedWithUsers: function SP_ChangeItem$get_sharedWithUsers() {
        this.checkUninitializedProperty('SharedWithUsers');
        return ((this.get_objectData()).get_properties())['SharedWithUsers'];
    },
    get_webId: function SP_ChangeItem$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeItem$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Editor;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Editor'] = $v_0;
            delete parentNode.Editor;
        }
        $v_0 = parentNode.EditorEmailHint;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EditorEmailHint'] = $v_0;
            delete parentNode.EditorEmailHint;
        }
        $v_0 = parentNode.ItemId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemId'] = $v_0;
            delete parentNode.ItemId;
        }
        $v_0 = parentNode.ListId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListId'] = $v_0;
            delete parentNode.ListId;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.SharedByUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SharedByUser'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SharedByUser;
        }
        $v_0 = parentNode.SharedWithUsers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SharedWithUsers'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SharedWithUsers;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeItemPropertyNames = function SP_ChangeItemPropertyNames() {
};
SP.ChangeList = function SP_ChangeList(context, objectPath) {
    SP.ChangeList.initializeBase(this, [context, objectPath]);
};
SP.ChangeList.prototype = {
    get_listId: function SP_ChangeList$get_listId() {
        this.checkUninitializedProperty('ListId');
        return ((this.get_objectData()).get_properties())['ListId'];
    },
    get_webId: function SP_ChangeList$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeList$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ListId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListId'] = $v_0;
            delete parentNode.ListId;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeListPropertyNames = function SP_ChangeListPropertyNames() {
};
SP.ChangeLogItemQuery = function SP_ChangeLogItemQuery() {
    SP.ChangeLogItemQuery.initializeBase(this);
};
SP.ChangeLogItemQuery.prototype = {
    $2J_1: null,
    $2O_1: null,
    $m_1: null,
    $4Y_1: null,
    $o_1: null,
    $s_1: null,
    $5Q_1: null,
    get_changeToken: function SP_ChangeLogItemQuery$get_changeToken() {
        return this.$2J_1;
    },
    set_changeToken: function SP_ChangeLogItemQuery$set_changeToken(value) {
        this.$2J_1 = value;
        return value;
    },
    get_contains: function SP_ChangeLogItemQuery$get_contains() {
        return this.$2O_1;
    },
    set_contains: function SP_ChangeLogItemQuery$set_contains(value) {
        this.$2O_1 = value;
        return value;
    },
    get_query: function SP_ChangeLogItemQuery$get_query() {
        return this.$m_1;
    },
    set_query: function SP_ChangeLogItemQuery$set_query(value) {
        this.$m_1 = value;
        return value;
    },
    get_queryOptions: function SP_ChangeLogItemQuery$get_queryOptions() {
        return this.$4Y_1;
    },
    set_queryOptions: function SP_ChangeLogItemQuery$set_queryOptions(value) {
        this.$4Y_1 = value;
        return value;
    },
    get_rowLimit: function SP_ChangeLogItemQuery$get_rowLimit() {
        return this.$o_1;
    },
    set_rowLimit: function SP_ChangeLogItemQuery$set_rowLimit(value) {
        this.$o_1 = value;
        return value;
    },
    get_viewFields: function SP_ChangeLogItemQuery$get_viewFields() {
        return this.$s_1;
    },
    set_viewFields: function SP_ChangeLogItemQuery$set_viewFields(value) {
        this.$s_1 = value;
        return value;
    },
    get_viewName: function SP_ChangeLogItemQuery$get_viewName() {
        return this.$5Q_1;
    },
    set_viewName: function SP_ChangeLogItemQuery$set_viewName(value) {
        this.$5Q_1 = value;
        return value;
    },
    get_typeId: function SP_ChangeLogItemQuery$get_typeId() {
        return '{820ed5a1-95f7-493b-88fa-266e9db920af}';
    },
    writeToXml: function SP_ChangeLogItemQuery$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['ChangeToken', 'Contains', 'Query', 'QueryOptions', 'RowLimit', 'ViewFields', 'ViewName'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ChangeLogItemQuery$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ChangeToken;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2J_1 = $v_0;
            delete parentNode.ChangeToken;
        }
        $v_0 = parentNode.Contains;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2O_1 = $v_0;
            delete parentNode.Contains;
        }
        $v_0 = parentNode.Query;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$m_1 = $v_0;
            delete parentNode.Query;
        }
        $v_0 = parentNode.QueryOptions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4Y_1 = $v_0;
            delete parentNode.QueryOptions;
        }
        $v_0 = parentNode.RowLimit;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$o_1 = $v_0;
            delete parentNode.RowLimit;
        }
        $v_0 = parentNode.ViewFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$s_1 = $v_0;
            delete parentNode.ViewFields;
        }
        $v_0 = parentNode.ViewName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5Q_1 = $v_0;
            delete parentNode.ViewName;
        }
    }
};
SP.ChangeQuery = function SP_ChangeQuery(allChangeObjectTypes, allChangeTypes) {
    SP.ChangeQuery.initializeBase(this);
    if (!arguments.length) {
        allChangeObjectTypes = false;
        allChangeTypes = false;
    }
    this.$7m_1(allChangeObjectTypes, allChangeTypes);
};
SP.ChangeQuery.prototype = {
    $1H_1: false,
    $1I_1: false,
    $2K_1: null,
    $2L_1: null,
    $1L_1: false,
    $1M_1: false,
    $2c_1: 1000,
    $8_1: false,
    $1N_1: false,
    $1O_1: false,
    $Q_1: false,
    $1P_1: false,
    $1Q_1: false,
    $1R_1: false,
    $4E_1: false,
    $R_1: false,
    $1T_1: false,
    $1U_1: false,
    $4g_1: false,
    $1Z_1: false,
    $1a_1: false,
    $1b_1: false,
    $1c_1: false,
    $1d_1: false,
    $1e_1: false,
    $1f_1: false,
    $1g_1: false,
    $W_1: false,
    $1h_1: false,
    $1k_1: false,
    $q_1: false,
    $E_1: false,
    $K_1: false,
    $7m_1: function SP_ChangeQuery$$7m_1($p0, $p1) {
        if ($p0) {
            this.$1R_1 = true;
            this.$R_1 = true;
            this.$K_1 = true;
            this.$W_1 = true;
            this.$1N_1 = true;
            this.$1O_1 = true;
            this.$1I_1 = true;
            this.$q_1 = true;
            this.$Q_1 = true;
            this.$1L_1 = true;
            this.$8_1 = true;
            this.$1g_1 = true;
            this.$E_1 = true;
        }
        if ($p1) {
            this.$1H_1 = true;
            this.$1k_1 = true;
            this.$1M_1 = true;
            this.$1Z_1 = true;
            this.$1T_1 = true;
            this.$1a_1 = true;
            this.$1d_1 = true;
            this.$1e_1 = true;
            this.$1f_1 = true;
            this.$1b_1 = true;
            this.$1c_1 = true;
            this.$1P_1 = true;
            this.$1Q_1 = true;
            this.$1h_1 = true;
            this.$1U_1 = true;
        }
    },
    get_add: function SP_ChangeQuery$get_add() {
        return this.$1H_1;
    },
    set_add: function SP_ChangeQuery$set_add(value) {
        this.$1H_1 = value;
        return value;
    },
    get_alert: function SP_ChangeQuery$get_alert() {
        return this.$1I_1;
    },
    set_alert: function SP_ChangeQuery$set_alert(value) {
        this.$1I_1 = value;
        return value;
    },
    get_changeTokenEnd: function SP_ChangeQuery$get_changeTokenEnd() {
        return this.$2K_1;
    },
    set_changeTokenEnd: function SP_ChangeQuery$set_changeTokenEnd(value) {
        this.$2K_1 = value;
        return value;
    },
    get_changeTokenStart: function SP_ChangeQuery$get_changeTokenStart() {
        return this.$2L_1;
    },
    set_changeTokenStart: function SP_ChangeQuery$set_changeTokenStart(value) {
        this.$2L_1 = value;
        return value;
    },
    get_contentType: function SP_ChangeQuery$get_contentType() {
        return this.$1L_1;
    },
    set_contentType: function SP_ChangeQuery$set_contentType(value) {
        this.$1L_1 = value;
        return value;
    },
    get_deleteObject: function SP_ChangeQuery$get_deleteObject() {
        return this.$1M_1;
    },
    set_deleteObject: function SP_ChangeQuery$set_deleteObject(value) {
        this.$1M_1 = value;
        return value;
    },
    get_fetchLimit: function SP_ChangeQuery$get_fetchLimit() {
        return this.$2c_1;
    },
    set_fetchLimit: function SP_ChangeQuery$set_fetchLimit(value) {
        this.$2c_1 = value;
        return value;
    },
    get_field: function SP_ChangeQuery$get_field() {
        return this.$8_1;
    },
    set_field: function SP_ChangeQuery$set_field(value) {
        this.$8_1 = value;
        return value;
    },
    get_file: function SP_ChangeQuery$get_file() {
        return this.$1N_1;
    },
    set_file: function SP_ChangeQuery$set_file(value) {
        this.$1N_1 = value;
        return value;
    },
    get_folder: function SP_ChangeQuery$get_folder() {
        return this.$1O_1;
    },
    set_folder: function SP_ChangeQuery$set_folder(value) {
        this.$1O_1 = value;
        return value;
    },
    get_group: function SP_ChangeQuery$get_group() {
        return this.$Q_1;
    },
    set_group: function SP_ChangeQuery$set_group(value) {
        this.$Q_1 = value;
        return value;
    },
    get_groupMembershipAdd: function SP_ChangeQuery$get_groupMembershipAdd() {
        return this.$1P_1;
    },
    set_groupMembershipAdd: function SP_ChangeQuery$set_groupMembershipAdd(value) {
        this.$1P_1 = value;
        return value;
    },
    get_groupMembershipDelete: function SP_ChangeQuery$get_groupMembershipDelete() {
        return this.$1Q_1;
    },
    set_groupMembershipDelete: function SP_ChangeQuery$set_groupMembershipDelete(value) {
        this.$1Q_1 = value;
        return value;
    },
    get_item: function SP_ChangeQuery$get_item() {
        return this.$1R_1;
    },
    set_item: function SP_ChangeQuery$set_item(value) {
        this.$1R_1 = value;
        return value;
    },
    get_latestFirst: function SP_ChangeQuery$get_latestFirst() {
        return this.$4E_1;
    },
    set_latestFirst: function SP_ChangeQuery$set_latestFirst(value) {
        this.$4E_1 = value;
        return value;
    },
    get_list: function SP_ChangeQuery$get_list() {
        return this.$R_1;
    },
    set_list: function SP_ChangeQuery$set_list(value) {
        this.$R_1 = value;
        return value;
    },
    get_move: function SP_ChangeQuery$get_move() {
        return this.$1T_1;
    },
    set_move: function SP_ChangeQuery$set_move(value) {
        this.$1T_1 = value;
        return value;
    },
    get_navigation: function SP_ChangeQuery$get_navigation() {
        return this.$1U_1;
    },
    set_navigation: function SP_ChangeQuery$set_navigation(value) {
        this.$1U_1 = value;
        return value;
    },
    get_recursiveAll: function SP_ChangeQuery$get_recursiveAll() {
        return this.$4g_1;
    },
    set_recursiveAll: function SP_ChangeQuery$set_recursiveAll(value) {
        this.$4g_1 = value;
        return value;
    },
    get_rename: function SP_ChangeQuery$get_rename() {
        return this.$1Z_1;
    },
    set_rename: function SP_ChangeQuery$set_rename(value) {
        this.$1Z_1 = value;
        return value;
    },
    get_restore: function SP_ChangeQuery$get_restore() {
        return this.$1a_1;
    },
    set_restore: function SP_ChangeQuery$set_restore(value) {
        this.$1a_1 = value;
        return value;
    },
    get_roleAssignmentAdd: function SP_ChangeQuery$get_roleAssignmentAdd() {
        return this.$1b_1;
    },
    set_roleAssignmentAdd: function SP_ChangeQuery$set_roleAssignmentAdd(value) {
        this.$1b_1 = value;
        return value;
    },
    get_roleAssignmentDelete: function SP_ChangeQuery$get_roleAssignmentDelete() {
        return this.$1c_1;
    },
    set_roleAssignmentDelete: function SP_ChangeQuery$set_roleAssignmentDelete(value) {
        this.$1c_1 = value;
        return value;
    },
    get_roleDefinitionAdd: function SP_ChangeQuery$get_roleDefinitionAdd() {
        return this.$1d_1;
    },
    set_roleDefinitionAdd: function SP_ChangeQuery$set_roleDefinitionAdd(value) {
        this.$1d_1 = value;
        return value;
    },
    get_roleDefinitionDelete: function SP_ChangeQuery$get_roleDefinitionDelete() {
        return this.$1e_1;
    },
    set_roleDefinitionDelete: function SP_ChangeQuery$set_roleDefinitionDelete(value) {
        this.$1e_1 = value;
        return value;
    },
    get_roleDefinitionUpdate: function SP_ChangeQuery$get_roleDefinitionUpdate() {
        return this.$1f_1;
    },
    set_roleDefinitionUpdate: function SP_ChangeQuery$set_roleDefinitionUpdate(value) {
        this.$1f_1 = value;
        return value;
    },
    get_securityPolicy: function SP_ChangeQuery$get_securityPolicy() {
        return this.$1g_1;
    },
    set_securityPolicy: function SP_ChangeQuery$set_securityPolicy(value) {
        this.$1g_1 = value;
        return value;
    },
    get_site: function SP_ChangeQuery$get_site() {
        return this.$W_1;
    },
    set_site: function SP_ChangeQuery$set_site(value) {
        this.$W_1 = value;
        return value;
    },
    get_systemUpdate: function SP_ChangeQuery$get_systemUpdate() {
        return this.$1h_1;
    },
    set_systemUpdate: function SP_ChangeQuery$set_systemUpdate(value) {
        this.$1h_1 = value;
        return value;
    },
    get_update: function SP_ChangeQuery$get_update() {
        return this.$1k_1;
    },
    set_update: function SP_ChangeQuery$set_update(value) {
        this.$1k_1 = value;
        return value;
    },
    get_user: function SP_ChangeQuery$get_user() {
        return this.$q_1;
    },
    set_user: function SP_ChangeQuery$set_user(value) {
        this.$q_1 = value;
        return value;
    },
    get_view: function SP_ChangeQuery$get_view() {
        return this.$E_1;
    },
    set_view: function SP_ChangeQuery$set_view(value) {
        this.$E_1 = value;
        return value;
    },
    get_web: function SP_ChangeQuery$get_web() {
        return this.$K_1;
    },
    set_web: function SP_ChangeQuery$set_web(value) {
        this.$K_1 = value;
        return value;
    },
    get_typeId: function SP_ChangeQuery$get_typeId() {
        return '{887a7218-1232-4cfc-b78f-88d54e9d8ec7}';
    },
    writeToXml: function SP_ChangeQuery$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Add', 'Alert', 'ChangeTokenEnd', 'ChangeTokenStart', 'ContentType', 'DeleteObject', 'FetchLimit', 'Field', 'File', 'Folder', 'Group', 'GroupMembershipAdd', 'GroupMembershipDelete', 'Item', 'LatestFirst', 'List', 'Move', 'Navigation', 'RecursiveAll', 'Rename', 'Restore', 'RoleAssignmentAdd', 'RoleAssignmentDelete', 'RoleDefinitionAdd', 'RoleDefinitionDelete', 'RoleDefinitionUpdate', 'SecurityPolicy', 'Site', 'SystemUpdate', 'Update', 'User', 'View', 'Web'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ChangeQuery$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Add;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1H_1 = $v_0;
            delete parentNode.Add;
        }
        $v_0 = parentNode.Alert;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1I_1 = $v_0;
            delete parentNode.Alert;
        }
        $v_0 = parentNode.ChangeTokenEnd;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2K_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.ChangeTokenEnd;
        }
        $v_0 = parentNode.ChangeTokenStart;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2L_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.ChangeTokenStart;
        }
        $v_0 = parentNode.ContentType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1L_1 = $v_0;
            delete parentNode.ContentType;
        }
        $v_0 = parentNode.DeleteObject;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1M_1 = $v_0;
            delete parentNode.DeleteObject;
        }
        $v_0 = parentNode.FetchLimit;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2c_1 = $v_0;
            delete parentNode.FetchLimit;
        }
        $v_0 = parentNode.Field;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$8_1 = $v_0;
            delete parentNode.Field;
        }
        $v_0 = parentNode.File;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1N_1 = $v_0;
            delete parentNode.File;
        }
        $v_0 = parentNode.Folder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1O_1 = $v_0;
            delete parentNode.Folder;
        }
        $v_0 = parentNode.Group;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$Q_1 = $v_0;
            delete parentNode.Group;
        }
        $v_0 = parentNode.GroupMembershipAdd;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1P_1 = $v_0;
            delete parentNode.GroupMembershipAdd;
        }
        $v_0 = parentNode.GroupMembershipDelete;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1Q_1 = $v_0;
            delete parentNode.GroupMembershipDelete;
        }
        $v_0 = parentNode.Item;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1R_1 = $v_0;
            delete parentNode.Item;
        }
        $v_0 = parentNode.LatestFirst;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4E_1 = $v_0;
            delete parentNode.LatestFirst;
        }
        $v_0 = parentNode.List;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$R_1 = $v_0;
            delete parentNode.List;
        }
        $v_0 = parentNode.Move;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1T_1 = $v_0;
            delete parentNode.Move;
        }
        $v_0 = parentNode.Navigation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1U_1 = $v_0;
            delete parentNode.Navigation;
        }
        $v_0 = parentNode.RecursiveAll;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4g_1 = $v_0;
            delete parentNode.RecursiveAll;
        }
        $v_0 = parentNode.Rename;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1Z_1 = $v_0;
            delete parentNode.Rename;
        }
        $v_0 = parentNode.Restore;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1a_1 = $v_0;
            delete parentNode.Restore;
        }
        $v_0 = parentNode.RoleAssignmentAdd;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1b_1 = $v_0;
            delete parentNode.RoleAssignmentAdd;
        }
        $v_0 = parentNode.RoleAssignmentDelete;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1c_1 = $v_0;
            delete parentNode.RoleAssignmentDelete;
        }
        $v_0 = parentNode.RoleDefinitionAdd;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1d_1 = $v_0;
            delete parentNode.RoleDefinitionAdd;
        }
        $v_0 = parentNode.RoleDefinitionDelete;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1e_1 = $v_0;
            delete parentNode.RoleDefinitionDelete;
        }
        $v_0 = parentNode.RoleDefinitionUpdate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1f_1 = $v_0;
            delete parentNode.RoleDefinitionUpdate;
        }
        $v_0 = parentNode.SecurityPolicy;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1g_1 = $v_0;
            delete parentNode.SecurityPolicy;
        }
        $v_0 = parentNode.Site;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$W_1 = $v_0;
            delete parentNode.Site;
        }
        $v_0 = parentNode.SystemUpdate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1h_1 = $v_0;
            delete parentNode.SystemUpdate;
        }
        $v_0 = parentNode.Update;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1k_1 = $v_0;
            delete parentNode.Update;
        }
        $v_0 = parentNode.User;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$q_1 = $v_0;
            delete parentNode.User;
        }
        $v_0 = parentNode.View;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$E_1 = $v_0;
            delete parentNode.View;
        }
        $v_0 = parentNode.Web;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$K_1 = $v_0;
            delete parentNode.Web;
        }
    }
};
SP.ChangeSite = function SP_ChangeSite(context, objectPath) {
    SP.ChangeSite.initializeBase(this, [context, objectPath]);
};
SP.ChangeToken = function SP_ChangeToken() {
    SP.ChangeToken.initializeBase(this);
};
SP.ChangeToken.prototype = {
    $p_1: null,
    get_stringValue: function SP_ChangeToken$get_stringValue() {
        return this.$p_1;
    },
    set_stringValue: function SP_ChangeToken$set_stringValue(value) {
        this.$p_1 = value;
        return value;
    },
    get_typeId: function SP_ChangeToken$get_typeId() {
        return '{41c5be82-b5bf-4b5a-9712-97111fb87686}';
    },
    writeToXml: function SP_ChangeToken$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['StringValue'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ChangeToken$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.StringValue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$p_1 = $v_0;
            delete parentNode.StringValue;
        }
    }
};
SP.ChangeUser = function SP_ChangeUser(context, objectPath) {
    SP.ChangeUser.initializeBase(this, [context, objectPath]);
};
SP.ChangeUser.prototype = {
    get_activate: function SP_ChangeUser$get_activate() {
        this.checkUninitializedProperty('Activate');
        return ((this.get_objectData()).get_properties())['Activate'];
    },
    get_userId: function SP_ChangeUser$get_userId() {
        this.checkUninitializedProperty('UserId');
        return ((this.get_objectData()).get_properties())['UserId'];
    },
    initPropertiesFromJson: function SP_ChangeUser$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Activate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Activate'] = $v_0;
            delete parentNode.Activate;
        }
        $v_0 = parentNode.UserId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UserId'] = $v_0;
            delete parentNode.UserId;
        }
    }
};
SP.ChangeUserPropertyNames = function SP_ChangeUserPropertyNames() {
};
SP.ChangeView = function SP_ChangeView(context, objectPath) {
    SP.ChangeView.initializeBase(this, [context, objectPath]);
};
SP.ChangeView.prototype = {
    get_viewId: function SP_ChangeView$get_viewId() {
        this.checkUninitializedProperty('ViewId');
        return ((this.get_objectData()).get_properties())['ViewId'];
    },
    get_listId: function SP_ChangeView$get_listId() {
        this.checkUninitializedProperty('ListId');
        return ((this.get_objectData()).get_properties())['ListId'];
    },
    get_webId: function SP_ChangeView$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeView$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ViewId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ViewId'] = $v_0;
            delete parentNode.ViewId;
        }
        $v_0 = parentNode.ListId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListId'] = $v_0;
            delete parentNode.ListId;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeViewPropertyNames = function SP_ChangeViewPropertyNames() {
};
SP.ChangeWeb = function SP_ChangeWeb(context, objectPath) {
    SP.ChangeWeb.initializeBase(this, [context, objectPath]);
};
SP.ChangeWeb.prototype = {
    get_webId: function SP_ChangeWeb$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_ChangeWeb$initPropertiesFromJson(parentNode) {
        SP.Change.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.ChangeWebPropertyNames = function SP_ChangeWebPropertyNames() {
};
SP.CompatibilityRange = function SP_CompatibilityRange(context, objectPath) {
    SP.CompatibilityRange.initializeBase(this, [context, objectPath]);
};
SP.ContentType = function SP_ContentType(context, objectPath) {
    SP.ContentType.initializeBase(this, [context, objectPath]);
};
SP.ContentType.prototype = {
    $F_1: function SP_ContentType$$F_1($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Description'] = $p0.$2_1;
            ((this.get_objectData()).get_properties())['Group'] = $p0.$Q_1;
            ((this.get_objectData()).get_properties())['Name'] = $p0.$4_1;
        }
    },
    get_description: function SP_ContentType$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    set_description: function SP_ContentType$set_description(value) {
        ((this.get_objectData()).get_properties())['Description'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Description', value));
        }
        return value;
    },
    get_descriptionResource: function SP_ContentType$get_descriptionResource() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['DescriptionResource'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserResource(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'DescriptionResource'));
            ((this.get_objectData()).get_clientObjectProperties())['DescriptionResource'] = $v_0;
        }
        return $v_0;
    },
    get_displayFormTemplateName: function SP_ContentType$get_displayFormTemplateName() {
        this.checkUninitializedProperty('DisplayFormTemplateName');
        return ((this.get_objectData()).get_properties())['DisplayFormTemplateName'];
    },
    set_displayFormTemplateName: function SP_ContentType$set_displayFormTemplateName(value) {
        ((this.get_objectData()).get_properties())['DisplayFormTemplateName'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DisplayFormTemplateName', value));
        }
        return value;
    },
    get_displayFormUrl: function SP_ContentType$get_displayFormUrl() {
        this.checkUninitializedProperty('DisplayFormUrl');
        return ((this.get_objectData()).get_properties())['DisplayFormUrl'];
    },
    set_displayFormUrl: function SP_ContentType$set_displayFormUrl(value) {
        ((this.get_objectData()).get_properties())['DisplayFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DisplayFormUrl', value));
        }
        return value;
    },
    get_documentTemplate: function SP_ContentType$get_documentTemplate() {
        this.checkUninitializedProperty('DocumentTemplate');
        return ((this.get_objectData()).get_properties())['DocumentTemplate'];
    },
    set_documentTemplate: function SP_ContentType$set_documentTemplate(value) {
        ((this.get_objectData()).get_properties())['DocumentTemplate'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DocumentTemplate', value));
        }
        return value;
    },
    get_documentTemplateUrl: function SP_ContentType$get_documentTemplateUrl() {
        this.checkUninitializedProperty('DocumentTemplateUrl');
        return ((this.get_objectData()).get_properties())['DocumentTemplateUrl'];
    },
    get_editFormTemplateName: function SP_ContentType$get_editFormTemplateName() {
        this.checkUninitializedProperty('EditFormTemplateName');
        return ((this.get_objectData()).get_properties())['EditFormTemplateName'];
    },
    set_editFormTemplateName: function SP_ContentType$set_editFormTemplateName(value) {
        ((this.get_objectData()).get_properties())['EditFormTemplateName'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EditFormTemplateName', value));
        }
        return value;
    },
    get_editFormUrl: function SP_ContentType$get_editFormUrl() {
        this.checkUninitializedProperty('EditFormUrl');
        return ((this.get_objectData()).get_properties())['EditFormUrl'];
    },
    set_editFormUrl: function SP_ContentType$set_editFormUrl(value) {
        ((this.get_objectData()).get_properties())['EditFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EditFormUrl', value));
        }
        return value;
    },
    get_fieldLinks: function SP_ContentType$get_fieldLinks() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['FieldLinks'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FieldLinkCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'FieldLinks'));
            ((this.get_objectData()).get_clientObjectProperties())['FieldLinks'] = $v_0;
        }
        return $v_0;
    },
    get_fields: function SP_ContentType$get_fields() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Fields'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FieldCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Fields'));
            ((this.get_objectData()).get_clientObjectProperties())['Fields'] = $v_0;
        }
        return $v_0;
    },
    get_group: function SP_ContentType$get_group() {
        this.checkUninitializedProperty('Group');
        return ((this.get_objectData()).get_properties())['Group'];
    },
    set_group: function SP_ContentType$set_group(value) {
        ((this.get_objectData()).get_properties())['Group'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Group', value));
        }
        return value;
    },
    get_hidden: function SP_ContentType$get_hidden() {
        this.checkUninitializedProperty('Hidden');
        return ((this.get_objectData()).get_properties())['Hidden'];
    },
    set_hidden: function SP_ContentType$set_hidden(value) {
        ((this.get_objectData()).get_properties())['Hidden'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Hidden', value));
        }
        return value;
    },
    get_id: function SP_ContentType$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_jsLink: function SP_ContentType$get_jsLink() {
        this.checkUninitializedProperty('JSLink');
        return ((this.get_objectData()).get_properties())['JSLink'];
    },
    set_jsLink: function SP_ContentType$set_jsLink(value) {
        ((this.get_objectData()).get_properties())['JSLink'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'JSLink', value));
        }
        return value;
    },
    get_mobileDisplayFormUrl: function SP_ContentType$get_mobileDisplayFormUrl() {
        this.checkUninitializedProperty('MobileDisplayFormUrl');
        return ((this.get_objectData()).get_properties())['MobileDisplayFormUrl'];
    },
    set_mobileDisplayFormUrl: function SP_ContentType$set_mobileDisplayFormUrl(value) {
        ((this.get_objectData()).get_properties())['MobileDisplayFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MobileDisplayFormUrl', value));
        }
        return value;
    },
    get_mobileEditFormUrl: function SP_ContentType$get_mobileEditFormUrl() {
        this.checkUninitializedProperty('MobileEditFormUrl');
        return ((this.get_objectData()).get_properties())['MobileEditFormUrl'];
    },
    set_mobileEditFormUrl: function SP_ContentType$set_mobileEditFormUrl(value) {
        ((this.get_objectData()).get_properties())['MobileEditFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MobileEditFormUrl', value));
        }
        return value;
    },
    get_mobileNewFormUrl: function SP_ContentType$get_mobileNewFormUrl() {
        this.checkUninitializedProperty('MobileNewFormUrl');
        return ((this.get_objectData()).get_properties())['MobileNewFormUrl'];
    },
    set_mobileNewFormUrl: function SP_ContentType$set_mobileNewFormUrl(value) {
        ((this.get_objectData()).get_properties())['MobileNewFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MobileNewFormUrl', value));
        }
        return value;
    },
    get_name: function SP_ContentType$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    set_name: function SP_ContentType$set_name(value) {
        ((this.get_objectData()).get_properties())['Name'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Name', value));
        }
        return value;
    },
    get_nameResource: function SP_ContentType$get_nameResource() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['NameResource'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserResource(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'NameResource'));
            ((this.get_objectData()).get_clientObjectProperties())['NameResource'] = $v_0;
        }
        return $v_0;
    },
    get_newFormTemplateName: function SP_ContentType$get_newFormTemplateName() {
        this.checkUninitializedProperty('NewFormTemplateName');
        return ((this.get_objectData()).get_properties())['NewFormTemplateName'];
    },
    set_newFormTemplateName: function SP_ContentType$set_newFormTemplateName(value) {
        ((this.get_objectData()).get_properties())['NewFormTemplateName'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'NewFormTemplateName', value));
        }
        return value;
    },
    get_newFormUrl: function SP_ContentType$get_newFormUrl() {
        this.checkUninitializedProperty('NewFormUrl');
        return ((this.get_objectData()).get_properties())['NewFormUrl'];
    },
    set_newFormUrl: function SP_ContentType$set_newFormUrl(value) {
        ((this.get_objectData()).get_properties())['NewFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'NewFormUrl', value));
        }
        return value;
    },
    get_parent: function SP_ContentType$get_parent() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Parent'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ContentType(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Parent'));
            ((this.get_objectData()).get_clientObjectProperties())['Parent'] = $v_0;
        }
        return $v_0;
    },
    get_readOnly: function SP_ContentType$get_readOnly() {
        this.checkUninitializedProperty('ReadOnly');
        return ((this.get_objectData()).get_properties())['ReadOnly'];
    },
    set_readOnly: function SP_ContentType$set_readOnly(value) {
        ((this.get_objectData()).get_properties())['ReadOnly'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ReadOnly', value));
        }
        return value;
    },
    get_schemaXml: function SP_ContentType$get_schemaXml() {
        this.checkUninitializedProperty('SchemaXml');
        return ((this.get_objectData()).get_properties())['SchemaXml'];
    },
    get_schemaXmlWithResourceTokens: function SP_ContentType$get_schemaXmlWithResourceTokens() {
        this.checkUninitializedProperty('SchemaXmlWithResourceTokens');
        return ((this.get_objectData()).get_properties())['SchemaXmlWithResourceTokens'];
    },
    set_schemaXmlWithResourceTokens: function SP_ContentType$set_schemaXmlWithResourceTokens(value) {
        ((this.get_objectData()).get_properties())['SchemaXmlWithResourceTokens'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SchemaXmlWithResourceTokens', value));
        }
        return value;
    },
    get_scope: function SP_ContentType$get_scope() {
        this.checkUninitializedProperty('Scope');
        return ((this.get_objectData()).get_properties())['Scope'];
    },
    get_sealed: function SP_ContentType$get_sealed() {
        this.checkUninitializedProperty('Sealed');
        return ((this.get_objectData()).get_properties())['Sealed'];
    },
    set_sealed: function SP_ContentType$set_sealed(value) {
        ((this.get_objectData()).get_properties())['Sealed'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Sealed', value));
        }
        return value;
    },
    get_stringId: function SP_ContentType$get_stringId() {
        this.checkUninitializedProperty('StringId');
        return ((this.get_objectData()).get_properties())['StringId'];
    },
    get_workflowAssociations: function SP_ContentType$get_workflowAssociations() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['WorkflowAssociations'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Workflow.WorkflowAssociationCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'WorkflowAssociations'));
            ((this.get_objectData()).get_clientObjectProperties())['WorkflowAssociations'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_ContentType$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.DescriptionResource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('DescriptionResource', this.get_descriptionResource(), $v_0);
            (this.get_descriptionResource()).fromJson($v_0);
            delete parentNode.DescriptionResource;
        }
        $v_0 = parentNode.DisplayFormTemplateName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisplayFormTemplateName'] = $v_0;
            delete parentNode.DisplayFormTemplateName;
        }
        $v_0 = parentNode.DisplayFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisplayFormUrl'] = $v_0;
            delete parentNode.DisplayFormUrl;
        }
        $v_0 = parentNode.DocumentTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentTemplate'] = $v_0;
            delete parentNode.DocumentTemplate;
        }
        $v_0 = parentNode.DocumentTemplateUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentTemplateUrl'] = $v_0;
            delete parentNode.DocumentTemplateUrl;
        }
        $v_0 = parentNode.EditFormTemplateName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EditFormTemplateName'] = $v_0;
            delete parentNode.EditFormTemplateName;
        }
        $v_0 = parentNode.EditFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EditFormUrl'] = $v_0;
            delete parentNode.EditFormUrl;
        }
        $v_0 = parentNode.FieldLinks;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('FieldLinks', this.get_fieldLinks(), $v_0);
            (this.get_fieldLinks()).fromJson($v_0);
            delete parentNode.FieldLinks;
        }
        $v_0 = parentNode.Fields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Fields', this.get_fields(), $v_0);
            (this.get_fields()).fromJson($v_0);
            delete parentNode.Fields;
        }
        $v_0 = parentNode.Group;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Group'] = $v_0;
            delete parentNode.Group;
        }
        $v_0 = parentNode.Hidden;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Hidden'] = $v_0;
            delete parentNode.Hidden;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Id;
        }
        $v_0 = parentNode.JSLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['JSLink'] = $v_0;
            delete parentNode.JSLink;
        }
        $v_0 = parentNode.MobileDisplayFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MobileDisplayFormUrl'] = $v_0;
            delete parentNode.MobileDisplayFormUrl;
        }
        $v_0 = parentNode.MobileEditFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MobileEditFormUrl'] = $v_0;
            delete parentNode.MobileEditFormUrl;
        }
        $v_0 = parentNode.MobileNewFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MobileNewFormUrl'] = $v_0;
            delete parentNode.MobileNewFormUrl;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.NameResource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('NameResource', this.get_nameResource(), $v_0);
            (this.get_nameResource()).fromJson($v_0);
            delete parentNode.NameResource;
        }
        $v_0 = parentNode.NewFormTemplateName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['NewFormTemplateName'] = $v_0;
            delete parentNode.NewFormTemplateName;
        }
        $v_0 = parentNode.NewFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['NewFormUrl'] = $v_0;
            delete parentNode.NewFormUrl;
        }
        $v_0 = parentNode.Parent;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Parent', this.get_parent(), $v_0);
            (this.get_parent()).fromJson($v_0);
            delete parentNode.Parent;
        }
        $v_0 = parentNode.ReadOnly;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReadOnly'] = $v_0;
            delete parentNode.ReadOnly;
        }
        $v_0 = parentNode.SchemaXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SchemaXml'] = $v_0;
            delete parentNode.SchemaXml;
        }
        $v_0 = parentNode.SchemaXmlWithResourceTokens;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SchemaXmlWithResourceTokens'] = $v_0;
            delete parentNode.SchemaXmlWithResourceTokens;
        }
        $v_0 = parentNode.Scope;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Scope'] = $v_0;
            delete parentNode.Scope;
        }
        $v_0 = parentNode.Sealed;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Sealed'] = $v_0;
            delete parentNode.Sealed;
        }
        $v_0 = parentNode.StringId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['StringId'] = $v_0;
            delete parentNode.StringId;
        }
        $v_0 = parentNode.WorkflowAssociations;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('WorkflowAssociations', this.get_workflowAssociations(), $v_0);
            (this.get_workflowAssociations()).fromJson($v_0);
            delete parentNode.WorkflowAssociations;
        }
    },
    update: function SP_ContentType$update(updateChildren) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', [updateChildren]);

        $v_0.addQuery($v_1);
    },
    deleteObject: function SP_ContentType$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.ContentTypePropertyNames = function SP_ContentTypePropertyNames() {
};
SP.ContentTypeObjectPropertyNames = function SP_ContentTypeObjectPropertyNames() {
};
SP.ContentTypeCollection = function SP_ContentTypeCollection(context, objectPath) {
    SP.ContentTypeCollection.initializeBase(this, [context, objectPath]);
};
SP.ContentTypeCollection.prototype = {
    itemAt: function SP_ContentTypeCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ContentTypeCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ContentTypeCollection$get_childItemType() {
        return SP.ContentType;
    },
    getById: function SP_ContentTypeCollection$getById(contentTypeId) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[contentTypeId];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.ContentType($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [contentTypeId]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[contentTypeId] = $v_1;
        }
        return $v_1;
    },
    addExistingContentType: function SP_ContentTypeCollection$addExistingContentType(contentType) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ContentType($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'AddExistingContentType', [contentType]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    },
    add: function SP_ContentTypeCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ContentType($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_1(parameters);
        return $v_1;
    }
};
SP.ContentTypeCreationInformation = function SP_ContentTypeCreationInformation() {
    SP.ContentTypeCreationInformation.initializeBase(this);
};
SP.ContentTypeCreationInformation.prototype = {
    $2_1: null,
    $Q_1: null,
    $x_1: null,
    $4_1: null,
    $6b_1: null,
    get_description: function SP_ContentTypeCreationInformation$get_description() {
        return this.$2_1;
    },
    set_description: function SP_ContentTypeCreationInformation$set_description(value) {
        this.$2_1 = value;
        return value;
    },
    get_group: function SP_ContentTypeCreationInformation$get_group() {
        return this.$Q_1;
    },
    set_group: function SP_ContentTypeCreationInformation$set_group(value) {
        this.$Q_1 = value;
        return value;
    },
    get_id: function SP_ContentTypeCreationInformation$get_id() {
        return this.$x_1;
    },
    set_id: function SP_ContentTypeCreationInformation$set_id(value) {
        this.$x_1 = value;
        return value;
    },
    get_name: function SP_ContentTypeCreationInformation$get_name() {
        return this.$4_1;
    },
    set_name: function SP_ContentTypeCreationInformation$set_name(value) {
        this.$4_1 = value;
        return value;
    },
    get_parentContentType: function SP_ContentTypeCreationInformation$get_parentContentType() {
        return this.$6b_1;
    },
    set_parentContentType: function SP_ContentTypeCreationInformation$set_parentContentType(value) {
        this.$6b_1 = value;
        return value;
    },
    get_typeId: function SP_ContentTypeCreationInformation$get_typeId() {
        return '{168f3091-4554-4f14-8866-b20d48e45b54}';
    },
    writeToXml: function SP_ContentTypeCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Description', 'Group', 'Id', 'Name', 'ParentContentType'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ContentTypeCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2_1 = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Group;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$Q_1 = $v_0;
            delete parentNode.Group;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$x_1 = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4_1 = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.ParentContentType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            delete parentNode.ParentContentType;
        }
    }
};
SP.ContentTypeId = function SP_ContentTypeId() {
    SP.ContentTypeId.initializeBase(this);
};
SP.ContentTypeId.prototype = {
    $p_1: null,
    toString: function SP_ContentTypeId$toString() {
        return this.$p_1;
    },
    get_stringValue: function SP_ContentTypeId$get_stringValue() {
        return this.$p_1;
    },
    get_typeId: function SP_ContentTypeId$get_typeId() {
        return '{da0f1e90-296f-480e-bc27-cefe51eff241}';
    },
    writeToXml: function SP_ContentTypeId$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['StringValue'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ContentTypeId$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.StringValue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$p_1 = $v_0;
            delete parentNode.StringValue;
        }
    }
};
SP.CreatableItemInfo = function SP_CreatableItemInfo() {
    SP.CreatableItemInfo.initializeBase(this);
};
SP.CreatableItemInfo.prototype = {
    $66_1: 0,
    $6B_1: null,
    $6L_1: null,
    get_documentTemplate: function SP_CreatableItemInfo$get_documentTemplate() {
        return this.$66_1;
    },
    get_fileExtension: function SP_CreatableItemInfo$get_fileExtension() {
        return this.$6B_1;
    },
    get_itemType: function SP_CreatableItemInfo$get_itemType() {
        return this.$6L_1;
    },
    get_typeId: function SP_CreatableItemInfo$get_typeId() {
        return '{e9797d9d-2304-4c12-bc6b-4a4e9d7a0ea6}';
    },
    writeToXml: function SP_CreatableItemInfo$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['DocumentTemplate', 'FileExtension', 'ItemType'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_CreatableItemInfo$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DocumentTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$66_1 = $v_0;
            delete parentNode.DocumentTemplate;
        }
        $v_0 = parentNode.FileExtension;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6B_1 = $v_0;
            delete parentNode.FileExtension;
        }
        $v_0 = parentNode.ItemType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6L_1 = $v_0;
            delete parentNode.ItemType;
        }
    }
};
SP.CreatableItemInfoCollection = function SP_CreatableItemInfoCollection() {
    SP.CreatableItemInfoCollection.initializeBase(this);
};
SP.CreatableItemInfoCollection.prototype = {
    add: function SP_CreatableItemInfoCollection$add(item) {
        this.addChild(item);
    },
    get_item: function SP_CreatableItemInfoCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_typeId: function SP_CreatableItemInfoCollection$get_typeId() {
        return '{9b16c27e-29b9-46db-acb0-9e36d3ab244a}';
    },
    writeToXml: function SP_CreatableItemInfoCollection$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        SP.ClientValueObjectCollection.prototype.writeToXml.call(this, writer, serializationContext);
    }
};
SP.CreatablesInfo = function SP_CreatablesInfo(context, objectPath) {
    SP.CreatablesInfo.initializeBase(this, [context, objectPath]);
};
SP.CreatablesInfo.prototype = {
    get_canCreateFolders: function SP_CreatablesInfo$get_canCreateFolders() {
        this.checkUninitializedProperty('CanCreateFolders');
        return ((this.get_objectData()).get_properties())['CanCreateFolders'];
    },
    get_canCreateItems: function SP_CreatablesInfo$get_canCreateItems() {
        this.checkUninitializedProperty('CanCreateItems');
        return ((this.get_objectData()).get_properties())['CanCreateItems'];
    },
    get_canUploadFiles: function SP_CreatablesInfo$get_canUploadFiles() {
        this.checkUninitializedProperty('CanUploadFiles');
        return ((this.get_objectData()).get_properties())['CanUploadFiles'];
    },
    get_creatablesCollection: function SP_CreatablesInfo$get_creatablesCollection() {
        this.checkUninitializedProperty('CreatablesCollection');
        return ((this.get_objectData()).get_properties())['CreatablesCollection'];
    },
    initPropertiesFromJson: function SP_CreatablesInfo$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CanCreateFolders;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCreateFolders'] = $v_0;
            delete parentNode.CanCreateFolders;
        }
        $v_0 = parentNode.CanCreateItems;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCreateItems'] = $v_0;
            delete parentNode.CanCreateItems;
        }
        $v_0 = parentNode.CanUploadFiles;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanUploadFiles'] = $v_0;
            delete parentNode.CanUploadFiles;
        }
        $v_0 = parentNode.CreatablesCollection;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CreatablesCollection'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.CreatablesCollection;
        }
    }
};
SP.CreatablesInfoPropertyNames = function SP_CreatablesInfoPropertyNames() {
};
SP.DlpPolicyTip = function SP_DlpPolicyTip(context, objectPath) {
    SP.DlpPolicyTip.initializeBase(this, [context, objectPath]);
};
SP.DlpPolicyTip.prototype = {
    get_appliedActionsText: function SP_DlpPolicyTip$get_appliedActionsText() {
        this.checkUninitializedProperty('AppliedActionsText');
        return ((this.get_objectData()).get_properties())['AppliedActionsText'];
    },
    get_complianceUrl: function SP_DlpPolicyTip$get_complianceUrl() {
        this.checkUninitializedProperty('ComplianceUrl');
        return ((this.get_objectData()).get_properties())['ComplianceUrl'];
    },
    get_generalText: function SP_DlpPolicyTip$get_generalText() {
        this.checkUninitializedProperty('GeneralText');
        return ((this.get_objectData()).get_properties())['GeneralText'];
    },
    get_lastProcessedTime: function SP_DlpPolicyTip$get_lastProcessedTime() {
        this.checkUninitializedProperty('LastProcessedTime');
        return ((this.get_objectData()).get_properties())['LastProcessedTime'];
    },
    get_matchedConditionDescriptions: function SP_DlpPolicyTip$get_matchedConditionDescriptions() {
        this.checkUninitializedProperty('MatchedConditionDescriptions');
        return ((this.get_objectData()).get_properties())['MatchedConditionDescriptions'];
    },
    get_overrideOptions: function SP_DlpPolicyTip$get_overrideOptions() {
        this.checkUninitializedProperty('OverrideOptions');
        return ((this.get_objectData()).get_properties())['OverrideOptions'];
    },
    initPropertiesFromJson: function SP_DlpPolicyTip$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AppliedActionsText;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AppliedActionsText'] = $v_0;
            delete parentNode.AppliedActionsText;
        }
        $v_0 = parentNode.ComplianceUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ComplianceUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ComplianceUrl;
        }
        $v_0 = parentNode.GeneralText;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GeneralText'] = $v_0;
            delete parentNode.GeneralText;
        }
        $v_0 = parentNode.LastProcessedTime;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LastProcessedTime'] = $v_0;
            delete parentNode.LastProcessedTime;
        }
        $v_0 = parentNode.MatchedConditionDescriptions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MatchedConditionDescriptions'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.MatchedConditionDescriptions;
        }
        $v_0 = parentNode.OverrideOptions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['OverrideOptions'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.OverrideOptions;
        }
    }
};
SP.DlpPolicyTipPropertyNames = function SP_DlpPolicyTipPropertyNames() {
};
SP.DocumentLibraryInformation = function SP_DocumentLibraryInformation() {
    SP.DocumentLibraryInformation.initializeBase(this);
};
SP.DocumentLibraryInformation.prototype = {
    $6V_1: null,
    $6W_1: null,
    $N_1: null,
    $0_1: null,
    get_modified: function SP_DocumentLibraryInformation$get_modified() {
        return this.$6V_1;
    },
    get_modifiedFriendlyDisplay: function SP_DocumentLibraryInformation$get_modifiedFriendlyDisplay() {
        return this.$6W_1;
    },
    get_serverRelativeUrl: function SP_DocumentLibraryInformation$get_serverRelativeUrl() {
        return this.$N_1;
    },
    get_title: function SP_DocumentLibraryInformation$get_title() {
        return this.$0_1;
    },
    get_typeId: function SP_DocumentLibraryInformation$get_typeId() {
        return '{fb3ddd20-725d-4c42-8c72-34c5efc2a0b4}';
    },
    writeToXml: function SP_DocumentLibraryInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Modified', 'ModifiedFriendlyDisplay', 'ServerRelativeUrl', 'Title'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_DocumentLibraryInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Modified;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6V_1 = $v_0;
            delete parentNode.Modified;
        }
        $v_0 = parentNode.ModifiedFriendlyDisplay;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6W_1 = $v_0;
            delete parentNode.ModifiedFriendlyDisplay;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$N_1 = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
    }
};
SP.EffectiveInformationRightsManagementSettings = function SP_EffectiveInformationRightsManagementSettings(context, objectPath) {
    SP.EffectiveInformationRightsManagementSettings.initializeBase(this, [context, objectPath]);
};
SP.EffectiveInformationRightsManagementSettings.prototype = {
    get_allowPrint: function SP_EffectiveInformationRightsManagementSettings$get_allowPrint() {
        this.checkUninitializedProperty('AllowPrint');
        return ((this.get_objectData()).get_properties())['AllowPrint'];
    },
    get_allowScript: function SP_EffectiveInformationRightsManagementSettings$get_allowScript() {
        this.checkUninitializedProperty('AllowScript');
        return ((this.get_objectData()).get_properties())['AllowScript'];
    },
    get_allowWriteCopy: function SP_EffectiveInformationRightsManagementSettings$get_allowWriteCopy() {
        this.checkUninitializedProperty('AllowWriteCopy');
        return ((this.get_objectData()).get_properties())['AllowWriteCopy'];
    },
    get_disableDocumentBrowserView: function SP_EffectiveInformationRightsManagementSettings$get_disableDocumentBrowserView() {
        this.checkUninitializedProperty('DisableDocumentBrowserView');
        return ((this.get_objectData()).get_properties())['DisableDocumentBrowserView'];
    },
    get_documentAccessExpireDays: function SP_EffectiveInformationRightsManagementSettings$get_documentAccessExpireDays() {
        this.checkUninitializedProperty('DocumentAccessExpireDays');
        return ((this.get_objectData()).get_properties())['DocumentAccessExpireDays'];
    },
    get_documentLibraryProtectionExpireDate: function SP_EffectiveInformationRightsManagementSettings$get_documentLibraryProtectionExpireDate() {
        this.checkUninitializedProperty('DocumentLibraryProtectionExpireDate');
        return ((this.get_objectData()).get_properties())['DocumentLibraryProtectionExpireDate'];
    },
    get_enableDocumentAccessExpire: function SP_EffectiveInformationRightsManagementSettings$get_enableDocumentAccessExpire() {
        this.checkUninitializedProperty('EnableDocumentAccessExpire');
        return ((this.get_objectData()).get_properties())['EnableDocumentAccessExpire'];
    },
    get_enableDocumentBrowserPublishingView: function SP_EffectiveInformationRightsManagementSettings$get_enableDocumentBrowserPublishingView() {
        this.checkUninitializedProperty('EnableDocumentBrowserPublishingView');
        return ((this.get_objectData()).get_properties())['EnableDocumentBrowserPublishingView'];
    },
    get_enableGroupProtection: function SP_EffectiveInformationRightsManagementSettings$get_enableGroupProtection() {
        this.checkUninitializedProperty('EnableGroupProtection');
        return ((this.get_objectData()).get_properties())['EnableGroupProtection'];
    },
    get_enableLicenseCacheExpire: function SP_EffectiveInformationRightsManagementSettings$get_enableLicenseCacheExpire() {
        this.checkUninitializedProperty('EnableLicenseCacheExpire');
        return ((this.get_objectData()).get_properties())['EnableLicenseCacheExpire'];
    },
    get_groupName: function SP_EffectiveInformationRightsManagementSettings$get_groupName() {
        this.checkUninitializedProperty('GroupName');
        return ((this.get_objectData()).get_properties())['GroupName'];
    },
    get_irmEnabled: function SP_EffectiveInformationRightsManagementSettings$get_irmEnabled() {
        this.checkUninitializedProperty('IrmEnabled');
        return ((this.get_objectData()).get_properties())['IrmEnabled'];
    },
    get_licenseCacheExpireDays: function SP_EffectiveInformationRightsManagementSettings$get_licenseCacheExpireDays() {
        this.checkUninitializedProperty('LicenseCacheExpireDays');
        return ((this.get_objectData()).get_properties())['LicenseCacheExpireDays'];
    },
    get_policyDescription: function SP_EffectiveInformationRightsManagementSettings$get_policyDescription() {
        this.checkUninitializedProperty('PolicyDescription');
        return ((this.get_objectData()).get_properties())['PolicyDescription'];
    },
    get_policyTitle: function SP_EffectiveInformationRightsManagementSettings$get_policyTitle() {
        this.checkUninitializedProperty('PolicyTitle');
        return ((this.get_objectData()).get_properties())['PolicyTitle'];
    },
    get_settingSource: function SP_EffectiveInformationRightsManagementSettings$get_settingSource() {
        this.checkUninitializedProperty('SettingSource');
        return ((this.get_objectData()).get_properties())['SettingSource'];
    },
    get_templateId: function SP_EffectiveInformationRightsManagementSettings$get_templateId() {
        this.checkUninitializedProperty('TemplateId');
        return ((this.get_objectData()).get_properties())['TemplateId'];
    },
    initPropertiesFromJson: function SP_EffectiveInformationRightsManagementSettings$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowPrint;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowPrint'] = $v_0;
            delete parentNode.AllowPrint;
        }
        $v_0 = parentNode.AllowScript;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowScript'] = $v_0;
            delete parentNode.AllowScript;
        }
        $v_0 = parentNode.AllowWriteCopy;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowWriteCopy'] = $v_0;
            delete parentNode.AllowWriteCopy;
        }
        $v_0 = parentNode.DisableDocumentBrowserView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisableDocumentBrowserView'] = $v_0;
            delete parentNode.DisableDocumentBrowserView;
        }
        $v_0 = parentNode.DocumentAccessExpireDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentAccessExpireDays'] = $v_0;
            delete parentNode.DocumentAccessExpireDays;
        }
        $v_0 = parentNode.DocumentLibraryProtectionExpireDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentLibraryProtectionExpireDate'] = $v_0;
            delete parentNode.DocumentLibraryProtectionExpireDate;
        }
        $v_0 = parentNode.EnableDocumentAccessExpire;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableDocumentAccessExpire'] = $v_0;
            delete parentNode.EnableDocumentAccessExpire;
        }
        $v_0 = parentNode.EnableDocumentBrowserPublishingView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableDocumentBrowserPublishingView'] = $v_0;
            delete parentNode.EnableDocumentBrowserPublishingView;
        }
        $v_0 = parentNode.EnableGroupProtection;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableGroupProtection'] = $v_0;
            delete parentNode.EnableGroupProtection;
        }
        $v_0 = parentNode.EnableLicenseCacheExpire;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableLicenseCacheExpire'] = $v_0;
            delete parentNode.EnableLicenseCacheExpire;
        }
        $v_0 = parentNode.GroupName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GroupName'] = $v_0;
            delete parentNode.GroupName;
        }
        $v_0 = parentNode.IrmEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IrmEnabled'] = $v_0;
            delete parentNode.IrmEnabled;
        }
        $v_0 = parentNode.LicenseCacheExpireDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LicenseCacheExpireDays'] = $v_0;
            delete parentNode.LicenseCacheExpireDays;
        }
        $v_0 = parentNode.PolicyDescription;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PolicyDescription'] = $v_0;
            delete parentNode.PolicyDescription;
        }
        $v_0 = parentNode.PolicyTitle;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PolicyTitle'] = $v_0;
            delete parentNode.PolicyTitle;
        }
        $v_0 = parentNode.SettingSource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SettingSource'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SettingSource;
        }
        $v_0 = parentNode.TemplateId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TemplateId'] = $v_0;
            delete parentNode.TemplateId;
        }
    }
};
SP.EffectiveInformationRightsManagementSettingsPropertyNames = function SP_EffectiveInformationRightsManagementSettingsPropertyNames() {
};
SP.EncryptionOption = function SP_EncryptionOption() {
    SP.EncryptionOption.initializeBase(this);
};
SP.EncryptionOption.prototype = {
    $24_1: null,
    get_aeS256CBCKey: function SP_EncryptionOption$get_aeS256CBCKey() {
        return this.$24_1;
    },
    set_aeS256CBCKey: function SP_EncryptionOption$set_aeS256CBCKey(value) {
        this.$24_1 = value;
        return value;
    },
    get_typeId: function SP_EncryptionOption$get_typeId() {
        return '{85614ad4-7a40-49e0-b272-6d1807dbfcc6}';
    },
    writeToXml: function SP_EncryptionOption$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['AES256CBCKey'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_EncryptionOption$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AES256CBCKey;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$24_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.AES256CBCKey;
        }
    }
};
SP.EventReceiverDefinition = function SP_EventReceiverDefinition(context, objectPath) {
    SP.EventReceiverDefinition.initializeBase(this, [context, objectPath]);
};
SP.EventReceiverDefinition.prototype = {
    get_receiverAssembly: function SP_EventReceiverDefinition$get_receiverAssembly() {
        this.checkUninitializedProperty('ReceiverAssembly');
        return ((this.get_objectData()).get_properties())['ReceiverAssembly'];
    },
    get_receiverClass: function SP_EventReceiverDefinition$get_receiverClass() {
        this.checkUninitializedProperty('ReceiverClass');
        return ((this.get_objectData()).get_properties())['ReceiverClass'];
    },
    get_receiverId: function SP_EventReceiverDefinition$get_receiverId() {
        this.checkUninitializedProperty('ReceiverId');
        return ((this.get_objectData()).get_properties())['ReceiverId'];
    },
    get_receiverName: function SP_EventReceiverDefinition$get_receiverName() {
        this.checkUninitializedProperty('ReceiverName');
        return ((this.get_objectData()).get_properties())['ReceiverName'];
    },
    get_sequenceNumber: function SP_EventReceiverDefinition$get_sequenceNumber() {
        this.checkUninitializedProperty('SequenceNumber');
        return ((this.get_objectData()).get_properties())['SequenceNumber'];
    },
    get_synchronization: function SP_EventReceiverDefinition$get_synchronization() {
        this.checkUninitializedProperty('Synchronization');
        return ((this.get_objectData()).get_properties())['Synchronization'];
    },
    get_eventType: function SP_EventReceiverDefinition$get_eventType() {
        this.checkUninitializedProperty('EventType');
        return ((this.get_objectData()).get_properties())['EventType'];
    },
    get_receiverUrl: function SP_EventReceiverDefinition$get_receiverUrl() {
        this.checkUninitializedProperty('ReceiverUrl');
        return ((this.get_objectData()).get_properties())['ReceiverUrl'];
    },
    initPropertiesFromJson: function SP_EventReceiverDefinition$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ReceiverAssembly;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReceiverAssembly'] = $v_0;
            delete parentNode.ReceiverAssembly;
        }
        $v_0 = parentNode.ReceiverClass;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReceiverClass'] = $v_0;
            delete parentNode.ReceiverClass;
        }
        $v_0 = parentNode.ReceiverId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReceiverId'] = $v_0;
            delete parentNode.ReceiverId;
        }
        $v_0 = parentNode.ReceiverName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReceiverName'] = $v_0;
            delete parentNode.ReceiverName;
        }
        $v_0 = parentNode.SequenceNumber;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SequenceNumber'] = $v_0;
            delete parentNode.SequenceNumber;
        }
        $v_0 = parentNode.Synchronization;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Synchronization'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Synchronization;
        }
        $v_0 = parentNode.EventType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EventType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.EventType;
        }
        $v_0 = parentNode.ReceiverUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReceiverUrl'] = $v_0;
            delete parentNode.ReceiverUrl;
        }
    },
    update: function SP_EventReceiverDefinition$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    },
    deleteObject: function SP_EventReceiverDefinition$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.EventReceiverDefinitionPropertyNames = function SP_EventReceiverDefinitionPropertyNames() {
};
SP.EventReceiverDefinitionCollection = function SP_EventReceiverDefinitionCollection(context, objectPath) {
    SP.EventReceiverDefinitionCollection.initializeBase(this, [context, objectPath]);
};
SP.EventReceiverDefinitionCollection.prototype = {
    itemAt: function SP_EventReceiverDefinitionCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_EventReceiverDefinitionCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_EventReceiverDefinitionCollection$get_childItemType() {
        return SP.EventReceiverDefinition;
    },
    getById: function SP_EventReceiverDefinitionCollection$getById(eventReceiverId) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[eventReceiverId.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.EventReceiverDefinition($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [eventReceiverId]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[eventReceiverId.toString()] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    add: function SP_EventReceiverDefinitionCollection$add(eventReceiverCreationInformation) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.EventReceiverDefinition($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [eventReceiverCreationInformation]));
        return $v_1;
    }
};
SP.EventReceiverDefinitionCreationInformation = function SP_EventReceiverDefinitionCreationInformation() {
    SP.EventReceiverDefinitionCreationInformation.initializeBase(this);
};
SP.EventReceiverDefinitionCreationInformation.prototype = {
    $4c_1: null,
    $4d_1: null,
    $4e_1: null,
    $4k_1: 0,
    $5D_1: 0,
    $2a_1: 0,
    $4f_1: null,
    get_receiverAssembly: function SP_EventReceiverDefinitionCreationInformation$get_receiverAssembly() {
        return this.$4c_1;
    },
    set_receiverAssembly: function SP_EventReceiverDefinitionCreationInformation$set_receiverAssembly(value) {
        this.$4c_1 = value;
        return value;
    },
    get_receiverClass: function SP_EventReceiverDefinitionCreationInformation$get_receiverClass() {
        return this.$4d_1;
    },
    set_receiverClass: function SP_EventReceiverDefinitionCreationInformation$set_receiverClass(value) {
        this.$4d_1 = value;
        return value;
    },
    get_receiverName: function SP_EventReceiverDefinitionCreationInformation$get_receiverName() {
        return this.$4e_1;
    },
    set_receiverName: function SP_EventReceiverDefinitionCreationInformation$set_receiverName(value) {
        this.$4e_1 = value;
        return value;
    },
    get_sequenceNumber: function SP_EventReceiverDefinitionCreationInformation$get_sequenceNumber() {
        return this.$4k_1;
    },
    set_sequenceNumber: function SP_EventReceiverDefinitionCreationInformation$set_sequenceNumber(value) {
        this.$4k_1 = value;
        return value;
    },
    get_synchronization: function SP_EventReceiverDefinitionCreationInformation$get_synchronization() {
        return this.$5D_1;
    },
    set_synchronization: function SP_EventReceiverDefinitionCreationInformation$set_synchronization(value) {
        this.$5D_1 = value;
        return value;
    },
    get_eventType: function SP_EventReceiverDefinitionCreationInformation$get_eventType() {
        return this.$2a_1;
    },
    set_eventType: function SP_EventReceiverDefinitionCreationInformation$set_eventType(value) {
        this.$2a_1 = value;
        return value;
    },
    get_receiverUrl: function SP_EventReceiverDefinitionCreationInformation$get_receiverUrl() {
        return this.$4f_1;
    },
    set_receiverUrl: function SP_EventReceiverDefinitionCreationInformation$set_receiverUrl(value) {
        this.$4f_1 = value;
        return value;
    },
    get_typeId: function SP_EventReceiverDefinitionCreationInformation$get_typeId() {
        return '{2c15382f-b6e4-41f6-8616-4cbe0080a5de}';
    },
    writeToXml: function SP_EventReceiverDefinitionCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['ReceiverAssembly', 'ReceiverClass', 'ReceiverName', 'SequenceNumber', 'Synchronization', 'EventType', 'ReceiverUrl'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_EventReceiverDefinitionCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ReceiverAssembly;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4c_1 = $v_0;
            delete parentNode.ReceiverAssembly;
        }
        $v_0 = parentNode.ReceiverClass;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4d_1 = $v_0;
            delete parentNode.ReceiverClass;
        }
        $v_0 = parentNode.ReceiverName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4e_1 = $v_0;
            delete parentNode.ReceiverName;
        }
        $v_0 = parentNode.SequenceNumber;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4k_1 = $v_0;
            delete parentNode.SequenceNumber;
        }
        $v_0 = parentNode.Synchronization;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5D_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Synchronization;
        }
        $v_0 = parentNode.EventType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2a_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.EventType;
        }
        $v_0 = parentNode.ReceiverUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4f_1 = $v_0;
            delete parentNode.ReceiverUrl;
        }
    }
};
SP.Feature = function SP_Feature(context, objectPath) {
    SP.Feature.initializeBase(this, [context, objectPath]);
};
SP.Feature.prototype = {
    get_definitionId: function SP_Feature$get_definitionId() {
        this.checkUninitializedProperty('DefinitionId');
        return ((this.get_objectData()).get_properties())['DefinitionId'];
    },
    get_displayName: function SP_Feature$get_displayName() {
        this.checkUninitializedProperty('DisplayName');
        return ((this.get_objectData()).get_properties())['DisplayName'];
    },
    initPropertiesFromJson: function SP_Feature$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DefinitionId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefinitionId'] = $v_0;
            delete parentNode.DefinitionId;
        }
        $v_0 = parentNode.DisplayName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisplayName'] = $v_0;
            delete parentNode.DisplayName;
        }
    }
};
SP.FeaturePropertyNames = function SP_FeaturePropertyNames() {
};
SP.FeatureCollection = function SP_FeatureCollection(context, objectPath) {
    SP.FeatureCollection.initializeBase(this, [context, objectPath]);
};
SP.FeatureCollection.prototype = {
    itemAt: function SP_FeatureCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_FeatureCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_FeatureCollection$get_childItemType() {
        return SP.Feature;
    },
    getById: function SP_FeatureCollection$getById(featureId) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[featureId.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Feature($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [featureId]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[featureId.toString()] = $v_1;
        }
        return $v_1;
    },
    add: function SP_FeatureCollection$add(featureId, force, featdefScope) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Feature($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [featureId, force, featdefScope]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    },
    remove: function SP_FeatureCollection$remove(featureId, force) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Remove', [featureId, force]);

        $v_0.addQuery($v_1);
    }
};
SP.Field = function SP_Field(context, objectPath) {
    SP.Field.initializeBase(this, [context, objectPath]);
};
SP.Field.prototype = {
    get_autoIndexed: function SP_Field$get_autoIndexed() {
        this.checkUninitializedProperty('AutoIndexed');
        return ((this.get_objectData()).get_properties())['AutoIndexed'];
    },
    get_canBeDeleted: function SP_Field$get_canBeDeleted() {
        this.checkUninitializedProperty('CanBeDeleted');
        return ((this.get_objectData()).get_properties())['CanBeDeleted'];
    },
    get_defaultValue: function SP_Field$get_defaultValue() {
        this.checkUninitializedProperty('DefaultValue');
        return ((this.get_objectData()).get_properties())['DefaultValue'];
    },
    set_defaultValue: function SP_Field$set_defaultValue(value) {
        ((this.get_objectData()).get_properties())['DefaultValue'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DefaultValue', value));
        }
        return value;
    },
    get_description: function SP_Field$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    set_description: function SP_Field$set_description(value) {
        ((this.get_objectData()).get_properties())['Description'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Description', value));
        }
        return value;
    },
    get_descriptionResource: function SP_Field$get_descriptionResource() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['DescriptionResource'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserResource(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'DescriptionResource'));
            ((this.get_objectData()).get_clientObjectProperties())['DescriptionResource'] = $v_0;
        }
        return $v_0;
    },
    get_direction: function SP_Field$get_direction() {
        this.checkUninitializedProperty('Direction');
        return ((this.get_objectData()).get_properties())['Direction'];
    },
    set_direction: function SP_Field$set_direction(value) {
        ((this.get_objectData()).get_properties())['Direction'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Direction', value));
        }
        return value;
    },
    get_enforceUniqueValues: function SP_Field$get_enforceUniqueValues() {
        this.checkUninitializedProperty('EnforceUniqueValues');
        return ((this.get_objectData()).get_properties())['EnforceUniqueValues'];
    },
    set_enforceUniqueValues: function SP_Field$set_enforceUniqueValues(value) {
        ((this.get_objectData()).get_properties())['EnforceUniqueValues'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnforceUniqueValues', value));
        }
        return value;
    },
    get_entityPropertyName: function SP_Field$get_entityPropertyName() {
        this.checkUninitializedProperty('EntityPropertyName');
        return ((this.get_objectData()).get_properties())['EntityPropertyName'];
    },
    get_filterable: function SP_Field$get_filterable() {
        this.checkUninitializedProperty('Filterable');
        return ((this.get_objectData()).get_properties())['Filterable'];
    },
    get_fromBaseType: function SP_Field$get_fromBaseType() {
        this.checkUninitializedProperty('FromBaseType');
        return ((this.get_objectData()).get_properties())['FromBaseType'];
    },
    get_group: function SP_Field$get_group() {
        this.checkUninitializedProperty('Group');
        return ((this.get_objectData()).get_properties())['Group'];
    },
    set_group: function SP_Field$set_group(value) {
        ((this.get_objectData()).get_properties())['Group'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Group', value));
        }
        return value;
    },
    get_hidden: function SP_Field$get_hidden() {
        this.checkUninitializedProperty('Hidden');
        return ((this.get_objectData()).get_properties())['Hidden'];
    },
    set_hidden: function SP_Field$set_hidden(value) {
        ((this.get_objectData()).get_properties())['Hidden'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Hidden', value));
        }
        return value;
    },
    get_id: function SP_Field$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_indexed: function SP_Field$get_indexed() {
        this.checkUninitializedProperty('Indexed');
        return ((this.get_objectData()).get_properties())['Indexed'];
    },
    set_indexed: function SP_Field$set_indexed(value) {
        ((this.get_objectData()).get_properties())['Indexed'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Indexed', value));
        }
        return value;
    },
    get_internalName: function SP_Field$get_internalName() {
        this.checkUninitializedProperty('InternalName');
        return ((this.get_objectData()).get_properties())['InternalName'];
    },
    get_jsLink: function SP_Field$get_jsLink() {
        this.checkUninitializedProperty('JSLink');
        return ((this.get_objectData()).get_properties())['JSLink'];
    },
    set_jsLink: function SP_Field$set_jsLink(value) {
        ((this.get_objectData()).get_properties())['JSLink'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'JSLink', value));
        }
        return value;
    },
    get_readOnlyField: function SP_Field$get_readOnlyField() {
        this.checkUninitializedProperty('ReadOnlyField');
        return ((this.get_objectData()).get_properties())['ReadOnlyField'];
    },
    set_readOnlyField: function SP_Field$set_readOnlyField(value) {
        ((this.get_objectData()).get_properties())['ReadOnlyField'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ReadOnlyField', value));
        }
        return value;
    },
    get_required: function SP_Field$get_required() {
        this.checkUninitializedProperty('Required');
        return ((this.get_objectData()).get_properties())['Required'];
    },
    set_required: function SP_Field$set_required(value) {
        ((this.get_objectData()).get_properties())['Required'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Required', value));
        }
        return value;
    },
    get_schemaXml: function SP_Field$get_schemaXml() {
        this.checkUninitializedProperty('SchemaXml');
        return ((this.get_objectData()).get_properties())['SchemaXml'];
    },
    set_schemaXml: function SP_Field$set_schemaXml(value) {
        ((this.get_objectData()).get_properties())['SchemaXml'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SchemaXml', value));
        }
        return value;
    },
    get_schemaXmlWithResourceTokens: function SP_Field$get_schemaXmlWithResourceTokens() {
        this.checkUninitializedProperty('SchemaXmlWithResourceTokens');
        return ((this.get_objectData()).get_properties())['SchemaXmlWithResourceTokens'];
    },
    get_scope: function SP_Field$get_scope() {
        this.checkUninitializedProperty('Scope');
        return ((this.get_objectData()).get_properties())['Scope'];
    },
    get_sealed: function SP_Field$get_sealed() {
        this.checkUninitializedProperty('Sealed');
        return ((this.get_objectData()).get_properties())['Sealed'];
    },
    get_sortable: function SP_Field$get_sortable() {
        this.checkUninitializedProperty('Sortable');
        return ((this.get_objectData()).get_properties())['Sortable'];
    },
    get_staticName: function SP_Field$get_staticName() {
        this.checkUninitializedProperty('StaticName');
        return ((this.get_objectData()).get_properties())['StaticName'];
    },
    set_staticName: function SP_Field$set_staticName(value) {
        ((this.get_objectData()).get_properties())['StaticName'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'StaticName', value));
        }
        return value;
    },
    get_title: function SP_Field$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    set_title: function SP_Field$set_title(value) {
        ((this.get_objectData()).get_properties())['Title'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Title', value));
        }
        return value;
    },
    get_titleResource: function SP_Field$get_titleResource() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['TitleResource'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserResource(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'TitleResource'));
            ((this.get_objectData()).get_clientObjectProperties())['TitleResource'] = $v_0;
        }
        return $v_0;
    },
    get_fieldTypeKind: function SP_Field$get_fieldTypeKind() {
        this.checkUninitializedProperty('FieldTypeKind');
        return ((this.get_objectData()).get_properties())['FieldTypeKind'];
    },
    set_fieldTypeKind: function SP_Field$set_fieldTypeKind(value) {
        ((this.get_objectData()).get_properties())['FieldTypeKind'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'FieldTypeKind', value));
        }
        return value;
    },
    get_typeAsString: function SP_Field$get_typeAsString() {
        this.checkUninitializedProperty('TypeAsString');
        return ((this.get_objectData()).get_properties())['TypeAsString'];
    },
    set_typeAsString: function SP_Field$set_typeAsString(value) {
        ((this.get_objectData()).get_properties())['TypeAsString'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'TypeAsString', value));
        }
        return value;
    },
    get_typeDisplayName: function SP_Field$get_typeDisplayName() {
        this.checkUninitializedProperty('TypeDisplayName');
        return ((this.get_objectData()).get_properties())['TypeDisplayName'];
    },
    get_typeShortDescription: function SP_Field$get_typeShortDescription() {
        this.checkUninitializedProperty('TypeShortDescription');
        return ((this.get_objectData()).get_properties())['TypeShortDescription'];
    },
    get_validationFormula: function SP_Field$get_validationFormula() {
        this.checkUninitializedProperty('ValidationFormula');
        return ((this.get_objectData()).get_properties())['ValidationFormula'];
    },
    set_validationFormula: function SP_Field$set_validationFormula(value) {
        ((this.get_objectData()).get_properties())['ValidationFormula'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ValidationFormula', value));
        }
        return value;
    },
    get_validationMessage: function SP_Field$get_validationMessage() {
        this.checkUninitializedProperty('ValidationMessage');
        return ((this.get_objectData()).get_properties())['ValidationMessage'];
    },
    set_validationMessage: function SP_Field$set_validationMessage(value) {
        ((this.get_objectData()).get_properties())['ValidationMessage'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ValidationMessage', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_Field$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AutoIndexed;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AutoIndexed'] = $v_0;
            delete parentNode.AutoIndexed;
        }
        $v_0 = parentNode.CanBeDeleted;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanBeDeleted'] = $v_0;
            delete parentNode.CanBeDeleted;
        }
        $v_0 = parentNode.DefaultValue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefaultValue'] = $v_0;
            delete parentNode.DefaultValue;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.DescriptionResource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('DescriptionResource', this.get_descriptionResource(), $v_0);
            (this.get_descriptionResource()).fromJson($v_0);
            delete parentNode.DescriptionResource;
        }
        $v_0 = parentNode.Direction;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Direction'] = $v_0;
            delete parentNode.Direction;
        }
        $v_0 = parentNode.EnforceUniqueValues;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnforceUniqueValues'] = $v_0;
            delete parentNode.EnforceUniqueValues;
        }
        $v_0 = parentNode.EntityPropertyName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EntityPropertyName'] = $v_0;
            delete parentNode.EntityPropertyName;
        }
        $v_0 = parentNode.Filterable;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Filterable'] = $v_0;
            delete parentNode.Filterable;
        }
        $v_0 = parentNode.FromBaseType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FromBaseType'] = $v_0;
            delete parentNode.FromBaseType;
        }
        $v_0 = parentNode.Group;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Group'] = $v_0;
            delete parentNode.Group;
        }
        $v_0 = parentNode.Hidden;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Hidden'] = $v_0;
            delete parentNode.Hidden;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.Indexed;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Indexed'] = $v_0;
            delete parentNode.Indexed;
        }
        $v_0 = parentNode.InternalName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['InternalName'] = $v_0;
            delete parentNode.InternalName;
        }
        $v_0 = parentNode.JSLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['JSLink'] = $v_0;
            delete parentNode.JSLink;
        }
        $v_0 = parentNode.ReadOnlyField;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReadOnlyField'] = $v_0;
            delete parentNode.ReadOnlyField;
        }
        $v_0 = parentNode.Required;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Required'] = $v_0;
            delete parentNode.Required;
        }
        $v_0 = parentNode.SchemaXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SchemaXml'] = $v_0;
            delete parentNode.SchemaXml;
        }
        $v_0 = parentNode.SchemaXmlWithResourceTokens;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SchemaXmlWithResourceTokens'] = $v_0;
            delete parentNode.SchemaXmlWithResourceTokens;
        }
        $v_0 = parentNode.Scope;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Scope'] = $v_0;
            delete parentNode.Scope;
        }
        $v_0 = parentNode.Sealed;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Sealed'] = $v_0;
            delete parentNode.Sealed;
        }
        $v_0 = parentNode.Sortable;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Sortable'] = $v_0;
            delete parentNode.Sortable;
        }
        $v_0 = parentNode.StaticName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['StaticName'] = $v_0;
            delete parentNode.StaticName;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.TitleResource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('TitleResource', this.get_titleResource(), $v_0);
            (this.get_titleResource()).fromJson($v_0);
            delete parentNode.TitleResource;
        }
        $v_0 = parentNode.FieldTypeKind;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FieldTypeKind'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.FieldTypeKind;
        }
        $v_0 = parentNode.TypeAsString;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TypeAsString'] = $v_0;
            delete parentNode.TypeAsString;
        }
        $v_0 = parentNode.TypeDisplayName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TypeDisplayName'] = $v_0;
            delete parentNode.TypeDisplayName;
        }
        $v_0 = parentNode.TypeShortDescription;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TypeShortDescription'] = $v_0;
            delete parentNode.TypeShortDescription;
        }
        $v_0 = parentNode.ValidationFormula;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ValidationFormula'] = $v_0;
            delete parentNode.ValidationFormula;
        }
        $v_0 = parentNode.ValidationMessage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ValidationMessage'] = $v_0;
            delete parentNode.ValidationMessage;
        }
    },
    validateSetValue: function SP_Field$validateSetValue(item, value) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'ValidateSetValue', [item, value]);

        $v_0.addQuery($v_1);
    },
    updateAndPushChanges: function SP_Field$updateAndPushChanges(pushChangesToLists) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'UpdateAndPushChanges', [pushChangesToLists]);

        $v_0.addQuery($v_1);
    },
    update: function SP_Field$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    },
    deleteObject: function SP_Field$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    },
    setShowInDisplayForm: function SP_Field$setShowInDisplayForm(value) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'SetShowInDisplayForm', [value]);

        $v_0.addQuery($v_1);
    },
    setShowInEditForm: function SP_Field$setShowInEditForm(value) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'SetShowInEditForm', [value]);

        $v_0.addQuery($v_1);
    },
    setShowInNewForm: function SP_Field$setShowInNewForm(value) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'SetShowInNewForm', [value]);

        $v_0.addQuery($v_1);
    }
};
SP.FieldPropertyNames = function SP_FieldPropertyNames() {
};
SP.FieldObjectPropertyNames = function SP_FieldObjectPropertyNames() {
};
SP.FieldCalculated = function SP_FieldCalculated(context, objectPath) {
    SP.FieldCalculated.initializeBase(this, [context, objectPath]);
};
SP.FieldCalculated.prototype = {
    get_dateFormat: function SP_FieldCalculated$get_dateFormat() {
        this.checkUninitializedProperty('DateFormat');
        return ((this.get_objectData()).get_properties())['DateFormat'];
    },
    set_dateFormat: function SP_FieldCalculated$set_dateFormat(value) {
        ((this.get_objectData()).get_properties())['DateFormat'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DateFormat', value));
        }
        return value;
    },
    get_formula: function SP_FieldCalculated$get_formula() {
        this.checkUninitializedProperty('Formula');
        return ((this.get_objectData()).get_properties())['Formula'];
    },
    set_formula: function SP_FieldCalculated$set_formula(value) {
        ((this.get_objectData()).get_properties())['Formula'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Formula', value));
        }
        return value;
    },
    get_outputType: function SP_FieldCalculated$get_outputType() {
        this.checkUninitializedProperty('OutputType');
        return ((this.get_objectData()).get_properties())['OutputType'];
    },
    set_outputType: function SP_FieldCalculated$set_outputType(value) {
        ((this.get_objectData()).get_properties())['OutputType'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'OutputType', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldCalculated$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DateFormat;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DateFormat'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.DateFormat;
        }
        $v_0 = parentNode.Formula;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Formula'] = $v_0;
            delete parentNode.Formula;
        }
        $v_0 = parentNode.OutputType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['OutputType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.OutputType;
        }
    }
};
SP.FieldCalculatedPropertyNames = function SP_FieldCalculatedPropertyNames() {
};
SP.FieldCalculatedErrorValue = function SP_FieldCalculatedErrorValue() {
    SP.FieldCalculatedErrorValue.initializeBase(this);
};
SP.FieldCalculatedErrorValue.prototype = {
    $P_1: null,
    get_errorMessage: function SP_FieldCalculatedErrorValue$get_errorMessage() {
        return this.$P_1;
    },
    get_typeId: function SP_FieldCalculatedErrorValue$get_typeId() {
        return '{3387286b-36e3-4199-bdca-f20048ce8328}';
    },
    writeToXml: function SP_FieldCalculatedErrorValue$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['ErrorMessage'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FieldCalculatedErrorValue$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ErrorMessage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$P_1 = $v_0;
            delete parentNode.ErrorMessage;
        }
    }
};
SP.FieldChoice = function SP_FieldChoice(context, objectPath) {
    SP.FieldChoice.initializeBase(this, [context, objectPath]);
};
SP.FieldChoice.prototype = {
    get_editFormat: function SP_FieldChoice$get_editFormat() {
        this.checkUninitializedProperty('EditFormat');
        return ((this.get_objectData()).get_properties())['EditFormat'];
    },
    set_editFormat: function SP_FieldChoice$set_editFormat(value) {
        ((this.get_objectData()).get_properties())['EditFormat'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EditFormat', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldChoice$initPropertiesFromJson(parentNode) {
        SP.FieldMultiChoice.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.EditFormat;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EditFormat'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.EditFormat;
        }
    }
};
SP.FieldChoicePropertyNames = function SP_FieldChoicePropertyNames() {
};
SP.FieldCollection = function SP_FieldCollection(context, objectPath) {
    SP.FieldCollection.initializeBase(this, [context, objectPath]);
};
SP.FieldCollection.prototype = {
    itemAt: function SP_FieldCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_FieldCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_FieldCollection$get_childItemType() {
        return SP.Field;
    },
    get_schemaXml: function SP_FieldCollection$get_schemaXml() {
        this.checkUninitializedProperty('SchemaXml');
        return ((this.get_objectData()).get_properties())['SchemaXml'];
    },
    getByTitle: function SP_FieldCollection$getByTitle(title) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByTitle'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByTitle'] = $v_2;
        }
        $v_1 = $v_2[title];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Field($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByTitle', [title]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[title] = $v_1;
        }
        return $v_1;
    },
    getById: function SP_FieldCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Field($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id.toString()] = $v_1;
        }
        return $v_1;
    },
    initPropertiesFromJson: function SP_FieldCollection$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.SchemaXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SchemaXml'] = $v_0;
            delete parentNode.SchemaXml;
        }
    },
    add: function SP_FieldCollection$add(field) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Field($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [field]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    },
    addDependentLookup: function SP_FieldCollection$addDependentLookup(displayName, primaryLookupField, lookupField) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Field($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'AddDependentLookup', [displayName, primaryLookupField, lookupField]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    },
    addFieldAsXml: function SP_FieldCollection$addFieldAsXml(schemaXml, addToDefaultView, options) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Field($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'AddFieldAsXml', [schemaXml, addToDefaultView, options]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    },
    getByInternalNameOrTitle: function SP_FieldCollection$getByInternalNameOrTitle(strName) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByInternalNameOrTitle'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByInternalNameOrTitle'] = $v_2;
        }
        $v_1 = $v_2[strName];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Field($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByInternalNameOrTitle', [strName]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[strName] = $v_1;
        }
        return $v_1;
    }
};
SP.FieldCollectionPropertyNames = function SP_FieldCollectionPropertyNames() {
};
SP.FieldComputed = function SP_FieldComputed(context, objectPath) {
    SP.FieldComputed.initializeBase(this, [context, objectPath]);
};
SP.FieldComputed.prototype = {
    get_enableLookup: function SP_FieldComputed$get_enableLookup() {
        this.checkUninitializedProperty('EnableLookup');
        return ((this.get_objectData()).get_properties())['EnableLookup'];
    },
    set_enableLookup: function SP_FieldComputed$set_enableLookup(value) {
        ((this.get_objectData()).get_properties())['EnableLookup'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableLookup', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldComputed$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.EnableLookup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableLookup'] = $v_0;
            delete parentNode.EnableLookup;
        }
    }
};
SP.FieldComputedPropertyNames = function SP_FieldComputedPropertyNames() {
};
SP.FieldCurrency = function SP_FieldCurrency(context, objectPath) {
    SP.FieldCurrency.initializeBase(this, [context, objectPath]);
};
SP.FieldCurrency.prototype = {
    get_currencyLocaleId: function SP_FieldCurrency$get_currencyLocaleId() {
        this.checkUninitializedProperty('CurrencyLocaleId');
        return ((this.get_objectData()).get_properties())['CurrencyLocaleId'];
    },
    set_currencyLocaleId: function SP_FieldCurrency$set_currencyLocaleId(value) {
        ((this.get_objectData()).get_properties())['CurrencyLocaleId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'CurrencyLocaleId', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldCurrency$initPropertiesFromJson(parentNode) {
        SP.FieldNumber.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CurrencyLocaleId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CurrencyLocaleId'] = $v_0;
            delete parentNode.CurrencyLocaleId;
        }
    }
};
SP.FieldCurrencyPropertyNames = function SP_FieldCurrencyPropertyNames() {
};
SP.FieldDateTime = function SP_FieldDateTime(context, objectPath) {
    SP.FieldDateTime.initializeBase(this, [context, objectPath]);
};
SP.FieldDateTime.prototype = {
    get_dateTimeCalendarType: function SP_FieldDateTime$get_dateTimeCalendarType() {
        this.checkUninitializedProperty('DateTimeCalendarType');
        return ((this.get_objectData()).get_properties())['DateTimeCalendarType'];
    },
    set_dateTimeCalendarType: function SP_FieldDateTime$set_dateTimeCalendarType(value) {
        ((this.get_objectData()).get_properties())['DateTimeCalendarType'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DateTimeCalendarType', value));
        }
        return value;
    },
    get_displayFormat: function SP_FieldDateTime$get_displayFormat() {
        this.checkUninitializedProperty('DisplayFormat');
        return ((this.get_objectData()).get_properties())['DisplayFormat'];
    },
    set_displayFormat: function SP_FieldDateTime$set_displayFormat(value) {
        ((this.get_objectData()).get_properties())['DisplayFormat'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DisplayFormat', value));
        }
        return value;
    },
    get_friendlyDisplayFormat: function SP_FieldDateTime$get_friendlyDisplayFormat() {
        this.checkUninitializedProperty('FriendlyDisplayFormat');
        return ((this.get_objectData()).get_properties())['FriendlyDisplayFormat'];
    },
    set_friendlyDisplayFormat: function SP_FieldDateTime$set_friendlyDisplayFormat(value) {
        ((this.get_objectData()).get_properties())['FriendlyDisplayFormat'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'FriendlyDisplayFormat', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldDateTime$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DateTimeCalendarType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DateTimeCalendarType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.DateTimeCalendarType;
        }
        $v_0 = parentNode.DisplayFormat;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisplayFormat'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.DisplayFormat;
        }
        $v_0 = parentNode.FriendlyDisplayFormat;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FriendlyDisplayFormat'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.FriendlyDisplayFormat;
        }
    }
};
SP.FieldDateTimePropertyNames = function SP_FieldDateTimePropertyNames() {
};
SP.FieldGeolocation = function SP_FieldGeolocation(context, objectPath) {
    SP.FieldGeolocation.initializeBase(this, [context, objectPath]);
};
SP.FieldGeolocationValue = function SP_FieldGeolocationValue() {
    this.$4F_1 = -99999;
    this.$4J_1 = -99999;
    SP.FieldGeolocationValue.initializeBase(this);
};
SP.FieldGeolocationValue.prototype = {
    $29_1: 0,
    $4M_1: 0,
    get_altitude: function SP_FieldGeolocationValue$get_altitude() {
        return this.$29_1;
    },
    set_altitude: function SP_FieldGeolocationValue$set_altitude(value) {
        this.$29_1 = value;
        return value;
    },
    get_latitude: function SP_FieldGeolocationValue$get_latitude() {
        return this.$4F_1;
    },
    set_latitude: function SP_FieldGeolocationValue$set_latitude(value) {
        this.$4F_1 = value;
        return value;
    },
    get_longitude: function SP_FieldGeolocationValue$get_longitude() {
        return this.$4J_1;
    },
    set_longitude: function SP_FieldGeolocationValue$set_longitude(value) {
        this.$4J_1 = value;
        return value;
    },
    get_measure: function SP_FieldGeolocationValue$get_measure() {
        return this.$4M_1;
    },
    set_measure: function SP_FieldGeolocationValue$set_measure(value) {
        this.$4M_1 = value;
        return value;
    },
    get_typeId: function SP_FieldGeolocationValue$get_typeId() {
        return '{97650aff-7e7b-44be-ac6e-d559f7f897a2}';
    },
    writeToXml: function SP_FieldGeolocationValue$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Altitude', 'Latitude', 'Longitude', 'Measure'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FieldGeolocationValue$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Altitude;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$29_1 = $v_0;
            delete parentNode.Altitude;
        }
        $v_0 = parentNode.Latitude;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4F_1 = $v_0;
            delete parentNode.Latitude;
        }
        $v_0 = parentNode.Longitude;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4J_1 = $v_0;
            delete parentNode.Longitude;
        }
        $v_0 = parentNode.Measure;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4M_1 = $v_0;
            delete parentNode.Measure;
        }
    }
};
SP.FieldGuid = function SP_FieldGuid(context, objectPath) {
    SP.FieldGuid.initializeBase(this, [context, objectPath]);
};
SP.FieldLink = function SP_FieldLink(context, objectPath) {
    SP.FieldLink.initializeBase(this, [context, objectPath]);
};
SP.FieldLink.prototype = {
    $F_1: function SP_FieldLink$$F_1($p0) {
    },
    get_hidden: function SP_FieldLink$get_hidden() {
        this.checkUninitializedProperty('Hidden');
        return ((this.get_objectData()).get_properties())['Hidden'];
    },
    set_hidden: function SP_FieldLink$set_hidden(value) {
        ((this.get_objectData()).get_properties())['Hidden'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Hidden', value));
        }
        return value;
    },
    get_id: function SP_FieldLink$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_name: function SP_FieldLink$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    get_required: function SP_FieldLink$get_required() {
        this.checkUninitializedProperty('Required');
        return ((this.get_objectData()).get_properties())['Required'];
    },
    set_required: function SP_FieldLink$set_required(value) {
        ((this.get_objectData()).get_properties())['Required'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Required', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldLink$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Hidden;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Hidden'] = $v_0;
            delete parentNode.Hidden;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.Required;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Required'] = $v_0;
            delete parentNode.Required;
        }
    },
    deleteObject: function SP_FieldLink$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.FieldLinkPropertyNames = function SP_FieldLinkPropertyNames() {
};
SP.FieldLinkCollection = function SP_FieldLinkCollection(context, objectPath) {
    SP.FieldLinkCollection.initializeBase(this, [context, objectPath]);
};
SP.FieldLinkCollection.prototype = {
    itemAt: function SP_FieldLinkCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_FieldLinkCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_FieldLinkCollection$get_childItemType() {
        return SP.FieldLink;
    },
    getById: function SP_FieldLinkCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.FieldLink($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id.toString()] = $v_1;
        }
        return $v_1;
    },
    add: function SP_FieldLinkCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.FieldLink($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_1(parameters);
        return $v_1;
    },
    reorder: function SP_FieldLinkCollection$reorder(internalNames) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Reorder', [internalNames]);

        $v_0.addQuery($v_1);
    }
};
SP.FieldLinkCreationInformation = function SP_FieldLinkCreationInformation() {
    SP.FieldLinkCreationInformation.initializeBase(this);
};
SP.FieldLinkCreationInformation.prototype = {
    $8_1: null,
    get_field: function SP_FieldLinkCreationInformation$get_field() {
        return this.$8_1;
    },
    set_field: function SP_FieldLinkCreationInformation$set_field(value) {
        this.$8_1 = value;
        return value;
    },
    get_typeId: function SP_FieldLinkCreationInformation$get_typeId() {
        return '{63fb2c92-8f65-4bbb-a658-b6cd294403f4}';
    },
    writeToXml: function SP_FieldLinkCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Field'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FieldLinkCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Field;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            delete parentNode.Field;
        }
    }
};
SP.FieldLookup = function SP_FieldLookup(context, objectPath) {
    SP.FieldLookup.initializeBase(this, [context, objectPath]);
};
SP.FieldLookup.prototype = {
    get_allowMultipleValues: function SP_FieldLookup$get_allowMultipleValues() {
        this.checkUninitializedProperty('AllowMultipleValues');
        return ((this.get_objectData()).get_properties())['AllowMultipleValues'];
    },
    set_allowMultipleValues: function SP_FieldLookup$set_allowMultipleValues(value) {
        ((this.get_objectData()).get_properties())['AllowMultipleValues'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowMultipleValues', value));
        }
        return value;
    },
    get_isRelationship: function SP_FieldLookup$get_isRelationship() {
        this.checkUninitializedProperty('IsRelationship');
        return ((this.get_objectData()).get_properties())['IsRelationship'];
    },
    set_isRelationship: function SP_FieldLookup$set_isRelationship(value) {
        ((this.get_objectData()).get_properties())['IsRelationship'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IsRelationship', value));
        }
        return value;
    },
    get_lookupField: function SP_FieldLookup$get_lookupField() {
        this.checkUninitializedProperty('LookupField');
        return ((this.get_objectData()).get_properties())['LookupField'];
    },
    set_lookupField: function SP_FieldLookup$set_lookupField(value) {
        ((this.get_objectData()).get_properties())['LookupField'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'LookupField', value));
        }
        return value;
    },
    get_lookupList: function SP_FieldLookup$get_lookupList() {
        this.checkUninitializedProperty('LookupList');
        return ((this.get_objectData()).get_properties())['LookupList'];
    },
    set_lookupList: function SP_FieldLookup$set_lookupList(value) {
        ((this.get_objectData()).get_properties())['LookupList'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'LookupList', value));
        }
        return value;
    },
    get_lookupWebId: function SP_FieldLookup$get_lookupWebId() {
        this.checkUninitializedProperty('LookupWebId');
        return ((this.get_objectData()).get_properties())['LookupWebId'];
    },
    set_lookupWebId: function SP_FieldLookup$set_lookupWebId(value) {
        ((this.get_objectData()).get_properties())['LookupWebId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'LookupWebId', value));
        }
        return value;
    },
    get_primaryFieldId: function SP_FieldLookup$get_primaryFieldId() {
        this.checkUninitializedProperty('PrimaryFieldId');
        return ((this.get_objectData()).get_properties())['PrimaryFieldId'];
    },
    set_primaryFieldId: function SP_FieldLookup$set_primaryFieldId(value) {
        ((this.get_objectData()).get_properties())['PrimaryFieldId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'PrimaryFieldId', value));
        }
        return value;
    },
    get_relationshipDeleteBehavior: function SP_FieldLookup$get_relationshipDeleteBehavior() {
        this.checkUninitializedProperty('RelationshipDeleteBehavior');
        return ((this.get_objectData()).get_properties())['RelationshipDeleteBehavior'];
    },
    set_relationshipDeleteBehavior: function SP_FieldLookup$set_relationshipDeleteBehavior(value) {
        ((this.get_objectData()).get_properties())['RelationshipDeleteBehavior'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'RelationshipDeleteBehavior', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldLookup$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowMultipleValues;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowMultipleValues'] = $v_0;
            delete parentNode.AllowMultipleValues;
        }
        $v_0 = parentNode.IsRelationship;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsRelationship'] = $v_0;
            delete parentNode.IsRelationship;
        }
        $v_0 = parentNode.LookupField;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LookupField'] = $v_0;
            delete parentNode.LookupField;
        }
        $v_0 = parentNode.LookupList;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LookupList'] = $v_0;
            delete parentNode.LookupList;
        }
        $v_0 = parentNode.LookupWebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LookupWebId'] = $v_0;
            delete parentNode.LookupWebId;
        }
        $v_0 = parentNode.PrimaryFieldId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PrimaryFieldId'] = $v_0;
            delete parentNode.PrimaryFieldId;
        }
        $v_0 = parentNode.RelationshipDeleteBehavior;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RelationshipDeleteBehavior'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.RelationshipDeleteBehavior;
        }
    }
};
SP.FieldLookupPropertyNames = function SP_FieldLookupPropertyNames() {
};
SP.FieldLookupValue = function SP_FieldLookupValue() {
    SP.FieldLookupValue.initializeBase(this);
};
SP.FieldLookupValue.prototype = {
    $1S_1: 0,
    $4K_1: null,
    $85_1: function SP_FieldLookupValue$$85_1($p0) {
        this.$4K_1 = $p0;
    },
    get_lookupId: function SP_FieldLookupValue$get_lookupId() {
        return this.$1S_1;
    },
    set_lookupId: function SP_FieldLookupValue$set_lookupId(value) {
        this.$1S_1 = value;
        return value;
    },
    get_lookupValue: function SP_FieldLookupValue$get_lookupValue() {
        return this.$4K_1;
    },
    get_typeId: function SP_FieldLookupValue$get_typeId() {
        return '{f1d34cc0-9b50-4a78-be78-d5facfcccfb7}';
    },
    writeToXml: function SP_FieldLookupValue$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['LookupId', 'LookupValue'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FieldLookupValue$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.LookupId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1S_1 = $v_0;
            delete parentNode.LookupId;
        }
        $v_0 = parentNode.LookupValue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4K_1 = $v_0;
            delete parentNode.LookupValue;
        }
    }
};
SP.FieldMultiChoice = function SP_FieldMultiChoice(context, objectPath) {
    SP.FieldMultiChoice.initializeBase(this, [context, objectPath]);
};
SP.FieldMultiChoice.prototype = {
    get_fillInChoice: function SP_FieldMultiChoice$get_fillInChoice() {
        this.checkUninitializedProperty('FillInChoice');
        return ((this.get_objectData()).get_properties())['FillInChoice'];
    },
    set_fillInChoice: function SP_FieldMultiChoice$set_fillInChoice(value) {
        ((this.get_objectData()).get_properties())['FillInChoice'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'FillInChoice', value));
        }
        return value;
    },
    get_mappings: function SP_FieldMultiChoice$get_mappings() {
        this.checkUninitializedProperty('Mappings');
        return ((this.get_objectData()).get_properties())['Mappings'];
    },
    get_choices: function SP_FieldMultiChoice$get_choices() {
        this.checkUninitializedProperty('Choices');
        return ((this.get_objectData()).get_properties())['Choices'];
    },
    set_choices: function SP_FieldMultiChoice$set_choices(value) {
        ((this.get_objectData()).get_properties())['Choices'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Choices', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldMultiChoice$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FillInChoice;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FillInChoice'] = $v_0;
            delete parentNode.FillInChoice;
        }
        $v_0 = parentNode.Mappings;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Mappings'] = $v_0;
            delete parentNode.Mappings;
        }
        $v_0 = parentNode.Choices;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Choices'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Choices;
        }
    }
};
SP.FieldMultiChoicePropertyNames = function SP_FieldMultiChoicePropertyNames() {
};
SP.FieldMultiLineText = function SP_FieldMultiLineText(context, objectPath) {
    SP.FieldMultiLineText.initializeBase(this, [context, objectPath]);
};
SP.FieldMultiLineText.prototype = {
    get_allowHyperlink: function SP_FieldMultiLineText$get_allowHyperlink() {
        this.checkUninitializedProperty('AllowHyperlink');
        return ((this.get_objectData()).get_properties())['AllowHyperlink'];
    },
    set_allowHyperlink: function SP_FieldMultiLineText$set_allowHyperlink(value) {
        ((this.get_objectData()).get_properties())['AllowHyperlink'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowHyperlink', value));
        }
        return value;
    },
    get_appendOnly: function SP_FieldMultiLineText$get_appendOnly() {
        this.checkUninitializedProperty('AppendOnly');
        return ((this.get_objectData()).get_properties())['AppendOnly'];
    },
    set_appendOnly: function SP_FieldMultiLineText$set_appendOnly(value) {
        ((this.get_objectData()).get_properties())['AppendOnly'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AppendOnly', value));
        }
        return value;
    },
    get_numberOfLines: function SP_FieldMultiLineText$get_numberOfLines() {
        this.checkUninitializedProperty('NumberOfLines');
        return ((this.get_objectData()).get_properties())['NumberOfLines'];
    },
    set_numberOfLines: function SP_FieldMultiLineText$set_numberOfLines(value) {
        ((this.get_objectData()).get_properties())['NumberOfLines'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'NumberOfLines', value));
        }
        return value;
    },
    get_restrictedMode: function SP_FieldMultiLineText$get_restrictedMode() {
        this.checkUninitializedProperty('RestrictedMode');
        return ((this.get_objectData()).get_properties())['RestrictedMode'];
    },
    set_restrictedMode: function SP_FieldMultiLineText$set_restrictedMode(value) {
        ((this.get_objectData()).get_properties())['RestrictedMode'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'RestrictedMode', value));
        }
        return value;
    },
    get_richText: function SP_FieldMultiLineText$get_richText() {
        this.checkUninitializedProperty('RichText');
        return ((this.get_objectData()).get_properties())['RichText'];
    },
    set_richText: function SP_FieldMultiLineText$set_richText(value) {
        ((this.get_objectData()).get_properties())['RichText'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'RichText', value));
        }
        return value;
    },
    get_wikiLinking: function SP_FieldMultiLineText$get_wikiLinking() {
        this.checkUninitializedProperty('WikiLinking');
        return ((this.get_objectData()).get_properties())['WikiLinking'];
    },
    initPropertiesFromJson: function SP_FieldMultiLineText$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowHyperlink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowHyperlink'] = $v_0;
            delete parentNode.AllowHyperlink;
        }
        $v_0 = parentNode.AppendOnly;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AppendOnly'] = $v_0;
            delete parentNode.AppendOnly;
        }
        $v_0 = parentNode.NumberOfLines;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['NumberOfLines'] = $v_0;
            delete parentNode.NumberOfLines;
        }
        $v_0 = parentNode.RestrictedMode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RestrictedMode'] = $v_0;
            delete parentNode.RestrictedMode;
        }
        $v_0 = parentNode.RichText;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RichText'] = $v_0;
            delete parentNode.RichText;
        }
        $v_0 = parentNode.WikiLinking;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WikiLinking'] = $v_0;
            delete parentNode.WikiLinking;
        }
    }
};
SP.FieldMultiLineTextPropertyNames = function SP_FieldMultiLineTextPropertyNames() {
};
SP.FieldNumber = function SP_FieldNumber(context, objectPath) {
    SP.FieldNumber.initializeBase(this, [context, objectPath]);
};
SP.FieldNumber.prototype = {
    get_maximumValue: function SP_FieldNumber$get_maximumValue() {
        this.checkUninitializedProperty('MaximumValue');
        return ((this.get_objectData()).get_properties())['MaximumValue'];
    },
    set_maximumValue: function SP_FieldNumber$set_maximumValue(value) {
        ((this.get_objectData()).get_properties())['MaximumValue'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MaximumValue', value));
        }
        return value;
    },
    get_minimumValue: function SP_FieldNumber$get_minimumValue() {
        this.checkUninitializedProperty('MinimumValue');
        return ((this.get_objectData()).get_properties())['MinimumValue'];
    },
    set_minimumValue: function SP_FieldNumber$set_minimumValue(value) {
        ((this.get_objectData()).get_properties())['MinimumValue'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MinimumValue', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldNumber$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.MaximumValue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MaximumValue'] = $v_0;
            delete parentNode.MaximumValue;
        }
        $v_0 = parentNode.MinimumValue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MinimumValue'] = $v_0;
            delete parentNode.MinimumValue;
        }
    }
};
SP.FieldNumberPropertyNames = function SP_FieldNumberPropertyNames() {
};
SP.FieldRatingScale = function SP_FieldRatingScale(context, objectPath) {
    SP.FieldRatingScale.initializeBase(this, [context, objectPath]);
};
SP.FieldRatingScale.prototype = {
    get_gridEndNumber: function SP_FieldRatingScale$get_gridEndNumber() {
        this.checkUninitializedProperty('GridEndNumber');
        return ((this.get_objectData()).get_properties())['GridEndNumber'];
    },
    set_gridEndNumber: function SP_FieldRatingScale$set_gridEndNumber(value) {
        ((this.get_objectData()).get_properties())['GridEndNumber'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'GridEndNumber', value));
        }
        return value;
    },
    get_gridNAOptionText: function SP_FieldRatingScale$get_gridNAOptionText() {
        this.checkUninitializedProperty('GridNAOptionText');
        return ((this.get_objectData()).get_properties())['GridNAOptionText'];
    },
    set_gridNAOptionText: function SP_FieldRatingScale$set_gridNAOptionText(value) {
        ((this.get_objectData()).get_properties())['GridNAOptionText'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'GridNAOptionText', value));
        }
        return value;
    },
    get_gridStartNumber: function SP_FieldRatingScale$get_gridStartNumber() {
        this.checkUninitializedProperty('GridStartNumber');
        return ((this.get_objectData()).get_properties())['GridStartNumber'];
    },
    set_gridStartNumber: function SP_FieldRatingScale$set_gridStartNumber(value) {
        ((this.get_objectData()).get_properties())['GridStartNumber'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'GridStartNumber', value));
        }
        return value;
    },
    get_gridTextRangeAverage: function SP_FieldRatingScale$get_gridTextRangeAverage() {
        this.checkUninitializedProperty('GridTextRangeAverage');
        return ((this.get_objectData()).get_properties())['GridTextRangeAverage'];
    },
    set_gridTextRangeAverage: function SP_FieldRatingScale$set_gridTextRangeAverage(value) {
        ((this.get_objectData()).get_properties())['GridTextRangeAverage'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'GridTextRangeAverage', value));
        }
        return value;
    },
    get_gridTextRangeHigh: function SP_FieldRatingScale$get_gridTextRangeHigh() {
        this.checkUninitializedProperty('GridTextRangeHigh');
        return ((this.get_objectData()).get_properties())['GridTextRangeHigh'];
    },
    set_gridTextRangeHigh: function SP_FieldRatingScale$set_gridTextRangeHigh(value) {
        ((this.get_objectData()).get_properties())['GridTextRangeHigh'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'GridTextRangeHigh', value));
        }
        return value;
    },
    get_gridTextRangeLow: function SP_FieldRatingScale$get_gridTextRangeLow() {
        this.checkUninitializedProperty('GridTextRangeLow');
        return ((this.get_objectData()).get_properties())['GridTextRangeLow'];
    },
    set_gridTextRangeLow: function SP_FieldRatingScale$set_gridTextRangeLow(value) {
        ((this.get_objectData()).get_properties())['GridTextRangeLow'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'GridTextRangeLow', value));
        }
        return value;
    },
    get_rangeCount: function SP_FieldRatingScale$get_rangeCount() {
        this.checkUninitializedProperty('RangeCount');
        return ((this.get_objectData()).get_properties())['RangeCount'];
    },
    initPropertiesFromJson: function SP_FieldRatingScale$initPropertiesFromJson(parentNode) {
        SP.FieldMultiChoice.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.GridEndNumber;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GridEndNumber'] = $v_0;
            delete parentNode.GridEndNumber;
        }
        $v_0 = parentNode.GridNAOptionText;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GridNAOptionText'] = $v_0;
            delete parentNode.GridNAOptionText;
        }
        $v_0 = parentNode.GridStartNumber;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GridStartNumber'] = $v_0;
            delete parentNode.GridStartNumber;
        }
        $v_0 = parentNode.GridTextRangeAverage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GridTextRangeAverage'] = $v_0;
            delete parentNode.GridTextRangeAverage;
        }
        $v_0 = parentNode.GridTextRangeHigh;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GridTextRangeHigh'] = $v_0;
            delete parentNode.GridTextRangeHigh;
        }
        $v_0 = parentNode.GridTextRangeLow;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GridTextRangeLow'] = $v_0;
            delete parentNode.GridTextRangeLow;
        }
        $v_0 = parentNode.RangeCount;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RangeCount'] = $v_0;
            delete parentNode.RangeCount;
        }
    }
};
SP.FieldRatingScalePropertyNames = function SP_FieldRatingScalePropertyNames() {
};
SP.FieldRatingScaleQuestionAnswer = function SP_FieldRatingScaleQuestionAnswer() {
    SP.FieldRatingScaleQuestionAnswer.initializeBase(this);
};
SP.FieldRatingScaleQuestionAnswer.prototype = {
    $2A_1: 0,
    $4a_1: null,
    get_answer: function SP_FieldRatingScaleQuestionAnswer$get_answer() {
        return this.$2A_1;
    },
    set_answer: function SP_FieldRatingScaleQuestionAnswer$set_answer(value) {
        this.$2A_1 = value;
        return value;
    },
    get_question: function SP_FieldRatingScaleQuestionAnswer$get_question() {
        return this.$4a_1;
    },
    set_question: function SP_FieldRatingScaleQuestionAnswer$set_question(value) {
        this.$4a_1 = value;
        return value;
    },
    get_typeId: function SP_FieldRatingScaleQuestionAnswer$get_typeId() {
        return '{9b88fe8e-47cd-4ddc-9d66-0d12d70dde28}';
    },
    writeToXml: function SP_FieldRatingScaleQuestionAnswer$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Answer', 'Question'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FieldRatingScaleQuestionAnswer$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Answer;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2A_1 = $v_0;
            delete parentNode.Answer;
        }
        $v_0 = parentNode.Question;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4a_1 = $v_0;
            delete parentNode.Question;
        }
    }
};
SP.FieldStringValues = function SP_FieldStringValues(context, objectPath) {
    SP.FieldStringValues.initializeBase(this, [context, objectPath]);
};
SP.FieldStringValues.prototype = {
    get_fieldValues: function SP_FieldStringValues$get_fieldValues() {
        var $v_0 = ((this.get_objectData()).get_methodReturnObjects())['$m_dict'];

        if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
            $v_0 = {};
            ((this.get_objectData()).get_methodReturnObjects())['$m_dict'] = $v_0;
        }
        return $v_0;
    },
    get_item: function SP_FieldStringValues$get_item(fieldName) {
        return this.$12_1(fieldName);
    },
    initNonPropertiesFromJson: function SP_FieldStringValues$initNonPropertiesFromJson(parentNode) {
        SP.DataConvert.populateDictionaryFromObject(this.get_fieldValues(), parentNode);
        SP.DataConvert.fixupTypes(this.get_context(), this.get_fieldValues());
    },
    $12_1: function SP_FieldStringValues$$12_1($p0) {
        var $v_0 = (this.get_fieldValues())[$p0];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            throw Error.create(SP.ResResources.getString('PropertyHasNotBeenInitialized'));
        }
        return $v_0;
    },
    refreshLoad: function SP_FieldStringValues$refreshLoad() {
        SP.ClientObject.prototype.refreshLoad.call(this);
        this.loadExpandoFields();
    },
    loadExpandoFields: function SP_FieldStringValues$loadExpandoFields() {
        var $$dict_0 = this.get_fieldValues();

        for (var $$key_1 in $$dict_0) {
            var $v_0 = {
                key: $$key_1,
                value: $$dict_0[$$key_1]
            };

            this.retrieve($v_0.key);
        }
    }
};
SP.FieldText = function SP_FieldText(context, objectPath) {
    SP.FieldText.initializeBase(this, [context, objectPath]);
};
SP.FieldText.prototype = {
    get_maxLength: function SP_FieldText$get_maxLength() {
        this.checkUninitializedProperty('MaxLength');
        return ((this.get_objectData()).get_properties())['MaxLength'];
    },
    set_maxLength: function SP_FieldText$set_maxLength(value) {
        ((this.get_objectData()).get_properties())['MaxLength'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MaxLength', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldText$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.MaxLength;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MaxLength'] = $v_0;
            delete parentNode.MaxLength;
        }
    }
};
SP.FieldTextPropertyNames = function SP_FieldTextPropertyNames() {
};
SP.FieldUrl = function SP_FieldUrl(context, objectPath) {
    SP.FieldUrl.initializeBase(this, [context, objectPath]);
};
SP.FieldUrl.prototype = {
    get_displayFormat: function SP_FieldUrl$get_displayFormat() {
        this.checkUninitializedProperty('DisplayFormat');
        return ((this.get_objectData()).get_properties())['DisplayFormat'];
    },
    set_displayFormat: function SP_FieldUrl$set_displayFormat(value) {
        ((this.get_objectData()).get_properties())['DisplayFormat'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DisplayFormat', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldUrl$initPropertiesFromJson(parentNode) {
        SP.Field.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DisplayFormat;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisplayFormat'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.DisplayFormat;
        }
    }
};
SP.FieldUrlPropertyNames = function SP_FieldUrlPropertyNames() {
};
SP.FieldUrlValue = function SP_FieldUrlValue() {
    SP.FieldUrlValue.initializeBase(this);
};
SP.FieldUrlValue.prototype = {
    $2_1: null,
    $1_1: null,
    get_description: function SP_FieldUrlValue$get_description() {
        return this.$2_1;
    },
    set_description: function SP_FieldUrlValue$set_description(value) {
        this.$2_1 = value;
        return value;
    },
    get_url: function SP_FieldUrlValue$get_url() {
        return this.$1_1;
    },
    set_url: function SP_FieldUrlValue$set_url(value) {
        this.$1_1 = value;
        return value;
    },
    get_typeId: function SP_FieldUrlValue$get_typeId() {
        return '{fa8b44af-7b43-43f2-904a-bd319497011e}';
    },
    writeToXml: function SP_FieldUrlValue$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Description', 'Url'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FieldUrlValue$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2_1 = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1_1 = $v_0;
            delete parentNode.Url;
        }
    }
};
SP.FieldUser = function SP_FieldUser(context, objectPath) {
    SP.FieldUser.initializeBase(this, [context, objectPath]);
};
SP.FieldUser.prototype = {
    get_allowDisplay: function SP_FieldUser$get_allowDisplay() {
        this.checkUninitializedProperty('AllowDisplay');
        return ((this.get_objectData()).get_properties())['AllowDisplay'];
    },
    set_allowDisplay: function SP_FieldUser$set_allowDisplay(value) {
        ((this.get_objectData()).get_properties())['AllowDisplay'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowDisplay', value));
        }
        return value;
    },
    get_presence: function SP_FieldUser$get_presence() {
        this.checkUninitializedProperty('Presence');
        return ((this.get_objectData()).get_properties())['Presence'];
    },
    set_presence: function SP_FieldUser$set_presence(value) {
        ((this.get_objectData()).get_properties())['Presence'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Presence', value));
        }
        return value;
    },
    get_selectionGroup: function SP_FieldUser$get_selectionGroup() {
        this.checkUninitializedProperty('SelectionGroup');
        return ((this.get_objectData()).get_properties())['SelectionGroup'];
    },
    set_selectionGroup: function SP_FieldUser$set_selectionGroup(value) {
        ((this.get_objectData()).get_properties())['SelectionGroup'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SelectionGroup', value));
        }
        return value;
    },
    get_selectionMode: function SP_FieldUser$get_selectionMode() {
        this.checkUninitializedProperty('SelectionMode');
        return ((this.get_objectData()).get_properties())['SelectionMode'];
    },
    set_selectionMode: function SP_FieldUser$set_selectionMode(value) {
        ((this.get_objectData()).get_properties())['SelectionMode'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SelectionMode', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_FieldUser$initPropertiesFromJson(parentNode) {
        SP.FieldLookup.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowDisplay;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowDisplay'] = $v_0;
            delete parentNode.AllowDisplay;
        }
        $v_0 = parentNode.Presence;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Presence'] = $v_0;
            delete parentNode.Presence;
        }
        $v_0 = parentNode.SelectionGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SelectionGroup'] = $v_0;
            delete parentNode.SelectionGroup;
        }
        $v_0 = parentNode.SelectionMode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SelectionMode'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SelectionMode;
        }
    }
};
SP.FieldUserPropertyNames = function SP_FieldUserPropertyNames() {
};
SP.FieldUserValue = function SP_FieldUserValue() {
    SP.FieldUserValue.initializeBase(this);
};
SP.FieldUserValue.fromUser = function SP_FieldUserValue$fromUser(userName) {
    var $v_0 = new SP.FieldUserValue();

    $v_0.$1S_1 = -1;
    $v_0.$85_1(userName);
    return $v_0;
};
SP.FieldUserValue.prototype = {
    $5_2: null,
    get_email: function SP_FieldUserValue$get_email() {
        return this.$5_2;
    },
    get_typeId: function SP_FieldUserValue$get_typeId() {
        return '{c956ab54-16bd-4c18-89d2-996f57282a6f}';
    },
    writeToXml: function SP_FieldUserValue$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Email'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.FieldLookupValue.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FieldUserValue$initPropertiesFromJson(parentNode) {
        SP.FieldLookupValue.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Email;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5_2 = $v_0;
            delete parentNode.Email;
        }
    }
};
SP.File = function SP_File(context, objectPath) {
    SP.File.initializeBase(this, [context, objectPath]);
};
SP.File.getContentVerFromTag = function SP_File$getContentVerFromTag(context, contentTag) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{df28be1e-74b5-4b21-b73a-2bbac0a23d8a}', 'GetContentVerFromTag', [contentTag]);

    context.addQuery($v_1);
    $v_0 = new SP.IntResult();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.File.prototype = {
    $F_1: function SP_File$$F_1($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Name'] = $p0.$1_1;
            if (!SP.ScriptUtility.isNullOrEmptyString($p0.$1_1)) {
                if ($p0.$1_1.endsWith('/')) {
                    throw Error.argument();
                }
                var $v_0;
                var $v_1 = $p0.$1_1.lastIndexOf('/');

                if ($v_1 >= 0 && $v_1 < $p0.$1_1.length) {
                    $v_0 = $p0.$1_1.substr($v_1 + 1);
                    ((this.get_objectData()).get_properties())['Name'] = $v_0;
                }
            }
        }
    },
    $7U_1: function SP_File$$7U_1($p0) {
        if (typeof $p0 === 'undefined') {
            throw Error.argument();
        }
    },
    get_author: function SP_File$get_author() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Author'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Author'));
            ((this.get_objectData()).get_clientObjectProperties())['Author'] = $v_0;
        }
        return $v_0;
    },
    get_checkedOutByUser: function SP_File$get_checkedOutByUser() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['CheckedOutByUser'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'CheckedOutByUser'));
            ((this.get_objectData()).get_clientObjectProperties())['CheckedOutByUser'] = $v_0;
        }
        return $v_0;
    },
    get_checkInComment: function SP_File$get_checkInComment() {
        this.checkUninitializedProperty('CheckInComment');
        return ((this.get_objectData()).get_properties())['CheckInComment'];
    },
    get_checkOutType: function SP_File$get_checkOutType() {
        this.checkUninitializedProperty('CheckOutType');
        return ((this.get_objectData()).get_properties())['CheckOutType'];
    },
    get_contentTag: function SP_File$get_contentTag() {
        this.checkUninitializedProperty('ContentTag');
        return ((this.get_objectData()).get_properties())['ContentTag'];
    },
    get_customizedPageStatus: function SP_File$get_customizedPageStatus() {
        this.checkUninitializedProperty('CustomizedPageStatus');
        return ((this.get_objectData()).get_properties())['CustomizedPageStatus'];
    },
    get_listId: function SP_File$get_listId() {
        this.checkUninitializedProperty('ListId');
        return ((this.get_objectData()).get_properties())['ListId'];
    },
    get_effectiveInformationRightsManagementSettings: function SP_File$get_effectiveInformationRightsManagementSettings() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['EffectiveInformationRightsManagementSettings'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.EffectiveInformationRightsManagementSettings(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'EffectiveInformationRightsManagementSettings'));
            ((this.get_objectData()).get_clientObjectProperties())['EffectiveInformationRightsManagementSettings'] = $v_0;
        }
        return $v_0;
    },
    get_eTag: function SP_File$get_eTag() {
        this.checkUninitializedProperty('ETag');
        return ((this.get_objectData()).get_properties())['ETag'];
    },
    get_exists: function SP_File$get_exists() {
        this.checkUninitializedProperty('Exists');
        return ((this.get_objectData()).get_properties())['Exists'];
    },
    get_informationRightsManagementSettings: function SP_File$get_informationRightsManagementSettings() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['InformationRightsManagementSettings'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.InformationRightsManagementFileSettings(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'InformationRightsManagementSettings'));
            ((this.get_objectData()).get_clientObjectProperties())['InformationRightsManagementSettings'] = $v_0;
        }
        return $v_0;
    },
    get_irmEnabled: function SP_File$get_irmEnabled() {
        this.checkUninitializedProperty('IrmEnabled');
        return ((this.get_objectData()).get_properties())['IrmEnabled'];
    },
    set_irmEnabled: function SP_File$set_irmEnabled(value) {
        ((this.get_objectData()).get_properties())['IrmEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IrmEnabled', value));
        }
        return value;
    },
    get_length: function SP_File$get_length() {
        this.checkUninitializedProperty('Length');
        return ((this.get_objectData()).get_properties())['Length'];
    },
    get_level: function SP_File$get_level() {
        this.checkUninitializedProperty('Level');
        return ((this.get_objectData()).get_properties())['Level'];
    },
    get_linkingUrl: function SP_File$get_linkingUrl() {
        this.checkUninitializedProperty('LinkingUrl');
        return ((this.get_objectData()).get_properties())['LinkingUrl'];
    },
    get_listItemAllFields: function SP_File$get_listItemAllFields() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ListItemAllFields'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ListItem(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ListItemAllFields'));
            ((this.get_objectData()).get_clientObjectProperties())['ListItemAllFields'] = $v_0;
        }
        return $v_0;
    },
    get_lockedByUser: function SP_File$get_lockedByUser() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['LockedByUser'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'LockedByUser'));
            ((this.get_objectData()).get_clientObjectProperties())['LockedByUser'] = $v_0;
        }
        return $v_0;
    },
    get_majorVersion: function SP_File$get_majorVersion() {
        this.checkUninitializedProperty('MajorVersion');
        return ((this.get_objectData()).get_properties())['MajorVersion'];
    },
    get_minorVersion: function SP_File$get_minorVersion() {
        this.checkUninitializedProperty('MinorVersion');
        return ((this.get_objectData()).get_properties())['MinorVersion'];
    },
    get_modifiedBy: function SP_File$get_modifiedBy() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ModifiedBy'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ModifiedBy'));
            ((this.get_objectData()).get_clientObjectProperties())['ModifiedBy'] = $v_0;
        }
        return $v_0;
    },
    get_name: function SP_File$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    get_properties: function SP_File$get_properties() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Properties'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.PropertyValues(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Properties'));
            ((this.get_objectData()).get_clientObjectProperties())['Properties'] = $v_0;
        }
        return $v_0;
    },
    get_serverRelativeUrl: function SP_File$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    get_siteId: function SP_File$get_siteId() {
        this.checkUninitializedProperty('SiteId');
        return ((this.get_objectData()).get_properties())['SiteId'];
    },
    get_timeCreated: function SP_File$get_timeCreated() {
        this.checkUninitializedProperty('TimeCreated');
        return ((this.get_objectData()).get_properties())['TimeCreated'];
    },
    get_timeLastModified: function SP_File$get_timeLastModified() {
        this.checkUninitializedProperty('TimeLastModified');
        return ((this.get_objectData()).get_properties())['TimeLastModified'];
    },
    get_title: function SP_File$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    get_uiVersion: function SP_File$get_uiVersion() {
        this.checkUninitializedProperty('UIVersion');
        return ((this.get_objectData()).get_properties())['UIVersion'];
    },
    get_uiVersionLabel: function SP_File$get_uiVersionLabel() {
        this.checkUninitializedProperty('UIVersionLabel');
        return ((this.get_objectData()).get_properties())['UIVersionLabel'];
    },
    get_uniqueId: function SP_File$get_uniqueId() {
        this.checkUninitializedProperty('UniqueId');
        return ((this.get_objectData()).get_properties())['UniqueId'];
    },
    get_versionEvents: function SP_File$get_versionEvents() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['VersionEvents'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FileVersionEventCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'VersionEvents'));
            ((this.get_objectData()).get_clientObjectProperties())['VersionEvents'] = $v_0;
        }
        return $v_0;
    },
    get_versions: function SP_File$get_versions() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Versions'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FileVersionCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Versions'));
            ((this.get_objectData()).get_clientObjectProperties())['Versions'] = $v_0;
        }
        return $v_0;
    },
    get_webId: function SP_File$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_File$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Author;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Author', this.get_author(), $v_0);
            (this.get_author()).fromJson($v_0);
            delete parentNode.Author;
        }
        $v_0 = parentNode.CheckedOutByUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('CheckedOutByUser', this.get_checkedOutByUser(), $v_0);
            (this.get_checkedOutByUser()).fromJson($v_0);
            delete parentNode.CheckedOutByUser;
        }
        $v_0 = parentNode.CheckInComment;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CheckInComment'] = $v_0;
            delete parentNode.CheckInComment;
        }
        $v_0 = parentNode.CheckOutType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CheckOutType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.CheckOutType;
        }
        $v_0 = parentNode.ContentTag;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContentTag'] = $v_0;
            delete parentNode.ContentTag;
        }
        $v_0 = parentNode.CustomizedPageStatus;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CustomizedPageStatus'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.CustomizedPageStatus;
        }
        $v_0 = parentNode.ListId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListId'] = $v_0;
            delete parentNode.ListId;
        }
        $v_0 = parentNode.EffectiveInformationRightsManagementSettings;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('EffectiveInformationRightsManagementSettings', this.get_effectiveInformationRightsManagementSettings(), $v_0);
            (this.get_effectiveInformationRightsManagementSettings()).fromJson($v_0);
            delete parentNode.EffectiveInformationRightsManagementSettings;
        }
        $v_0 = parentNode.ETag;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ETag'] = $v_0;
            delete parentNode.ETag;
        }
        $v_0 = parentNode.Exists;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Exists'] = $v_0;
            delete parentNode.Exists;
        }
        $v_0 = parentNode.InformationRightsManagementSettings;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('InformationRightsManagementSettings', this.get_informationRightsManagementSettings(), $v_0);
            (this.get_informationRightsManagementSettings()).fromJson($v_0);
            delete parentNode.InformationRightsManagementSettings;
        }
        $v_0 = parentNode.IrmEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IrmEnabled'] = $v_0;
            delete parentNode.IrmEnabled;
        }
        $v_0 = parentNode.Length;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Length'] = $v_0;
            delete parentNode.Length;
        }
        $v_0 = parentNode.Level;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Level'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Level;
        }
        $v_0 = parentNode.LinkingUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LinkingUrl'] = $v_0;
            delete parentNode.LinkingUrl;
        }
        $v_0 = parentNode.ListItemAllFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ListItemAllFields', this.get_listItemAllFields(), $v_0);
            (this.get_listItemAllFields()).fromJson($v_0);
            delete parentNode.ListItemAllFields;
        }
        $v_0 = parentNode.LockedByUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('LockedByUser', this.get_lockedByUser(), $v_0);
            (this.get_lockedByUser()).fromJson($v_0);
            delete parentNode.LockedByUser;
        }
        $v_0 = parentNode.MajorVersion;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MajorVersion'] = $v_0;
            delete parentNode.MajorVersion;
        }
        $v_0 = parentNode.MinorVersion;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MinorVersion'] = $v_0;
            delete parentNode.MinorVersion;
        }
        $v_0 = parentNode.ModifiedBy;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ModifiedBy', this.get_modifiedBy(), $v_0);
            (this.get_modifiedBy()).fromJson($v_0);
            delete parentNode.ModifiedBy;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.Properties;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Properties', this.get_properties(), $v_0);
            (this.get_properties()).fromJson($v_0);
            delete parentNode.Properties;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.SiteId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SiteId'] = $v_0;
            delete parentNode.SiteId;
        }
        $v_0 = parentNode.TimeCreated;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TimeCreated'] = $v_0;
            delete parentNode.TimeCreated;
        }
        $v_0 = parentNode.TimeLastModified;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TimeLastModified'] = $v_0;
            delete parentNode.TimeLastModified;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.UIVersion;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UIVersion'] = $v_0;
            delete parentNode.UIVersion;
        }
        $v_0 = parentNode.UIVersionLabel;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UIVersionLabel'] = $v_0;
            delete parentNode.UIVersionLabel;
        }
        $v_0 = parentNode.UniqueId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UniqueId'] = $v_0;
            delete parentNode.UniqueId;
        }
        $v_0 = parentNode.VersionEvents;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('VersionEvents', this.get_versionEvents(), $v_0);
            (this.get_versionEvents()).fromJson($v_0);
            delete parentNode.VersionEvents;
        }
        $v_0 = parentNode.Versions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Versions', this.get_versions(), $v_0);
            (this.get_versions()).fromJson($v_0);
            delete parentNode.Versions;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    },
    getPreAuthorizedAccessUrl: function SP_File$getPreAuthorizedAccessUrl(expirationHours) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetPreAuthorizedAccessUrl', [expirationHours]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getImagePreviewUrl: function SP_File$getImagePreviewUrl(width, height, clientType) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetImagePreviewUrl', [width, height, clientType]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    startUpload: function SP_File$startUpload(uploadId, stream) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'StartUpload', [uploadId, stream]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.IntResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    continueUpload: function SP_File$continueUpload(uploadId, fileOffset, stream) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'ContinueUpload', [uploadId, fileOffset, stream]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.IntResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    finishUpload: function SP_File$finishUpload(uploadId, fileOffset, stream) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'FinishUpload', [uploadId, fileOffset, stream]));
        return $v_1;
    },
    cancelUpload: function SP_File$cancelUpload(uploadId) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'CancelUpload', [uploadId]);

        $v_0.addQuery($v_1);
    },
    deleteObject: function SP_File$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    },
    recycle: function SP_File$recycle() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'Recycle', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        this.removeFromParentCollection();
        return $v_1;
    },
    executeCobaltRequest: function SP_File$executeCobaltRequest(inputStream) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'ExecuteCobaltRequest', [inputStream]);

        $v_0.addQuery($v_2);
        $v_1 = [];
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    checkOut: function SP_File$checkOut() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'CheckOut', null);

        $v_0.addQuery($v_1);
    },
    undoCheckOut: function SP_File$undoCheckOut() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'UndoCheckOut', null);

        $v_0.addQuery($v_1);
    },
    checkIn: function SP_File$checkIn(comment, checkInType) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'CheckIn', [comment, checkInType]);

        $v_0.addQuery($v_1);
    },
    publish: function SP_File$publish(comment) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Publish', [comment]);

        $v_0.addQuery($v_1);
    },
    unPublish: function SP_File$unPublish(comment) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'UnPublish', [comment]);

        $v_0.addQuery($v_1);
    },
    approve: function SP_File$approve(comment) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Approve', [comment]);

        $v_0.addQuery($v_1);
    },
    deny: function SP_File$deny(comment) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Deny', [comment]);

        $v_0.addQuery($v_1);
    },
    getLimitedWebPartManager: function SP_File$getLimitedWebPartManager(scope) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetLimitedWebPartManager'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetLimitedWebPartManager'] = $v_2;
        }
        $v_1 = $v_2[scope];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.WebParts.LimitedWebPartManager($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetLimitedWebPartManager', [scope]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[scope] = $v_1;
        }
        this.$7U_1(scope);
        return $v_1;
    },
    getWOPIFrameUrl: function SP_File$getWOPIFrameUrl(action) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetWOPIFrameUrl', [action]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    update: function SP_File$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    },
    moveTo: function SP_File$moveTo(newUrl, flags) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'MoveTo', [newUrl, flags]);

        $v_0.addQuery($v_1);
    },
    copyTo: function SP_File$copyTo(strNewUrl, bOverWrite) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'CopyTo', [strNewUrl, bOverWrite]);

        $v_0.addQuery($v_1);
    },
    saveBinary: function SP_File$saveBinary(parameters) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'SaveBinary', [parameters]);

        $v_0.addQuery($v_1);
    }
};
SP.FilePropertyNames = function SP_FilePropertyNames() {
};
SP.FileObjectPropertyNames = function SP_FileObjectPropertyNames() {
};
SP.FileCollection = function SP_FileCollection(context, objectPath) {
    SP.FileCollection.initializeBase(this, [context, objectPath]);
};
SP.FileCollection.prototype = {
    itemAt: function SP_FileCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_FileCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_FileCollection$get_childItemType() {
        return SP.File;
    },
    getByUrl: function SP_FileCollection$getByUrl(url) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByUrl'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByUrl'] = $v_2;
        }
        $v_1 = $v_2[url];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByUrl', [url]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[url] = $v_1;
        }
        return $v_1;
    },
    add: function SP_FileCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_1(parameters);
        return $v_1;
    },
    addTemplateFile: function SP_FileCollection$addTemplateFile(urlOfFile, templateFileType) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'AddTemplateFile', [urlOfFile, templateFileType]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    }
};
SP.FileCreationInformation = function SP_FileCreationInformation() {
    SP.FileCreationInformation.initializeBase(this);
};
SP.FileCreationInformation.prototype = {
    $Z_1: null,
    $l_1: false,
    $1_1: null,
    get_content: function SP_FileCreationInformation$get_content() {
        return this.$Z_1;
    },
    set_content: function SP_FileCreationInformation$set_content(value) {
        this.$Z_1 = value;
        return value;
    },
    get_overwrite: function SP_FileCreationInformation$get_overwrite() {
        return this.$l_1;
    },
    set_overwrite: function SP_FileCreationInformation$set_overwrite(value) {
        this.$l_1 = value;
        return value;
    },
    get_url: function SP_FileCreationInformation$get_url() {
        return this.$1_1;
    },
    set_url: function SP_FileCreationInformation$set_url(value) {
        this.$1_1 = value;
        return value;
    },
    get_typeId: function SP_FileCreationInformation$get_typeId() {
        return '{f5c8173c-cae6-4469-a7af-3879ca3c617c}';
    },
    writeToXml: function SP_FileCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Content', 'Overwrite', 'Url'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FileCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Content;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$Z_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Content;
        }
        $v_0 = parentNode.Overwrite;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$l_1 = $v_0;
            delete parentNode.Overwrite;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1_1 = $v_0;
            delete parentNode.Url;
        }
    }
};
SP.FileSaveBinaryInformation = function SP_FileSaveBinaryInformation() {
    SP.FileSaveBinaryInformation.initializeBase(this);
};
SP.FileSaveBinaryInformation.prototype = {
    $2M_1: false,
    $Z_1: null,
    $2Z_1: null,
    $2g_1: null,
    get_checkRequiredFields: function SP_FileSaveBinaryInformation$get_checkRequiredFields() {
        return this.$2M_1;
    },
    set_checkRequiredFields: function SP_FileSaveBinaryInformation$set_checkRequiredFields(value) {
        this.$2M_1 = value;
        return value;
    },
    get_content: function SP_FileSaveBinaryInformation$get_content() {
        return this.$Z_1;
    },
    set_content: function SP_FileSaveBinaryInformation$set_content(value) {
        this.$Z_1 = value;
        return value;
    },
    get_eTag: function SP_FileSaveBinaryInformation$get_eTag() {
        return this.$2Z_1;
    },
    set_eTag: function SP_FileSaveBinaryInformation$set_eTag(value) {
        this.$2Z_1 = value;
        return value;
    },
    get_fieldValues: function SP_FileSaveBinaryInformation$get_fieldValues() {
        return this.$2g_1;
    },
    set_fieldValues: function SP_FileSaveBinaryInformation$set_fieldValues(value) {
        this.$2g_1 = value;
        return value;
    },
    get_typeId: function SP_FileSaveBinaryInformation$get_typeId() {
        return '{c3de0784-43e6-4f12-bd0c-f0d9a34ebf93}';
    },
    writeToXml: function SP_FileSaveBinaryInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['CheckRequiredFields', 'Content', 'ETag', 'FieldValues'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FileSaveBinaryInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CheckRequiredFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2M_1 = $v_0;
            delete parentNode.CheckRequiredFields;
        }
        $v_0 = parentNode.Content;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$Z_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Content;
        }
        $v_0 = parentNode.ETag;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2Z_1 = $v_0;
            delete parentNode.ETag;
        }
        $v_0 = parentNode.FieldValues;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2g_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.FieldValues;
        }
    }
};
SP.FileVersion = function SP_FileVersion(context, objectPath) {
    SP.FileVersion.initializeBase(this, [context, objectPath]);
};
SP.FileVersion.prototype = {
    get_checkInComment: function SP_FileVersion$get_checkInComment() {
        this.checkUninitializedProperty('CheckInComment');
        return ((this.get_objectData()).get_properties())['CheckInComment'];
    },
    get_created: function SP_FileVersion$get_created() {
        this.checkUninitializedProperty('Created');
        return ((this.get_objectData()).get_properties())['Created'];
    },
    get_createdBy: function SP_FileVersion$get_createdBy() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['CreatedBy'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'CreatedBy'));
            ((this.get_objectData()).get_clientObjectProperties())['CreatedBy'] = $v_0;
        }
        return $v_0;
    },
    get_id: function SP_FileVersion$get_id() {
        this.checkUninitializedProperty('ID');
        return ((this.get_objectData()).get_properties())['ID'];
    },
    get_isCurrentVersion: function SP_FileVersion$get_isCurrentVersion() {
        this.checkUninitializedProperty('IsCurrentVersion');
        return ((this.get_objectData()).get_properties())['IsCurrentVersion'];
    },
    get_length: function SP_FileVersion$get_length() {
        this.checkUninitializedProperty('Length');
        return ((this.get_objectData()).get_properties())['Length'];
    },
    get_size: function SP_FileVersion$get_size() {
        this.checkUninitializedProperty('Size');
        return ((this.get_objectData()).get_properties())['Size'];
    },
    get_url: function SP_FileVersion$get_url() {
        this.checkUninitializedProperty('Url');
        return ((this.get_objectData()).get_properties())['Url'];
    },
    get_versionLabel: function SP_FileVersion$get_versionLabel() {
        this.checkUninitializedProperty('VersionLabel');
        return ((this.get_objectData()).get_properties())['VersionLabel'];
    },
    initPropertiesFromJson: function SP_FileVersion$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CheckInComment;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CheckInComment'] = $v_0;
            delete parentNode.CheckInComment;
        }
        $v_0 = parentNode.Created;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Created'] = $v_0;
            delete parentNode.Created;
        }
        $v_0 = parentNode.CreatedBy;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('CreatedBy', this.get_createdBy(), $v_0);
            (this.get_createdBy()).fromJson($v_0);
            delete parentNode.CreatedBy;
        }
        $v_0 = parentNode.ID;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ID'] = $v_0;
            delete parentNode.ID;
        }
        $v_0 = parentNode.IsCurrentVersion;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsCurrentVersion'] = $v_0;
            delete parentNode.IsCurrentVersion;
        }
        $v_0 = parentNode.Length;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Length'] = $v_0;
            delete parentNode.Length;
        }
        $v_0 = parentNode.Size;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Size'] = $v_0;
            delete parentNode.Size;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Url'] = $v_0;
            delete parentNode.Url;
        }
        $v_0 = parentNode.VersionLabel;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['VersionLabel'] = $v_0;
            delete parentNode.VersionLabel;
        }
    },
    deleteObject: function SP_FileVersion$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.FileVersionPropertyNames = function SP_FileVersionPropertyNames() {
};
SP.FileVersionObjectPropertyNames = function SP_FileVersionObjectPropertyNames() {
};
SP.FileVersionCollection = function SP_FileVersionCollection(context, objectPath) {
    SP.FileVersionCollection.initializeBase(this, [context, objectPath]);
};
SP.FileVersionCollection.prototype = {
    itemAt: function SP_FileVersionCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_FileVersionCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_FileVersionCollection$get_childItemType() {
        return SP.FileVersion;
    },
    getById: function SP_FileVersionCollection$getById(versionid) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[versionid];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.FileVersion($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [versionid]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[versionid] = $v_1;
        }
        return $v_1;
    },
    deleteByID: function SP_FileVersionCollection$deleteByID(vid) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteByID', [vid]);

        $v_0.addQuery($v_1);
    },
    deleteByLabel: function SP_FileVersionCollection$deleteByLabel(versionlabel) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteByLabel', [versionlabel]);

        $v_0.addQuery($v_1);
    },
    deleteAll: function SP_FileVersionCollection$deleteAll() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteAll', null);

        $v_0.addQuery($v_1);
    },
    restoreByLabel: function SP_FileVersionCollection$restoreByLabel(versionlabel) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RestoreByLabel', [versionlabel]);

        $v_0.addQuery($v_1);
    }
};
SP.FileVersionEvent = function SP_FileVersionEvent(context, objectPath) {
    SP.FileVersionEvent.initializeBase(this, [context, objectPath]);
};
SP.FileVersionEvent.prototype = {
    get_editor: function SP_FileVersionEvent$get_editor() {
        this.checkUninitializedProperty('Editor');
        return ((this.get_objectData()).get_properties())['Editor'];
    },
    get_editorEmail: function SP_FileVersionEvent$get_editorEmail() {
        this.checkUninitializedProperty('EditorEmail');
        return ((this.get_objectData()).get_properties())['EditorEmail'];
    },
    get_sharedByUser: function SP_FileVersionEvent$get_sharedByUser() {
        this.checkUninitializedProperty('SharedByUser');
        return ((this.get_objectData()).get_properties())['SharedByUser'];
    },
    get_sharedWithUsers: function SP_FileVersionEvent$get_sharedWithUsers() {
        this.checkUninitializedProperty('SharedWithUsers');
        return ((this.get_objectData()).get_properties())['SharedWithUsers'];
    },
    get_time: function SP_FileVersionEvent$get_time() {
        this.checkUninitializedProperty('Time');
        return ((this.get_objectData()).get_properties())['Time'];
    },
    get_eventType: function SP_FileVersionEvent$get_eventType() {
        this.checkUninitializedProperty('EventType');
        return ((this.get_objectData()).get_properties())['EventType'];
    },
    initPropertiesFromJson: function SP_FileVersionEvent$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Editor;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Editor'] = $v_0;
            delete parentNode.Editor;
        }
        $v_0 = parentNode.EditorEmail;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EditorEmail'] = $v_0;
            delete parentNode.EditorEmail;
        }
        $v_0 = parentNode.SharedByUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SharedByUser'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SharedByUser;
        }
        $v_0 = parentNode.SharedWithUsers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SharedWithUsers'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SharedWithUsers;
        }
        $v_0 = parentNode.Time;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Time'] = $v_0;
            delete parentNode.Time;
        }
        $v_0 = parentNode.EventType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EventType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.EventType;
        }
    }
};
SP.FileVersionEventPropertyNames = function SP_FileVersionEventPropertyNames() {
};
SP.FileVersionEventCollection = function SP_FileVersionEventCollection(context, objectPath) {
    SP.FileVersionEventCollection.initializeBase(this, [context, objectPath]);
};
SP.FileVersionEventCollection.prototype = {
    itemAt: function SP_FileVersionEventCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_FileVersionEventCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_FileVersionEventCollection$get_childItemType() {
        return SP.FileVersionEvent;
    }
};
SP.Folder = function SP_Folder(context, objectPath) {
    SP.Folder.initializeBase(this, [context, objectPath]);
};
SP.Folder.prototype = {
    get_contentTypeOrder: function SP_Folder$get_contentTypeOrder() {
        this.checkUninitializedProperty('ContentTypeOrder');
        return ((this.get_objectData()).get_properties())['ContentTypeOrder'];
    },
    get_exists: function SP_Folder$get_exists() {
        this.checkUninitializedProperty('Exists');
        return ((this.get_objectData()).get_properties())['Exists'];
    },
    get_files: function SP_Folder$get_files() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Files'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FileCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Files'));
            ((this.get_objectData()).get_clientObjectProperties())['Files'] = $v_0;
        }
        return $v_0;
    },
    get_isWOPIEnabled: function SP_Folder$get_isWOPIEnabled() {
        this.checkUninitializedProperty('IsWOPIEnabled');
        return ((this.get_objectData()).get_properties())['IsWOPIEnabled'];
    },
    get_listItemAllFields: function SP_Folder$get_listItemAllFields() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ListItemAllFields'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ListItem(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ListItemAllFields'));
            ((this.get_objectData()).get_clientObjectProperties())['ListItemAllFields'] = $v_0;
        }
        return $v_0;
    },
    get_itemCount: function SP_Folder$get_itemCount() {
        this.checkUninitializedProperty('ItemCount');
        return ((this.get_objectData()).get_properties())['ItemCount'];
    },
    get_name: function SP_Folder$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    get_parentFolder: function SP_Folder$get_parentFolder() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ParentFolder'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Folder(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ParentFolder'));
            ((this.get_objectData()).get_clientObjectProperties())['ParentFolder'] = $v_0;
        }
        return $v_0;
    },
    get_progID: function SP_Folder$get_progID() {
        this.checkUninitializedProperty('ProgID');
        return ((this.get_objectData()).get_properties())['ProgID'];
    },
    get_properties: function SP_Folder$get_properties() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Properties'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.PropertyValues(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Properties'));
            ((this.get_objectData()).get_clientObjectProperties())['Properties'] = $v_0;
        }
        return $v_0;
    },
    get_serverRelativeUrl: function SP_Folder$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    get_storageMetrics: function SP_Folder$get_storageMetrics() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['StorageMetrics'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.StorageMetrics(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'StorageMetrics'));
            ((this.get_objectData()).get_clientObjectProperties())['StorageMetrics'] = $v_0;
        }
        return $v_0;
    },
    get_folders: function SP_Folder$get_folders() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Folders'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FolderCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Folders'));
            ((this.get_objectData()).get_clientObjectProperties())['Folders'] = $v_0;
        }
        return $v_0;
    },
    get_timeCreated: function SP_Folder$get_timeCreated() {
        this.checkUninitializedProperty('TimeCreated');
        return ((this.get_objectData()).get_properties())['TimeCreated'];
    },
    get_timeLastModified: function SP_Folder$get_timeLastModified() {
        this.checkUninitializedProperty('TimeLastModified');
        return ((this.get_objectData()).get_properties())['TimeLastModified'];
    },
    get_uniqueContentTypeOrder: function SP_Folder$get_uniqueContentTypeOrder() {
        this.checkUninitializedProperty('UniqueContentTypeOrder');
        return ((this.get_objectData()).get_properties())['UniqueContentTypeOrder'];
    },
    set_uniqueContentTypeOrder: function SP_Folder$set_uniqueContentTypeOrder(value) {
        ((this.get_objectData()).get_properties())['UniqueContentTypeOrder'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'UniqueContentTypeOrder', value));
        }
        return value;
    },
    get_uniqueId: function SP_Folder$get_uniqueId() {
        this.checkUninitializedProperty('UniqueId');
        return ((this.get_objectData()).get_properties())['UniqueId'];
    },
    get_welcomePage: function SP_Folder$get_welcomePage() {
        this.checkUninitializedProperty('WelcomePage');
        return ((this.get_objectData()).get_properties())['WelcomePage'];
    },
    set_welcomePage: function SP_Folder$set_welcomePage(value) {
        ((this.get_objectData()).get_properties())['WelcomePage'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'WelcomePage', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_Folder$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ContentTypeOrder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContentTypeOrder'] = [];
            SP.DataConvert.populateArray(this.get_context(), ((this.get_objectData()).get_properties())['ContentTypeOrder'], $v_0);
            delete parentNode.ContentTypeOrder;
        }
        $v_0 = parentNode.Exists;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Exists'] = $v_0;
            delete parentNode.Exists;
        }
        $v_0 = parentNode.Files;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Files', this.get_files(), $v_0);
            (this.get_files()).fromJson($v_0);
            delete parentNode.Files;
        }
        $v_0 = parentNode.IsWOPIEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsWOPIEnabled'] = $v_0;
            delete parentNode.IsWOPIEnabled;
        }
        $v_0 = parentNode.ListItemAllFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ListItemAllFields', this.get_listItemAllFields(), $v_0);
            (this.get_listItemAllFields()).fromJson($v_0);
            delete parentNode.ListItemAllFields;
        }
        $v_0 = parentNode.ItemCount;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemCount'] = $v_0;
            delete parentNode.ItemCount;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.ParentFolder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ParentFolder', this.get_parentFolder(), $v_0);
            (this.get_parentFolder()).fromJson($v_0);
            delete parentNode.ParentFolder;
        }
        $v_0 = parentNode.ProgID;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ProgID'] = $v_0;
            delete parentNode.ProgID;
        }
        $v_0 = parentNode.Properties;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Properties', this.get_properties(), $v_0);
            (this.get_properties()).fromJson($v_0);
            delete parentNode.Properties;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.StorageMetrics;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('StorageMetrics', this.get_storageMetrics(), $v_0);
            (this.get_storageMetrics()).fromJson($v_0);
            delete parentNode.StorageMetrics;
        }
        $v_0 = parentNode.Folders;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Folders', this.get_folders(), $v_0);
            (this.get_folders()).fromJson($v_0);
            delete parentNode.Folders;
        }
        $v_0 = parentNode.TimeCreated;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TimeCreated'] = $v_0;
            delete parentNode.TimeCreated;
        }
        $v_0 = parentNode.TimeLastModified;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TimeLastModified'] = $v_0;
            delete parentNode.TimeLastModified;
        }
        $v_0 = parentNode.UniqueContentTypeOrder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UniqueContentTypeOrder'] = [];
            SP.DataConvert.populateArray(this.get_context(), ((this.get_objectData()).get_properties())['UniqueContentTypeOrder'], $v_0);
            delete parentNode.UniqueContentTypeOrder;
        }
        $v_0 = parentNode.UniqueId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UniqueId'] = $v_0;
            delete parentNode.UniqueId;
        }
        $v_0 = parentNode.WelcomePage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WelcomePage'] = $v_0;
            delete parentNode.WelcomePage;
        }
    },
    getListItemChanges: function SP_Folder$getListItemChanges(query) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ChangeCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetListItemChanges', [query]));
        return $v_1;
    },
    update: function SP_Folder$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    },
    moveTo: function SP_Folder$moveTo(newUrl) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'MoveTo', [newUrl]);

        $v_0.addQuery($v_1);
    },
    deleteObject: function SP_Folder$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    },
    recycle: function SP_Folder$recycle() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'Recycle', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        this.removeFromParentCollection();
        return $v_1;
    }
};
SP.FolderPropertyNames = function SP_FolderPropertyNames() {
};
SP.FolderObjectPropertyNames = function SP_FolderObjectPropertyNames() {
};
SP.FolderCollection = function SP_FolderCollection(context, objectPath) {
    SP.FolderCollection.initializeBase(this, [context, objectPath]);
};
SP.FolderCollection.prototype = {
    itemAt: function SP_FolderCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_FolderCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_FolderCollection$get_childItemType() {
        return SP.Folder;
    },
    getByUrl: function SP_FolderCollection$getByUrl(url) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByUrl'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByUrl'] = $v_2;
        }
        $v_1 = $v_2[url];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Folder($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByUrl', [url]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[url] = $v_1;
        }
        return $v_1;
    },
    add: function SP_FolderCollection$add(url) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Folder($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [url]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    },
    addWithOverwrite: function SP_FolderCollection$addWithOverwrite(url, overwrite) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Folder($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'AddWithOverwrite', [url, overwrite]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    }
};
SP.FolderEntityData = function SP_FolderEntityData() {
    SP.FolderEntityData.initializeBase(this);
};
SP.FolderEntityData.prototype = {
    $l_1: false,
    $N_1: null,
    get_overwrite: function SP_FolderEntityData$get_overwrite() {
        return this.$l_1;
    },
    set_overwrite: function SP_FolderEntityData$set_overwrite(value) {
        this.$l_1 = value;
        return value;
    },
    get_serverRelativeUrl: function SP_FolderEntityData$get_serverRelativeUrl() {
        return this.$N_1;
    },
    set_serverRelativeUrl: function SP_FolderEntityData$set_serverRelativeUrl(value) {
        this.$N_1 = value;
        return value;
    },
    get_typeId: function SP_FolderEntityData$get_typeId() {
        return '{0ffbd1db-e28a-42aa-a6ba-ccf4f2626a6b}';
    },
    writeToXml: function SP_FolderEntityData$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Overwrite', 'ServerRelativeUrl'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_FolderEntityData$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Overwrite;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$l_1 = $v_0;
            delete parentNode.Overwrite;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$N_1 = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
    }
};
SP.Form = function SP_Form(context, objectPath) {
    SP.Form.initializeBase(this, [context, objectPath]);
};
SP.Form.prototype = {
    get_id: function SP_Form$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_serverRelativeUrl: function SP_Form$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    get_formType: function SP_Form$get_formType() {
        this.checkUninitializedProperty('FormType');
        return ((this.get_objectData()).get_properties())['FormType'];
    },
    initPropertiesFromJson: function SP_Form$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.FormType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FormType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.FormType;
        }
    }
};
SP.FormPropertyNames = function SP_FormPropertyNames() {
};
SP.FormCollection = function SP_FormCollection(context, objectPath) {
    SP.FormCollection.initializeBase(this, [context, objectPath]);
};
SP.FormCollection.prototype = {
    itemAt: function SP_FormCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_FormCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_FormCollection$get_childItemType() {
        return SP.Form;
    },
    getByPageType: function SP_FormCollection$getByPageType(formType) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByPageType'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetByPageType'] = $v_2;
        }
        $v_1 = $v_2[formType];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Form($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByPageType', [formType]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[formType] = $v_1;
        }
        return $v_1;
    },
    getById: function SP_FormCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Form($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id.toString()] = $v_1;
        }
        return $v_1;
    }
};
SP.Group = function SP_Group(context, objectPath) {
    SP.Group.initializeBase(this, [context, objectPath]);
};
SP.Group.prototype = {
    $F_2: function SP_Group$$F_2($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Title'] = $p0.$0_1;
        }
    },
    get_allowMembersEditMembership: function SP_Group$get_allowMembersEditMembership() {
        this.checkUninitializedProperty('AllowMembersEditMembership');
        return ((this.get_objectData()).get_properties())['AllowMembersEditMembership'];
    },
    set_allowMembersEditMembership: function SP_Group$set_allowMembersEditMembership(value) {
        ((this.get_objectData()).get_properties())['AllowMembersEditMembership'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowMembersEditMembership', value));
        }
        return value;
    },
    get_allowRequestToJoinLeave: function SP_Group$get_allowRequestToJoinLeave() {
        this.checkUninitializedProperty('AllowRequestToJoinLeave');
        return ((this.get_objectData()).get_properties())['AllowRequestToJoinLeave'];
    },
    set_allowRequestToJoinLeave: function SP_Group$set_allowRequestToJoinLeave(value) {
        ((this.get_objectData()).get_properties())['AllowRequestToJoinLeave'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowRequestToJoinLeave', value));
        }
        return value;
    },
    get_autoAcceptRequestToJoinLeave: function SP_Group$get_autoAcceptRequestToJoinLeave() {
        this.checkUninitializedProperty('AutoAcceptRequestToJoinLeave');
        return ((this.get_objectData()).get_properties())['AutoAcceptRequestToJoinLeave'];
    },
    set_autoAcceptRequestToJoinLeave: function SP_Group$set_autoAcceptRequestToJoinLeave(value) {
        ((this.get_objectData()).get_properties())['AutoAcceptRequestToJoinLeave'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AutoAcceptRequestToJoinLeave', value));
        }
        return value;
    },
    get_canCurrentUserEditMembership: function SP_Group$get_canCurrentUserEditMembership() {
        this.checkUninitializedProperty('CanCurrentUserEditMembership');
        return ((this.get_objectData()).get_properties())['CanCurrentUserEditMembership'];
    },
    get_canCurrentUserManageGroup: function SP_Group$get_canCurrentUserManageGroup() {
        this.checkUninitializedProperty('CanCurrentUserManageGroup');
        return ((this.get_objectData()).get_properties())['CanCurrentUserManageGroup'];
    },
    get_canCurrentUserViewMembership: function SP_Group$get_canCurrentUserViewMembership() {
        this.checkUninitializedProperty('CanCurrentUserViewMembership');
        return ((this.get_objectData()).get_properties())['CanCurrentUserViewMembership'];
    },
    get_description: function SP_Group$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    set_description: function SP_Group$set_description(value) {
        ((this.get_objectData()).get_properties())['Description'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Description', value));
        }
        return value;
    },
    get_onlyAllowMembersViewMembership: function SP_Group$get_onlyAllowMembersViewMembership() {
        this.checkUninitializedProperty('OnlyAllowMembersViewMembership');
        return ((this.get_objectData()).get_properties())['OnlyAllowMembersViewMembership'];
    },
    set_onlyAllowMembersViewMembership: function SP_Group$set_onlyAllowMembersViewMembership(value) {
        ((this.get_objectData()).get_properties())['OnlyAllowMembersViewMembership'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'OnlyAllowMembersViewMembership', value));
        }
        return value;
    },
    get_owner: function SP_Group$get_owner() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Owner'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Principal(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Owner'));
            ((this.get_objectData()).get_clientObjectProperties())['Owner'] = $v_0;
        }
        return $v_0;
    },
    set_owner: function SP_Group$set_owner(value) {
        ((this.get_objectData()).get_clientObjectProperties())['Owner'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Owner', value));
        }
        return value;
    },
    get_ownerTitle: function SP_Group$get_ownerTitle() {
        this.checkUninitializedProperty('OwnerTitle');
        return ((this.get_objectData()).get_properties())['OwnerTitle'];
    },
    get_requestToJoinLeaveEmailSetting: function SP_Group$get_requestToJoinLeaveEmailSetting() {
        this.checkUninitializedProperty('RequestToJoinLeaveEmailSetting');
        return ((this.get_objectData()).get_properties())['RequestToJoinLeaveEmailSetting'];
    },
    set_requestToJoinLeaveEmailSetting: function SP_Group$set_requestToJoinLeaveEmailSetting(value) {
        ((this.get_objectData()).get_properties())['RequestToJoinLeaveEmailSetting'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'RequestToJoinLeaveEmailSetting', value));
        }
        return value;
    },
    get_users: function SP_Group$get_users() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Users'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Users'));
            ((this.get_objectData()).get_clientObjectProperties())['Users'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_Group$initPropertiesFromJson(parentNode) {
        SP.Principal.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowMembersEditMembership;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowMembersEditMembership'] = $v_0;
            delete parentNode.AllowMembersEditMembership;
        }
        $v_0 = parentNode.AllowRequestToJoinLeave;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowRequestToJoinLeave'] = $v_0;
            delete parentNode.AllowRequestToJoinLeave;
        }
        $v_0 = parentNode.AutoAcceptRequestToJoinLeave;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AutoAcceptRequestToJoinLeave'] = $v_0;
            delete parentNode.AutoAcceptRequestToJoinLeave;
        }
        $v_0 = parentNode.CanCurrentUserEditMembership;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserEditMembership'] = $v_0;
            delete parentNode.CanCurrentUserEditMembership;
        }
        $v_0 = parentNode.CanCurrentUserManageGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserManageGroup'] = $v_0;
            delete parentNode.CanCurrentUserManageGroup;
        }
        $v_0 = parentNode.CanCurrentUserViewMembership;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserViewMembership'] = $v_0;
            delete parentNode.CanCurrentUserViewMembership;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.OnlyAllowMembersViewMembership;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['OnlyAllowMembersViewMembership'] = $v_0;
            delete parentNode.OnlyAllowMembersViewMembership;
        }
        $v_0 = parentNode.Owner;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Owner', this.get_owner(), $v_0);
            (this.get_owner()).fromJson($v_0);
            delete parentNode.Owner;
        }
        $v_0 = parentNode.OwnerTitle;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['OwnerTitle'] = $v_0;
            delete parentNode.OwnerTitle;
        }
        $v_0 = parentNode.RequestToJoinLeaveEmailSetting;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RequestToJoinLeaveEmailSetting'] = $v_0;
            delete parentNode.RequestToJoinLeaveEmailSetting;
        }
        $v_0 = parentNode.Users;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Users', this.get_users(), $v_0);
            (this.get_users()).fromJson($v_0);
            delete parentNode.Users;
        }
    },
    update: function SP_Group$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    }
};
SP.GroupPropertyNames = function SP_GroupPropertyNames() {
};
SP.GroupObjectPropertyNames = function SP_GroupObjectPropertyNames() {
};
SP.GroupCollection = function SP_GroupCollection(context, objectPath) {
    SP.GroupCollection.initializeBase(this, [context, objectPath]);
};
SP.GroupCollection.prototype = {
    itemAt: function SP_GroupCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_GroupCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_GroupCollection$get_childItemType() {
        return SP.Group;
    },
    getByName: function SP_GroupCollection$getByName(name) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByName'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByName'] = $v_2;
        }
        $v_1 = $v_2[name];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Group($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByName', [name]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[name] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    getById: function SP_GroupCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Group($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    add: function SP_GroupCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Group($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_2(parameters);
        return $v_1;
    },
    removeByLoginName: function SP_GroupCollection$removeByLoginName(loginName) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RemoveByLoginName', [loginName]);

        $v_0.addQuery($v_1);
    },
    removeById: function SP_GroupCollection$removeById(id) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RemoveById', [id]);

        $v_0.addQuery($v_1);
    },
    remove: function SP_GroupCollection$remove(group) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Remove', [group]);

        $v_0.addQuery($v_1);
        this.removeChild(group);
    }
};
SP.GroupCreationInformation = function SP_GroupCreationInformation() {
    SP.GroupCreationInformation.initializeBase(this);
};
SP.GroupCreationInformation.prototype = {
    $2_1: null,
    $0_1: null,
    get_description: function SP_GroupCreationInformation$get_description() {
        return this.$2_1;
    },
    set_description: function SP_GroupCreationInformation$set_description(value) {
        this.$2_1 = value;
        return value;
    },
    get_title: function SP_GroupCreationInformation$get_title() {
        return this.$0_1;
    },
    set_title: function SP_GroupCreationInformation$set_title(value) {
        this.$0_1 = value;
        return value;
    },
    get_typeId: function SP_GroupCreationInformation$get_typeId() {
        return '{9fd1540e-59e6-47fa-9a00-5173c9c35785}';
    },
    writeToXml: function SP_GroupCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Description', 'Title'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_GroupCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2_1 = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
    }
};
SP.InformationRightsManagementFileSettings = function SP_InformationRightsManagementFileSettings(context, objectPath) {
    SP.InformationRightsManagementFileSettings.initializeBase(this, [context, objectPath]);
};
SP.InformationRightsManagementFileSettings.prototype = {
    get_allowPrint: function SP_InformationRightsManagementFileSettings$get_allowPrint() {
        this.checkUninitializedProperty('AllowPrint');
        return ((this.get_objectData()).get_properties())['AllowPrint'];
    },
    set_allowPrint: function SP_InformationRightsManagementFileSettings$set_allowPrint(value) {
        ((this.get_objectData()).get_properties())['AllowPrint'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowPrint', value));
        }
        return value;
    },
    get_allowScript: function SP_InformationRightsManagementFileSettings$get_allowScript() {
        this.checkUninitializedProperty('AllowScript');
        return ((this.get_objectData()).get_properties())['AllowScript'];
    },
    set_allowScript: function SP_InformationRightsManagementFileSettings$set_allowScript(value) {
        ((this.get_objectData()).get_properties())['AllowScript'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowScript', value));
        }
        return value;
    },
    get_allowWriteCopy: function SP_InformationRightsManagementFileSettings$get_allowWriteCopy() {
        this.checkUninitializedProperty('AllowWriteCopy');
        return ((this.get_objectData()).get_properties())['AllowWriteCopy'];
    },
    set_allowWriteCopy: function SP_InformationRightsManagementFileSettings$set_allowWriteCopy(value) {
        ((this.get_objectData()).get_properties())['AllowWriteCopy'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowWriteCopy', value));
        }
        return value;
    },
    get_disableDocumentBrowserView: function SP_InformationRightsManagementFileSettings$get_disableDocumentBrowserView() {
        this.checkUninitializedProperty('DisableDocumentBrowserView');
        return ((this.get_objectData()).get_properties())['DisableDocumentBrowserView'];
    },
    set_disableDocumentBrowserView: function SP_InformationRightsManagementFileSettings$set_disableDocumentBrowserView(value) {
        ((this.get_objectData()).get_properties())['DisableDocumentBrowserView'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DisableDocumentBrowserView', value));
        }
        return value;
    },
    get_documentAccessExpireDays: function SP_InformationRightsManagementFileSettings$get_documentAccessExpireDays() {
        this.checkUninitializedProperty('DocumentAccessExpireDays');
        return ((this.get_objectData()).get_properties())['DocumentAccessExpireDays'];
    },
    set_documentAccessExpireDays: function SP_InformationRightsManagementFileSettings$set_documentAccessExpireDays(value) {
        ((this.get_objectData()).get_properties())['DocumentAccessExpireDays'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DocumentAccessExpireDays', value));
        }
        return value;
    },
    get_enableDocumentAccessExpire: function SP_InformationRightsManagementFileSettings$get_enableDocumentAccessExpire() {
        this.checkUninitializedProperty('EnableDocumentAccessExpire');
        return ((this.get_objectData()).get_properties())['EnableDocumentAccessExpire'];
    },
    set_enableDocumentAccessExpire: function SP_InformationRightsManagementFileSettings$set_enableDocumentAccessExpire(value) {
        ((this.get_objectData()).get_properties())['EnableDocumentAccessExpire'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableDocumentAccessExpire', value));
        }
        return value;
    },
    get_enableDocumentBrowserPublishingView: function SP_InformationRightsManagementFileSettings$get_enableDocumentBrowserPublishingView() {
        this.checkUninitializedProperty('EnableDocumentBrowserPublishingView');
        return ((this.get_objectData()).get_properties())['EnableDocumentBrowserPublishingView'];
    },
    set_enableDocumentBrowserPublishingView: function SP_InformationRightsManagementFileSettings$set_enableDocumentBrowserPublishingView(value) {
        ((this.get_objectData()).get_properties())['EnableDocumentBrowserPublishingView'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableDocumentBrowserPublishingView', value));
        }
        return value;
    },
    get_enableGroupProtection: function SP_InformationRightsManagementFileSettings$get_enableGroupProtection() {
        this.checkUninitializedProperty('EnableGroupProtection');
        return ((this.get_objectData()).get_properties())['EnableGroupProtection'];
    },
    set_enableGroupProtection: function SP_InformationRightsManagementFileSettings$set_enableGroupProtection(value) {
        ((this.get_objectData()).get_properties())['EnableGroupProtection'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableGroupProtection', value));
        }
        return value;
    },
    get_enableLicenseCacheExpire: function SP_InformationRightsManagementFileSettings$get_enableLicenseCacheExpire() {
        this.checkUninitializedProperty('EnableLicenseCacheExpire');
        return ((this.get_objectData()).get_properties())['EnableLicenseCacheExpire'];
    },
    set_enableLicenseCacheExpire: function SP_InformationRightsManagementFileSettings$set_enableLicenseCacheExpire(value) {
        ((this.get_objectData()).get_properties())['EnableLicenseCacheExpire'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableLicenseCacheExpire', value));
        }
        return value;
    },
    get_groupName: function SP_InformationRightsManagementFileSettings$get_groupName() {
        this.checkUninitializedProperty('GroupName');
        return ((this.get_objectData()).get_properties())['GroupName'];
    },
    set_groupName: function SP_InformationRightsManagementFileSettings$set_groupName(value) {
        ((this.get_objectData()).get_properties())['GroupName'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'GroupName', value));
        }
        return value;
    },
    get_licenseCacheExpireDays: function SP_InformationRightsManagementFileSettings$get_licenseCacheExpireDays() {
        this.checkUninitializedProperty('LicenseCacheExpireDays');
        return ((this.get_objectData()).get_properties())['LicenseCacheExpireDays'];
    },
    set_licenseCacheExpireDays: function SP_InformationRightsManagementFileSettings$set_licenseCacheExpireDays(value) {
        ((this.get_objectData()).get_properties())['LicenseCacheExpireDays'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'LicenseCacheExpireDays', value));
        }
        return value;
    },
    get_policyDescription: function SP_InformationRightsManagementFileSettings$get_policyDescription() {
        this.checkUninitializedProperty('PolicyDescription');
        return ((this.get_objectData()).get_properties())['PolicyDescription'];
    },
    set_policyDescription: function SP_InformationRightsManagementFileSettings$set_policyDescription(value) {
        ((this.get_objectData()).get_properties())['PolicyDescription'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'PolicyDescription', value));
        }
        return value;
    },
    get_policyTitle: function SP_InformationRightsManagementFileSettings$get_policyTitle() {
        this.checkUninitializedProperty('PolicyTitle');
        return ((this.get_objectData()).get_properties())['PolicyTitle'];
    },
    set_policyTitle: function SP_InformationRightsManagementFileSettings$set_policyTitle(value) {
        ((this.get_objectData()).get_properties())['PolicyTitle'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'PolicyTitle', value));
        }
        return value;
    },
    get_templateId: function SP_InformationRightsManagementFileSettings$get_templateId() {
        this.checkUninitializedProperty('TemplateId');
        return ((this.get_objectData()).get_properties())['TemplateId'];
    },
    set_templateId: function SP_InformationRightsManagementFileSettings$set_templateId(value) {
        ((this.get_objectData()).get_properties())['TemplateId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'TemplateId', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_InformationRightsManagementFileSettings$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowPrint;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowPrint'] = $v_0;
            delete parentNode.AllowPrint;
        }
        $v_0 = parentNode.AllowScript;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowScript'] = $v_0;
            delete parentNode.AllowScript;
        }
        $v_0 = parentNode.AllowWriteCopy;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowWriteCopy'] = $v_0;
            delete parentNode.AllowWriteCopy;
        }
        $v_0 = parentNode.DisableDocumentBrowserView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisableDocumentBrowserView'] = $v_0;
            delete parentNode.DisableDocumentBrowserView;
        }
        $v_0 = parentNode.DocumentAccessExpireDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentAccessExpireDays'] = $v_0;
            delete parentNode.DocumentAccessExpireDays;
        }
        $v_0 = parentNode.EnableDocumentAccessExpire;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableDocumentAccessExpire'] = $v_0;
            delete parentNode.EnableDocumentAccessExpire;
        }
        $v_0 = parentNode.EnableDocumentBrowserPublishingView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableDocumentBrowserPublishingView'] = $v_0;
            delete parentNode.EnableDocumentBrowserPublishingView;
        }
        $v_0 = parentNode.EnableGroupProtection;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableGroupProtection'] = $v_0;
            delete parentNode.EnableGroupProtection;
        }
        $v_0 = parentNode.EnableLicenseCacheExpire;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableLicenseCacheExpire'] = $v_0;
            delete parentNode.EnableLicenseCacheExpire;
        }
        $v_0 = parentNode.GroupName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GroupName'] = $v_0;
            delete parentNode.GroupName;
        }
        $v_0 = parentNode.LicenseCacheExpireDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LicenseCacheExpireDays'] = $v_0;
            delete parentNode.LicenseCacheExpireDays;
        }
        $v_0 = parentNode.PolicyDescription;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PolicyDescription'] = $v_0;
            delete parentNode.PolicyDescription;
        }
        $v_0 = parentNode.PolicyTitle;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PolicyTitle'] = $v_0;
            delete parentNode.PolicyTitle;
        }
        $v_0 = parentNode.TemplateId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TemplateId'] = $v_0;
            delete parentNode.TemplateId;
        }
    },
    reset: function SP_InformationRightsManagementFileSettings$reset() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Reset', null);

        $v_0.addQuery($v_1);
    },
    update: function SP_InformationRightsManagementFileSettings$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    }
};
SP.InformationRightsManagementFileSettingsPropertyNames = function SP_InformationRightsManagementFileSettingsPropertyNames() {
};
SP.InformationRightsManagementSettings = function SP_InformationRightsManagementSettings(context, objectPath) {
    SP.InformationRightsManagementSettings.initializeBase(this, [context, objectPath]);
};
SP.InformationRightsManagementSettings.prototype = {
    get_allowPrint: function SP_InformationRightsManagementSettings$get_allowPrint() {
        this.checkUninitializedProperty('AllowPrint');
        return ((this.get_objectData()).get_properties())['AllowPrint'];
    },
    set_allowPrint: function SP_InformationRightsManagementSettings$set_allowPrint(value) {
        ((this.get_objectData()).get_properties())['AllowPrint'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowPrint', value));
        }
        return value;
    },
    get_allowScript: function SP_InformationRightsManagementSettings$get_allowScript() {
        this.checkUninitializedProperty('AllowScript');
        return ((this.get_objectData()).get_properties())['AllowScript'];
    },
    set_allowScript: function SP_InformationRightsManagementSettings$set_allowScript(value) {
        ((this.get_objectData()).get_properties())['AllowScript'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowScript', value));
        }
        return value;
    },
    get_allowWriteCopy: function SP_InformationRightsManagementSettings$get_allowWriteCopy() {
        this.checkUninitializedProperty('AllowWriteCopy');
        return ((this.get_objectData()).get_properties())['AllowWriteCopy'];
    },
    set_allowWriteCopy: function SP_InformationRightsManagementSettings$set_allowWriteCopy(value) {
        ((this.get_objectData()).get_properties())['AllowWriteCopy'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowWriteCopy', value));
        }
        return value;
    },
    get_disableDocumentBrowserView: function SP_InformationRightsManagementSettings$get_disableDocumentBrowserView() {
        this.checkUninitializedProperty('DisableDocumentBrowserView');
        return ((this.get_objectData()).get_properties())['DisableDocumentBrowserView'];
    },
    set_disableDocumentBrowserView: function SP_InformationRightsManagementSettings$set_disableDocumentBrowserView(value) {
        ((this.get_objectData()).get_properties())['DisableDocumentBrowserView'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DisableDocumentBrowserView', value));
        }
        return value;
    },
    get_documentAccessExpireDays: function SP_InformationRightsManagementSettings$get_documentAccessExpireDays() {
        this.checkUninitializedProperty('DocumentAccessExpireDays');
        return ((this.get_objectData()).get_properties())['DocumentAccessExpireDays'];
    },
    set_documentAccessExpireDays: function SP_InformationRightsManagementSettings$set_documentAccessExpireDays(value) {
        ((this.get_objectData()).get_properties())['DocumentAccessExpireDays'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DocumentAccessExpireDays', value));
        }
        return value;
    },
    get_documentLibraryProtectionExpireDate: function SP_InformationRightsManagementSettings$get_documentLibraryProtectionExpireDate() {
        this.checkUninitializedProperty('DocumentLibraryProtectionExpireDate');
        return ((this.get_objectData()).get_properties())['DocumentLibraryProtectionExpireDate'];
    },
    set_documentLibraryProtectionExpireDate: function SP_InformationRightsManagementSettings$set_documentLibraryProtectionExpireDate(value) {
        ((this.get_objectData()).get_properties())['DocumentLibraryProtectionExpireDate'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DocumentLibraryProtectionExpireDate', value));
        }
        return value;
    },
    get_enableDocumentAccessExpire: function SP_InformationRightsManagementSettings$get_enableDocumentAccessExpire() {
        this.checkUninitializedProperty('EnableDocumentAccessExpire');
        return ((this.get_objectData()).get_properties())['EnableDocumentAccessExpire'];
    },
    set_enableDocumentAccessExpire: function SP_InformationRightsManagementSettings$set_enableDocumentAccessExpire(value) {
        ((this.get_objectData()).get_properties())['EnableDocumentAccessExpire'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableDocumentAccessExpire', value));
        }
        return value;
    },
    get_enableDocumentBrowserPublishingView: function SP_InformationRightsManagementSettings$get_enableDocumentBrowserPublishingView() {
        this.checkUninitializedProperty('EnableDocumentBrowserPublishingView');
        return ((this.get_objectData()).get_properties())['EnableDocumentBrowserPublishingView'];
    },
    set_enableDocumentBrowserPublishingView: function SP_InformationRightsManagementSettings$set_enableDocumentBrowserPublishingView(value) {
        ((this.get_objectData()).get_properties())['EnableDocumentBrowserPublishingView'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableDocumentBrowserPublishingView', value));
        }
        return value;
    },
    get_enableGroupProtection: function SP_InformationRightsManagementSettings$get_enableGroupProtection() {
        this.checkUninitializedProperty('EnableGroupProtection');
        return ((this.get_objectData()).get_properties())['EnableGroupProtection'];
    },
    set_enableGroupProtection: function SP_InformationRightsManagementSettings$set_enableGroupProtection(value) {
        ((this.get_objectData()).get_properties())['EnableGroupProtection'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableGroupProtection', value));
        }
        return value;
    },
    get_enableLicenseCacheExpire: function SP_InformationRightsManagementSettings$get_enableLicenseCacheExpire() {
        this.checkUninitializedProperty('EnableLicenseCacheExpire');
        return ((this.get_objectData()).get_properties())['EnableLicenseCacheExpire'];
    },
    set_enableLicenseCacheExpire: function SP_InformationRightsManagementSettings$set_enableLicenseCacheExpire(value) {
        ((this.get_objectData()).get_properties())['EnableLicenseCacheExpire'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableLicenseCacheExpire', value));
        }
        return value;
    },
    get_groupName: function SP_InformationRightsManagementSettings$get_groupName() {
        this.checkUninitializedProperty('GroupName');
        return ((this.get_objectData()).get_properties())['GroupName'];
    },
    set_groupName: function SP_InformationRightsManagementSettings$set_groupName(value) {
        ((this.get_objectData()).get_properties())['GroupName'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'GroupName', value));
        }
        return value;
    },
    get_licenseCacheExpireDays: function SP_InformationRightsManagementSettings$get_licenseCacheExpireDays() {
        this.checkUninitializedProperty('LicenseCacheExpireDays');
        return ((this.get_objectData()).get_properties())['LicenseCacheExpireDays'];
    },
    set_licenseCacheExpireDays: function SP_InformationRightsManagementSettings$set_licenseCacheExpireDays(value) {
        ((this.get_objectData()).get_properties())['LicenseCacheExpireDays'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'LicenseCacheExpireDays', value));
        }
        return value;
    },
    get_policyDescription: function SP_InformationRightsManagementSettings$get_policyDescription() {
        this.checkUninitializedProperty('PolicyDescription');
        return ((this.get_objectData()).get_properties())['PolicyDescription'];
    },
    set_policyDescription: function SP_InformationRightsManagementSettings$set_policyDescription(value) {
        ((this.get_objectData()).get_properties())['PolicyDescription'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'PolicyDescription', value));
        }
        return value;
    },
    get_policyTitle: function SP_InformationRightsManagementSettings$get_policyTitle() {
        this.checkUninitializedProperty('PolicyTitle');
        return ((this.get_objectData()).get_properties())['PolicyTitle'];
    },
    set_policyTitle: function SP_InformationRightsManagementSettings$set_policyTitle(value) {
        ((this.get_objectData()).get_properties())['PolicyTitle'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'PolicyTitle', value));
        }
        return value;
    },
    get_templateId: function SP_InformationRightsManagementSettings$get_templateId() {
        this.checkUninitializedProperty('TemplateId');
        return ((this.get_objectData()).get_properties())['TemplateId'];
    },
    set_templateId: function SP_InformationRightsManagementSettings$set_templateId(value) {
        ((this.get_objectData()).get_properties())['TemplateId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'TemplateId', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_InformationRightsManagementSettings$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowPrint;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowPrint'] = $v_0;
            delete parentNode.AllowPrint;
        }
        $v_0 = parentNode.AllowScript;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowScript'] = $v_0;
            delete parentNode.AllowScript;
        }
        $v_0 = parentNode.AllowWriteCopy;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowWriteCopy'] = $v_0;
            delete parentNode.AllowWriteCopy;
        }
        $v_0 = parentNode.DisableDocumentBrowserView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisableDocumentBrowserView'] = $v_0;
            delete parentNode.DisableDocumentBrowserView;
        }
        $v_0 = parentNode.DocumentAccessExpireDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentAccessExpireDays'] = $v_0;
            delete parentNode.DocumentAccessExpireDays;
        }
        $v_0 = parentNode.DocumentLibraryProtectionExpireDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentLibraryProtectionExpireDate'] = $v_0;
            delete parentNode.DocumentLibraryProtectionExpireDate;
        }
        $v_0 = parentNode.EnableDocumentAccessExpire;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableDocumentAccessExpire'] = $v_0;
            delete parentNode.EnableDocumentAccessExpire;
        }
        $v_0 = parentNode.EnableDocumentBrowserPublishingView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableDocumentBrowserPublishingView'] = $v_0;
            delete parentNode.EnableDocumentBrowserPublishingView;
        }
        $v_0 = parentNode.EnableGroupProtection;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableGroupProtection'] = $v_0;
            delete parentNode.EnableGroupProtection;
        }
        $v_0 = parentNode.EnableLicenseCacheExpire;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableLicenseCacheExpire'] = $v_0;
            delete parentNode.EnableLicenseCacheExpire;
        }
        $v_0 = parentNode.GroupName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GroupName'] = $v_0;
            delete parentNode.GroupName;
        }
        $v_0 = parentNode.LicenseCacheExpireDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LicenseCacheExpireDays'] = $v_0;
            delete parentNode.LicenseCacheExpireDays;
        }
        $v_0 = parentNode.PolicyDescription;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PolicyDescription'] = $v_0;
            delete parentNode.PolicyDescription;
        }
        $v_0 = parentNode.PolicyTitle;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PolicyTitle'] = $v_0;
            delete parentNode.PolicyTitle;
        }
        $v_0 = parentNode.TemplateId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TemplateId'] = $v_0;
            delete parentNode.TemplateId;
        }
    },
    reset: function SP_InformationRightsManagementSettings$reset() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Reset', null);

        $v_0.addQuery($v_1);
    },
    update: function SP_InformationRightsManagementSettings$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    }
};
SP.InformationRightsManagementSettingsPropertyNames = function SP_InformationRightsManagementSettingsPropertyNames() {
};
SP.IngestionTaskKey = function SP_IngestionTaskKey() {
    SP.IngestionTaskKey.initializeBase(this);
};
SP.IngestionTaskKey.prototype = {
    $47_1: null,
    $48_1: null,
    $4C_1: null,
    $5E_1: null,
    $5G_1: null,
    get_ingestionTableAccountKey: function SP_IngestionTaskKey$get_ingestionTableAccountKey() {
        return this.$47_1;
    },
    set_ingestionTableAccountKey: function SP_IngestionTaskKey$set_ingestionTableAccountKey(value) {
        this.$47_1 = value;
        return value;
    },
    get_ingestionTableAccountName: function SP_IngestionTaskKey$get_ingestionTableAccountName() {
        return this.$48_1;
    },
    set_ingestionTableAccountName: function SP_IngestionTaskKey$set_ingestionTableAccountName(value) {
        this.$48_1 = value;
        return value;
    },
    get_jobId: function SP_IngestionTaskKey$get_jobId() {
        return this.$4C_1;
    },
    set_jobId: function SP_IngestionTaskKey$set_jobId(value) {
        this.$4C_1 = value;
        return value;
    },
    get_taskId: function SP_IngestionTaskKey$get_taskId() {
        return this.$5E_1;
    },
    set_taskId: function SP_IngestionTaskKey$set_taskId(value) {
        this.$5E_1 = value;
        return value;
    },
    get_tenantName: function SP_IngestionTaskKey$get_tenantName() {
        return this.$5G_1;
    },
    set_tenantName: function SP_IngestionTaskKey$set_tenantName(value) {
        this.$5G_1 = value;
        return value;
    },
    get_typeId: function SP_IngestionTaskKey$get_typeId() {
        return '{3314041b-e208-4492-a0e9-a275fa3f6204}';
    },
    writeToXml: function SP_IngestionTaskKey$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['IngestionTableAccountKey', 'IngestionTableAccountName', 'JobId', 'TaskId', 'TenantName'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_IngestionTaskKey$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.IngestionTableAccountKey;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$47_1 = $v_0;
            delete parentNode.IngestionTableAccountKey;
        }
        $v_0 = parentNode.IngestionTableAccountName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$48_1 = $v_0;
            delete parentNode.IngestionTableAccountName;
        }
        $v_0 = parentNode.JobId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4C_1 = $v_0;
            delete parentNode.JobId;
        }
        $v_0 = parentNode.TaskId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5E_1 = $v_0;
            delete parentNode.TaskId;
        }
        $v_0 = parentNode.TenantName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5G_1 = $v_0;
            delete parentNode.TenantName;
        }
    }
};
SP.Language = function SP_Language() {
    SP.Language.initializeBase(this);
};
SP.Language.prototype = {
    $H_1: null,
    $6N_1: null,
    $6Q_1: 0,
    get_displayName: function SP_Language$get_displayName() {
        return this.$H_1;
    },
    get_languageTag: function SP_Language$get_languageTag() {
        return this.$6N_1;
    },
    get_lcid: function SP_Language$get_lcid() {
        return this.$6Q_1;
    },
    get_typeId: function SP_Language$get_typeId() {
        return '{eae9f1b5-1ae9-417b-9a8b-04a1b4c05a4b}';
    },
    writeToXml: function SP_Language$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['DisplayName', 'LanguageTag', 'Lcid'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_Language$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DisplayName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$H_1 = $v_0;
            delete parentNode.DisplayName;
        }
        $v_0 = parentNode.LanguageTag;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6N_1 = $v_0;
            delete parentNode.LanguageTag;
        }
        $v_0 = parentNode.Lcid;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6Q_1 = $v_0;
            delete parentNode.Lcid;
        }
    }
};
SP.List = function SP_List(context, objectPath) {
    SP.List.initializeBase(this, [context, objectPath]);
};
SP.List.prototype = {
    $F_2: function SP_List$$F_2($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Description'] = $p0.$2_1;
            ((this.get_objectData()).get_properties())['TemplateFeatureId'] = $p0.$1i_1;
            ((this.get_objectData()).get_properties())['Title'] = $p0.$0_1;
        }
    },
    getItemById: function SP_List$getItemById(id) {
        if (typeof id === 'string') {
            return this.$7g_2(id.toString());
        }
        else {
            id = parseInt(id.toString());
            var $v_0;
            var $v_1 = ((this.get_objectData()).get_methodReturnObjects())['GetItemById'];

            if (SP.ScriptUtility.isNullOrUndefined($v_1)) {
                $v_1 = [];
                ((this.get_objectData()).get_methodReturnObjects())['GetItemById'] = $v_1;
            }
            $v_0 = $v_1[id];
            if (!SP.ScriptUtility.isNullOrUndefined($v_0)) {
                return $v_0;
            }
            $v_0 = new SP.ListItem(this.get_context(), new SP.ObjectPathMethod(this.get_context(), this.get_path(), 'GetItemById', [id]));
            $v_1[id] = $v_0;
            return $v_0;
        }
    },
    get_allowContentTypes: function SP_List$get_allowContentTypes() {
        this.checkUninitializedProperty('AllowContentTypes');
        return ((this.get_objectData()).get_properties())['AllowContentTypes'];
    },
    get_baseTemplate: function SP_List$get_baseTemplate() {
        this.checkUninitializedProperty('BaseTemplate');
        return ((this.get_objectData()).get_properties())['BaseTemplate'];
    },
    get_baseType: function SP_List$get_baseType() {
        this.checkUninitializedProperty('BaseType');
        return ((this.get_objectData()).get_properties())['BaseType'];
    },
    get_browserFileHandling: function SP_List$get_browserFileHandling() {
        this.checkUninitializedProperty('BrowserFileHandling');
        return ((this.get_objectData()).get_properties())['BrowserFileHandling'];
    },
    get_contentTypes: function SP_List$get_contentTypes() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ContentTypes'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ContentTypeCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ContentTypes'));
            ((this.get_objectData()).get_clientObjectProperties())['ContentTypes'] = $v_0;
        }
        return $v_0;
    },
    get_contentTypesEnabled: function SP_List$get_contentTypesEnabled() {
        this.checkUninitializedProperty('ContentTypesEnabled');
        return ((this.get_objectData()).get_properties())['ContentTypesEnabled'];
    },
    set_contentTypesEnabled: function SP_List$set_contentTypesEnabled(value) {
        ((this.get_objectData()).get_properties())['ContentTypesEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ContentTypesEnabled', value));
        }
        return value;
    },
    get_crawlNonDefaultViews: function SP_List$get_crawlNonDefaultViews() {
        this.checkUninitializedProperty('CrawlNonDefaultViews');
        return ((this.get_objectData()).get_properties())['CrawlNonDefaultViews'];
    },
    set_crawlNonDefaultViews: function SP_List$set_crawlNonDefaultViews(value) {
        ((this.get_objectData()).get_properties())['CrawlNonDefaultViews'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'CrawlNonDefaultViews', value));
        }
        return value;
    },
    get_creatablesInfo: function SP_List$get_creatablesInfo() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['CreatablesInfo'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.CreatablesInfo(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'CreatablesInfo'));
            ((this.get_objectData()).get_clientObjectProperties())['CreatablesInfo'] = $v_0;
        }
        return $v_0;
    },
    get_created: function SP_List$get_created() {
        this.checkUninitializedProperty('Created');
        return ((this.get_objectData()).get_properties())['Created'];
    },
    get_currentChangeToken: function SP_List$get_currentChangeToken() {
        this.checkUninitializedProperty('CurrentChangeToken');
        return ((this.get_objectData()).get_properties())['CurrentChangeToken'];
    },
    get_dataSource: function SP_List$get_dataSource() {
        this.checkUninitializedProperty('DataSource');
        return ((this.get_objectData()).get_properties())['DataSource'];
    },
    get_defaultContentApprovalWorkflowId: function SP_List$get_defaultContentApprovalWorkflowId() {
        this.checkUninitializedProperty('DefaultContentApprovalWorkflowId');
        return ((this.get_objectData()).get_properties())['DefaultContentApprovalWorkflowId'];
    },
    set_defaultContentApprovalWorkflowId: function SP_List$set_defaultContentApprovalWorkflowId(value) {
        ((this.get_objectData()).get_properties())['DefaultContentApprovalWorkflowId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DefaultContentApprovalWorkflowId', value));
        }
        return value;
    },
    get_defaultDisplayFormUrl: function SP_List$get_defaultDisplayFormUrl() {
        this.checkUninitializedProperty('DefaultDisplayFormUrl');
        return ((this.get_objectData()).get_properties())['DefaultDisplayFormUrl'];
    },
    set_defaultDisplayFormUrl: function SP_List$set_defaultDisplayFormUrl(value) {
        ((this.get_objectData()).get_properties())['DefaultDisplayFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DefaultDisplayFormUrl', value));
        }
        return value;
    },
    get_defaultEditFormUrl: function SP_List$get_defaultEditFormUrl() {
        this.checkUninitializedProperty('DefaultEditFormUrl');
        return ((this.get_objectData()).get_properties())['DefaultEditFormUrl'];
    },
    set_defaultEditFormUrl: function SP_List$set_defaultEditFormUrl(value) {
        ((this.get_objectData()).get_properties())['DefaultEditFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DefaultEditFormUrl', value));
        }
        return value;
    },
    get_defaultNewFormUrl: function SP_List$get_defaultNewFormUrl() {
        this.checkUninitializedProperty('DefaultNewFormUrl');
        return ((this.get_objectData()).get_properties())['DefaultNewFormUrl'];
    },
    set_defaultNewFormUrl: function SP_List$set_defaultNewFormUrl(value) {
        ((this.get_objectData()).get_properties())['DefaultNewFormUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DefaultNewFormUrl', value));
        }
        return value;
    },
    get_defaultView: function SP_List$get_defaultView() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['DefaultView'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.View(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'DefaultView'));
            ((this.get_objectData()).get_clientObjectProperties())['DefaultView'] = $v_0;
        }
        return $v_0;
    },
    get_defaultViewUrl: function SP_List$get_defaultViewUrl() {
        this.checkUninitializedProperty('DefaultViewUrl');
        return ((this.get_objectData()).get_properties())['DefaultViewUrl'];
    },
    get_description: function SP_List$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    set_description: function SP_List$set_description(value) {
        ((this.get_objectData()).get_properties())['Description'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Description', value));
        }
        return value;
    },
    get_descriptionResource: function SP_List$get_descriptionResource() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['DescriptionResource'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserResource(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'DescriptionResource'));
            ((this.get_objectData()).get_clientObjectProperties())['DescriptionResource'] = $v_0;
        }
        return $v_0;
    },
    get_direction: function SP_List$get_direction() {
        this.checkUninitializedProperty('Direction');
        return ((this.get_objectData()).get_properties())['Direction'];
    },
    set_direction: function SP_List$set_direction(value) {
        ((this.get_objectData()).get_properties())['Direction'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Direction', value));
        }
        return value;
    },
    get_documentTemplateUrl: function SP_List$get_documentTemplateUrl() {
        this.checkUninitializedProperty('DocumentTemplateUrl');
        return ((this.get_objectData()).get_properties())['DocumentTemplateUrl'];
    },
    set_documentTemplateUrl: function SP_List$set_documentTemplateUrl(value) {
        ((this.get_objectData()).get_properties())['DocumentTemplateUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DocumentTemplateUrl', value));
        }
        return value;
    },
    get_draftVersionVisibility: function SP_List$get_draftVersionVisibility() {
        this.checkUninitializedProperty('DraftVersionVisibility');
        return ((this.get_objectData()).get_properties())['DraftVersionVisibility'];
    },
    set_draftVersionVisibility: function SP_List$set_draftVersionVisibility(value) {
        ((this.get_objectData()).get_properties())['DraftVersionVisibility'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DraftVersionVisibility', value));
        }
        return value;
    },
    get_effectiveBasePermissions: function SP_List$get_effectiveBasePermissions() {
        this.checkUninitializedProperty('EffectiveBasePermissions');
        return ((this.get_objectData()).get_properties())['EffectiveBasePermissions'];
    },
    get_effectiveBasePermissionsForUI: function SP_List$get_effectiveBasePermissionsForUI() {
        this.checkUninitializedProperty('EffectiveBasePermissionsForUI');
        return ((this.get_objectData()).get_properties())['EffectiveBasePermissionsForUI'];
    },
    get_enableAttachments: function SP_List$get_enableAttachments() {
        this.checkUninitializedProperty('EnableAttachments');
        return ((this.get_objectData()).get_properties())['EnableAttachments'];
    },
    set_enableAttachments: function SP_List$set_enableAttachments(value) {
        ((this.get_objectData()).get_properties())['EnableAttachments'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableAttachments', value));
        }
        return value;
    },
    get_enableFolderCreation: function SP_List$get_enableFolderCreation() {
        this.checkUninitializedProperty('EnableFolderCreation');
        return ((this.get_objectData()).get_properties())['EnableFolderCreation'];
    },
    set_enableFolderCreation: function SP_List$set_enableFolderCreation(value) {
        ((this.get_objectData()).get_properties())['EnableFolderCreation'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableFolderCreation', value));
        }
        return value;
    },
    get_enableMinorVersions: function SP_List$get_enableMinorVersions() {
        this.checkUninitializedProperty('EnableMinorVersions');
        return ((this.get_objectData()).get_properties())['EnableMinorVersions'];
    },
    set_enableMinorVersions: function SP_List$set_enableMinorVersions(value) {
        ((this.get_objectData()).get_properties())['EnableMinorVersions'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableMinorVersions', value));
        }
        return value;
    },
    get_enableModeration: function SP_List$get_enableModeration() {
        this.checkUninitializedProperty('EnableModeration');
        return ((this.get_objectData()).get_properties())['EnableModeration'];
    },
    set_enableModeration: function SP_List$set_enableModeration(value) {
        ((this.get_objectData()).get_properties())['EnableModeration'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableModeration', value));
        }
        return value;
    },
    get_enableVersioning: function SP_List$get_enableVersioning() {
        this.checkUninitializedProperty('EnableVersioning');
        return ((this.get_objectData()).get_properties())['EnableVersioning'];
    },
    set_enableVersioning: function SP_List$set_enableVersioning(value) {
        ((this.get_objectData()).get_properties())['EnableVersioning'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableVersioning', value));
        }
        return value;
    },
    get_entityTypeName: function SP_List$get_entityTypeName() {
        this.checkUninitializedProperty('EntityTypeName');
        return ((this.get_objectData()).get_properties())['EntityTypeName'];
    },
    get_eventReceivers: function SP_List$get_eventReceivers() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['EventReceivers'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.EventReceiverDefinitionCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'EventReceivers'));
            ((this.get_objectData()).get_clientObjectProperties())['EventReceivers'] = $v_0;
        }
        return $v_0;
    },
    get_fields: function SP_List$get_fields() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Fields'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FieldCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Fields'));
            ((this.get_objectData()).get_clientObjectProperties())['Fields'] = $v_0;
        }
        return $v_0;
    },
    get_fileSavePostProcessingEnabled: function SP_List$get_fileSavePostProcessingEnabled() {
        this.checkUninitializedProperty('FileSavePostProcessingEnabled');
        return ((this.get_objectData()).get_properties())['FileSavePostProcessingEnabled'];
    },
    get_forceCheckout: function SP_List$get_forceCheckout() {
        this.checkUninitializedProperty('ForceCheckout');
        return ((this.get_objectData()).get_properties())['ForceCheckout'];
    },
    set_forceCheckout: function SP_List$set_forceCheckout(value) {
        ((this.get_objectData()).get_properties())['ForceCheckout'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ForceCheckout', value));
        }
        return value;
    },
    get_forms: function SP_List$get_forms() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Forms'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FormCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Forms'));
            ((this.get_objectData()).get_clientObjectProperties())['Forms'] = $v_0;
        }
        return $v_0;
    },
    get_hasExternalDataSource: function SP_List$get_hasExternalDataSource() {
        this.checkUninitializedProperty('HasExternalDataSource');
        return ((this.get_objectData()).get_properties())['HasExternalDataSource'];
    },
    get_hidden: function SP_List$get_hidden() {
        this.checkUninitializedProperty('Hidden');
        return ((this.get_objectData()).get_properties())['Hidden'];
    },
    set_hidden: function SP_List$set_hidden(value) {
        ((this.get_objectData()).get_properties())['Hidden'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Hidden', value));
        }
        return value;
    },
    get_id: function SP_List$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_imageUrl: function SP_List$get_imageUrl() {
        this.checkUninitializedProperty('ImageUrl');
        return ((this.get_objectData()).get_properties())['ImageUrl'];
    },
    set_imageUrl: function SP_List$set_imageUrl(value) {
        ((this.get_objectData()).get_properties())['ImageUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ImageUrl', value));
        }
        return value;
    },
    get_informationRightsManagementSettings: function SP_List$get_informationRightsManagementSettings() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['InformationRightsManagementSettings'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.InformationRightsManagementSettings(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'InformationRightsManagementSettings'));
            ((this.get_objectData()).get_clientObjectProperties())['InformationRightsManagementSettings'] = $v_0;
        }
        return $v_0;
    },
    get_irmEnabled: function SP_List$get_irmEnabled() {
        this.checkUninitializedProperty('IrmEnabled');
        return ((this.get_objectData()).get_properties())['IrmEnabled'];
    },
    set_irmEnabled: function SP_List$set_irmEnabled(value) {
        ((this.get_objectData()).get_properties())['IrmEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IrmEnabled', value));
        }
        return value;
    },
    get_irmExpire: function SP_List$get_irmExpire() {
        this.checkUninitializedProperty('IrmExpire');
        return ((this.get_objectData()).get_properties())['IrmExpire'];
    },
    set_irmExpire: function SP_List$set_irmExpire(value) {
        ((this.get_objectData()).get_properties())['IrmExpire'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IrmExpire', value));
        }
        return value;
    },
    get_irmReject: function SP_List$get_irmReject() {
        this.checkUninitializedProperty('IrmReject');
        return ((this.get_objectData()).get_properties())['IrmReject'];
    },
    set_irmReject: function SP_List$set_irmReject(value) {
        ((this.get_objectData()).get_properties())['IrmReject'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IrmReject', value));
        }
        return value;
    },
    get_isApplicationList: function SP_List$get_isApplicationList() {
        this.checkUninitializedProperty('IsApplicationList');
        return ((this.get_objectData()).get_properties())['IsApplicationList'];
    },
    set_isApplicationList: function SP_List$set_isApplicationList(value) {
        ((this.get_objectData()).get_properties())['IsApplicationList'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IsApplicationList', value));
        }
        return value;
    },
    get_isCatalog: function SP_List$get_isCatalog() {
        this.checkUninitializedProperty('IsCatalog');
        return ((this.get_objectData()).get_properties())['IsCatalog'];
    },
    get_isPrivate: function SP_List$get_isPrivate() {
        this.checkUninitializedProperty('IsPrivate');
        return ((this.get_objectData()).get_properties())['IsPrivate'];
    },
    get_isSiteAssetsLibrary: function SP_List$get_isSiteAssetsLibrary() {
        this.checkUninitializedProperty('IsSiteAssetsLibrary');
        return ((this.get_objectData()).get_properties())['IsSiteAssetsLibrary'];
    },
    get_itemCount: function SP_List$get_itemCount() {
        this.checkUninitializedProperty('ItemCount');
        return ((this.get_objectData()).get_properties())['ItemCount'];
    },
    get_lastItemDeletedDate: function SP_List$get_lastItemDeletedDate() {
        this.checkUninitializedProperty('LastItemDeletedDate');
        return ((this.get_objectData()).get_properties())['LastItemDeletedDate'];
    },
    get_lastItemModifiedDate: function SP_List$get_lastItemModifiedDate() {
        this.checkUninitializedProperty('LastItemModifiedDate');
        return ((this.get_objectData()).get_properties())['LastItemModifiedDate'];
    },
    set_lastItemModifiedDate: function SP_List$set_lastItemModifiedDate(value) {
        ((this.get_objectData()).get_properties())['LastItemModifiedDate'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'LastItemModifiedDate', value));
        }
        return value;
    },
    get_listItemEntityTypeFullName: function SP_List$get_listItemEntityTypeFullName() {
        this.checkUninitializedProperty('ListItemEntityTypeFullName');
        return ((this.get_objectData()).get_properties())['ListItemEntityTypeFullName'];
    },
    get_majorVersionLimit: function SP_List$get_majorVersionLimit() {
        this.checkUninitializedProperty('MajorVersionLimit');
        return ((this.get_objectData()).get_properties())['MajorVersionLimit'];
    },
    set_majorVersionLimit: function SP_List$set_majorVersionLimit(value) {
        ((this.get_objectData()).get_properties())['MajorVersionLimit'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MajorVersionLimit', value));
        }
        return value;
    },
    get_majorWithMinorVersionsLimit: function SP_List$get_majorWithMinorVersionsLimit() {
        this.checkUninitializedProperty('MajorWithMinorVersionsLimit');
        return ((this.get_objectData()).get_properties())['MajorWithMinorVersionsLimit'];
    },
    set_majorWithMinorVersionsLimit: function SP_List$set_majorWithMinorVersionsLimit(value) {
        ((this.get_objectData()).get_properties())['MajorWithMinorVersionsLimit'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MajorWithMinorVersionsLimit', value));
        }
        return value;
    },
    get_multipleDataList: function SP_List$get_multipleDataList() {
        this.checkUninitializedProperty('MultipleDataList');
        return ((this.get_objectData()).get_properties())['MultipleDataList'];
    },
    set_multipleDataList: function SP_List$set_multipleDataList(value) {
        ((this.get_objectData()).get_properties())['MultipleDataList'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MultipleDataList', value));
        }
        return value;
    },
    get_noCrawl: function SP_List$get_noCrawl() {
        this.checkUninitializedProperty('NoCrawl');
        return ((this.get_objectData()).get_properties())['NoCrawl'];
    },
    set_noCrawl: function SP_List$set_noCrawl(value) {
        ((this.get_objectData()).get_properties())['NoCrawl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'NoCrawl', value));
        }
        return value;
    },
    get_onQuickLaunch: function SP_List$get_onQuickLaunch() {
        this.checkUninitializedProperty('OnQuickLaunch');
        return ((this.get_objectData()).get_properties())['OnQuickLaunch'];
    },
    set_onQuickLaunch: function SP_List$set_onQuickLaunch(value) {
        ((this.get_objectData()).get_properties())['OnQuickLaunch'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'OnQuickLaunch', value));
        }
        return value;
    },
    get_parentWeb: function SP_List$get_parentWeb() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ParentWeb'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Web(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ParentWeb'));
            ((this.get_objectData()).get_clientObjectProperties())['ParentWeb'] = $v_0;
        }
        return $v_0;
    },
    get_parentWebUrl: function SP_List$get_parentWebUrl() {
        this.checkUninitializedProperty('ParentWebUrl');
        return ((this.get_objectData()).get_properties())['ParentWebUrl'];
    },
    get_parserDisabled: function SP_List$get_parserDisabled() {
        this.checkUninitializedProperty('ParserDisabled');
        return ((this.get_objectData()).get_properties())['ParserDisabled'];
    },
    set_parserDisabled: function SP_List$set_parserDisabled(value) {
        ((this.get_objectData()).get_properties())['ParserDisabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ParserDisabled', value));
        }
        return value;
    },
    get_rootFolder: function SP_List$get_rootFolder() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RootFolder'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Folder(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RootFolder'));
            ((this.get_objectData()).get_clientObjectProperties())['RootFolder'] = $v_0;
        }
        return $v_0;
    },
    get_schemaXml: function SP_List$get_schemaXml() {
        this.checkUninitializedProperty('SchemaXml');
        return ((this.get_objectData()).get_properties())['SchemaXml'];
    },
    get_serverTemplateCanCreateFolders: function SP_List$get_serverTemplateCanCreateFolders() {
        this.checkUninitializedProperty('ServerTemplateCanCreateFolders');
        return ((this.get_objectData()).get_properties())['ServerTemplateCanCreateFolders'];
    },
    get_templateFeatureId: function SP_List$get_templateFeatureId() {
        this.checkUninitializedProperty('TemplateFeatureId');
        return ((this.get_objectData()).get_properties())['TemplateFeatureId'];
    },
    get_title: function SP_List$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    set_title: function SP_List$set_title(value) {
        ((this.get_objectData()).get_properties())['Title'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Title', value));
        }
        return value;
    },
    get_titleResource: function SP_List$get_titleResource() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['TitleResource'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserResource(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'TitleResource'));
            ((this.get_objectData()).get_clientObjectProperties())['TitleResource'] = $v_0;
        }
        return $v_0;
    },
    get_userCustomActions: function SP_List$get_userCustomActions() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['UserCustomActions'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserCustomActionCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'UserCustomActions'));
            ((this.get_objectData()).get_clientObjectProperties())['UserCustomActions'] = $v_0;
        }
        return $v_0;
    },
    get_validationFormula: function SP_List$get_validationFormula() {
        this.checkUninitializedProperty('ValidationFormula');
        return ((this.get_objectData()).get_properties())['ValidationFormula'];
    },
    set_validationFormula: function SP_List$set_validationFormula(value) {
        ((this.get_objectData()).get_properties())['ValidationFormula'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ValidationFormula', value));
        }
        return value;
    },
    get_validationMessage: function SP_List$get_validationMessage() {
        this.checkUninitializedProperty('ValidationMessage');
        return ((this.get_objectData()).get_properties())['ValidationMessage'];
    },
    set_validationMessage: function SP_List$set_validationMessage(value) {
        ((this.get_objectData()).get_properties())['ValidationMessage'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ValidationMessage', value));
        }
        return value;
    },
    get_views: function SP_List$get_views() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Views'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ViewCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Views'));
            ((this.get_objectData()).get_clientObjectProperties())['Views'] = $v_0;
        }
        return $v_0;
    },
    get_workflowAssociations: function SP_List$get_workflowAssociations() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['WorkflowAssociations'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Workflow.WorkflowAssociationCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'WorkflowAssociations'));
            ((this.get_objectData()).get_clientObjectProperties())['WorkflowAssociations'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_List$initPropertiesFromJson(parentNode) {
        SP.SecurableObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowContentTypes;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowContentTypes'] = $v_0;
            delete parentNode.AllowContentTypes;
        }
        $v_0 = parentNode.BaseTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['BaseTemplate'] = $v_0;
            delete parentNode.BaseTemplate;
        }
        $v_0 = parentNode.BaseType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['BaseType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.BaseType;
        }
        $v_0 = parentNode.BrowserFileHandling;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['BrowserFileHandling'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.BrowserFileHandling;
        }
        $v_0 = parentNode.ContentTypes;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ContentTypes', this.get_contentTypes(), $v_0);
            (this.get_contentTypes()).fromJson($v_0);
            delete parentNode.ContentTypes;
        }
        $v_0 = parentNode.ContentTypesEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContentTypesEnabled'] = $v_0;
            delete parentNode.ContentTypesEnabled;
        }
        $v_0 = parentNode.CrawlNonDefaultViews;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CrawlNonDefaultViews'] = $v_0;
            delete parentNode.CrawlNonDefaultViews;
        }
        $v_0 = parentNode.CreatablesInfo;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('CreatablesInfo', this.get_creatablesInfo(), $v_0);
            (this.get_creatablesInfo()).fromJson($v_0);
            delete parentNode.CreatablesInfo;
        }
        $v_0 = parentNode.Created;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Created'] = $v_0;
            delete parentNode.Created;
        }
        $v_0 = parentNode.CurrentChangeToken;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CurrentChangeToken'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.CurrentChangeToken;
        }
        $v_0 = parentNode.DataSource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DataSource'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.DataSource;
        }
        $v_0 = parentNode.DefaultContentApprovalWorkflowId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefaultContentApprovalWorkflowId'] = $v_0;
            delete parentNode.DefaultContentApprovalWorkflowId;
        }
        $v_0 = parentNode.DefaultDisplayFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefaultDisplayFormUrl'] = $v_0;
            delete parentNode.DefaultDisplayFormUrl;
        }
        $v_0 = parentNode.DefaultEditFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefaultEditFormUrl'] = $v_0;
            delete parentNode.DefaultEditFormUrl;
        }
        $v_0 = parentNode.DefaultNewFormUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefaultNewFormUrl'] = $v_0;
            delete parentNode.DefaultNewFormUrl;
        }
        $v_0 = parentNode.DefaultView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('DefaultView', this.get_defaultView(), $v_0);
            (this.get_defaultView()).fromJson($v_0);
            delete parentNode.DefaultView;
        }
        $v_0 = parentNode.DefaultViewUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefaultViewUrl'] = $v_0;
            delete parentNode.DefaultViewUrl;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.DescriptionResource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('DescriptionResource', this.get_descriptionResource(), $v_0);
            (this.get_descriptionResource()).fromJson($v_0);
            delete parentNode.DescriptionResource;
        }
        $v_0 = parentNode.Direction;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Direction'] = $v_0;
            delete parentNode.Direction;
        }
        $v_0 = parentNode.DocumentTemplateUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentTemplateUrl'] = $v_0;
            delete parentNode.DocumentTemplateUrl;
        }
        $v_0 = parentNode.DraftVersionVisibility;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DraftVersionVisibility'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.DraftVersionVisibility;
        }
        $v_0 = parentNode.EffectiveBasePermissions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EffectiveBasePermissions'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.EffectiveBasePermissions;
        }
        $v_0 = parentNode.EffectiveBasePermissionsForUI;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EffectiveBasePermissionsForUI'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.EffectiveBasePermissionsForUI;
        }
        $v_0 = parentNode.EnableAttachments;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableAttachments'] = $v_0;
            delete parentNode.EnableAttachments;
        }
        $v_0 = parentNode.EnableFolderCreation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableFolderCreation'] = $v_0;
            delete parentNode.EnableFolderCreation;
        }
        $v_0 = parentNode.EnableMinorVersions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableMinorVersions'] = $v_0;
            delete parentNode.EnableMinorVersions;
        }
        $v_0 = parentNode.EnableModeration;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableModeration'] = $v_0;
            delete parentNode.EnableModeration;
        }
        $v_0 = parentNode.EnableVersioning;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableVersioning'] = $v_0;
            delete parentNode.EnableVersioning;
        }
        $v_0 = parentNode.EntityTypeName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EntityTypeName'] = $v_0;
            delete parentNode.EntityTypeName;
        }
        $v_0 = parentNode.EventReceivers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('EventReceivers', this.get_eventReceivers(), $v_0);
            (this.get_eventReceivers()).fromJson($v_0);
            delete parentNode.EventReceivers;
        }
        $v_0 = parentNode.Fields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Fields', this.get_fields(), $v_0);
            (this.get_fields()).fromJson($v_0);
            delete parentNode.Fields;
        }
        $v_0 = parentNode.FileSavePostProcessingEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FileSavePostProcessingEnabled'] = $v_0;
            delete parentNode.FileSavePostProcessingEnabled;
        }
        $v_0 = parentNode.ForceCheckout;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ForceCheckout'] = $v_0;
            delete parentNode.ForceCheckout;
        }
        $v_0 = parentNode.Forms;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Forms', this.get_forms(), $v_0);
            (this.get_forms()).fromJson($v_0);
            delete parentNode.Forms;
        }
        $v_0 = parentNode.HasExternalDataSource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasExternalDataSource'] = $v_0;
            delete parentNode.HasExternalDataSource;
        }
        $v_0 = parentNode.Hidden;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Hidden'] = $v_0;
            delete parentNode.Hidden;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.ImageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ImageUrl'] = $v_0;
            delete parentNode.ImageUrl;
        }
        $v_0 = parentNode.InformationRightsManagementSettings;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('InformationRightsManagementSettings', this.get_informationRightsManagementSettings(), $v_0);
            (this.get_informationRightsManagementSettings()).fromJson($v_0);
            delete parentNode.InformationRightsManagementSettings;
        }
        $v_0 = parentNode.IrmEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IrmEnabled'] = $v_0;
            delete parentNode.IrmEnabled;
        }
        $v_0 = parentNode.IrmExpire;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IrmExpire'] = $v_0;
            delete parentNode.IrmExpire;
        }
        $v_0 = parentNode.IrmReject;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IrmReject'] = $v_0;
            delete parentNode.IrmReject;
        }
        $v_0 = parentNode.IsApplicationList;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsApplicationList'] = $v_0;
            delete parentNode.IsApplicationList;
        }
        $v_0 = parentNode.IsCatalog;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsCatalog'] = $v_0;
            delete parentNode.IsCatalog;
        }
        $v_0 = parentNode.IsPrivate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsPrivate'] = $v_0;
            delete parentNode.IsPrivate;
        }
        $v_0 = parentNode.IsSiteAssetsLibrary;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsSiteAssetsLibrary'] = $v_0;
            delete parentNode.IsSiteAssetsLibrary;
        }
        $v_0 = parentNode.ItemCount;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemCount'] = $v_0;
            delete parentNode.ItemCount;
        }
        $v_0 = parentNode.LastItemDeletedDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LastItemDeletedDate'] = $v_0;
            delete parentNode.LastItemDeletedDate;
        }
        $v_0 = parentNode.LastItemModifiedDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LastItemModifiedDate'] = $v_0;
            delete parentNode.LastItemModifiedDate;
        }
        $v_0 = parentNode.ListItemEntityTypeFullName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListItemEntityTypeFullName'] = $v_0;
            delete parentNode.ListItemEntityTypeFullName;
        }
        $v_0 = parentNode.MajorVersionLimit;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MajorVersionLimit'] = $v_0;
            delete parentNode.MajorVersionLimit;
        }
        $v_0 = parentNode.MajorWithMinorVersionsLimit;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MajorWithMinorVersionsLimit'] = $v_0;
            delete parentNode.MajorWithMinorVersionsLimit;
        }
        $v_0 = parentNode.MultipleDataList;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MultipleDataList'] = $v_0;
            delete parentNode.MultipleDataList;
        }
        $v_0 = parentNode.NoCrawl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['NoCrawl'] = $v_0;
            delete parentNode.NoCrawl;
        }
        $v_0 = parentNode.OnQuickLaunch;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['OnQuickLaunch'] = $v_0;
            delete parentNode.OnQuickLaunch;
        }
        $v_0 = parentNode.ParentWeb;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ParentWeb', this.get_parentWeb(), $v_0);
            (this.get_parentWeb()).fromJson($v_0);
            delete parentNode.ParentWeb;
        }
        $v_0 = parentNode.ParentWebUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ParentWebUrl'] = $v_0;
            delete parentNode.ParentWebUrl;
        }
        $v_0 = parentNode.ParserDisabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ParserDisabled'] = $v_0;
            delete parentNode.ParserDisabled;
        }
        $v_0 = parentNode.RootFolder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RootFolder', this.get_rootFolder(), $v_0);
            (this.get_rootFolder()).fromJson($v_0);
            delete parentNode.RootFolder;
        }
        $v_0 = parentNode.SchemaXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SchemaXml'] = $v_0;
            delete parentNode.SchemaXml;
        }
        $v_0 = parentNode.ServerTemplateCanCreateFolders;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerTemplateCanCreateFolders'] = $v_0;
            delete parentNode.ServerTemplateCanCreateFolders;
        }
        $v_0 = parentNode.TemplateFeatureId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TemplateFeatureId'] = $v_0;
            delete parentNode.TemplateFeatureId;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.TitleResource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('TitleResource', this.get_titleResource(), $v_0);
            (this.get_titleResource()).fromJson($v_0);
            delete parentNode.TitleResource;
        }
        $v_0 = parentNode.UserCustomActions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('UserCustomActions', this.get_userCustomActions(), $v_0);
            (this.get_userCustomActions()).fromJson($v_0);
            delete parentNode.UserCustomActions;
        }
        $v_0 = parentNode.ValidationFormula;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ValidationFormula'] = $v_0;
            delete parentNode.ValidationFormula;
        }
        $v_0 = parentNode.ValidationMessage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ValidationMessage'] = $v_0;
            delete parentNode.ValidationMessage;
        }
        $v_0 = parentNode.Views;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Views', this.get_views(), $v_0);
            (this.get_views()).fromJson($v_0);
            delete parentNode.Views;
        }
        $v_0 = parentNode.WorkflowAssociations;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('WorkflowAssociations', this.get_workflowAssociations(), $v_0);
            (this.get_workflowAssociations()).fromJson($v_0);
            delete parentNode.WorkflowAssociations;
        }
    },
    saveAsNewView: function SP_List$saveAsNewView(oldName, newName, privateView, uri) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'SaveAsNewView', [oldName, newName, privateView, uri]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    createDocumentAndGetEditLink: function SP_List$createDocumentAndGetEditLink(fileName, folderPath, documentTemplateType) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'CreateDocumentAndGetEditLink', [fileName, folderPath, documentTemplateType]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    createDocumentWithDefaultName: function SP_List$createDocumentWithDefaultName(folderPath, extension) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'CreateDocumentWithDefaultName', [folderPath, extension]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    createDocument: function SP_List$createDocument(fileName, targetFolder, templateType) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ListItem($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'CreateDocument', [fileName, targetFolder, templateType]));
        return $v_1;
    },
    createDocumentFromTemplateStream: function SP_List$createDocumentFromTemplateStream(fileName, targetFolder, extension, templateStream) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ListItem($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'CreateDocumentFromTemplateStream', [fileName, targetFolder, extension, templateStream]));
        return $v_1;
    },
    createDocumentFromTemplateBytes: function SP_List$createDocumentFromTemplateBytes(fileName, targetFolder, templateBytes, extension) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ListItem($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'CreateDocumentFromTemplateBytes', [fileName, targetFolder, templateBytes, extension]));
        return $v_1;
    },
    createDocumentFromTemplate: function SP_List$createDocumentFromTemplate(fileName, targetFolder, templateUrl) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ListItem($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'CreateDocumentFromTemplate', [fileName, targetFolder, templateUrl]));
        return $v_1;
    },
    getSpecialFolderUrl: function SP_List$getSpecialFolderUrl(type, bForceCreate, existingFolderGuid) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetSpecialFolderUrl', [type, bForceCreate, existingFolderGuid]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getWebDavUrl: function SP_List$getWebDavUrl(sourceUrl) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetWebDavUrl', [sourceUrl]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    reserveListItemId: function SP_List$reserveListItemId() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'ReserveListItemId', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.IntResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    update: function SP_List$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    },
    getView: function SP_List$getView(viewGuid) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetView'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetView'] = $v_2;
        }
        $v_1 = $v_2[viewGuid.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.View($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetView', [viewGuid]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[viewGuid.toString()] = $v_1;
        }
        return $v_1;
    },
    deleteObject: function SP_List$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    },
    recycle: function SP_List$recycle() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'Recycle', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        this.removeFromParentCollection();
        return $v_1;
    },
    getChanges: function SP_List$getChanges(query) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ChangeCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetChanges', [query]));
        return $v_1;
    },
    getUserEffectivePermissions: function SP_List$getUserEffectivePermissions(userName) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetUserEffectivePermissions', [userName]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.BasePermissions();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getItems: function SP_List$getItems(query) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ListItemCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetItems', [query]));
        return $v_1;
    },
    $7g_2: function SP_List$$7g_2($p0) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetItemByStringId'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetItemByStringId'] = $v_2;
        }
        $v_1 = $v_2[$p0];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.ListItem($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetItemByStringId', [$p0]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[$p0] = $v_1;
        }
        return $v_1;
    },
    getRelatedFields: function SP_List$getRelatedFields() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.RelatedFieldCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetRelatedFields', null));
        return $v_1;
    },
    getRelatedFieldsExtendedData: function SP_List$getRelatedFieldsExtendedData() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.RelatedFieldExtendedDataCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetRelatedFieldsExtendedData', null));
        return $v_1;
    },
    renderExtendedListFormData: function SP_List$renderExtendedListFormData(itemId, formId, mode, options) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'RenderExtendedListFormData', [itemId, formId, mode, options]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    renderListFormData: function SP_List$renderListFormData(itemId, formId, mode) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'RenderListFormData', [itemId, formId, mode]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    renderListData: function SP_List$renderListData(viewXml) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'RenderListData', [viewXml]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    renderListDataAsStream: function SP_List$renderListDataAsStream(parameters, overrideParameters) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'RenderListDataAsStream', [parameters, overrideParameters]);

        $v_0.addQuery($v_2);
        $v_1 = [];
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    renderListFilterData: function SP_List$renderListFilterData(parameters) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'RenderListFilterData', [parameters]);

        $v_0.addQuery($v_2);
        $v_1 = [];
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    renderListContextMenuData: function SP_List$renderListContextMenuData(parameters) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'RenderListContextMenuData', [parameters]);

        $v_0.addQuery($v_2);
        $v_1 = [];
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    addItem: function SP_List$addItem(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ListItem($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'AddItem', [parameters]));
        $v_1.$F_2(parameters);
        return $v_1;
    }
};
SP.ListPropertyNames = function SP_ListPropertyNames() {
};
SP.ListObjectPropertyNames = function SP_ListObjectPropertyNames() {
};
SP.ListCollection = function SP_ListCollection(context, objectPath) {
    SP.ListCollection.initializeBase(this, [context, objectPath]);
};
SP.ListCollection.prototype = {
    itemAt: function SP_ListCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ListCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ListCollection$get_childItemType() {
        return SP.List;
    },
    getByTitle: function SP_ListCollection$getByTitle(title) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByTitle'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByTitle'] = $v_2;
        }
        $v_1 = $v_2[title.toUpperCase()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByTitle', [title]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[title.toUpperCase()] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    getById: function SP_ListCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id.toString()] = $v_1;
        }
        return $v_1;
    },
    add: function SP_ListCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_2(parameters);
        return $v_1;
    },
    ensureSitePagesLibrary: function SP_ListCollection$ensureSitePagesLibrary() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'EnsureSitePagesLibrary', null));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        return $v_1;
    },
    ensureSiteAssetsLibrary: function SP_ListCollection$ensureSiteAssetsLibrary() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'EnsureSiteAssetsLibrary', null));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        return $v_1;
    }
};
SP.ListCreationInformation = function SP_ListCreationInformation() {
    SP.ListCreationInformation.initializeBase(this);
};
SP.ListCreationInformation.prototype = {
    $2T_1: null,
    $2U_1: null,
    $2_1: null,
    $2V_1: 0,
    $4b_1: 0,
    $1i_1: null,
    $5F_1: 0,
    $0_1: null,
    $1_1: null,
    get_customSchemaXml: function SP_ListCreationInformation$get_customSchemaXml() {
        return this.$2T_1;
    },
    set_customSchemaXml: function SP_ListCreationInformation$set_customSchemaXml(value) {
        this.$2T_1 = value;
        return value;
    },
    get_dataSourceProperties: function SP_ListCreationInformation$get_dataSourceProperties() {
        return this.$2U_1;
    },
    set_dataSourceProperties: function SP_ListCreationInformation$set_dataSourceProperties(value) {
        this.$2U_1 = value;
        return value;
    },
    get_description: function SP_ListCreationInformation$get_description() {
        return this.$2_1;
    },
    set_description: function SP_ListCreationInformation$set_description(value) {
        this.$2_1 = value;
        return value;
    },
    get_documentTemplateType: function SP_ListCreationInformation$get_documentTemplateType() {
        return this.$2V_1;
    },
    set_documentTemplateType: function SP_ListCreationInformation$set_documentTemplateType(value) {
        this.$2V_1 = value;
        return value;
    },
    get_quickLaunchOption: function SP_ListCreationInformation$get_quickLaunchOption() {
        return this.$4b_1;
    },
    set_quickLaunchOption: function SP_ListCreationInformation$set_quickLaunchOption(value) {
        this.$4b_1 = value;
        return value;
    },
    get_templateFeatureId: function SP_ListCreationInformation$get_templateFeatureId() {
        return this.$1i_1;
    },
    set_templateFeatureId: function SP_ListCreationInformation$set_templateFeatureId(value) {
        this.$1i_1 = value;
        return value;
    },
    get_templateType: function SP_ListCreationInformation$get_templateType() {
        return this.$5F_1;
    },
    set_templateType: function SP_ListCreationInformation$set_templateType(value) {
        this.$5F_1 = value;
        return value;
    },
    get_title: function SP_ListCreationInformation$get_title() {
        return this.$0_1;
    },
    set_title: function SP_ListCreationInformation$set_title(value) {
        this.$0_1 = value;
        return value;
    },
    get_url: function SP_ListCreationInformation$get_url() {
        return this.$1_1;
    },
    set_url: function SP_ListCreationInformation$set_url(value) {
        this.$1_1 = value;
        return value;
    },
    get_typeId: function SP_ListCreationInformation$get_typeId() {
        return '{e247b7fc-095e-4ea4-a4c9-c5d373723d8c}';
    },
    writeToXml: function SP_ListCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['CustomSchemaXml', 'DataSourceProperties', 'Description', 'DocumentTemplateType', 'QuickLaunchOption', 'TemplateFeatureId', 'TemplateType', 'Title', 'Url'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ListCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CustomSchemaXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2T_1 = $v_0;
            delete parentNode.CustomSchemaXml;
        }
        $v_0 = parentNode.DataSourceProperties;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2U_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.DataSourceProperties;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2_1 = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.DocumentTemplateType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2V_1 = $v_0;
            delete parentNode.DocumentTemplateType;
        }
        $v_0 = parentNode.QuickLaunchOption;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4b_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.QuickLaunchOption;
        }
        $v_0 = parentNode.TemplateFeatureId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1i_1 = $v_0;
            delete parentNode.TemplateFeatureId;
        }
        $v_0 = parentNode.TemplateType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5F_1 = $v_0;
            delete parentNode.TemplateType;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1_1 = $v_0;
            delete parentNode.Url;
        }
    }
};
SP.ListDataSource = function SP_ListDataSource() {
    SP.ListDataSource.initializeBase(this);
};
SP.ListDataSource.prototype = {
    $6f_1: null,
    get_properties: function SP_ListDataSource$get_properties() {
        return this.$6f_1;
    },
    get_typeId: function SP_ListDataSource$get_typeId() {
        return '{06bfe4a5-1516-4b55-a6d7-ecbe3ff7a3c8}';
    },
    writeToXml: function SP_ListDataSource$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Properties'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ListDataSource$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Properties;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6f_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Properties;
        }
    }
};
SP.ListDataValidationExceptionValue = function SP_ListDataValidationExceptionValue() {
    SP.ListDataValidationExceptionValue.initializeBase(this);
};
SP.ListDataValidationExceptionValue.prototype = {
    $2d_1: null,
    $6K_1: null,
    get_fieldFailures: function SP_ListDataValidationExceptionValue$get_fieldFailures() {
        return this.$2d_1;
    },
    get_itemFailure: function SP_ListDataValidationExceptionValue$get_itemFailure() {
        return this.$6K_1;
    },
    get_typeId: function SP_ListDataValidationExceptionValue$get_typeId() {
        return '{356fe248-721a-4adf-af96-20822bc5476e}';
    },
    writeToXml: function SP_ListDataValidationExceptionValue$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['FieldFailures', 'ItemFailure'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ListDataValidationExceptionValue$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FieldFailures;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2d_1 = [];
            SP.DataConvert.populateArray(null, this.$2d_1, $v_0);
            delete parentNode.FieldFailures;
        }
        $v_0 = parentNode.ItemFailure;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6K_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.ItemFailure;
        }
    }
};
SP.ListDataValidationFailure = function SP_ListDataValidationFailure() {
    SP.ListDataValidationFailure.initializeBase(this);
};
SP.ListDataValidationFailure.prototype = {
    $H_1: null,
    $15_1: null,
    $4_1: null,
    $6h_1: 0,
    $72_1: 0,
    get_displayName: function SP_ListDataValidationFailure$get_displayName() {
        return this.$H_1;
    },
    get_message: function SP_ListDataValidationFailure$get_message() {
        return this.$15_1;
    },
    get_name: function SP_ListDataValidationFailure$get_name() {
        return this.$4_1;
    },
    get_reason: function SP_ListDataValidationFailure$get_reason() {
        return this.$6h_1;
    },
    get_validationType: function SP_ListDataValidationFailure$get_validationType() {
        return this.$72_1;
    },
    get_typeId: function SP_ListDataValidationFailure$get_typeId() {
        return '{6e0bc783-53a2-4506-827f-135040524794}';
    },
    writeToXml: function SP_ListDataValidationFailure$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['DisplayName', 'Message', 'Name', 'Reason', 'ValidationType'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ListDataValidationFailure$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DisplayName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$H_1 = $v_0;
            delete parentNode.DisplayName;
        }
        $v_0 = parentNode.Message;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$15_1 = $v_0;
            delete parentNode.Message;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4_1 = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.Reason;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6h_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Reason;
        }
        $v_0 = parentNode.ValidationType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$72_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.ValidationType;
        }
    }
};
SP.ListItem = function SP_ListItem(context, objectPath) {
    SP.ListItem.initializeBase(this, [context, objectPath]);
};
SP.ListItem.prototype = {
    get_fieldValues: function SP_ListItem$get_fieldValues() {
        var $v_0 = ((this.get_objectData()).get_methodReturnObjects())['$m_dict'];

        if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
            $v_0 = {};
            ((this.get_objectData()).get_methodReturnObjects())['$m_dict'] = $v_0;
        }
        return $v_0;
    },
    get_item: function SP_ListItem$get_item(fieldName) {
        return this.$12_2(fieldName);
    },
    set_item: function SP_ListItem$set_item(fieldName, value) {
        this.$5e_2(fieldName, value);
        return value;
    },
    $F_2: function SP_ListItem$$F_2($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['FileSystemObjectType'] = $p0.$1j_1;
            ((this.get_objectData()).get_properties())['Id'] = -1;
        }
    },
    get_attachmentFiles: function SP_ListItem$get_attachmentFiles() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['AttachmentFiles'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.AttachmentCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'AttachmentFiles'));
            ((this.get_objectData()).get_clientObjectProperties())['AttachmentFiles'] = $v_0;
        }
        return $v_0;
    },
    get_contentType: function SP_ListItem$get_contentType() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ContentType'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ContentType(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ContentType'));
            ((this.get_objectData()).get_clientObjectProperties())['ContentType'] = $v_0;
        }
        return $v_0;
    },
    get_displayName: function SP_ListItem$get_displayName() {
        this.checkUninitializedProperty('DisplayName');
        return ((this.get_objectData()).get_properties())['DisplayName'];
    },
    get_getDlpPolicyTip: function SP_ListItem$get_getDlpPolicyTip() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['GetDlpPolicyTip'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.DlpPolicyTip(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'GetDlpPolicyTip'));
            ((this.get_objectData()).get_clientObjectProperties())['GetDlpPolicyTip'] = $v_0;
        }
        return $v_0;
    },
    get_effectiveBasePermissions: function SP_ListItem$get_effectiveBasePermissions() {
        this.checkUninitializedProperty('EffectiveBasePermissions');
        return ((this.get_objectData()).get_properties())['EffectiveBasePermissions'];
    },
    get_effectiveBasePermissionsForUI: function SP_ListItem$get_effectiveBasePermissionsForUI() {
        this.checkUninitializedProperty('EffectiveBasePermissionsForUI');
        return ((this.get_objectData()).get_properties())['EffectiveBasePermissionsForUI'];
    },
    get_fieldValuesAsHtml: function SP_ListItem$get_fieldValuesAsHtml() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['FieldValuesAsHtml'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FieldStringValues(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'FieldValuesAsHtml'));
            ((this.get_objectData()).get_clientObjectProperties())['FieldValuesAsHtml'] = $v_0;
        }
        return $v_0;
    },
    get_fieldValuesAsText: function SP_ListItem$get_fieldValuesAsText() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['FieldValuesAsText'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FieldStringValues(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'FieldValuesAsText'));
            ((this.get_objectData()).get_clientObjectProperties())['FieldValuesAsText'] = $v_0;
        }
        return $v_0;
    },
    get_fieldValuesForEdit: function SP_ListItem$get_fieldValuesForEdit() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['FieldValuesForEdit'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FieldStringValues(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'FieldValuesForEdit'));
            ((this.get_objectData()).get_clientObjectProperties())['FieldValuesForEdit'] = $v_0;
        }
        return $v_0;
    },
    get_file: function SP_ListItem$get_file() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['File'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.File(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'File'));
            ((this.get_objectData()).get_clientObjectProperties())['File'] = $v_0;
        }
        return $v_0;
    },
    get_fileSystemObjectType: function SP_ListItem$get_fileSystemObjectType() {
        this.checkUninitializedProperty('FileSystemObjectType');
        return ((this.get_objectData()).get_properties())['FileSystemObjectType'];
    },
    get_folder: function SP_ListItem$get_folder() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Folder'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Folder(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Folder'));
            ((this.get_objectData()).get_clientObjectProperties())['Folder'] = $v_0;
        }
        return $v_0;
    },
    get_id: function SP_ListItem$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_parentList: function SP_ListItem$get_parentList() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ParentList'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.List(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ParentList'));
            ((this.get_objectData()).get_clientObjectProperties())['ParentList'] = $v_0;
        }
        return $v_0;
    },
    get_client_Title: function SP_ListItem$get_client_Title() {
        this.checkUninitializedProperty('Client_Title');
        return ((this.get_objectData()).get_properties())['Client_Title'];
    },
    initNonPropertiesFromJson: function SP_ListItem$initNonPropertiesFromJson(parentNode) {
        SP.DataConvert.populateDictionaryFromObject(this.get_fieldValues(), parentNode);
        SP.DataConvert.fixupTypes(this.get_context(), this.get_fieldValues());
    },
    initPropertiesFromJson: function SP_ListItem$initPropertiesFromJson(parentNode) {
        SP.SecurableObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AttachmentFiles;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('AttachmentFiles', this.get_attachmentFiles(), $v_0);
            (this.get_attachmentFiles()).fromJson($v_0);
            delete parentNode.AttachmentFiles;
        }
        $v_0 = parentNode.ContentType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ContentType', this.get_contentType(), $v_0);
            (this.get_contentType()).fromJson($v_0);
            delete parentNode.ContentType;
        }
        $v_0 = parentNode.DisplayName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisplayName'] = $v_0;
            delete parentNode.DisplayName;
        }
        $v_0 = parentNode.GetDlpPolicyTip;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('GetDlpPolicyTip', this.get_getDlpPolicyTip(), $v_0);
            (this.get_getDlpPolicyTip()).fromJson($v_0);
            delete parentNode.GetDlpPolicyTip;
        }
        $v_0 = parentNode.EffectiveBasePermissions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EffectiveBasePermissions'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.EffectiveBasePermissions;
        }
        $v_0 = parentNode.EffectiveBasePermissionsForUI;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EffectiveBasePermissionsForUI'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.EffectiveBasePermissionsForUI;
        }
        $v_0 = parentNode.FieldValuesAsHtml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('FieldValuesAsHtml', this.get_fieldValuesAsHtml(), $v_0);
            (this.get_fieldValuesAsHtml()).fromJson($v_0);
            delete parentNode.FieldValuesAsHtml;
        }
        $v_0 = parentNode.FieldValuesAsText;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('FieldValuesAsText', this.get_fieldValuesAsText(), $v_0);
            (this.get_fieldValuesAsText()).fromJson($v_0);
            delete parentNode.FieldValuesAsText;
        }
        $v_0 = parentNode.FieldValuesForEdit;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('FieldValuesForEdit', this.get_fieldValuesForEdit(), $v_0);
            (this.get_fieldValuesForEdit()).fromJson($v_0);
            delete parentNode.FieldValuesForEdit;
        }
        $v_0 = parentNode.File;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('File', this.get_file(), $v_0);
            (this.get_file()).fromJson($v_0);
            delete parentNode.File;
        }
        $v_0 = parentNode.FileSystemObjectType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FileSystemObjectType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.FileSystemObjectType;
        }
        $v_0 = parentNode.Folder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Folder', this.get_folder(), $v_0);
            (this.get_folder()).fromJson($v_0);
            delete parentNode.Folder;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.ParentList;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ParentList', this.get_parentList(), $v_0);
            (this.get_parentList()).fromJson($v_0);
            delete parentNode.ParentList;
        }
        $v_0 = parentNode.Client_Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Client_Title'] = $v_0;
            delete parentNode.Client_Title;
        }
    },
    $12_2: function SP_ListItem$$12_2($p0) {
        var $v_0 = (this.get_fieldValues())[$p0];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            throw Error.create(SP.ResResources.getString('PropertyHasNotBeenInitialized'));
        }
        return $v_0;
    },
    refreshLoad: function SP_ListItem$refreshLoad() {
        SP.ClientObject.prototype.refreshLoad.call(this);
        this.loadExpandoFields();
    },
    loadExpandoFields: function SP_ListItem$loadExpandoFields() {
        var $$dict_0 = this.get_fieldValues();

        for (var $$key_1 in $$dict_0) {
            var $v_0 = {
                key: $$key_1,
                value: $$dict_0[$$key_1]
            };

            this.retrieve($v_0.key);
        }
    },
    deleteObject: function SP_ListItem$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    },
    recycle: function SP_ListItem$recycle() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'Recycle', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        this.removeFromParentCollection();
        return $v_1;
    },
    getUserEffectivePermissions: function SP_ListItem$getUserEffectivePermissions(userName) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetUserEffectivePermissions', [userName]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.BasePermissions();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    overridePolicyTip: function SP_ListItem$overridePolicyTip(userAction, justification) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'OverridePolicyTip', [userAction, justification]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.IntResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getWOPIFrameUrl: function SP_ListItem$getWOPIFrameUrl(action) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetWOPIFrameUrl', [action]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    update: function SP_ListItem$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
        this.refreshLoad();
    },
    getChanges: function SP_ListItem$getChanges(query) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ChangeCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetChanges', [query]));
        return $v_1;
    },
    $5e_2: function SP_ListItem$$5e_2($p0, $p1) {
        var $v_0 = this.get_context();

        (this.get_fieldValues())[$p0] = $p1;
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'SetFieldValue', [$p0, $p1]);

        if ($v_0) {
            $v_0.addQuery($v_1);
        }
    },
    parseAndSetFieldValue: function SP_ListItem$parseAndSetFieldValue(fieldName, value) {
        var $v_0 = this.get_context();

        (this.get_fieldValues())[fieldName] = value;
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'ParseAndSetFieldValue', [fieldName, value]);

        if ($v_0) {
            $v_0.addQuery($v_1);
        }
    },
    validateUpdateListItem: function SP_ListItem$validateUpdateListItem(formValues, bNewDocumentUpdate, checkInComment) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'ValidateUpdateListItem', [formValues, bNewDocumentUpdate, checkInComment]);

        $v_0.addQuery($v_2);
        $v_1 = [];
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    }
};
SP.ListItemPropertyNames = function SP_ListItemPropertyNames() {
};
SP.ListItemObjectPropertyNames = function SP_ListItemObjectPropertyNames() {
};
SP.ListItemCollection = function SP_ListItemCollection(context, objectPath) {
    SP.ListItemCollection.initializeBase(this, [context, objectPath]);
};
SP.ListItemCollection.prototype = {
    itemAt: function SP_ListItemCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ListItemCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ListItemCollection$get_childItemType() {
        return SP.ListItem;
    },
    getById: function SP_ListItemCollection$getById(id) {
        if (typeof id === 'string') {
            return this.$7e_2(id.toString());
        }
        else {
            id = parseInt(id.toString());
            var $v_0;
            var $v_1 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

            if (SP.ScriptUtility.isNullOrUndefined($v_1)) {
                $v_1 = [];
                ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_1;
            }
            $v_0 = $v_1[id];
            if (!SP.ScriptUtility.isNullOrUndefined($v_0)) {
                return $v_0;
            }
            $v_0 = new SP.ListItem(this.get_context(), new SP.ObjectPathMethod(this.get_context(), this.get_path(), 'GetById', [id]));
            $v_1[id] = $v_0;
            return $v_0;
        }
    },
    get_listItemCollectionPosition: function SP_ListItemCollection$get_listItemCollectionPosition() {
        this.checkUninitializedProperty('ListItemCollectionPosition');
        return ((this.get_objectData()).get_properties())['ListItemCollectionPosition'];
    },
    initPropertiesFromJson: function SP_ListItemCollection$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ListItemCollectionPosition;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListItemCollectionPosition'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ListItemCollectionPosition;
        }
    },
    $7e_2: function SP_ListItemCollection$$7e_2($p0) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByStringId'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByStringId'] = $v_2;
        }
        $v_1 = $v_2[$p0];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.ListItem($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByStringId', [$p0]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[$p0] = $v_1;
        }
        return $v_1;
    }
};
SP.ListItemCollectionPropertyNames = function SP_ListItemCollectionPropertyNames() {
};
SP.ListItemCollectionPosition = function SP_ListItemCollectionPosition() {
    SP.ListItemCollectionPosition.initializeBase(this);
};
SP.ListItemCollectionPosition.prototype = {
    $4U_1: null,
    get_pagingInfo: function SP_ListItemCollectionPosition$get_pagingInfo() {
        return this.$4U_1;
    },
    set_pagingInfo: function SP_ListItemCollectionPosition$set_pagingInfo(value) {
        this.$4U_1 = value;
        return value;
    },
    get_typeId: function SP_ListItemCollectionPosition$get_typeId() {
        return '{922354eb-c56a-4d88-ad59-67496854efe1}';
    },
    writeToXml: function SP_ListItemCollectionPosition$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['PagingInfo'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ListItemCollectionPosition$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.PagingInfo;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4U_1 = $v_0;
            delete parentNode.PagingInfo;
        }
    }
};
SP.ListItemCreationInformation = function SP_ListItemCreationInformation() {
    SP.ListItemCreationInformation.initializeBase(this);
};
SP.ListItemCreationInformation.prototype = {
    $3z_1: null,
    $4G_1: null,
    $1j_1: 0,
    get_folderUrl: function SP_ListItemCreationInformation$get_folderUrl() {
        return this.$3z_1;
    },
    set_folderUrl: function SP_ListItemCreationInformation$set_folderUrl(value) {
        this.$3z_1 = value;
        return value;
    },
    get_leafName: function SP_ListItemCreationInformation$get_leafName() {
        return this.$4G_1;
    },
    set_leafName: function SP_ListItemCreationInformation$set_leafName(value) {
        this.$4G_1 = value;
        return value;
    },
    get_underlyingObjectType: function SP_ListItemCreationInformation$get_underlyingObjectType() {
        return this.$1j_1;
    },
    set_underlyingObjectType: function SP_ListItemCreationInformation$set_underlyingObjectType(value) {
        this.$1j_1 = value;
        return value;
    },
    get_typeId: function SP_ListItemCreationInformation$get_typeId() {
        return '{54cdbee5-0897-44ac-829f-411557fa11be}';
    },
    writeToXml: function SP_ListItemCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['FolderUrl', 'LeafName', 'UnderlyingObjectType'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ListItemCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FolderUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3z_1 = $v_0;
            delete parentNode.FolderUrl;
        }
        $v_0 = parentNode.LeafName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4G_1 = $v_0;
            delete parentNode.LeafName;
        }
        $v_0 = parentNode.UnderlyingObjectType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1j_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.UnderlyingObjectType;
        }
    }
};
SP.ListItemEntityCollection = function SP_ListItemEntityCollection(context, objectPath) {
    SP.ListItemEntityCollection.initializeBase(this, [context, objectPath]);
};
SP.ListItemEntityCollection.prototype = {
    itemAt: function SP_ListItemEntityCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ListItemEntityCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ListItemEntityCollection$get_childItemType() {
        return SP.ListItem;
    }
};
SP.ListItemFormUpdateValue = function SP_ListItemFormUpdateValue() {
    SP.ListItemFormUpdateValue.initializeBase(this);
};
SP.ListItemFormUpdateValue.prototype = {
    $P_1: null,
    $2e_1: null,
    $2f_1: null,
    $43_1: false,
    get_errorMessage: function SP_ListItemFormUpdateValue$get_errorMessage() {
        return this.$P_1;
    },
    set_errorMessage: function SP_ListItemFormUpdateValue$set_errorMessage(value) {
        this.$P_1 = value;
        return value;
    },
    get_fieldName: function SP_ListItemFormUpdateValue$get_fieldName() {
        return this.$2e_1;
    },
    set_fieldName: function SP_ListItemFormUpdateValue$set_fieldName(value) {
        this.$2e_1 = value;
        return value;
    },
    get_fieldValue: function SP_ListItemFormUpdateValue$get_fieldValue() {
        return this.$2f_1;
    },
    set_fieldValue: function SP_ListItemFormUpdateValue$set_fieldValue(value) {
        this.$2f_1 = value;
        return value;
    },
    get_hasException: function SP_ListItemFormUpdateValue$get_hasException() {
        return this.$43_1;
    },
    set_hasException: function SP_ListItemFormUpdateValue$set_hasException(value) {
        this.$43_1 = value;
        return value;
    },
    get_typeId: function SP_ListItemFormUpdateValue$get_typeId() {
        return '{03745a5a-2400-440e-92d6-dad4afee30a6}';
    },
    writeToXml: function SP_ListItemFormUpdateValue$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['ErrorMessage', 'FieldName', 'FieldValue', 'HasException'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ListItemFormUpdateValue$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ErrorMessage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$P_1 = $v_0;
            delete parentNode.ErrorMessage;
        }
        $v_0 = parentNode.FieldName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2e_1 = $v_0;
            delete parentNode.FieldName;
        }
        $v_0 = parentNode.FieldValue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2f_1 = $v_0;
            delete parentNode.FieldValue;
        }
        $v_0 = parentNode.HasException;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$43_1 = $v_0;
            delete parentNode.HasException;
        }
    }
};
SP.ListTemplate = function SP_ListTemplate(context, objectPath) {
    SP.ListTemplate.initializeBase(this, [context, objectPath]);
};
SP.ListTemplate.prototype = {
    get_allowsFolderCreation: function SP_ListTemplate$get_allowsFolderCreation() {
        this.checkUninitializedProperty('AllowsFolderCreation');
        return ((this.get_objectData()).get_properties())['AllowsFolderCreation'];
    },
    get_baseType: function SP_ListTemplate$get_baseType() {
        this.checkUninitializedProperty('BaseType');
        return ((this.get_objectData()).get_properties())['BaseType'];
    },
    get_description: function SP_ListTemplate$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    get_featureId: function SP_ListTemplate$get_featureId() {
        this.checkUninitializedProperty('FeatureId');
        return ((this.get_objectData()).get_properties())['FeatureId'];
    },
    get_hidden: function SP_ListTemplate$get_hidden() {
        this.checkUninitializedProperty('Hidden');
        return ((this.get_objectData()).get_properties())['Hidden'];
    },
    get_imageUrl: function SP_ListTemplate$get_imageUrl() {
        this.checkUninitializedProperty('ImageUrl');
        return ((this.get_objectData()).get_properties())['ImageUrl'];
    },
    get_internalName: function SP_ListTemplate$get_internalName() {
        this.checkUninitializedProperty('InternalName');
        return ((this.get_objectData()).get_properties())['InternalName'];
    },
    get_isCustomTemplate: function SP_ListTemplate$get_isCustomTemplate() {
        this.checkUninitializedProperty('IsCustomTemplate');
        return ((this.get_objectData()).get_properties())['IsCustomTemplate'];
    },
    get_name: function SP_ListTemplate$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    get_onQuickLaunch: function SP_ListTemplate$get_onQuickLaunch() {
        this.checkUninitializedProperty('OnQuickLaunch');
        return ((this.get_objectData()).get_properties())['OnQuickLaunch'];
    },
    get_listTemplateTypeKind: function SP_ListTemplate$get_listTemplateTypeKind() {
        this.checkUninitializedProperty('ListTemplateTypeKind');
        return ((this.get_objectData()).get_properties())['ListTemplateTypeKind'];
    },
    get_unique: function SP_ListTemplate$get_unique() {
        this.checkUninitializedProperty('Unique');
        return ((this.get_objectData()).get_properties())['Unique'];
    },
    initPropertiesFromJson: function SP_ListTemplate$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowsFolderCreation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowsFolderCreation'] = $v_0;
            delete parentNode.AllowsFolderCreation;
        }
        $v_0 = parentNode.BaseType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['BaseType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.BaseType;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.FeatureId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FeatureId'] = $v_0;
            delete parentNode.FeatureId;
        }
        $v_0 = parentNode.Hidden;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Hidden'] = $v_0;
            delete parentNode.Hidden;
        }
        $v_0 = parentNode.ImageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ImageUrl'] = $v_0;
            delete parentNode.ImageUrl;
        }
        $v_0 = parentNode.InternalName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['InternalName'] = $v_0;
            delete parentNode.InternalName;
        }
        $v_0 = parentNode.IsCustomTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsCustomTemplate'] = $v_0;
            delete parentNode.IsCustomTemplate;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.OnQuickLaunch;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['OnQuickLaunch'] = $v_0;
            delete parentNode.OnQuickLaunch;
        }
        $v_0 = parentNode.ListTemplateTypeKind;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListTemplateTypeKind'] = $v_0;
            delete parentNode.ListTemplateTypeKind;
        }
        $v_0 = parentNode.Unique;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Unique'] = $v_0;
            delete parentNode.Unique;
        }
    },
    getGlobalSchemaXml: function SP_ListTemplate$getGlobalSchemaXml() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetGlobalSchemaXml', null);

        $v_0.addQuery($v_2);
        $v_1 = [];
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    }
};
SP.ListTemplatePropertyNames = function SP_ListTemplatePropertyNames() {
};
SP.ListTemplateCollection = function SP_ListTemplateCollection(context, objectPath) {
    SP.ListTemplateCollection.initializeBase(this, [context, objectPath]);
};
SP.ListTemplateCollection.prototype = {
    itemAt: function SP_ListTemplateCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ListTemplateCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ListTemplateCollection$get_childItemType() {
        return SP.ListTemplate;
    },
    getByName: function SP_ListTemplateCollection$getByName(name) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByName'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByName'] = $v_2;
        }
        $v_1 = $v_2[name];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.ListTemplate($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByName', [name]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[name] = $v_1;
        }
        return $v_1;
    }
};
SP.MountedFolderInfo = function SP_MountedFolderInfo(context, objectPath) {
    SP.MountedFolderInfo.initializeBase(this, [context, objectPath]);
};
SP.MountedFolderInfo.prototype = {
    get_folderUrl: function SP_MountedFolderInfo$get_folderUrl() {
        this.checkUninitializedProperty('FolderUrl');
        return ((this.get_objectData()).get_properties())['FolderUrl'];
    },
    get_hasEditPermission: function SP_MountedFolderInfo$get_hasEditPermission() {
        this.checkUninitializedProperty('HasEditPermission');
        return ((this.get_objectData()).get_properties())['HasEditPermission'];
    },
    get_itemId: function SP_MountedFolderInfo$get_itemId() {
        this.checkUninitializedProperty('ItemId');
        return ((this.get_objectData()).get_properties())['ItemId'];
    },
    get_listTemplateType: function SP_MountedFolderInfo$get_listTemplateType() {
        this.checkUninitializedProperty('ListTemplateType');
        return ((this.get_objectData()).get_properties())['ListTemplateType'];
    },
    get_listViewUrl: function SP_MountedFolderInfo$get_listViewUrl() {
        this.checkUninitializedProperty('ListViewUrl');
        return ((this.get_objectData()).get_properties())['ListViewUrl'];
    },
    get_webUrl: function SP_MountedFolderInfo$get_webUrl() {
        this.checkUninitializedProperty('WebUrl');
        return ((this.get_objectData()).get_properties())['WebUrl'];
    },
    initPropertiesFromJson: function SP_MountedFolderInfo$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FolderUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FolderUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.FolderUrl;
        }
        $v_0 = parentNode.HasEditPermission;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasEditPermission'] = $v_0;
            delete parentNode.HasEditPermission;
        }
        $v_0 = parentNode.ItemId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemId'] = $v_0;
            delete parentNode.ItemId;
        }
        $v_0 = parentNode.ListTemplateType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListTemplateType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ListTemplateType;
        }
        $v_0 = parentNode.ListViewUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListViewUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ListViewUrl;
        }
        $v_0 = parentNode.WebUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.WebUrl;
        }
    }
};
SP.MountedFolderInfoPropertyNames = function SP_MountedFolderInfoPropertyNames() {
};
SP.MountPoint = function SP_MountPoint() {
};
SP.MountPoint.createMountPoint = function SP_MountPoint$createMountPoint(context, folder, name, targetSiteId, targetWebId, targetUniqueId) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{0489cfad-ccd4-422d-9014-be0f150e4389}', 'CreateMountPoint', [folder, name, targetSiteId, targetWebId, targetUniqueId]);

    context.addQuery($v_0);
};
SP.MountPoint.getMountedFolderInfo = function SP_MountPoint$getMountedFolderInfo(context, targetSiteId, targetWebId, targetUniqueId) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.MountedFolderInfo(context, new SP.ObjectPathStaticMethod(context, '{0489cfad-ccd4-422d-9014-be0f150e4389}', 'GetMountedFolderInfo', [targetSiteId, targetWebId, targetUniqueId]));
    return $v_0;
};
SP.MountPoint.getMountedFolderUrls = function SP_MountPoint$getMountedFolderUrls(context, list) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{0489cfad-ccd4-422d-9014-be0f150e4389}', 'GetMountedFolderUrls', [list]);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.MountPointInfo = function SP_MountPointInfo(context, objectPath) {
    SP.MountPointInfo.initializeBase(this, [context, objectPath]);
};
SP.MountPointInfo.prototype = {
    get_name: function SP_MountPointInfo$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    get_redirectUrl: function SP_MountPointInfo$get_redirectUrl() {
        this.checkUninitializedProperty('RedirectUrl');
        return ((this.get_objectData()).get_properties())['RedirectUrl'];
    },
    initPropertiesFromJson: function SP_MountPointInfo$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.RedirectUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RedirectUrl'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.RedirectUrl;
        }
    }
};
SP.MountPointInfoPropertyNames = function SP_MountPointInfoPropertyNames() {
};
SP.MoveCopyUtil = function SP_MoveCopyUtil() {
};
SP.MoveCopyUtil.moveFile = function SP_MoveCopyUtil$moveFile(context, srcUrl, destUrl, overwrite) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{c668c5ca-bbdd-435f-8008-502f3180cf20}', 'MoveFile', [srcUrl, destUrl, overwrite]);

    context.addQuery($v_0);
};
SP.MoveCopyUtil.copyFile = function SP_MoveCopyUtil$copyFile(context, srcUrl, destUrl, overwrite) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{c668c5ca-bbdd-435f-8008-502f3180cf20}', 'CopyFile', [srcUrl, destUrl, overwrite]);

    context.addQuery($v_0);
};
SP.MoveCopyUtil.moveFolder = function SP_MoveCopyUtil$moveFolder(context, srcUrl, destUrl) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{c668c5ca-bbdd-435f-8008-502f3180cf20}', 'MoveFolder', [srcUrl, destUrl]);

    context.addQuery($v_0);
};
SP.MoveCopyUtil.copyFolder = function SP_MoveCopyUtil$copyFolder(context, srcUrl, destUrl) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{c668c5ca-bbdd-435f-8008-502f3180cf20}', 'CopyFolder', [srcUrl, destUrl]);

    context.addQuery($v_0);
};
SP.Navigation = function SP_Navigation(context, objectPath) {
    SP.Navigation.initializeBase(this, [context, objectPath]);
};
SP.Navigation.prototype = {
    get_quickLaunch: function SP_Navigation$get_quickLaunch() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['QuickLaunch'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.NavigationNodeCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'QuickLaunch'));
            ((this.get_objectData()).get_clientObjectProperties())['QuickLaunch'] = $v_0;
        }
        return $v_0;
    },
    get_topNavigationBar: function SP_Navigation$get_topNavigationBar() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['TopNavigationBar'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.NavigationNodeCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'TopNavigationBar'));
            ((this.get_objectData()).get_clientObjectProperties())['TopNavigationBar'] = $v_0;
        }
        return $v_0;
    },
    get_useShared: function SP_Navigation$get_useShared() {
        this.checkUninitializedProperty('UseShared');
        return ((this.get_objectData()).get_properties())['UseShared'];
    },
    set_useShared: function SP_Navigation$set_useShared(value) {
        ((this.get_objectData()).get_properties())['UseShared'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'UseShared', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_Navigation$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.QuickLaunch;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('QuickLaunch', this.get_quickLaunch(), $v_0);
            (this.get_quickLaunch()).fromJson($v_0);
            delete parentNode.QuickLaunch;
        }
        $v_0 = parentNode.TopNavigationBar;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('TopNavigationBar', this.get_topNavigationBar(), $v_0);
            (this.get_topNavigationBar()).fromJson($v_0);
            delete parentNode.TopNavigationBar;
        }
        $v_0 = parentNode.UseShared;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UseShared'] = $v_0;
            delete parentNode.UseShared;
        }
    },
    getNodeById: function SP_Navigation$getNodeById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetNodeById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetNodeById'] = $v_2;
        }
        $v_1 = $v_2[id];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.NavigationNode($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetNodeById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id] = $v_1;
        }
        return $v_1;
    }
};
SP.NavigationPropertyNames = function SP_NavigationPropertyNames() {
};
SP.NavigationObjectPropertyNames = function SP_NavigationObjectPropertyNames() {
};
SP.NavigationNode = function SP_NavigationNode(context, objectPath) {
    SP.NavigationNode.initializeBase(this, [context, objectPath]);
};
SP.NavigationNode.prototype = {
    $F_1: function SP_NavigationNode$$F_1($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Title'] = $p0.$0_1;
            ((this.get_objectData()).get_properties())['Url'] = $p0.$1_1;
        }
    },
    get_children: function SP_NavigationNode$get_children() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Children'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.NavigationNodeCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Children'));
            ((this.get_objectData()).get_clientObjectProperties())['Children'] = $v_0;
        }
        return $v_0;
    },
    get_id: function SP_NavigationNode$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_isDocLib: function SP_NavigationNode$get_isDocLib() {
        this.checkUninitializedProperty('IsDocLib');
        return ((this.get_objectData()).get_properties())['IsDocLib'];
    },
    get_isExternal: function SP_NavigationNode$get_isExternal() {
        this.checkUninitializedProperty('IsExternal');
        return ((this.get_objectData()).get_properties())['IsExternal'];
    },
    get_isVisible: function SP_NavigationNode$get_isVisible() {
        this.checkUninitializedProperty('IsVisible');
        return ((this.get_objectData()).get_properties())['IsVisible'];
    },
    set_isVisible: function SP_NavigationNode$set_isVisible(value) {
        ((this.get_objectData()).get_properties())['IsVisible'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IsVisible', value));
        }
        return value;
    },
    get_title: function SP_NavigationNode$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    set_title: function SP_NavigationNode$set_title(value) {
        ((this.get_objectData()).get_properties())['Title'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Title', value));
        }
        return value;
    },
    get_url: function SP_NavigationNode$get_url() {
        this.checkUninitializedProperty('Url');
        return ((this.get_objectData()).get_properties())['Url'];
    },
    set_url: function SP_NavigationNode$set_url(value) {
        ((this.get_objectData()).get_properties())['Url'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Url', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_NavigationNode$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Children;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Children', this.get_children(), $v_0);
            (this.get_children()).fromJson($v_0);
            delete parentNode.Children;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.IsDocLib;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsDocLib'] = $v_0;
            delete parentNode.IsDocLib;
        }
        $v_0 = parentNode.IsExternal;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsExternal'] = $v_0;
            delete parentNode.IsExternal;
        }
        $v_0 = parentNode.IsVisible;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsVisible'] = $v_0;
            delete parentNode.IsVisible;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Url'] = $v_0;
            delete parentNode.Url;
        }
    },
    update: function SP_NavigationNode$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
        this.refreshLoad();
    },
    deleteObject: function SP_NavigationNode$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.NavigationNodePropertyNames = function SP_NavigationNodePropertyNames() {
};
SP.NavigationNodeObjectPropertyNames = function SP_NavigationNodeObjectPropertyNames() {
};
SP.NavigationNodeCollection = function SP_NavigationNodeCollection(context, objectPath) {
    SP.NavigationNodeCollection.initializeBase(this, [context, objectPath]);
};
SP.NavigationNodeCollection.prototype = {
    itemAt: function SP_NavigationNodeCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_NavigationNodeCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_NavigationNodeCollection$get_childItemType() {
        return SP.NavigationNode;
    },
    add: function SP_NavigationNodeCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.NavigationNode($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_1(parameters);
        return $v_1;
    }
};
SP.NavigationNodeCreationInformation = function SP_NavigationNodeCreationInformation() {
    SP.NavigationNodeCreationInformation.initializeBase(this);
};
SP.NavigationNodeCreationInformation.prototype = {
    $2B_1: false,
    $49_1: false,
    $6c_1: null,
    $0_1: null,
    $1_1: null,
    get_asLastNode: function SP_NavigationNodeCreationInformation$get_asLastNode() {
        return this.$2B_1;
    },
    set_asLastNode: function SP_NavigationNodeCreationInformation$set_asLastNode(value) {
        this.$2B_1 = value;
        return value;
    },
    get_isExternal: function SP_NavigationNodeCreationInformation$get_isExternal() {
        return this.$49_1;
    },
    set_isExternal: function SP_NavigationNodeCreationInformation$set_isExternal(value) {
        this.$49_1 = value;
        return value;
    },
    get_previousNode: function SP_NavigationNodeCreationInformation$get_previousNode() {
        return this.$6c_1;
    },
    set_previousNode: function SP_NavigationNodeCreationInformation$set_previousNode(value) {
        this.$6c_1 = value;
        return value;
    },
    get_title: function SP_NavigationNodeCreationInformation$get_title() {
        return this.$0_1;
    },
    set_title: function SP_NavigationNodeCreationInformation$set_title(value) {
        this.$0_1 = value;
        return value;
    },
    get_url: function SP_NavigationNodeCreationInformation$get_url() {
        return this.$1_1;
    },
    set_url: function SP_NavigationNodeCreationInformation$set_url(value) {
        this.$1_1 = value;
        return value;
    },
    get_typeId: function SP_NavigationNodeCreationInformation$get_typeId() {
        return '{7aaaa605-79a9-4fda-ae1e-db952e5083e0}';
    },
    writeToXml: function SP_NavigationNodeCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['AsLastNode', 'IsExternal', 'PreviousNode', 'Title', 'Url'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_NavigationNodeCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AsLastNode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2B_1 = $v_0;
            delete parentNode.AsLastNode;
        }
        $v_0 = parentNode.IsExternal;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$49_1 = $v_0;
            delete parentNode.IsExternal;
        }
        $v_0 = parentNode.PreviousNode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            delete parentNode.PreviousNode;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1_1 = $v_0;
            delete parentNode.Url;
        }
    }
};
SP.ObjectSharingInformation = function SP_ObjectSharingInformation(context, objectPath) {
    SP.ObjectSharingInformation.initializeBase(this, [context, objectPath]);
};
SP.ObjectSharingInformation.getListItemSharingInformation = function SP_ObjectSharingInformation$getListItemSharingInformation(context, listID, itemID, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ObjectSharingInformation(context, new SP.ObjectPathStaticMethod(context, '{e7dae9f6-8ca5-4286-92c8-61941d774c44}', 'GetListItemSharingInformation', [listID, itemID, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests]));
    return $v_0;
};
SP.ObjectSharingInformation.getWebSharingInformation = function SP_ObjectSharingInformation$getWebSharingInformation(context, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ObjectSharingInformation(context, new SP.ObjectPathStaticMethod(context, '{e7dae9f6-8ca5-4286-92c8-61941d774c44}', 'GetWebSharingInformation', [excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests]));
    return $v_0;
};
SP.ObjectSharingInformation.getObjectSharingInformation = function SP_ObjectSharingInformation$getObjectSharingInformation(context, securableObject, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests, retrievePermissionLevels) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ObjectSharingInformation(context, new SP.ObjectPathStaticMethod(context, '{e7dae9f6-8ca5-4286-92c8-61941d774c44}', 'GetObjectSharingInformation', [securableObject, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests, retrievePermissionLevels]));
    return $v_0;
};
SP.ObjectSharingInformation.getObjectSharingInformationByUrl = function SP_ObjectSharingInformation$getObjectSharingInformationByUrl(context, objectUrl, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests, retrievePermissionLevels) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ObjectSharingInformation(context, new SP.ObjectPathStaticMethod(context, '{e7dae9f6-8ca5-4286-92c8-61941d774c44}', 'GetObjectSharingInformationByUrl', [objectUrl, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests, retrievePermissionLevels]));
    return $v_0;
};
SP.ObjectSharingInformation.getObjectSharingInformation2 = function SP_ObjectSharingInformation$getObjectSharingInformation2(context, securableObject, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests, retrievePermissionLevels, forceRetrievePermissionLevels) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ObjectSharingInformation(context, new SP.ObjectPathStaticMethod(context, '{e7dae9f6-8ca5-4286-92c8-61941d774c44}', 'GetObjectSharingInformation2', [securableObject, excludeCurrentUser, excludeSiteAdmin, excludeSecurityGroups, retrieveAnonymousLinks, retrieveUserInfoDetails, checkForAccessRequests, retrievePermissionLevels, forceRetrievePermissionLevels]));
    return $v_0;
};
SP.ObjectSharingInformation.canCurrentUserShare = function SP_ObjectSharingInformation$canCurrentUserShare(context, docId) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{e7dae9f6-8ca5-4286-92c8-61941d774c44}', 'CanCurrentUserShare', [docId]);

    context.addQuery($v_1);
    $v_0 = new SP.IntResult();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.ObjectSharingInformation.canCurrentUserShareRemote = function SP_ObjectSharingInformation$canCurrentUserShareRemote(context, docId) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{e7dae9f6-8ca5-4286-92c8-61941d774c44}', 'CanCurrentUserShareRemote', [docId]);

    context.addQuery($v_1);
    $v_0 = new SP.IntResult();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.ObjectSharingInformation.prototype = {
    get_anonymousEditLink: function SP_ObjectSharingInformation$get_anonymousEditLink() {
        this.checkUninitializedProperty('AnonymousEditLink');
        return ((this.get_objectData()).get_properties())['AnonymousEditLink'];
    },
    get_anonymousViewLink: function SP_ObjectSharingInformation$get_anonymousViewLink() {
        this.checkUninitializedProperty('AnonymousViewLink');
        return ((this.get_objectData()).get_properties())['AnonymousViewLink'];
    },
    get_canBeShared: function SP_ObjectSharingInformation$get_canBeShared() {
        this.checkUninitializedProperty('CanBeShared');
        return ((this.get_objectData()).get_properties())['CanBeShared'];
    },
    get_canBeUnshared: function SP_ObjectSharingInformation$get_canBeUnshared() {
        this.checkUninitializedProperty('CanBeUnshared');
        return ((this.get_objectData()).get_properties())['CanBeUnshared'];
    },
    get_canManagePermissions: function SP_ObjectSharingInformation$get_canManagePermissions() {
        this.checkUninitializedProperty('CanManagePermissions');
        return ((this.get_objectData()).get_properties())['CanManagePermissions'];
    },
    get_hasPendingAccessRequests: function SP_ObjectSharingInformation$get_hasPendingAccessRequests() {
        this.checkUninitializedProperty('HasPendingAccessRequests');
        return ((this.get_objectData()).get_properties())['HasPendingAccessRequests'];
    },
    get_hasPermissionLevels: function SP_ObjectSharingInformation$get_hasPermissionLevels() {
        this.checkUninitializedProperty('HasPermissionLevels');
        return ((this.get_objectData()).get_properties())['HasPermissionLevels'];
    },
    get_isSharedWithCurrentUser: function SP_ObjectSharingInformation$get_isSharedWithCurrentUser() {
        this.checkUninitializedProperty('IsSharedWithCurrentUser');
        return ((this.get_objectData()).get_properties())['IsSharedWithCurrentUser'];
    },
    get_isSharedWithGuest: function SP_ObjectSharingInformation$get_isSharedWithGuest() {
        this.checkUninitializedProperty('IsSharedWithGuest');
        return ((this.get_objectData()).get_properties())['IsSharedWithGuest'];
    },
    get_isSharedWithMany: function SP_ObjectSharingInformation$get_isSharedWithMany() {
        this.checkUninitializedProperty('IsSharedWithMany');
        return ((this.get_objectData()).get_properties())['IsSharedWithMany'];
    },
    get_isSharedWithSecurityGroup: function SP_ObjectSharingInformation$get_isSharedWithSecurityGroup() {
        this.checkUninitializedProperty('IsSharedWithSecurityGroup');
        return ((this.get_objectData()).get_properties())['IsSharedWithSecurityGroup'];
    },
    get_pendingAccessRequestsLink: function SP_ObjectSharingInformation$get_pendingAccessRequestsLink() {
        this.checkUninitializedProperty('PendingAccessRequestsLink');
        return ((this.get_objectData()).get_properties())['PendingAccessRequestsLink'];
    },
    get_sharedWithUsersCollection: function SP_ObjectSharingInformation$get_sharedWithUsersCollection() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['SharedWithUsersCollection'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ObjectSharingInformationUserCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'SharedWithUsersCollection'));
            ((this.get_objectData()).get_clientObjectProperties())['SharedWithUsersCollection'] = $v_0;
        }
        return $v_0;
    },
    get_sharingLinks: function SP_ObjectSharingInformation$get_sharingLinks() {
        this.checkUninitializedProperty('SharingLinks');
        return ((this.get_objectData()).get_properties())['SharingLinks'];
    },
    initPropertiesFromJson: function SP_ObjectSharingInformation$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AnonymousEditLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AnonymousEditLink'] = $v_0;
            delete parentNode.AnonymousEditLink;
        }
        $v_0 = parentNode.AnonymousViewLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AnonymousViewLink'] = $v_0;
            delete parentNode.AnonymousViewLink;
        }
        $v_0 = parentNode.CanBeShared;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanBeShared'] = $v_0;
            delete parentNode.CanBeShared;
        }
        $v_0 = parentNode.CanBeUnshared;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanBeUnshared'] = $v_0;
            delete parentNode.CanBeUnshared;
        }
        $v_0 = parentNode.CanManagePermissions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanManagePermissions'] = $v_0;
            delete parentNode.CanManagePermissions;
        }
        $v_0 = parentNode.HasPendingAccessRequests;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasPendingAccessRequests'] = $v_0;
            delete parentNode.HasPendingAccessRequests;
        }
        $v_0 = parentNode.HasPermissionLevels;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasPermissionLevels'] = $v_0;
            delete parentNode.HasPermissionLevels;
        }
        $v_0 = parentNode.IsSharedWithCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsSharedWithCurrentUser'] = $v_0;
            delete parentNode.IsSharedWithCurrentUser;
        }
        $v_0 = parentNode.IsSharedWithGuest;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsSharedWithGuest'] = $v_0;
            delete parentNode.IsSharedWithGuest;
        }
        $v_0 = parentNode.IsSharedWithMany;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsSharedWithMany'] = $v_0;
            delete parentNode.IsSharedWithMany;
        }
        $v_0 = parentNode.IsSharedWithSecurityGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsSharedWithSecurityGroup'] = $v_0;
            delete parentNode.IsSharedWithSecurityGroup;
        }
        $v_0 = parentNode.PendingAccessRequestsLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PendingAccessRequestsLink'] = $v_0;
            delete parentNode.PendingAccessRequestsLink;
        }
        $v_0 = parentNode.SharedWithUsersCollection;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('SharedWithUsersCollection', this.get_sharedWithUsersCollection(), $v_0);
            (this.get_sharedWithUsersCollection()).fromJson($v_0);
            delete parentNode.SharedWithUsersCollection;
        }
        $v_0 = parentNode.SharingLinks;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SharingLinks'] = [];
            SP.DataConvert.populateArray(this.get_context(), ((this.get_objectData()).get_properties())['SharingLinks'], $v_0);
            delete parentNode.SharingLinks;
        }
    },
    getSharedWithUsers: function SP_ObjectSharingInformation$getSharedWithUsers() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ClientObjectList($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetSharedWithUsers', null), SP.ObjectSharingInformationUser);
        return $v_1;
    }
};
SP.ObjectSharingInformationPropertyNames = function SP_ObjectSharingInformationPropertyNames() {
};
SP.ObjectSharingInformationObjectPropertyNames = function SP_ObjectSharingInformationObjectPropertyNames() {
};
SP.ObjectSharingInformationUser = function SP_ObjectSharingInformationUser(context, objectPath) {
    SP.ObjectSharingInformationUser.initializeBase(this, [context, objectPath]);
};
SP.ObjectSharingInformationUser.prototype = {
    get_customRoleNames: function SP_ObjectSharingInformationUser$get_customRoleNames() {
        this.checkUninitializedProperty('CustomRoleNames');
        return ((this.get_objectData()).get_properties())['CustomRoleNames'];
    },
    get_department: function SP_ObjectSharingInformationUser$get_department() {
        this.checkUninitializedProperty('Department');
        return ((this.get_objectData()).get_properties())['Department'];
    },
    get_email: function SP_ObjectSharingInformationUser$get_email() {
        this.checkUninitializedProperty('Email');
        return ((this.get_objectData()).get_properties())['Email'];
    },
    get_hasEditPermission: function SP_ObjectSharingInformationUser$get_hasEditPermission() {
        this.checkUninitializedProperty('HasEditPermission');
        return ((this.get_objectData()).get_properties())['HasEditPermission'];
    },
    get_hasViewPermission: function SP_ObjectSharingInformationUser$get_hasViewPermission() {
        this.checkUninitializedProperty('HasViewPermission');
        return ((this.get_objectData()).get_properties())['HasViewPermission'];
    },
    get_id: function SP_ObjectSharingInformationUser$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_isDomainGroup: function SP_ObjectSharingInformationUser$get_isDomainGroup() {
        this.checkUninitializedProperty('IsDomainGroup');
        return ((this.get_objectData()).get_properties())['IsDomainGroup'];
    },
    get_isMemberOfGroup: function SP_ObjectSharingInformationUser$get_isMemberOfGroup() {
        this.checkUninitializedProperty('IsMemberOfGroup');
        return ((this.get_objectData()).get_properties())['IsMemberOfGroup'];
    },
    get_isSiteAdmin: function SP_ObjectSharingInformationUser$get_isSiteAdmin() {
        this.checkUninitializedProperty('IsSiteAdmin');
        return ((this.get_objectData()).get_properties())['IsSiteAdmin'];
    },
    get_jobTitle: function SP_ObjectSharingInformationUser$get_jobTitle() {
        this.checkUninitializedProperty('JobTitle');
        return ((this.get_objectData()).get_properties())['JobTitle'];
    },
    get_loginName: function SP_ObjectSharingInformationUser$get_loginName() {
        this.checkUninitializedProperty('LoginName');
        return ((this.get_objectData()).get_properties())['LoginName'];
    },
    get_name: function SP_ObjectSharingInformationUser$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    get_picture: function SP_ObjectSharingInformationUser$get_picture() {
        this.checkUninitializedProperty('Picture');
        return ((this.get_objectData()).get_properties())['Picture'];
    },
    get_principal: function SP_ObjectSharingInformationUser$get_principal() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Principal'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Principal(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Principal'));
            ((this.get_objectData()).get_clientObjectProperties())['Principal'] = $v_0;
        }
        return $v_0;
    },
    get_sipAddress: function SP_ObjectSharingInformationUser$get_sipAddress() {
        this.checkUninitializedProperty('SipAddress');
        return ((this.get_objectData()).get_properties())['SipAddress'];
    },
    get_user: function SP_ObjectSharingInformationUser$get_user() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['User'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'User'));
            ((this.get_objectData()).get_clientObjectProperties())['User'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_ObjectSharingInformationUser$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CustomRoleNames;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CustomRoleNames'] = $v_0;
            delete parentNode.CustomRoleNames;
        }
        $v_0 = parentNode.Department;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Department'] = $v_0;
            delete parentNode.Department;
        }
        $v_0 = parentNode.Email;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Email'] = $v_0;
            delete parentNode.Email;
        }
        $v_0 = parentNode.HasEditPermission;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasEditPermission'] = $v_0;
            delete parentNode.HasEditPermission;
        }
        $v_0 = parentNode.HasViewPermission;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasViewPermission'] = $v_0;
            delete parentNode.HasViewPermission;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.IsDomainGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsDomainGroup'] = $v_0;
            delete parentNode.IsDomainGroup;
        }
        $v_0 = parentNode.IsMemberOfGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsMemberOfGroup'] = $v_0;
            delete parentNode.IsMemberOfGroup;
        }
        $v_0 = parentNode.IsSiteAdmin;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsSiteAdmin'] = $v_0;
            delete parentNode.IsSiteAdmin;
        }
        $v_0 = parentNode.JobTitle;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['JobTitle'] = $v_0;
            delete parentNode.JobTitle;
        }
        $v_0 = parentNode.LoginName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LoginName'] = $v_0;
            delete parentNode.LoginName;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.Picture;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Picture'] = $v_0;
            delete parentNode.Picture;
        }
        $v_0 = parentNode.Principal;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Principal', this.get_principal(), $v_0);
            (this.get_principal()).fromJson($v_0);
            delete parentNode.Principal;
        }
        $v_0 = parentNode.SipAddress;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SipAddress'] = $v_0;
            delete parentNode.SipAddress;
        }
        $v_0 = parentNode.User;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('User', this.get_user(), $v_0);
            (this.get_user()).fromJson($v_0);
            delete parentNode.User;
        }
    }
};
SP.ObjectSharingInformationUserPropertyNames = function SP_ObjectSharingInformationUserPropertyNames() {
};
SP.ObjectSharingInformationUserObjectPropertyNames = function SP_ObjectSharingInformationUserObjectPropertyNames() {
};
SP.ObjectSharingInformationUserCollection = function SP_ObjectSharingInformationUserCollection(context, objectPath) {
    SP.ObjectSharingInformationUserCollection.initializeBase(this, [context, objectPath]);
};
SP.ObjectSharingInformationUserCollection.prototype = {
    itemAt: function SP_ObjectSharingInformationUserCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ObjectSharingInformationUserCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ObjectSharingInformationUserCollection$get_childItemType() {
        return SP.ObjectSharingInformationUser;
    }
};
SP.ObjectSharingSettings = function SP_ObjectSharingSettings(context, objectPath) {
    SP.ObjectSharingSettings.initializeBase(this, [context, objectPath]);
};
SP.ObjectSharingSettings.prototype = {
    get_accessRequestMode: function SP_ObjectSharingSettings$get_accessRequestMode() {
        this.checkUninitializedProperty('AccessRequestMode');
        return ((this.get_objectData()).get_properties())['AccessRequestMode'];
    },
    get_canCurrentUserManageOrganizationReadonlyLink: function SP_ObjectSharingSettings$get_canCurrentUserManageOrganizationReadonlyLink() {
        this.checkUninitializedProperty('CanCurrentUserManageOrganizationReadonlyLink');
        return ((this.get_objectData()).get_properties())['CanCurrentUserManageOrganizationReadonlyLink'];
    },
    get_canCurrentUserManageOrganizationReadWriteLink: function SP_ObjectSharingSettings$get_canCurrentUserManageOrganizationReadWriteLink() {
        this.checkUninitializedProperty('CanCurrentUserManageOrganizationReadWriteLink');
        return ((this.get_objectData()).get_properties())['CanCurrentUserManageOrganizationReadWriteLink'];
    },
    get_canCurrentUserManageReadonlyLink: function SP_ObjectSharingSettings$get_canCurrentUserManageReadonlyLink() {
        this.checkUninitializedProperty('CanCurrentUserManageReadonlyLink');
        return ((this.get_objectData()).get_properties())['CanCurrentUserManageReadonlyLink'];
    },
    get_canCurrentUserManageReadWriteLink: function SP_ObjectSharingSettings$get_canCurrentUserManageReadWriteLink() {
        this.checkUninitializedProperty('CanCurrentUserManageReadWriteLink');
        return ((this.get_objectData()).get_properties())['CanCurrentUserManageReadWriteLink'];
    },
    get_canCurrentUserRetrieveOrganizationReadonlyLink: function SP_ObjectSharingSettings$get_canCurrentUserRetrieveOrganizationReadonlyLink() {
        this.checkUninitializedProperty('CanCurrentUserRetrieveOrganizationReadonlyLink');
        return ((this.get_objectData()).get_properties())['CanCurrentUserRetrieveOrganizationReadonlyLink'];
    },
    get_canCurrentUserRetrieveOrganizationReadWriteLink: function SP_ObjectSharingSettings$get_canCurrentUserRetrieveOrganizationReadWriteLink() {
        this.checkUninitializedProperty('CanCurrentUserRetrieveOrganizationReadWriteLink');
        return ((this.get_objectData()).get_properties())['CanCurrentUserRetrieveOrganizationReadWriteLink'];
    },
    get_canCurrentUserRetrieveReadonlyLink: function SP_ObjectSharingSettings$get_canCurrentUserRetrieveReadonlyLink() {
        this.checkUninitializedProperty('CanCurrentUserRetrieveReadonlyLink');
        return ((this.get_objectData()).get_properties())['CanCurrentUserRetrieveReadonlyLink'];
    },
    get_canCurrentUserRetrieveReadWriteLink: function SP_ObjectSharingSettings$get_canCurrentUserRetrieveReadWriteLink() {
        this.checkUninitializedProperty('CanCurrentUserRetrieveReadWriteLink');
        return ((this.get_objectData()).get_properties())['CanCurrentUserRetrieveReadWriteLink'];
    },
    get_canCurrentUserShareExternally: function SP_ObjectSharingSettings$get_canCurrentUserShareExternally() {
        this.checkUninitializedProperty('CanCurrentUserShareExternally');
        return ((this.get_objectData()).get_properties())['CanCurrentUserShareExternally'];
    },
    get_canCurrentUserShareInternally: function SP_ObjectSharingSettings$get_canCurrentUserShareInternally() {
        this.checkUninitializedProperty('CanCurrentUserShareInternally');
        return ((this.get_objectData()).get_properties())['CanCurrentUserShareInternally'];
    },
    get_canSendEmail: function SP_ObjectSharingSettings$get_canSendEmail() {
        this.checkUninitializedProperty('CanSendEmail');
        return ((this.get_objectData()).get_properties())['CanSendEmail'];
    },
    get_canSendLink: function SP_ObjectSharingSettings$get_canSendLink() {
        this.checkUninitializedProperty('CanSendLink');
        return ((this.get_objectData()).get_properties())['CanSendLink'];
    },
    get_canShareFolder: function SP_ObjectSharingSettings$get_canShareFolder() {
        this.checkUninitializedProperty('CanShareFolder');
        return ((this.get_objectData()).get_properties())['CanShareFolder'];
    },
    get_groupsList: function SP_ObjectSharingSettings$get_groupsList() {
        this.checkUninitializedProperty('GroupsList');
        return ((this.get_objectData()).get_properties())['GroupsList'];
    },
    get_hasEditRole: function SP_ObjectSharingSettings$get_hasEditRole() {
        this.checkUninitializedProperty('HasEditRole');
        return ((this.get_objectData()).get_properties())['HasEditRole'];
    },
    get_hasReadRole: function SP_ObjectSharingSettings$get_hasReadRole() {
        this.checkUninitializedProperty('HasReadRole');
        return ((this.get_objectData()).get_properties())['HasReadRole'];
    },
    get_inheritingWebLink: function SP_ObjectSharingSettings$get_inheritingWebLink() {
        this.checkUninitializedProperty('InheritingWebLink');
        return ((this.get_objectData()).get_properties())['InheritingWebLink'];
    },
    get_isGuestUser: function SP_ObjectSharingSettings$get_isGuestUser() {
        this.checkUninitializedProperty('IsGuestUser');
        return ((this.get_objectData()).get_properties())['IsGuestUser'];
    },
    get_isPictureLibrary: function SP_ObjectSharingSettings$get_isPictureLibrary() {
        this.checkUninitializedProperty('IsPictureLibrary');
        return ((this.get_objectData()).get_properties())['IsPictureLibrary'];
    },
    get_isUserSiteAdmin: function SP_ObjectSharingSettings$get_isUserSiteAdmin() {
        this.checkUninitializedProperty('IsUserSiteAdmin');
        return ((this.get_objectData()).get_properties())['IsUserSiteAdmin'];
    },
    get_itemId: function SP_ObjectSharingSettings$get_itemId() {
        this.checkUninitializedProperty('ItemId');
        return ((this.get_objectData()).get_properties())['ItemId'];
    },
    get_itemName: function SP_ObjectSharingSettings$get_itemName() {
        this.checkUninitializedProperty('ItemName');
        return ((this.get_objectData()).get_properties())['ItemName'];
    },
    get_itemUrl: function SP_ObjectSharingSettings$get_itemUrl() {
        this.checkUninitializedProperty('ItemUrl');
        return ((this.get_objectData()).get_properties())['ItemUrl'];
    },
    get_listId: function SP_ObjectSharingSettings$get_listId() {
        this.checkUninitializedProperty('ListId');
        return ((this.get_objectData()).get_properties())['ListId'];
    },
    get_objectSharingInformation: function SP_ObjectSharingSettings$get_objectSharingInformation() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ObjectSharingInformation'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ObjectSharingInformation(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ObjectSharingInformation'));
            ((this.get_objectData()).get_clientObjectProperties())['ObjectSharingInformation'] = $v_0;
        }
        return $v_0;
    },
    get_permissionsOnlyMode: function SP_ObjectSharingSettings$get_permissionsOnlyMode() {
        this.checkUninitializedProperty('PermissionsOnlyMode');
        return ((this.get_objectData()).get_properties())['PermissionsOnlyMode'];
    },
    get_requiredAnonymousLinkExpirationInDays: function SP_ObjectSharingSettings$get_requiredAnonymousLinkExpirationInDays() {
        this.checkUninitializedProperty('RequiredAnonymousLinkExpirationInDays');
        return ((this.get_objectData()).get_properties())['RequiredAnonymousLinkExpirationInDays'];
    },
    get_roles: function SP_ObjectSharingSettings$get_roles() {
        this.checkUninitializedProperty('Roles');
        return ((this.get_objectData()).get_properties())['Roles'];
    },
    get_shareByEmailEnabled: function SP_ObjectSharingSettings$get_shareByEmailEnabled() {
        this.checkUninitializedProperty('ShareByEmailEnabled');
        return ((this.get_objectData()).get_properties())['ShareByEmailEnabled'];
    },
    get_sharePointSettings: function SP_ObjectSharingSettings$get_sharePointSettings() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['SharePointSettings'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.SharePointSharingSettings(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'SharePointSettings'));
            ((this.get_objectData()).get_clientObjectProperties())['SharePointSettings'] = $v_0;
        }
        return $v_0;
    },
    get_sharingPermissions: function SP_ObjectSharingSettings$get_sharingPermissions() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['SharingPermissions'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.SharingPermissionInformationCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'SharingPermissions'));
            ((this.get_objectData()).get_clientObjectProperties())['SharingPermissions'] = $v_0;
        }
        return $v_0;
    },
    get_showExternalSharingWarning: function SP_ObjectSharingSettings$get_showExternalSharingWarning() {
        this.checkUninitializedProperty('ShowExternalSharingWarning');
        return ((this.get_objectData()).get_properties())['ShowExternalSharingWarning'];
    },
    get_simplifiedRoles: function SP_ObjectSharingSettings$get_simplifiedRoles() {
        this.checkUninitializedProperty('SimplifiedRoles');
        return ((this.get_objectData()).get_properties())['SimplifiedRoles'];
    },
    get_supportsAclPropagation: function SP_ObjectSharingSettings$get_supportsAclPropagation() {
        this.checkUninitializedProperty('SupportsAclPropagation');
        return ((this.get_objectData()).get_properties())['SupportsAclPropagation'];
    },
    get_webUrl: function SP_ObjectSharingSettings$get_webUrl() {
        this.checkUninitializedProperty('WebUrl');
        return ((this.get_objectData()).get_properties())['WebUrl'];
    },
    initPropertiesFromJson: function SP_ObjectSharingSettings$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AccessRequestMode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AccessRequestMode'] = $v_0;
            delete parentNode.AccessRequestMode;
        }
        $v_0 = parentNode.CanCurrentUserManageOrganizationReadonlyLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserManageOrganizationReadonlyLink'] = $v_0;
            delete parentNode.CanCurrentUserManageOrganizationReadonlyLink;
        }
        $v_0 = parentNode.CanCurrentUserManageOrganizationReadWriteLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserManageOrganizationReadWriteLink'] = $v_0;
            delete parentNode.CanCurrentUserManageOrganizationReadWriteLink;
        }
        $v_0 = parentNode.CanCurrentUserManageReadonlyLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserManageReadonlyLink'] = $v_0;
            delete parentNode.CanCurrentUserManageReadonlyLink;
        }
        $v_0 = parentNode.CanCurrentUserManageReadWriteLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserManageReadWriteLink'] = $v_0;
            delete parentNode.CanCurrentUserManageReadWriteLink;
        }
        $v_0 = parentNode.CanCurrentUserRetrieveOrganizationReadonlyLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserRetrieveOrganizationReadonlyLink'] = $v_0;
            delete parentNode.CanCurrentUserRetrieveOrganizationReadonlyLink;
        }
        $v_0 = parentNode.CanCurrentUserRetrieveOrganizationReadWriteLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserRetrieveOrganizationReadWriteLink'] = $v_0;
            delete parentNode.CanCurrentUserRetrieveOrganizationReadWriteLink;
        }
        $v_0 = parentNode.CanCurrentUserRetrieveReadonlyLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserRetrieveReadonlyLink'] = $v_0;
            delete parentNode.CanCurrentUserRetrieveReadonlyLink;
        }
        $v_0 = parentNode.CanCurrentUserRetrieveReadWriteLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserRetrieveReadWriteLink'] = $v_0;
            delete parentNode.CanCurrentUserRetrieveReadWriteLink;
        }
        $v_0 = parentNode.CanCurrentUserShareExternally;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserShareExternally'] = $v_0;
            delete parentNode.CanCurrentUserShareExternally;
        }
        $v_0 = parentNode.CanCurrentUserShareInternally;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanCurrentUserShareInternally'] = $v_0;
            delete parentNode.CanCurrentUserShareInternally;
        }
        $v_0 = parentNode.CanSendEmail;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanSendEmail'] = $v_0;
            delete parentNode.CanSendEmail;
        }
        $v_0 = parentNode.CanSendLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanSendLink'] = $v_0;
            delete parentNode.CanSendLink;
        }
        $v_0 = parentNode.CanShareFolder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanShareFolder'] = $v_0;
            delete parentNode.CanShareFolder;
        }
        $v_0 = parentNode.GroupsList;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GroupsList'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.GroupsList;
        }
        $v_0 = parentNode.HasEditRole;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasEditRole'] = $v_0;
            delete parentNode.HasEditRole;
        }
        $v_0 = parentNode.HasReadRole;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasReadRole'] = $v_0;
            delete parentNode.HasReadRole;
        }
        $v_0 = parentNode.InheritingWebLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['InheritingWebLink'] = $v_0;
            delete parentNode.InheritingWebLink;
        }
        $v_0 = parentNode.IsGuestUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsGuestUser'] = $v_0;
            delete parentNode.IsGuestUser;
        }
        $v_0 = parentNode.IsPictureLibrary;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsPictureLibrary'] = $v_0;
            delete parentNode.IsPictureLibrary;
        }
        $v_0 = parentNode.IsUserSiteAdmin;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsUserSiteAdmin'] = $v_0;
            delete parentNode.IsUserSiteAdmin;
        }
        $v_0 = parentNode.ItemId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemId'] = $v_0;
            delete parentNode.ItemId;
        }
        $v_0 = parentNode.ItemName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemName'] = $v_0;
            delete parentNode.ItemName;
        }
        $v_0 = parentNode.ItemUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemUrl'] = $v_0;
            delete parentNode.ItemUrl;
        }
        $v_0 = parentNode.ListId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListId'] = $v_0;
            delete parentNode.ListId;
        }
        $v_0 = parentNode.ObjectSharingInformation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ObjectSharingInformation', this.get_objectSharingInformation(), $v_0);
            (this.get_objectSharingInformation()).fromJson($v_0);
            delete parentNode.ObjectSharingInformation;
        }
        $v_0 = parentNode.PermissionsOnlyMode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PermissionsOnlyMode'] = $v_0;
            delete parentNode.PermissionsOnlyMode;
        }
        $v_0 = parentNode.RequiredAnonymousLinkExpirationInDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RequiredAnonymousLinkExpirationInDays'] = $v_0;
            delete parentNode.RequiredAnonymousLinkExpirationInDays;
        }
        $v_0 = parentNode.Roles;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Roles'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Roles;
        }
        $v_0 = parentNode.ShareByEmailEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShareByEmailEnabled'] = $v_0;
            delete parentNode.ShareByEmailEnabled;
        }
        $v_0 = parentNode.SharePointSettings;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('SharePointSettings', this.get_sharePointSettings(), $v_0);
            (this.get_sharePointSettings()).fromJson($v_0);
            delete parentNode.SharePointSettings;
        }
        $v_0 = parentNode.SharingPermissions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('SharingPermissions', this.get_sharingPermissions(), $v_0);
            (this.get_sharingPermissions()).fromJson($v_0);
            delete parentNode.SharingPermissions;
        }
        $v_0 = parentNode.ShowExternalSharingWarning;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShowExternalSharingWarning'] = $v_0;
            delete parentNode.ShowExternalSharingWarning;
        }
        $v_0 = parentNode.SimplifiedRoles;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SimplifiedRoles'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SimplifiedRoles;
        }
        $v_0 = parentNode.SupportsAclPropagation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SupportsAclPropagation'] = $v_0;
            delete parentNode.SupportsAclPropagation;
        }
        $v_0 = parentNode.WebUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebUrl'] = $v_0;
            delete parentNode.WebUrl;
        }
    }
};
SP.ObjectSharingSettingsPropertyNames = function SP_ObjectSharingSettingsPropertyNames() {
};
SP.ObjectSharingSettingsObjectPropertyNames = function SP_ObjectSharingSettingsObjectPropertyNames() {
};
SP.PickerSettings = function SP_PickerSettings(context, objectPath) {
    SP.PickerSettings.initializeBase(this, [context, objectPath]);
};
SP.PickerSettings.prototype = {
    get_allowEmailAddresses: function SP_PickerSettings$get_allowEmailAddresses() {
        this.checkUninitializedProperty('AllowEmailAddresses');
        return ((this.get_objectData()).get_properties())['AllowEmailAddresses'];
    },
    get_allowOnlyEmailAddresses: function SP_PickerSettings$get_allowOnlyEmailAddresses() {
        this.checkUninitializedProperty('AllowOnlyEmailAddresses');
        return ((this.get_objectData()).get_properties())['AllowOnlyEmailAddresses'];
    },
    get_principalAccountType: function SP_PickerSettings$get_principalAccountType() {
        this.checkUninitializedProperty('PrincipalAccountType');
        return ((this.get_objectData()).get_properties())['PrincipalAccountType'];
    },
    get_principalSource: function SP_PickerSettings$get_principalSource() {
        this.checkUninitializedProperty('PrincipalSource');
        return ((this.get_objectData()).get_properties())['PrincipalSource'];
    },
    get_visibleSuggestions: function SP_PickerSettings$get_visibleSuggestions() {
        this.checkUninitializedProperty('VisibleSuggestions');
        return ((this.get_objectData()).get_properties())['VisibleSuggestions'];
    },
    initPropertiesFromJson: function SP_PickerSettings$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowEmailAddresses;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowEmailAddresses'] = $v_0;
            delete parentNode.AllowEmailAddresses;
        }
        $v_0 = parentNode.AllowOnlyEmailAddresses;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowOnlyEmailAddresses'] = $v_0;
            delete parentNode.AllowOnlyEmailAddresses;
        }
        $v_0 = parentNode.PrincipalAccountType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PrincipalAccountType'] = $v_0;
            delete parentNode.PrincipalAccountType;
        }
        $v_0 = parentNode.PrincipalSource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PrincipalSource'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.PrincipalSource;
        }
        $v_0 = parentNode.VisibleSuggestions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['VisibleSuggestions'] = $v_0;
            delete parentNode.VisibleSuggestions;
        }
    }
};
SP.PickerSettingsPropertyNames = function SP_PickerSettingsPropertyNames() {
};
SP.Principal = function SP_Principal(context, objectPath) {
    SP.Principal.initializeBase(this, [context, objectPath]);
};
SP.Principal.prototype = {
    get_id: function SP_Principal$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_isHiddenInUI: function SP_Principal$get_isHiddenInUI() {
        this.checkUninitializedProperty('IsHiddenInUI');
        return ((this.get_objectData()).get_properties())['IsHiddenInUI'];
    },
    get_loginName: function SP_Principal$get_loginName() {
        this.checkUninitializedProperty('LoginName');
        return ((this.get_objectData()).get_properties())['LoginName'];
    },
    get_title: function SP_Principal$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    set_title: function SP_Principal$set_title(value) {
        ((this.get_objectData()).get_properties())['Title'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Title', value));
        }
        return value;
    },
    get_principalType: function SP_Principal$get_principalType() {
        this.checkUninitializedProperty('PrincipalType');
        return ((this.get_objectData()).get_properties())['PrincipalType'];
    },
    initPropertiesFromJson: function SP_Principal$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.IsHiddenInUI;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsHiddenInUI'] = $v_0;
            delete parentNode.IsHiddenInUI;
        }
        $v_0 = parentNode.LoginName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LoginName'] = $v_0;
            delete parentNode.LoginName;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.PrincipalType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PrincipalType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.PrincipalType;
        }
    }
};
SP.PrincipalPropertyNames = function SP_PrincipalPropertyNames() {
};
SP.PropertyValues = function SP_PropertyValues(context, objectPath) {
    SP.PropertyValues.initializeBase(this, [context, objectPath]);
};
SP.PropertyValues.prototype = {
    get_fieldValues: function SP_PropertyValues$get_fieldValues() {
        var $v_0 = ((this.get_objectData()).get_methodReturnObjects())['$m_dict'];

        if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
            $v_0 = {};
            ((this.get_objectData()).get_methodReturnObjects())['$m_dict'] = $v_0;
        }
        return $v_0;
    },
    get_item: function SP_PropertyValues$get_item(fieldName) {
        return this.$12_1(fieldName);
    },
    set_item: function SP_PropertyValues$set_item(fieldName, value) {
        this.$5e_1(fieldName, value);
        return value;
    },
    initNonPropertiesFromJson: function SP_PropertyValues$initNonPropertiesFromJson(parentNode) {
        SP.DataConvert.populateDictionaryFromObject(this.get_fieldValues(), parentNode);
        SP.DataConvert.fixupTypes(this.get_context(), this.get_fieldValues());
    },
    $12_1: function SP_PropertyValues$$12_1($p0) {
        var $v_0 = (this.get_fieldValues())[$p0];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            throw Error.create(SP.ResResources.getString('PropertyHasNotBeenInitialized'));
        }
        return $v_0;
    },
    refreshLoad: function SP_PropertyValues$refreshLoad() {
        SP.ClientObject.prototype.refreshLoad.call(this);
        this.loadExpandoFields();
    },
    loadExpandoFields: function SP_PropertyValues$loadExpandoFields() {
        var $$dict_0 = this.get_fieldValues();

        for (var $$key_1 in $$dict_0) {
            var $v_0 = {
                key: $$key_1,
                value: $$dict_0[$$key_1]
            };

            this.retrieve($v_0.key);
        }
    },
    $5e_1: function SP_PropertyValues$$5e_1($p0, $p1) {
        var $v_0 = this.get_context();

        (this.get_fieldValues())[$p0] = $p1;
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'SetFieldValue', [$p0, $p1]);

        if ($v_0) {
            $v_0.addQuery($v_1);
        }
    }
};
SP.PushNotificationSubscriber = function SP_PushNotificationSubscriber(context, objectPath) {
    SP.PushNotificationSubscriber.initializeBase(this, [context, objectPath]);
};
SP.PushNotificationSubscriber.prototype = {
    get_customArgs: function SP_PushNotificationSubscriber$get_customArgs() {
        this.checkUninitializedProperty('CustomArgs');
        return ((this.get_objectData()).get_properties())['CustomArgs'];
    },
    set_customArgs: function SP_PushNotificationSubscriber$set_customArgs(value) {
        ((this.get_objectData()).get_properties())['CustomArgs'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'CustomArgs', value));
        }
        return value;
    },
    get_deviceAppInstanceId: function SP_PushNotificationSubscriber$get_deviceAppInstanceId() {
        this.checkUninitializedProperty('DeviceAppInstanceId');
        return ((this.get_objectData()).get_properties())['DeviceAppInstanceId'];
    },
    get_lastModifiedTimeStamp: function SP_PushNotificationSubscriber$get_lastModifiedTimeStamp() {
        this.checkUninitializedProperty('LastModifiedTimeStamp');
        return ((this.get_objectData()).get_properties())['LastModifiedTimeStamp'];
    },
    get_registrationTimeStamp: function SP_PushNotificationSubscriber$get_registrationTimeStamp() {
        this.checkUninitializedProperty('RegistrationTimeStamp');
        return ((this.get_objectData()).get_properties())['RegistrationTimeStamp'];
    },
    get_serviceToken: function SP_PushNotificationSubscriber$get_serviceToken() {
        this.checkUninitializedProperty('ServiceToken');
        return ((this.get_objectData()).get_properties())['ServiceToken'];
    },
    set_serviceToken: function SP_PushNotificationSubscriber$set_serviceToken(value) {
        ((this.get_objectData()).get_properties())['ServiceToken'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ServiceToken', value));
        }
        return value;
    },
    get_subscriberType: function SP_PushNotificationSubscriber$get_subscriberType() {
        this.checkUninitializedProperty('SubscriberType');
        return ((this.get_objectData()).get_properties())['SubscriberType'];
    },
    set_subscriberType: function SP_PushNotificationSubscriber$set_subscriberType(value) {
        ((this.get_objectData()).get_properties())['SubscriberType'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SubscriberType', value));
        }
        return value;
    },
    get_user: function SP_PushNotificationSubscriber$get_user() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['User'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'User'));
            ((this.get_objectData()).get_clientObjectProperties())['User'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_PushNotificationSubscriber$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CustomArgs;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CustomArgs'] = $v_0;
            delete parentNode.CustomArgs;
        }
        $v_0 = parentNode.DeviceAppInstanceId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DeviceAppInstanceId'] = $v_0;
            delete parentNode.DeviceAppInstanceId;
        }
        $v_0 = parentNode.LastModifiedTimeStamp;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LastModifiedTimeStamp'] = $v_0;
            delete parentNode.LastModifiedTimeStamp;
        }
        $v_0 = parentNode.RegistrationTimeStamp;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RegistrationTimeStamp'] = $v_0;
            delete parentNode.RegistrationTimeStamp;
        }
        $v_0 = parentNode.ServiceToken;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServiceToken'] = $v_0;
            delete parentNode.ServiceToken;
        }
        $v_0 = parentNode.SubscriberType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SubscriberType'] = $v_0;
            delete parentNode.SubscriberType;
        }
        $v_0 = parentNode.User;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('User', this.get_user(), $v_0);
            (this.get_user()).fromJson($v_0);
            delete parentNode.User;
        }
    },
    update: function SP_PushNotificationSubscriber$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    }
};
SP.PushNotificationSubscriberPropertyNames = function SP_PushNotificationSubscriberPropertyNames() {
};
SP.PushNotificationSubscriberObjectPropertyNames = function SP_PushNotificationSubscriberObjectPropertyNames() {
};
SP.PushNotificationSubscriberCollection = function SP_PushNotificationSubscriberCollection(context, objectPath) {
    SP.PushNotificationSubscriberCollection.initializeBase(this, [context, objectPath]);
};
SP.PushNotificationSubscriberCollection.prototype = {
    itemAt: function SP_PushNotificationSubscriberCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_PushNotificationSubscriberCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_PushNotificationSubscriberCollection$get_childItemType() {
        return SP.PushNotificationSubscriber;
    },
    getByStoreId: function SP_PushNotificationSubscriberCollection$getByStoreId(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByStoreId'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByStoreId'] = $v_2;
        }
        $v_1 = $v_2[id];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.PushNotificationSubscriber($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByStoreId', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id] = $v_1;
        }
        return $v_1;
    }
};
SP.RecycleBinItem = function SP_RecycleBinItem(context, objectPath) {
    SP.RecycleBinItem.initializeBase(this, [context, objectPath]);
};
SP.RecycleBinItem.prototype = {
    get_author: function SP_RecycleBinItem$get_author() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Author'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Author'));
            ((this.get_objectData()).get_clientObjectProperties())['Author'] = $v_0;
        }
        return $v_0;
    },
    get_authorEmail: function SP_RecycleBinItem$get_authorEmail() {
        this.checkUninitializedProperty('AuthorEmail');
        return ((this.get_objectData()).get_properties())['AuthorEmail'];
    },
    get_authorName: function SP_RecycleBinItem$get_authorName() {
        this.checkUninitializedProperty('AuthorName');
        return ((this.get_objectData()).get_properties())['AuthorName'];
    },
    get_deletedBy: function SP_RecycleBinItem$get_deletedBy() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['DeletedBy'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'DeletedBy'));
            ((this.get_objectData()).get_clientObjectProperties())['DeletedBy'] = $v_0;
        }
        return $v_0;
    },
    get_deletedByEmail: function SP_RecycleBinItem$get_deletedByEmail() {
        this.checkUninitializedProperty('DeletedByEmail');
        return ((this.get_objectData()).get_properties())['DeletedByEmail'];
    },
    get_deletedByName: function SP_RecycleBinItem$get_deletedByName() {
        this.checkUninitializedProperty('DeletedByName');
        return ((this.get_objectData()).get_properties())['DeletedByName'];
    },
    get_deletedDate: function SP_RecycleBinItem$get_deletedDate() {
        this.checkUninitializedProperty('DeletedDate');
        return ((this.get_objectData()).get_properties())['DeletedDate'];
    },
    get_dirName: function SP_RecycleBinItem$get_dirName() {
        this.checkUninitializedProperty('DirName');
        return ((this.get_objectData()).get_properties())['DirName'];
    },
    get_id: function SP_RecycleBinItem$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_itemState: function SP_RecycleBinItem$get_itemState() {
        this.checkUninitializedProperty('ItemState');
        return ((this.get_objectData()).get_properties())['ItemState'];
    },
    get_itemType: function SP_RecycleBinItem$get_itemType() {
        this.checkUninitializedProperty('ItemType');
        return ((this.get_objectData()).get_properties())['ItemType'];
    },
    get_leafName: function SP_RecycleBinItem$get_leafName() {
        this.checkUninitializedProperty('LeafName');
        return ((this.get_objectData()).get_properties())['LeafName'];
    },
    get_size: function SP_RecycleBinItem$get_size() {
        this.checkUninitializedProperty('Size');
        return ((this.get_objectData()).get_properties())['Size'];
    },
    get_title: function SP_RecycleBinItem$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    initPropertiesFromJson: function SP_RecycleBinItem$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Author;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Author', this.get_author(), $v_0);
            (this.get_author()).fromJson($v_0);
            delete parentNode.Author;
        }
        $v_0 = parentNode.AuthorEmail;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AuthorEmail'] = $v_0;
            delete parentNode.AuthorEmail;
        }
        $v_0 = parentNode.AuthorName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AuthorName'] = $v_0;
            delete parentNode.AuthorName;
        }
        $v_0 = parentNode.DeletedBy;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('DeletedBy', this.get_deletedBy(), $v_0);
            (this.get_deletedBy()).fromJson($v_0);
            delete parentNode.DeletedBy;
        }
        $v_0 = parentNode.DeletedByEmail;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DeletedByEmail'] = $v_0;
            delete parentNode.DeletedByEmail;
        }
        $v_0 = parentNode.DeletedByName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DeletedByName'] = $v_0;
            delete parentNode.DeletedByName;
        }
        $v_0 = parentNode.DeletedDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DeletedDate'] = $v_0;
            delete parentNode.DeletedDate;
        }
        $v_0 = parentNode.DirName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DirName'] = $v_0;
            delete parentNode.DirName;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.ItemState;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemState'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ItemState;
        }
        $v_0 = parentNode.ItemType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ItemType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ItemType;
        }
        $v_0 = parentNode.LeafName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LeafName'] = $v_0;
            delete parentNode.LeafName;
        }
        $v_0 = parentNode.Size;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Size'] = $v_0;
            delete parentNode.Size;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
    },
    deleteObject: function SP_RecycleBinItem$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    },
    restore: function SP_RecycleBinItem$restore() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Restore', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.RecycleBinItemPropertyNames = function SP_RecycleBinItemPropertyNames() {
};
SP.RecycleBinItemObjectPropertyNames = function SP_RecycleBinItemObjectPropertyNames() {
};
SP.RecycleBinItemCollection = function SP_RecycleBinItemCollection(context, objectPath) {
    SP.RecycleBinItemCollection.initializeBase(this, [context, objectPath]);
};
SP.RecycleBinItemCollection.prototype = {
    itemAt: function SP_RecycleBinItemCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_RecycleBinItemCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_RecycleBinItemCollection$get_childItemType() {
        return SP.RecycleBinItem;
    },
    $7E_2: function SP_RecycleBinItemCollection$$7E_2() {
        var $v_0 = this.get_data();

        while ($v_0.length > 0) {
            Array.removeAt($v_0, $v_0.length - 1);
        }
    },
    getById: function SP_RecycleBinItemCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.RecycleBinItem($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id.toString()] = $v_1;
        }
        return $v_1;
    },
    deleteAll: function SP_RecycleBinItemCollection$deleteAll() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteAll', null);

        $v_0.addQuery($v_1);
        this.$7E_2();
    },
    restoreAll: function SP_RecycleBinItemCollection$restoreAll() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RestoreAll', null);

        $v_0.addQuery($v_1);
        this.$7E_2();
    }
};
SP.RegionalSettings = function SP_RegionalSettings(context, objectPath) {
    SP.RegionalSettings.initializeBase(this, [context, objectPath]);
};
SP.RegionalSettings.prototype = {
    get_adjustHijriDays: function SP_RegionalSettings$get_adjustHijriDays() {
        this.checkUninitializedProperty('AdjustHijriDays');
        return ((this.get_objectData()).get_properties())['AdjustHijriDays'];
    },
    set_adjustHijriDays: function SP_RegionalSettings$set_adjustHijriDays(value) {
        ((this.get_objectData()).get_properties())['AdjustHijriDays'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AdjustHijriDays', value));
        }
        return value;
    },
    get_alternateCalendarType: function SP_RegionalSettings$get_alternateCalendarType() {
        this.checkUninitializedProperty('AlternateCalendarType');
        return ((this.get_objectData()).get_properties())['AlternateCalendarType'];
    },
    set_alternateCalendarType: function SP_RegionalSettings$set_alternateCalendarType(value) {
        ((this.get_objectData()).get_properties())['AlternateCalendarType'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AlternateCalendarType', value));
        }
        return value;
    },
    get_AM: function SP_RegionalSettings$get_AM() {
        this.checkUninitializedProperty('AM');
        return ((this.get_objectData()).get_properties())['AM'];
    },
    get_calendarType: function SP_RegionalSettings$get_calendarType() {
        this.checkUninitializedProperty('CalendarType');
        return ((this.get_objectData()).get_properties())['CalendarType'];
    },
    set_calendarType: function SP_RegionalSettings$set_calendarType(value) {
        ((this.get_objectData()).get_properties())['CalendarType'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'CalendarType', value));
        }
        return value;
    },
    get_collation: function SP_RegionalSettings$get_collation() {
        this.checkUninitializedProperty('Collation');
        return ((this.get_objectData()).get_properties())['Collation'];
    },
    set_collation: function SP_RegionalSettings$set_collation(value) {
        ((this.get_objectData()).get_properties())['Collation'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Collation', value));
        }
        return value;
    },
    get_collationLCID: function SP_RegionalSettings$get_collationLCID() {
        this.checkUninitializedProperty('CollationLCID');
        return ((this.get_objectData()).get_properties())['CollationLCID'];
    },
    get_dateFormat: function SP_RegionalSettings$get_dateFormat() {
        this.checkUninitializedProperty('DateFormat');
        return ((this.get_objectData()).get_properties())['DateFormat'];
    },
    get_dateSeparator: function SP_RegionalSettings$get_dateSeparator() {
        this.checkUninitializedProperty('DateSeparator');
        return ((this.get_objectData()).get_properties())['DateSeparator'];
    },
    get_decimalSeparator: function SP_RegionalSettings$get_decimalSeparator() {
        this.checkUninitializedProperty('DecimalSeparator');
        return ((this.get_objectData()).get_properties())['DecimalSeparator'];
    },
    get_digitGrouping: function SP_RegionalSettings$get_digitGrouping() {
        this.checkUninitializedProperty('DigitGrouping');
        return ((this.get_objectData()).get_properties())['DigitGrouping'];
    },
    get_firstDayOfWeek: function SP_RegionalSettings$get_firstDayOfWeek() {
        this.checkUninitializedProperty('FirstDayOfWeek');
        return ((this.get_objectData()).get_properties())['FirstDayOfWeek'];
    },
    set_firstDayOfWeek: function SP_RegionalSettings$set_firstDayOfWeek(value) {
        ((this.get_objectData()).get_properties())['FirstDayOfWeek'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'FirstDayOfWeek', value));
        }
        return value;
    },
    get_firstWeekOfYear: function SP_RegionalSettings$get_firstWeekOfYear() {
        this.checkUninitializedProperty('FirstWeekOfYear');
        return ((this.get_objectData()).get_properties())['FirstWeekOfYear'];
    },
    set_firstWeekOfYear: function SP_RegionalSettings$set_firstWeekOfYear(value) {
        ((this.get_objectData()).get_properties())['FirstWeekOfYear'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'FirstWeekOfYear', value));
        }
        return value;
    },
    get_isEastAsia: function SP_RegionalSettings$get_isEastAsia() {
        this.checkUninitializedProperty('IsEastAsia');
        return ((this.get_objectData()).get_properties())['IsEastAsia'];
    },
    get_isRightToLeft: function SP_RegionalSettings$get_isRightToLeft() {
        this.checkUninitializedProperty('IsRightToLeft');
        return ((this.get_objectData()).get_properties())['IsRightToLeft'];
    },
    get_isUIRightToLeft: function SP_RegionalSettings$get_isUIRightToLeft() {
        this.checkUninitializedProperty('IsUIRightToLeft');
        return ((this.get_objectData()).get_properties())['IsUIRightToLeft'];
    },
    get_listSeparator: function SP_RegionalSettings$get_listSeparator() {
        this.checkUninitializedProperty('ListSeparator');
        return ((this.get_objectData()).get_properties())['ListSeparator'];
    },
    get_localeId: function SP_RegionalSettings$get_localeId() {
        this.checkUninitializedProperty('LocaleId');
        return ((this.get_objectData()).get_properties())['LocaleId'];
    },
    set_localeId: function SP_RegionalSettings$set_localeId(value) {
        ((this.get_objectData()).get_properties())['LocaleId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'LocaleId', value));
        }
        return value;
    },
    get_negativeSign: function SP_RegionalSettings$get_negativeSign() {
        this.checkUninitializedProperty('NegativeSign');
        return ((this.get_objectData()).get_properties())['NegativeSign'];
    },
    get_negNumberMode: function SP_RegionalSettings$get_negNumberMode() {
        this.checkUninitializedProperty('NegNumberMode');
        return ((this.get_objectData()).get_properties())['NegNumberMode'];
    },
    get_PM: function SP_RegionalSettings$get_PM() {
        this.checkUninitializedProperty('PM');
        return ((this.get_objectData()).get_properties())['PM'];
    },
    get_positiveSign: function SP_RegionalSettings$get_positiveSign() {
        this.checkUninitializedProperty('PositiveSign');
        return ((this.get_objectData()).get_properties())['PositiveSign'];
    },
    get_showWeeks: function SP_RegionalSettings$get_showWeeks() {
        this.checkUninitializedProperty('ShowWeeks');
        return ((this.get_objectData()).get_properties())['ShowWeeks'];
    },
    set_showWeeks: function SP_RegionalSettings$set_showWeeks(value) {
        ((this.get_objectData()).get_properties())['ShowWeeks'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ShowWeeks', value));
        }
        return value;
    },
    get_thousandSeparator: function SP_RegionalSettings$get_thousandSeparator() {
        this.checkUninitializedProperty('ThousandSeparator');
        return ((this.get_objectData()).get_properties())['ThousandSeparator'];
    },
    get_time24: function SP_RegionalSettings$get_time24() {
        this.checkUninitializedProperty('Time24');
        return ((this.get_objectData()).get_properties())['Time24'];
    },
    set_time24: function SP_RegionalSettings$set_time24(value) {
        ((this.get_objectData()).get_properties())['Time24'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Time24', value));
        }
        return value;
    },
    get_timeMarkerPosition: function SP_RegionalSettings$get_timeMarkerPosition() {
        this.checkUninitializedProperty('TimeMarkerPosition');
        return ((this.get_objectData()).get_properties())['TimeMarkerPosition'];
    },
    get_timeSeparator: function SP_RegionalSettings$get_timeSeparator() {
        this.checkUninitializedProperty('TimeSeparator');
        return ((this.get_objectData()).get_properties())['TimeSeparator'];
    },
    get_timeZone: function SP_RegionalSettings$get_timeZone() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['TimeZone'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.TimeZone(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'TimeZone'));
            ((this.get_objectData()).get_clientObjectProperties())['TimeZone'] = $v_0;
        }
        return $v_0;
    },
    set_timeZone: function SP_RegionalSettings$set_timeZone(value) {
        ((this.get_objectData()).get_clientObjectProperties())['TimeZone'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'TimeZone', value));
        }
        return value;
    },
    get_timeZones: function SP_RegionalSettings$get_timeZones() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['TimeZones'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.TimeZoneCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'TimeZones'));
            ((this.get_objectData()).get_clientObjectProperties())['TimeZones'] = $v_0;
        }
        return $v_0;
    },
    get_workDayEndHour: function SP_RegionalSettings$get_workDayEndHour() {
        this.checkUninitializedProperty('WorkDayEndHour');
        return ((this.get_objectData()).get_properties())['WorkDayEndHour'];
    },
    set_workDayEndHour: function SP_RegionalSettings$set_workDayEndHour(value) {
        ((this.get_objectData()).get_properties())['WorkDayEndHour'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'WorkDayEndHour', value));
        }
        return value;
    },
    get_workDays: function SP_RegionalSettings$get_workDays() {
        this.checkUninitializedProperty('WorkDays');
        return ((this.get_objectData()).get_properties())['WorkDays'];
    },
    set_workDays: function SP_RegionalSettings$set_workDays(value) {
        ((this.get_objectData()).get_properties())['WorkDays'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'WorkDays', value));
        }
        return value;
    },
    get_workDayStartHour: function SP_RegionalSettings$get_workDayStartHour() {
        this.checkUninitializedProperty('WorkDayStartHour');
        return ((this.get_objectData()).get_properties())['WorkDayStartHour'];
    },
    set_workDayStartHour: function SP_RegionalSettings$set_workDayStartHour(value) {
        ((this.get_objectData()).get_properties())['WorkDayStartHour'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'WorkDayStartHour', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_RegionalSettings$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AdjustHijriDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AdjustHijriDays'] = $v_0;
            delete parentNode.AdjustHijriDays;
        }
        $v_0 = parentNode.AlternateCalendarType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AlternateCalendarType'] = $v_0;
            delete parentNode.AlternateCalendarType;
        }
        $v_0 = parentNode.AM;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AM'] = $v_0;
            delete parentNode.AM;
        }
        $v_0 = parentNode.CalendarType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CalendarType'] = $v_0;
            delete parentNode.CalendarType;
        }
        $v_0 = parentNode.Collation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Collation'] = $v_0;
            delete parentNode.Collation;
        }
        $v_0 = parentNode.CollationLCID;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CollationLCID'] = $v_0;
            delete parentNode.CollationLCID;
        }
        $v_0 = parentNode.DateFormat;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DateFormat'] = $v_0;
            delete parentNode.DateFormat;
        }
        $v_0 = parentNode.DateSeparator;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DateSeparator'] = $v_0;
            delete parentNode.DateSeparator;
        }
        $v_0 = parentNode.DecimalSeparator;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DecimalSeparator'] = $v_0;
            delete parentNode.DecimalSeparator;
        }
        $v_0 = parentNode.DigitGrouping;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DigitGrouping'] = $v_0;
            delete parentNode.DigitGrouping;
        }
        $v_0 = parentNode.FirstDayOfWeek;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FirstDayOfWeek'] = $v_0;
            delete parentNode.FirstDayOfWeek;
        }
        $v_0 = parentNode.FirstWeekOfYear;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FirstWeekOfYear'] = $v_0;
            delete parentNode.FirstWeekOfYear;
        }
        $v_0 = parentNode.IsEastAsia;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsEastAsia'] = $v_0;
            delete parentNode.IsEastAsia;
        }
        $v_0 = parentNode.IsRightToLeft;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsRightToLeft'] = $v_0;
            delete parentNode.IsRightToLeft;
        }
        $v_0 = parentNode.IsUIRightToLeft;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsUIRightToLeft'] = $v_0;
            delete parentNode.IsUIRightToLeft;
        }
        $v_0 = parentNode.ListSeparator;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListSeparator'] = $v_0;
            delete parentNode.ListSeparator;
        }
        $v_0 = parentNode.LocaleId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LocaleId'] = $v_0;
            delete parentNode.LocaleId;
        }
        $v_0 = parentNode.NegativeSign;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['NegativeSign'] = $v_0;
            delete parentNode.NegativeSign;
        }
        $v_0 = parentNode.NegNumberMode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['NegNumberMode'] = $v_0;
            delete parentNode.NegNumberMode;
        }
        $v_0 = parentNode.PM;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PM'] = $v_0;
            delete parentNode.PM;
        }
        $v_0 = parentNode.PositiveSign;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PositiveSign'] = $v_0;
            delete parentNode.PositiveSign;
        }
        $v_0 = parentNode.ShowWeeks;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShowWeeks'] = $v_0;
            delete parentNode.ShowWeeks;
        }
        $v_0 = parentNode.ThousandSeparator;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ThousandSeparator'] = $v_0;
            delete parentNode.ThousandSeparator;
        }
        $v_0 = parentNode.Time24;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Time24'] = $v_0;
            delete parentNode.Time24;
        }
        $v_0 = parentNode.TimeMarkerPosition;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TimeMarkerPosition'] = $v_0;
            delete parentNode.TimeMarkerPosition;
        }
        $v_0 = parentNode.TimeSeparator;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TimeSeparator'] = $v_0;
            delete parentNode.TimeSeparator;
        }
        $v_0 = parentNode.TimeZone;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('TimeZone', this.get_timeZone(), $v_0);
            (this.get_timeZone()).fromJson($v_0);
            delete parentNode.TimeZone;
        }
        $v_0 = parentNode.TimeZones;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('TimeZones', this.get_timeZones(), $v_0);
            (this.get_timeZones()).fromJson($v_0);
            delete parentNode.TimeZones;
        }
        $v_0 = parentNode.WorkDayEndHour;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WorkDayEndHour'] = $v_0;
            delete parentNode.WorkDayEndHour;
        }
        $v_0 = parentNode.WorkDays;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WorkDays'] = $v_0;
            delete parentNode.WorkDays;
        }
        $v_0 = parentNode.WorkDayStartHour;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WorkDayStartHour'] = $v_0;
            delete parentNode.WorkDayStartHour;
        }
    },
    update: function SP_RegionalSettings$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    }
};
SP.RegionalSettingsPropertyNames = function SP_RegionalSettingsPropertyNames() {
};
SP.RegionalSettingsObjectPropertyNames = function SP_RegionalSettingsObjectPropertyNames() {
};
SP.RelatedField = function SP_RelatedField(context, objectPath) {
    SP.RelatedField.initializeBase(this, [context, objectPath]);
};
SP.RelatedField.prototype = {
    get_fieldId: function SP_RelatedField$get_fieldId() {
        this.checkUninitializedProperty('FieldId');
        return ((this.get_objectData()).get_properties())['FieldId'];
    },
    get_listId: function SP_RelatedField$get_listId() {
        this.checkUninitializedProperty('ListId');
        return ((this.get_objectData()).get_properties())['ListId'];
    },
    get_lookupList: function SP_RelatedField$get_lookupList() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['LookupList'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.List(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'LookupList'));
            ((this.get_objectData()).get_clientObjectProperties())['LookupList'] = $v_0;
        }
        return $v_0;
    },
    get_relationshipDeleteBehavior: function SP_RelatedField$get_relationshipDeleteBehavior() {
        this.checkUninitializedProperty('RelationshipDeleteBehavior');
        return ((this.get_objectData()).get_properties())['RelationshipDeleteBehavior'];
    },
    get_webId: function SP_RelatedField$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_RelatedField$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FieldId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FieldId'] = $v_0;
            delete parentNode.FieldId;
        }
        $v_0 = parentNode.ListId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListId'] = $v_0;
            delete parentNode.ListId;
        }
        $v_0 = parentNode.LookupList;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('LookupList', this.get_lookupList(), $v_0);
            (this.get_lookupList()).fromJson($v_0);
            delete parentNode.LookupList;
        }
        $v_0 = parentNode.RelationshipDeleteBehavior;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RelationshipDeleteBehavior'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.RelationshipDeleteBehavior;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.RelatedFieldPropertyNames = function SP_RelatedFieldPropertyNames() {
};
SP.RelatedFieldObjectPropertyNames = function SP_RelatedFieldObjectPropertyNames() {
};
SP.RelatedFieldCollection = function SP_RelatedFieldCollection(context, objectPath) {
    SP.RelatedFieldCollection.initializeBase(this, [context, objectPath]);
};
SP.RelatedFieldCollection.prototype = {
    itemAt: function SP_RelatedFieldCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_RelatedFieldCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_RelatedFieldCollection$get_childItemType() {
        return SP.RelatedField;
    }
};
SP.RelatedFieldExtendedData = function SP_RelatedFieldExtendedData(context, objectPath) {
    SP.RelatedFieldExtendedData.initializeBase(this, [context, objectPath]);
};
SP.RelatedFieldExtendedData.prototype = {
    get_fieldId: function SP_RelatedFieldExtendedData$get_fieldId() {
        this.checkUninitializedProperty('FieldId');
        return ((this.get_objectData()).get_properties())['FieldId'];
    },
    get_listId: function SP_RelatedFieldExtendedData$get_listId() {
        this.checkUninitializedProperty('ListId');
        return ((this.get_objectData()).get_properties())['ListId'];
    },
    get_listImageUrl: function SP_RelatedFieldExtendedData$get_listImageUrl() {
        this.checkUninitializedProperty('ListImageUrl');
        return ((this.get_objectData()).get_properties())['ListImageUrl'];
    },
    get_resolvedListTitle: function SP_RelatedFieldExtendedData$get_resolvedListTitle() {
        this.checkUninitializedProperty('ResolvedListTitle');
        return ((this.get_objectData()).get_properties())['ResolvedListTitle'];
    },
    get_toolTipDescription: function SP_RelatedFieldExtendedData$get_toolTipDescription() {
        this.checkUninitializedProperty('ToolTipDescription');
        return ((this.get_objectData()).get_properties())['ToolTipDescription'];
    },
    get_webId: function SP_RelatedFieldExtendedData$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_RelatedFieldExtendedData$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FieldId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['FieldId'] = $v_0;
            delete parentNode.FieldId;
        }
        $v_0 = parentNode.ListId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListId'] = $v_0;
            delete parentNode.ListId;
        }
        $v_0 = parentNode.ListImageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListImageUrl'] = $v_0;
            delete parentNode.ListImageUrl;
        }
        $v_0 = parentNode.ResolvedListTitle;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ResolvedListTitle'] = $v_0;
            delete parentNode.ResolvedListTitle;
        }
        $v_0 = parentNode.ToolTipDescription;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ToolTipDescription'] = $v_0;
            delete parentNode.ToolTipDescription;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.RelatedFieldExtendedDataPropertyNames = function SP_RelatedFieldExtendedDataPropertyNames() {
};
SP.RelatedFieldExtendedDataCollection = function SP_RelatedFieldExtendedDataCollection(context, objectPath) {
    SP.RelatedFieldExtendedDataCollection.initializeBase(this, [context, objectPath]);
};
SP.RelatedFieldExtendedDataCollection.prototype = {
    itemAt: function SP_RelatedFieldExtendedDataCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_RelatedFieldExtendedDataCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_RelatedFieldExtendedDataCollection$get_childItemType() {
        return SP.RelatedFieldExtendedData;
    }
};
SP.RelatedItem = function SP_RelatedItem() {
    SP.RelatedItem.initializeBase(this);
};
SP.RelatedItem.prototype = {
    $46_1: null,
    $i_1: 0,
    $7_1: null,
    $0_1: null,
    $1_1: null,
    $5T_1: null,
    get_iconUrl: function SP_RelatedItem$get_iconUrl() {
        return this.$46_1;
    },
    set_iconUrl: function SP_RelatedItem$set_iconUrl(value) {
        this.$46_1 = value;
        return value;
    },
    get_itemId: function SP_RelatedItem$get_itemId() {
        return this.$i_1;
    },
    set_itemId: function SP_RelatedItem$set_itemId(value) {
        this.$i_1 = value;
        return value;
    },
    get_listId: function SP_RelatedItem$get_listId() {
        return this.$7_1;
    },
    set_listId: function SP_RelatedItem$set_listId(value) {
        this.$7_1 = value;
        return value;
    },
    get_title: function SP_RelatedItem$get_title() {
        return this.$0_1;
    },
    set_title: function SP_RelatedItem$set_title(value) {
        this.$0_1 = value;
        return value;
    },
    get_url: function SP_RelatedItem$get_url() {
        return this.$1_1;
    },
    set_url: function SP_RelatedItem$set_url(value) {
        this.$1_1 = value;
        return value;
    },
    get_webId: function SP_RelatedItem$get_webId() {
        return this.$5T_1;
    },
    set_webId: function SP_RelatedItem$set_webId(value) {
        this.$5T_1 = value;
        return value;
    },
    get_typeId: function SP_RelatedItem$get_typeId() {
        return '{627c69f5-12e8-46bc-9052-bd5e46e155d3}';
    },
    writeToXml: function SP_RelatedItem$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['IconUrl', 'ItemId', 'ListId', 'Title', 'Url', 'WebId'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_RelatedItem$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.IconUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$46_1 = $v_0;
            delete parentNode.IconUrl;
        }
        $v_0 = parentNode.ItemId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$i_1 = $v_0;
            delete parentNode.ItemId;
        }
        $v_0 = parentNode.ListId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$7_1 = $v_0;
            delete parentNode.ListId;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1_1 = $v_0;
            delete parentNode.Url;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5T_1 = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.RelatedItemManager = function SP_RelatedItemManager(context, objectPath) {
    SP.RelatedItemManager.initializeBase(this, [context, objectPath]);
};
SP.RelatedItemManager.getRelatedItems = function SP_RelatedItemManager$getRelatedItems(context, SourceListName, SourceItemID) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{23af17db-2585-4d17-82a7-aa9e3fba099d}', 'GetRelatedItems', [SourceListName, SourceItemID]);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.RelatedItemManager.getPageOneRelatedItems = function SP_RelatedItemManager$getPageOneRelatedItems(context, SourceListName, SourceItemID) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{23af17db-2585-4d17-82a7-aa9e3fba099d}', 'GetPageOneRelatedItems', [SourceListName, SourceItemID]);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.RelatedItemManager.addSingleLink = function SP_RelatedItemManager$addSingleLink(context, SourceListName, SourceItemID, SourceWebUrl, TargetListName, TargetItemID, TargetWebUrl, TryAddReverseLink) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{23af17db-2585-4d17-82a7-aa9e3fba099d}', 'AddSingleLink', [SourceListName, SourceItemID, SourceWebUrl, TargetListName, TargetItemID, TargetWebUrl, TryAddReverseLink]);

    context.addQuery($v_0);
};
SP.RelatedItemManager.addSingleLinkToUrl = function SP_RelatedItemManager$addSingleLinkToUrl(context, SourceListName, SourceItemID, TargetItemUrl, TryAddReverseLink) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{23af17db-2585-4d17-82a7-aa9e3fba099d}', 'AddSingleLinkToUrl', [SourceListName, SourceItemID, TargetItemUrl, TryAddReverseLink]);

    context.addQuery($v_0);
};
SP.RelatedItemManager.addSingleLinkFromUrl = function SP_RelatedItemManager$addSingleLinkFromUrl(context, SourceItemUrl, TargetListName, TargetItemID, TryAddReverseLink) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{23af17db-2585-4d17-82a7-aa9e3fba099d}', 'AddSingleLinkFromUrl', [SourceItemUrl, TargetListName, TargetItemID, TryAddReverseLink]);

    context.addQuery($v_0);
};
SP.RelatedItemManager.deleteSingleLink = function SP_RelatedItemManager$deleteSingleLink(context, SourceListName, SourceItemID, SourceWebUrl, TargetListName, TargetItemID, TargetWebUrl, TryDeleteReverseLink) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{23af17db-2585-4d17-82a7-aa9e3fba099d}', 'DeleteSingleLink', [SourceListName, SourceItemID, SourceWebUrl, TargetListName, TargetItemID, TargetWebUrl, TryDeleteReverseLink]);

    context.addQuery($v_0);
};
SP.RemoteWeb = function SP_RemoteWeb(context, requestUrl) {
    SP.RemoteWeb.initializeBase(this, [context, SP.ClientUtility.getOrCreateObjectPathForConstructor(context, '{e31f488b-8615-4434-87a8-381b3af1ee3b}', arguments)]);
};
SP.RemoteWeb.newObject = function SP_RemoteWeb$newObject(context, requestUrl) {
    return new SP.RemoteWeb(context, new SP.ObjectPathConstructor(context, '{e31f488b-8615-4434-87a8-381b3af1ee3b}', [requestUrl]));
};
SP.RemoteWeb.prototype = {
    get_canSendEmail: function SP_RemoteWeb$get_canSendEmail() {
        this.checkUninitializedProperty('CanSendEmail');
        return ((this.get_objectData()).get_properties())['CanSendEmail'];
    },
    get_shareByEmailEnabled: function SP_RemoteWeb$get_shareByEmailEnabled() {
        this.checkUninitializedProperty('ShareByEmailEnabled');
        return ((this.get_objectData()).get_properties())['ShareByEmailEnabled'];
    },
    get_shareByLinkEnabled: function SP_RemoteWeb$get_shareByLinkEnabled() {
        this.checkUninitializedProperty('ShareByLinkEnabled');
        return ((this.get_objectData()).get_properties())['ShareByLinkEnabled'];
    },
    initPropertiesFromJson: function SP_RemoteWeb$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CanSendEmail;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanSendEmail'] = $v_0;
            delete parentNode.CanSendEmail;
        }
        $v_0 = parentNode.ShareByEmailEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShareByEmailEnabled'] = $v_0;
            delete parentNode.ShareByEmailEnabled;
        }
        $v_0 = parentNode.ShareByLinkEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShareByLinkEnabled'] = $v_0;
            delete parentNode.ShareByLinkEnabled;
        }
    },
    getFileByServerRelativeUrl: function SP_RemoteWeb$getFileByServerRelativeUrl(serverRelativeFileUrl) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFileByServerRelativeUrl', [serverRelativeFileUrl]));
        return $v_1;
    },
    getListById: function SP_RemoteWeb$getListById(listGuid) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetListById', [listGuid]));
        return $v_1;
    },
    getListByServerRelativeUrl: function SP_RemoteWeb$getListByServerRelativeUrl(serverRelativeUrl) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetListByServerRelativeUrl', [serverRelativeUrl]));
        return $v_1;
    },
    getFolderByServerRelativeUrl: function SP_RemoteWeb$getFolderByServerRelativeUrl(serverRelativeUrl) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetFolderByServerRelativeUrl'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetFolderByServerRelativeUrl'] = $v_2;
        }
        $v_1 = $v_2[serverRelativeUrl.toUpperCase()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Folder($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFolderByServerRelativeUrl', [serverRelativeUrl]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[serverRelativeUrl.toUpperCase()] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    getGroupById: function SP_RemoteWeb$getGroupById(groupId) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Group($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetGroupById', [groupId]));
        return $v_1;
    }
};
SP.RemoteWebPropertyNames = function SP_RemoteWebPropertyNames() {
};
SP.RenderListContextMenuDataParameters = function SP_RenderListContextMenuDataParameters() {
    SP.RenderListContextMenuDataParameters.initializeBase(this);
};
SP.RenderListContextMenuDataParameters.prototype = {
    $Y_1: null,
    $a_1: null,
    $8_1: null,
    $I_1: null,
    $e_1: null,
    $f_1: null,
    $g_1: null,
    $h_1: null,
    $i_1: null,
    $j_1: null,
    $J_1: null,
    $n_1: null,
    $E_1: null,
    $r_1: null,
    get_cascDelWarnMessage: function SP_RenderListContextMenuDataParameters$get_cascDelWarnMessage() {
        return this.$Y_1;
    },
    set_cascDelWarnMessage: function SP_RenderListContextMenuDataParameters$set_cascDelWarnMessage(value) {
        this.$Y_1 = value;
        return value;
    },
    get_customAction: function SP_RenderListContextMenuDataParameters$get_customAction() {
        return this.$a_1;
    },
    set_customAction: function SP_RenderListContextMenuDataParameters$set_customAction(value) {
        this.$a_1 = value;
        return value;
    },
    get_field: function SP_RenderListContextMenuDataParameters$get_field() {
        return this.$8_1;
    },
    set_field: function SP_RenderListContextMenuDataParameters$set_field(value) {
        this.$8_1 = value;
        return value;
    },
    get_id: function SP_RenderListContextMenuDataParameters$get_id() {
        return this.$I_1;
    },
    set_id: function SP_RenderListContextMenuDataParameters$set_id(value) {
        this.$I_1 = value;
        return value;
    },
    get_inplaceFullListSearch: function SP_RenderListContextMenuDataParameters$get_inplaceFullListSearch() {
        return this.$e_1;
    },
    set_inplaceFullListSearch: function SP_RenderListContextMenuDataParameters$set_inplaceFullListSearch(value) {
        this.$e_1 = value;
        return value;
    },
    get_inplaceSearchQuery: function SP_RenderListContextMenuDataParameters$get_inplaceSearchQuery() {
        return this.$f_1;
    },
    set_inplaceSearchQuery: function SP_RenderListContextMenuDataParameters$set_inplaceSearchQuery(value) {
        this.$f_1 = value;
        return value;
    },
    get_isCSR: function SP_RenderListContextMenuDataParameters$get_isCSR() {
        return this.$g_1;
    },
    set_isCSR: function SP_RenderListContextMenuDataParameters$set_isCSR(value) {
        this.$g_1 = value;
        return value;
    },
    get_isXslView: function SP_RenderListContextMenuDataParameters$get_isXslView() {
        return this.$h_1;
    },
    set_isXslView: function SP_RenderListContextMenuDataParameters$set_isXslView(value) {
        this.$h_1 = value;
        return value;
    },
    get_itemId: function SP_RenderListContextMenuDataParameters$get_itemId() {
        return this.$i_1;
    },
    set_itemId: function SP_RenderListContextMenuDataParameters$set_itemId(value) {
        this.$i_1 = value;
        return value;
    },
    get_listViewPageUrl: function SP_RenderListContextMenuDataParameters$get_listViewPageUrl() {
        return this.$j_1;
    },
    set_listViewPageUrl: function SP_RenderListContextMenuDataParameters$set_listViewPageUrl(value) {
        this.$j_1 = value;
        return value;
    },
    get_overrideScope: function SP_RenderListContextMenuDataParameters$get_overrideScope() {
        return this.$J_1;
    },
    set_overrideScope: function SP_RenderListContextMenuDataParameters$set_overrideScope(value) {
        this.$J_1 = value;
        return value;
    },
    get_rootFolder: function SP_RenderListContextMenuDataParameters$get_rootFolder() {
        return this.$n_1;
    },
    set_rootFolder: function SP_RenderListContextMenuDataParameters$set_rootFolder(value) {
        this.$n_1 = value;
        return value;
    },
    get_view: function SP_RenderListContextMenuDataParameters$get_view() {
        return this.$E_1;
    },
    set_view: function SP_RenderListContextMenuDataParameters$set_view(value) {
        this.$E_1 = value;
        return value;
    },
    get_viewCount: function SP_RenderListContextMenuDataParameters$get_viewCount() {
        return this.$r_1;
    },
    set_viewCount: function SP_RenderListContextMenuDataParameters$set_viewCount(value) {
        this.$r_1 = value;
        return value;
    },
    get_typeId: function SP_RenderListContextMenuDataParameters$get_typeId() {
        return '{775a72c4-6d8f-457f-ad76-d2779ca29921}';
    },
    writeToXml: function SP_RenderListContextMenuDataParameters$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['CascDelWarnMessage', 'CustomAction', 'Field', 'ID', 'InplaceFullListSearch', 'InplaceSearchQuery', 'IsCSR', 'IsXslView', 'ItemId', 'ListViewPageUrl', 'OverrideScope', 'RootFolder', 'View', 'ViewCount'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_RenderListContextMenuDataParameters$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CascDelWarnMessage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$Y_1 = $v_0;
            delete parentNode.CascDelWarnMessage;
        }
        $v_0 = parentNode.CustomAction;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$a_1 = $v_0;
            delete parentNode.CustomAction;
        }
        $v_0 = parentNode.Field;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$8_1 = $v_0;
            delete parentNode.Field;
        }
        $v_0 = parentNode.ID;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$I_1 = $v_0;
            delete parentNode.ID;
        }
        $v_0 = parentNode.InplaceFullListSearch;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$e_1 = $v_0;
            delete parentNode.InplaceFullListSearch;
        }
        $v_0 = parentNode.InplaceSearchQuery;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$f_1 = $v_0;
            delete parentNode.InplaceSearchQuery;
        }
        $v_0 = parentNode.IsCSR;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$g_1 = $v_0;
            delete parentNode.IsCSR;
        }
        $v_0 = parentNode.IsXslView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$h_1 = $v_0;
            delete parentNode.IsXslView;
        }
        $v_0 = parentNode.ItemId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$i_1 = $v_0;
            delete parentNode.ItemId;
        }
        $v_0 = parentNode.ListViewPageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$j_1 = $v_0;
            delete parentNode.ListViewPageUrl;
        }
        $v_0 = parentNode.OverrideScope;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$J_1 = $v_0;
            delete parentNode.OverrideScope;
        }
        $v_0 = parentNode.RootFolder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$n_1 = $v_0;
            delete parentNode.RootFolder;
        }
        $v_0 = parentNode.View;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$E_1 = $v_0;
            delete parentNode.View;
        }
        $v_0 = parentNode.ViewCount;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$r_1 = $v_0;
            delete parentNode.ViewCount;
        }
    }
};
SP.RenderListDataOverrideParameters = function SP_RenderListDataOverrideParameters() {
    SP.RenderListDataOverrideParameters.initializeBase(this);
};
SP.RenderListDataOverrideParameters.prototype = {
    $Y_1: null,
    $a_1: null,
    $2W_1: null,
    $8_1: null,
    $b_1: null,
    $2i_1: null,
    $2j_1: null,
    $2k_1: null,
    $2l_1: null,
    $2m_1: null,
    $2n_1: null,
    $2o_1: null,
    $2p_1: null,
    $2q_1: null,
    $2r_1: null,
    $2s_1: null,
    $2t_1: null,
    $2u_1: null,
    $2v_1: null,
    $2w_1: null,
    $2x_1: null,
    $2y_1: null,
    $2z_1: null,
    $30_1: null,
    $31_1: null,
    $32_1: null,
    $33_1: null,
    $34_1: null,
    $35_1: null,
    $36_1: null,
    $37_1: null,
    $38_1: null,
    $39_1: null,
    $3A_1: null,
    $3B_1: null,
    $3C_1: null,
    $3D_1: null,
    $3E_1: null,
    $3F_1: null,
    $3G_1: null,
    $3H_1: null,
    $3I_1: null,
    $3J_1: null,
    $3K_1: null,
    $3L_1: null,
    $3M_1: null,
    $3N_1: null,
    $3O_1: null,
    $3P_1: null,
    $3Q_1: null,
    $3R_1: null,
    $3S_1: null,
    $3T_1: null,
    $3U_1: null,
    $3V_1: null,
    $3W_1: null,
    $3X_1: null,
    $3Y_1: null,
    $3Z_1: null,
    $3a_1: null,
    $3b_1: null,
    $3c_1: null,
    $3d_1: null,
    $3e_1: null,
    $3f_1: null,
    $3g_1: null,
    $3h_1: null,
    $3i_1: null,
    $3j_1: null,
    $3k_1: null,
    $3l_1: null,
    $3m_1: null,
    $3n_1: null,
    $3o_1: null,
    $3p_1: null,
    $3q_1: null,
    $3r_1: null,
    $3s_1: null,
    $3t_1: null,
    $3u_1: null,
    $3v_1: null,
    $3w_1: null,
    $3x_1: null,
    $42_1: null,
    $44_1: null,
    $I_1: null,
    $e_1: null,
    $f_1: null,
    $g_1: null,
    $4A_1: null,
    $h_1: null,
    $j_1: null,
    $J_1: null,
    $4P_1: null,
    $4R_1: null,
    $4S_1: null,
    $n_1: null,
    $4n_1: null,
    $4o_1: null,
    $4p_1: null,
    $4q_1: null,
    $4r_1: null,
    $4s_1: null,
    $4t_1: null,
    $4u_1: null,
    $4v_1: null,
    $4w_1: null,
    $4x_1: null,
    $4y_1: null,
    $4z_1: null,
    $50_1: null,
    $51_1: null,
    $52_1: null,
    $53_1: null,
    $54_1: null,
    $55_1: null,
    $56_1: null,
    $57_1: null,
    $58_1: null,
    $59_1: null,
    $5A_1: null,
    $E_1: null,
    $r_1: null,
    $6_1: null,
    $5U_1: null,
    get_cascDelWarnMessage: function SP_RenderListDataOverrideParameters$get_cascDelWarnMessage() {
        return this.$Y_1;
    },
    set_cascDelWarnMessage: function SP_RenderListDataOverrideParameters$set_cascDelWarnMessage(value) {
        this.$Y_1 = value;
        return value;
    },
    get_customAction: function SP_RenderListDataOverrideParameters$get_customAction() {
        return this.$a_1;
    },
    set_customAction: function SP_RenderListDataOverrideParameters$set_customAction(value) {
        this.$a_1 = value;
        return value;
    },
    get_drillDown: function SP_RenderListDataOverrideParameters$get_drillDown() {
        return this.$2W_1;
    },
    set_drillDown: function SP_RenderListDataOverrideParameters$set_drillDown(value) {
        this.$2W_1 = value;
        return value;
    },
    get_field: function SP_RenderListDataOverrideParameters$get_field() {
        return this.$8_1;
    },
    set_field: function SP_RenderListDataOverrideParameters$set_field(value) {
        this.$8_1 = value;
        return value;
    },
    get_fieldInternalName: function SP_RenderListDataOverrideParameters$get_fieldInternalName() {
        return this.$b_1;
    },
    set_fieldInternalName: function SP_RenderListDataOverrideParameters$set_fieldInternalName(value) {
        this.$b_1 = value;
        return value;
    },
    get_filter: function SP_RenderListDataOverrideParameters$get_filter() {
        return this.$2i_1;
    },
    set_filter: function SP_RenderListDataOverrideParameters$set_filter(value) {
        this.$2i_1 = value;
        return value;
    },
    get_filterData: function SP_RenderListDataOverrideParameters$get_filterData() {
        return this.$2j_1;
    },
    set_filterData: function SP_RenderListDataOverrideParameters$set_filterData(value) {
        this.$2j_1 = value;
        return value;
    },
    get_filterData1: function SP_RenderListDataOverrideParameters$get_filterData1() {
        return this.$2k_1;
    },
    set_filterData1: function SP_RenderListDataOverrideParameters$set_filterData1(value) {
        this.$2k_1 = value;
        return value;
    },
    get_filterData10: function SP_RenderListDataOverrideParameters$get_filterData10() {
        return this.$2l_1;
    },
    set_filterData10: function SP_RenderListDataOverrideParameters$set_filterData10(value) {
        this.$2l_1 = value;
        return value;
    },
    get_filterData2: function SP_RenderListDataOverrideParameters$get_filterData2() {
        return this.$2m_1;
    },
    set_filterData2: function SP_RenderListDataOverrideParameters$set_filterData2(value) {
        this.$2m_1 = value;
        return value;
    },
    get_filterData3: function SP_RenderListDataOverrideParameters$get_filterData3() {
        return this.$2n_1;
    },
    set_filterData3: function SP_RenderListDataOverrideParameters$set_filterData3(value) {
        this.$2n_1 = value;
        return value;
    },
    get_filterData4: function SP_RenderListDataOverrideParameters$get_filterData4() {
        return this.$2o_1;
    },
    set_filterData4: function SP_RenderListDataOverrideParameters$set_filterData4(value) {
        this.$2o_1 = value;
        return value;
    },
    get_filterData5: function SP_RenderListDataOverrideParameters$get_filterData5() {
        return this.$2p_1;
    },
    set_filterData5: function SP_RenderListDataOverrideParameters$set_filterData5(value) {
        this.$2p_1 = value;
        return value;
    },
    get_filterData6: function SP_RenderListDataOverrideParameters$get_filterData6() {
        return this.$2q_1;
    },
    set_filterData6: function SP_RenderListDataOverrideParameters$set_filterData6(value) {
        this.$2q_1 = value;
        return value;
    },
    get_filterData7: function SP_RenderListDataOverrideParameters$get_filterData7() {
        return this.$2r_1;
    },
    set_filterData7: function SP_RenderListDataOverrideParameters$set_filterData7(value) {
        this.$2r_1 = value;
        return value;
    },
    get_filterData8: function SP_RenderListDataOverrideParameters$get_filterData8() {
        return this.$2s_1;
    },
    set_filterData8: function SP_RenderListDataOverrideParameters$set_filterData8(value) {
        this.$2s_1 = value;
        return value;
    },
    get_filterData9: function SP_RenderListDataOverrideParameters$get_filterData9() {
        return this.$2t_1;
    },
    set_filterData9: function SP_RenderListDataOverrideParameters$set_filterData9(value) {
        this.$2t_1 = value;
        return value;
    },
    get_filterField: function SP_RenderListDataOverrideParameters$get_filterField() {
        return this.$2u_1;
    },
    set_filterField: function SP_RenderListDataOverrideParameters$set_filterField(value) {
        this.$2u_1 = value;
        return value;
    },
    get_filterField1: function SP_RenderListDataOverrideParameters$get_filterField1() {
        return this.$2v_1;
    },
    set_filterField1: function SP_RenderListDataOverrideParameters$set_filterField1(value) {
        this.$2v_1 = value;
        return value;
    },
    get_filterField10: function SP_RenderListDataOverrideParameters$get_filterField10() {
        return this.$2w_1;
    },
    set_filterField10: function SP_RenderListDataOverrideParameters$set_filterField10(value) {
        this.$2w_1 = value;
        return value;
    },
    get_filterField2: function SP_RenderListDataOverrideParameters$get_filterField2() {
        return this.$2x_1;
    },
    set_filterField2: function SP_RenderListDataOverrideParameters$set_filterField2(value) {
        this.$2x_1 = value;
        return value;
    },
    get_filterField3: function SP_RenderListDataOverrideParameters$get_filterField3() {
        return this.$2y_1;
    },
    set_filterField3: function SP_RenderListDataOverrideParameters$set_filterField3(value) {
        this.$2y_1 = value;
        return value;
    },
    get_filterField4: function SP_RenderListDataOverrideParameters$get_filterField4() {
        return this.$2z_1;
    },
    set_filterField4: function SP_RenderListDataOverrideParameters$set_filterField4(value) {
        this.$2z_1 = value;
        return value;
    },
    get_filterField5: function SP_RenderListDataOverrideParameters$get_filterField5() {
        return this.$30_1;
    },
    set_filterField5: function SP_RenderListDataOverrideParameters$set_filterField5(value) {
        this.$30_1 = value;
        return value;
    },
    get_filterField6: function SP_RenderListDataOverrideParameters$get_filterField6() {
        return this.$31_1;
    },
    set_filterField6: function SP_RenderListDataOverrideParameters$set_filterField6(value) {
        this.$31_1 = value;
        return value;
    },
    get_filterField7: function SP_RenderListDataOverrideParameters$get_filterField7() {
        return this.$32_1;
    },
    set_filterField7: function SP_RenderListDataOverrideParameters$set_filterField7(value) {
        this.$32_1 = value;
        return value;
    },
    get_filterField8: function SP_RenderListDataOverrideParameters$get_filterField8() {
        return this.$33_1;
    },
    set_filterField8: function SP_RenderListDataOverrideParameters$set_filterField8(value) {
        this.$33_1 = value;
        return value;
    },
    get_filterField9: function SP_RenderListDataOverrideParameters$get_filterField9() {
        return this.$34_1;
    },
    set_filterField9: function SP_RenderListDataOverrideParameters$set_filterField9(value) {
        this.$34_1 = value;
        return value;
    },
    get_filterFields: function SP_RenderListDataOverrideParameters$get_filterFields() {
        return this.$35_1;
    },
    set_filterFields: function SP_RenderListDataOverrideParameters$set_filterFields(value) {
        this.$35_1 = value;
        return value;
    },
    get_filterFields1: function SP_RenderListDataOverrideParameters$get_filterFields1() {
        return this.$36_1;
    },
    set_filterFields1: function SP_RenderListDataOverrideParameters$set_filterFields1(value) {
        this.$36_1 = value;
        return value;
    },
    get_filterFields10: function SP_RenderListDataOverrideParameters$get_filterFields10() {
        return this.$37_1;
    },
    set_filterFields10: function SP_RenderListDataOverrideParameters$set_filterFields10(value) {
        this.$37_1 = value;
        return value;
    },
    get_filterFields2: function SP_RenderListDataOverrideParameters$get_filterFields2() {
        return this.$38_1;
    },
    set_filterFields2: function SP_RenderListDataOverrideParameters$set_filterFields2(value) {
        this.$38_1 = value;
        return value;
    },
    get_filterFields3: function SP_RenderListDataOverrideParameters$get_filterFields3() {
        return this.$39_1;
    },
    set_filterFields3: function SP_RenderListDataOverrideParameters$set_filterFields3(value) {
        this.$39_1 = value;
        return value;
    },
    get_filterFields4: function SP_RenderListDataOverrideParameters$get_filterFields4() {
        return this.$3A_1;
    },
    set_filterFields4: function SP_RenderListDataOverrideParameters$set_filterFields4(value) {
        this.$3A_1 = value;
        return value;
    },
    get_filterFields5: function SP_RenderListDataOverrideParameters$get_filterFields5() {
        return this.$3B_1;
    },
    set_filterFields5: function SP_RenderListDataOverrideParameters$set_filterFields5(value) {
        this.$3B_1 = value;
        return value;
    },
    get_filterFields6: function SP_RenderListDataOverrideParameters$get_filterFields6() {
        return this.$3C_1;
    },
    set_filterFields6: function SP_RenderListDataOverrideParameters$set_filterFields6(value) {
        this.$3C_1 = value;
        return value;
    },
    get_filterFields7: function SP_RenderListDataOverrideParameters$get_filterFields7() {
        return this.$3D_1;
    },
    set_filterFields7: function SP_RenderListDataOverrideParameters$set_filterFields7(value) {
        this.$3D_1 = value;
        return value;
    },
    get_filterFields8: function SP_RenderListDataOverrideParameters$get_filterFields8() {
        return this.$3E_1;
    },
    set_filterFields8: function SP_RenderListDataOverrideParameters$set_filterFields8(value) {
        this.$3E_1 = value;
        return value;
    },
    get_filterFields9: function SP_RenderListDataOverrideParameters$get_filterFields9() {
        return this.$3F_1;
    },
    set_filterFields9: function SP_RenderListDataOverrideParameters$set_filterFields9(value) {
        this.$3F_1 = value;
        return value;
    },
    get_filterLookupId: function SP_RenderListDataOverrideParameters$get_filterLookupId() {
        return this.$3G_1;
    },
    set_filterLookupId: function SP_RenderListDataOverrideParameters$set_filterLookupId(value) {
        this.$3G_1 = value;
        return value;
    },
    get_filterLookupId1: function SP_RenderListDataOverrideParameters$get_filterLookupId1() {
        return this.$3H_1;
    },
    set_filterLookupId1: function SP_RenderListDataOverrideParameters$set_filterLookupId1(value) {
        this.$3H_1 = value;
        return value;
    },
    get_filterLookupId10: function SP_RenderListDataOverrideParameters$get_filterLookupId10() {
        return this.$3I_1;
    },
    set_filterLookupId10: function SP_RenderListDataOverrideParameters$set_filterLookupId10(value) {
        this.$3I_1 = value;
        return value;
    },
    get_filterLookupId2: function SP_RenderListDataOverrideParameters$get_filterLookupId2() {
        return this.$3J_1;
    },
    set_filterLookupId2: function SP_RenderListDataOverrideParameters$set_filterLookupId2(value) {
        this.$3J_1 = value;
        return value;
    },
    get_filterLookupId3: function SP_RenderListDataOverrideParameters$get_filterLookupId3() {
        return this.$3K_1;
    },
    set_filterLookupId3: function SP_RenderListDataOverrideParameters$set_filterLookupId3(value) {
        this.$3K_1 = value;
        return value;
    },
    get_filterLookupId4: function SP_RenderListDataOverrideParameters$get_filterLookupId4() {
        return this.$3L_1;
    },
    set_filterLookupId4: function SP_RenderListDataOverrideParameters$set_filterLookupId4(value) {
        this.$3L_1 = value;
        return value;
    },
    get_filterLookupId5: function SP_RenderListDataOverrideParameters$get_filterLookupId5() {
        return this.$3M_1;
    },
    set_filterLookupId5: function SP_RenderListDataOverrideParameters$set_filterLookupId5(value) {
        this.$3M_1 = value;
        return value;
    },
    get_filterLookupId6: function SP_RenderListDataOverrideParameters$get_filterLookupId6() {
        return this.$3N_1;
    },
    set_filterLookupId6: function SP_RenderListDataOverrideParameters$set_filterLookupId6(value) {
        this.$3N_1 = value;
        return value;
    },
    get_filterLookupId7: function SP_RenderListDataOverrideParameters$get_filterLookupId7() {
        return this.$3O_1;
    },
    set_filterLookupId7: function SP_RenderListDataOverrideParameters$set_filterLookupId7(value) {
        this.$3O_1 = value;
        return value;
    },
    get_filterLookupId8: function SP_RenderListDataOverrideParameters$get_filterLookupId8() {
        return this.$3P_1;
    },
    set_filterLookupId8: function SP_RenderListDataOverrideParameters$set_filterLookupId8(value) {
        this.$3P_1 = value;
        return value;
    },
    get_filterLookupId9: function SP_RenderListDataOverrideParameters$get_filterLookupId9() {
        return this.$3Q_1;
    },
    set_filterLookupId9: function SP_RenderListDataOverrideParameters$set_filterLookupId9(value) {
        this.$3Q_1 = value;
        return value;
    },
    get_filterOp: function SP_RenderListDataOverrideParameters$get_filterOp() {
        return this.$3R_1;
    },
    set_filterOp: function SP_RenderListDataOverrideParameters$set_filterOp(value) {
        this.$3R_1 = value;
        return value;
    },
    get_filterOp1: function SP_RenderListDataOverrideParameters$get_filterOp1() {
        return this.$3S_1;
    },
    set_filterOp1: function SP_RenderListDataOverrideParameters$set_filterOp1(value) {
        this.$3S_1 = value;
        return value;
    },
    get_filterOp10: function SP_RenderListDataOverrideParameters$get_filterOp10() {
        return this.$3T_1;
    },
    set_filterOp10: function SP_RenderListDataOverrideParameters$set_filterOp10(value) {
        this.$3T_1 = value;
        return value;
    },
    get_filterOp2: function SP_RenderListDataOverrideParameters$get_filterOp2() {
        return this.$3U_1;
    },
    set_filterOp2: function SP_RenderListDataOverrideParameters$set_filterOp2(value) {
        this.$3U_1 = value;
        return value;
    },
    get_filterOp3: function SP_RenderListDataOverrideParameters$get_filterOp3() {
        return this.$3V_1;
    },
    set_filterOp3: function SP_RenderListDataOverrideParameters$set_filterOp3(value) {
        this.$3V_1 = value;
        return value;
    },
    get_filterOp4: function SP_RenderListDataOverrideParameters$get_filterOp4() {
        return this.$3W_1;
    },
    set_filterOp4: function SP_RenderListDataOverrideParameters$set_filterOp4(value) {
        this.$3W_1 = value;
        return value;
    },
    get_filterOp5: function SP_RenderListDataOverrideParameters$get_filterOp5() {
        return this.$3X_1;
    },
    set_filterOp5: function SP_RenderListDataOverrideParameters$set_filterOp5(value) {
        this.$3X_1 = value;
        return value;
    },
    get_filterOp6: function SP_RenderListDataOverrideParameters$get_filterOp6() {
        return this.$3Y_1;
    },
    set_filterOp6: function SP_RenderListDataOverrideParameters$set_filterOp6(value) {
        this.$3Y_1 = value;
        return value;
    },
    get_filterOp7: function SP_RenderListDataOverrideParameters$get_filterOp7() {
        return this.$3Z_1;
    },
    set_filterOp7: function SP_RenderListDataOverrideParameters$set_filterOp7(value) {
        this.$3Z_1 = value;
        return value;
    },
    get_filterOp8: function SP_RenderListDataOverrideParameters$get_filterOp8() {
        return this.$3a_1;
    },
    set_filterOp8: function SP_RenderListDataOverrideParameters$set_filterOp8(value) {
        this.$3a_1 = value;
        return value;
    },
    get_filterOp9: function SP_RenderListDataOverrideParameters$get_filterOp9() {
        return this.$3b_1;
    },
    set_filterOp9: function SP_RenderListDataOverrideParameters$set_filterOp9(value) {
        this.$3b_1 = value;
        return value;
    },
    get_filterValue: function SP_RenderListDataOverrideParameters$get_filterValue() {
        return this.$3c_1;
    },
    set_filterValue: function SP_RenderListDataOverrideParameters$set_filterValue(value) {
        this.$3c_1 = value;
        return value;
    },
    get_filterValue1: function SP_RenderListDataOverrideParameters$get_filterValue1() {
        return this.$3d_1;
    },
    set_filterValue1: function SP_RenderListDataOverrideParameters$set_filterValue1(value) {
        this.$3d_1 = value;
        return value;
    },
    get_filterValue10: function SP_RenderListDataOverrideParameters$get_filterValue10() {
        return this.$3e_1;
    },
    set_filterValue10: function SP_RenderListDataOverrideParameters$set_filterValue10(value) {
        this.$3e_1 = value;
        return value;
    },
    get_filterValue2: function SP_RenderListDataOverrideParameters$get_filterValue2() {
        return this.$3f_1;
    },
    set_filterValue2: function SP_RenderListDataOverrideParameters$set_filterValue2(value) {
        this.$3f_1 = value;
        return value;
    },
    get_filterValue3: function SP_RenderListDataOverrideParameters$get_filterValue3() {
        return this.$3g_1;
    },
    set_filterValue3: function SP_RenderListDataOverrideParameters$set_filterValue3(value) {
        this.$3g_1 = value;
        return value;
    },
    get_filterValue4: function SP_RenderListDataOverrideParameters$get_filterValue4() {
        return this.$3h_1;
    },
    set_filterValue4: function SP_RenderListDataOverrideParameters$set_filterValue4(value) {
        this.$3h_1 = value;
        return value;
    },
    get_filterValue5: function SP_RenderListDataOverrideParameters$get_filterValue5() {
        return this.$3i_1;
    },
    set_filterValue5: function SP_RenderListDataOverrideParameters$set_filterValue5(value) {
        this.$3i_1 = value;
        return value;
    },
    get_filterValue6: function SP_RenderListDataOverrideParameters$get_filterValue6() {
        return this.$3j_1;
    },
    set_filterValue6: function SP_RenderListDataOverrideParameters$set_filterValue6(value) {
        this.$3j_1 = value;
        return value;
    },
    get_filterValue7: function SP_RenderListDataOverrideParameters$get_filterValue7() {
        return this.$3k_1;
    },
    set_filterValue7: function SP_RenderListDataOverrideParameters$set_filterValue7(value) {
        this.$3k_1 = value;
        return value;
    },
    get_filterValue8: function SP_RenderListDataOverrideParameters$get_filterValue8() {
        return this.$3l_1;
    },
    set_filterValue8: function SP_RenderListDataOverrideParameters$set_filterValue8(value) {
        this.$3l_1 = value;
        return value;
    },
    get_filterValue9: function SP_RenderListDataOverrideParameters$get_filterValue9() {
        return this.$3m_1;
    },
    set_filterValue9: function SP_RenderListDataOverrideParameters$set_filterValue9(value) {
        this.$3m_1 = value;
        return value;
    },
    get_filterValues: function SP_RenderListDataOverrideParameters$get_filterValues() {
        return this.$3n_1;
    },
    set_filterValues: function SP_RenderListDataOverrideParameters$set_filterValues(value) {
        this.$3n_1 = value;
        return value;
    },
    get_filterValues1: function SP_RenderListDataOverrideParameters$get_filterValues1() {
        return this.$3o_1;
    },
    set_filterValues1: function SP_RenderListDataOverrideParameters$set_filterValues1(value) {
        this.$3o_1 = value;
        return value;
    },
    get_filterValues10: function SP_RenderListDataOverrideParameters$get_filterValues10() {
        return this.$3p_1;
    },
    set_filterValues10: function SP_RenderListDataOverrideParameters$set_filterValues10(value) {
        this.$3p_1 = value;
        return value;
    },
    get_filterValues2: function SP_RenderListDataOverrideParameters$get_filterValues2() {
        return this.$3q_1;
    },
    set_filterValues2: function SP_RenderListDataOverrideParameters$set_filterValues2(value) {
        this.$3q_1 = value;
        return value;
    },
    get_filterValues3: function SP_RenderListDataOverrideParameters$get_filterValues3() {
        return this.$3r_1;
    },
    set_filterValues3: function SP_RenderListDataOverrideParameters$set_filterValues3(value) {
        this.$3r_1 = value;
        return value;
    },
    get_filterValues4: function SP_RenderListDataOverrideParameters$get_filterValues4() {
        return this.$3s_1;
    },
    set_filterValues4: function SP_RenderListDataOverrideParameters$set_filterValues4(value) {
        this.$3s_1 = value;
        return value;
    },
    get_filterValues5: function SP_RenderListDataOverrideParameters$get_filterValues5() {
        return this.$3t_1;
    },
    set_filterValues5: function SP_RenderListDataOverrideParameters$set_filterValues5(value) {
        this.$3t_1 = value;
        return value;
    },
    get_filterValues6: function SP_RenderListDataOverrideParameters$get_filterValues6() {
        return this.$3u_1;
    },
    set_filterValues6: function SP_RenderListDataOverrideParameters$set_filterValues6(value) {
        this.$3u_1 = value;
        return value;
    },
    get_filterValues7: function SP_RenderListDataOverrideParameters$get_filterValues7() {
        return this.$3v_1;
    },
    set_filterValues7: function SP_RenderListDataOverrideParameters$set_filterValues7(value) {
        this.$3v_1 = value;
        return value;
    },
    get_filterValues8: function SP_RenderListDataOverrideParameters$get_filterValues8() {
        return this.$3w_1;
    },
    set_filterValues8: function SP_RenderListDataOverrideParameters$set_filterValues8(value) {
        this.$3w_1 = value;
        return value;
    },
    get_filterValues9: function SP_RenderListDataOverrideParameters$get_filterValues9() {
        return this.$3x_1;
    },
    set_filterValues9: function SP_RenderListDataOverrideParameters$set_filterValues9(value) {
        this.$3x_1 = value;
        return value;
    },
    get_groupString: function SP_RenderListDataOverrideParameters$get_groupString() {
        return this.$42_1;
    },
    set_groupString: function SP_RenderListDataOverrideParameters$set_groupString(value) {
        this.$42_1 = value;
        return value;
    },
    get_hasOverrideSelectCommand: function SP_RenderListDataOverrideParameters$get_hasOverrideSelectCommand() {
        return this.$44_1;
    },
    set_hasOverrideSelectCommand: function SP_RenderListDataOverrideParameters$set_hasOverrideSelectCommand(value) {
        this.$44_1 = value;
        return value;
    },
    get_id: function SP_RenderListDataOverrideParameters$get_id() {
        return this.$I_1;
    },
    set_id: function SP_RenderListDataOverrideParameters$set_id(value) {
        this.$I_1 = value;
        return value;
    },
    get_inplaceFullListSearch: function SP_RenderListDataOverrideParameters$get_inplaceFullListSearch() {
        return this.$e_1;
    },
    set_inplaceFullListSearch: function SP_RenderListDataOverrideParameters$set_inplaceFullListSearch(value) {
        this.$e_1 = value;
        return value;
    },
    get_inplaceSearchQuery: function SP_RenderListDataOverrideParameters$get_inplaceSearchQuery() {
        return this.$f_1;
    },
    set_inplaceSearchQuery: function SP_RenderListDataOverrideParameters$set_inplaceSearchQuery(value) {
        this.$f_1 = value;
        return value;
    },
    get_isCSR: function SP_RenderListDataOverrideParameters$get_isCSR() {
        return this.$g_1;
    },
    set_isCSR: function SP_RenderListDataOverrideParameters$set_isCSR(value) {
        this.$g_1 = value;
        return value;
    },
    get_isGroupRender: function SP_RenderListDataOverrideParameters$get_isGroupRender() {
        return this.$4A_1;
    },
    set_isGroupRender: function SP_RenderListDataOverrideParameters$set_isGroupRender(value) {
        this.$4A_1 = value;
        return value;
    },
    get_isXslView: function SP_RenderListDataOverrideParameters$get_isXslView() {
        return this.$h_1;
    },
    set_isXslView: function SP_RenderListDataOverrideParameters$set_isXslView(value) {
        this.$h_1 = value;
        return value;
    },
    get_listViewPageUrl: function SP_RenderListDataOverrideParameters$get_listViewPageUrl() {
        return this.$j_1;
    },
    set_listViewPageUrl: function SP_RenderListDataOverrideParameters$set_listViewPageUrl(value) {
        this.$j_1 = value;
        return value;
    },
    get_overrideScope: function SP_RenderListDataOverrideParameters$get_overrideScope() {
        return this.$J_1;
    },
    set_overrideScope: function SP_RenderListDataOverrideParameters$set_overrideScope(value) {
        this.$J_1 = value;
        return value;
    },
    get_overrideSelectCommand: function SP_RenderListDataOverrideParameters$get_overrideSelectCommand() {
        return this.$4P_1;
    },
    set_overrideSelectCommand: function SP_RenderListDataOverrideParameters$set_overrideSelectCommand(value) {
        this.$4P_1 = value;
        return value;
    },
    get_pageFirstRow: function SP_RenderListDataOverrideParameters$get_pageFirstRow() {
        return this.$4R_1;
    },
    set_pageFirstRow: function SP_RenderListDataOverrideParameters$set_pageFirstRow(value) {
        this.$4R_1 = value;
        return value;
    },
    get_pageLastRow: function SP_RenderListDataOverrideParameters$get_pageLastRow() {
        return this.$4S_1;
    },
    set_pageLastRow: function SP_RenderListDataOverrideParameters$set_pageLastRow(value) {
        this.$4S_1 = value;
        return value;
    },
    get_rootFolder: function SP_RenderListDataOverrideParameters$get_rootFolder() {
        return this.$n_1;
    },
    set_rootFolder: function SP_RenderListDataOverrideParameters$set_rootFolder(value) {
        this.$n_1 = value;
        return value;
    },
    get_sortDir: function SP_RenderListDataOverrideParameters$get_sortDir() {
        return this.$4n_1;
    },
    set_sortDir: function SP_RenderListDataOverrideParameters$set_sortDir(value) {
        this.$4n_1 = value;
        return value;
    },
    get_sortDir1: function SP_RenderListDataOverrideParameters$get_sortDir1() {
        return this.$4o_1;
    },
    set_sortDir1: function SP_RenderListDataOverrideParameters$set_sortDir1(value) {
        this.$4o_1 = value;
        return value;
    },
    get_sortDir10: function SP_RenderListDataOverrideParameters$get_sortDir10() {
        return this.$4p_1;
    },
    set_sortDir10: function SP_RenderListDataOverrideParameters$set_sortDir10(value) {
        this.$4p_1 = value;
        return value;
    },
    get_sortDir2: function SP_RenderListDataOverrideParameters$get_sortDir2() {
        return this.$4q_1;
    },
    set_sortDir2: function SP_RenderListDataOverrideParameters$set_sortDir2(value) {
        this.$4q_1 = value;
        return value;
    },
    get_sortDir3: function SP_RenderListDataOverrideParameters$get_sortDir3() {
        return this.$4r_1;
    },
    set_sortDir3: function SP_RenderListDataOverrideParameters$set_sortDir3(value) {
        this.$4r_1 = value;
        return value;
    },
    get_sortDir4: function SP_RenderListDataOverrideParameters$get_sortDir4() {
        return this.$4s_1;
    },
    set_sortDir4: function SP_RenderListDataOverrideParameters$set_sortDir4(value) {
        this.$4s_1 = value;
        return value;
    },
    get_sortDir5: function SP_RenderListDataOverrideParameters$get_sortDir5() {
        return this.$4t_1;
    },
    set_sortDir5: function SP_RenderListDataOverrideParameters$set_sortDir5(value) {
        this.$4t_1 = value;
        return value;
    },
    get_sortDir6: function SP_RenderListDataOverrideParameters$get_sortDir6() {
        return this.$4u_1;
    },
    set_sortDir6: function SP_RenderListDataOverrideParameters$set_sortDir6(value) {
        this.$4u_1 = value;
        return value;
    },
    get_sortDir7: function SP_RenderListDataOverrideParameters$get_sortDir7() {
        return this.$4v_1;
    },
    set_sortDir7: function SP_RenderListDataOverrideParameters$set_sortDir7(value) {
        this.$4v_1 = value;
        return value;
    },
    get_sortDir8: function SP_RenderListDataOverrideParameters$get_sortDir8() {
        return this.$4w_1;
    },
    set_sortDir8: function SP_RenderListDataOverrideParameters$set_sortDir8(value) {
        this.$4w_1 = value;
        return value;
    },
    get_sortDir9: function SP_RenderListDataOverrideParameters$get_sortDir9() {
        return this.$4x_1;
    },
    set_sortDir9: function SP_RenderListDataOverrideParameters$set_sortDir9(value) {
        this.$4x_1 = value;
        return value;
    },
    get_sortField: function SP_RenderListDataOverrideParameters$get_sortField() {
        return this.$4y_1;
    },
    set_sortField: function SP_RenderListDataOverrideParameters$set_sortField(value) {
        this.$4y_1 = value;
        return value;
    },
    get_sortField1: function SP_RenderListDataOverrideParameters$get_sortField1() {
        return this.$4z_1;
    },
    set_sortField1: function SP_RenderListDataOverrideParameters$set_sortField1(value) {
        this.$4z_1 = value;
        return value;
    },
    get_sortField10: function SP_RenderListDataOverrideParameters$get_sortField10() {
        return this.$50_1;
    },
    set_sortField10: function SP_RenderListDataOverrideParameters$set_sortField10(value) {
        this.$50_1 = value;
        return value;
    },
    get_sortField2: function SP_RenderListDataOverrideParameters$get_sortField2() {
        return this.$51_1;
    },
    set_sortField2: function SP_RenderListDataOverrideParameters$set_sortField2(value) {
        this.$51_1 = value;
        return value;
    },
    get_sortField3: function SP_RenderListDataOverrideParameters$get_sortField3() {
        return this.$52_1;
    },
    set_sortField3: function SP_RenderListDataOverrideParameters$set_sortField3(value) {
        this.$52_1 = value;
        return value;
    },
    get_sortField4: function SP_RenderListDataOverrideParameters$get_sortField4() {
        return this.$53_1;
    },
    set_sortField4: function SP_RenderListDataOverrideParameters$set_sortField4(value) {
        this.$53_1 = value;
        return value;
    },
    get_sortField5: function SP_RenderListDataOverrideParameters$get_sortField5() {
        return this.$54_1;
    },
    set_sortField5: function SP_RenderListDataOverrideParameters$set_sortField5(value) {
        this.$54_1 = value;
        return value;
    },
    get_sortField6: function SP_RenderListDataOverrideParameters$get_sortField6() {
        return this.$55_1;
    },
    set_sortField6: function SP_RenderListDataOverrideParameters$set_sortField6(value) {
        this.$55_1 = value;
        return value;
    },
    get_sortField7: function SP_RenderListDataOverrideParameters$get_sortField7() {
        return this.$56_1;
    },
    set_sortField7: function SP_RenderListDataOverrideParameters$set_sortField7(value) {
        this.$56_1 = value;
        return value;
    },
    get_sortField8: function SP_RenderListDataOverrideParameters$get_sortField8() {
        return this.$57_1;
    },
    set_sortField8: function SP_RenderListDataOverrideParameters$set_sortField8(value) {
        this.$57_1 = value;
        return value;
    },
    get_sortField9: function SP_RenderListDataOverrideParameters$get_sortField9() {
        return this.$58_1;
    },
    set_sortField9: function SP_RenderListDataOverrideParameters$set_sortField9(value) {
        this.$58_1 = value;
        return value;
    },
    get_sortFields: function SP_RenderListDataOverrideParameters$get_sortFields() {
        return this.$59_1;
    },
    set_sortFields: function SP_RenderListDataOverrideParameters$set_sortFields(value) {
        this.$59_1 = value;
        return value;
    },
    get_sortFieldValues: function SP_RenderListDataOverrideParameters$get_sortFieldValues() {
        return this.$5A_1;
    },
    set_sortFieldValues: function SP_RenderListDataOverrideParameters$set_sortFieldValues(value) {
        this.$5A_1 = value;
        return value;
    },
    get_view: function SP_RenderListDataOverrideParameters$get_view() {
        return this.$E_1;
    },
    set_view: function SP_RenderListDataOverrideParameters$set_view(value) {
        this.$E_1 = value;
        return value;
    },
    get_viewCount: function SP_RenderListDataOverrideParameters$get_viewCount() {
        return this.$r_1;
    },
    set_viewCount: function SP_RenderListDataOverrideParameters$set_viewCount(value) {
        this.$r_1 = value;
        return value;
    },
    get_viewId: function SP_RenderListDataOverrideParameters$get_viewId() {
        return this.$6_1;
    },
    set_viewId: function SP_RenderListDataOverrideParameters$set_viewId(value) {
        this.$6_1 = value;
        return value;
    },
    get_webPartId: function SP_RenderListDataOverrideParameters$get_webPartId() {
        return this.$5U_1;
    },
    set_webPartId: function SP_RenderListDataOverrideParameters$set_webPartId(value) {
        this.$5U_1 = value;
        return value;
    },
    get_typeId: function SP_RenderListDataOverrideParameters$get_typeId() {
        return '{ad0885e6-0f16-4694-9397-058c65376fb7}';
    },
    writeToXml: function SP_RenderListDataOverrideParameters$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['CascDelWarnMessage', 'CustomAction', 'DrillDown', 'Field', 'FieldInternalName', 'Filter', 'FilterData', 'FilterData1', 'FilterData10', 'FilterData2', 'FilterData3', 'FilterData4', 'FilterData5', 'FilterData6', 'FilterData7', 'FilterData8', 'FilterData9', 'FilterField', 'FilterField1', 'FilterField10', 'FilterField2', 'FilterField3', 'FilterField4', 'FilterField5', 'FilterField6', 'FilterField7', 'FilterField8', 'FilterField9', 'FilterFields', 'FilterFields1', 'FilterFields10', 'FilterFields2', 'FilterFields3', 'FilterFields4', 'FilterFields5', 'FilterFields6', 'FilterFields7', 'FilterFields8', 'FilterFields9', 'FilterLookupId', 'FilterLookupId1', 'FilterLookupId10', 'FilterLookupId2', 'FilterLookupId3', 'FilterLookupId4', 'FilterLookupId5', 'FilterLookupId6', 'FilterLookupId7', 'FilterLookupId8', 'FilterLookupId9', 'FilterOp', 'FilterOp1', 'FilterOp10', 'FilterOp2', 'FilterOp3', 'FilterOp4', 'FilterOp5', 'FilterOp6', 'FilterOp7', 'FilterOp8', 'FilterOp9', 'FilterValue', 'FilterValue1', 'FilterValue10', 'FilterValue2', 'FilterValue3', 'FilterValue4', 'FilterValue5', 'FilterValue6', 'FilterValue7', 'FilterValue8', 'FilterValue9', 'FilterValues', 'FilterValues1', 'FilterValues10', 'FilterValues2', 'FilterValues3', 'FilterValues4', 'FilterValues5', 'FilterValues6', 'FilterValues7', 'FilterValues8', 'FilterValues9', 'GroupString', 'HasOverrideSelectCommand', 'ID', 'InplaceFullListSearch', 'InplaceSearchQuery', 'IsCSR', 'IsGroupRender', 'IsXslView', 'ListViewPageUrl', 'OverrideScope', 'OverrideSelectCommand', 'PageFirstRow', 'PageLastRow', 'RootFolder', 'SortDir', 'SortDir1', 'SortDir10', 'SortDir2', 'SortDir3', 'SortDir4', 'SortDir5', 'SortDir6', 'SortDir7', 'SortDir8', 'SortDir9', 'SortField', 'SortField1', 'SortField10', 'SortField2', 'SortField3', 'SortField4', 'SortField5', 'SortField6', 'SortField7', 'SortField8', 'SortField9', 'SortFields', 'SortFieldValues', 'View', 'ViewCount', 'ViewId', 'WebPartId'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_RenderListDataOverrideParameters$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CascDelWarnMessage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$Y_1 = $v_0;
            delete parentNode.CascDelWarnMessage;
        }
        $v_0 = parentNode.CustomAction;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$a_1 = $v_0;
            delete parentNode.CustomAction;
        }
        $v_0 = parentNode.DrillDown;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2W_1 = $v_0;
            delete parentNode.DrillDown;
        }
        $v_0 = parentNode.Field;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$8_1 = $v_0;
            delete parentNode.Field;
        }
        $v_0 = parentNode.FieldInternalName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$b_1 = $v_0;
            delete parentNode.FieldInternalName;
        }
        $v_0 = parentNode.Filter;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2i_1 = $v_0;
            delete parentNode.Filter;
        }
        $v_0 = parentNode.FilterData;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2j_1 = $v_0;
            delete parentNode.FilterData;
        }
        $v_0 = parentNode.FilterData1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2k_1 = $v_0;
            delete parentNode.FilterData1;
        }
        $v_0 = parentNode.FilterData10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2l_1 = $v_0;
            delete parentNode.FilterData10;
        }
        $v_0 = parentNode.FilterData2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2m_1 = $v_0;
            delete parentNode.FilterData2;
        }
        $v_0 = parentNode.FilterData3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2n_1 = $v_0;
            delete parentNode.FilterData3;
        }
        $v_0 = parentNode.FilterData4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2o_1 = $v_0;
            delete parentNode.FilterData4;
        }
        $v_0 = parentNode.FilterData5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2p_1 = $v_0;
            delete parentNode.FilterData5;
        }
        $v_0 = parentNode.FilterData6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2q_1 = $v_0;
            delete parentNode.FilterData6;
        }
        $v_0 = parentNode.FilterData7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2r_1 = $v_0;
            delete parentNode.FilterData7;
        }
        $v_0 = parentNode.FilterData8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2s_1 = $v_0;
            delete parentNode.FilterData8;
        }
        $v_0 = parentNode.FilterData9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2t_1 = $v_0;
            delete parentNode.FilterData9;
        }
        $v_0 = parentNode.FilterField;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2u_1 = $v_0;
            delete parentNode.FilterField;
        }
        $v_0 = parentNode.FilterField1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2v_1 = $v_0;
            delete parentNode.FilterField1;
        }
        $v_0 = parentNode.FilterField10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2w_1 = $v_0;
            delete parentNode.FilterField10;
        }
        $v_0 = parentNode.FilterField2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2x_1 = $v_0;
            delete parentNode.FilterField2;
        }
        $v_0 = parentNode.FilterField3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2y_1 = $v_0;
            delete parentNode.FilterField3;
        }
        $v_0 = parentNode.FilterField4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2z_1 = $v_0;
            delete parentNode.FilterField4;
        }
        $v_0 = parentNode.FilterField5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$30_1 = $v_0;
            delete parentNode.FilterField5;
        }
        $v_0 = parentNode.FilterField6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$31_1 = $v_0;
            delete parentNode.FilterField6;
        }
        $v_0 = parentNode.FilterField7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$32_1 = $v_0;
            delete parentNode.FilterField7;
        }
        $v_0 = parentNode.FilterField8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$33_1 = $v_0;
            delete parentNode.FilterField8;
        }
        $v_0 = parentNode.FilterField9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$34_1 = $v_0;
            delete parentNode.FilterField9;
        }
        $v_0 = parentNode.FilterFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$35_1 = $v_0;
            delete parentNode.FilterFields;
        }
        $v_0 = parentNode.FilterFields1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$36_1 = $v_0;
            delete parentNode.FilterFields1;
        }
        $v_0 = parentNode.FilterFields10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$37_1 = $v_0;
            delete parentNode.FilterFields10;
        }
        $v_0 = parentNode.FilterFields2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$38_1 = $v_0;
            delete parentNode.FilterFields2;
        }
        $v_0 = parentNode.FilterFields3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$39_1 = $v_0;
            delete parentNode.FilterFields3;
        }
        $v_0 = parentNode.FilterFields4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3A_1 = $v_0;
            delete parentNode.FilterFields4;
        }
        $v_0 = parentNode.FilterFields5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3B_1 = $v_0;
            delete parentNode.FilterFields5;
        }
        $v_0 = parentNode.FilterFields6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3C_1 = $v_0;
            delete parentNode.FilterFields6;
        }
        $v_0 = parentNode.FilterFields7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3D_1 = $v_0;
            delete parentNode.FilterFields7;
        }
        $v_0 = parentNode.FilterFields8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3E_1 = $v_0;
            delete parentNode.FilterFields8;
        }
        $v_0 = parentNode.FilterFields9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3F_1 = $v_0;
            delete parentNode.FilterFields9;
        }
        $v_0 = parentNode.FilterLookupId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3G_1 = $v_0;
            delete parentNode.FilterLookupId;
        }
        $v_0 = parentNode.FilterLookupId1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3H_1 = $v_0;
            delete parentNode.FilterLookupId1;
        }
        $v_0 = parentNode.FilterLookupId10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3I_1 = $v_0;
            delete parentNode.FilterLookupId10;
        }
        $v_0 = parentNode.FilterLookupId2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3J_1 = $v_0;
            delete parentNode.FilterLookupId2;
        }
        $v_0 = parentNode.FilterLookupId3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3K_1 = $v_0;
            delete parentNode.FilterLookupId3;
        }
        $v_0 = parentNode.FilterLookupId4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3L_1 = $v_0;
            delete parentNode.FilterLookupId4;
        }
        $v_0 = parentNode.FilterLookupId5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3M_1 = $v_0;
            delete parentNode.FilterLookupId5;
        }
        $v_0 = parentNode.FilterLookupId6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3N_1 = $v_0;
            delete parentNode.FilterLookupId6;
        }
        $v_0 = parentNode.FilterLookupId7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3O_1 = $v_0;
            delete parentNode.FilterLookupId7;
        }
        $v_0 = parentNode.FilterLookupId8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3P_1 = $v_0;
            delete parentNode.FilterLookupId8;
        }
        $v_0 = parentNode.FilterLookupId9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3Q_1 = $v_0;
            delete parentNode.FilterLookupId9;
        }
        $v_0 = parentNode.FilterOp;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3R_1 = $v_0;
            delete parentNode.FilterOp;
        }
        $v_0 = parentNode.FilterOp1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3S_1 = $v_0;
            delete parentNode.FilterOp1;
        }
        $v_0 = parentNode.FilterOp10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3T_1 = $v_0;
            delete parentNode.FilterOp10;
        }
        $v_0 = parentNode.FilterOp2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3U_1 = $v_0;
            delete parentNode.FilterOp2;
        }
        $v_0 = parentNode.FilterOp3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3V_1 = $v_0;
            delete parentNode.FilterOp3;
        }
        $v_0 = parentNode.FilterOp4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3W_1 = $v_0;
            delete parentNode.FilterOp4;
        }
        $v_0 = parentNode.FilterOp5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3X_1 = $v_0;
            delete parentNode.FilterOp5;
        }
        $v_0 = parentNode.FilterOp6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3Y_1 = $v_0;
            delete parentNode.FilterOp6;
        }
        $v_0 = parentNode.FilterOp7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3Z_1 = $v_0;
            delete parentNode.FilterOp7;
        }
        $v_0 = parentNode.FilterOp8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3a_1 = $v_0;
            delete parentNode.FilterOp8;
        }
        $v_0 = parentNode.FilterOp9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3b_1 = $v_0;
            delete parentNode.FilterOp9;
        }
        $v_0 = parentNode.FilterValue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3c_1 = $v_0;
            delete parentNode.FilterValue;
        }
        $v_0 = parentNode.FilterValue1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3d_1 = $v_0;
            delete parentNode.FilterValue1;
        }
        $v_0 = parentNode.FilterValue10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3e_1 = $v_0;
            delete parentNode.FilterValue10;
        }
        $v_0 = parentNode.FilterValue2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3f_1 = $v_0;
            delete parentNode.FilterValue2;
        }
        $v_0 = parentNode.FilterValue3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3g_1 = $v_0;
            delete parentNode.FilterValue3;
        }
        $v_0 = parentNode.FilterValue4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3h_1 = $v_0;
            delete parentNode.FilterValue4;
        }
        $v_0 = parentNode.FilterValue5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3i_1 = $v_0;
            delete parentNode.FilterValue5;
        }
        $v_0 = parentNode.FilterValue6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3j_1 = $v_0;
            delete parentNode.FilterValue6;
        }
        $v_0 = parentNode.FilterValue7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3k_1 = $v_0;
            delete parentNode.FilterValue7;
        }
        $v_0 = parentNode.FilterValue8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3l_1 = $v_0;
            delete parentNode.FilterValue8;
        }
        $v_0 = parentNode.FilterValue9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3m_1 = $v_0;
            delete parentNode.FilterValue9;
        }
        $v_0 = parentNode.FilterValues;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3n_1 = $v_0;
            delete parentNode.FilterValues;
        }
        $v_0 = parentNode.FilterValues1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3o_1 = $v_0;
            delete parentNode.FilterValues1;
        }
        $v_0 = parentNode.FilterValues10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3p_1 = $v_0;
            delete parentNode.FilterValues10;
        }
        $v_0 = parentNode.FilterValues2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3q_1 = $v_0;
            delete parentNode.FilterValues2;
        }
        $v_0 = parentNode.FilterValues3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3r_1 = $v_0;
            delete parentNode.FilterValues3;
        }
        $v_0 = parentNode.FilterValues4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3s_1 = $v_0;
            delete parentNode.FilterValues4;
        }
        $v_0 = parentNode.FilterValues5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3t_1 = $v_0;
            delete parentNode.FilterValues5;
        }
        $v_0 = parentNode.FilterValues6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3u_1 = $v_0;
            delete parentNode.FilterValues6;
        }
        $v_0 = parentNode.FilterValues7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3v_1 = $v_0;
            delete parentNode.FilterValues7;
        }
        $v_0 = parentNode.FilterValues8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3w_1 = $v_0;
            delete parentNode.FilterValues8;
        }
        $v_0 = parentNode.FilterValues9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3x_1 = $v_0;
            delete parentNode.FilterValues9;
        }
        $v_0 = parentNode.GroupString;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$42_1 = $v_0;
            delete parentNode.GroupString;
        }
        $v_0 = parentNode.HasOverrideSelectCommand;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$44_1 = $v_0;
            delete parentNode.HasOverrideSelectCommand;
        }
        $v_0 = parentNode.ID;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$I_1 = $v_0;
            delete parentNode.ID;
        }
        $v_0 = parentNode.InplaceFullListSearch;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$e_1 = $v_0;
            delete parentNode.InplaceFullListSearch;
        }
        $v_0 = parentNode.InplaceSearchQuery;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$f_1 = $v_0;
            delete parentNode.InplaceSearchQuery;
        }
        $v_0 = parentNode.IsCSR;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$g_1 = $v_0;
            delete parentNode.IsCSR;
        }
        $v_0 = parentNode.IsGroupRender;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4A_1 = $v_0;
            delete parentNode.IsGroupRender;
        }
        $v_0 = parentNode.IsXslView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$h_1 = $v_0;
            delete parentNode.IsXslView;
        }
        $v_0 = parentNode.ListViewPageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$j_1 = $v_0;
            delete parentNode.ListViewPageUrl;
        }
        $v_0 = parentNode.OverrideScope;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$J_1 = $v_0;
            delete parentNode.OverrideScope;
        }
        $v_0 = parentNode.OverrideSelectCommand;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4P_1 = $v_0;
            delete parentNode.OverrideSelectCommand;
        }
        $v_0 = parentNode.PageFirstRow;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4R_1 = $v_0;
            delete parentNode.PageFirstRow;
        }
        $v_0 = parentNode.PageLastRow;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4S_1 = $v_0;
            delete parentNode.PageLastRow;
        }
        $v_0 = parentNode.RootFolder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$n_1 = $v_0;
            delete parentNode.RootFolder;
        }
        $v_0 = parentNode.SortDir;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4n_1 = $v_0;
            delete parentNode.SortDir;
        }
        $v_0 = parentNode.SortDir1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4o_1 = $v_0;
            delete parentNode.SortDir1;
        }
        $v_0 = parentNode.SortDir10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4p_1 = $v_0;
            delete parentNode.SortDir10;
        }
        $v_0 = parentNode.SortDir2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4q_1 = $v_0;
            delete parentNode.SortDir2;
        }
        $v_0 = parentNode.SortDir3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4r_1 = $v_0;
            delete parentNode.SortDir3;
        }
        $v_0 = parentNode.SortDir4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4s_1 = $v_0;
            delete parentNode.SortDir4;
        }
        $v_0 = parentNode.SortDir5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4t_1 = $v_0;
            delete parentNode.SortDir5;
        }
        $v_0 = parentNode.SortDir6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4u_1 = $v_0;
            delete parentNode.SortDir6;
        }
        $v_0 = parentNode.SortDir7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4v_1 = $v_0;
            delete parentNode.SortDir7;
        }
        $v_0 = parentNode.SortDir8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4w_1 = $v_0;
            delete parentNode.SortDir8;
        }
        $v_0 = parentNode.SortDir9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4x_1 = $v_0;
            delete parentNode.SortDir9;
        }
        $v_0 = parentNode.SortField;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4y_1 = $v_0;
            delete parentNode.SortField;
        }
        $v_0 = parentNode.SortField1;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4z_1 = $v_0;
            delete parentNode.SortField1;
        }
        $v_0 = parentNode.SortField10;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$50_1 = $v_0;
            delete parentNode.SortField10;
        }
        $v_0 = parentNode.SortField2;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$51_1 = $v_0;
            delete parentNode.SortField2;
        }
        $v_0 = parentNode.SortField3;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$52_1 = $v_0;
            delete parentNode.SortField3;
        }
        $v_0 = parentNode.SortField4;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$53_1 = $v_0;
            delete parentNode.SortField4;
        }
        $v_0 = parentNode.SortField5;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$54_1 = $v_0;
            delete parentNode.SortField5;
        }
        $v_0 = parentNode.SortField6;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$55_1 = $v_0;
            delete parentNode.SortField6;
        }
        $v_0 = parentNode.SortField7;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$56_1 = $v_0;
            delete parentNode.SortField7;
        }
        $v_0 = parentNode.SortField8;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$57_1 = $v_0;
            delete parentNode.SortField8;
        }
        $v_0 = parentNode.SortField9;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$58_1 = $v_0;
            delete parentNode.SortField9;
        }
        $v_0 = parentNode.SortFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$59_1 = $v_0;
            delete parentNode.SortFields;
        }
        $v_0 = parentNode.SortFieldValues;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5A_1 = $v_0;
            delete parentNode.SortFieldValues;
        }
        $v_0 = parentNode.View;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$E_1 = $v_0;
            delete parentNode.View;
        }
        $v_0 = parentNode.ViewCount;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$r_1 = $v_0;
            delete parentNode.ViewCount;
        }
        $v_0 = parentNode.ViewId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6_1 = $v_0;
            delete parentNode.ViewId;
        }
        $v_0 = parentNode.WebPartId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5U_1 = $v_0;
            delete parentNode.WebPartId;
        }
    }
};
SP.RenderListDataParameters = function SP_RenderListDataParameters() {
    SP.RenderListDataParameters.initializeBase(this);
};
SP.RenderListDataParameters.prototype = {
    $T_1: false,
    $3y_1: false,
    $c_1: null,
    $4Q_1: null,
    $4T_1: null,
    $4h_1: 0,
    $S_1: null,
    get_datesInUtc: function SP_RenderListDataParameters$get_datesInUtc() {
        return this.$T_1;
    },
    set_datesInUtc: function SP_RenderListDataParameters$set_datesInUtc(value) {
        this.$T_1 = value;
        return value;
    },
    get_firstGroupOnly: function SP_RenderListDataParameters$get_firstGroupOnly() {
        return this.$3y_1;
    },
    set_firstGroupOnly: function SP_RenderListDataParameters$set_firstGroupOnly(value) {
        this.$3y_1 = value;
        return value;
    },
    get_folderServerRelativeUrl: function SP_RenderListDataParameters$get_folderServerRelativeUrl() {
        return this.$c_1;
    },
    set_folderServerRelativeUrl: function SP_RenderListDataParameters$set_folderServerRelativeUrl(value) {
        this.$c_1 = value;
        return value;
    },
    get_overrideViewXml: function SP_RenderListDataParameters$get_overrideViewXml() {
        return this.$4Q_1;
    },
    set_overrideViewXml: function SP_RenderListDataParameters$set_overrideViewXml(value) {
        this.$4Q_1 = value;
        return value;
    },
    get_paging: function SP_RenderListDataParameters$get_paging() {
        return this.$4T_1;
    },
    set_paging: function SP_RenderListDataParameters$set_paging(value) {
        this.$4T_1 = value;
        return value;
    },
    get_renderOptions: function SP_RenderListDataParameters$get_renderOptions() {
        return this.$4h_1;
    },
    set_renderOptions: function SP_RenderListDataParameters$set_renderOptions(value) {
        this.$4h_1 = value;
        return value;
    },
    get_viewXml: function SP_RenderListDataParameters$get_viewXml() {
        return this.$S_1;
    },
    set_viewXml: function SP_RenderListDataParameters$set_viewXml(value) {
        this.$S_1 = value;
        return value;
    },
    get_typeId: function SP_RenderListDataParameters$get_typeId() {
        return '{ae2d69b3-12fa-4ecb-ba76-bba24d51e83d}';
    },
    writeToXml: function SP_RenderListDataParameters$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['DatesInUtc', 'FirstGroupOnly', 'FolderServerRelativeUrl', 'OverrideViewXml', 'Paging', 'RenderOptions', 'ViewXml'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_RenderListDataParameters$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.DatesInUtc;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$T_1 = $v_0;
            delete parentNode.DatesInUtc;
        }
        $v_0 = parentNode.FirstGroupOnly;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$3y_1 = $v_0;
            delete parentNode.FirstGroupOnly;
        }
        $v_0 = parentNode.FolderServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$c_1 = $v_0;
            delete parentNode.FolderServerRelativeUrl;
        }
        $v_0 = parentNode.OverrideViewXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4Q_1 = $v_0;
            delete parentNode.OverrideViewXml;
        }
        $v_0 = parentNode.Paging;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4T_1 = $v_0;
            delete parentNode.Paging;
        }
        $v_0 = parentNode.RenderOptions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4h_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.RenderOptions;
        }
        $v_0 = parentNode.ViewXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$S_1 = $v_0;
            delete parentNode.ViewXml;
        }
    }
};
SP.RenderListFilterDataParameters = function SP_RenderListFilterDataParameters() {
    SP.RenderListFilterDataParameters.initializeBase(this);
};
SP.RenderListFilterDataParameters.prototype = {
    $b_1: null,
    $J_1: null,
    $4X_1: null,
    $6_1: null,
    get_fieldInternalName: function SP_RenderListFilterDataParameters$get_fieldInternalName() {
        return this.$b_1;
    },
    set_fieldInternalName: function SP_RenderListFilterDataParameters$set_fieldInternalName(value) {
        this.$b_1 = value;
        return value;
    },
    get_overrideScope: function SP_RenderListFilterDataParameters$get_overrideScope() {
        return this.$J_1;
    },
    set_overrideScope: function SP_RenderListFilterDataParameters$set_overrideScope(value) {
        this.$J_1 = value;
        return value;
    },
    get_processQStringToCAML: function SP_RenderListFilterDataParameters$get_processQStringToCAML() {
        return this.$4X_1;
    },
    set_processQStringToCAML: function SP_RenderListFilterDataParameters$set_processQStringToCAML(value) {
        this.$4X_1 = value;
        return value;
    },
    get_viewId: function SP_RenderListFilterDataParameters$get_viewId() {
        return this.$6_1;
    },
    set_viewId: function SP_RenderListFilterDataParameters$set_viewId(value) {
        this.$6_1 = value;
        return value;
    },
    get_typeId: function SP_RenderListFilterDataParameters$get_typeId() {
        return '{5932e072-c4e0-4809-b1c9-88077c4df471}';
    },
    writeToXml: function SP_RenderListFilterDataParameters$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['FieldInternalName', 'OverrideScope', 'ProcessQStringToCAML', 'ViewId'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_RenderListFilterDataParameters$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FieldInternalName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$b_1 = $v_0;
            delete parentNode.FieldInternalName;
        }
        $v_0 = parentNode.OverrideScope;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$J_1 = $v_0;
            delete parentNode.OverrideScope;
        }
        $v_0 = parentNode.ProcessQStringToCAML;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4X_1 = $v_0;
            delete parentNode.ProcessQStringToCAML;
        }
        $v_0 = parentNode.ViewId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6_1 = $v_0;
            delete parentNode.ViewId;
        }
    }
};
SP.RequestContext = function SP_RequestContext($p0, $p1) {
    SP.RequestContext.initializeBase(this, [$p0, $p1]);
};
SP.RequestContext.getCurrent = function SP_RequestContext$getCurrent($p0) {
    var $v_0 = ($p0.get_staticObjects())['Microsoft$SharePoint$SPContext$Current'];

    if (!$v_0) {
        $v_0 = new SP.RequestContext($p0, new SP.ObjectPathStaticProperty($p0, '{3747adcd-a3c3-41b9-bfab-4a64dd2f1e0a}', 'Current'));
        ($p0.get_staticObjects())['Microsoft$SharePoint$SPContext$Current'] = $v_0;
    }
    return $v_0;
};
SP.RequestContext.prototype = {
    get_list: function SP_RequestContext$get_list() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['List'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.List(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'List'));
            ((this.get_objectData()).get_clientObjectProperties())['List'] = $v_0;
        }
        return $v_0;
    },
    get_site: function SP_RequestContext$get_site() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Site'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Site(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Site'));
            ((this.get_objectData()).get_clientObjectProperties())['Site'] = $v_0;
        }
        return $v_0;
    },
    get_web: function SP_RequestContext$get_web() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Web'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Web(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Web'));
            ((this.get_objectData()).get_clientObjectProperties())['Web'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_RequestContext$initPropertiesFromJson($p0) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, $p0);
        var $v_0;

        $v_0 = $p0.List;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('List', this.get_list(), $v_0);
            (this.get_list()).fromJson($v_0);
            delete $p0.List;
        }
        $v_0 = $p0.Site;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Site', this.get_site(), $v_0);
            (this.get_site()).fromJson($v_0);
            delete $p0.Site;
        }
        $v_0 = $p0.Web;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Web', this.get_web(), $v_0);
            (this.get_web()).fromJson($v_0);
            delete $p0.Web;
        }
    },
    getRemoteContext: function SP_RequestContext$getRemoteContext() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.RequestContext($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetRemoteContext', null));
        return $v_1;
    }
};
SP.RequestContextObjectPropertyNames = function SP_RequestContextObjectPropertyNames() {
};
SP.RequestUserContext = function SP_RequestUserContext(context, objectPath) {
    SP.RequestUserContext.initializeBase(this, [context, objectPath]);
};
SP.RequestUserContext.getCurrent = function SP_RequestUserContext$getCurrent(Context) {
    var $v_0 = (Context.get_staticObjects())['Microsoft$SharePoint$SPRequestUserContext$Current'];

    if (!$v_0) {
        $v_0 = new SP.RequestUserContext(Context, new SP.ObjectPathStaticProperty(Context, '{56e4c4bc-9c90-400c-8efd-940e74794e3a}', 'Current'));
        (Context.get_staticObjects())['Microsoft$SharePoint$SPRequestUserContext$Current'] = $v_0;
    }
    return $v_0;
};
SP.RequestUserContext.prototype = {
    get_user: function SP_RequestUserContext$get_user() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['User'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'User'));
            ((this.get_objectData()).get_clientObjectProperties())['User'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_RequestUserContext$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.User;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('User', this.get_user(), $v_0);
            (this.get_user()).fromJson($v_0);
            delete parentNode.User;
        }
    }
};
SP.RequestUserContextObjectPropertyNames = function SP_RequestUserContextObjectPropertyNames() {
};
SP.RequestVariable = function SP_RequestVariable(context) {
    SP.RequestVariable.initializeBase(this, [context, SP.ClientUtility.getOrCreateObjectPathForConstructor(context, '{5806d374-4904-49e9-a73f-3265ee2e06c6}', arguments)]);
};
SP.RequestVariable.newObject = function SP_RequestVariable$newObject(context) {
    return new SP.RequestVariable(context, new SP.ObjectPathConstructor(context, '{5806d374-4904-49e9-a73f-3265ee2e06c6}', null));
};
SP.RequestVariable.prototype = {
    get_value: function SP_RequestVariable$get_value() {
        this.checkUninitializedProperty('Value');
        return ((this.get_objectData()).get_properties())['Value'];
    },
    initPropertiesFromJson: function SP_RequestVariable$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Value;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Value'] = $v_0;
            delete parentNode.Value;
        }
    },
    append: function SP_RequestVariable$append(value) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Append', [value]);

        $v_0.addQuery($v_1);
    },
    set: function SP_RequestVariable$set(value) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Set', [value]);

        $v_0.addQuery($v_1);
    }
};
SP.RequestVariablePropertyNames = function SP_RequestVariablePropertyNames() {
};
SP.RoleAssignment = function SP_RoleAssignment(context, objectPath) {
    SP.RoleAssignment.initializeBase(this, [context, objectPath]);
};
SP.RoleAssignment.prototype = {
    get_member: function SP_RoleAssignment$get_member() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Member'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Principal(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Member'));
            ((this.get_objectData()).get_clientObjectProperties())['Member'] = $v_0;
        }
        return $v_0;
    },
    get_principalId: function SP_RoleAssignment$get_principalId() {
        this.checkUninitializedProperty('PrincipalId');
        return ((this.get_objectData()).get_properties())['PrincipalId'];
    },
    get_roleDefinitionBindings: function SP_RoleAssignment$get_roleDefinitionBindings() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RoleDefinitionBindings'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.RoleDefinitionBindingCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RoleDefinitionBindings'));
            ((this.get_objectData()).get_clientObjectProperties())['RoleDefinitionBindings'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_RoleAssignment$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Member;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Member', this.get_member(), $v_0);
            (this.get_member()).fromJson($v_0);
            delete parentNode.Member;
        }
        $v_0 = parentNode.PrincipalId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PrincipalId'] = $v_0;
            delete parentNode.PrincipalId;
        }
        $v_0 = parentNode.RoleDefinitionBindings;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RoleDefinitionBindings', this.get_roleDefinitionBindings(), $v_0);
            (this.get_roleDefinitionBindings()).fromJson($v_0);
            delete parentNode.RoleDefinitionBindings;
        }
    },
    importRoleDefinitionBindings: function SP_RoleAssignment$importRoleDefinitionBindings(roleDefinitionBindings) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'ImportRoleDefinitionBindings', [roleDefinitionBindings]);

        $v_0.addQuery($v_1);
    },
    update: function SP_RoleAssignment$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    },
    deleteObject: function SP_RoleAssignment$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.RoleAssignmentPropertyNames = function SP_RoleAssignmentPropertyNames() {
};
SP.RoleAssignmentObjectPropertyNames = function SP_RoleAssignmentObjectPropertyNames() {
};
SP.RoleAssignmentCollection = function SP_RoleAssignmentCollection(context, objectPath) {
    SP.RoleAssignmentCollection.initializeBase(this, [context, objectPath]);
};
SP.RoleAssignmentCollection.prototype = {
    itemAt: function SP_RoleAssignmentCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_RoleAssignmentCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_RoleAssignmentCollection$get_childItemType() {
        return SP.RoleAssignment;
    },
    get_groups: function SP_RoleAssignmentCollection$get_groups() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Groups'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.GroupCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Groups'));
            ((this.get_objectData()).get_clientObjectProperties())['Groups'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_RoleAssignmentCollection$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Groups;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Groups', this.get_groups(), $v_0);
            (this.get_groups()).fromJson($v_0);
            delete parentNode.Groups;
        }
    },
    getByPrincipal: function SP_RoleAssignmentCollection$getByPrincipal(principalToFind) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.RoleAssignment($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByPrincipal', [principalToFind]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        return $v_1;
    },
    getByPrincipalId: function SP_RoleAssignmentCollection$getByPrincipalId(principalId) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByPrincipalId'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetByPrincipalId'] = $v_2;
        }
        $v_1 = $v_2[principalId];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.RoleAssignment($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByPrincipalId', [principalId]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[principalId] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    add: function SP_RoleAssignmentCollection$add(principal, roleBindings) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.RoleAssignment($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [principal, roleBindings]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    }
};
SP.RoleAssignmentCollectionObjectPropertyNames = function SP_RoleAssignmentCollectionObjectPropertyNames() {
};
SP.RoleDefinition = function SP_RoleDefinition(context, objectPath) {
    SP.RoleDefinition.initializeBase(this, [context, objectPath]);
};
SP.RoleDefinition.prototype = {
    $F_1: function SP_RoleDefinition$$F_1($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Description'] = $p0.$2_1;
            ((this.get_objectData()).get_properties())['Name'] = $p0.$4_1;
            ((this.get_objectData()).get_properties())['Order'] = $p0.$1W_1;
            ((this.get_objectData()).get_properties())['BasePermissions'] = $p0.$1J_1;
        }
    },
    get_basePermissions: function SP_RoleDefinition$get_basePermissions() {
        this.checkUninitializedProperty('BasePermissions');
        return ((this.get_objectData()).get_properties())['BasePermissions'];
    },
    set_basePermissions: function SP_RoleDefinition$set_basePermissions(value) {
        ((this.get_objectData()).get_properties())['BasePermissions'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'BasePermissions', value));
        }
        return value;
    },
    get_description: function SP_RoleDefinition$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    set_description: function SP_RoleDefinition$set_description(value) {
        ((this.get_objectData()).get_properties())['Description'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Description', value));
        }
        return value;
    },
    get_hidden: function SP_RoleDefinition$get_hidden() {
        this.checkUninitializedProperty('Hidden');
        return ((this.get_objectData()).get_properties())['Hidden'];
    },
    get_id: function SP_RoleDefinition$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_name: function SP_RoleDefinition$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    set_name: function SP_RoleDefinition$set_name(value) {
        ((this.get_objectData()).get_properties())['Name'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Name', value));
        }
        return value;
    },
    get_order: function SP_RoleDefinition$get_order() {
        this.checkUninitializedProperty('Order');
        return ((this.get_objectData()).get_properties())['Order'];
    },
    set_order: function SP_RoleDefinition$set_order(value) {
        ((this.get_objectData()).get_properties())['Order'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Order', value));
        }
        return value;
    },
    get_roleTypeKind: function SP_RoleDefinition$get_roleTypeKind() {
        this.checkUninitializedProperty('RoleTypeKind');
        return ((this.get_objectData()).get_properties())['RoleTypeKind'];
    },
    initPropertiesFromJson: function SP_RoleDefinition$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.BasePermissions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['BasePermissions'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.BasePermissions;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Hidden;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Hidden'] = $v_0;
            delete parentNode.Hidden;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.Order;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Order'] = $v_0;
            delete parentNode.Order;
        }
        $v_0 = parentNode.RoleTypeKind;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RoleTypeKind'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.RoleTypeKind;
        }
    },
    update: function SP_RoleDefinition$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    },
    deleteObject: function SP_RoleDefinition$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.RoleDefinitionPropertyNames = function SP_RoleDefinitionPropertyNames() {
};
SP.RoleDefinitionBindingCollection = function SP_RoleDefinitionBindingCollection(context) {
    SP.RoleDefinitionBindingCollection.initializeBase(this, [context, SP.ClientUtility.getOrCreateObjectPathForConstructor(context, '{07bf1941-6953-4761-b114-58374b4aaf57}', arguments)]);
};
SP.RoleDefinitionBindingCollection.newObject = function SP_RoleDefinitionBindingCollection$newObject(context) {
    return new SP.RoleDefinitionBindingCollection(context, new SP.ObjectPathConstructor(context, '{07bf1941-6953-4761-b114-58374b4aaf57}', null));
};
SP.RoleDefinitionBindingCollection.prototype = {
    itemAt: function SP_RoleDefinitionBindingCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_RoleDefinitionBindingCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_RoleDefinitionBindingCollection$get_childItemType() {
        return SP.RoleDefinition;
    },
    $7L_2: function SP_RoleDefinitionBindingCollection$$7L_2() {
        var $v_0 = this.get_data();

        while ($v_0.length > 0) {
            Array.removeAt($v_0, $v_0.length - 1);
        }
    },
    add: function SP_RoleDefinitionBindingCollection$add(roleDefinition) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Add', [roleDefinition]);

        $v_0.addQuery($v_1);
        this.addChild(roleDefinition);
    },
    remove: function SP_RoleDefinitionBindingCollection$remove(roleDefinition) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Remove', [roleDefinition]);

        $v_0.addQuery($v_1);
        this.removeChild(roleDefinition);
    },
    removeAll: function SP_RoleDefinitionBindingCollection$removeAll() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RemoveAll', null);

        $v_0.addQuery($v_1);
        this.$7L_2();
    }
};
SP.RoleDefinitionCollection = function SP_RoleDefinitionCollection(context, objectPath) {
    SP.RoleDefinitionCollection.initializeBase(this, [context, objectPath]);
};
SP.RoleDefinitionCollection.prototype = {
    itemAt: function SP_RoleDefinitionCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_RoleDefinitionCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_RoleDefinitionCollection$get_childItemType() {
        return SP.RoleDefinition;
    },
    getByName: function SP_RoleDefinitionCollection$getByName(name) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByName'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByName'] = $v_2;
        }
        $v_1 = $v_2[name];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.RoleDefinition($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByName', [name]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[name] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    add: function SP_RoleDefinitionCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.RoleDefinition($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_1(parameters);
        return $v_1;
    },
    recreateMissingDefaultRoleDefinitions: function SP_RoleDefinitionCollection$recreateMissingDefaultRoleDefinitions() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RecreateMissingDefaultRoleDefinitions', null);

        $v_0.addQuery($v_1);
    },
    getById: function SP_RoleDefinitionCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.RoleDefinition($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    getByType: function SP_RoleDefinitionCollection$getByType(roleType) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByType'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetByType'] = $v_2;
        }
        $v_1 = $v_2[roleType];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.RoleDefinition($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByType', [roleType]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[roleType] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    }
};
SP.RoleDefinitionCreationInformation = function SP_RoleDefinitionCreationInformation() {
    SP.RoleDefinitionCreationInformation.initializeBase(this);
};
SP.RoleDefinitionCreationInformation.prototype = {
    $1J_1: null,
    $2_1: null,
    $4_1: null,
    $1W_1: 0,
    get_basePermissions: function SP_RoleDefinitionCreationInformation$get_basePermissions() {
        return this.$1J_1;
    },
    set_basePermissions: function SP_RoleDefinitionCreationInformation$set_basePermissions(value) {
        this.$1J_1 = value;
        return value;
    },
    get_description: function SP_RoleDefinitionCreationInformation$get_description() {
        return this.$2_1;
    },
    set_description: function SP_RoleDefinitionCreationInformation$set_description(value) {
        this.$2_1 = value;
        return value;
    },
    get_name: function SP_RoleDefinitionCreationInformation$get_name() {
        return this.$4_1;
    },
    set_name: function SP_RoleDefinitionCreationInformation$set_name(value) {
        this.$4_1 = value;
        return value;
    },
    get_order: function SP_RoleDefinitionCreationInformation$get_order() {
        return this.$1W_1;
    },
    set_order: function SP_RoleDefinitionCreationInformation$set_order(value) {
        this.$1W_1 = value;
        return value;
    },
    get_typeId: function SP_RoleDefinitionCreationInformation$get_typeId() {
        return '{59eddf82-1018-4677-8067-69e16efd3495}';
    },
    writeToXml: function SP_RoleDefinitionCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['BasePermissions', 'Description', 'Name', 'Order'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_RoleDefinitionCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.BasePermissions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1J_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.BasePermissions;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2_1 = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4_1 = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.Order;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1W_1 = $v_0;
            delete parentNode.Order;
        }
    }
};
SP.SecurableObject = function SP_SecurableObject(context, objectPath) {
    SP.SecurableObject.initializeBase(this, [context, objectPath]);
};
SP.SecurableObject.prototype = {
    get_firstUniqueAncestorSecurableObject: function SP_SecurableObject$get_firstUniqueAncestorSecurableObject() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['FirstUniqueAncestorSecurableObject'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.SecurableObject(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'FirstUniqueAncestorSecurableObject'));
            ((this.get_objectData()).get_clientObjectProperties())['FirstUniqueAncestorSecurableObject'] = $v_0;
        }
        return $v_0;
    },
    get_hasUniqueRoleAssignments: function SP_SecurableObject$get_hasUniqueRoleAssignments() {
        this.checkUninitializedProperty('HasUniqueRoleAssignments');
        return ((this.get_objectData()).get_properties())['HasUniqueRoleAssignments'];
    },
    get_roleAssignments: function SP_SecurableObject$get_roleAssignments() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RoleAssignments'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.RoleAssignmentCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RoleAssignments'));
            ((this.get_objectData()).get_clientObjectProperties())['RoleAssignments'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_SecurableObject$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.FirstUniqueAncestorSecurableObject;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('FirstUniqueAncestorSecurableObject', this.get_firstUniqueAncestorSecurableObject(), $v_0);
            (this.get_firstUniqueAncestorSecurableObject()).fromJson($v_0);
            delete parentNode.FirstUniqueAncestorSecurableObject;
        }
        $v_0 = parentNode.HasUniqueRoleAssignments;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HasUniqueRoleAssignments'] = $v_0;
            delete parentNode.HasUniqueRoleAssignments;
        }
        $v_0 = parentNode.RoleAssignments;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RoleAssignments', this.get_roleAssignments(), $v_0);
            (this.get_roleAssignments()).fromJson($v_0);
            delete parentNode.RoleAssignments;
        }
    },
    resetRoleInheritance: function SP_SecurableObject$resetRoleInheritance() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'ResetRoleInheritance', null);

        $v_0.addQuery($v_1);
    },
    breakRoleInheritance: function SP_SecurableObject$breakRoleInheritance(copyRoleAssignments, clearSubscopes) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'BreakRoleInheritance', [copyRoleAssignments, clearSubscopes]);

        $v_0.addQuery($v_1);
    }
};
SP.SecurableObjectPropertyNames = function SP_SecurableObjectPropertyNames() {
};
SP.SecurableObjectObjectPropertyNames = function SP_SecurableObjectObjectPropertyNames() {
};
SP.ServerSettings = function SP_ServerSettings() {
};
SP.ServerSettings.getAlternateUrls = function SP_ServerSettings$getAlternateUrls(context) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ClientObjectList(context, new SP.ObjectPathStaticMethod(context, '{adfa7b3e-a27c-4288-9b6c-a8ea51bf082d}', 'GetAlternateUrls', null), SP.AlternateUrl);
    return $v_0;
};
SP.ServerSettings.getGlobalInstalledLanguages = function SP_ServerSettings$getGlobalInstalledLanguages(context, compatibilityLevel) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{adfa7b3e-a27c-4288-9b6c-a8ea51bf082d}', 'GetGlobalInstalledLanguages', [compatibilityLevel]);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.ServerSettings.isSharePointOnline = function SP_ServerSettings$isSharePointOnline(context) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{adfa7b3e-a27c-4288-9b6c-a8ea51bf082d}', 'IsSharePointOnline', null);

    context.addQuery($v_1);
    $v_0 = new SP.BooleanResult();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.SharedWithUser = function SP_SharedWithUser() {
    SP.SharedWithUser.initializeBase(this);
};
SP.SharedWithUser.prototype = {
    $5_1: null,
    $4_1: null,
    get_email: function SP_SharedWithUser$get_email() {
        return this.$5_1;
    },
    get_name: function SP_SharedWithUser$get_name() {
        return this.$4_1;
    },
    get_typeId: function SP_SharedWithUser$get_typeId() {
        return '{01d693d9-72c2-4531-9fb9-105c88b6706b}';
    },
    writeToXml: function SP_SharedWithUser$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Email', 'Name'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_SharedWithUser$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Email;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5_1 = $v_0;
            delete parentNode.Email;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4_1 = $v_0;
            delete parentNode.Name;
        }
    }
};
SP.SharedWithUserCollection = function SP_SharedWithUserCollection() {
    SP.SharedWithUserCollection.initializeBase(this);
};
SP.SharedWithUserCollection.prototype = {
    add: function SP_SharedWithUserCollection$add(item) {
        this.addChild(item);
    },
    get_item: function SP_SharedWithUserCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_typeId: function SP_SharedWithUserCollection$get_typeId() {
        return '{c60fa59c-1de9-4b4f-a6ed-2b4b625ff300}';
    },
    writeToXml: function SP_SharedWithUserCollection$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        SP.ClientValueObjectCollection.prototype.writeToXml.call(this, writer, serializationContext);
    }
};
SP.SharePointSharingSettings = function SP_SharePointSharingSettings(context, objectPath) {
    SP.SharePointSharingSettings.initializeBase(this, [context, objectPath]);
};
SP.SharePointSharingSettings.prototype = {
    get_addToGroupModeName: function SP_SharePointSharingSettings$get_addToGroupModeName() {
        this.checkUninitializedProperty('AddToGroupModeName');
        return ((this.get_objectData()).get_properties())['AddToGroupModeName'];
    },
    get_groupNameLines: function SP_SharePointSharingSettings$get_groupNameLines() {
        this.checkUninitializedProperty('GroupNameLines');
        return ((this.get_objectData()).get_properties())['GroupNameLines'];
    },
    get_groupRoleDefinitionNamesLines: function SP_SharePointSharingSettings$get_groupRoleDefinitionNamesLines() {
        this.checkUninitializedProperty('GroupRoleDefinitionNamesLines');
        return ((this.get_objectData()).get_properties())['GroupRoleDefinitionNamesLines'];
    },
    get_isMobileView: function SP_SharePointSharingSettings$get_isMobileView() {
        this.checkUninitializedProperty('IsMobileView');
        return ((this.get_objectData()).get_properties())['IsMobileView'];
    },
    get_panelGivePermissionsVisible: function SP_SharePointSharingSettings$get_panelGivePermissionsVisible() {
        this.checkUninitializedProperty('PanelGivePermissionsVisible');
        return ((this.get_objectData()).get_properties())['PanelGivePermissionsVisible'];
    },
    get_panelShowHideMoreOptionsVisible: function SP_SharePointSharingSettings$get_panelShowHideMoreOptionsVisible() {
        this.checkUninitializedProperty('PanelShowHideMoreOptionsVisible');
        return ((this.get_objectData()).get_properties())['PanelShowHideMoreOptionsVisible'];
    },
    get_panelSimplifiedRoleSelectorVisible: function SP_SharePointSharingSettings$get_panelSimplifiedRoleSelectorVisible() {
        this.checkUninitializedProperty('PanelSimplifiedRoleSelectorVisible');
        return ((this.get_objectData()).get_properties())['PanelSimplifiedRoleSelectorVisible'];
    },
    get_pickerProperties: function SP_SharePointSharingSettings$get_pickerProperties() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['PickerProperties'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.PickerSettings(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'PickerProperties'));
            ((this.get_objectData()).get_clientObjectProperties())['PickerProperties'] = $v_0;
        }
        return $v_0;
    },
    get_requiredScriptFileLinks: function SP_SharePointSharingSettings$get_requiredScriptFileLinks() {
        this.checkUninitializedProperty('RequiredScriptFileLinks');
        return ((this.get_objectData()).get_properties())['RequiredScriptFileLinks'];
    },
    get_roleDefinitionNameLines: function SP_SharePointSharingSettings$get_roleDefinitionNameLines() {
        this.checkUninitializedProperty('RoleDefinitionNameLines');
        return ((this.get_objectData()).get_properties())['RoleDefinitionNameLines'];
    },
    get_selectedGroup: function SP_SharePointSharingSettings$get_selectedGroup() {
        this.checkUninitializedProperty('SelectedGroup');
        return ((this.get_objectData()).get_properties())['SelectedGroup'];
    },
    get_sharedWithEnabled: function SP_SharePointSharingSettings$get_sharedWithEnabled() {
        this.checkUninitializedProperty('SharedWithEnabled');
        return ((this.get_objectData()).get_properties())['SharedWithEnabled'];
    },
    get_sharingCssLink: function SP_SharePointSharingSettings$get_sharingCssLink() {
        this.checkUninitializedProperty('SharingCssLink');
        return ((this.get_objectData()).get_properties())['SharingCssLink'];
    },
    get_tabbedDialogEnabled: function SP_SharePointSharingSettings$get_tabbedDialogEnabled() {
        this.checkUninitializedProperty('TabbedDialogEnabled');
        return ((this.get_objectData()).get_properties())['TabbedDialogEnabled'];
    },
    get_tabToShow: function SP_SharePointSharingSettings$get_tabToShow() {
        this.checkUninitializedProperty('TabToShow');
        return ((this.get_objectData()).get_properties())['TabToShow'];
    },
    get_txtEmailSubjectText: function SP_SharePointSharingSettings$get_txtEmailSubjectText() {
        this.checkUninitializedProperty('txtEmailSubjectText');
        return ((this.get_objectData()).get_properties())['txtEmailSubjectText'];
    },
    get_userDisplayUrl: function SP_SharePointSharingSettings$get_userDisplayUrl() {
        this.checkUninitializedProperty('UserDisplayUrl');
        return ((this.get_objectData()).get_properties())['UserDisplayUrl'];
    },
    initPropertiesFromJson: function SP_SharePointSharingSettings$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AddToGroupModeName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AddToGroupModeName'] = $v_0;
            delete parentNode.AddToGroupModeName;
        }
        $v_0 = parentNode.GroupNameLines;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GroupNameLines'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.GroupNameLines;
        }
        $v_0 = parentNode.GroupRoleDefinitionNamesLines;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['GroupRoleDefinitionNamesLines'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.GroupRoleDefinitionNamesLines;
        }
        $v_0 = parentNode.IsMobileView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsMobileView'] = $v_0;
            delete parentNode.IsMobileView;
        }
        $v_0 = parentNode.PanelGivePermissionsVisible;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PanelGivePermissionsVisible'] = $v_0;
            delete parentNode.PanelGivePermissionsVisible;
        }
        $v_0 = parentNode.PanelShowHideMoreOptionsVisible;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PanelShowHideMoreOptionsVisible'] = $v_0;
            delete parentNode.PanelShowHideMoreOptionsVisible;
        }
        $v_0 = parentNode.PanelSimplifiedRoleSelectorVisible;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PanelSimplifiedRoleSelectorVisible'] = $v_0;
            delete parentNode.PanelSimplifiedRoleSelectorVisible;
        }
        $v_0 = parentNode.PickerProperties;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('PickerProperties', this.get_pickerProperties(), $v_0);
            (this.get_pickerProperties()).fromJson($v_0);
            delete parentNode.PickerProperties;
        }
        $v_0 = parentNode.RequiredScriptFileLinks;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RequiredScriptFileLinks'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.RequiredScriptFileLinks;
        }
        $v_0 = parentNode.RoleDefinitionNameLines;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RoleDefinitionNameLines'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.RoleDefinitionNameLines;
        }
        $v_0 = parentNode.SelectedGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SelectedGroup'] = $v_0;
            delete parentNode.SelectedGroup;
        }
        $v_0 = parentNode.SharedWithEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SharedWithEnabled'] = $v_0;
            delete parentNode.SharedWithEnabled;
        }
        $v_0 = parentNode.SharingCssLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SharingCssLink'] = $v_0;
            delete parentNode.SharingCssLink;
        }
        $v_0 = parentNode.TabbedDialogEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TabbedDialogEnabled'] = $v_0;
            delete parentNode.TabbedDialogEnabled;
        }
        $v_0 = parentNode.TabToShow;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TabToShow'] = $v_0;
            delete parentNode.TabToShow;
        }
        $v_0 = parentNode.txtEmailSubjectText;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['txtEmailSubjectText'] = $v_0;
            delete parentNode.txtEmailSubjectText;
        }
        $v_0 = parentNode.UserDisplayUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UserDisplayUrl'] = $v_0;
            delete parentNode.UserDisplayUrl;
        }
    }
};
SP.SharePointSharingSettingsPropertyNames = function SP_SharePointSharingSettingsPropertyNames() {
};
SP.SharePointSharingSettingsObjectPropertyNames = function SP_SharePointSharingSettingsObjectPropertyNames() {
};
SP.SharingLinkInfo = function SP_SharingLinkInfo() {
    SP.SharingLinkInfo.initializeBase(this);
};
SP.SharingLinkInfo.prototype = {
    $6I_1: false,
    $6R_1: 0,
    $1_1: null,
    get_isActive: function SP_SharingLinkInfo$get_isActive() {
        return this.$6I_1;
    },
    get_linkKind: function SP_SharingLinkInfo$get_linkKind() {
        return this.$6R_1;
    },
    get_url: function SP_SharingLinkInfo$get_url() {
        return this.$1_1;
    },
    get_typeId: function SP_SharingLinkInfo$get_typeId() {
        return '{43647532-53c0-489a-a800-b51f5a3804a2}';
    },
    writeToXml: function SP_SharingLinkInfo$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['IsActive', 'LinkKind', 'Url'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_SharingLinkInfo$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.IsActive;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6I_1 = $v_0;
            delete parentNode.IsActive;
        }
        $v_0 = parentNode.LinkKind;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6R_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.LinkKind;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1_1 = $v_0;
            delete parentNode.Url;
        }
    }
};
SP.SharingPermissionInformation = function SP_SharingPermissionInformation(context, objectPath) {
    SP.SharingPermissionInformation.initializeBase(this, [context, objectPath]);
};
SP.SharingPermissionInformation.prototype = {
    get_isDefaultPermission: function SP_SharingPermissionInformation$get_isDefaultPermission() {
        this.checkUninitializedProperty('IsDefaultPermission');
        return ((this.get_objectData()).get_properties())['IsDefaultPermission'];
    },
    get_permissionDescription: function SP_SharingPermissionInformation$get_permissionDescription() {
        this.checkUninitializedProperty('PermissionDescription');
        return ((this.get_objectData()).get_properties())['PermissionDescription'];
    },
    get_permissionId: function SP_SharingPermissionInformation$get_permissionId() {
        this.checkUninitializedProperty('PermissionId');
        return ((this.get_objectData()).get_properties())['PermissionId'];
    },
    get_permissionKind: function SP_SharingPermissionInformation$get_permissionKind() {
        this.checkUninitializedProperty('PermissionKind');
        return ((this.get_objectData()).get_properties())['PermissionKind'];
    },
    get_permissionName: function SP_SharingPermissionInformation$get_permissionName() {
        this.checkUninitializedProperty('PermissionName');
        return ((this.get_objectData()).get_properties())['PermissionName'];
    },
    get_permissionRoleType: function SP_SharingPermissionInformation$get_permissionRoleType() {
        this.checkUninitializedProperty('PermissionRoleType');
        return ((this.get_objectData()).get_properties())['PermissionRoleType'];
    },
    initPropertiesFromJson: function SP_SharingPermissionInformation$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.IsDefaultPermission;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsDefaultPermission'] = $v_0;
            delete parentNode.IsDefaultPermission;
        }
        $v_0 = parentNode.PermissionDescription;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PermissionDescription'] = $v_0;
            delete parentNode.PermissionDescription;
        }
        $v_0 = parentNode.PermissionId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PermissionId'] = $v_0;
            delete parentNode.PermissionId;
        }
        $v_0 = parentNode.PermissionKind;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PermissionKind'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.PermissionKind;
        }
        $v_0 = parentNode.PermissionName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PermissionName'] = $v_0;
            delete parentNode.PermissionName;
        }
        $v_0 = parentNode.PermissionRoleType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PermissionRoleType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.PermissionRoleType;
        }
    }
};
SP.SharingPermissionInformationPropertyNames = function SP_SharingPermissionInformationPropertyNames() {
};
SP.SharingPermissionInformationCollection = function SP_SharingPermissionInformationCollection(context, objectPath) {
    SP.SharingPermissionInformationCollection.initializeBase(this, [context, objectPath]);
};
SP.SharingPermissionInformationCollection.prototype = {
    itemAt: function SP_SharingPermissionInformationCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_SharingPermissionInformationCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_SharingPermissionInformationCollection$get_childItemType() {
        return SP.SharingPermissionInformation;
    }
};
SP.SharingResult = function SP_SharingResult(context, objectPath) {
    SP.SharingResult.initializeBase(this, [context, objectPath]);
};
SP.SharingResult.prototype = {
    get_errorMessage: function SP_SharingResult$get_errorMessage() {
        this.checkUninitializedProperty('ErrorMessage');
        return ((this.get_objectData()).get_properties())['ErrorMessage'];
    },
    get_groupsSharedWith: function SP_SharingResult$get_groupsSharedWith() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['GroupsSharedWith'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.GroupCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'GroupsSharedWith'));
            ((this.get_objectData()).get_clientObjectProperties())['GroupsSharedWith'] = $v_0;
        }
        return $v_0;
    },
    get_groupUsersAddedTo: function SP_SharingResult$get_groupUsersAddedTo() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['GroupUsersAddedTo'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Group(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'GroupUsersAddedTo'));
            ((this.get_objectData()).get_clientObjectProperties())['GroupUsersAddedTo'] = $v_0;
        }
        return $v_0;
    },
    get_iconUrl: function SP_SharingResult$get_iconUrl() {
        this.checkUninitializedProperty('IconUrl');
        return ((this.get_objectData()).get_properties())['IconUrl'];
    },
    get_invitedUsers: function SP_SharingResult$get_invitedUsers() {
        this.checkUninitializedProperty('InvitedUsers');
        return ((this.get_objectData()).get_properties())['InvitedUsers'];
    },
    get_name: function SP_SharingResult$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    get_permissionsPageRelativeUrl: function SP_SharingResult$get_permissionsPageRelativeUrl() {
        this.checkUninitializedProperty('PermissionsPageRelativeUrl');
        return ((this.get_objectData()).get_properties())['PermissionsPageRelativeUrl'];
    },
    get_statusCode: function SP_SharingResult$get_statusCode() {
        this.checkUninitializedProperty('StatusCode');
        return ((this.get_objectData()).get_properties())['StatusCode'];
    },
    get_uniquelyPermissionedUsers: function SP_SharingResult$get_uniquelyPermissionedUsers() {
        this.checkUninitializedProperty('UniquelyPermissionedUsers');
        return ((this.get_objectData()).get_properties())['UniquelyPermissionedUsers'];
    },
    get_url: function SP_SharingResult$get_url() {
        this.checkUninitializedProperty('Url');
        return ((this.get_objectData()).get_properties())['Url'];
    },
    get_usersAddedToGroup: function SP_SharingResult$get_usersAddedToGroup() {
        this.checkUninitializedProperty('UsersAddedToGroup');
        return ((this.get_objectData()).get_properties())['UsersAddedToGroup'];
    },
    get_usersWithAccessRequests: function SP_SharingResult$get_usersWithAccessRequests() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['UsersWithAccessRequests'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.SharingUserCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'UsersWithAccessRequests'));
            ((this.get_objectData()).get_clientObjectProperties())['UsersWithAccessRequests'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_SharingResult$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ErrorMessage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ErrorMessage'] = $v_0;
            delete parentNode.ErrorMessage;
        }
        $v_0 = parentNode.GroupsSharedWith;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('GroupsSharedWith', this.get_groupsSharedWith(), $v_0);
            (this.get_groupsSharedWith()).fromJson($v_0);
            delete parentNode.GroupsSharedWith;
        }
        $v_0 = parentNode.GroupUsersAddedTo;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('GroupUsersAddedTo', this.get_groupUsersAddedTo(), $v_0);
            (this.get_groupUsersAddedTo()).fromJson($v_0);
            delete parentNode.GroupUsersAddedTo;
        }
        $v_0 = parentNode.IconUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IconUrl'] = $v_0;
            delete parentNode.IconUrl;
        }
        $v_0 = parentNode.InvitedUsers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['InvitedUsers'] = [];
            SP.DataConvert.populateArray(this.get_context(), ((this.get_objectData()).get_properties())['InvitedUsers'], $v_0);
            delete parentNode.InvitedUsers;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.PermissionsPageRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PermissionsPageRelativeUrl'] = $v_0;
            delete parentNode.PermissionsPageRelativeUrl;
        }
        $v_0 = parentNode.StatusCode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['StatusCode'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.StatusCode;
        }
        $v_0 = parentNode.UniquelyPermissionedUsers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UniquelyPermissionedUsers'] = [];
            SP.DataConvert.populateArray(this.get_context(), ((this.get_objectData()).get_properties())['UniquelyPermissionedUsers'], $v_0);
            delete parentNode.UniquelyPermissionedUsers;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Url'] = $v_0;
            delete parentNode.Url;
        }
        $v_0 = parentNode.UsersAddedToGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UsersAddedToGroup'] = [];
            SP.DataConvert.populateArray(this.get_context(), ((this.get_objectData()).get_properties())['UsersAddedToGroup'], $v_0);
            delete parentNode.UsersAddedToGroup;
        }
        $v_0 = parentNode.UsersWithAccessRequests;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('UsersWithAccessRequests', this.get_usersWithAccessRequests(), $v_0);
            (this.get_usersWithAccessRequests()).fromJson($v_0);
            delete parentNode.UsersWithAccessRequests;
        }
    }
};
SP.SharingResultPropertyNames = function SP_SharingResultPropertyNames() {
};
SP.SharingResultObjectPropertyNames = function SP_SharingResultObjectPropertyNames() {
};
SP.SharingUserCollection = function SP_SharingUserCollection(context, objectPath) {
    SP.SharingUserCollection.initializeBase(this, [context, objectPath]);
};
SP.SharingUserCollection.prototype = {
    itemAt: function SP_SharingUserCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_SharingUserCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_SharingUserCollection$get_childItemType() {
        return SP.User;
    }
};
SP.Site = function SP_Site(context, objectPath) {
    SP.Site.initializeBase(this, [context, objectPath]);
};
SP.Site.prototype = {
    get_allowCreateDeclarativeWorkflow: function SP_Site$get_allowCreateDeclarativeWorkflow() {
        this.checkUninitializedProperty('AllowCreateDeclarativeWorkflow');
        return ((this.get_objectData()).get_properties())['AllowCreateDeclarativeWorkflow'];
    },
    set_allowCreateDeclarativeWorkflow: function SP_Site$set_allowCreateDeclarativeWorkflow(value) {
        ((this.get_objectData()).get_properties())['AllowCreateDeclarativeWorkflow'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowCreateDeclarativeWorkflow', value));
        }
        return value;
    },
    get_allowDesigner: function SP_Site$get_allowDesigner() {
        this.checkUninitializedProperty('AllowDesigner');
        return ((this.get_objectData()).get_properties())['AllowDesigner'];
    },
    set_allowDesigner: function SP_Site$set_allowDesigner(value) {
        ((this.get_objectData()).get_properties())['AllowDesigner'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowDesigner', value));
        }
        return value;
    },
    get_allowMasterPageEditing: function SP_Site$get_allowMasterPageEditing() {
        this.checkUninitializedProperty('AllowMasterPageEditing');
        return ((this.get_objectData()).get_properties())['AllowMasterPageEditing'];
    },
    set_allowMasterPageEditing: function SP_Site$set_allowMasterPageEditing(value) {
        ((this.get_objectData()).get_properties())['AllowMasterPageEditing'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowMasterPageEditing', value));
        }
        return value;
    },
    get_allowRevertFromTemplate: function SP_Site$get_allowRevertFromTemplate() {
        this.checkUninitializedProperty('AllowRevertFromTemplate');
        return ((this.get_objectData()).get_properties())['AllowRevertFromTemplate'];
    },
    set_allowRevertFromTemplate: function SP_Site$set_allowRevertFromTemplate(value) {
        ((this.get_objectData()).get_properties())['AllowRevertFromTemplate'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowRevertFromTemplate', value));
        }
        return value;
    },
    get_allowSaveDeclarativeWorkflowAsTemplate: function SP_Site$get_allowSaveDeclarativeWorkflowAsTemplate() {
        this.checkUninitializedProperty('AllowSaveDeclarativeWorkflowAsTemplate');
        return ((this.get_objectData()).get_properties())['AllowSaveDeclarativeWorkflowAsTemplate'];
    },
    set_allowSaveDeclarativeWorkflowAsTemplate: function SP_Site$set_allowSaveDeclarativeWorkflowAsTemplate(value) {
        ((this.get_objectData()).get_properties())['AllowSaveDeclarativeWorkflowAsTemplate'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowSaveDeclarativeWorkflowAsTemplate', value));
        }
        return value;
    },
    get_allowSavePublishDeclarativeWorkflow: function SP_Site$get_allowSavePublishDeclarativeWorkflow() {
        this.checkUninitializedProperty('AllowSavePublishDeclarativeWorkflow');
        return ((this.get_objectData()).get_properties())['AllowSavePublishDeclarativeWorkflow'];
    },
    set_allowSavePublishDeclarativeWorkflow: function SP_Site$set_allowSavePublishDeclarativeWorkflow(value) {
        ((this.get_objectData()).get_properties())['AllowSavePublishDeclarativeWorkflow'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowSavePublishDeclarativeWorkflow', value));
        }
        return value;
    },
    get_allowSelfServiceUpgrade: function SP_Site$get_allowSelfServiceUpgrade() {
        this.checkUninitializedProperty('AllowSelfServiceUpgrade');
        return ((this.get_objectData()).get_properties())['AllowSelfServiceUpgrade'];
    },
    set_allowSelfServiceUpgrade: function SP_Site$set_allowSelfServiceUpgrade(value) {
        ((this.get_objectData()).get_properties())['AllowSelfServiceUpgrade'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowSelfServiceUpgrade', value));
        }
        return value;
    },
    get_allowSelfServiceUpgradeEvaluation: function SP_Site$get_allowSelfServiceUpgradeEvaluation() {
        this.checkUninitializedProperty('AllowSelfServiceUpgradeEvaluation');
        return ((this.get_objectData()).get_properties())['AllowSelfServiceUpgradeEvaluation'];
    },
    set_allowSelfServiceUpgradeEvaluation: function SP_Site$set_allowSelfServiceUpgradeEvaluation(value) {
        ((this.get_objectData()).get_properties())['AllowSelfServiceUpgradeEvaluation'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AllowSelfServiceUpgradeEvaluation', value));
        }
        return value;
    },
    get_audit: function SP_Site$get_audit() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Audit'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Audit(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Audit'));
            ((this.get_objectData()).get_clientObjectProperties())['Audit'] = $v_0;
        }
        return $v_0;
    },
    get_auditLogTrimmingRetention: function SP_Site$get_auditLogTrimmingRetention() {
        this.checkUninitializedProperty('AuditLogTrimmingRetention');
        return ((this.get_objectData()).get_properties())['AuditLogTrimmingRetention'];
    },
    set_auditLogTrimmingRetention: function SP_Site$set_auditLogTrimmingRetention(value) {
        ((this.get_objectData()).get_properties())['AuditLogTrimmingRetention'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AuditLogTrimmingRetention', value));
        }
        return value;
    },
    get_canUpgrade: function SP_Site$get_canUpgrade() {
        this.checkUninitializedProperty('CanUpgrade');
        return ((this.get_objectData()).get_properties())['CanUpgrade'];
    },
    get_compatibilityLevel: function SP_Site$get_compatibilityLevel() {
        this.checkUninitializedProperty('CompatibilityLevel');
        return ((this.get_objectData()).get_properties())['CompatibilityLevel'];
    },
    get_currentChangeToken: function SP_Site$get_currentChangeToken() {
        this.checkUninitializedProperty('CurrentChangeToken');
        return ((this.get_objectData()).get_properties())['CurrentChangeToken'];
    },
    get_disableCompanyWideSharingLinks: function SP_Site$get_disableCompanyWideSharingLinks() {
        this.checkUninitializedProperty('DisableCompanyWideSharingLinks');
        return ((this.get_objectData()).get_properties())['DisableCompanyWideSharingLinks'];
    },
    set_disableCompanyWideSharingLinks: function SP_Site$set_disableCompanyWideSharingLinks(value) {
        ((this.get_objectData()).get_properties())['DisableCompanyWideSharingLinks'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DisableCompanyWideSharingLinks', value));
        }
        return value;
    },
    get_eventReceivers: function SP_Site$get_eventReceivers() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['EventReceivers'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.EventReceiverDefinitionCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'EventReceivers'));
            ((this.get_objectData()).get_clientObjectProperties())['EventReceivers'] = $v_0;
        }
        return $v_0;
    },
    get_externalSharingTipsEnabled: function SP_Site$get_externalSharingTipsEnabled() {
        this.checkUninitializedProperty('ExternalSharingTipsEnabled');
        return ((this.get_objectData()).get_properties())['ExternalSharingTipsEnabled'];
    },
    get_features: function SP_Site$get_features() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Features'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FeatureCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Features'));
            ((this.get_objectData()).get_clientObjectProperties())['Features'] = $v_0;
        }
        return $v_0;
    },
    get_id: function SP_Site$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_lockIssue: function SP_Site$get_lockIssue() {
        this.checkUninitializedProperty('LockIssue');
        return ((this.get_objectData()).get_properties())['LockIssue'];
    },
    get_maxItemsPerThrottledOperation: function SP_Site$get_maxItemsPerThrottledOperation() {
        this.checkUninitializedProperty('MaxItemsPerThrottledOperation');
        return ((this.get_objectData()).get_properties())['MaxItemsPerThrottledOperation'];
    },
    get_needsB2BUpgrade: function SP_Site$get_needsB2BUpgrade() {
        this.checkUninitializedProperty('NeedsB2BUpgrade');
        return ((this.get_objectData()).get_properties())['NeedsB2BUpgrade'];
    },
    set_needsB2BUpgrade: function SP_Site$set_needsB2BUpgrade(value) {
        ((this.get_objectData()).get_properties())['NeedsB2BUpgrade'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'NeedsB2BUpgrade', value));
        }
        return value;
    },
    get_owner: function SP_Site$get_owner() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Owner'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Owner'));
            ((this.get_objectData()).get_clientObjectProperties())['Owner'] = $v_0;
        }
        return $v_0;
    },
    set_owner: function SP_Site$set_owner(value) {
        ((this.get_objectData()).get_clientObjectProperties())['Owner'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Owner', value));
        }
        return value;
    },
    get_primaryUri: function SP_Site$get_primaryUri() {
        this.checkUninitializedProperty('PrimaryUri');
        return ((this.get_objectData()).get_properties())['PrimaryUri'];
    },
    get_readOnly: function SP_Site$get_readOnly() {
        this.checkUninitializedProperty('ReadOnly');
        return ((this.get_objectData()).get_properties())['ReadOnly'];
    },
    get_recycleBin: function SP_Site$get_recycleBin() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RecycleBin'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.RecycleBinItemCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RecycleBin'));
            ((this.get_objectData()).get_clientObjectProperties())['RecycleBin'] = $v_0;
        }
        return $v_0;
    },
    get_requiredDesignerVersion: function SP_Site$get_requiredDesignerVersion() {
        this.checkUninitializedProperty('RequiredDesignerVersion');
        return ((this.get_objectData()).get_properties())['RequiredDesignerVersion'];
    },
    get_rootWeb: function SP_Site$get_rootWeb() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RootWeb'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Web(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RootWeb'));
            ((this.get_objectData()).get_clientObjectProperties())['RootWeb'] = $v_0;
        }
        return $v_0;
    },
    get_sandboxedCodeActivationCapability: function SP_Site$get_sandboxedCodeActivationCapability() {
        this.checkUninitializedProperty('SandboxedCodeActivationCapability');
        return ((this.get_objectData()).get_properties())['SandboxedCodeActivationCapability'];
    },
    set_sandboxedCodeActivationCapability: function SP_Site$set_sandboxedCodeActivationCapability(value) {
        ((this.get_objectData()).get_properties())['SandboxedCodeActivationCapability'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SandboxedCodeActivationCapability', value));
        }
        return value;
    },
    get_secondaryContact: function SP_Site$get_secondaryContact() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['SecondaryContact'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'SecondaryContact'));
            ((this.get_objectData()).get_clientObjectProperties())['SecondaryContact'] = $v_0;
        }
        return $v_0;
    },
    set_secondaryContact: function SP_Site$set_secondaryContact(value) {
        ((this.get_objectData()).get_clientObjectProperties())['SecondaryContact'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SecondaryContact', value));
        }
        return value;
    },
    get_serverRelativeUrl: function SP_Site$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    get_shareByEmailEnabled: function SP_Site$get_shareByEmailEnabled() {
        this.checkUninitializedProperty('ShareByEmailEnabled');
        return ((this.get_objectData()).get_properties())['ShareByEmailEnabled'];
    },
    set_shareByEmailEnabled: function SP_Site$set_shareByEmailEnabled(value) {
        ((this.get_objectData()).get_properties())['ShareByEmailEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ShareByEmailEnabled', value));
        }
        return value;
    },
    get_shareByLinkEnabled: function SP_Site$get_shareByLinkEnabled() {
        this.checkUninitializedProperty('ShareByLinkEnabled');
        return ((this.get_objectData()).get_properties())['ShareByLinkEnabled'];
    },
    get_showUrlStructure: function SP_Site$get_showUrlStructure() {
        this.checkUninitializedProperty('ShowUrlStructure');
        return ((this.get_objectData()).get_properties())['ShowUrlStructure'];
    },
    set_showUrlStructure: function SP_Site$set_showUrlStructure(value) {
        ((this.get_objectData()).get_properties())['ShowUrlStructure'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ShowUrlStructure', value));
        }
        return value;
    },
    get_trimAuditLog: function SP_Site$get_trimAuditLog() {
        this.checkUninitializedProperty('TrimAuditLog');
        return ((this.get_objectData()).get_properties())['TrimAuditLog'];
    },
    set_trimAuditLog: function SP_Site$set_trimAuditLog(value) {
        ((this.get_objectData()).get_properties())['TrimAuditLog'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'TrimAuditLog', value));
        }
        return value;
    },
    get_uiVersionConfigurationEnabled: function SP_Site$get_uiVersionConfigurationEnabled() {
        this.checkUninitializedProperty('UIVersionConfigurationEnabled');
        return ((this.get_objectData()).get_properties())['UIVersionConfigurationEnabled'];
    },
    set_uiVersionConfigurationEnabled: function SP_Site$set_uiVersionConfigurationEnabled(value) {
        ((this.get_objectData()).get_properties())['UIVersionConfigurationEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'UIVersionConfigurationEnabled', value));
        }
        return value;
    },
    get_upgradeInfo: function SP_Site$get_upgradeInfo() {
        this.checkUninitializedProperty('UpgradeInfo');
        return ((this.get_objectData()).get_properties())['UpgradeInfo'];
    },
    get_upgradeReminderDate: function SP_Site$get_upgradeReminderDate() {
        this.checkUninitializedProperty('UpgradeReminderDate');
        return ((this.get_objectData()).get_properties())['UpgradeReminderDate'];
    },
    get_upgradeScheduled: function SP_Site$get_upgradeScheduled() {
        this.checkUninitializedProperty('UpgradeScheduled');
        return ((this.get_objectData()).get_properties())['UpgradeScheduled'];
    },
    set_upgradeScheduled: function SP_Site$set_upgradeScheduled(value) {
        ((this.get_objectData()).get_properties())['UpgradeScheduled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'UpgradeScheduled', value));
        }
        return value;
    },
    get_upgradeScheduledDate: function SP_Site$get_upgradeScheduledDate() {
        this.checkUninitializedProperty('UpgradeScheduledDate');
        return ((this.get_objectData()).get_properties())['UpgradeScheduledDate'];
    },
    set_upgradeScheduledDate: function SP_Site$set_upgradeScheduledDate(value) {
        ((this.get_objectData()).get_properties())['UpgradeScheduledDate'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'UpgradeScheduledDate', value));
        }
        return value;
    },
    get_upgrading: function SP_Site$get_upgrading() {
        this.checkUninitializedProperty('Upgrading');
        return ((this.get_objectData()).get_properties())['Upgrading'];
    },
    get_url: function SP_Site$get_url() {
        this.checkUninitializedProperty('Url');
        return ((this.get_objectData()).get_properties())['Url'];
    },
    get_usage: function SP_Site$get_usage() {
        this.checkUninitializedProperty('Usage');
        return ((this.get_objectData()).get_properties())['Usage'];
    },
    get_userCustomActions: function SP_Site$get_userCustomActions() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['UserCustomActions'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserCustomActionCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'UserCustomActions'));
            ((this.get_objectData()).get_clientObjectProperties())['UserCustomActions'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_Site$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowCreateDeclarativeWorkflow;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowCreateDeclarativeWorkflow'] = $v_0;
            delete parentNode.AllowCreateDeclarativeWorkflow;
        }
        $v_0 = parentNode.AllowDesigner;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowDesigner'] = $v_0;
            delete parentNode.AllowDesigner;
        }
        $v_0 = parentNode.AllowMasterPageEditing;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowMasterPageEditing'] = $v_0;
            delete parentNode.AllowMasterPageEditing;
        }
        $v_0 = parentNode.AllowRevertFromTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowRevertFromTemplate'] = $v_0;
            delete parentNode.AllowRevertFromTemplate;
        }
        $v_0 = parentNode.AllowSaveDeclarativeWorkflowAsTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowSaveDeclarativeWorkflowAsTemplate'] = $v_0;
            delete parentNode.AllowSaveDeclarativeWorkflowAsTemplate;
        }
        $v_0 = parentNode.AllowSavePublishDeclarativeWorkflow;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowSavePublishDeclarativeWorkflow'] = $v_0;
            delete parentNode.AllowSavePublishDeclarativeWorkflow;
        }
        $v_0 = parentNode.AllowSelfServiceUpgrade;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowSelfServiceUpgrade'] = $v_0;
            delete parentNode.AllowSelfServiceUpgrade;
        }
        $v_0 = parentNode.AllowSelfServiceUpgradeEvaluation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowSelfServiceUpgradeEvaluation'] = $v_0;
            delete parentNode.AllowSelfServiceUpgradeEvaluation;
        }
        $v_0 = parentNode.Audit;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Audit', this.get_audit(), $v_0);
            (this.get_audit()).fromJson($v_0);
            delete parentNode.Audit;
        }
        $v_0 = parentNode.AuditLogTrimmingRetention;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AuditLogTrimmingRetention'] = $v_0;
            delete parentNode.AuditLogTrimmingRetention;
        }
        $v_0 = parentNode.CanUpgrade;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CanUpgrade'] = $v_0;
            delete parentNode.CanUpgrade;
        }
        $v_0 = parentNode.CompatibilityLevel;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CompatibilityLevel'] = $v_0;
            delete parentNode.CompatibilityLevel;
        }
        $v_0 = parentNode.CurrentChangeToken;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CurrentChangeToken'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.CurrentChangeToken;
        }
        $v_0 = parentNode.DisableCompanyWideSharingLinks;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisableCompanyWideSharingLinks'] = $v_0;
            delete parentNode.DisableCompanyWideSharingLinks;
        }
        $v_0 = parentNode.EventReceivers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('EventReceivers', this.get_eventReceivers(), $v_0);
            (this.get_eventReceivers()).fromJson($v_0);
            delete parentNode.EventReceivers;
        }
        $v_0 = parentNode.ExternalSharingTipsEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ExternalSharingTipsEnabled'] = $v_0;
            delete parentNode.ExternalSharingTipsEnabled;
        }
        $v_0 = parentNode.Features;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Features', this.get_features(), $v_0);
            (this.get_features()).fromJson($v_0);
            delete parentNode.Features;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.LockIssue;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LockIssue'] = $v_0;
            delete parentNode.LockIssue;
        }
        $v_0 = parentNode.MaxItemsPerThrottledOperation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MaxItemsPerThrottledOperation'] = $v_0;
            delete parentNode.MaxItemsPerThrottledOperation;
        }
        $v_0 = parentNode.NeedsB2BUpgrade;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['NeedsB2BUpgrade'] = $v_0;
            delete parentNode.NeedsB2BUpgrade;
        }
        $v_0 = parentNode.Owner;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Owner', this.get_owner(), $v_0);
            (this.get_owner()).fromJson($v_0);
            delete parentNode.Owner;
        }
        $v_0 = parentNode.PrimaryUri;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PrimaryUri'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.PrimaryUri;
        }
        $v_0 = parentNode.ReadOnly;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReadOnly'] = $v_0;
            delete parentNode.ReadOnly;
        }
        $v_0 = parentNode.RecycleBin;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RecycleBin', this.get_recycleBin(), $v_0);
            (this.get_recycleBin()).fromJson($v_0);
            delete parentNode.RecycleBin;
        }
        $v_0 = parentNode.RequiredDesignerVersion;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RequiredDesignerVersion'] = $v_0;
            delete parentNode.RequiredDesignerVersion;
        }
        $v_0 = parentNode.RootWeb;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RootWeb', this.get_rootWeb(), $v_0);
            (this.get_rootWeb()).fromJson($v_0);
            delete parentNode.RootWeb;
        }
        $v_0 = parentNode.SandboxedCodeActivationCapability;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SandboxedCodeActivationCapability'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SandboxedCodeActivationCapability;
        }
        $v_0 = parentNode.SecondaryContact;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('SecondaryContact', this.get_secondaryContact(), $v_0);
            (this.get_secondaryContact()).fromJson($v_0);
            delete parentNode.SecondaryContact;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.ShareByEmailEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShareByEmailEnabled'] = $v_0;
            delete parentNode.ShareByEmailEnabled;
        }
        $v_0 = parentNode.ShareByLinkEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShareByLinkEnabled'] = $v_0;
            delete parentNode.ShareByLinkEnabled;
        }
        $v_0 = parentNode.ShowUrlStructure;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShowUrlStructure'] = $v_0;
            delete parentNode.ShowUrlStructure;
        }
        $v_0 = parentNode.TrimAuditLog;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TrimAuditLog'] = $v_0;
            delete parentNode.TrimAuditLog;
        }
        $v_0 = parentNode.UIVersionConfigurationEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UIVersionConfigurationEnabled'] = $v_0;
            delete parentNode.UIVersionConfigurationEnabled;
        }
        $v_0 = parentNode.UpgradeInfo;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UpgradeInfo'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.UpgradeInfo;
        }
        $v_0 = parentNode.UpgradeReminderDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UpgradeReminderDate'] = $v_0;
            delete parentNode.UpgradeReminderDate;
        }
        $v_0 = parentNode.UpgradeScheduled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UpgradeScheduled'] = $v_0;
            delete parentNode.UpgradeScheduled;
        }
        $v_0 = parentNode.UpgradeScheduledDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UpgradeScheduledDate'] = $v_0;
            delete parentNode.UpgradeScheduledDate;
        }
        $v_0 = parentNode.Upgrading;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Upgrading'] = $v_0;
            delete parentNode.Upgrading;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Url'] = $v_0;
            delete parentNode.Url;
        }
        $v_0 = parentNode.Usage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Usage'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Usage;
        }
        $v_0 = parentNode.UserCustomActions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('UserCustomActions', this.get_userCustomActions(), $v_0);
            (this.get_userCustomActions()).fromJson($v_0);
            delete parentNode.UserCustomActions;
        }
    },
    updateClientObjectModelUseRemoteAPIsPermissionSetting: function SP_Site$updateClientObjectModelUseRemoteAPIsPermissionSetting(requireUseRemoteAPIs) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'UpdateClientObjectModelUseRemoteAPIsPermissionSetting', [requireUseRemoteAPIs]);

        $v_0.addQuery($v_1);
    },
    needsUpgradeByType: function SP_Site$needsUpgradeByType(versionUpgrade, recursive) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'NeedsUpgradeByType', [versionUpgrade, recursive]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.BooleanResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    runHealthCheck: function SP_Site$runHealthCheck(ruleId, bRepair, bRunAlways) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.SiteHealth.SiteHealthSummary($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'RunHealthCheck', [ruleId, bRepair, bRunAlways]));
        return $v_1;
    },
    createPreviewSPSite: function SP_Site$createPreviewSPSite(upgrade, sendemail) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'CreatePreviewSPSite', [upgrade, sendemail]);

        $v_0.addQuery($v_1);
    },
    runUpgradeSiteSession: function SP_Site$runUpgradeSiteSession(versionUpgrade, queueOnly, sendEmail) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RunUpgradeSiteSession', [versionUpgrade, queueOnly, sendEmail]);

        $v_0.addQuery($v_1);
    },
    deleteMigrationJob: function SP_Site$deleteMigrationJob(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'DeleteMigrationJob', [id]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.BooleanResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getMigrationStatus: function SP_Site$getMigrationStatus() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.SPMigrationJobStatusCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetMigrationStatus', null));
        return $v_1;
    },
    getMigrationJobStatus: function SP_Site$getMigrationJobStatus(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetMigrationJobStatus', [id]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.IntResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    createMigrationJob: function SP_Site$createMigrationJob(gWebId, azureContainerSourceUri, azureContainerManifestUri, azureQueueReportUri) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'CreateMigrationJob', [gWebId, azureContainerSourceUri, azureContainerManifestUri, azureQueueReportUri]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    createMigrationJobEncrypted: function SP_Site$createMigrationJobEncrypted(gWebId, azureContainerSourceUri, azureContainerManifestUri, azureQueueReportUri, options) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'CreateMigrationJobEncrypted', [gWebId, azureContainerSourceUri, azureContainerManifestUri, azureQueueReportUri, options]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    createMigrationIngestionJob: function SP_Site$createMigrationIngestionJob(gWebId, azureContainerSourceUri, azureContainerManifestUri, azureQueueReportUri, ingestionTaskKey) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'CreateMigrationIngestionJob', [gWebId, azureContainerSourceUri, azureContainerManifestUri, azureQueueReportUri, ingestionTaskKey]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.GuidResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getChanges: function SP_Site$getChanges(query) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ChangeCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetChanges', [query]));
        return $v_1;
    },
    getRecycleBinItems: function SP_Site$getRecycleBinItems(pagingInfo, rowLimit, isAscending, orderBy, itemState) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.RecycleBinItemCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetRecycleBinItems', [pagingInfo, rowLimit, isAscending, orderBy, itemState]));
        return $v_1;
    },
    openWeb: function SP_Site$openWeb(strUrl) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['OpenWeb'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['OpenWeb'] = $v_2;
        }
        $v_1 = $v_2[strUrl.toUpperCase()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Web($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'OpenWeb', [strUrl]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[strUrl.toUpperCase()] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    openWebById: function SP_Site$openWebById(gWebId) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Web($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'OpenWebById', [gWebId]));
        return $v_1;
    },
    getWebTemplates: function SP_Site$getWebTemplates(LCID, overrideCompatLevel) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.WebTemplateCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetWebTemplates', [LCID, overrideCompatLevel]));
        return $v_1;
    },
    getCustomListTemplates: function SP_Site$getCustomListTemplates(web) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ListTemplateCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetCustomListTemplates', [web]));
        return $v_1;
    },
    getCatalog: function SP_Site$getCatalog(typeCatalog) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetCatalog'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetCatalog'] = $v_2;
        }
        $v_1 = $v_2[typeCatalog];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetCatalog', [typeCatalog]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[typeCatalog] = $v_1;
        }
        return $v_1;
    },
    extendUpgradeReminderDate: function SP_Site$extendUpgradeReminderDate() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'ExtendUpgradeReminderDate', null);

        $v_0.addQuery($v_1);
    },
    invalidate: function SP_Site$invalidate() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Invalidate', null);

        $v_0.addQuery($v_1);
    }
};
SP.SitePropertyNames = function SP_SitePropertyNames() {
};
SP.SiteObjectPropertyNames = function SP_SiteObjectPropertyNames() {
};
SP.SiteUrl = function SP_SiteUrl(context, objectPath) {
    SP.SiteUrl.initializeBase(this, [context, objectPath]);
};
SP.SPDataLeakagePreventionStatusInfo = function SP_SPDataLeakagePreventionStatusInfo(context, objectPath) {
    SP.SPDataLeakagePreventionStatusInfo.initializeBase(this, [context, objectPath]);
};
SP.SPDataLeakagePreventionStatusInfo.prototype = {
    get_containsConfidentialInfo: function SP_SPDataLeakagePreventionStatusInfo$get_containsConfidentialInfo() {
        this.checkUninitializedProperty('ContainsConfidentialInfo');
        return ((this.get_objectData()).get_properties())['ContainsConfidentialInfo'];
    },
    get_containsConfidentialInfoLearnMoreUrl: function SP_SPDataLeakagePreventionStatusInfo$get_containsConfidentialInfoLearnMoreUrl() {
        this.checkUninitializedProperty('ContainsConfidentialInfoLearnMoreUrl');
        return ((this.get_objectData()).get_properties())['ContainsConfidentialInfoLearnMoreUrl'];
    },
    get_externalSharingTipsEnabled: function SP_SPDataLeakagePreventionStatusInfo$get_externalSharingTipsEnabled() {
        this.checkUninitializedProperty('ExternalSharingTipsEnabled');
        return ((this.get_objectData()).get_properties())['ExternalSharingTipsEnabled'];
    },
    get_externalSharingTipsLearnMoreUrl: function SP_SPDataLeakagePreventionStatusInfo$get_externalSharingTipsLearnMoreUrl() {
        this.checkUninitializedProperty('ExternalSharingTipsLearnMoreUrl');
        return ((this.get_objectData()).get_properties())['ExternalSharingTipsLearnMoreUrl'];
    },
    initPropertiesFromJson: function SP_SPDataLeakagePreventionStatusInfo$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ContainsConfidentialInfo;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContainsConfidentialInfo'] = $v_0;
            delete parentNode.ContainsConfidentialInfo;
        }
        $v_0 = parentNode.ContainsConfidentialInfoLearnMoreUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContainsConfidentialInfoLearnMoreUrl'] = $v_0;
            delete parentNode.ContainsConfidentialInfoLearnMoreUrl;
        }
        $v_0 = parentNode.ExternalSharingTipsEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ExternalSharingTipsEnabled'] = $v_0;
            delete parentNode.ExternalSharingTipsEnabled;
        }
        $v_0 = parentNode.ExternalSharingTipsLearnMoreUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ExternalSharingTipsLearnMoreUrl'] = $v_0;
            delete parentNode.ExternalSharingTipsLearnMoreUrl;
        }
    }
};
SP.SPDataLeakagePreventionStatusInfoPropertyNames = function SP_SPDataLeakagePreventionStatusInfoPropertyNames() {
};
SP.SPInvitationCreationResult = function SP_SPInvitationCreationResult() {
    SP.SPInvitationCreationResult.initializeBase(this);
};
SP.SPInvitationCreationResult.prototype = {
    $5_1: null,
    $14_1: null,
    $6v_1: false,
    get_email: function SP_SPInvitationCreationResult$get_email() {
        return this.$5_1;
    },
    get_invitationLink: function SP_SPInvitationCreationResult$get_invitationLink() {
        return this.$14_1;
    },
    get_succeeded: function SP_SPInvitationCreationResult$get_succeeded() {
        return this.$6v_1;
    },
    get_typeId: function SP_SPInvitationCreationResult$get_typeId() {
        return '{56593357-67a4-41f7-b6d8-cce2d1013afe}';
    },
    writeToXml: function SP_SPInvitationCreationResult$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Email', 'InvitationLink', 'Succeeded'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_SPInvitationCreationResult$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Email;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5_1 = $v_0;
            delete parentNode.Email;
        }
        $v_0 = parentNode.InvitationLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$14_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.InvitationLink;
        }
        $v_0 = parentNode.Succeeded;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6v_1 = $v_0;
            delete parentNode.Succeeded;
        }
    }
};
SP.SPMigrationJobStatus = function SP_SPMigrationJobStatus(context, objectPath) {
    SP.SPMigrationJobStatus.initializeBase(this, [context, objectPath]);
};
SP.SPMigrationJobStatus.prototype = {
    get_jobId: function SP_SPMigrationJobStatus$get_jobId() {
        this.checkUninitializedProperty('JobId');
        return ((this.get_objectData()).get_properties())['JobId'];
    },
    set_jobId: function SP_SPMigrationJobStatus$set_jobId(value) {
        ((this.get_objectData()).get_properties())['JobId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'JobId', value));
        }
        return value;
    },
    get_jobState: function SP_SPMigrationJobStatus$get_jobState() {
        this.checkUninitializedProperty('JobState');
        return ((this.get_objectData()).get_properties())['JobState'];
    },
    set_jobState: function SP_SPMigrationJobStatus$set_jobState(value) {
        ((this.get_objectData()).get_properties())['JobState'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'JobState', value));
        }
        return value;
    },
    initPropertiesFromJson: function SP_SPMigrationJobStatus$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.JobId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['JobId'] = $v_0;
            delete parentNode.JobId;
        }
        $v_0 = parentNode.JobState;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['JobState'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.JobState;
        }
    }
};
SP.SPMigrationJobStatusPropertyNames = function SP_SPMigrationJobStatusPropertyNames() {
};
SP.SPMigrationJobStatusCollection = function SP_SPMigrationJobStatusCollection(context, objectPath) {
    SP.SPMigrationJobStatusCollection.initializeBase(this, [context, objectPath]);
};
SP.SPMigrationJobStatusCollection.prototype = {
    itemAt: function SP_SPMigrationJobStatusCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_SPMigrationJobStatusCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_SPMigrationJobStatusCollection$get_childItemType() {
        return SP.SPMigrationJobStatus;
    }
};
SP.StorageMetrics = function SP_StorageMetrics(context, objectPath) {
    SP.StorageMetrics.initializeBase(this, [context, objectPath]);
};
SP.StorageMetrics.prototype = {
    get_lastModified: function SP_StorageMetrics$get_lastModified() {
        this.checkUninitializedProperty('LastModified');
        return ((this.get_objectData()).get_properties())['LastModified'];
    },
    get_totalFileCount: function SP_StorageMetrics$get_totalFileCount() {
        this.checkUninitializedProperty('TotalFileCount');
        return ((this.get_objectData()).get_properties())['TotalFileCount'];
    },
    get_totalFileStreamSize: function SP_StorageMetrics$get_totalFileStreamSize() {
        this.checkUninitializedProperty('TotalFileStreamSize');
        return ((this.get_objectData()).get_properties())['TotalFileStreamSize'];
    },
    get_totalSize: function SP_StorageMetrics$get_totalSize() {
        this.checkUninitializedProperty('TotalSize');
        return ((this.get_objectData()).get_properties())['TotalSize'];
    },
    initPropertiesFromJson: function SP_StorageMetrics$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.LastModified;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LastModified'] = $v_0;
            delete parentNode.LastModified;
        }
        $v_0 = parentNode.TotalFileCount;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TotalFileCount'] = $v_0;
            delete parentNode.TotalFileCount;
        }
        $v_0 = parentNode.TotalFileStreamSize;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TotalFileStreamSize'] = $v_0;
            delete parentNode.TotalFileStreamSize;
        }
        $v_0 = parentNode.TotalSize;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TotalSize'] = $v_0;
            delete parentNode.TotalSize;
        }
    }
};
SP.StorageMetricsPropertyNames = function SP_StorageMetricsPropertyNames() {
};
SP.SubwebQuery = function SP_SubwebQuery() {
    this.$2N_1 = -1;
    this.$5X_1 = -1;
    SP.SubwebQuery.initializeBase(this);
};
SP.SubwebQuery.prototype = {
    get_configurationFilter: function SP_SubwebQuery$get_configurationFilter() {
        return this.$2N_1;
    },
    set_configurationFilter: function SP_SubwebQuery$set_configurationFilter(value) {
        this.$2N_1 = value;
        return value;
    },
    get_webTemplateFilter: function SP_SubwebQuery$get_webTemplateFilter() {
        return this.$5X_1;
    },
    set_webTemplateFilter: function SP_SubwebQuery$set_webTemplateFilter(value) {
        this.$5X_1 = value;
        return value;
    },
    get_typeId: function SP_SubwebQuery$get_typeId() {
        return '{e3a4d63c-876b-4e24-a972-7664437146fe}';
    },
    writeToXml: function SP_SubwebQuery$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['ConfigurationFilter', 'WebTemplateFilter'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_SubwebQuery$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ConfigurationFilter;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2N_1 = $v_0;
            delete parentNode.ConfigurationFilter;
        }
        $v_0 = parentNode.WebTemplateFilter;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5X_1 = $v_0;
            delete parentNode.WebTemplateFilter;
        }
    }
};
SP.TenantAppInformation = function SP_TenantAppInformation() {
    SP.TenantAppInformation.initializeBase(this);
};
SP.TenantAppInformation.prototype = {
    $5u_1: null,
    $5v_1: null,
    $61_1: null,
    $6G_1: null,
    $6H_1: null,
    $x_1: null,
    $6P_1: null,
    $6a_1: null,
    $6e_1: null,
    $6i_1: null,
    $D_1: 0,
    $0_1: null,
    get_appPrincipalId: function SP_TenantAppInformation$get_appPrincipalId() {
        return this.$5u_1;
    },
    get_appWebFullUrl: function SP_TenantAppInformation$get_appWebFullUrl() {
        return this.$5v_1;
    },
    get_creationTime: function SP_TenantAppInformation$get_creationTime() {
        return this.$61_1;
    },
    get_iconAbsoluteUrl: function SP_TenantAppInformation$get_iconAbsoluteUrl() {
        return this.$6G_1;
    },
    get_iconFallbackAbsoluteUrl: function SP_TenantAppInformation$get_iconFallbackAbsoluteUrl() {
        return this.$6H_1;
    },
    get_id: function SP_TenantAppInformation$get_id() {
        return this.$x_1;
    },
    get_launchUrl: function SP_TenantAppInformation$get_launchUrl() {
        return this.$6P_1;
    },
    get_packageFingerprint: function SP_TenantAppInformation$get_packageFingerprint() {
        return this.$6a_1;
    },
    get_productId: function SP_TenantAppInformation$get_productId() {
        return this.$6e_1;
    },
    get_remoteAppUrl: function SP_TenantAppInformation$get_remoteAppUrl() {
        return this.$6i_1;
    },
    get_status: function SP_TenantAppInformation$get_status() {
        return this.$D_1;
    },
    get_title: function SP_TenantAppInformation$get_title() {
        return this.$0_1;
    },
    get_typeId: function SP_TenantAppInformation$get_typeId() {
        return '{52e6bc7d-825f-45b5-9f39-7a11723319df}';
    },
    writeToXml: function SP_TenantAppInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['AppPrincipalId', 'AppWebFullUrl', 'CreationTime', 'IconAbsoluteUrl', 'IconFallbackAbsoluteUrl', 'Id', 'LaunchUrl', 'PackageFingerprint', 'ProductId', 'RemoteAppUrl', 'Status', 'Title'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_TenantAppInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AppPrincipalId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5u_1 = $v_0;
            delete parentNode.AppPrincipalId;
        }
        $v_0 = parentNode.AppWebFullUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5v_1 = $v_0;
            delete parentNode.AppWebFullUrl;
        }
        $v_0 = parentNode.CreationTime;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$61_1 = $v_0;
            delete parentNode.CreationTime;
        }
        $v_0 = parentNode.IconAbsoluteUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6G_1 = $v_0;
            delete parentNode.IconAbsoluteUrl;
        }
        $v_0 = parentNode.IconFallbackAbsoluteUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6H_1 = $v_0;
            delete parentNode.IconFallbackAbsoluteUrl;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$x_1 = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.LaunchUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6P_1 = $v_0;
            delete parentNode.LaunchUrl;
        }
        $v_0 = parentNode.PackageFingerprint;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6a_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.PackageFingerprint;
        }
        $v_0 = parentNode.ProductId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6e_1 = $v_0;
            delete parentNode.ProductId;
        }
        $v_0 = parentNode.RemoteAppUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6i_1 = $v_0;
            delete parentNode.RemoteAppUrl;
        }
        $v_0 = parentNode.Status;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$D_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Status;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
    }
};
SP.TenantAppInstance = function SP_TenantAppInstance(context, objectPath) {
    SP.TenantAppInstance.initializeBase(this, [context, objectPath]);
};
SP.TenantAppInstance.prototype = {
    get_id: function SP_TenantAppInstance$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_siteId: function SP_TenantAppInstance$get_siteId() {
        this.checkUninitializedProperty('SiteId');
        return ((this.get_objectData()).get_properties())['SiteId'];
    },
    get_webId: function SP_TenantAppInstance$get_webId() {
        this.checkUninitializedProperty('WebId');
        return ((this.get_objectData()).get_properties())['WebId'];
    },
    initPropertiesFromJson: function SP_TenantAppInstance$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.SiteId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SiteId'] = $v_0;
            delete parentNode.SiteId;
        }
        $v_0 = parentNode.WebId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebId'] = $v_0;
            delete parentNode.WebId;
        }
    }
};
SP.TenantAppInstancePropertyNames = function SP_TenantAppInstancePropertyNames() {
};
SP.TenantAppUtility = function SP_TenantAppUtility() {
};
SP.TenantAppUtility.getTenantAppInformationCollection = function SP_TenantAppUtility$getTenantAppInformationCollection(context, web, lcid) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{a7e15a67-957e-459b-8903-e1e42fa52ab1}', 'GetTenantAppInformationCollection', [web, lcid]);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.TenantAppUtility.getAppIcon = function SP_TenantAppUtility$getAppIcon(context, web, appInstanceId, packageFingerprint) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new Microsoft.SharePoint.Packaging.AppIconInfo(context, new SP.ObjectPathStaticMethod(context, '{a7e15a67-957e-459b-8903-e1e42fa52ab1}', 'GetAppIcon', [web, appInstanceId, packageFingerprint]));
    return $v_0;
};
SP.TenantAppUtility.getTenantAppInstance = function SP_TenantAppUtility$getTenantAppInstance(context, web, appInstance) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.TenantAppInstance(context, new SP.ObjectPathStaticMethod(context, '{a7e15a67-957e-459b-8903-e1e42fa52ab1}', 'GetTenantAppInstance', [web, appInstance]));
    return $v_0;
};
SP.TenantAppUtility.getAppDetails = function SP_TenantAppUtility$getAppDetails(context, web, tenantAppInstance) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new Microsoft.SharePoint.Packaging.AppDetails(context, new SP.ObjectPathStaticMethod(context, '{a7e15a67-957e-459b-8903-e1e42fa52ab1}', 'GetAppDetails', [web, tenantAppInstance]));
    return $v_0;
};
SP.TenantAppUtility.getAppPermissionDescriptions = function SP_TenantAppUtility$getAppPermissionDescriptions(context, web, tenantAppInstance) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{a7e15a67-957e-459b-8903-e1e42fa52ab1}', 'GetAppPermissionDescriptions', [web, tenantAppInstance]);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.TenantSettings = function SP_TenantSettings(context, objectPath) {
    SP.TenantSettings.initializeBase(this, [context, objectPath]);
};
SP.TenantSettings.getCurrent = function SP_TenantSettings$getCurrent(Context) {
    var $v_0 = (Context.get_staticObjects())['Microsoft$SharePoint$TenantSettings$Current'];

    if (!$v_0) {
        $v_0 = new SP.TenantSettings(Context, new SP.ObjectPathStaticProperty(Context, '{e9a11c41-0667-4c14-a4a5-e0d6cf67f6fa}', 'Current'));
        (Context.get_staticObjects())['Microsoft$SharePoint$TenantSettings$Current'] = $v_0;
    }
    return $v_0;
};
SP.TenantSettings.prototype = {
    get_corporateCatalogUrl: function SP_TenantSettings$get_corporateCatalogUrl() {
        this.checkUninitializedProperty('CorporateCatalogUrl');
        return ((this.get_objectData()).get_properties())['CorporateCatalogUrl'];
    },
    initPropertiesFromJson: function SP_TenantSettings$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CorporateCatalogUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CorporateCatalogUrl'] = $v_0;
            delete parentNode.CorporateCatalogUrl;
        }
    }
};
SP.TenantSettingsPropertyNames = function SP_TenantSettingsPropertyNames() {
};
SP.ThemeInfo = function SP_ThemeInfo(context, objectPath) {
    SP.ThemeInfo.initializeBase(this, [context, objectPath]);
};
SP.ThemeInfo.prototype = {
    get_accessibleDescription: function SP_ThemeInfo$get_accessibleDescription() {
        this.checkUninitializedProperty('AccessibleDescription');
        return ((this.get_objectData()).get_properties())['AccessibleDescription'];
    },
    get_themeBackgroundImageUri: function SP_ThemeInfo$get_themeBackgroundImageUri() {
        this.checkUninitializedProperty('ThemeBackgroundImageUri');
        return ((this.get_objectData()).get_properties())['ThemeBackgroundImageUri'];
    },
    initPropertiesFromJson: function SP_ThemeInfo$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AccessibleDescription;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AccessibleDescription'] = $v_0;
            delete parentNode.AccessibleDescription;
        }
        $v_0 = parentNode.ThemeBackgroundImageUri;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ThemeBackgroundImageUri'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ThemeBackgroundImageUri;
        }
    },
    getThemeShadeByName: function SP_ThemeInfo$getThemeShadeByName(name) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetThemeShadeByName', [name]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getThemeFontByName: function SP_ThemeInfo$getThemeFontByName(name, lcid) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetThemeFontByName', [name, lcid]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    }
};
SP.ThemeInfoPropertyNames = function SP_ThemeInfoPropertyNames() {
};
SP.TimeZone = function SP_TimeZone(context, objectPath) {
    SP.TimeZone.initializeBase(this, [context, objectPath]);
};
SP.TimeZone.prototype = {
    get_description: function SP_TimeZone$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    get_id: function SP_TimeZone$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_information: function SP_TimeZone$get_information() {
        this.checkUninitializedProperty('Information');
        return ((this.get_objectData()).get_properties())['Information'];
    },
    initPropertiesFromJson: function SP_TimeZone$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.Information;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Information'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Information;
        }
    },
    localTimeToUTC: function SP_TimeZone$localTimeToUTC(date) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'LocalTimeToUTC', [date]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.DateTimeResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    utcToLocalTime: function SP_TimeZone$utcToLocalTime(date) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'UTCToLocalTime', [date]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.DateTimeResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    }
};
SP.TimeZonePropertyNames = function SP_TimeZonePropertyNames() {
};
SP.TimeZoneCollection = function SP_TimeZoneCollection(context, objectPath) {
    SP.TimeZoneCollection.initializeBase(this, [context, objectPath]);
};
SP.TimeZoneCollection.prototype = {
    itemAt: function SP_TimeZoneCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_TimeZoneCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_TimeZoneCollection$get_childItemType() {
        return SP.TimeZone;
    },
    getById: function SP_TimeZoneCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.TimeZone($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id] = $v_1;
        }
        return $v_1;
    }
};
SP.TimeZoneInformation = function SP_TimeZoneInformation() {
    SP.TimeZoneInformation.initializeBase(this);
};
SP.TimeZoneInformation.prototype = {
    $5y_1: 0,
    $63_1: 0,
    $6r_1: 0,
    get_bias: function SP_TimeZoneInformation$get_bias() {
        return this.$5y_1;
    },
    get_daylightBias: function SP_TimeZoneInformation$get_daylightBias() {
        return this.$63_1;
    },
    get_standardBias: function SP_TimeZoneInformation$get_standardBias() {
        return this.$6r_1;
    },
    get_typeId: function SP_TimeZoneInformation$get_typeId() {
        return '{09e18222-7e4d-488b-811d-6ef43f31d17f}';
    },
    writeToXml: function SP_TimeZoneInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Bias', 'DaylightBias', 'StandardBias'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_TimeZoneInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Bias;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5y_1 = $v_0;
            delete parentNode.Bias;
        }
        $v_0 = parentNode.DaylightBias;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$63_1 = $v_0;
            delete parentNode.DaylightBias;
        }
        $v_0 = parentNode.StandardBias;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6r_1 = $v_0;
            delete parentNode.StandardBias;
        }
    }
};
SP.UpgradeInfo = function SP_UpgradeInfo() {
    SP.UpgradeInfo.initializeBase(this);
};
SP.UpgradeInfo.prototype = {
    $69_1: null,
    $6A_1: 0,
    $6O_1: null,
    $6S_1: null,
    $6j_1: null,
    $6k_1: 0,
    $6s_1: null,
    $D_1: 0,
    $71_1: 0,
    $75_1: 0,
    get_errorFile: function SP_UpgradeInfo$get_errorFile() {
        return this.$69_1;
    },
    get_errors: function SP_UpgradeInfo$get_errors() {
        return this.$6A_1;
    },
    get_lastUpdated: function SP_UpgradeInfo$get_lastUpdated() {
        return this.$6O_1;
    },
    get_logFile: function SP_UpgradeInfo$get_logFile() {
        return this.$6S_1;
    },
    get_requestDate: function SP_UpgradeInfo$get_requestDate() {
        return this.$6j_1;
    },
    get_retryCount: function SP_UpgradeInfo$get_retryCount() {
        return this.$6k_1;
    },
    get_startTime: function SP_UpgradeInfo$get_startTime() {
        return this.$6s_1;
    },
    get_status: function SP_UpgradeInfo$get_status() {
        return this.$D_1;
    },
    get_upgradeType: function SP_UpgradeInfo$get_upgradeType() {
        return this.$71_1;
    },
    get_warnings: function SP_UpgradeInfo$get_warnings() {
        return this.$75_1;
    },
    get_typeId: function SP_UpgradeInfo$get_typeId() {
        return '{a012e5fa-a28f-4232-9561-c4033f61c889}';
    },
    writeToXml: function SP_UpgradeInfo$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['ErrorFile', 'Errors', 'LastUpdated', 'LogFile', 'RequestDate', 'RetryCount', 'StartTime', 'Status', 'UpgradeType', 'Warnings'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_UpgradeInfo$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.ErrorFile;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$69_1 = $v_0;
            delete parentNode.ErrorFile;
        }
        $v_0 = parentNode.Errors;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6A_1 = $v_0;
            delete parentNode.Errors;
        }
        $v_0 = parentNode.LastUpdated;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6O_1 = $v_0;
            delete parentNode.LastUpdated;
        }
        $v_0 = parentNode.LogFile;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6S_1 = $v_0;
            delete parentNode.LogFile;
        }
        $v_0 = parentNode.RequestDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6j_1 = $v_0;
            delete parentNode.RequestDate;
        }
        $v_0 = parentNode.RetryCount;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6k_1 = $v_0;
            delete parentNode.RetryCount;
        }
        $v_0 = parentNode.StartTime;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6s_1 = $v_0;
            delete parentNode.StartTime;
        }
        $v_0 = parentNode.Status;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$D_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Status;
        }
        $v_0 = parentNode.UpgradeType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$71_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.UpgradeType;
        }
        $v_0 = parentNode.Warnings;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$75_1 = $v_0;
            delete parentNode.Warnings;
        }
    }
};
SP.UsageInfo = function SP_UsageInfo() {
    SP.UsageInfo.initializeBase(this);
};
SP.UsageInfo.prototype = {
    $5w_1: 0,
    $65_1: 0,
    $6E_1: 0,
    $6t_1: 0,
    $6u_1: 0,
    $74_1: 0,
    get_bandwidth: function SP_UsageInfo$get_bandwidth() {
        return this.$5w_1;
    },
    get_discussionStorage: function SP_UsageInfo$get_discussionStorage() {
        return this.$65_1;
    },
    get_hits: function SP_UsageInfo$get_hits() {
        return this.$6E_1;
    },
    get_storage: function SP_UsageInfo$get_storage() {
        return this.$6t_1;
    },
    get_storagePercentageUsed: function SP_UsageInfo$get_storagePercentageUsed() {
        return this.$6u_1;
    },
    get_visits: function SP_UsageInfo$get_visits() {
        return this.$74_1;
    },
    get_typeId: function SP_UsageInfo$get_typeId() {
        return '{7ec28504-35f9-4fcf-a09f-401024417292}';
    },
    writeToXml: function SP_UsageInfo$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Bandwidth', 'DiscussionStorage', 'Hits', 'Storage', 'StoragePercentageUsed', 'Visits'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_UsageInfo$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Bandwidth;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5w_1 = $v_0;
            delete parentNode.Bandwidth;
        }
        $v_0 = parentNode.DiscussionStorage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$65_1 = $v_0;
            delete parentNode.DiscussionStorage;
        }
        $v_0 = parentNode.Hits;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6E_1 = $v_0;
            delete parentNode.Hits;
        }
        $v_0 = parentNode.Storage;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6t_1 = $v_0;
            delete parentNode.Storage;
        }
        $v_0 = parentNode.StoragePercentageUsed;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6u_1 = $v_0;
            delete parentNode.StoragePercentageUsed;
        }
        $v_0 = parentNode.Visits;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$74_1 = $v_0;
            delete parentNode.Visits;
        }
    }
};
SP.User = function SP_User(context, objectPath) {
    SP.User.initializeBase(this, [context, objectPath]);
};
SP.User.prototype = {
    $F_2: function SP_User$$F_2($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Email'] = $p0.$5_1;
            ((this.get_objectData()).get_properties())['LoginName'] = $p0.$k_1;
            ((this.get_objectData()).get_properties())['Title'] = $p0.$0_1;
        }
    },
    get_email: function SP_User$get_email() {
        this.checkUninitializedProperty('Email');
        return ((this.get_objectData()).get_properties())['Email'];
    },
    set_email: function SP_User$set_email(value) {
        ((this.get_objectData()).get_properties())['Email'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Email', value));
        }
        return value;
    },
    get_groups: function SP_User$get_groups() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Groups'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.GroupCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Groups'));
            ((this.get_objectData()).get_clientObjectProperties())['Groups'] = $v_0;
        }
        return $v_0;
    },
    get_isShareByEmailGuestUser: function SP_User$get_isShareByEmailGuestUser() {
        this.checkUninitializedProperty('IsShareByEmailGuestUser');
        return ((this.get_objectData()).get_properties())['IsShareByEmailGuestUser'];
    },
    get_isSiteAdmin: function SP_User$get_isSiteAdmin() {
        this.checkUninitializedProperty('IsSiteAdmin');
        return ((this.get_objectData()).get_properties())['IsSiteAdmin'];
    },
    set_isSiteAdmin: function SP_User$set_isSiteAdmin(value) {
        ((this.get_objectData()).get_properties())['IsSiteAdmin'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IsSiteAdmin', value));
        }
        return value;
    },
    get_userId: function SP_User$get_userId() {
        this.checkUninitializedProperty('UserId');
        return ((this.get_objectData()).get_properties())['UserId'];
    },
    initPropertiesFromJson: function SP_User$initPropertiesFromJson(parentNode) {
        SP.Principal.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Email;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Email'] = $v_0;
            delete parentNode.Email;
        }
        $v_0 = parentNode.Groups;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Groups', this.get_groups(), $v_0);
            (this.get_groups()).fromJson($v_0);
            delete parentNode.Groups;
        }
        $v_0 = parentNode.IsShareByEmailGuestUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsShareByEmailGuestUser'] = $v_0;
            delete parentNode.IsShareByEmailGuestUser;
        }
        $v_0 = parentNode.IsSiteAdmin;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsSiteAdmin'] = $v_0;
            delete parentNode.IsSiteAdmin;
        }
        $v_0 = parentNode.UserId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UserId'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.UserId;
        }
    },
    update: function SP_User$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    }
};
SP.UserPropertyNames = function SP_UserPropertyNames() {
};
SP.UserObjectPropertyNames = function SP_UserObjectPropertyNames() {
};
SP.UserCollection = function SP_UserCollection(context, objectPath) {
    SP.UserCollection.initializeBase(this, [context, objectPath]);
};
SP.UserCollection.prototype = {
    itemAt: function SP_UserCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_UserCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_UserCollection$get_childItemType() {
        return SP.User;
    },
    getByLoginName: function SP_UserCollection$getByLoginName(loginName) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByLoginName'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByLoginName'] = $v_2;
        }
        $v_1 = $v_2[loginName.toUpperCase()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.User($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByLoginName', [loginName]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[loginName.toUpperCase()] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    getById: function SP_UserCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.User($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        return $v_1;
    },
    getByEmail: function SP_UserCollection$getByEmail(emailAddress) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByEmail'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByEmail'] = $v_2;
        }
        $v_1 = $v_2[emailAddress];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.User($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByEmail', [emailAddress]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[emailAddress] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    removeByLoginName: function SP_UserCollection$removeByLoginName(loginName) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RemoveByLoginName', [loginName]);

        $v_0.addQuery($v_1);
    },
    removeById: function SP_UserCollection$removeById(id) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RemoveById', [id]);

        $v_0.addQuery($v_1);
    },
    remove: function SP_UserCollection$remove(user) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Remove', [user]);

        $v_0.addQuery($v_1);
        this.removeChild(user);
    },
    add: function SP_UserCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.User($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_2(parameters);
        return $v_1;
    },
    addUser: function SP_UserCollection$addUser(user) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.User($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'AddUser', [user]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        return $v_1;
    }
};
SP.UserCreationInformation = function SP_UserCreationInformation() {
    SP.UserCreationInformation.initializeBase(this);
};
SP.UserCreationInformation.prototype = {
    $5_1: null,
    $k_1: null,
    $0_1: null,
    get_email: function SP_UserCreationInformation$get_email() {
        return this.$5_1;
    },
    set_email: function SP_UserCreationInformation$set_email(value) {
        this.$5_1 = value;
        return value;
    },
    get_loginName: function SP_UserCreationInformation$get_loginName() {
        return this.$k_1;
    },
    set_loginName: function SP_UserCreationInformation$set_loginName(value) {
        this.$k_1 = value;
        return value;
    },
    get_title: function SP_UserCreationInformation$get_title() {
        return this.$0_1;
    },
    set_title: function SP_UserCreationInformation$set_title(value) {
        this.$0_1 = value;
        return value;
    },
    get_typeId: function SP_UserCreationInformation$get_typeId() {
        return '{6ecd8af6-bed3-4a74-be76-1ec981b350e1}';
    },
    writeToXml: function SP_UserCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Email', 'LoginName', 'Title'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_UserCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Email;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5_1 = $v_0;
            delete parentNode.Email;
        }
        $v_0 = parentNode.LoginName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$k_1 = $v_0;
            delete parentNode.LoginName;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
    }
};
SP.UserCustomAction = function SP_UserCustomAction(context, objectPath) {
    SP.UserCustomAction.initializeBase(this, [context, objectPath]);
};
SP.UserCustomAction.prototype = {
    get_commandUIExtension: function SP_UserCustomAction$get_commandUIExtension() {
        this.checkUninitializedProperty('CommandUIExtension');
        return ((this.get_objectData()).get_properties())['CommandUIExtension'];
    },
    set_commandUIExtension: function SP_UserCustomAction$set_commandUIExtension(value) {
        ((this.get_objectData()).get_properties())['CommandUIExtension'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'CommandUIExtension', value));
        }
        return value;
    },
    get_description: function SP_UserCustomAction$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    set_description: function SP_UserCustomAction$set_description(value) {
        ((this.get_objectData()).get_properties())['Description'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Description', value));
        }
        return value;
    },
    get_group: function SP_UserCustomAction$get_group() {
        this.checkUninitializedProperty('Group');
        return ((this.get_objectData()).get_properties())['Group'];
    },
    set_group: function SP_UserCustomAction$set_group(value) {
        ((this.get_objectData()).get_properties())['Group'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Group', value));
        }
        return value;
    },
    get_id: function SP_UserCustomAction$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_imageUrl: function SP_UserCustomAction$get_imageUrl() {
        this.checkUninitializedProperty('ImageUrl');
        return ((this.get_objectData()).get_properties())['ImageUrl'];
    },
    set_imageUrl: function SP_UserCustomAction$set_imageUrl(value) {
        ((this.get_objectData()).get_properties())['ImageUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ImageUrl', value));
        }
        return value;
    },
    get_location: function SP_UserCustomAction$get_location() {
        this.checkUninitializedProperty('Location');
        return ((this.get_objectData()).get_properties())['Location'];
    },
    set_location: function SP_UserCustomAction$set_location(value) {
        ((this.get_objectData()).get_properties())['Location'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Location', value));
        }
        return value;
    },
    get_name: function SP_UserCustomAction$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    set_name: function SP_UserCustomAction$set_name(value) {
        ((this.get_objectData()).get_properties())['Name'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Name', value));
        }
        return value;
    },
    get_registrationId: function SP_UserCustomAction$get_registrationId() {
        this.checkUninitializedProperty('RegistrationId');
        return ((this.get_objectData()).get_properties())['RegistrationId'];
    },
    set_registrationId: function SP_UserCustomAction$set_registrationId(value) {
        ((this.get_objectData()).get_properties())['RegistrationId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'RegistrationId', value));
        }
        return value;
    },
    get_registrationType: function SP_UserCustomAction$get_registrationType() {
        this.checkUninitializedProperty('RegistrationType');
        return ((this.get_objectData()).get_properties())['RegistrationType'];
    },
    set_registrationType: function SP_UserCustomAction$set_registrationType(value) {
        ((this.get_objectData()).get_properties())['RegistrationType'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'RegistrationType', value));
        }
        return value;
    },
    get_rights: function SP_UserCustomAction$get_rights() {
        this.checkUninitializedProperty('Rights');
        return ((this.get_objectData()).get_properties())['Rights'];
    },
    set_rights: function SP_UserCustomAction$set_rights(value) {
        ((this.get_objectData()).get_properties())['Rights'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Rights', value));
        }
        return value;
    },
    get_scope: function SP_UserCustomAction$get_scope() {
        this.checkUninitializedProperty('Scope');
        return ((this.get_objectData()).get_properties())['Scope'];
    },
    get_scriptBlock: function SP_UserCustomAction$get_scriptBlock() {
        this.checkUninitializedProperty('ScriptBlock');
        return ((this.get_objectData()).get_properties())['ScriptBlock'];
    },
    set_scriptBlock: function SP_UserCustomAction$set_scriptBlock(value) {
        ((this.get_objectData()).get_properties())['ScriptBlock'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ScriptBlock', value));
        }
        return value;
    },
    get_scriptSrc: function SP_UserCustomAction$get_scriptSrc() {
        this.checkUninitializedProperty('ScriptSrc');
        return ((this.get_objectData()).get_properties())['ScriptSrc'];
    },
    set_scriptSrc: function SP_UserCustomAction$set_scriptSrc(value) {
        ((this.get_objectData()).get_properties())['ScriptSrc'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ScriptSrc', value));
        }
        return value;
    },
    get_sequence: function SP_UserCustomAction$get_sequence() {
        this.checkUninitializedProperty('Sequence');
        return ((this.get_objectData()).get_properties())['Sequence'];
    },
    set_sequence: function SP_UserCustomAction$set_sequence(value) {
        ((this.get_objectData()).get_properties())['Sequence'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Sequence', value));
        }
        return value;
    },
    get_title: function SP_UserCustomAction$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    set_title: function SP_UserCustomAction$set_title(value) {
        ((this.get_objectData()).get_properties())['Title'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Title', value));
        }
        return value;
    },
    get_url: function SP_UserCustomAction$get_url() {
        this.checkUninitializedProperty('Url');
        return ((this.get_objectData()).get_properties())['Url'];
    },
    set_url: function SP_UserCustomAction$set_url(value) {
        ((this.get_objectData()).get_properties())['Url'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Url', value));
        }
        return value;
    },
    get_versionOfUserCustomAction: function SP_UserCustomAction$get_versionOfUserCustomAction() {
        this.checkUninitializedProperty('VersionOfUserCustomAction');
        return ((this.get_objectData()).get_properties())['VersionOfUserCustomAction'];
    },
    initPropertiesFromJson: function SP_UserCustomAction$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.CommandUIExtension;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CommandUIExtension'] = $v_0;
            delete parentNode.CommandUIExtension;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Group;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Group'] = $v_0;
            delete parentNode.Group;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.ImageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ImageUrl'] = $v_0;
            delete parentNode.ImageUrl;
        }
        $v_0 = parentNode.Location;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Location'] = $v_0;
            delete parentNode.Location;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.RegistrationId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RegistrationId'] = $v_0;
            delete parentNode.RegistrationId;
        }
        $v_0 = parentNode.RegistrationType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RegistrationType'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.RegistrationType;
        }
        $v_0 = parentNode.Rights;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Rights'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Rights;
        }
        $v_0 = parentNode.Scope;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Scope'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Scope;
        }
        $v_0 = parentNode.ScriptBlock;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ScriptBlock'] = $v_0;
            delete parentNode.ScriptBlock;
        }
        $v_0 = parentNode.ScriptSrc;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ScriptSrc'] = $v_0;
            delete parentNode.ScriptSrc;
        }
        $v_0 = parentNode.Sequence;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Sequence'] = $v_0;
            delete parentNode.Sequence;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Url'] = $v_0;
            delete parentNode.Url;
        }
        $v_0 = parentNode.VersionOfUserCustomAction;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['VersionOfUserCustomAction'] = $v_0;
            delete parentNode.VersionOfUserCustomAction;
        }
    },
    update: function SP_UserCustomAction$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
        this.refreshLoad();
    },
    deleteObject: function SP_UserCustomAction$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    }
};
SP.UserCustomActionPropertyNames = function SP_UserCustomActionPropertyNames() {
};
SP.UserCustomActionCollection = function SP_UserCustomActionCollection(context, objectPath) {
    SP.UserCustomActionCollection.initializeBase(this, [context, objectPath]);
};
SP.UserCustomActionCollection.prototype = {
    itemAt: function SP_UserCustomActionCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_UserCustomActionCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_UserCustomActionCollection$get_childItemType() {
        return SP.UserCustomAction;
    },
    getById: function SP_UserCustomActionCollection$getById(id) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[id.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.UserCustomAction($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [id]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[id.toString()] = $v_1;
        }
        return $v_1;
    },
    clear: function SP_UserCustomActionCollection$clear() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Clear', null);

        $v_0.addQuery($v_1);
    },
    add: function SP_UserCustomActionCollection$add() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.UserCustomAction($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', null));
        this.addChild($v_1);
        return $v_1;
    }
};
SP.UserIdInfo = function SP_UserIdInfo() {
    SP.UserIdInfo.initializeBase(this);
};
SP.UserIdInfo.prototype = {
    $6X_1: null,
    $6Y_1: null,
    get_nameId: function SP_UserIdInfo$get_nameId() {
        return this.$6X_1;
    },
    get_nameIdIssuer: function SP_UserIdInfo$get_nameIdIssuer() {
        return this.$6Y_1;
    },
    get_typeId: function SP_UserIdInfo$get_typeId() {
        return '{c5c3ae1a-63b6-4f25-a887-54b0b20a28e2}';
    },
    writeToXml: function SP_UserIdInfo$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['NameId', 'NameIdIssuer'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_UserIdInfo$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.NameId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6X_1 = $v_0;
            delete parentNode.NameId;
        }
        $v_0 = parentNode.NameIdIssuer;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$6Y_1 = $v_0;
            delete parentNode.NameIdIssuer;
        }
    }
};
SP.UserResource = function SP_UserResource(context, objectPath) {
    SP.UserResource.initializeBase(this, [context, objectPath]);
};
SP.UserResource.prototype = {
    getValueForUICulture: function SP_UserResource$getValueForUICulture(cultureName) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetValueForUICulture'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetValueForUICulture'] = $v_2;
        }
        $v_1 = $v_2[cultureName];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        var $v_3 = new SP.ClientActionInvokeMethod(this, 'GetValueForUICulture', [cultureName]);

        $v_0.addQuery($v_3);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[cultureName] = $v_1;
        }
        return $v_1;
    },
    setValueForUICulture: function SP_UserResource$setValueForUICulture(cultureName, value) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'SetValueForUICulture', [cultureName, value]);

        $v_0.addQuery($v_1);
    }
};
SP.View = function SP_View(context, objectPath) {
    SP.View.initializeBase(this, [context, objectPath]);
};
SP.View.prototype = {
    $F_1: function SP_View$$F_1($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Title'] = $p0.$0_1;
            ((this.get_objectData()).get_properties())['Paged'] = $p0.$1Y_1;
        }
    },
    get_aggregations: function SP_View$get_aggregations() {
        this.checkUninitializedProperty('Aggregations');
        return ((this.get_objectData()).get_properties())['Aggregations'];
    },
    set_aggregations: function SP_View$set_aggregations(value) {
        ((this.get_objectData()).get_properties())['Aggregations'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Aggregations', value));
        }
        return value;
    },
    get_aggregationsStatus: function SP_View$get_aggregationsStatus() {
        this.checkUninitializedProperty('AggregationsStatus');
        return ((this.get_objectData()).get_properties())['AggregationsStatus'];
    },
    set_aggregationsStatus: function SP_View$set_aggregationsStatus(value) {
        ((this.get_objectData()).get_properties())['AggregationsStatus'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AggregationsStatus', value));
        }
        return value;
    },
    get_baseViewId: function SP_View$get_baseViewId() {
        this.checkUninitializedProperty('BaseViewId');
        return ((this.get_objectData()).get_properties())['BaseViewId'];
    },
    get_contentTypeId: function SP_View$get_contentTypeId() {
        this.checkUninitializedProperty('ContentTypeId');
        return ((this.get_objectData()).get_properties())['ContentTypeId'];
    },
    set_contentTypeId: function SP_View$set_contentTypeId(value) {
        ((this.get_objectData()).get_properties())['ContentTypeId'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ContentTypeId', value));
        }
        return value;
    },
    get_defaultView: function SP_View$get_defaultView() {
        this.checkUninitializedProperty('DefaultView');
        return ((this.get_objectData()).get_properties())['DefaultView'];
    },
    set_defaultView: function SP_View$set_defaultView(value) {
        ((this.get_objectData()).get_properties())['DefaultView'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DefaultView', value));
        }
        return value;
    },
    get_defaultViewForContentType: function SP_View$get_defaultViewForContentType() {
        this.checkUninitializedProperty('DefaultViewForContentType');
        return ((this.get_objectData()).get_properties())['DefaultViewForContentType'];
    },
    set_defaultViewForContentType: function SP_View$set_defaultViewForContentType(value) {
        ((this.get_objectData()).get_properties())['DefaultViewForContentType'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'DefaultViewForContentType', value));
        }
        return value;
    },
    get_editorModified: function SP_View$get_editorModified() {
        this.checkUninitializedProperty('EditorModified');
        return ((this.get_objectData()).get_properties())['EditorModified'];
    },
    set_editorModified: function SP_View$set_editorModified(value) {
        ((this.get_objectData()).get_properties())['EditorModified'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EditorModified', value));
        }
        return value;
    },
    get_formats: function SP_View$get_formats() {
        this.checkUninitializedProperty('Formats');
        return ((this.get_objectData()).get_properties())['Formats'];
    },
    set_formats: function SP_View$set_formats(value) {
        ((this.get_objectData()).get_properties())['Formats'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Formats', value));
        }
        return value;
    },
    get_hidden: function SP_View$get_hidden() {
        this.checkUninitializedProperty('Hidden');
        return ((this.get_objectData()).get_properties())['Hidden'];
    },
    set_hidden: function SP_View$set_hidden(value) {
        ((this.get_objectData()).get_properties())['Hidden'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Hidden', value));
        }
        return value;
    },
    get_htmlSchemaXml: function SP_View$get_htmlSchemaXml() {
        this.checkUninitializedProperty('HtmlSchemaXml');
        return ((this.get_objectData()).get_properties())['HtmlSchemaXml'];
    },
    get_id: function SP_View$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_imageUrl: function SP_View$get_imageUrl() {
        this.checkUninitializedProperty('ImageUrl');
        return ((this.get_objectData()).get_properties())['ImageUrl'];
    },
    get_includeRootFolder: function SP_View$get_includeRootFolder() {
        this.checkUninitializedProperty('IncludeRootFolder');
        return ((this.get_objectData()).get_properties())['IncludeRootFolder'];
    },
    set_includeRootFolder: function SP_View$set_includeRootFolder(value) {
        ((this.get_objectData()).get_properties())['IncludeRootFolder'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IncludeRootFolder', value));
        }
        return value;
    },
    get_viewJoins: function SP_View$get_viewJoins() {
        this.checkUninitializedProperty('ViewJoins');
        return ((this.get_objectData()).get_properties())['ViewJoins'];
    },
    set_viewJoins: function SP_View$set_viewJoins(value) {
        ((this.get_objectData()).get_properties())['ViewJoins'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ViewJoins', value));
        }
        return value;
    },
    get_jsLink: function SP_View$get_jsLink() {
        this.checkUninitializedProperty('JSLink');
        return ((this.get_objectData()).get_properties())['JSLink'];
    },
    set_jsLink: function SP_View$set_jsLink(value) {
        ((this.get_objectData()).get_properties())['JSLink'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'JSLink', value));
        }
        return value;
    },
    get_listViewXml: function SP_View$get_listViewXml() {
        this.checkUninitializedProperty('ListViewXml');
        return ((this.get_objectData()).get_properties())['ListViewXml'];
    },
    set_listViewXml: function SP_View$set_listViewXml(value) {
        ((this.get_objectData()).get_properties())['ListViewXml'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ListViewXml', value));
        }
        return value;
    },
    get_method: function SP_View$get_method() {
        this.checkUninitializedProperty('Method');
        return ((this.get_objectData()).get_properties())['Method'];
    },
    set_method: function SP_View$set_method(value) {
        ((this.get_objectData()).get_properties())['Method'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Method', value));
        }
        return value;
    },
    get_mobileDefaultView: function SP_View$get_mobileDefaultView() {
        this.checkUninitializedProperty('MobileDefaultView');
        return ((this.get_objectData()).get_properties())['MobileDefaultView'];
    },
    set_mobileDefaultView: function SP_View$set_mobileDefaultView(value) {
        ((this.get_objectData()).get_properties())['MobileDefaultView'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MobileDefaultView', value));
        }
        return value;
    },
    get_mobileView: function SP_View$get_mobileView() {
        this.checkUninitializedProperty('MobileView');
        return ((this.get_objectData()).get_properties())['MobileView'];
    },
    set_mobileView: function SP_View$set_mobileView(value) {
        ((this.get_objectData()).get_properties())['MobileView'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MobileView', value));
        }
        return value;
    },
    get_moderationType: function SP_View$get_moderationType() {
        this.checkUninitializedProperty('ModerationType');
        return ((this.get_objectData()).get_properties())['ModerationType'];
    },
    get_orderedView: function SP_View$get_orderedView() {
        this.checkUninitializedProperty('OrderedView');
        return ((this.get_objectData()).get_properties())['OrderedView'];
    },
    get_paged: function SP_View$get_paged() {
        this.checkUninitializedProperty('Paged');
        return ((this.get_objectData()).get_properties())['Paged'];
    },
    set_paged: function SP_View$set_paged(value) {
        ((this.get_objectData()).get_properties())['Paged'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Paged', value));
        }
        return value;
    },
    get_personalView: function SP_View$get_personalView() {
        this.checkUninitializedProperty('PersonalView');
        return ((this.get_objectData()).get_properties())['PersonalView'];
    },
    get_viewProjectedFields: function SP_View$get_viewProjectedFields() {
        this.checkUninitializedProperty('ViewProjectedFields');
        return ((this.get_objectData()).get_properties())['ViewProjectedFields'];
    },
    set_viewProjectedFields: function SP_View$set_viewProjectedFields(value) {
        ((this.get_objectData()).get_properties())['ViewProjectedFields'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ViewProjectedFields', value));
        }
        return value;
    },
    get_viewQuery: function SP_View$get_viewQuery() {
        this.checkUninitializedProperty('ViewQuery');
        return ((this.get_objectData()).get_properties())['ViewQuery'];
    },
    set_viewQuery: function SP_View$set_viewQuery(value) {
        ((this.get_objectData()).get_properties())['ViewQuery'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ViewQuery', value));
        }
        return value;
    },
    get_readOnlyView: function SP_View$get_readOnlyView() {
        this.checkUninitializedProperty('ReadOnlyView');
        return ((this.get_objectData()).get_properties())['ReadOnlyView'];
    },
    get_requiresClientIntegration: function SP_View$get_requiresClientIntegration() {
        this.checkUninitializedProperty('RequiresClientIntegration');
        return ((this.get_objectData()).get_properties())['RequiresClientIntegration'];
    },
    get_rowLimit: function SP_View$get_rowLimit() {
        this.checkUninitializedProperty('RowLimit');
        return ((this.get_objectData()).get_properties())['RowLimit'];
    },
    set_rowLimit: function SP_View$set_rowLimit(value) {
        ((this.get_objectData()).get_properties())['RowLimit'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'RowLimit', value));
        }
        return value;
    },
    get_scope: function SP_View$get_scope() {
        this.checkUninitializedProperty('Scope');
        return ((this.get_objectData()).get_properties())['Scope'];
    },
    set_scope: function SP_View$set_scope(value) {
        ((this.get_objectData()).get_properties())['Scope'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Scope', value));
        }
        return value;
    },
    get_serverRelativeUrl: function SP_View$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    get_styleId: function SP_View$get_styleId() {
        this.checkUninitializedProperty('StyleId');
        return ((this.get_objectData()).get_properties())['StyleId'];
    },
    get_threaded: function SP_View$get_threaded() {
        this.checkUninitializedProperty('Threaded');
        return ((this.get_objectData()).get_properties())['Threaded'];
    },
    get_title: function SP_View$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    set_title: function SP_View$set_title(value) {
        ((this.get_objectData()).get_properties())['Title'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Title', value));
        }
        return value;
    },
    get_toolbar: function SP_View$get_toolbar() {
        this.checkUninitializedProperty('Toolbar');
        return ((this.get_objectData()).get_properties())['Toolbar'];
    },
    set_toolbar: function SP_View$set_toolbar(value) {
        ((this.get_objectData()).get_properties())['Toolbar'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Toolbar', value));
        }
        return value;
    },
    get_toolbarTemplateName: function SP_View$get_toolbarTemplateName() {
        this.checkUninitializedProperty('ToolbarTemplateName');
        return ((this.get_objectData()).get_properties())['ToolbarTemplateName'];
    },
    get_viewType: function SP_View$get_viewType() {
        this.checkUninitializedProperty('ViewType');
        return ((this.get_objectData()).get_properties())['ViewType'];
    },
    get_viewData: function SP_View$get_viewData() {
        this.checkUninitializedProperty('ViewData');
        return ((this.get_objectData()).get_properties())['ViewData'];
    },
    set_viewData: function SP_View$set_viewData(value) {
        ((this.get_objectData()).get_properties())['ViewData'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ViewData', value));
        }
        return value;
    },
    get_viewFields: function SP_View$get_viewFields() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ViewFields'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ViewFieldCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ViewFields'));
            ((this.get_objectData()).get_clientObjectProperties())['ViewFields'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_View$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Aggregations;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Aggregations'] = $v_0;
            delete parentNode.Aggregations;
        }
        $v_0 = parentNode.AggregationsStatus;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AggregationsStatus'] = $v_0;
            delete parentNode.AggregationsStatus;
        }
        $v_0 = parentNode.BaseViewId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['BaseViewId'] = $v_0;
            delete parentNode.BaseViewId;
        }
        $v_0 = parentNode.ContentTypeId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContentTypeId'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.ContentTypeId;
        }
        $v_0 = parentNode.DefaultView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefaultView'] = $v_0;
            delete parentNode.DefaultView;
        }
        $v_0 = parentNode.DefaultViewForContentType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DefaultViewForContentType'] = $v_0;
            delete parentNode.DefaultViewForContentType;
        }
        $v_0 = parentNode.EditorModified;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EditorModified'] = $v_0;
            delete parentNode.EditorModified;
        }
        $v_0 = parentNode.Formats;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Formats'] = $v_0;
            delete parentNode.Formats;
        }
        $v_0 = parentNode.Hidden;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Hidden'] = $v_0;
            delete parentNode.Hidden;
        }
        $v_0 = parentNode.HtmlSchemaXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['HtmlSchemaXml'] = $v_0;
            delete parentNode.HtmlSchemaXml;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.ImageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ImageUrl'] = $v_0;
            delete parentNode.ImageUrl;
        }
        $v_0 = parentNode.IncludeRootFolder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IncludeRootFolder'] = $v_0;
            delete parentNode.IncludeRootFolder;
        }
        $v_0 = parentNode.ViewJoins;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ViewJoins'] = $v_0;
            delete parentNode.ViewJoins;
        }
        $v_0 = parentNode.JSLink;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['JSLink'] = $v_0;
            delete parentNode.JSLink;
        }
        $v_0 = parentNode.ListViewXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ListViewXml'] = $v_0;
            delete parentNode.ListViewXml;
        }
        $v_0 = parentNode.Method;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Method'] = $v_0;
            delete parentNode.Method;
        }
        $v_0 = parentNode.MobileDefaultView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MobileDefaultView'] = $v_0;
            delete parentNode.MobileDefaultView;
        }
        $v_0 = parentNode.MobileView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MobileView'] = $v_0;
            delete parentNode.MobileView;
        }
        $v_0 = parentNode.ModerationType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ModerationType'] = $v_0;
            delete parentNode.ModerationType;
        }
        $v_0 = parentNode.OrderedView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['OrderedView'] = $v_0;
            delete parentNode.OrderedView;
        }
        $v_0 = parentNode.Paged;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Paged'] = $v_0;
            delete parentNode.Paged;
        }
        $v_0 = parentNode.PersonalView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['PersonalView'] = $v_0;
            delete parentNode.PersonalView;
        }
        $v_0 = parentNode.ViewProjectedFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ViewProjectedFields'] = $v_0;
            delete parentNode.ViewProjectedFields;
        }
        $v_0 = parentNode.ViewQuery;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ViewQuery'] = $v_0;
            delete parentNode.ViewQuery;
        }
        $v_0 = parentNode.ReadOnlyView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ReadOnlyView'] = $v_0;
            delete parentNode.ReadOnlyView;
        }
        $v_0 = parentNode.RequiresClientIntegration;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RequiresClientIntegration'] = $v_0;
            delete parentNode.RequiresClientIntegration;
        }
        $v_0 = parentNode.RowLimit;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RowLimit'] = $v_0;
            delete parentNode.RowLimit;
        }
        $v_0 = parentNode.Scope;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Scope'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.Scope;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.StyleId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['StyleId'] = $v_0;
            delete parentNode.StyleId;
        }
        $v_0 = parentNode.Threaded;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Threaded'] = $v_0;
            delete parentNode.Threaded;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.Toolbar;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Toolbar'] = $v_0;
            delete parentNode.Toolbar;
        }
        $v_0 = parentNode.ToolbarTemplateName;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ToolbarTemplateName'] = $v_0;
            delete parentNode.ToolbarTemplateName;
        }
        $v_0 = parentNode.ViewType;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ViewType'] = $v_0;
            delete parentNode.ViewType;
        }
        $v_0 = parentNode.ViewData;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ViewData'] = $v_0;
            delete parentNode.ViewData;
        }
        $v_0 = parentNode.ViewFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ViewFields', this.get_viewFields(), $v_0);
            (this.get_viewFields()).fromJson($v_0);
            delete parentNode.ViewFields;
        }
    },
    deleteObject: function SP_View$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    },
    renderAsHtml: function SP_View$renderAsHtml() {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'RenderAsHtml', null);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    update: function SP_View$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    }
};
SP.ViewPropertyNames = function SP_ViewPropertyNames() {
};
SP.ViewObjectPropertyNames = function SP_ViewObjectPropertyNames() {
};
SP.ViewCollection = function SP_ViewCollection(context, objectPath) {
    SP.ViewCollection.initializeBase(this, [context, objectPath]);
};
SP.ViewCollection.prototype = {
    itemAt: function SP_ViewCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ViewCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ViewCollection$get_childItemType() {
        return SP.View;
    },
    getByTitle: function SP_ViewCollection$getByTitle(strTitle) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByTitle'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByTitle'] = $v_2;
        }
        $v_1 = $v_2[strTitle];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.View($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByTitle', [strTitle]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[strTitle] = $v_1;
        }
        return $v_1;
    },
    getById: function SP_ViewCollection$getById(guidId) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetById'] = $v_2;
        }
        $v_1 = $v_2[guidId.toString()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.View($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetById', [guidId]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[guidId.toString()] = $v_1;
        }
        return $v_1;
    },
    add: function SP_ViewCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.View($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_1(parameters);
        return $v_1;
    }
};
SP.ViewCreationInformation = function SP_ViewCreationInformation() {
    SP.ViewCreationInformation.initializeBase(this);
};
SP.ViewCreationInformation.prototype = {
    $1Y_1: false,
    $4V_1: false,
    $m_1: null,
    $o_1: 30,
    $4l_1: false,
    $0_1: null,
    $s_1: null,
    $5R_1: 0,
    get_paged: function SP_ViewCreationInformation$get_paged() {
        return this.$1Y_1;
    },
    set_paged: function SP_ViewCreationInformation$set_paged(value) {
        this.$1Y_1 = value;
        return value;
    },
    get_personalView: function SP_ViewCreationInformation$get_personalView() {
        return this.$4V_1;
    },
    set_personalView: function SP_ViewCreationInformation$set_personalView(value) {
        this.$4V_1 = value;
        return value;
    },
    get_query: function SP_ViewCreationInformation$get_query() {
        return this.$m_1;
    },
    set_query: function SP_ViewCreationInformation$set_query(value) {
        this.$m_1 = value;
        return value;
    },
    get_rowLimit: function SP_ViewCreationInformation$get_rowLimit() {
        return this.$o_1;
    },
    set_rowLimit: function SP_ViewCreationInformation$set_rowLimit(value) {
        this.$o_1 = value;
        return value;
    },
    get_setAsDefaultView: function SP_ViewCreationInformation$get_setAsDefaultView() {
        return this.$4l_1;
    },
    set_setAsDefaultView: function SP_ViewCreationInformation$set_setAsDefaultView(value) {
        this.$4l_1 = value;
        return value;
    },
    get_title: function SP_ViewCreationInformation$get_title() {
        return this.$0_1;
    },
    set_title: function SP_ViewCreationInformation$set_title(value) {
        this.$0_1 = value;
        return value;
    },
    get_viewFields: function SP_ViewCreationInformation$get_viewFields() {
        return this.$s_1;
    },
    set_viewFields: function SP_ViewCreationInformation$set_viewFields(value) {
        this.$s_1 = value;
        return value;
    },
    get_viewTypeKind: function SP_ViewCreationInformation$get_viewTypeKind() {
        return this.$5R_1;
    },
    set_viewTypeKind: function SP_ViewCreationInformation$set_viewTypeKind(value) {
        this.$5R_1 = value;
        return value;
    },
    get_typeId: function SP_ViewCreationInformation$get_typeId() {
        return '{a3547807-7266-42f3-b055-afa6e840e458}';
    },
    writeToXml: function SP_ViewCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Paged', 'PersonalView', 'Query', 'RowLimit', 'SetAsDefaultView', 'Title', 'ViewFields', 'ViewTypeKind'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_ViewCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Paged;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1Y_1 = $v_0;
            delete parentNode.Paged;
        }
        $v_0 = parentNode.PersonalView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4V_1 = $v_0;
            delete parentNode.PersonalView;
        }
        $v_0 = parentNode.Query;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$m_1 = $v_0;
            delete parentNode.Query;
        }
        $v_0 = parentNode.RowLimit;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$o_1 = $v_0;
            delete parentNode.RowLimit;
        }
        $v_0 = parentNode.SetAsDefaultView;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4l_1 = $v_0;
            delete parentNode.SetAsDefaultView;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.ViewFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$s_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.ViewFields;
        }
        $v_0 = parentNode.ViewTypeKind;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5R_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.ViewTypeKind;
        }
    }
};
SP.ViewFieldCollection = function SP_ViewFieldCollection(context, objectPath) {
    SP.ViewFieldCollection.initializeBase(this, [context, objectPath]);
};
SP.ViewFieldCollection.prototype = {
    itemAt: function SP_ViewFieldCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_ViewFieldCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_ViewFieldCollection$get_childItemType() {
        return String;
    },
    $7p_2: function SP_ViewFieldCollection$$7p_2($p0) {
        Array.add(this.get_data(), $p0);
    },
    $7x_2: function SP_ViewFieldCollection$$7x_2($p0) {
        Array.remove(this.get_data(), $p0);
    },
    $7L_2: function SP_ViewFieldCollection$$7L_2() {
        var $v_0 = this.get_data();

        while ($v_0.length > 0) {
            Array.removeAt($v_0, $v_0.length - 1);
        }
    },
    get_schemaXml: function SP_ViewFieldCollection$get_schemaXml() {
        this.checkUninitializedProperty('SchemaXml');
        return ((this.get_objectData()).get_properties())['SchemaXml'];
    },
    initPropertiesFromJson: function SP_ViewFieldCollection$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.SchemaXml;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SchemaXml'] = $v_0;
            delete parentNode.SchemaXml;
        }
    },
    moveFieldTo: function SP_ViewFieldCollection$moveFieldTo(field, index) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'MoveFieldTo', [field, index]);

        $v_0.addQuery($v_1);
    },
    add: function SP_ViewFieldCollection$add(strField) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Add', [strField]);

        $v_0.addQuery($v_1);
        this.$7p_2(strField);
    },
    remove: function SP_ViewFieldCollection$remove(strField) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Remove', [strField]);

        $v_0.addQuery($v_1);
        this.$7x_2(strField);
    },
    removeAll: function SP_ViewFieldCollection$removeAll() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RemoveAll', null);

        $v_0.addQuery($v_1);
        this.$7L_2();
    }
};
SP.ViewFieldCollectionPropertyNames = function SP_ViewFieldCollectionPropertyNames() {
};
SP.Web = function SP_Web(context, objectPath) {
    SP.Web.initializeBase(this, [context, objectPath]);
};
SP.Web.createAnonymousLinkWithExpiration = function SP_Web$createAnonymousLinkWithExpiration(context, url, isEditLink, expirationString) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'CreateAnonymousLinkWithExpiration', [url, isEditLink, expirationString]);

    context.addQuery($v_1);
    $v_0 = new SP.StringResult();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.Web.deleteAllAnonymousLinksForObject = function SP_Web$deleteAllAnonymousLinksForObject(context, url) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'DeleteAllAnonymousLinksForObject', [url]);

    context.addQuery($v_0);
};
SP.Web.deleteAnonymousLinkForObject = function SP_Web$deleteAnonymousLinkForObject(context, url, isEditLink, removeAssociatedSharingLinkGroup) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'DeleteAnonymousLinkForObject', [url, isEditLink, removeAssociatedSharingLinkGroup]);

    context.addQuery($v_0);
};
SP.Web.createOrganizationSharingLink = function SP_Web$createOrganizationSharingLink(context, url, isEditLink) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'CreateOrganizationSharingLink', [url, isEditLink]);

    context.addQuery($v_1);
    $v_0 = new SP.StringResult();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.Web.destroyOrganizationSharingLink = function SP_Web$destroyOrganizationSharingLink(context, url, isEditLink, removeAssociatedSharingLinkGroup) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'DestroyOrganizationSharingLink', [url, isEditLink, removeAssociatedSharingLinkGroup]);

    context.addQuery($v_0);
};
SP.Web.shareObject = function SP_Web$shareObject(context, url, peoplePickerInput, roleValue, groupId, propagateAcl, sendEmail, includeAnonymousLinkInEmail, emailSubject, emailBody, useSimplifiedRoles) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.SharingResult(context, new SP.ObjectPathStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'ShareObject', [url, peoplePickerInput, roleValue, groupId, propagateAcl, sendEmail, includeAnonymousLinkInEmail, emailSubject, emailBody, useSimplifiedRoles]));
    return $v_0;
};
SP.Web.forwardObjectLink = function SP_Web$forwardObjectLink(context, url, peoplePickerInput, emailSubject, emailBody) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.SharingResult(context, new SP.ObjectPathStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'ForwardObjectLink', [url, peoplePickerInput, emailSubject, emailBody]));
    return $v_0;
};
SP.Web.unshareObject = function SP_Web$unshareObject(context, url) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.SharingResult(context, new SP.ObjectPathStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'UnshareObject', [url]));
    return $v_0;
};
SP.Web.getObjectSharingSettings = function SP_Web$getObjectSharingSettings(context, objectUrl, groupId, useSimplifiedRoles) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ObjectSharingSettings(context, new SP.ObjectPathStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'GetObjectSharingSettings', [objectUrl, groupId, useSimplifiedRoles]));
    return $v_0;
};
SP.Web.createAnonymousLink = function SP_Web$createAnonymousLink(context, url, isEditLink) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'CreateAnonymousLink', [url, isEditLink]);

    context.addQuery($v_1);
    $v_0 = new SP.StringResult();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.Web.getDocumentLibraries = function SP_Web$getDocumentLibraries(context, webFullUrl) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{a489add2-5d3a-4de8-9445-49259462dceb}', 'GetDocumentLibraries', [webFullUrl]);

    context.addQuery($v_1);
    $v_0 = [];
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.Web.prototype = {
    $F_2: function SP_Web$$F_2($p0) {
        if ($p0) {
            ((this.get_objectData()).get_properties())['Description'] = $p0.$2_1;
            ((this.get_objectData()).get_properties())['Title'] = $p0.$0_1;
        }
    },
    get_allowCreateDeclarativeWorkflowForCurrentUser: function SP_Web$get_allowCreateDeclarativeWorkflowForCurrentUser() {
        this.checkUninitializedProperty('AllowCreateDeclarativeWorkflowForCurrentUser');
        return ((this.get_objectData()).get_properties())['AllowCreateDeclarativeWorkflowForCurrentUser'];
    },
    get_allowDesignerForCurrentUser: function SP_Web$get_allowDesignerForCurrentUser() {
        this.checkUninitializedProperty('AllowDesignerForCurrentUser');
        return ((this.get_objectData()).get_properties())['AllowDesignerForCurrentUser'];
    },
    get_allowMasterPageEditingForCurrentUser: function SP_Web$get_allowMasterPageEditingForCurrentUser() {
        this.checkUninitializedProperty('AllowMasterPageEditingForCurrentUser');
        return ((this.get_objectData()).get_properties())['AllowMasterPageEditingForCurrentUser'];
    },
    get_allowRevertFromTemplateForCurrentUser: function SP_Web$get_allowRevertFromTemplateForCurrentUser() {
        this.checkUninitializedProperty('AllowRevertFromTemplateForCurrentUser');
        return ((this.get_objectData()).get_properties())['AllowRevertFromTemplateForCurrentUser'];
    },
    get_allowRssFeeds: function SP_Web$get_allowRssFeeds() {
        this.checkUninitializedProperty('AllowRssFeeds');
        return ((this.get_objectData()).get_properties())['AllowRssFeeds'];
    },
    get_allowSaveDeclarativeWorkflowAsTemplateForCurrentUser: function SP_Web$get_allowSaveDeclarativeWorkflowAsTemplateForCurrentUser() {
        this.checkUninitializedProperty('AllowSaveDeclarativeWorkflowAsTemplateForCurrentUser');
        return ((this.get_objectData()).get_properties())['AllowSaveDeclarativeWorkflowAsTemplateForCurrentUser'];
    },
    get_allowSavePublishDeclarativeWorkflowForCurrentUser: function SP_Web$get_allowSavePublishDeclarativeWorkflowForCurrentUser() {
        this.checkUninitializedProperty('AllowSavePublishDeclarativeWorkflowForCurrentUser');
        return ((this.get_objectData()).get_properties())['AllowSavePublishDeclarativeWorkflowForCurrentUser'];
    },
    get_allProperties: function SP_Web$get_allProperties() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['AllProperties'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.PropertyValues(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'AllProperties'));
            ((this.get_objectData()).get_clientObjectProperties())['AllProperties'] = $v_0;
        }
        return $v_0;
    },
    get_alternateCssUrl: function SP_Web$get_alternateCssUrl() {
        this.checkUninitializedProperty('AlternateCssUrl');
        return ((this.get_objectData()).get_properties())['AlternateCssUrl'];
    },
    set_alternateCssUrl: function SP_Web$set_alternateCssUrl(value) {
        ((this.get_objectData()).get_properties())['AlternateCssUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AlternateCssUrl', value));
        }
        return value;
    },
    get_appInstanceId: function SP_Web$get_appInstanceId() {
        this.checkUninitializedProperty('AppInstanceId');
        return ((this.get_objectData()).get_properties())['AppInstanceId'];
    },
    get_appTiles: function SP_Web$get_appTiles() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['AppTiles'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.AppTileCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'AppTiles'));
            ((this.get_objectData()).get_clientObjectProperties())['AppTiles'] = $v_0;
        }
        return $v_0;
    },
    get_associatedMemberGroup: function SP_Web$get_associatedMemberGroup() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['AssociatedMemberGroup'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Group(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'AssociatedMemberGroup'));
            ((this.get_objectData()).get_clientObjectProperties())['AssociatedMemberGroup'] = $v_0;
        }
        return $v_0;
    },
    set_associatedMemberGroup: function SP_Web$set_associatedMemberGroup(value) {
        ((this.get_objectData()).get_clientObjectProperties())['AssociatedMemberGroup'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AssociatedMemberGroup', value));
        }
        return value;
    },
    get_associatedOwnerGroup: function SP_Web$get_associatedOwnerGroup() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['AssociatedOwnerGroup'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Group(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'AssociatedOwnerGroup'));
            ((this.get_objectData()).get_clientObjectProperties())['AssociatedOwnerGroup'] = $v_0;
        }
        return $v_0;
    },
    set_associatedOwnerGroup: function SP_Web$set_associatedOwnerGroup(value) {
        ((this.get_objectData()).get_clientObjectProperties())['AssociatedOwnerGroup'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AssociatedOwnerGroup', value));
        }
        return value;
    },
    get_associatedVisitorGroup: function SP_Web$get_associatedVisitorGroup() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['AssociatedVisitorGroup'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Group(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'AssociatedVisitorGroup'));
            ((this.get_objectData()).get_clientObjectProperties())['AssociatedVisitorGroup'] = $v_0;
        }
        return $v_0;
    },
    set_associatedVisitorGroup: function SP_Web$set_associatedVisitorGroup(value) {
        ((this.get_objectData()).get_clientObjectProperties())['AssociatedVisitorGroup'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'AssociatedVisitorGroup', value));
        }
        return value;
    },
    get_availableContentTypes: function SP_Web$get_availableContentTypes() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['AvailableContentTypes'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ContentTypeCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'AvailableContentTypes'));
            ((this.get_objectData()).get_clientObjectProperties())['AvailableContentTypes'] = $v_0;
        }
        return $v_0;
    },
    get_availableFields: function SP_Web$get_availableFields() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['AvailableFields'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FieldCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'AvailableFields'));
            ((this.get_objectData()).get_clientObjectProperties())['AvailableFields'] = $v_0;
        }
        return $v_0;
    },
    get_configuration: function SP_Web$get_configuration() {
        this.checkUninitializedProperty('Configuration');
        return ((this.get_objectData()).get_properties())['Configuration'];
    },
    get_containsConfidentialInfo: function SP_Web$get_containsConfidentialInfo() {
        this.checkUninitializedProperty('ContainsConfidentialInfo');
        return ((this.get_objectData()).get_properties())['ContainsConfidentialInfo'];
    },
    set_containsConfidentialInfo: function SP_Web$set_containsConfidentialInfo(value) {
        ((this.get_objectData()).get_properties())['ContainsConfidentialInfo'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ContainsConfidentialInfo', value));
        }
        return value;
    },
    get_contentTypes: function SP_Web$get_contentTypes() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ContentTypes'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ContentTypeCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ContentTypes'));
            ((this.get_objectData()).get_clientObjectProperties())['ContentTypes'] = $v_0;
        }
        return $v_0;
    },
    get_created: function SP_Web$get_created() {
        this.checkUninitializedProperty('Created');
        return ((this.get_objectData()).get_properties())['Created'];
    },
    get_currentChangeToken: function SP_Web$get_currentChangeToken() {
        this.checkUninitializedProperty('CurrentChangeToken');
        return ((this.get_objectData()).get_properties())['CurrentChangeToken'];
    },
    get_currentUser: function SP_Web$get_currentUser() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['CurrentUser'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.User(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'CurrentUser'));
            ((this.get_objectData()).get_clientObjectProperties())['CurrentUser'] = $v_0;
        }
        return $v_0;
    },
    get_customMasterUrl: function SP_Web$get_customMasterUrl() {
        this.checkUninitializedProperty('CustomMasterUrl');
        return ((this.get_objectData()).get_properties())['CustomMasterUrl'];
    },
    set_customMasterUrl: function SP_Web$set_customMasterUrl(value) {
        ((this.get_objectData()).get_properties())['CustomMasterUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'CustomMasterUrl', value));
        }
        return value;
    },
    get_dataLeakagePreventionStatusInfo: function SP_Web$get_dataLeakagePreventionStatusInfo() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['DataLeakagePreventionStatusInfo'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.SPDataLeakagePreventionStatusInfo(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'DataLeakagePreventionStatusInfo'));
            ((this.get_objectData()).get_clientObjectProperties())['DataLeakagePreventionStatusInfo'] = $v_0;
        }
        return $v_0;
    },
    get_description: function SP_Web$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    set_description: function SP_Web$set_description(value) {
        ((this.get_objectData()).get_properties())['Description'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Description', value));
        }
        return value;
    },
    get_descriptionResource: function SP_Web$get_descriptionResource() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['DescriptionResource'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserResource(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'DescriptionResource'));
            ((this.get_objectData()).get_clientObjectProperties())['DescriptionResource'] = $v_0;
        }
        return $v_0;
    },
    get_designerDownloadUrlForCurrentUser: function SP_Web$get_designerDownloadUrlForCurrentUser() {
        this.checkUninitializedProperty('DesignerDownloadUrlForCurrentUser');
        return ((this.get_objectData()).get_properties())['DesignerDownloadUrlForCurrentUser'];
    },
    get_documentLibraryCalloutOfficeWebAppPreviewersDisabled: function SP_Web$get_documentLibraryCalloutOfficeWebAppPreviewersDisabled() {
        this.checkUninitializedProperty('DocumentLibraryCalloutOfficeWebAppPreviewersDisabled');
        return ((this.get_objectData()).get_properties())['DocumentLibraryCalloutOfficeWebAppPreviewersDisabled'];
    },
    get_effectiveBasePermissions: function SP_Web$get_effectiveBasePermissions() {
        this.checkUninitializedProperty('EffectiveBasePermissions');
        return ((this.get_objectData()).get_properties())['EffectiveBasePermissions'];
    },
    get_enableMinimalDownload: function SP_Web$get_enableMinimalDownload() {
        this.checkUninitializedProperty('EnableMinimalDownload');
        return ((this.get_objectData()).get_properties())['EnableMinimalDownload'];
    },
    set_enableMinimalDownload: function SP_Web$set_enableMinimalDownload(value) {
        ((this.get_objectData()).get_properties())['EnableMinimalDownload'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'EnableMinimalDownload', value));
        }
        return value;
    },
    get_eventReceivers: function SP_Web$get_eventReceivers() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['EventReceivers'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.EventReceiverDefinitionCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'EventReceivers'));
            ((this.get_objectData()).get_clientObjectProperties())['EventReceivers'] = $v_0;
        }
        return $v_0;
    },
    get_features: function SP_Web$get_features() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Features'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FeatureCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Features'));
            ((this.get_objectData()).get_clientObjectProperties())['Features'] = $v_0;
        }
        return $v_0;
    },
    get_fields: function SP_Web$get_fields() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Fields'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FieldCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Fields'));
            ((this.get_objectData()).get_clientObjectProperties())['Fields'] = $v_0;
        }
        return $v_0;
    },
    get_folders: function SP_Web$get_folders() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Folders'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.FolderCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Folders'));
            ((this.get_objectData()).get_clientObjectProperties())['Folders'] = $v_0;
        }
        return $v_0;
    },
    get_id: function SP_Web$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_isMultilingual: function SP_Web$get_isMultilingual() {
        this.checkUninitializedProperty('IsMultilingual');
        return ((this.get_objectData()).get_properties())['IsMultilingual'];
    },
    set_isMultilingual: function SP_Web$set_isMultilingual(value) {
        ((this.get_objectData()).get_properties())['IsMultilingual'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'IsMultilingual', value));
        }
        return value;
    },
    get_language: function SP_Web$get_language() {
        this.checkUninitializedProperty('Language');
        return ((this.get_objectData()).get_properties())['Language'];
    },
    get_lastItemModifiedDate: function SP_Web$get_lastItemModifiedDate() {
        this.checkUninitializedProperty('LastItemModifiedDate');
        return ((this.get_objectData()).get_properties())['LastItemModifiedDate'];
    },
    get_lists: function SP_Web$get_lists() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Lists'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ListCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Lists'));
            ((this.get_objectData()).get_clientObjectProperties())['Lists'] = $v_0;
        }
        return $v_0;
    },
    get_listTemplates: function SP_Web$get_listTemplates() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ListTemplates'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ListTemplateCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ListTemplates'));
            ((this.get_objectData()).get_clientObjectProperties())['ListTemplates'] = $v_0;
        }
        return $v_0;
    },
    get_masterUrl: function SP_Web$get_masterUrl() {
        this.checkUninitializedProperty('MasterUrl');
        return ((this.get_objectData()).get_properties())['MasterUrl'];
    },
    set_masterUrl: function SP_Web$set_masterUrl(value) {
        ((this.get_objectData()).get_properties())['MasterUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MasterUrl', value));
        }
        return value;
    },
    get_membersCanShare: function SP_Web$get_membersCanShare() {
        this.checkUninitializedProperty('MembersCanShare');
        return ((this.get_objectData()).get_properties())['MembersCanShare'];
    },
    set_membersCanShare: function SP_Web$set_membersCanShare(value) {
        ((this.get_objectData()).get_properties())['MembersCanShare'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'MembersCanShare', value));
        }
        return value;
    },
    get_navigation: function SP_Web$get_navigation() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Navigation'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Navigation(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Navigation'));
            ((this.get_objectData()).get_clientObjectProperties())['Navigation'] = $v_0;
        }
        return $v_0;
    },
    get_noCrawl: function SP_Web$get_noCrawl() {
        this.checkUninitializedProperty('NoCrawl');
        return ((this.get_objectData()).get_properties())['NoCrawl'];
    },
    set_noCrawl: function SP_Web$set_noCrawl(value) {
        ((this.get_objectData()).get_properties())['NoCrawl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'NoCrawl', value));
        }
        return value;
    },
    get_overwriteTranslationsOnChange: function SP_Web$get_overwriteTranslationsOnChange() {
        this.checkUninitializedProperty('OverwriteTranslationsOnChange');
        return ((this.get_objectData()).get_properties())['OverwriteTranslationsOnChange'];
    },
    set_overwriteTranslationsOnChange: function SP_Web$set_overwriteTranslationsOnChange(value) {
        ((this.get_objectData()).get_properties())['OverwriteTranslationsOnChange'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'OverwriteTranslationsOnChange', value));
        }
        return value;
    },
    get_parentWeb: function SP_Web$get_parentWeb() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ParentWeb'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.WebInformation(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ParentWeb'));
            ((this.get_objectData()).get_clientObjectProperties())['ParentWeb'] = $v_0;
        }
        return $v_0;
    },
    get_pushNotificationSubscribers: function SP_Web$get_pushNotificationSubscribers() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['PushNotificationSubscribers'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.PushNotificationSubscriberCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'PushNotificationSubscribers'));
            ((this.get_objectData()).get_clientObjectProperties())['PushNotificationSubscribers'] = $v_0;
        }
        return $v_0;
    },
    get_quickLaunchEnabled: function SP_Web$get_quickLaunchEnabled() {
        this.checkUninitializedProperty('QuickLaunchEnabled');
        return ((this.get_objectData()).get_properties())['QuickLaunchEnabled'];
    },
    set_quickLaunchEnabled: function SP_Web$set_quickLaunchEnabled(value) {
        ((this.get_objectData()).get_properties())['QuickLaunchEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'QuickLaunchEnabled', value));
        }
        return value;
    },
    get_recycleBin: function SP_Web$get_recycleBin() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RecycleBin'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.RecycleBinItemCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RecycleBin'));
            ((this.get_objectData()).get_clientObjectProperties())['RecycleBin'] = $v_0;
        }
        return $v_0;
    },
    get_recycleBinEnabled: function SP_Web$get_recycleBinEnabled() {
        this.checkUninitializedProperty('RecycleBinEnabled');
        return ((this.get_objectData()).get_properties())['RecycleBinEnabled'];
    },
    get_regionalSettings: function SP_Web$get_regionalSettings() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RegionalSettings'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.RegionalSettings(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RegionalSettings'));
            ((this.get_objectData()).get_clientObjectProperties())['RegionalSettings'] = $v_0;
        }
        return $v_0;
    },
    get_requestAccessEmail: function SP_Web$get_requestAccessEmail() {
        this.checkUninitializedProperty('RequestAccessEmail');
        return ((this.get_objectData()).get_properties())['RequestAccessEmail'];
    },
    set_requestAccessEmail: function SP_Web$set_requestAccessEmail(value) {
        ((this.get_objectData()).get_properties())['RequestAccessEmail'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'RequestAccessEmail', value));
        }
        return value;
    },
    get_roleDefinitions: function SP_Web$get_roleDefinitions() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RoleDefinitions'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.RoleDefinitionCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RoleDefinitions'));
            ((this.get_objectData()).get_clientObjectProperties())['RoleDefinitions'] = $v_0;
        }
        return $v_0;
    },
    get_rootFolder: function SP_Web$get_rootFolder() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['RootFolder'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Folder(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'RootFolder'));
            ((this.get_objectData()).get_clientObjectProperties())['RootFolder'] = $v_0;
        }
        return $v_0;
    },
    get_saveSiteAsTemplateEnabled: function SP_Web$get_saveSiteAsTemplateEnabled() {
        this.checkUninitializedProperty('SaveSiteAsTemplateEnabled');
        return ((this.get_objectData()).get_properties())['SaveSiteAsTemplateEnabled'];
    },
    set_saveSiteAsTemplateEnabled: function SP_Web$set_saveSiteAsTemplateEnabled(value) {
        ((this.get_objectData()).get_properties())['SaveSiteAsTemplateEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SaveSiteAsTemplateEnabled', value));
        }
        return value;
    },
    get_serverRelativeUrl: function SP_Web$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    set_serverRelativeUrl: function SP_Web$set_serverRelativeUrl(value) {
        ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'ServerRelativeUrl', value));
        }
        return value;
    },
    get_showUrlStructureForCurrentUser: function SP_Web$get_showUrlStructureForCurrentUser() {
        this.checkUninitializedProperty('ShowUrlStructureForCurrentUser');
        return ((this.get_objectData()).get_properties())['ShowUrlStructureForCurrentUser'];
    },
    get_siteGroups: function SP_Web$get_siteGroups() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['SiteGroups'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.GroupCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'SiteGroups'));
            ((this.get_objectData()).get_clientObjectProperties())['SiteGroups'] = $v_0;
        }
        return $v_0;
    },
    get_siteLogoUrl: function SP_Web$get_siteLogoUrl() {
        this.checkUninitializedProperty('SiteLogoUrl');
        return ((this.get_objectData()).get_properties())['SiteLogoUrl'];
    },
    set_siteLogoUrl: function SP_Web$set_siteLogoUrl(value) {
        ((this.get_objectData()).get_properties())['SiteLogoUrl'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SiteLogoUrl', value));
        }
        return value;
    },
    get_siteUserInfoList: function SP_Web$get_siteUserInfoList() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['SiteUserInfoList'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.List(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'SiteUserInfoList'));
            ((this.get_objectData()).get_clientObjectProperties())['SiteUserInfoList'] = $v_0;
        }
        return $v_0;
    },
    get_siteUsers: function SP_Web$get_siteUsers() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['SiteUsers'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'SiteUsers'));
            ((this.get_objectData()).get_clientObjectProperties())['SiteUsers'] = $v_0;
        }
        return $v_0;
    },
    get_supportedUILanguageIds: function SP_Web$get_supportedUILanguageIds() {
        this.checkUninitializedProperty('SupportedUILanguageIds');
        return ((this.get_objectData()).get_properties())['SupportedUILanguageIds'];
    },
    get_syndicationEnabled: function SP_Web$get_syndicationEnabled() {
        this.checkUninitializedProperty('SyndicationEnabled');
        return ((this.get_objectData()).get_properties())['SyndicationEnabled'];
    },
    set_syndicationEnabled: function SP_Web$set_syndicationEnabled(value) {
        ((this.get_objectData()).get_properties())['SyndicationEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'SyndicationEnabled', value));
        }
        return value;
    },
    get_themeInfo: function SP_Web$get_themeInfo() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['ThemeInfo'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.ThemeInfo(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'ThemeInfo'));
            ((this.get_objectData()).get_clientObjectProperties())['ThemeInfo'] = $v_0;
        }
        return $v_0;
    },
    get_thirdPartyMdmEnabled: function SP_Web$get_thirdPartyMdmEnabled() {
        this.checkUninitializedProperty('ThirdPartyMdmEnabled');
        return ((this.get_objectData()).get_properties())['ThirdPartyMdmEnabled'];
    },
    get_title: function SP_Web$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    set_title: function SP_Web$set_title(value) {
        ((this.get_objectData()).get_properties())['Title'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'Title', value));
        }
        return value;
    },
    get_titleResource: function SP_Web$get_titleResource() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['TitleResource'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserResource(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'TitleResource'));
            ((this.get_objectData()).get_clientObjectProperties())['TitleResource'] = $v_0;
        }
        return $v_0;
    },
    get_treeViewEnabled: function SP_Web$get_treeViewEnabled() {
        this.checkUninitializedProperty('TreeViewEnabled');
        return ((this.get_objectData()).get_properties())['TreeViewEnabled'];
    },
    set_treeViewEnabled: function SP_Web$set_treeViewEnabled(value) {
        ((this.get_objectData()).get_properties())['TreeViewEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'TreeViewEnabled', value));
        }
        return value;
    },
    get_uiVersion: function SP_Web$get_uiVersion() {
        this.checkUninitializedProperty('UIVersion');
        return ((this.get_objectData()).get_properties())['UIVersion'];
    },
    set_uiVersion: function SP_Web$set_uiVersion(value) {
        ((this.get_objectData()).get_properties())['UIVersion'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'UIVersion', value));
        }
        return value;
    },
    get_uiVersionConfigurationEnabled: function SP_Web$get_uiVersionConfigurationEnabled() {
        this.checkUninitializedProperty('UIVersionConfigurationEnabled');
        return ((this.get_objectData()).get_properties())['UIVersionConfigurationEnabled'];
    },
    set_uiVersionConfigurationEnabled: function SP_Web$set_uiVersionConfigurationEnabled(value) {
        ((this.get_objectData()).get_properties())['UIVersionConfigurationEnabled'] = value;
        if (this.get_context()) {
            (this.get_context()).addQuery(new SP.ClientActionSetProperty(this, 'UIVersionConfigurationEnabled', value));
        }
        return value;
    },
    get_url: function SP_Web$get_url() {
        this.checkUninitializedProperty('Url');
        return ((this.get_objectData()).get_properties())['Url'];
    },
    get_userCustomActions: function SP_Web$get_userCustomActions() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['UserCustomActions'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.UserCustomActionCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'UserCustomActions'));
            ((this.get_objectData()).get_clientObjectProperties())['UserCustomActions'] = $v_0;
        }
        return $v_0;
    },
    get_webs: function SP_Web$get_webs() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['Webs'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.WebCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'Webs'));
            ((this.get_objectData()).get_clientObjectProperties())['Webs'] = $v_0;
        }
        return $v_0;
    },
    get_webTemplate: function SP_Web$get_webTemplate() {
        this.checkUninitializedProperty('WebTemplate');
        return ((this.get_objectData()).get_properties())['WebTemplate'];
    },
    get_workflowAssociations: function SP_Web$get_workflowAssociations() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['WorkflowAssociations'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Workflow.WorkflowAssociationCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'WorkflowAssociations'));
            ((this.get_objectData()).get_clientObjectProperties())['WorkflowAssociations'] = $v_0;
        }
        return $v_0;
    },
    get_workflowTemplates: function SP_Web$get_workflowTemplates() {
        var $v_0 = ((this.get_objectData()).get_clientObjectProperties())['WorkflowTemplates'];

        if (SP.ScriptUtility.isUndefined($v_0)) {
            $v_0 = new SP.Workflow.WorkflowTemplateCollection(this.get_context(), new SP.ObjectPathProperty(this.get_context(), this.get_path(), 'WorkflowTemplates'));
            ((this.get_objectData()).get_clientObjectProperties())['WorkflowTemplates'] = $v_0;
        }
        return $v_0;
    },
    initPropertiesFromJson: function SP_Web$initPropertiesFromJson(parentNode) {
        SP.SecurableObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.AllowCreateDeclarativeWorkflowForCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowCreateDeclarativeWorkflowForCurrentUser'] = $v_0;
            delete parentNode.AllowCreateDeclarativeWorkflowForCurrentUser;
        }
        $v_0 = parentNode.AllowDesignerForCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowDesignerForCurrentUser'] = $v_0;
            delete parentNode.AllowDesignerForCurrentUser;
        }
        $v_0 = parentNode.AllowMasterPageEditingForCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowMasterPageEditingForCurrentUser'] = $v_0;
            delete parentNode.AllowMasterPageEditingForCurrentUser;
        }
        $v_0 = parentNode.AllowRevertFromTemplateForCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowRevertFromTemplateForCurrentUser'] = $v_0;
            delete parentNode.AllowRevertFromTemplateForCurrentUser;
        }
        $v_0 = parentNode.AllowRssFeeds;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowRssFeeds'] = $v_0;
            delete parentNode.AllowRssFeeds;
        }
        $v_0 = parentNode.AllowSaveDeclarativeWorkflowAsTemplateForCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowSaveDeclarativeWorkflowAsTemplateForCurrentUser'] = $v_0;
            delete parentNode.AllowSaveDeclarativeWorkflowAsTemplateForCurrentUser;
        }
        $v_0 = parentNode.AllowSavePublishDeclarativeWorkflowForCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AllowSavePublishDeclarativeWorkflowForCurrentUser'] = $v_0;
            delete parentNode.AllowSavePublishDeclarativeWorkflowForCurrentUser;
        }
        $v_0 = parentNode.AllProperties;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('AllProperties', this.get_allProperties(), $v_0);
            (this.get_allProperties()).fromJson($v_0);
            delete parentNode.AllProperties;
        }
        $v_0 = parentNode.AlternateCssUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AlternateCssUrl'] = $v_0;
            delete parentNode.AlternateCssUrl;
        }
        $v_0 = parentNode.AppInstanceId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['AppInstanceId'] = $v_0;
            delete parentNode.AppInstanceId;
        }
        $v_0 = parentNode.AppTiles;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('AppTiles', this.get_appTiles(), $v_0);
            (this.get_appTiles()).fromJson($v_0);
            delete parentNode.AppTiles;
        }
        $v_0 = parentNode.AssociatedMemberGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('AssociatedMemberGroup', this.get_associatedMemberGroup(), $v_0);
            (this.get_associatedMemberGroup()).fromJson($v_0);
            delete parentNode.AssociatedMemberGroup;
        }
        $v_0 = parentNode.AssociatedOwnerGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('AssociatedOwnerGroup', this.get_associatedOwnerGroup(), $v_0);
            (this.get_associatedOwnerGroup()).fromJson($v_0);
            delete parentNode.AssociatedOwnerGroup;
        }
        $v_0 = parentNode.AssociatedVisitorGroup;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('AssociatedVisitorGroup', this.get_associatedVisitorGroup(), $v_0);
            (this.get_associatedVisitorGroup()).fromJson($v_0);
            delete parentNode.AssociatedVisitorGroup;
        }
        $v_0 = parentNode.AvailableContentTypes;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('AvailableContentTypes', this.get_availableContentTypes(), $v_0);
            (this.get_availableContentTypes()).fromJson($v_0);
            delete parentNode.AvailableContentTypes;
        }
        $v_0 = parentNode.AvailableFields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('AvailableFields', this.get_availableFields(), $v_0);
            (this.get_availableFields()).fromJson($v_0);
            delete parentNode.AvailableFields;
        }
        $v_0 = parentNode.Configuration;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Configuration'] = $v_0;
            delete parentNode.Configuration;
        }
        $v_0 = parentNode.ContainsConfidentialInfo;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ContainsConfidentialInfo'] = $v_0;
            delete parentNode.ContainsConfidentialInfo;
        }
        $v_0 = parentNode.ContentTypes;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ContentTypes', this.get_contentTypes(), $v_0);
            (this.get_contentTypes()).fromJson($v_0);
            delete parentNode.ContentTypes;
        }
        $v_0 = parentNode.Created;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Created'] = $v_0;
            delete parentNode.Created;
        }
        $v_0 = parentNode.CurrentChangeToken;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CurrentChangeToken'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.CurrentChangeToken;
        }
        $v_0 = parentNode.CurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('CurrentUser', this.get_currentUser(), $v_0);
            (this.get_currentUser()).fromJson($v_0);
            delete parentNode.CurrentUser;
        }
        $v_0 = parentNode.CustomMasterUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['CustomMasterUrl'] = $v_0;
            delete parentNode.CustomMasterUrl;
        }
        $v_0 = parentNode.DataLeakagePreventionStatusInfo;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('DataLeakagePreventionStatusInfo', this.get_dataLeakagePreventionStatusInfo(), $v_0);
            (this.get_dataLeakagePreventionStatusInfo()).fromJson($v_0);
            delete parentNode.DataLeakagePreventionStatusInfo;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.DescriptionResource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('DescriptionResource', this.get_descriptionResource(), $v_0);
            (this.get_descriptionResource()).fromJson($v_0);
            delete parentNode.DescriptionResource;
        }
        $v_0 = parentNode.DesignerDownloadUrlForCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DesignerDownloadUrlForCurrentUser'] = $v_0;
            delete parentNode.DesignerDownloadUrlForCurrentUser;
        }
        $v_0 = parentNode.DocumentLibraryCalloutOfficeWebAppPreviewersDisabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DocumentLibraryCalloutOfficeWebAppPreviewersDisabled'] = $v_0;
            delete parentNode.DocumentLibraryCalloutOfficeWebAppPreviewersDisabled;
        }
        $v_0 = parentNode.EffectiveBasePermissions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EffectiveBasePermissions'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.EffectiveBasePermissions;
        }
        $v_0 = parentNode.EnableMinimalDownload;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['EnableMinimalDownload'] = $v_0;
            delete parentNode.EnableMinimalDownload;
        }
        $v_0 = parentNode.EventReceivers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('EventReceivers', this.get_eventReceivers(), $v_0);
            (this.get_eventReceivers()).fromJson($v_0);
            delete parentNode.EventReceivers;
        }
        $v_0 = parentNode.Features;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Features', this.get_features(), $v_0);
            (this.get_features()).fromJson($v_0);
            delete parentNode.Features;
        }
        $v_0 = parentNode.Fields;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Fields', this.get_fields(), $v_0);
            (this.get_fields()).fromJson($v_0);
            delete parentNode.Fields;
        }
        $v_0 = parentNode.Folders;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Folders', this.get_folders(), $v_0);
            (this.get_folders()).fromJson($v_0);
            delete parentNode.Folders;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.IsMultilingual;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsMultilingual'] = $v_0;
            delete parentNode.IsMultilingual;
        }
        $v_0 = parentNode.Language;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Language'] = $v_0;
            delete parentNode.Language;
        }
        $v_0 = parentNode.LastItemModifiedDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LastItemModifiedDate'] = $v_0;
            delete parentNode.LastItemModifiedDate;
        }
        $v_0 = parentNode.Lists;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Lists', this.get_lists(), $v_0);
            (this.get_lists()).fromJson($v_0);
            delete parentNode.Lists;
        }
        $v_0 = parentNode.ListTemplates;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ListTemplates', this.get_listTemplates(), $v_0);
            (this.get_listTemplates()).fromJson($v_0);
            delete parentNode.ListTemplates;
        }
        $v_0 = parentNode.MasterUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MasterUrl'] = $v_0;
            delete parentNode.MasterUrl;
        }
        $v_0 = parentNode.MembersCanShare;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['MembersCanShare'] = $v_0;
            delete parentNode.MembersCanShare;
        }
        $v_0 = parentNode.Navigation;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Navigation', this.get_navigation(), $v_0);
            (this.get_navigation()).fromJson($v_0);
            delete parentNode.Navigation;
        }
        $v_0 = parentNode.NoCrawl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['NoCrawl'] = $v_0;
            delete parentNode.NoCrawl;
        }
        $v_0 = parentNode.OverwriteTranslationsOnChange;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['OverwriteTranslationsOnChange'] = $v_0;
            delete parentNode.OverwriteTranslationsOnChange;
        }
        $v_0 = parentNode.ParentWeb;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ParentWeb', this.get_parentWeb(), $v_0);
            (this.get_parentWeb()).fromJson($v_0);
            delete parentNode.ParentWeb;
        }
        $v_0 = parentNode.PushNotificationSubscribers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('PushNotificationSubscribers', this.get_pushNotificationSubscribers(), $v_0);
            (this.get_pushNotificationSubscribers()).fromJson($v_0);
            delete parentNode.PushNotificationSubscribers;
        }
        $v_0 = parentNode.QuickLaunchEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['QuickLaunchEnabled'] = $v_0;
            delete parentNode.QuickLaunchEnabled;
        }
        $v_0 = parentNode.RecycleBin;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RecycleBin', this.get_recycleBin(), $v_0);
            (this.get_recycleBin()).fromJson($v_0);
            delete parentNode.RecycleBin;
        }
        $v_0 = parentNode.RecycleBinEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RecycleBinEnabled'] = $v_0;
            delete parentNode.RecycleBinEnabled;
        }
        $v_0 = parentNode.RegionalSettings;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RegionalSettings', this.get_regionalSettings(), $v_0);
            (this.get_regionalSettings()).fromJson($v_0);
            delete parentNode.RegionalSettings;
        }
        $v_0 = parentNode.RequestAccessEmail;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['RequestAccessEmail'] = $v_0;
            delete parentNode.RequestAccessEmail;
        }
        $v_0 = parentNode.RoleDefinitions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RoleDefinitions', this.get_roleDefinitions(), $v_0);
            (this.get_roleDefinitions()).fromJson($v_0);
            delete parentNode.RoleDefinitions;
        }
        $v_0 = parentNode.RootFolder;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('RootFolder', this.get_rootFolder(), $v_0);
            (this.get_rootFolder()).fromJson($v_0);
            delete parentNode.RootFolder;
        }
        $v_0 = parentNode.SaveSiteAsTemplateEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SaveSiteAsTemplateEnabled'] = $v_0;
            delete parentNode.SaveSiteAsTemplateEnabled;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.ShowUrlStructureForCurrentUser;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ShowUrlStructureForCurrentUser'] = $v_0;
            delete parentNode.ShowUrlStructureForCurrentUser;
        }
        $v_0 = parentNode.SiteGroups;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('SiteGroups', this.get_siteGroups(), $v_0);
            (this.get_siteGroups()).fromJson($v_0);
            delete parentNode.SiteGroups;
        }
        $v_0 = parentNode.SiteLogoUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SiteLogoUrl'] = $v_0;
            delete parentNode.SiteLogoUrl;
        }
        $v_0 = parentNode.SiteUserInfoList;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('SiteUserInfoList', this.get_siteUserInfoList(), $v_0);
            (this.get_siteUserInfoList()).fromJson($v_0);
            delete parentNode.SiteUserInfoList;
        }
        $v_0 = parentNode.SiteUsers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('SiteUsers', this.get_siteUsers(), $v_0);
            (this.get_siteUsers()).fromJson($v_0);
            delete parentNode.SiteUsers;
        }
        $v_0 = parentNode.SupportedUILanguageIds;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SupportedUILanguageIds'] = SP.DataConvert.fixupType(this.get_context(), $v_0);
            delete parentNode.SupportedUILanguageIds;
        }
        $v_0 = parentNode.SyndicationEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['SyndicationEnabled'] = $v_0;
            delete parentNode.SyndicationEnabled;
        }
        $v_0 = parentNode.ThemeInfo;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('ThemeInfo', this.get_themeInfo(), $v_0);
            (this.get_themeInfo()).fromJson($v_0);
            delete parentNode.ThemeInfo;
        }
        $v_0 = parentNode.ThirdPartyMdmEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ThirdPartyMdmEnabled'] = $v_0;
            delete parentNode.ThirdPartyMdmEnabled;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.TitleResource;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('TitleResource', this.get_titleResource(), $v_0);
            (this.get_titleResource()).fromJson($v_0);
            delete parentNode.TitleResource;
        }
        $v_0 = parentNode.TreeViewEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['TreeViewEnabled'] = $v_0;
            delete parentNode.TreeViewEnabled;
        }
        $v_0 = parentNode.UIVersion;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UIVersion'] = $v_0;
            delete parentNode.UIVersion;
        }
        $v_0 = parentNode.UIVersionConfigurationEnabled;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['UIVersionConfigurationEnabled'] = $v_0;
            delete parentNode.UIVersionConfigurationEnabled;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Url'] = $v_0;
            delete parentNode.Url;
        }
        $v_0 = parentNode.UserCustomActions;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('UserCustomActions', this.get_userCustomActions(), $v_0);
            (this.get_userCustomActions()).fromJson($v_0);
            delete parentNode.UserCustomActions;
        }
        $v_0 = parentNode.Webs;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('Webs', this.get_webs(), $v_0);
            (this.get_webs()).fromJson($v_0);
            delete parentNode.Webs;
        }
        $v_0 = parentNode.WebTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebTemplate'] = $v_0;
            delete parentNode.WebTemplate;
        }
        $v_0 = parentNode.WorkflowAssociations;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('WorkflowAssociations', this.get_workflowAssociations(), $v_0);
            (this.get_workflowAssociations()).fromJson($v_0);
            delete parentNode.WorkflowAssociations;
        }
        $v_0 = parentNode.WorkflowTemplates;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.updateClientObjectPropertyType('WorkflowTemplates', this.get_workflowTemplates(), $v_0);
            (this.get_workflowTemplates()).fromJson($v_0);
            delete parentNode.WorkflowTemplates;
        }
    },
    doesUserHavePermissions: function SP_Web$doesUserHavePermissions(permissionMask) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'DoesUserHavePermissions', [permissionMask]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.BooleanResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getUserEffectivePermissions: function SP_Web$getUserEffectivePermissions(userName) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'GetUserEffectivePermissions', [userName]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.BasePermissions();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    mapToIcon: function SP_Web$mapToIcon(fileName, progId, size) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'MapToIcon', [fileName, progId, size]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.StringResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    registerPushNotificationSubscriber: function SP_Web$registerPushNotificationSubscriber(deviceAppInstanceId, serviceToken) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.PushNotificationSubscriber($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'RegisterPushNotificationSubscriber', [deviceAppInstanceId, serviceToken]));
        return $v_1;
    },
    unregisterPushNotificationSubscriber: function SP_Web$unregisterPushNotificationSubscriber(deviceAppInstanceId) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'UnregisterPushNotificationSubscriber', [deviceAppInstanceId]);

        $v_0.addQuery($v_1);
    },
    getPushNotificationSubscribersByArgs: function SP_Web$getPushNotificationSubscribersByArgs(customArgs) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.PushNotificationSubscriberCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetPushNotificationSubscribersByArgs', [customArgs]));
        return $v_1;
    },
    getPushNotificationSubscribersByUser: function SP_Web$getPushNotificationSubscribersByUser(userName) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.PushNotificationSubscriberCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetPushNotificationSubscribersByUser', [userName]));
        return $v_1;
    },
    doesPushNotificationSubscriberExist: function SP_Web$doesPushNotificationSubscriberExist(deviceAppInstanceId) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = new SP.ClientActionInvokeMethod(this, 'DoesPushNotificationSubscriberExist', [deviceAppInstanceId]);

        $v_0.addQuery($v_2);
        $v_1 = new SP.BooleanResult();
        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        return $v_1;
    },
    getPushNotificationSubscriber: function SP_Web$getPushNotificationSubscriber(deviceAppInstanceId) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.PushNotificationSubscriber($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetPushNotificationSubscriber', [deviceAppInstanceId]));
        return $v_1;
    },
    getUserById: function SP_Web$getUserById(userId) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetUserById'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetUserById'] = $v_2;
        }
        $v_1 = $v_2[userId];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.User($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetUserById', [userId]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[userId] = $v_1;
        }
        return $v_1;
    },
    getRecycleBinItems: function SP_Web$getRecycleBinItems(pagingInfo, rowLimit, isAscending, orderBy, itemState) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.RecycleBinItemCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetRecycleBinItems', [pagingInfo, rowLimit, isAscending, orderBy, itemState]));
        return $v_1;
    },
    getChanges: function SP_Web$getChanges(query) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ChangeCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetChanges', [query]));
        return $v_1;
    },
    getFileByServerRelativeUrl: function SP_Web$getFileByServerRelativeUrl(serverRelativeUrl) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetFileByServerRelativeUrl'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetFileByServerRelativeUrl'] = $v_2;
        }
        $v_1 = $v_2[serverRelativeUrl.toUpperCase()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFileByServerRelativeUrl', [serverRelativeUrl]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[serverRelativeUrl.toUpperCase()] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    defaultDocumentLibrary: function SP_Web$defaultDocumentLibrary() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'DefaultDocumentLibrary', null));
        return $v_1;
    },
    getFileById: function SP_Web$getFileById(uniqueId) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFileById', [uniqueId]));
        return $v_1;
    },
    getFolderById: function SP_Web$getFolderById(uniqueId) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Folder($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFolderById', [uniqueId]));
        return $v_1;
    },
    getFileByLinkingUrl: function SP_Web$getFileByLinkingUrl(linkingUrl) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFileByLinkingUrl', [linkingUrl]));
        return $v_1;
    },
    getFileByGuestUrl: function SP_Web$getFileByGuestUrl(guestUrl) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFileByGuestUrl', [guestUrl]));
        return $v_1;
    },
    getFileByWOPIFrameUrl: function SP_Web$getFileByWOPIFrameUrl(wopiFrameUrl) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFileByWOPIFrameUrl', [wopiFrameUrl]));
        return $v_1;
    },
    getFileByUrl: function SP_Web$getFileByUrl(fileUrl) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.File($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFileByUrl', [fileUrl]));
        return $v_1;
    },
    getFolderByServerRelativeUrl: function SP_Web$getFolderByServerRelativeUrl(serverRelativeUrl) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetFolderByServerRelativeUrl'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetFolderByServerRelativeUrl'] = $v_2;
        }
        $v_1 = $v_2[serverRelativeUrl.toUpperCase()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.Folder($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetFolderByServerRelativeUrl', [serverRelativeUrl]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[serverRelativeUrl.toUpperCase()] = $v_1;
        }
        var $v_3 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_3.get_id(), $v_1);
        $v_0.addQuery($v_3);
        return $v_1;
    },
    getList: function SP_Web$getList(strUrl) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetList'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetList'] = $v_2;
        }
        $v_1 = $v_2[strUrl];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetList', [strUrl]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[strUrl] = $v_1;
        }
        return $v_1;
    },
    getEntity: function SP_Web$getEntity(nnamespace, name) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.BusinessData.Entity($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetEntity', [nnamespace, name]));
        return $v_1;
    },
    getAppBdcCatalogForAppInstance: function SP_Web$getAppBdcCatalogForAppInstance(appInstanceId) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.BusinessData.AppBdcCatalog($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetAppBdcCatalogForAppInstance', [appInstanceId]));
        return $v_1;
    },
    getAppBdcCatalog: function SP_Web$getAppBdcCatalog() {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.BusinessData.AppBdcCatalog($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetAppBdcCatalog', null));
        return $v_1;
    },
    getSubwebsForCurrentUser: function SP_Web$getSubwebsForCurrentUser(query) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.WebCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetSubwebsForCurrentUser', [query]));
        return $v_1;
    },
    getAvailableWebTemplates: function SP_Web$getAvailableWebTemplates(lcid, doIncludeCrossLanguage) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.WebTemplateCollection($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetAvailableWebTemplates', [lcid, doIncludeCrossLanguage]));
        return $v_1;
    },
    getCatalog: function SP_Web$getCatalog(typeCatalog) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetCatalog'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = [];
            ((this.get_objectData()).get_methodReturnObjects())['GetCatalog'] = $v_2;
        }
        $v_1 = $v_2[typeCatalog];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.List($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetCatalog', [typeCatalog]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[typeCatalog] = $v_1;
        }
        return $v_1;
    },
    applyWebTemplate: function SP_Web$applyWebTemplate(webTemplate) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'ApplyWebTemplate', [webTemplate]);

        $v_0.addQuery($v_1);
    },
    deleteObject: function SP_Web$deleteObject() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'DeleteObject', null);

        $v_0.addQuery($v_1);
        this.removeFromParentCollection();
    },
    update: function SP_Web$update() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'Update', null);

        $v_0.addQuery($v_1);
    },
    getAppInstanceById: function SP_Web$getAppInstanceById(appInstanceId) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.AppInstance($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetAppInstanceById', [appInstanceId]));
        return $v_1;
    },
    getAppInstancesByProductId: function SP_Web$getAppInstancesByProductId(productId) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.ClientObjectList($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetAppInstancesByProductId', [productId]), SP.AppInstance);
        return $v_1;
    },
    loadAndInstallAppInSpecifiedLocale: function SP_Web$loadAndInstallAppInSpecifiedLocale(appPackageStream, installationLocaleLCID) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.AppInstance($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'LoadAndInstallAppInSpecifiedLocale', [appPackageStream, installationLocaleLCID]));
        return $v_1;
    },
    loadApp: function SP_Web$loadApp(appPackageStream, installationLocaleLCID) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.AppInstance($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'LoadApp', [appPackageStream, installationLocaleLCID]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        return $v_1;
    },
    loadAndInstallApp: function SP_Web$loadAndInstallApp(appPackageStream) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.AppInstance($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'LoadAndInstallApp', [appPackageStream]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        return $v_1;
    },
    ensureUser: function SP_Web$ensureUser(logonName) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.User($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'EnsureUser', [logonName]));
        return $v_1;
    },
    applyTheme: function SP_Web$applyTheme(colorPaletteUrl, fontSchemeUrl, backgroundImageUrl, shareGenerated) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'ApplyTheme', [colorPaletteUrl, fontSchemeUrl, backgroundImageUrl, shareGenerated]);

        $v_0.addQuery($v_1);
    },
    incrementSiteClientTag: function SP_Web$incrementSiteClientTag() {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'IncrementSiteClientTag', null);

        $v_0.addQuery($v_1);
    },
    addSupportedUILanguage: function SP_Web$addSupportedUILanguage(lcid) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'AddSupportedUILanguage', [lcid]);

        $v_0.addQuery($v_1);
    },
    removeSupportedUILanguage: function SP_Web$removeSupportedUILanguage(lcid) {
        var $v_0 = this.get_context();
        var $v_1 = new SP.ClientActionInvokeMethod(this, 'RemoveSupportedUILanguage', [lcid]);

        $v_0.addQuery($v_1);
    }
};
SP.WebPropertyNames = function SP_WebPropertyNames() {
};
SP.WebObjectPropertyNames = function SP_WebObjectPropertyNames() {
};
SP.WebCollection = function SP_WebCollection(context, objectPath) {
    SP.WebCollection.initializeBase(this, [context, objectPath]);
};
SP.WebCollection.prototype = {
    itemAt: function SP_WebCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_WebCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_WebCollection$get_childItemType() {
        return SP.Web;
    },
    add: function SP_WebCollection$add(parameters) {
        var $v_0 = this.get_context();
        var $v_1;

        $v_1 = new SP.Web($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'Add', [parameters]));
        ($v_1.get_path()).setPendingReplace();
        var $v_2 = new SP.ObjectIdentityQuery($v_1.get_path());

        $v_0.addQueryIdAndResultObject($v_2.get_id(), $v_1);
        $v_0.addQuery($v_2);
        this.addChild($v_1);
        $v_1.$F_2(parameters);
        return $v_1;
    }
};
SP.WebCreationInformation = function SP_WebCreationInformation() {
    SP.WebCreationInformation.initializeBase(this);
};
SP.WebCreationInformation.prototype = {
    $2_1: null,
    $4D_1: 0,
    $0_1: null,
    $1_1: null,
    $5P_1: false,
    $5W_1: null,
    get_description: function SP_WebCreationInformation$get_description() {
        return this.$2_1;
    },
    set_description: function SP_WebCreationInformation$set_description(value) {
        this.$2_1 = value;
        return value;
    },
    get_language: function SP_WebCreationInformation$get_language() {
        return this.$4D_1;
    },
    set_language: function SP_WebCreationInformation$set_language(value) {
        this.$4D_1 = value;
        return value;
    },
    get_title: function SP_WebCreationInformation$get_title() {
        return this.$0_1;
    },
    set_title: function SP_WebCreationInformation$set_title(value) {
        this.$0_1 = value;
        return value;
    },
    get_url: function SP_WebCreationInformation$get_url() {
        return this.$1_1;
    },
    set_url: function SP_WebCreationInformation$set_url(value) {
        this.$1_1 = value;
        return value;
    },
    get_useSamePermissionsAsParentSite: function SP_WebCreationInformation$get_useSamePermissionsAsParentSite() {
        return this.$5P_1;
    },
    set_useSamePermissionsAsParentSite: function SP_WebCreationInformation$set_useSamePermissionsAsParentSite(value) {
        this.$5P_1 = value;
        return value;
    },
    get_webTemplate: function SP_WebCreationInformation$get_webTemplate() {
        return this.$5W_1;
    },
    set_webTemplate: function SP_WebCreationInformation$set_webTemplate(value) {
        this.$5W_1 = value;
        return value;
    },
    get_typeId: function SP_WebCreationInformation$get_typeId() {
        return '{8f9e9fbe-189e-492f-884f-98f9ef9cc4d6}';
    },
    writeToXml: function SP_WebCreationInformation$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Description', 'Language', 'Title', 'Url', 'UseSamePermissionsAsParentSite', 'WebTemplate'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_WebCreationInformation$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$2_1 = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Language;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4D_1 = $v_0;
            delete parentNode.Language;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$0_1 = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1_1 = $v_0;
            delete parentNode.Url;
        }
        $v_0 = parentNode.UseSamePermissionsAsParentSite;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5P_1 = $v_0;
            delete parentNode.UseSamePermissionsAsParentSite;
        }
        $v_0 = parentNode.WebTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5W_1 = $v_0;
            delete parentNode.WebTemplate;
        }
    }
};
SP.WebInformation = function SP_WebInformation(context, objectPath) {
    SP.WebInformation.initializeBase(this, [context, objectPath]);
};
SP.WebInformation.prototype = {
    get_configuration: function SP_WebInformation$get_configuration() {
        this.checkUninitializedProperty('Configuration');
        return ((this.get_objectData()).get_properties())['Configuration'];
    },
    get_created: function SP_WebInformation$get_created() {
        this.checkUninitializedProperty('Created');
        return ((this.get_objectData()).get_properties())['Created'];
    },
    get_description: function SP_WebInformation$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    get_id: function SP_WebInformation$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_language: function SP_WebInformation$get_language() {
        this.checkUninitializedProperty('Language');
        return ((this.get_objectData()).get_properties())['Language'];
    },
    get_lastItemModifiedDate: function SP_WebInformation$get_lastItemModifiedDate() {
        this.checkUninitializedProperty('LastItemModifiedDate');
        return ((this.get_objectData()).get_properties())['LastItemModifiedDate'];
    },
    get_serverRelativeUrl: function SP_WebInformation$get_serverRelativeUrl() {
        this.checkUninitializedProperty('ServerRelativeUrl');
        return ((this.get_objectData()).get_properties())['ServerRelativeUrl'];
    },
    get_title: function SP_WebInformation$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    get_webTemplate: function SP_WebInformation$get_webTemplate() {
        this.checkUninitializedProperty('WebTemplate');
        return ((this.get_objectData()).get_properties())['WebTemplate'];
    },
    get_webTemplateId: function SP_WebInformation$get_webTemplateId() {
        this.checkUninitializedProperty('WebTemplateId');
        return ((this.get_objectData()).get_properties())['WebTemplateId'];
    },
    initPropertiesFromJson: function SP_WebInformation$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Configuration;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Configuration'] = $v_0;
            delete parentNode.Configuration;
        }
        $v_0 = parentNode.Created;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Created'] = $v_0;
            delete parentNode.Created;
        }
        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.Language;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Language'] = $v_0;
            delete parentNode.Language;
        }
        $v_0 = parentNode.LastItemModifiedDate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['LastItemModifiedDate'] = $v_0;
            delete parentNode.LastItemModifiedDate;
        }
        $v_0 = parentNode.ServerRelativeUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ServerRelativeUrl'] = $v_0;
            delete parentNode.ServerRelativeUrl;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
        $v_0 = parentNode.WebTemplate;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebTemplate'] = $v_0;
            delete parentNode.WebTemplate;
        }
        $v_0 = parentNode.WebTemplateId;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['WebTemplateId'] = $v_0;
            delete parentNode.WebTemplateId;
        }
    }
};
SP.WebInformationPropertyNames = function SP_WebInformationPropertyNames() {
};
SP.WebProxy = function SP_WebProxy() {
};
SP.WebProxy.invoke = function SP_WebProxy$invoke(context, requestInfo) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{656a77c4-1634-415c-bf85-c6c0cb286e0e}', 'Invoke', [requestInfo]);

    context.addQuery($v_1);
    $v_0 = new SP.WebResponseInfo();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.WebRequestInfo = function SP_WebRequestInfo() {
    SP.WebRequestInfo.initializeBase(this);
};
SP.WebRequestInfo.prototype = {
    $G_1: null,
    $d_1: null,
    $4N_1: null,
    $1_1: null,
    get_body: function SP_WebRequestInfo$get_body() {
        return this.$G_1;
    },
    set_body: function SP_WebRequestInfo$set_body(value) {
        this.$G_1 = value;
        return value;
    },
    get_headers: function SP_WebRequestInfo$get_headers() {
        return this.$d_1;
    },
    set_headers: function SP_WebRequestInfo$set_headers(value) {
        this.$d_1 = value;
        return value;
    },
    get_method: function SP_WebRequestInfo$get_method() {
        return this.$4N_1;
    },
    set_method: function SP_WebRequestInfo$set_method(value) {
        this.$4N_1 = value;
        return value;
    },
    get_url: function SP_WebRequestInfo$get_url() {
        return this.$1_1;
    },
    set_url: function SP_WebRequestInfo$set_url(value) {
        this.$1_1 = value;
        return value;
    },
    get_typeId: function SP_WebRequestInfo$get_typeId() {
        return '{71aa825d-bc12-422d-a177-d2e63fe68cd9}';
    },
    writeToXml: function SP_WebRequestInfo$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Body', 'Headers', 'Method', 'Url'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_WebRequestInfo$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Body;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$G_1 = $v_0;
            delete parentNode.Body;
        }
        $v_0 = parentNode.Headers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$d_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Headers;
        }
        $v_0 = parentNode.Method;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$4N_1 = $v_0;
            delete parentNode.Method;
        }
        $v_0 = parentNode.Url;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$1_1 = $v_0;
            delete parentNode.Url;
        }
    }
};
SP.WebResponseInfo = function SP_WebResponseInfo() {
    SP.WebResponseInfo.initializeBase(this);
};
SP.WebResponseInfo.prototype = {
    $G_1: null,
    $d_1: null,
    $5B_1: 0,
    get_body: function SP_WebResponseInfo$get_body() {
        return this.$G_1;
    },
    set_body: function SP_WebResponseInfo$set_body(value) {
        this.$G_1 = value;
        return value;
    },
    get_headers: function SP_WebResponseInfo$get_headers() {
        return this.$d_1;
    },
    set_headers: function SP_WebResponseInfo$set_headers(value) {
        this.$d_1 = value;
        return value;
    },
    get_statusCode: function SP_WebResponseInfo$get_statusCode() {
        return this.$5B_1;
    },
    set_statusCode: function SP_WebResponseInfo$set_statusCode(value) {
        this.$5B_1 = value;
        return value;
    },
    get_typeId: function SP_WebResponseInfo$get_typeId() {
        return '{73b6054a-aa40-41e4-a34f-5a6f898e6d4f}';
    },
    writeToXml: function SP_WebResponseInfo$writeToXml(writer, serializationContext) {
        if (!writer) {
            throw Error.argumentNull('writer');
        }
        if (!serializationContext) {
            throw Error.argumentNull('serializationContext');
        }
        var $v_0 = ['Body', 'Headers', 'StatusCode'];

        SP.DataConvert.writePropertiesToXml(writer, this, $v_0, serializationContext);
        SP.ClientValueObject.prototype.writeToXml.call(this, writer, serializationContext);
    },
    initPropertiesFromJson: function SP_WebResponseInfo$initPropertiesFromJson(parentNode) {
        SP.ClientValueObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Body;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$G_1 = $v_0;
            delete parentNode.Body;
        }
        $v_0 = parentNode.Headers;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$d_1 = SP.DataConvert.fixupType(null, $v_0);
            delete parentNode.Headers;
        }
        $v_0 = parentNode.StatusCode;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            this.$5B_1 = $v_0;
            delete parentNode.StatusCode;
        }
    }
};
SP.WebTemplate = function SP_WebTemplate(context, objectPath) {
    SP.WebTemplate.initializeBase(this, [context, objectPath]);
};
SP.WebTemplate.prototype = {
    get_description: function SP_WebTemplate$get_description() {
        this.checkUninitializedProperty('Description');
        return ((this.get_objectData()).get_properties())['Description'];
    },
    get_displayCategory: function SP_WebTemplate$get_displayCategory() {
        this.checkUninitializedProperty('DisplayCategory');
        return ((this.get_objectData()).get_properties())['DisplayCategory'];
    },
    get_id: function SP_WebTemplate$get_id() {
        this.checkUninitializedProperty('Id');
        return ((this.get_objectData()).get_properties())['Id'];
    },
    get_imageUrl: function SP_WebTemplate$get_imageUrl() {
        this.checkUninitializedProperty('ImageUrl');
        return ((this.get_objectData()).get_properties())['ImageUrl'];
    },
    get_isHidden: function SP_WebTemplate$get_isHidden() {
        this.checkUninitializedProperty('IsHidden');
        return ((this.get_objectData()).get_properties())['IsHidden'];
    },
    get_isRootWebOnly: function SP_WebTemplate$get_isRootWebOnly() {
        this.checkUninitializedProperty('IsRootWebOnly');
        return ((this.get_objectData()).get_properties())['IsRootWebOnly'];
    },
    get_isSubWebOnly: function SP_WebTemplate$get_isSubWebOnly() {
        this.checkUninitializedProperty('IsSubWebOnly');
        return ((this.get_objectData()).get_properties())['IsSubWebOnly'];
    },
    get_lcid: function SP_WebTemplate$get_lcid() {
        this.checkUninitializedProperty('Lcid');
        return ((this.get_objectData()).get_properties())['Lcid'];
    },
    get_name: function SP_WebTemplate$get_name() {
        this.checkUninitializedProperty('Name');
        return ((this.get_objectData()).get_properties())['Name'];
    },
    get_title: function SP_WebTemplate$get_title() {
        this.checkUninitializedProperty('Title');
        return ((this.get_objectData()).get_properties())['Title'];
    },
    initPropertiesFromJson: function SP_WebTemplate$initPropertiesFromJson(parentNode) {
        SP.ClientObject.prototype.initPropertiesFromJson.call(this, parentNode);
        var $v_0;

        $v_0 = parentNode.Description;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Description'] = $v_0;
            delete parentNode.Description;
        }
        $v_0 = parentNode.DisplayCategory;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['DisplayCategory'] = $v_0;
            delete parentNode.DisplayCategory;
        }
        $v_0 = parentNode.Id;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Id'] = $v_0;
            delete parentNode.Id;
        }
        $v_0 = parentNode.ImageUrl;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['ImageUrl'] = $v_0;
            delete parentNode.ImageUrl;
        }
        $v_0 = parentNode.IsHidden;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsHidden'] = $v_0;
            delete parentNode.IsHidden;
        }
        $v_0 = parentNode.IsRootWebOnly;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsRootWebOnly'] = $v_0;
            delete parentNode.IsRootWebOnly;
        }
        $v_0 = parentNode.IsSubWebOnly;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['IsSubWebOnly'] = $v_0;
            delete parentNode.IsSubWebOnly;
        }
        $v_0 = parentNode.Lcid;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Lcid'] = $v_0;
            delete parentNode.Lcid;
        }
        $v_0 = parentNode.Name;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Name'] = $v_0;
            delete parentNode.Name;
        }
        $v_0 = parentNode.Title;
        if (!SP.ScriptUtility.isUndefined($v_0)) {
            ((this.get_objectData()).get_properties())['Title'] = $v_0;
            delete parentNode.Title;
        }
    }
};
SP.WebTemplatePropertyNames = function SP_WebTemplatePropertyNames() {
};
SP.WebTemplateCollection = function SP_WebTemplateCollection(context, objectPath) {
    SP.WebTemplateCollection.initializeBase(this, [context, objectPath]);
};
SP.WebTemplateCollection.prototype = {
    itemAt: function SP_WebTemplateCollection$itemAt(index) {
        return this.getItemAtIndex(index);
    },
    get_item: function SP_WebTemplateCollection$get_item(index) {
        return this.getItemAtIndex(index);
    },
    get_childItemType: function SP_WebTemplateCollection$get_childItemType() {
        return SP.WebTemplate;
    },
    getByName: function SP_WebTemplateCollection$getByName(name) {
        var $v_0 = this.get_context();
        var $v_1;
        var $v_2 = ((this.get_objectData()).get_methodReturnObjects())['GetByName'];

        if (SP.ScriptUtility.isNullOrUndefined($v_2)) {
            $v_2 = {};
            ((this.get_objectData()).get_methodReturnObjects())['GetByName'] = $v_2;
        }
        $v_1 = $v_2[name.toUpperCase()];
        if (!$v_0.get_disableReturnValueCache() && !SP.ScriptUtility.isNullOrUndefined($v_1)) {
            return $v_1;
        }
        $v_1 = new SP.WebTemplate($v_0, new SP.ObjectPathMethod($v_0, this.get_path(), 'GetByName', [name]));
        if (!$v_0.get_disableReturnValueCache()) {
            $v_2[name.toUpperCase()] = $v_1;
        }
        return $v_1;
    }
};
Type.registerNamespace('SP.UI');
SP.UI.PopoutMenu = function SP_UI_PopoutMenu(launcherId, menuId, iconId, launcherOpenCssClass, textDirection, closeIconUrl, isClustered, closeIconOffsetLeft, closeIconOffsetTop, closeIconHeight, closeIconWidth) {
    this.$$d_closeMenu = Function.createDelegate(this, this.closeMenu);
    this.$$d_onMenuMouseOver = Function.createDelegate(this, this.onMenuMouseOver);
    this.$$d_onMenuMouseOut = Function.createDelegate(this, this.onMenuMouseOut);
    this.$1r_0 = -1;
    this.$L_0 = $get(launcherId);
    this.$3_0 = $get(menuId);
    this.$1t_0 = launcherOpenCssClass;
    this.$5m_0 = textDirection;
    this.$1q_0 = closeIconUrl;
    this.$5h_0 = isClustered;
    if (isClustered) {
        this.$1C_0 = $get(iconId);
        this.$10_0 = this.$1C_0.firstChild;
        this.$5i_0 = closeIconOffsetLeft;
        this.$5j_0 = closeIconOffsetTop;
        this.$5g_0 = closeIconHeight;
        this.$5k_0 = closeIconWidth;
    }
    else {
        this.$10_0 = $get(iconId);
    }
    if (SP.ScriptUtility.isNullOrUndefined(this.$L_0)) {
        throw Error.argument('launcherId');
    }
    if (SP.ScriptUtility.isNullOrUndefined(this.$3_0)) {
        throw Error.argument('menuId');
    }
    this.$1v_0 = this.$$d_onMenuMouseOut;
    this.$1w_0 = this.$$d_onMenuMouseOver;
    this.$1u_0 = SP.UI.PopoutMenu.onMenuClick;
    $addHandler(this.$3_0, 'mouseout', this.$1v_0);
    $addHandler(this.$3_0, 'mouseover', this.$1w_0);
    $addHandler(this.$3_0, 'click', this.$1u_0);
};
SP.UI.PopoutMenu.beginModal = function SP_UI_PopoutMenu$beginModal() {
    if (SP.UI.PopoutMenu.$u) {
        return;
    }
    if (!SP.UI.PopoutMenu.$5l) {
        $addHandler(document, 'keydown', SP.UI.PopoutMenu.onModalKeyDown);
        var $v_0 = SP.UI.PopoutMenu.onCloseEvent;

        $addHandler(window, 'scroll', $v_0);
        $addHandler(document.body, 'click', $v_0);
        SP.UI.PopoutMenu.$5l = true;
    }
    SP.UI.PopoutMenu.$u = true;
};
SP.UI.PopoutMenu.endModal = function SP_UI_PopoutMenu$endModal() {
    if (!SP.UI.PopoutMenu.$u) {
        return;
    }
    SP.UI.PopoutMenu.$u = false;
};
SP.UI.PopoutMenu.onMenuClick = function SP_UI_PopoutMenu$onMenuClick(evt) {
    evt.stopPropagation();
    if (!SP.ScriptUtility.isNullOrUndefined(SP.UI.PopoutMenu._activePopoutMenuInstance)) {
        SP.UI.PopoutMenu._activePopoutMenuInstance.closeMenu();
    }
    var $v_0 = evt.target;

    if ($v_0 && $v_0.tagName && $v_0.tagName.toUpperCase() === 'A' && $v_0.href && $v_0.href.length > 0) {
        evt.preventDefault();
        STSNavigate($v_0.href);
    }
};
SP.UI.PopoutMenu.onModalKeyDown = function SP_UI_PopoutMenu$onModalKeyDown(evt) {
    if (!SP.UI.PopoutMenu.$u) {
        return;
    }
    if (evt && evt.rawEvent) {
        if (evt.rawEvent.keyCode === 27) {
            SP.UI.PopoutMenu._activePopoutMenuInstance.closeMenu();
        }
    }
};
SP.UI.PopoutMenu.onCloseEvent = function SP_UI_PopoutMenu$onCloseEvent(evt) {
    if (!SP.UI.PopoutMenu.$u) {
        return;
    }
    SP.UI.PopoutMenu._activePopoutMenuInstance.closeMenu();
    evt.preventDefault();
};
SP.UI.PopoutMenu.ensureCSSClassOnElement = function SP_UI_PopoutMenu$ensureCSSClassOnElement(element, cssClass) {
    if (SP.ScriptUtility.isNullOrUndefined(element)) {
        return;
    }
    var $v_0 = element.className;

    if ($v_0.indexOf(cssClass) !== -1) {
        return;
    }
    var $v_1 = element.className.trim() + ' ' + cssClass;

    $v_1 = $v_1.trim();
    element.className = $v_1;
};
SP.UI.PopoutMenu.removeCSSClassFromElement = function SP_UI_PopoutMenu$removeCSSClassFromElement(element, cssClass) {
    if (SP.ScriptUtility.isNullOrUndefined(element)) {
        return;
    }
    element.className = element.className.replace(cssClass, '');
};
SP.UI.PopoutMenu.getViewPortWidth = function SP_UI_PopoutMenu$getViewPortWidth() {
    var $v_0 = window.innerWidth;

    if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
        $v_0 = document.documentElement.clientWidth;
    }
    if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
        $v_0 = document.body.clientWidth;
    }
    return $v_0;
};
SP.UI.PopoutMenu.getViewPortHeight = function SP_UI_PopoutMenu$getViewPortHeight() {
    var $v_0 = window.innerHeight;

    if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
        $v_0 = document.documentElement.clientHeight;
    }
    if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
        $v_0 = document.body.clientHeight;
    }
    return $v_0;
};
SP.UI.PopoutMenu.getViewableTop = function SP_UI_PopoutMenu$getViewableTop() {
    var $v_0;

    $v_0 = window.pageXOffset;
    if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
        $v_0 = document.documentElement.scrollTop;
    }
    if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
        $v_0 = document.body.scrollTop;
    }
    return $v_0;
};
SP.UI.PopoutMenu.getViewableLeft = function SP_UI_PopoutMenu$getViewableLeft() {
    var $v_0;

    $v_0 = window.pageYOffset;
    if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
        $v_0 = document.documentElement.scrollLeft;
    }
    if (SP.ScriptUtility.isNullOrUndefined($v_0)) {
        $v_0 = document.body.scrollLeft;
    }
    return $v_0;
};
SP.UI.PopoutMenu.get_activePopoutMenuInstance = function SP_UI_PopoutMenu$get_activePopoutMenuInstance() {
    return SP.UI.PopoutMenu._activePopoutMenuInstance;
};
SP.UI.PopoutMenu.set_activePopoutMenuInstance = function SP_UI_PopoutMenu$set_activePopoutMenuInstance(value) {
    SP.UI.PopoutMenu._activePopoutMenuInstance = value;
    return value;
};
SP.UI.PopoutMenu.createPopoutMenuInstanceAndLaunch = function SP_UI_PopoutMenu$createPopoutMenuInstanceAndLaunch(anchorId, menuId, iconId, anchorOpenCss, textDirection, closeIconUrl, isClustered, x, y, height, width) {
    if (!SP.ScriptUtility.isNullOrUndefined(SP.UI.PopoutMenu._activePopoutMenuInstance)) {
        SP.UI.PopoutMenu._activePopoutMenuInstance.closeMenu();
        return;
    }
    var $v_0 = new SP.UI.PopoutMenu(anchorId, menuId, iconId, anchorOpenCss, textDirection, closeIconUrl, isClustered, x, y, height, width);

    $v_0.launchMenu();
};
SP.UI.PopoutMenu.closeActivePopoutMenuInstance = function SP_UI_PopoutMenu$closeActivePopoutMenuInstance() {
    if (!SP.ScriptUtility.isNullOrUndefined(SP.UI.PopoutMenu._activePopoutMenuInstance)) {
        SP.UI.PopoutMenu._activePopoutMenuInstance.closeMenu();
    }
};
SP.UI.PopoutMenu.prototype = {
    $L_0: null,
    $3_0: null,
    $1C_0: null,
    $10_0: null,
    $1t_0: null,
    $5m_0: null,
    $1q_0: null,
    $5h_0: false,
    $5i_0: 0,
    $5j_0: 0,
    $5g_0: 0,
    $5k_0: 0,
    $1v_0: null,
    $1w_0: null,
    $1u_0: null,
    launchMenu: function SP_UI_PopoutMenu$launchMenu() {
        if (this._menuLaunched) {
            return;
        }
        if (SP.UI.PopoutMenu._activePopoutMenuInstance) {
            SP.UI.PopoutMenu._activePopoutMenuInstance.closeMenu();
        }
        SP.UI.PopoutMenu._activePopoutMenuInstance = this;
        SP.UI.PopoutMenu.beginModal();
        SP.UI.PopoutMenu.ensureCSSClassOnElement(this.$L_0, this.$1t_0);
        this.$3_0.style.display = 'block';
        this.$3_0.style.visibility = 'hidden';
        this.$3_0.style.position = 'absolute';
        this.$3_0.style.top = '0px';
        this.$3_0.style.left = '0px';
        this.$3_0.style.zIndex = 1002;
        var $v_0 = Sys.Browser.agent === Sys.Browser.InternetExplorer && Math.floor(Sys.Browser.version) === 7;

        if ($v_0) {
            var $v_1 = this.$3_0.offsetWidth;

            if ($v_1 < 142) {
                $v_1 = 142;
            }
            else if ($v_1 > 400) {
                $v_1 = 400;
            }
            this.$3_0.style.width = $v_1 + 'px';
        }
        this.positionMenu();
        this.$3_0.style.visibility = 'visible';
        if (Sys.Browser.agent === Sys.Browser.InternetExplorer) {
            this.$3_0.parentNode.insertBefore(this.get_backFrame(), this.$3_0);
            this.positionBackFrame(this.$3_0);
        }
        this.$L_0.rel = '_spPopoutMenuIsOpen';
        this._menuLaunched = true;
    },
    closeMenu: function SP_UI_PopoutMenu$closeMenu() {
        if (!this._menuLaunched) {
            return;
        }
        this.$3_0.style.display = 'none';
        if (Sys.Browser.agent === Sys.Browser.InternetExplorer) {
            this.$3_0.parentNode.removeChild(this.get_backFrame());
        }
        SP.UI.PopoutMenu.endModal();
        SP.UI.PopoutMenu.removeCSSClassFromElement(this.$L_0, this.$1t_0);
        if (!SP.ScriptUtility.isNullOrEmptyString(this.$1q_0)) {
            this.$86_0();
        }
        this.$L_0.rel = '';
        this._menuLaunched = false;
        SP.UI.PopoutMenu._activePopoutMenuInstance = null;
    },
    $86_0: function SP_UI_PopoutMenu$$86_0() {
        this.$10_0.src = this.$1q_0;
        if (this.$5h_0) {
            this.$10_0.style.top = '-' + this.$5j_0 + 'px';
            this.$10_0.style.left = '-' + this.$5i_0 + 'px';
            this.$1C_0.style.height = this.$5g_0 + 'px';
            this.$1C_0.style.width = this.$5k_0 + 'px';
        }
    },
    positionBackFrame: function SP_UI_PopoutMenu$positionBackFrame(elem) {
        var $v_0 = !SP.ScriptUtility.isNullOrUndefined(elem.offsetParent);
        var $v_1 = AbsTop(elem) - ($v_0 ? AbsTop(elem.offsetParent) : 0);
        var $v_2 = AbsLeft(elem) - ($v_0 ? AbsLeft(elem.offsetParent) : 0);
        var $v_3 = elem.offsetWidth;
        var $v_4 = elem.offsetHeight;

        (this.get_backFrame()).style.top = $v_1 + 6 + 'px';
        (this.get_backFrame()).style.left = $v_2 + 'px';
        (this.get_backFrame()).style.width = $v_3 + 'px';
        (this.get_backFrame()).style.height = $v_4 + 'px';
    },
    positionMenu: function SP_UI_PopoutMenu$positionMenu() {
        var $v_0 = this.$3_0.offsetWidth;
        var $v_1 = this.$3_0.offsetHeight;
        var $v_2 = !SP.ScriptUtility.isNullOrUndefined(this.$3_0.offsetParent);
        var $v_3 = this.$L_0.offsetWidth;
        var $v_4 = this.$L_0.offsetHeight;
        var $v_5 = AbsTop(this.$L_0) - ($v_2 ? AbsTop(this.$3_0.offsetParent) : 0);
        var $v_6 = AbsLeft(this.$L_0) - ($v_2 ? AbsLeft(this.$3_0.offsetParent) : 0);
        var $v_7 = SP.UI.PopoutMenu.getViewPortWidth();
        var $v_8 = SP.UI.PopoutMenu.getViewPortHeight();
        var $v_9 = SP.UI.PopoutMenu.getViewableTop();
        var $v_A = SP.UI.PopoutMenu.getViewableLeft();

        if (this.get_defaultLaunchRight()) {
            if (this.$78_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A)) {
                return;
            }
            if (this.$7N_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A)) {
                return;
            }
            if (this.$77_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A)) {
                return;
            }
            if (this.$7M_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A)) {
                return;
            }
            this.$78_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A);
        }
        else {
            if (this.$77_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A)) {
                return;
            }
            if (this.$7M_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A)) {
                return;
            }
            if (this.$78_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A)) {
                return;
            }
            if (this.$7N_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A)) {
                return;
            }
            this.$77_0($v_0, $v_1, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_A);
        }
    },
    positionMenuWithCoordinates: function SP_UI_PopoutMenu$positionMenuWithCoordinates(left, top) {
        this.$3_0.style.top = top + 6 + 'px';
        this.$3_0.style.left = left + 'px';
    },
    $7M_0: function SP_UI_PopoutMenu$$7M_0($p0, $p1, $p2, $p3, $p4, $p5, $p6, $p7, $p8, $p9) {
        var $v_0 = $p5 + $p2 - $p0;

        if ($v_0 < $p9) {
            return false;
        }
        var $v_1 = $p4 - $p1;

        if ($v_1 < $p8) {
            return false;
        }
        this.positionMenuWithCoordinates($v_0, $v_1);
        return true;
    },
    $77_0: function SP_UI_PopoutMenu$$77_0($p0, $p1, $p2, $p3, $p4, $p5, $p6, $p7, $p8, $p9) {
        var $v_0 = $p5 + $p2 - $p0;

        if ($v_0 < $p9) {
            return false;
        }
        var $v_1 = $p4 + $p3 + $p1;
        var $v_2 = $p8 + $p7;

        if ($v_1 > $v_2) {
            return false;
        }
        this.positionMenuWithCoordinates($v_0, $p4 + $p3);
        return true;
    },
    $7N_0: function SP_UI_PopoutMenu$$7N_0($p0, $p1, $p2, $p3, $p4, $p5, $p6, $p7, $p8, $p9) {
        var $v_0 = $p5 + $p0;
        var $v_1 = $p9 + $p6;

        if ($v_0 > $v_1) {
            return false;
        }
        var $v_2 = $p4 - $p1;

        if ($v_2 < $p8) {
            return false;
        }
        this.positionMenuWithCoordinates($p5, $v_2);
        return true;
    },
    $78_0: function SP_UI_PopoutMenu$$78_0($p0, $p1, $p2, $p3, $p4, $p5, $p6, $p7, $p8, $p9) {
        var $v_0 = $p5 + $p0;
        var $v_1 = $p9 + $p6;

        if ($v_0 > $v_1) {
            return false;
        }
        var $v_2 = $p4 + $p3 + $p1;
        var $v_3 = $p8 + $p7;

        if ($v_2 > $v_3) {
            return false;
        }
        this.positionMenuWithCoordinates($p5, $p4 + $p3);
        return true;
    },
    onMenuMouseOver: function SP_UI_PopoutMenu$onMenuMouseOver(evt) {
        window.clearTimeout(this.$1r_0);
    },
    onMenuMouseOut: function SP_UI_PopoutMenu$onMenuMouseOut(evt) {
        window.clearTimeout(this.$1r_0);
        this.$1r_0 = window.setTimeout(this.$$d_closeMenu, 1500);
    },
    _menuLaunched: false,
    get_menuLaunched: function SP_UI_PopoutMenu$get_menuLaunched() {
        return this._menuLaunched;
    },
    set_menuLaunched: function SP_UI_PopoutMenu$set_menuLaunched(value) {
        this._menuLaunched = value;
        return value;
    },
    _backFrame: null,
    get_backFrame: function SP_UI_PopoutMenu$get_backFrame() {
        if (!this._backFrame) {
            this._backFrame = document.createElement('iframe');
            this._backFrame.style.zIndex = 1001;
            this._backFrame.style.position = 'absolute';
            this._backFrame.style.visibility = 'hidden';
        }
        return this._backFrame;
    },
    get_defaultLaunchRight: function SP_UI_PopoutMenu$get_defaultLaunchRight() {
        return this.$5m_0 === 'ltr';
    },
    dispose: function SP_UI_PopoutMenu$dispose() {
        $removeHandler(this.$3_0, 'mouseout', this.$1v_0);
        $removeHandler(this.$3_0, 'mouseover', this.$1w_0);
        $removeHandler(this.$3_0, 'click', this.$1u_0);
    }
};
SP.UI.AttractModeControl = function SP_UI_AttractModeControl() {
    SP.UI.AttractModeControl.initializeBase(this, [document.createElement('div')]);
    (this.get_element()).className = SP.UI.AttractModeControl.cssAttractModeBackground;
    this.$83_2();
};
SP.UI.AttractModeControl.$7Y = function SP_UI_AttractModeControl$$7Y() {
    var $v_0 = document.createElement('div');

    $v_0.className = SP.UI.AttractModeControl.cssAttractModeWrapper;
    return $v_0;
};
SP.UI.AttractModeControl.prototype = {
    $1s_2: null,
    $1D_2: null,
    get_imageElement: function SP_UI_AttractModeControl$get_imageElement() {
        return this.$1s_2;
    },
    get_textElement: function SP_UI_AttractModeControl$get_textElement() {
        return this.$1D_2;
    },
    $83_2: function SP_UI_AttractModeControl$$83_2() {
        var $v_0 = SP.UI.AttractModeControl.$7Y();
        var $v_1 = document.createElement('div');

        $v_1.className = SP.UI.AttractModeControl.cssAttractModeCell;
        this.$1s_2 = this.$7X_2();
        $v_1.appendChild(this.$1s_2);
        $v_0.appendChild($v_1);
        var $v_2 = this.$7Z_2();

        Sys.UI.DomElement.addCssClass($v_2, SP.UI.AttractModeControl.cssAttractModeCell);
        Sys.UI.DomElement.addCssClass($v_2, SP.UI.AttractModeControl.cssAttractMode);
        this.$1D_2 = document.createElement('div');
        this.$1D_2.className = SP.UI.AttractModeControl.cssAttractModeText;
        $v_2.appendChild(this.$1D_2);
        $v_0.appendChild($v_2);
        (this.get_element()).appendChild($v_0);
    },
    $7X_2: function SP_UI_AttractModeControl$$7X_2() {
        var $v_0 = document.createElement('img');

        $v_0.src = SP.Utilities.Utility.getImageUrl(SP.UI.AttractModeControl.defaultAttractModeIcon);
        $v_0.className = SP.UI.AttractModeControl.cssAttractModeIcon;
        return $v_0;
    },
    $7Z_2: function SP_UI_AttractModeControl$$7Z_2() {
        var $v_0 = document.createElement('span');

        Sys.UI.DomElement.addCssClass($v_0, SP.UI.AttractModeControl.cssAttractMode);
        return $v_0;
    }
};
SP.UI.Status = function SP_UI_Status() {
};
SP.UI.Status.addStatus = function SP_UI_Status$addStatus(strTitle, strHtml, atBegining) {
    return addStatus(strTitle, strHtml, atBegining);
};
SP.UI.Status.appendStatus = function SP_UI_Status$appendStatus(sid, strTitle, strHtml) {
    return appendStatus(sid, strTitle, strHtml);
};
SP.UI.Status.updateStatus = function SP_UI_Status$updateStatus(sid, strHtml) {
    updateStatus(sid, strHtml);
};
SP.UI.Status.setStatusPriColor = function SP_UI_Status$setStatusPriColor(sid, strColor) {
    setStatusPriColor(sid, strColor);
};
SP.UI.Status.removeStatus = function SP_UI_Status$removeStatus(sid) {
    removeStatus(sid);
};
SP.UI.Status.removeAllStatus = function SP_UI_Status$removeAllStatus(hide) {
    removeAllStatus(hide);
};
SP.UI.Menu = function SP_UI_Menu($p0) {
    this.$U_0 = $p0;
};
SP.UI.Menu.create = function SP_UI_Menu$create(id) {
    var $v_0 = CMenu(id);

    return new SP.UI.Menu($v_0);
};
SP.UI.Menu.prototype = {
    $U_0: null,
    addMenuItem: function SP_UI_Menu$addMenuItem(text, actionScriptText, imageSourceUrl, imageAlternateText, sequenceNumber, description, id) {
        var $v_0 = CAMOpt(this.$U_0, text, actionScriptText, imageSourceUrl, imageAlternateText, sequenceNumber, description);

        if (id) {
            $v_0.id = id;
        }
        return $v_0;
    },
    addSeparator: function SP_UI_Menu$addSeparator() {
        CAMSep(this.$U_0);
    },
    addSubMenu: function SP_UI_Menu$addSubMenu(text, imageSourceUrl, imageAlternateText, sequenceNumber, description, id) {
        var $v_0 = CASubM(this.$U_0, text, imageSourceUrl, imageAlternateText, sequenceNumber, description);

        if (id) {
            $v_0.id = id;
        }
        return new SP.UI.Menu($v_0);
    },
    show: function SP_UI_Menu$show(relativeElement, forceRefresh, flipTopLevelMenu, yOffset) {
        OMenu(this.$U_0, relativeElement, forceRefresh, flipTopLevelMenu, yOffset);
    },
    showFilterMenu: function SP_UI_Menu$showFilterMenu(relativeElement, forceRefresh, flipTopLevelMenu, yOffset, fShowClose, fShowCheckBoxes) {
        OMenu(this.$U_0, relativeElement, forceRefresh, flipTopLevelMenu, yOffset, fShowClose, fShowCheckBoxes);
    },
    hideIcons: function SP_UI_Menu$hideIcons() {
        this.$U_0.setAttribute('hideicons', 'true');
    },
    showIcons: function SP_UI_Menu$showIcons() {
        this.$U_0.setAttribute('hideicons', 'false');
    }
};
SP.UI.MenuTest = function SP_UI_MenuTest() {
};
SP.UI.MenuTest.setup = function SP_UI_MenuTest$setup(relativeElement) {
    SP.UI.MenuTest.$1A = relativeElement;
    relativeElement.attachEvent('onclick', SP.UI.MenuTest.$7o);
};
SP.UI.MenuTest.$7o = function SP_UI_MenuTest$$7o() {
    var $v_0 = SP.UI.MenuTest.$1A._menu;

    if (!$v_0) {
        $v_0 = SP.UI.Menu.create(SP.UI.MenuTest.$1A.id + '_menu');
        SP.UI.MenuTest.$1A._menu = $v_0;
        $v_0.addMenuItem('Option 1', null, null, null, 0, null, null);
        $v_0.addSeparator();
        $v_0.addMenuItem('Option 2', 'window.location=\'http://www.microsoft.com\';', null, null, 0, null, null);
    }
    $v_0.show(SP.UI.MenuTest.$1A, false, false, -1);
};
Type.registerNamespace('SP.Utilities');
SP.Utilities.DateTimeFormat = function() {
};
SP.Utilities.DateTimeFormat.prototype = {
    dateTime: 0,
    dateOnly: 1,
    timeOnly: 2,
    isO8601: 3,
    monthDayOnly: 4,
    monthYearOnly: 5,
    longDate: 6,
    unknownFormat: 7
};
SP.Utilities.DateTimeFormat.registerEnum('SP.Utilities.DateTimeFormat', false);
SP.Utilities.IconSize = function() {
};
SP.Utilities.IconSize.prototype = {
    size16: 0,
    size32: 1,
    size256: 2
};
SP.Utilities.IconSize.registerEnum('SP.Utilities.IconSize', false);
SP.Utilities.LogAppErrorResult = function() {
};
SP.Utilities.LogAppErrorResult.prototype = {
    success: 0,
    errorsThrottled: -1,
    accessDenied: -2
};
SP.Utilities.LogAppErrorResult.registerEnum('SP.Utilities.LogAppErrorResult', false);
SP.Utilities.PrincipalSource = function() {
};
SP.Utilities.PrincipalSource.prototype = {
    none: 0,
    userInfoList: 1,
    windows: 2,
    membershipProvider: 4,
    roleProvider: 8,
    all: 15
};
SP.Utilities.PrincipalSource.registerEnum('SP.Utilities.PrincipalSource', false);
SP.Utilities.PrincipalType = function() {
};
SP.Utilities.PrincipalType.prototype = {
    none: 0,
    user: 1,
    distributionList: 2,
    securityGroup: 4,
    sharePointGroup: 8,
    all: 15
};
SP.Utilities.PrincipalType.registerEnum('SP.Utilities.PrincipalType', false);
SP.Utilities.SPWOPIFrameAction = function() {
};
SP.Utilities.SPWOPIFrameAction.prototype = {
    view: 0,
    edit: 1,
    mobileView: 2,
    interactivePreview: 3,
    syndicate: 4,
    legacyWebService: 5
};
SP.Utilities.SPWOPIFrameAction.registerEnum('SP.Utilities.SPWOPIFrameAction', false);
SP.Utilities.Utility = function SP_Utilities_Utility() {
};
SP.Utilities.Utility.get_layoutsLatestVersionRelativeUrl = function SP_Utilities_Utility$get_layoutsLatestVersionRelativeUrl() {
    return '_layouts/15/';
};
SP.Utilities.Utility.get_layoutsLatestVersionUrl = function SP_Utilities_Utility$get_layoutsLatestVersionUrl() {
    return '/_layouts/15/';
};
SP.Utilities.Utility.getLayoutsPageUrl = function SP_Utilities_Utility$getLayoutsPageUrl(pageName) {
    return SP.Utilities.UrlBuilder.urlCombine(SP.PageContextInfo.get_webServerRelativeUrl(), '_layouts/15/' + pageName);
};
SP.Utilities.Utility.getImageUrl = function SP_Utilities_Utility$getImageUrl(imageName) {
    return '/_layouts/15/images/' + imageName;
};
SP.Utilities.Utility.createWikiPageInContextWeb = function SP_Utilities_Utility$createWikiPageInContextWeb(context, parameters) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.File(context, new SP.ObjectPathStaticMethod(context, '{16f43e7e-bf35-475d-b677-9dc61e549339}', 'CreateWikiPageInContextWeb', [parameters]));
    return $v_0;
};
SP.Utilities.Utility.localizeWebPartGallery = function SP_Utilities_Utility$localizeWebPartGallery(context, items) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;

    $v_0 = new SP.ClientObjectList(context, new SP.ObjectPathStaticMethod(context, '{16f43e7e-bf35-475d-b677-9dc61e549339}', 'LocalizeWebPartGallery', [items]), SP.ListItem);
    return $v_0;
};
SP.Utilities.Utility.getAppLicenseInformation = function SP_Utilities_Utility$getAppLicenseInformation(context, productId) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0;
    var $v_1 = new SP.ClientActionInvokeStaticMethod(context, '{16f43e7e-bf35-475d-b677-9dc61e549339}', 'GetAppLicenseInformation', [productId]);

    context.addQuery($v_1);
    $v_0 = new SP.AppLicenseCollection();
    context.addQueryIdAndResultObject($v_1.get_id(), $v_0);
    return $v_0;
};
SP.Utilities.Utility.importAppLicense = function SP_Utilities_Utility$importAppLicense(context, licenseTokenToImport, contentMarket, billingMarket, appName, iconUrl, providerName, appSubtype) {
    if (!context) {
        throw Error.argumentNull('context');
    }
    var $v_0 = new SP.ClientActionInvokeStaticMethod(context, '{16f43e7e-bf35-475d-b677-9dc61e549339}', 'ImportAppLicense', [licenseTokenToImport, contentMarket, billingMarket, appName, iconUrl, providerName, appSubtype]);

    context.addQuery($v_0);
};
SP.Utilities.Utility.getAppLicenseDeploymentId = function SP_Utilities_Utility$