/**
 * Imports
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

var _evStore = require('ev-store');

var _evStore2 = _interopRequireDefault(_evStore);

var _composeFunction = require('compose-function');

var _composeFunction2 = _interopRequireDefault(_composeFunction);

var _proxyEvent = require('./proxy-event');

var _proxyEvent2 = _interopRequireDefault(_proxyEvent);

/**
 * Events
 */

var events = ["blur", "change", "click", "contextmenu", "dblclick", "error", "focus", "focusin", "focusout", "input", "keydown", "keypress", "keyup", "load", "mousedown", "mouseup", "resize", "select", "submit", "touchcancel", "touchend", "touchstart", "unload"];

/**
 * Delegator
 */

function delegant(rootNode) {
  var fn = arguments.length <= 1 || arguments[1] === undefined ? function (v) {
    return v;
  } : arguments[1];

  return _composeFunction2['default'].apply(undefined, _toConsumableArray(events.map(bind)));

  function bind(name) {
    var handler = listener(name);
    rootNode.addEventListener(name, handler, true);
    return function () {
      return rootNode.removeEventListener(name, handler, true);
    };
  }

  function listener(name) {
    return function (e) {
      return bubble(name, e.target, e);
    };
  }

  function bubble(name, target, e) {
    var es = (0, _evStore2['default'])(target);
    var handler = es[name];

    if (handler) {
      var _event = new _proxyEvent2['default'](e);
      _event.currentTarget = target;
      fn(handler(_event));
      if (_event._stopPropagation || _event._stopImmediatePropagation) {
        return;
      }
    }

    if (target.parentNode && target.parentNode !== rootNode) {
      bubble(name, target.parentNode, e);
    }
  }
}

/**
 * Exports
 */

exports['default'] = delegant;
module.exports = exports['default'];